#include <stdio.h>
#include "qxt.h"

FILE *netin, *netout;
int processing_time;
int use_timer;

extern char *getenv ();

init_qio ()
{
  char *t_env;

  netin  = fdopen (NETIN,  "r");
  if (netin == NULL)
    fatal ("Init QIF: netin", 0);
  netout = fdopen (NETOUT, "w");
  if (netin == NULL)
    fatal ("Init QIF: netout", 0);
  if ((t_env = getenv ("QXTTIMER")) && strcmp (t_env, "ON") == 0)
    use_timer = 1;
  else
    use_timer = 0;
}

check_result (error_msg)
     char *error_msg;
{
  char *result;

  result = readline_stream (netin);
  if (result == NULL || result[0] == '-')
    fatal (error_msg, ABORT);
  free (result);
}

check_execution_end ()
{
  char *result;

  result = readline_stream (netin);
  if (result == NULL || result[0] == '-')
    fatal ("QIF protocol: command execution failed", ABORT);
  if (use_timer)
    {
      sscanf (result, "+OK Time %d ms", &processing_time);
      fprintf (stdout, "Processing Time %d ms\n", processing_time);
    }
  free (result);
}

send_command (line)
     char *line;
{
/*  int term_len = strlen (line) + 1; */

  if (use_timer)
    fprintf (netout, "CMD T\n");
  else
    fprintf (netout, "CMD\n");
  fflush (netout);
  check_result ("QIF protocol: CMD failed\n");
  fputs (line, netout);
  fputs ("\n", netout);
  fflush (netout);
  check_result ("command failed\n");
}
