/****************************************************************
 *     REWRITED IS THE SERVER PROGRAM OF RWRITE.   <pm_server.c>
 *                                      '93.12.10  panch_in by R.K
 ****************************************************************/

/*** includes ***/
#include  <stdio.h>
#include  <string.h>
#include  <sys/types.h>
#include  <sys/socket.h>
#include  <sys/stat.h>
#include  <sys/errno.h>
#include  <netinet/in.h>
#include  <netdb.h>

#include  "oprprot.h"
#include  "pmdata.h"

extern errno;

/*** prototypes ***/
void  pm();
void  *calloc();
void  *realloc();
void  free();

/***** << programs >> *******************************************/
main(argc,argv)

  int   argc ;
  char  *argv[] ;
{

  int     ret, fromlen ;
  int     s, sn ;
  int     cc,i ;
  char    hdir[128];
  FILE    *fp;

  struct  sockaddr_in     sin, from ;
  struct  servent         *sp ;

  s = socket(AF_INET,SOCK_STREAM,0);
  if( s < 0 ){
    fprintf(stderr,"pm_server: socket\n");
    exit(1);
  }
  sin.sin_family = AF_INET;
  sin.sin_port = 6789 ;
  sin.sin_addr.s_addr = INADDR_ANY;
  
  /*** move current directory($HOME/quixote_pm) ***/
  opr_cmnd("env > temp");
  fp = fopen("temp","r");
  while(1){
    if( (fgets(hdir,sizeof(hdir),fp)) == NULL ){
      fclose(fp);
      opr_cmnd("rm temp");
      break;
    }
    if( !strncmp(hdir,"HOME",4) ){
      hdir[strlen(hdir)-1] = NULL;
      strcpy(home_dir,(hdir+5));
      sprintf(cur_dir,"%s/quixote_pm",home_dir);
      fclose(fp);
      opr_cmnd("rm temp");
      break;
    }
  }
  opr_cd(home_dir);
  
  /*** change current dir ***/
  if( (ret = opr_cd("quixote_pm")) < 0 ){
    opr_cmnd("mkdir quixote_pm");
    opr_cd("quixote_pm");
  }

  /*** open translate log file ***/
  fp = fopen("pm_log","w");
  fclose(fp);

  /*** memory allocation ***/
  if( (rd_data = calloc(1,BUF_MAX)) == NULL ){
    printf("pm_server: memory allocation(used RX data)\n");
    exit(1);
  }
  alloc_cnt_rd++;
  if( (wr_data = calloc(1,BUF_MAX)) == NULL ){
    printf("pm_server: memory allocation(used TX data)\n");
    exit(1);
  }
  alloc_cnt_wr++;
  if( (prm_buf = calloc(1,BUF_MAX)) == NULL ){
    printf("pm_server: memory allocation(used RX prm)\n");
    exit(1);
  }
  alloc_cnt_prm++;

  /*** bind proccess ***/
  while( bind(s,(caddr_t)&sin,sizeof(sin)) < 0 ){
    fprintf(stderr,"pm_server: bind(%d,%d,%d,%d,%d,%d)\n",
	    errno,EBADF,ENOTSOCK,EADDRINUSE,EINVAL,EFAULT);
    sleep(5);
  }
  if( listen(s,5) < 0 ){
    fprintf(stderr,"pm_server: listen\n");
    exit(1);
  }

  for(;;){
    fromlen = sizeof(from);
    sn = accept(s,&from,&fromlen);
    if( sn < 0 ){
      fprintf(stderr,"pm_server: accept\n");
      sleep(5);
      continue;
    }
    if( fork() == 0 ){
      close(s);
      pm(sn,rd_data);
      exit(0);
    }
  }
}
/***** END OF <PM_SERVER.C> *******************************************/
