/************************************************************
 *      DIRECTORY OPRATION MODULE        <DIROPR.C>
 *                                           '93.12.7 by R.K
 ************************************************************/
#include  <stdio.h>
#include  <string.h>
#include  <sys/types.h>

#include  "oprprot.h"

/**************************************************************
 *     CHANGE DIRECTORY 
 *-------------------------------------------------------------
 *  <calling sequence>
 *          ret = opr_cd(*pathname)
 *
 *  <input>
 *          char  *pathname : pointer of path name string
 *
 *  <output>
 *          int    ret    : return status
 *                                0 = normal end status
 *                               -1 = abnormal end status
 *-------------------------------------------------------------
 *  <description>
 *         this function change directory for argument.
 *         when saccess ,return normal end status(0), 
 *         else return abnormal end status(-1).
 **************************************************************/
int opr_cd(pathname)

     char  *pathname ;
{
  return( chdir(pathname) );
}
/**************************************************************
 *     EXECUTE UNIX COMMAND
 *-------------------------------------------------------------
 *  <calling sequence>
 *          ret = opr_cmnd(*command)
 *
 *  <input>
 *          char  *command : pointer of command name string
 *
 *  <output>
 *          int    ret    : return status
 *                                0 = normal end status
 *                               -1 = abnormal end status
 *-------------------------------------------------------------
 *  <description>
 *         this function execute unix command.
 *         when saccess ,return normal end status(0), 
 *         else return abnormal end status(-1).
 **************************************************************/
int  opr_cmnd(command)

     char  *command;
{
  int  ret;

  ret = system(command);
  if(ret != STS_NORM)
    ret = STS_ABNORM;
  return  ret;
}
/***** <<< opr_cmnd() END >>> *****/

/***** <<< END OF DIROPR.C >>> **********************************/
