#include  <stdio.h>
#include  <string.h>

#include  "pmdata.h"
#include  "pmfunc.h"
#include  "pmtool.h"
#include  "oprprot.h"

/*** sub routin prototypes ***/
void  update_cntrl();

/**********************************************************
 *     FUNCTION MODULE
 *                                        '93.1.12 by R.K
 *---------------------------------------------------------
 * module name : rm_all_c()
 *
 * input :
 *
 *output :
 *
 **********************************************************/
void rm_all_c(sn,buf)

     int  sn ;
     char *buf;
{

  char *wp, wbuf[80], wbuf2[20] ;
  char *dir, *DB_name, *VerNO, DB_name2[80], VerNO2[20] ;
  int ret ;
  FILE *fp ;

  /*** parameter set *************************************/
  if( (ret = pm_sep_prm(buf+1,prm_buf)) != 3 ){
    strcpy(wr_data,"result_rm_all(abnormal(\"invalid prm\"),done)\n");
    write(sn,wr_data,strlen(wr_data));
    return;
  }
  dir = prm_buf;                           /* get dir */
  DB_name = (dir+strlen(dir)+1);           /* get DB_name */
  VerNO = (DB_name+strlen(DB_name)+1);     /* get VerNO */
  
  /*** execute *******************************************/
  /*** change directory ***/
  pm_mkdir_name(dir,wbuf);
  if( (ret = opr_cd(wbuf)) == -1 ){
    strcpy(wr_data,"result_rm_all(abnormal(\"dir not found\"),done)\n");
    write(sn,wr_data,strlen(wr_data));
    return;
  }

  /*** read ".cntrl" file ***/
  sprintf(wbuf,"%s.cntrl",DB_name);
  if( (fp = fopen(wbuf,"r")) == NULL ){
    strcpy(wr_data,"result_rm_all(abnormal(\"DB not found\"),done)\n");
    write(sn,wr_data,strlen(wr_data));
    opr_cd(cur_dir);
    return;
  }
  fclose(fp);

  /*** check VerNO ***/
  sprintf(wbuf,"rm %s.",DB_name);
  if( !strcmp(VerNO,"\'&void\'") ) {   /* delete all DBname file */
    strcpy(wbuf+strlen(wbuf),"*");
    opr_cmnd(wbuf);
  }
  else{                                /* delete version & update cntrl */
    sprintf(wbuf+strlen(wbuf),"%s.*",VerNO);
    opr_cmnd(wbuf);

    /*** update ".cntrl" file ***/
    update_cntrl(DB_name,VerNO);
  }

  /*** response ***/
  strcpy(wr_data,"result_rm_all(normal,done)\n");
  write(sn,wr_data,strlen(wr_data));
  
  /*** change directory ***/
  opr_cd(cur_dir);
}
/*** <<< rm_all_c() END >>> ***/

/*************************************************************
 *   SUB ROUTIN 
 ************************************************************/
void  update_cntrl(dbname,vernum)

     char  *dbname, *vernum ;
{

  char  name[256], buf[256], fstr[40], cntrl[20], *wp, *wp2 ;
  int   num, vnum_s ;
  FILE  *fp, *tempfp ;

  /*** get DB_name ***/
  strcpy(name,dbname);
  strcpy(cntrl,dbname);
  strcpy(cntrl+strlen(cntrl),".cntrl");

  /*** get VerNO ***/
  vnum_s = atoi(vernum);

  /*** read ".cntrl" file ***/
  fp = fopen(cntrl,"r");
  fgets(buf,sizeof(buf),fp);
  fscanf(fp,"%d",&num);
  fclose(fp);

  /*** check version ***/
  if( vnum_s != num )
    return;
  if( (vnum_s == num) && (num > 1) ){
    opr_cmnd("ls > rmall_temp");                  /*** make ls list file ***/

    /*** make cmp string ***/
    strcpy(buf,name);
    wp = (buf+strlen(buf));
    while(1){
      if( num == 0 )
	break;
      sprintf(wp,".%d",num);
      tempfp = fopen("rmall_temp","r");

      /* search DB version */
      for( ; (wp2 = fgets(fstr,sizeof(fstr),tempfp)) != NULL; ){
	if( !strncmp(fstr,buf,strlen(buf)) ){
	  sprintf(name+strlen(name),"\n");
	  sprintf(name+strlen(name),"%d\n",num);
	  fp = fopen(cntrl,"w");
	  opr_write(fp,name,strlen(name));
	  fclose(fp);
	  fclose(tempfp);
	  opr_cmnd("rm rmall_temp");
	  return;
	}
      }
      num--;
      fclose(tempfp);
    }

    /*** delete ".cntrl" file & temp file ***/
    sprintf(buf,"rm %s",cntrl);
    opr_cmnd(buf);
    fclose(tempfp);
    opr_cmnd("rm rmall_temp");
    return;
  }

  /* case of < origin version > */
  else if( num == 1 ){
    sprintf(buf,"rm %s",cntrl);
    opr_cmnd(buf);
    fclose(tempfp);
    opr_cmnd("rm rmall_temp");
    return;
  }
}
/*** <<< update_cntrl END >>> ***/

/***** <<< END OF c_rmall.c >>> *****/
