%{
int (*yyinputfunc) ();
#undef YY_INPUT
#define YY_INPUT(buf,result,max_size) \
    { \
	result = yyinputfunc (buf,max_size); \
    }

int yylineno = 1;

#ifdef DEBUG
#define token(tk) printf("%-12s is \"%s\" (lval=%d)\n","tk",yytext,yylval)
#else
#define token(tk) return(tk)
#endif
%}

%e 1600
%p 5000
%n 800
%k 200
%a 2400
%o 2200

kanji		[\241-\376][\241-\376]
upper-char	[A-Z]
number		[0-9]
lower-char	[a-z]
char		({lower-char}|{number}|{upper-char}|_)
/* lower-char	([_a-z0-9&] | {kanji}) */
/* char		{upper-char} | {lower-char} */
/* print-char	{char} | [- !#$%'()*+,./:;<=>?@`\[\\\]^{|}~] */
/* print-char	[A-Z] | [_a-z0-9&] | [- !#$%'()*+,./:;<=>?@`\[\\\]^\{\|\}~] */

%%
"&void"         {
		token(TOK_Void);
		}
"'&void'"       {
		token(TOK_Void);
		}
"program"       {
		token(TOK_Pgm);
		}
"query"		{
		token(TOK_Qry);
		}
"env_def"       {
		token(TOK_Env);
		}
"def_lib"       {
		token(TOK_DefLib);
		}
"&exp_lib"      {
		token(TOK_ExpLib);
		}
"'&exp_lib'"    {
		token(TOK_ExpLib);
		}
"&pgm_lib"      {
		token(TOK_PgmLib);
		}
"'&pgm_lib'"    {
		token(TOK_PgmLib);
		}
"&sort_lib"     {
		token(TOK_SrtLib);
		}
"'&sort_lib'"   {
		token(TOK_SrtLib);
		}
"exp_def"       {
		token(TOK_Exp);
		}
"exp"           {
		token(TOK_Exp);
		}
"exp_name"      {
		token(TOK_ExpNam);
		}
"obj_def"       {
		token(TOK_Obj);
		}
"obj_sub"       {
		token(TOK_ObjSub);
		}
"mod_def"       {
		token(TOK_Mod);
		}
"m_sub"         {
		token(TOK_MSub);
		}
"m_id"          {
		token(TOK_MId);
		}
"m_desc"        {
		token(TOK_MDsc);
		}
"link_def"      {
		token(TOK_Link);
		}
"link"          {
		token(TOK_Lnk);
		}
"rule_def"      {
		token(TOK_Rule);
		}
"rule"          {
		token(TOK_Rul);
		}
"normal"	{
		token(TOK_Nrm);
		}
"rel"		{
		token(TOK_Rel);
		}
"update"	{
		token(TOK_Upd);
		}
"transaction"	{
		token(TOK_Trn);
		}
"consis"	{  
		token(TOK_Con);
		}
"inconsis"	{  
		token(TOK_InCon);
		}
"prop"          {  
		token(TOK_Prp);
		}
"cnstrs"        {  
		token(TOK_Cns);
		}
"cnstr"         {  
		token(TOK_Cns);
		}
"a_term"        {  
		token(TOK_ATrm);
		}
"c_o_term"      {  
		token(TOK_COTrm);
		}
"prolog"        {  
		token(TOK_Prl);
		}
"dot"           {  
		token(TOK_Dot);
		}
"list"          {  
		token(TOK_Lst);
		}
"sublist"       {  
		token(TOK_SubLst);
		}
"nill"          {  
		token(TOK_Nil);
		}
"string"        {  
		token(TOK_Str);
		}
"integer"       {  
		token(TOK_Int);
		}
"attr"		{  
		token(TOK_Atr);
		}
"var"		{  
		token(TOK_Var);
		}
"ind"		{  
		token(TOK_Ind);
		}
"set"		{  
		token(TOK_Set);
		}
"curl_ind"	{  
		token(TOK_CrlInd);
		}
"curl_set"	{  
		token(TOK_CrlSet);
		}
"query_cnstr"	{  
		token(TOK_QryCns);
		}
"proc"		{
		token(TOK_Prc);
		}
"ans"		{
		token(TOK_Ans);
		}
"inherit"	{
		token(TOK_Inh);
		}
"merge"		{
		token(TOK_Mrg);
		}
"explanation"	{
		token(TOK_Xpl);
		}
"sort"		{
		token(TOK_Srt);
		}
"answer"	{
		token(TOK_Ans);
		}
"answer_element" {
		token(TOK_AnsElm);
		}
"dot_cnstr"	{
		token(TOK_DotCns);
		}
"var_cnstr"	{
		token(TOK_VarCns);
		}
"lookup"	{
		token(TOK_Lkp);
		}
"unit"		{
		token(TOK_Unt);
		}
"up"		{
		token(TOK_Up);
		}
"down"		{
		token(TOK_Dwn);
		}
"reduce"	{
		token(TOK_Rdc);
		}
"subgoal"	{
		token(TOK_Sbg);
		}
"con"		{
		token(TOK_Con);
		}
"assump"	{
		token(TOK_Asm);
		}
"ruleID"	{
		token(TOK_Rid);
		}

"&no_update"    {
		token(TOK_NoUpd);
		}
"'&no_update'"  {
		token(TOK_NoUpd);
		}
"&update"       {
		token(TOK_Upd);
		}
"'&update'"     {
		token(TOK_Upd);
		}
"&ol"           {  
		token(TOK_OL);
		}
"&lo"           {  
		token(TOK_LO);
		}
"&l"            {  
		token(TOK_L);
		}
"&o"            {  
		token(TOK_O);
		}
"'&ol'"         {  
		token(TOK_OL);
		}
"'&lo'"         {  
		token(TOK_LO);
		}
"'&l'"          {  
		token(TOK_L);
		}
"'&o'"          {  
		token(TOK_O);
		}
"&no_assume"	{  
		token(TOK_NoAsm);
		}
"'&no_assume'"	{  
		token(TOK_NoAsm);
		}
"&bt"           {  
		token(TOK_BT);
		}
"&et"           {  
		token(TOK_ET);
		}
"&at"           {  
		token(TOK_AT);
		}
"'&bt'"         {  
		token(TOK_BT);
		}
"'&et'"         {  
		token(TOK_ET);
		}
"'&at'"         {  
		token(TOK_AT);
		}
"&in"		{  
		token(TOK_In);
		}
"&ni"		{  
		token(TOK_Ni);
		}
"'&in'"		{  
		token(TOK_In);
		}
"'&ni'"		{  
		token(TOK_Ni);
		}
"&single"	{
		token(TOK_Single);
		}
"&multi"	{
		token(TOK_Multi);
		}
"&minimal"	{
		token(TOK_Minimal);
		}
"&normal"	{
		token(TOK_Normal);
		}
"&yes"		{
		token(TOK_Yes);
		}
"&no"		{
		token(TOK_No);
		}
"&on"		{
		token(TOK_On);
		}
"&off"		{
		token(TOK_Off);
		}
"&all"		{
		token(TOK_All);
		}
"&down"		{
		token(TOK_Down);
		}
"&up"		{
		token(TOK_Up);
		}
"'&single'"	{
		token(TOK_Single);
		}
"'&multi'"	{
		token(TOK_Multi);
		}
"'&minimal'"	{
		token(TOK_Minimal);
		}
"'&normal'"	{
		token(TOK_Normal);
		}
"'&yes'"	{
		token(TOK_Yes);
		}
"'&no'"		{
		token(TOK_No);
		}
"'&on'"		{
		token(TOK_On);
		}
"'&off'"	{
		token(TOK_Off);
		}
"'&all'"	{
		token(TOK_All);
		}
"'&down'"	{
		token(TOK_Down);
		}
"'&up'"		{
		token(TOK_Up);
		}

{number}+	{
		yylval.name = ans_pool(yytext);
		token(TOK_Integer);
		}
{lower-char}{char}*	{
			yylval.name = ans_pool(yytext);
			/* printf("Atom:%s\n",yylval.name); */
			token(TOK_Atom);
			}
{upper-char}{char}*	{
			yylval.name = ans_pool(yytext);
			/* printf("Atom:%s\n",yylval.name); */
			token(TOK_Variable);
			}
\"[^\"\n]*\"            {
			yylval.name = ans_pool(yytext);
			/* printf("String:%s\n",yylval.name); */
			token(TOK_String);
			}

"="		{
		token(TOK_Equal);
		}
"'='"		{
		token(TOK_Equal);
		}
"+"		{
		token(TOK_Plus);
		}
"-"		{
		token(TOK_Minus);
		}
"'+'"		{
		token(TOK_Plus);
		}
"'-'"		{
		token(TOK_Minus);
		}

"=<"		{
		token(TOK_SetSubsumed);
		}
">="		{
		token(TOK_SetSubsumes);
		}
"=="		{
		token(TOK_SetCong);
		}
"'=<'"		{
		token(TOK_SetSubsumed);
		}
"'>='"		{
		token(TOK_SetSubsumes);
		}
"'=='"		{
		token(TOK_SetCong);
		}
"+<"		{
		token(TOK_SetSubsumedop);
		}
">+"		{
		token(TOK_SetSubsumesop);
		}
"=+="		{
		token(TOK_SetCongop);
		}
"'+<'"		{
		token(TOK_SetSubsumedop);
		}
"'>+'"		{
		token(TOK_SetSubsumesop);
		}
"'=+='"		{
		token(TOK_SetCongop);
		}

"-<"		{
		token(TOK_Subsumed);
		}
">-"		{
		token(TOK_Subsumes);
		}
"'-<'"		{
		token(TOK_Subsumed);
		}
"'>-'"		{
		token(TOK_Subsumes);
		}
"->"		{
		token(TOK_RightArrow);
		}
"<-"		{
		token(TOK_LeftArrow);
		}
"'->'"		{
		token(TOK_RightArrow);
		}
"'<-'"		{
		token(TOK_LeftArrow);
		}
\%.*\n		{
		yylineno++;
		}
\n              {
		yylineno++;
		}
[ \t]         ;
.                 {
		  /* yylval.name = yytext; */
		  token(yytext[0]);
		  }
%%
yyxxfatal (msg)
    char *msg;
{
    fprintf (stderr, "%s\n", msg);
    exit (1);
}

char *yyinput_string;
int yyinput_string_length;

yyinput_from_string (buf, max_size)
	char *buf;
	int max_size;
{
  int result;

  if (yyinput_string_length <= 0)
      return 0;

  if (yyinput_string_length <= max_size)
    {
       result = yyinput_string_length;
       memcpy (buf, yyinput_string, yyinput_string_length);
       yyinput_string += yyinput_string_length;
       yyinput_string_length = 0;

       return result;
    }
  else
    {
       result = max_size;
       memcpy (buf, yyinput_string, max_size);
       yyinput_string += max_size;
       yyinput_string_length -= max_size;
       
       return result;
    }
}

yyinit_input_from_string (string)
	char *string;
{
    yyinput_string = string;
    yyinput_string_length = strlen (string);
    yyinputfunc = yyinput_from_string;
}

yyinput_from_yyin (buf, max_size)
	char *buf;
	int max_size;
{
    int result;

    if ((result = read (fileno(yyin), (char *) buf, max_size)) < 0)
	yyxxfatal ("read() in flex scanner failed");

    return result;
}

yyinit_input_from_yyin ()
{
    yyinputfunc = yyinput_from_yyin;
}
