;;
;; Result analysis and dispatching
;;
(defun qxt-result (string)
  "Quixote server $B$+$i$N7k2L(B STRING $B$N=hM}$r$9$k4X?t!#(B
STRING $B$O(B newline (\\n) $B$G=*$C$F$$$k!#(B

Quixote server $B$+$iJV$C$F$-$?7k2L$N(B string $B$r4X?t(B qxt-term2lisp $B$G(B
lisp $B$N9=B$$KJQ49$7!"BP1~$9$k7k2L=hM}4X?t$r8F$S=P$9!#(B

$B7k2LI=<(%P%C%U%!$r(B pop-up $B$5$;!"$=$l$r%+%l%s%H%P%C%U%!$K$7$F$*$/!"(B
$B7W;~5!G=$,(B on $B$N;~$O(B processing time $B$r7k2LI=<(%P%C%U%!$K=q$-9~$`!#(B"
  (setq string (substring string 0 -1)) ; delete newline
  (let* ((result (qxt-term2lisp string))
	 (result-id (aref result 0))
	 (status (aref result 1))
	 (entry (assq result-id qxt-result-dispatch-table))
	 func
	 kind-of-buffer)
    (if (null entry)
	(error (format "term protocol error(unknown result): %s" result-id))
      (setq func (car (cdr entry)))
      (setq kind-of-buffer (car (cdr (cdr entry))))
      (if qxt-synchronous
	  (save-excursion
	    (qxt-result-analysis))
	(qxt-result-analysis)))))

;; use dynamic binding
(defun qxt-result-analysis ()
  (cond ((eq kind-of-buffer 'result)
	 (pop-to-buffer (qxt-get-result-buffer)))
	((eq kind-of-buffer 'debug)
	 (pop-to-buffer (qxt-get-debug-buffer)))
	(t (error "Unknown mode")))
  (goto-char (point-max))
  (if (eq qxt-time-switch nil)
      ()
    (insert "** Processing time : ")
    (insert (int-to-string qxt-processing-time))
    (insert " msec **\n"))
  (if (qxt-check-status-error status)
      (condition-case err
	  (funcall func result)
	(error
	 (insert
	  (format "** error in the analysis of result:\n%s\n"
		  result)))))
  (cond ((null qxt-input-state)
	 (qxt-insert-prompt qxt-current-session))
	((eq qxt-input-state 'program) ; never occurred
	 (insert "program;;"))
	((or (eq qxt-input-state 'query-begin)
	     (eq qxt-input-state 'query))
	 (insert "?-"))))

(defconst qxt-result-dispatch-table
  '(
    ;; return label              function to be invoked     buffer to be used

    (result_to_message           qxt-result-to-message           result)

    ;; server session
    (result_create_database      qxt-result-create-database      result)
    (result_open_database        qxt-result-open-database        result)
    (result_show_status          qxt-result-show-status          result)
    (result_cd                   qxt-result-status-only          result)
    (result_pwd                  qxt-result-pwd                  result)
    (result_ls                   qxt-result-ls                   result)
    (result_ls_l                 qxt-result-ls-l                 result)
    (result_mkdir                qxt-result-status-only          result)
    (result_rmdir                qxt-result-status-only          result)
    (result_rm                   qxt-result-status-only          result)
    (result_rm_all               qxt-result-status-only          result)
    (result_purge                qxt-result-status-only          result)
    (result_get_text_DB          qxt-result-get-text-DB          result)
    (result_get_DBswitch         qxt-result-get-DBswitch         result)
    (result_set_DBswitch         qxt-result-status-only          result)

    ;; database session
    (result_query                qxt-result-query                result)
    (result_close_database       qxt-result-close-database       result)
    (result_begin_transaction    qxt-result-status-only          result)
    (result_end_transaction      qxt-result-status-only          result)
    (result_abort_transaction    qxt-result-status-only          result)
    (result_show_module          qxt-result-show-module          result)
    (result_show_module_nodes    qxt-result-show-module-nodes    result)
    (result_show_lattice         qxt-result-show-lattice         result)
    (result_show_lattice_nodes   qxt-result-show-lattice-nodes   result)
    (result_compress_set         qxt-result-compress-set         result)
    (result_delete_database      qxt-result-delete-database      result)
    (result_show_rules           qxt-result-show-rules           result)
    (result_show_normalize_rules qxt-result-show-normalize-rules result)
    (result_get_id_rule          qxt-result-get-id-rule          result)
    (result_get_default_mode     qxt-result-get-default-mode     result)
    (result_set_default_mode     qxt-result-status-only          result)
    (result_show_basic_objects   qxt-result-show-basic-objects   result)
    (result_show_objects         qxt-result-show-objects         result)
    (result_change_conv_mode     qxt-result-status-only          result)
    (result_show_dot_labels      qxt-result-show-dot-labels      result)
    ;; database session (trace)
    (result_set_trace_mode       qxt-result-status-only          result)
    (result_get_trace_mode       qxt-result-get-trace-mode       result)
    (result_set_gate             qxt-result-status-only          result)
    (result_set_gate_all         qxt-result-status-only          result)
    (result_get_gate             qxt-result-get-gate             result)
    (result_get_gate_all         qxt-result-get-gate-all         result)
    (result_spy_at_subgoals      qxt-result-status-only          result)
    (result_spy_at_rules         qxt-result-status-only          result)
    (result_spy_at_modules       qxt-result-status-only          result)
    (result_list_spy             qxt-result-list-spy             result)
    (result_unspy_at_subgoals    qxt-result-status-only          result)
    (result_unspy_at_rules       qxt-result-status-only          result)
    (result_unspy_at_modules     qxt-result-status-only          result)
    (result_unspy_at_spypoints   qxt-result-status-only          result)
    (result_enable_all           qxt-result-status-only          result)
    (result_enable_at_spypoints  qxt-result-status-only          result)
    (result_disable_all          qxt-result-status-only          result)
    (result_disable_at_spypoints qxt-result-status-only          result)
    (result_get_all_state        qxt-result-get-all-state        result)
    (result_load_spy             qxt-result-status-only          result)
    (result_reset_trace          qxt-result-status-only          result)

    ;; database session (window)
    (result_show_module_hierarchy  qxt-result-show-module-hierarchy result)

    ;; trace session
    (trace_event                 qxt-trace-event                 debug)
    (result_set_gate_on_trace    qxt-result-status-only          debug)
    (result_gate_all_on_trace    qxt-result-status-only          debug)
    (result_list_spy_on_trace    qxt-result-list-spy             debug)
    (result_quit_trace           qxt-result-quit-trace           debug)
    (result_inspect              qxt-result-inspect              debug)

    ;;inspect session
    (result_inspect_assumption   qxt-result-inspect-assumption   debug)
    (result_inspect_conclusion   qxt-result-inspect-conclusion   debug)
    (result_inspect_variable     qxt-result-inspect-variable     debug)
    (result_quit_inspect         qxt-result-quit-inspect         debug)
    ))


;;
;;    Status = normal | aborted |
;;      abnormal(ErrorInfo) | warning(WarningInfo)
;;	ErrorInfo = {PredicateInfo,[ErrorInfo,...]}
;;		| warning(WarningInfo)
;;		| Term | String 	% seting by detector
;;	WarningInfo = {PredicateInfo,[WarningInfo,...]}
;;		| Term | String		% seting by detector
;;	PredicateInfo = Module_name:PredicateName | PredicateName
;;	ModuleName = Atom
;;      PredicateName = Atom
;;
(defun qxt-check-status-error (status)
  "Quixote server $B$NJV$7$?(B STATUS $B$r%A%'%C%/$9$k4X?t!#(B
$B@.8y$7$?>l9g(B t, $B$=$&$G$J$$>l9g(B nil $B$rJV$9!#(B"
  (cond ((eq status 'normal)
	 t)
	((eq status 'aborted)
	 (insert "** aborted **\n")
	 nil)
	((and (vectorp status) (eq (aref status 0) 'warning))
	 (insert "** warning **\n")
	 (setq standard-output (current-buffer))
	 (qxt-print-term (aref status 1))
	 (newline)
	 t)
	((and (vectorp status) (eq (aref status 0)  'abnormal))
	 (insert "** abnormal **\n")
	 (setq standard-output (current-buffer))
	 (qxt-print-term (aref status 1))
	 (newline)
	 nil)
	(t
	 (insert (format "invalid status: %s" status))
	 nil)))

(defvar qxt-debug-buffer nil
  "Buffer to debug Quixote.")

(defun qxt-get-debug-buffer ()
  "Trace $BMQ$N(B *Quixote Debug* $B$H$$$&(B buffer $B$r(B($B$b$7$J$1$l$P(B)$B?7$?$K@8@.$7(B, 
trace mode $B$K@_Dj$9$k!#$=$7$F$=$N(B buffer $B$rJQ?t(B qxt-debug-buffer $B$KBeF~$9$k!#(B
$BJV$jCM$O$=$N(B buffer.
$BF1;~$K(B, qxt-result-buffer $B$r=q$-9~$_IT2D$K$9$k!#(B
"
  (setq qxt-debug-buffer (get-buffer-create "*Quixote Debug*"))
  (save-excursion
    (set-buffer qxt-debug-buffer)
    (if (eq major-mode 'qxt-debug-mode)
	()
      (qxt-debug-mode)))
  (save-excursion
    (set-buffer qxt-result-buffer)
    (setq buffer-read-only t))
  qxt-debug-buffer)

(defvar qxt-result-buffer nil
  "Buffer which contains the result of Quixote interaction.
Quixote $B$N%3%^%s%I<B9T7k2L$rI=<($9$k(B buffer.")

(defun qxt-get-result-buffer ()
  "$B7k2L$NI=<(MQ$K(B *Quixote* $B$H$$$&(B buffer $B$r(B($B$b$7$J$1$l$P(B)$B?7$?$K@8@.$7!"(B
mode $B$r@_Dj$9$k!#$=$N(B buffer $B$rJQ?t(B qxt-result-buffer $B$KBeF~$9$k!#(B
$BF1;~$K$=$N(B buffer $B$r=q$-9~$_2D$K$9$k!#(B
$BJV$jCM$O$=$N(B buffer."
  (setq qxt-result-buffer (get-buffer-create "*Quixote*"))
  (save-excursion
    (set-buffer qxt-result-buffer)
    (setq buffer-read-only nil)
    (if (eq major-mode 'qxt-interaction-mode)
	()
      (qxt-interaction-mode)))
  qxt-result-buffer)

(defun qxt-result-status-only (result)
  (insert "ok.\n"))

(defun qxt-result-reply ()
  (setq qxt-meta-command t))