;; $B;z6g2r@OIt$N;H$$J}(B
;;
;; (1) Quixote $B%W%m%0%i%`$NJ8;zNs$rJQ?t(B qxt-input-string $B$KBeF~$9$k!#(B
;; (2) Quixote $B%W%m%0%i%`$NJ8;zNs$ND9$5$r(B qxt-input-string-len $B$KBeF~$9$k!#(B
;; (3) $BJQ?t(B qxt-lex-pos $B$K(B 0 $B$rBeF~$9$k!#(B
;; (4) $BJQ?t(B qxt-line-no $B$K(B 1 $B$rBeF~$9$k!#(B
;; (5) $B4X?t(B qxt-lex $B$r8F$VKh$K(B ($B;z6g(B . $BCM(B) $B$N(B cons cell $B$,JV$k!#(B
;; (6) $B:G8e$K(B qxt-lex $B$O(B (0 . nil) $B$N(B cons cell $B$rJV$9!#(B
;;

(put 'lexical 'error-conditions '(error lexical))


(defvar qxt-input-string ""
  "$B;z6g2r@O$NBP>]$H$J$k(B string. $BJ8;zNs!#(B")
(defvar qxt-input-string-len 0
  "qxt-input-string $B$ND9$5!#@0?t!#(B")

(defvar qxt-lex-pos 0
  "qxt-input-string $B$N$I$3$+$i=hM}$9$k$N$+$r<($9JQ?t!#@0?t!#(B
$B$3$NCM$r<!!9$K99?7$9$k$3$H$G(B qxt-input-string $B$N;z6g2r@O$r9T$J$&!#(B")

(defvar qxt-line-no 0
  "$B@0?t!#(B
qxt-input-string $B$NCf$G2?2s(B new line $B$KAx6x$7$?$+$r5-21$7$F$*$/JQ?t!#(B")

(defun unget-next-char (c)
  "$B0lJ8;zFI$^$J$+$C$?$3$H$K$9$k!#(B
C $B$N$=$l$H0c$$!"(B EOF(0) $B$N>l9g$K$b(B unget $B$7$F$h$m$7$$!#(B"
  (if (= c 0)
      ()
  (setq qxt-lex-pos (1- qxt-lex-pos))))

(defun get-next-char ()
  "$BJQ?t(B qxt-input-string $B$NJ8;zNs$NJQ?t(B qxt-lex-pos $B$N0LCV$+$i!"(B
$BJQ?t(B ch $B$K0lJ8;zFI$_!"(Bqxt-lex-pos $B$r99?7$7!"$=$NJ8;z$rJV$9!#(B
$BJ8;zNs$N:G8e$^$GMh$?$i(B EOF (0) $B$rJV$9!#(B"
  (if (>= qxt-lex-pos qxt-input-string-len)
      (setq ch 0)
    (setq ch (aref qxt-input-string qxt-lex-pos))
    (setq qxt-lex-pos (1+ qxt-lex-pos))))

;; (token . value)

(defun qxt-lex ()
  "Quixote $B%W%m%0%i%`$N;z6g2r@O$r9T$J$$!"(B(token . value) $B$N(B cons cell $B$rJV$9!#(B
$B$3$3$G(B token $B$O;z6g$N<oN`$r<($9(B symbol($B$"$k$$$O@0?t(B),
value $B$O;z6g$NCM$G$"$k!#(Bvalue $B$O>o$KMQ$$$i$l$k$H$O8B$i$J$$!#(B

$B;z6g$r9=@.$9$k$^$G0lJ8;z$E$D8+$F$$$/!#(BQuixote $B%W%m%0%i%`$N;z6g$O(B
$BC1=c$J$N$G!"0lJ8;z$E$D$_$F$$$/J}K!$G==J,$G$"$k!#(B"
  (let (is-integer
	is-set
	beg-of-lexeme
	value
	len
	token)
    (catch 'token-recognized
      (while t
	(get-next-char)
	(setq is-integer nil)
	(cond
	 ;; comment
	 ((= ch ?%)
	  (while (/= ch ?\n)
	    (get-next-char))
	  (setq qxt-line-no (1+ qxt-line-no)))
	 ;; count new line
	 ((= ch ?\n)
	  (setq qxt-line-no (1+ qxt-line-no)))
	 ;; skip white space
	 ((or (= ch ?\ ) (= ch ?\t))
	  )
	 ;; string
	 ((= ch ?\")
	  (setq beg-of-lexeme qxt-lex-pos)
	  (get-next-char)
	  (catch 'break
	    (while t
	      (while (/= ch ?\")
		(if (= ch 0)
		    (signal 'lexical (list (format "LEX: missing double quote"))))
		(get-next-char))
	      (get-next-char)
	      (if (/= ch ?\")
		  (throw 'break nil)
		(get-next-char))))
	  (unget-next-char ch)
	  (setq value
		(substring qxt-input-string beg-of-lexeme qxt-lex-pos))
	  (let* ((i 0) (j 0)
		 (len (length value))
		 (result (make-string len 0)))
	    (while (< j len)
	      (let ((ch1 (aref value j))
		    (sakkimo-quote nil))
		(aset result i ch1)
		(if (/= ch1 ?\")
		    (if sakkimo-quote
			(setq sakkimo-quote nil)
		      (setq i (1+ i)
			    sakkimo-quote t)))
		(setq j (1+ j))))
	    (setq value (substring result 0 i)))
	  (setq token 'STRING)
	  (throw 'token-recognized nil))
	 ;; integer ;; atom ;; exp_name ;; sort_name ;; keyword ;; set_atom
	 ((or (= ch ?&)
	      (>= ch 128) ; kanji
	      (and (>= ch ?a) (<= ch ?z))
	      (and (>= ch ?0) (<= ch ?9) (setq is-integer t)))
	  (setq beg-of-lexeme (1- qxt-lex-pos))
	  (if (= ch 161)
	      (progn
		(get-next-char)
		(if (= ch 161)
		    (signal 'lexical (list (format "LEX")))))
	    (if (>= ch 128)
		(get-next-char)))
	  (get-next-char)
	  (while (or (>= ch 128) ; kanji
		     (and (= ch ?&) (progn (setq is-integer nil) t))
		     (and (= ch ?_) (progn (setq is-integer nil) t))
		     (and (>= ch ?a) (<= ch ?z)
			  (progn (setq is-integer nil) t))
		     (and (>= ch ?A) (<= ch ?Z)
			  (progn (setq is-integer nil) t))
		     (and (>= ch ?0) (<= ch ?9)))
	    (if (= ch 161)
		(progn
		  (get-next-char)
		  (if (= ch 161)
		      (signal 'lexical (list (format "LEX")))))
	      (if (>= ch 128)
		  (get-next-char)))
	    (get-next-char))
	  (unget-next-char ch)
	  (setq value
		(substring qxt-input-string beg-of-lexeme qxt-lex-pos))
	  (setq len (length value))
	  (cond (is-integer
		 (setq value
		       (string-to-int value)
		       token 'INTEGER))
		((and (= (aref value 0) ?e)
		      (> len 1)
		      (= (aref value 1) ?_))
		 (setq value
		       (intern value)
		       token 'EXP_NAME))
		((and (= (aref value 0) ?s)
		      (> len 1)
		      (= (aref value 1) ?_))
		 (setq value
		       (intern value)
		       token 'SORT_NAME))
		(t
		 (if (= ch ?*)
		     (progn
		       (get-next-char)
		       (setq is-set t)))
		 (setq value
		       (substring qxt-input-string beg-of-lexeme qxt-lex-pos))
		 (let ((symbol (intern-soft value qxt-lex-keywords-obarray)))
		   (if symbol
		       (progn
			 (setq value (intern value)
			       token (symbol-value symbol))
			 (if value
			     ()
			   ;; nil (qxt-nil)
			   (setq value symbol)))
		     (setq value (intern value)
			   token (if is-set 'SET_ATOM 'ATOM))))))
	  (throw 'token-recognized nil))
	 ;; variable ;; set_variable
	 ((or (= ch ?_)
	   (and (>= ch ?A) (<= ch ?Z)))
	  (setq beg-of-lexeme (1- qxt-lex-pos))
	  (get-next-char)
	  (while (or (>= ch 128) ; kanji
		     (= ch ?&)
		     (= ch ?_)
		     (and (>= ch ?a) (<= ch ?z))
		     (and (>= ch ?A) (<= ch ?Z))
		     (and (>= ch ?0) (<= ch ?9)))
	    (get-next-char))
	  (if (= ch ?*)
	      (setq is-set t)
	    (unget-next-char ch))
	  (setq value
		(substring qxt-input-string beg-of-lexeme qxt-lex-pos))
	  (setq token (if is-set 'SET_VARIABLE 'VARIABLE))
	  (throw 'token-recognized nil))
	 ((= ch ?\;)
	  (setq beg-of-lexeme (1- qxt-lex-pos))
	  (get-next-char)
	  (if (= ch ?\;)
	      (progn
		(setq token 'TERMINATER))
	    (unget-next-char ch)
	    (setq token ?\;))
	  (setq value
		(intern
		 (substring qxt-input-string beg-of-lexeme qxt-lex-pos)))
	  (throw 'token-recognized nil))
	 ((= ch ?>)
	  (setq beg-of-lexeme (1- qxt-lex-pos))
	  (get-next-char)
	  (cond ((= ch ?=)
		 (setq token 'SUBSUMES))
		((= ch ?*)
		 (setq token 'SET_SUBSUMES))
		((= ch ?-)
		 (setq token 'SUPER_MODULE_OF))
		(t
		 (unget-next-char ch)
		 (setq token ?>)))
	  (setq value
		(intern
		 (substring qxt-input-string beg-of-lexeme qxt-lex-pos)))
	  (throw 'token-recognized nil))
	 ((= ch ?=)
	  (setq beg-of-lexeme (1- qxt-lex-pos))
	  (get-next-char)
	  (cond ((= ch ?<)
		 (setq token 'SUPERSUMES))
		((= ch ?=)
		 (setq token 'CONGRUENT))
		((= ch ?*)
		 (get-next-char)
		 (if (= ch ?=)
		     (setq token 'SET_CONGRUENT)
		   (unget-next-char ch)
		   (unget-next-char ?*)
		   (setq token ?=)))
		(t
		 (unget-next-char ch)
		 (setq token ?=)))
	  (setq value
		(intern
		 (substring qxt-input-string beg-of-lexeme qxt-lex-pos)))
	  (throw 'token-recognized nil))
	 ((= ch ?*)
	  (setq beg-of-lexeme (1- qxt-lex-pos))
	  (get-next-char)
	  (cond ((= ch ?<)
		 (setq token 'SET_SUPERSUMES))
		(t
		 (unget-next-char ch)
		 (setq token ?*)))
	  (setq value
		(intern
		 (substring qxt-input-string beg-of-lexeme qxt-lex-pos)))
	  (throw 'token-recognized nil))
	 ((= ch ?-)
	  (setq beg-of-lexeme (1- qxt-lex-pos))
	  (get-next-char)
	  (cond ((= ch ?<)
		 (setq token 'SUB_MODULE_OF))
		((= ch ?>)
		 (setq token 'INSTANCE_OF))
		(t
		 (unget-next-char ch)
		 (setq token ?-)))
	  (setq value
		(intern
		 (substring qxt-input-string beg-of-lexeme qxt-lex-pos)))
	  (throw 'token-recognized nil))
	 ((= ch ?<)
	  (setq beg-of-lexeme (1- qxt-lex-pos))
	  (get-next-char)
	  (cond ((= ch ?-)
		 (setq token 'ABSTRACT_OF))
		((= ch ?=)
		 (setq token 'COMMITS))
		(t
		 (unget-next-char ch)
		 (setq token ?<)))
	  (setq value
		(intern
		 (substring qxt-input-string beg-of-lexeme qxt-lex-pos)))
	  (throw 'token-recognized nil))	 
	 ((= ch ?\[)
	  (setq beg-of-lexeme (1- qxt-lex-pos))
	  (get-next-char)
	  (cond ((= ch ?\])
		 (setq token 'NIL))
		(t
		 (unget-next-char ch)
		 (setq token ?\[)))
	  (setq value
		(intern
		 (substring qxt-input-string beg-of-lexeme qxt-lex-pos)))
	  (throw 'token-recognized nil))
	 ((= ch ?|)
	  (setq beg-of-lexeme (1- qxt-lex-pos))
	  (get-next-char)
	  (cond ((= ch ?|)
		 (setq token 'CONSTRAINED))
		(t
		 (unget-next-char ch)
		 (setq token ?|)))
	  (setq value
		(intern
		 (substring qxt-input-string beg-of-lexeme qxt-lex-pos)))
	  (throw 'token-recognized nil))
	 ((= ch ?\?)
	  (setq beg-of-lexeme (1- qxt-lex-pos))
	  (get-next-char)
	  (cond ((= ch ?-)
		 (setq token 'SOLVE))
		(t
		 (unget-next-char ch)
		 (setq token ?\?)))
	  (setq value
		(intern
		 (substring qxt-input-string beg-of-lexeme qxt-lex-pos)))
	  (throw 'token-recognized nil))
	 ((= ch ?:)
	  (setq beg-of-lexeme (1- qxt-lex-pos))
	  (get-next-char)
	  (cond ((= ch ?:)
		 (setq token 'DOUBLE_COLON))
		((= ch ?-)
		 (setq token 'COMMITS))
		(t
		 (unget-next-char ch)
		 (setq token ?:)))
	  (setq value
		(intern
		 (substring qxt-input-string beg-of-lexeme qxt-lex-pos)))
	  (throw 'token-recognized nil))
	 (t
	  (setq token ch)
	  ;; value is not used
	  (throw 'token-recognized nil)) )))
      (cons token value) ))

(defconst qxt-lex-keywords
  '(
    ("&abort_transaction" ABORT_TRANSACTION)
    ("&at" ABORT_TRANSACTION)
    ("&abs" ABS)
    ("&add" ADD)
    ("&all" ALL)
    ("&ans_mode" ANS_MODE)
    ("&author" AUTHOR)
    ("&aut_name" AUT_NAME)
    ("&begin_transaction" BEGIN_TRANSACTION)
    ("&bt" BEGIN_TRANSACTION)
    ("&car" CAR)
    ("&cdr" CDR)
    ("&consis" CONSIS)
    ("&date" DATE)
    ("&db" DATABASE)
    ("&database" DATABASE)
    ("&del" DEL)
    ("&down" DOWN)
    ("&end_transaction" END_TRANSACTION)
    ("&et" END_TRANSACTION)
    ("&end" END)
    ("&env" ENVIRONMENT)
    ("&environment" ENVIRONMENT)
    ("&exp" EXPRESSION)
    ("&expression" EXPRESSION)
    ("&exp_lib" EXP)
    ("&explanation" EXPLANATION)
    ("&in" IN)
    ("&include" INCLUDE)
    ("&inconsis" INCONSIS)
    ("&inheritance" INHERITANCE)
    ("&l" L)
    ("&link" LINK)
    ("&lo" LO)
    ("&merge" MERGE)
    ("&minimal" MINIMAL)
    ("&mod" MODULE)
    ("&module" MODULE)
    ("&multi" MULTI)
    ("&name" NAME)
    ("&ni" NI)
    ("&no" NO)
    ("&no_assume" NO_ASSUME)
    ("&normal" NORMAL)
    ("&o" O)
    ("&obj" OBJECT)
    ("&object" OBJECT)
    ("&off" OFF)
    ("&ol" OL)
    ("&on" ON)
    ("&pgm_name" PGM_NAME)
    ("&pgm_lib" PGM_LIB)
    ("&proc_mode" PROC_MODE)
    ("&program" PROGRAM)
    ("&pgm" PROGRAM)
    ("&q_mode" Q_MODE)
    ("&rule" RULE)
    ("&self" SELF)
    ("&single" SINGLE)
    ("&sort_lib" SORT_LIB)
    ("&submod" SUBMODULE)
    ("&submodule" SUBMODULE)
    ("&subsum" SUBSUMPTION)
    ("&subsumption" SUBSUMPTION)
    ("&up" UP)
    ("&yes" YES)
    ("nil" ATOM))
  "Quixote $B%W%m%0%i%`$N%-!<%o!<%I$N%j%9%H!#(B
Quixote $B%W%m%0%i%`$K$*$$$F$9$Y$F$N%-!<%o!<%I$O(B $B%"%s%Q%5%s%I(B(&)$B$G;O$^$k!#(B
nil $B$ONc30$G(B lisp $B$N(B nil $B$H$J$i$J$$$h$&$K$3$3$KEPO?$7$F$"$k!#(B")

(defvar qxt-lex-keywords-obarray nil
  "Quixote $B%W%m%0%i%`$N%-!<%o!<%I$N%O%C%7%eI=!#(B
e-lisp $B$NET9g>e(B, $BJQ?t$K$J$C$F$$$k$,Dj?t!#(B")

(if qxt-lex-keywords-obarray
    ()
  (let ((list qxt-lex-keywords))
    (setq qxt-lex-keywords-obarray (make-vector 79 0))
    (while list
      (let* ((s-name (car (car list)))
	     (symbol (intern s-name qxt-lex-keywords-obarray)))
	(set symbol (car (cdr (car list)))))
      (setq list (cdr list)))))

(defconst qxt-nil
   (intern "nil" qxt-lex-keywords-obarray))
