(defconst qxt-server-port 5678
  "Port Number of Quixote Server.
Quixote Server $B$N%]!<%HHV9f!#(B
**$B%5!<%S%9L>$r07$($k$h$&$K$9$k$H$b$C$H$$$$$M$'(B")

(defvar qxt-host-name nil
  "String or Nil. Host Name of Quixote Server.
Quixote Server $B$N%[%9%HL>$N%9%H%j%s%0!#(Bnil $B$N>l9g$OL$Dj$rI=$9!#(B
**133.148.113.11 $B$H$$$&7A<0$,07$($k$H$b$C$H$$$$$M$'(B")

(defvar qxt-process nil "Communication Channel to Quixote Server
Quixote Server $B$H$NDL?.(B channel $B$r2!$($F$$$kJQ?t!#(B
$BF~$kCM$O(B Emacs $B$N(B Process.")

(if (boundp 'NEMACS)
    (define-service-kanji-code qxt-server-port nil 3) ; EUC
  ;; mule $B$K$J$C$?$i$3$3$rJQ99$;$M$P(B
  )

(defvar qxt-current-session nil "Variable for current session
Its value is one of:
   server
   database
   trace
   inspect
")

(defun qxt-start (another-host)
  "Start Quixote session to SERVER.
Use prefix argument to connect another host

Quixote $B$H$N@\B3$r9T$J$&!#$9$G$K@\B3$,$"$k>l9g$O%(%i!<!#(B
$B@\B3$O(B qxt-host-name $B$,@_Dj$5$l$F$$$k>l9g$=$N%[%9%H$K(B
$B@\B3$9$k!#(Bqxt-host-name $B$,@_Dj$5$l$F$$$J$$>l9g$O4D6-JQ?t$N(B
QXTSERVER, $B4D6-JQ?t$,@_Dj$5$l$F$$$J$$>l9g$O%f!<%6$KLd$$9g$o$;$k!#(B
$B%[%9%HL>$r4D6-JQ?t(B, $B%f!<%6$X$NLd$$9g$o$;$GF@$?>l9g!"(B
$B$=$NCM$O(B qxt-host-name $B$K@_Dj$5$l$k(B($B<!2s0J9_$O$=$NCM$,MQ$$$i$l$k(B)$B!#(B

prefix argument(C-u $B$J$I$G(B)($B0z?t(B another-host $B$K(B bind $B$5$l$k(B) $B$O(B
$B8=:_$N(B qxt-host-name $B$NCM!"4D6-JQ?t(B QXTSERVER $B$H(B
$B4X78$J$/%f!<%6$K%[%9%HL>$rLd$$9g$o$;$k$3$H$r0UL#$9$k!#(B"
  (interactive "P")
  (setq qxt-host-name
	(if another-host
	    (read-string "Host: ")
	  (or qxt-host-name
	      (getenv "QXTSERVER")
	      (read-string "Host: "))))
  (if (and qxt-process
	   (eq (process-status qxt-process) 'open))
      (message "there is opening session already")
    (qxt-session-start qxt-host-name))
  (let ((qxt-synchronous t))
    (run-hooks 'qxt-setup-hook)))

(defvar qxt-buffer nil
  "Buffer for interaction debugging.
QIF protocol $B$N(B interaction $B%G%P%C%0MQ$N(B buffer.
$B%$%s%?%i%/%7%g%s$NMM;R$,$3$3$K<($5$l$k!#(B")

(defun qxt-session-start (host)
  "Start Quixote session to SERVER.

Quixte $B%5!<%P(B ($B0z?t(B Host) $B$K@\B3$9$k4X?t!#(B
$B0J2<$N=hM}$r9T$J$&!#(B
  $B%P%C%U%!(B \" *Quixtote*\" $B$r:n$j!"(Bqxt-buffer $B$KBeF~$9$k!#(B
  $B7k2LI=<(MQ$N(B buffer $B$rMQ0U$9$k!#(B
  open-network-stream $B$K$h$j@\B3$r9T$J$&!#(B
  $B<u?.MQ$N%U%#%k%?$r@_Dj!#@\B30[>o8!=P$N$?$a$N4X?t$r@_Dj$9$k!#(B
  $BJQ?t(B qxt-current-session, qxt-client-state $B$r=i4|@_Dj$9$k!#(B
  $BG'>Z$N$?$a$N(B USER user-name $B$r(B Quixote server $B$KAw?.$9$k!#(B
  $B%a%C%;!<%8$K@\B3$7$?$HI=<($9$k!#(B
"
  (let ((buffer (get-buffer-create " *Quixote*")))
    (setq qxt-buffer buffer)
    (qxt-get-result-buffer)
    (setq qxt-server-output nil)
    (setq qxt-process (open-network-stream "Qif" nil host qxt-server-port))
    (set-process-filter  qxt-process  'qxt-filter)
    (set-process-sentinel qxt-process 'qxt-sentinel)
    (setq qxt-client-state 'expect-status)
    (accept-process-output qxt-process)
    (qxt-process-send-string (concat "USER " (user-login-name) "\n"))
    (setq qxt-current-session 'server)
    (setq qxt-client-state 'expect-status)
    (accept-process-output qxt-process)
    (setq qxt-window-mode nil)
    (if qxt-synchronous
	(save-excursion
	  (set-buffer qxt-result-buffer)
	  (insert (format "Quixote server on %s\n" host))
	  (qxt-insert-prompt qxt-current-session))
      (switch-to-buffer qxt-result-buffer)
      (insert (format "Quixote server on %s\n" host))
      (qxt-insert-prompt qxt-current-session))
    (message (concat "connected " host))))

(defvar qxt-server-output nil
  "Quixote $B%5!<%P$+$i<u?.$7$?FbMF$r$H$C$F$*$/JQ?t!#(B
String $B$^$?$O(B nil.")

(defvar qxt-client-state nil
  "$B8=:_$N(B client $B$NDL?.>uBV$r<($9JQ?t!#(B

$B0J2<$N;M$D$N(B symbol $B$G<($5$l$k>uBV$,$"$k!#(B
nil                           CMD $B<B9TH/?.2DG=(B
expect-status                 $B%9%F%$%?%9<u?.BT$A(B
expect-status-and-result      $B%9%F%$%?%9!&7k2L<u?.BT$A(B
expect-result                 $B7k2L<u?.BT$A(B"
)

(defun qxt-insert (string)
  "$B%G%P%C%0MQ(B buffer \" *Quixote*\" $B$KJ8;zNs$rA^F~$9$k!#(B
$B8=:_$N(B window, buffer $B$N>uBV$rJx$5$J$$!#(B"
  (save-excursion
    (set-buffer qxt-buffer)
    (goto-char (point-max))
    (insert string))
    (if (eq (window-buffer (selected-window))
	    qxt-buffer)
	(set-window-point (selected-window)
			  (save-excursion
			    (set-buffer qxt-buffer)
			    (point-max)))))

(defvar qxt-time-switch nil
  "$B7W;~5!G=$N%9%$%C%A$NJQ?t!#(B
Quixote Server $B$N%3%^%s%I<B9T$K$*$$$F!"$3$NJQ?t$,(B nil $B$N$H$-$O(B
$B7W;~$rMW5a$7$J$$!#(Bnil $B0J30$N;~$O7W;~$rMW5a$9$k!#(B")

(defvar qxt-processing-time 0
  "$B7W;~$7$?;~4V$rF~$l$F$*$/JQ?t!#@0?t!#(B")

(defun qxt-filter (process string)
  "$B%W%m%;%9%U%#%k%?4X?t!#$3$N4X?t$,(B Quixote $B%5!<%P$H$NDL?.$N%U%#%k%?(B($B<u?.4X(B
$B?t(B)$B$H$7$FMQ$$$i$l$k!#<u?.$7$?(B string $B$rJQ?t(B qxt-server-output $B$K(B 
concatinate $B$9$k$H$H$b$K!"%/%i%$%"%s%H$N>uBV$K1~$8$F0J2<$N=hM}$r9T$J$&!#(B

  (1) $B%9%F%$%?%9BT$A>uBV(B
	$B0l9TF~NO$,=*N;$7$?>l9g!"(Bqxt-insert $B$r8F$S=P$7!"(B
	qxt-client-state $B$r(B nil $B$K@_Dj$9$k!#(B

  (2) $B%9%F%$%?%9!&7k2LBT$A>uBV(B
	$B0l9TF~NO$,=*N;$7$?>l9g!"<:GT$N>l9g(B qxt-client-state $B$r(B nil $B$K@_Dj$9$k!#(B
        $B@.8y$G$"$C$?$J$i!"(B
	$B7W;~%9%$%C%A(B qxt-time-switch $B$,(B on $B$N$H$-!";~4V$rI=<($7!"(B
	qxt-insert $B$r8F$S=P$7!"(B
	qxt-client-state $B$r(B expect-result $B$K@_Dj$9$k!#(B

  (3) $B7k2LBT$A>uBV(B
	$B0l9TF~NO$,=*N;$7$?>l9g!"(B
	qxt-client-state $B$r(B nil $B$K@_Dj$7!"7k2L(B dispatch $B4X?t$r8F$S=P$9!#(B"
  (setq qxt-server-output (concat qxt-server-output string))
  (if (eq qxt-client-state 'expect-status)
      (let ((line (qxt-get-line)))
	(if line
	    (progn
	      (setq qxt-client-state nil)
	      (qxt-insert line))))
    (if (eq qxt-client-state 'expect-status-and-result)
	(let ((line (qxt-get-line)))
	  (if line
	      (progn
		(if (= (aref line 0) ?-)
		    (progn
		      (setq qxt-client-state nil) ;; error
		      (error line))
		  (if qxt-time-switch
		      ;; The format of string which Server returns is:
		      ;;
		      ;;  +OK Time 1125 ms. Executing....done. Result is:
		      ;;           ^^^^ we want this
		      (setq qxt-processing-time
			    (car (read-from-string line 8))))
		  (setq qxt-client-state 'expect-result))
		(qxt-insert line)))))
    (if (eq qxt-client-state 'expect-result)
      (let ((line (qxt-get-line)))
	(if line
	    (progn
	      (setq qxt-client-state nil)
	      (qxt-insert line)     ;; insert " *Quixote*" buffer
	      (qxt-result line)     ;; response to user
	      ))))))

(defun qxt-process-send-string (string)
  "Quixote $B%5!<%P$KJ8;zNs(B string $B$rAw?.$9$k!#(B
$B<u?.7k2L$,$^$@=hM}$5$l$F$$$J$$>l9g$r%A%'%C%/$7!"=hM}$5$l$F$$$J$$>l9g$O(B
$B%(%i!<$H$9$k!#(B"
  (and qxt-server-output
       (not (string= qxt-server-output ""))
       (error "What's wrong?"))
  (process-send-string qxt-process string))

(defun qxt-get-line ()
  "$BJQ?t(B qxt-server-output $B$K$h$j!"0l9T$NF~NO$,$"$C$?$+$I$&$+3N$+$a$k!#(B
qxt-server-output $B$,0l9T$KK~$?$J$$>l9g!"(Bnil $B$rJV$9!#(B
$B0l9T$,$"$C$?>l9g$=$l$r(B qxt-server-output $B$+$i:o$j!"(B
$B$=$N9T$NJ8;zNs$rJV$9!#(B"
  (let (index)
    (if (and qxt-server-output
	     (setq index (string-match "\n" qxt-server-output)))
	(prog1
	    (substring qxt-server-output 0 (1+ index))
	  (setq qxt-server-output (substring qxt-server-output (1+ index))))
      nil)))

(defun qxt-get-line-or-wait ()
  "Quixote server $B$+$i0l9TF@$k$^$GBT$D!#(B"
  (let (line)
    (while (null (setq line (qxt-get-line)))
      (accept-process-output qxt-process))
    line))

(defun qxt-sentinel (process status)
  "$B%W%m%;%9%;%s%A%M%k4X?t!#HVJ<!#(BQuixote $B%5!<%P$H$NDL?.$N%;%s%A%M%k(B
*$B@\B3>uBV=hM}4X?t(B*$B$H$7$FMQ$$$i$l$k!#(B"
  (save-excursion
    (set-buffer qxt-buffer)
    (goto-char (point-max))
    (insert status)
    (insert "\n"))
  (let ((win (get-buffer-window qxt-result-buffer))
	(pm (save-excursion
	      (display-buffer qxt-result-buffer)
	      (set-buffer qxt-result-buffer)
	      (setq buffer-read-only nil)
	      (goto-char (point-max))
	      (insert status)
	      (insert "\n")
	      (point-max))))
    (if win
	(set-window-point win pm)))
  (setq qxt-process nil))

(defun qxt-check-result (error-msg)
  "QIF $B%W%k%H%3%k$K$*$$$F%(%i!<$+$I$&$+%A%'%C%/$9$k4X?t!#(B
Quixote $B%5!<%P$N1~Ez$N:G=i$N0lJ8;z$r8+$F$=$l$,(B -(minus) $B$J$i$P(B
$B%(%i!<(B $B$G$"$k!#$=$N;~$O(B error $B$r0z?t(B error-msg $B$GH/@8$9$k!#(B"
  (let ((result (qxt-get-line-or-wait)))
    (if (= (aref result 0) ?-)
	(error error-msg))))

(defun qxt-expect-result ()
  "$B7k2L$rBT$D$3$H$r;XDj$9$k4X?t!#(B
$BJQ?t(B qxt-client-state $B$r(B expect-status-and-result $B$K@_Dj$9$k!#(B
$B$b$&$9$G$K7k2L$,JV$C$F$$$k(B($BJQ?t(B qxt-output-string $B$K(B)$B$+$bCN$l$J$$$N$G(B
$B4X?t(B qxt-filter $B$r6u$NJ8;zNs$G8F$S=P$9!#(B"
  (setq qxt-client-state 'expect-status-and-result)
  (qxt-filter qxt-process ""))

(defvar qxt-synchronous nil
  "$BF14|<B9T$9$k$+$I$&$+$N%9%$%C%A!#(Bnil $B$N$H$-(B off. $B$=$l0J30$N;~(B on.")

(defun qxt-send-command (line)
  "$B%3%^%s%I<B9TAw?.4X?t!#(B
$B0z?t(B line $B$G<($5$l$kFbMF$N%3%^%s%I<B9T$r(B Quxite server $B$KMW5a$9$k!#(B
$BJQ?t(B qxt-time-switch $B$K$h$j!"(B CMD $B$+(B CMD T $B$+$rA*Br$9$k!#(B
QIF $B%W%m%H%3%k$K4p$E$$$F(B CMD $B$NMW5a$N@.8y$r3NG'!"(Bcommand $B$NMW5a3NG'$r9T$J$&!#(B
$B$$$:$l$+$,<:GT$7$?;~$O%(%i!<!#<B9T7k2L$rBT$D>uBV$K0\9T$9$k!#(B
$BJQ?t(B qxt-synchronous $B$,(B on $B$N;~$O(B Quixote server $B$N<B9T7k2L$,JV$k$^$G(B
$BBT$D!#(B"
  (if qxt-time-switch
      (qxt-process-send-string "CMD T\n")
    (qxt-process-send-string "CMD\n"))
  (qxt-check-result "CMD failed")
  (qxt-process-send-string (concat line "\n"))
  (qxt-check-result "command failed")
  (qxt-expect-result)
  ;;
  (if qxt-synchronous
      (while qxt-client-state
	(accept-process-output qxt-process))))


;; timer stuff
;(if (eq system-type 'usg-unix-v)
;    (defconst qxt-time-command "/bin/time")
;  ;; Guess it is BSD.
;  (defconst qxt-time-command "/usr/bin/time"))
;
;(defvar qxt-time-process nil)
;(defvar qxt-time-output-string nil)
;
;(defun qxt-timer-start ()
;  (if qxt-time-process
;      (delete-process qxt-time-process))
;  (setq qxt-time-output-string nil)
;  (condition-case err
;      (progn
;	(setq qxt-time-process
;	      (start-process "Time" nil qxt-time-command "cat"))
;	(set-process-filter qxt-time-process 'qxt-read-elapsed-time))
;    (error nil)))
;
;(defun qxt-read-elapsed-time (process output)
;  (if (or (not (boundp 'time)) time)
;      ()
;    (setq qxt-time-output-string (concat qxt-time-output-string output))
;    (if (string= qxt-time-output-string "\n")
;	(setq qxt-time-output-string nil)
;      (if (and qxt-time-output-string
;	       (string-match "\n" qxt-time-output-string))
;	  ;; The format of SysV time is:
;	  ;;
;	  ;; real      1:2.9
;	  ;; user        0.0
;	  ;; sys         0.0
;	  ;; 
;	  ;; while BSD's is:
;	  ;;     62.9 real 0.0 user 0.0 sys
;	  ;;
;	  (setq time
;		(progn
;		  (string-match "\\([0-9]+\\)?+:[0-9]+\\.[0-9]+"
;				qxt-time-output-string)
;		  (substring qxt-time-output-string
;			     (match-beginning 0)
;			     (match-end 0))))))))
;
;(defun qxt-timer-end ()
;  (if (null qxt-time-process)
;      ()
;    (process-send-eof qxt-time-process)
;    (let (time)
;      (while (null time)
;	(accept-process-output qxt-time-process))
;      (delete-process qxt-time-process)
;      (setq qxt-time-process nil)
;      time)))
;