#include <assert.h>
#include <ctype.h>

#define MALLOC_DEBUG

#define INDENT 4

#include "dotsrc.h"

extern FILE *fp;


/*
 VALUE (union)
*/

Local void test_value1()
{
    Value *value = NULL;

    assert(is_value(value));
    value = new_value();
    assert(is_value(value));
    delete_value(value);
    check_memory_usage("test_value1");
}

Local void test_value2()
{
    Set *set = new_set(), *set2 = copy_set(set);
    Sort *sort = new_sort(), *sort2 = copy_sort(sort);
    OTerm *o_term = new_o_term(), *o_term2 = copy_o_term(o_term);
    Prolog *prolog = new_prolog(), *prolog2 = copy_prolog(prolog);
    COTerm *c_o_term = new_c_o_term(), *c_o_term2 = copy_c_o_term(c_o_term);
    Var *var = new_var(), *var2 = copy_var(var);
    Dot *dot = new_dot(), *dot2 = copy_dot(dot);
    List *list = new_list(), *list2 = copy_list(list);
    NonStruct *non_struct = new_non_struct(), 
              *non_struct2 = copy_non_struct(non_struct);
    Value *value = new_value();
    Value *value_set = create_value_set(set);
    Value *value_sort = create_value_sort(sort);
    Value *value_o_term = create_value_o_term(o_term);
    Value *value_prolog = create_value_o_term((OTerm*)prolog);
    Value *value_c_o_term = create_value_o_term((OTerm*)c_o_term);
    Value *value_var = create_value_o_term((OTerm*)var);
    Value *value_dot = create_value_o_term((OTerm*)dot);
    Value *value_list = create_value_o_term((OTerm*)list);
    Value *value_non_struct = create_value_o_term((OTerm*)non_struct);
    PMode *p_mode = new_p_mode();

    assert(fis_set(value_set) && fis_sort(value_sort) &&
	   fis_o_term(value_o_term) && fis_prolog(value_prolog) &&
	   fis_c_o_term(value_c_o_term) && fis_var(value_var) &&
	   fis_dot(value_dot) && fis_list(value_list) &&
	   fis_non_struct(value_non_struct) && fis_value(value) && 
	   fis_value(NULL));
/*
    assert(*((Set*)value_set) == *set2 && *((Sort*)value_sort) == *sort2 &&
	   *((OTerm*)value_o_term) == *o_term2);
*/
    assert(! is_value(p_mode));
    assert(! fis_value(p_mode));
    delete_set(set2);
    delete_sort(sort2);
    delete_o_term(o_term2);
    delete_prolog(prolog2);
    delete_c_o_term(c_o_term2);
    delete_var(var2);
    delete_dot(dot2);
    delete_list(list2);
    delete_non_struct(non_struct2);
    delete_value(value);
    delete_value(value_set);
    delete_value(value_sort);
    delete_value(value_o_term);
    delete_value(value_prolog);
    delete_value(value_c_o_term);
    delete_value(value_var);
    delete_value(value_dot);
    delete_value(value_list);
    delete_value(value_non_struct);
    delete_p_mode(p_mode);
    check_memory_usage("test_value2");
}

Local void test_value3()
{
    Value *value_set = create_value_set(new_set()), *value_set2;
    Value *value_sort = create_value_sort(new_sort()), *value_sort2;
    Value *value_o_term = create_value_o_term(new_o_term()),
          *value_o_term2;
    Value *value_prolog = create_value_o_term((OTerm*)new_prolog()), 
          *value_prolog2;
    Value *value_c_o_term = create_value_o_term((OTerm*)new_c_o_term()), 
          *value_c_o_term2;
    Value *value_var = create_value_o_term((OTerm*)new_var()), 
          *value_var2;
    Value *value_dot = create_value_o_term((OTerm*)new_dot()), 
          *value_dot2;
    Value *value_list = create_value_o_term((OTerm*)new_list()), 
          *value_list2;
    Value *value_non_struct = create_value_o_term((OTerm*)new_non_struct()), 
          *value_non_struct2;

    assert(fis_set(value_set) && fis_sort(value_sort) &&
	   fis_o_term(value_o_term) && fis_prolog(value_prolog) &&
	   fis_c_o_term(value_c_o_term) && fis_var(value_var) &&
	   fis_dot(value_dot) && fis_list(value_list) &&
	   fis_non_struct(value_non_struct));
    value_set2 = copy_value(value_set);
    value_sort2 = copy_value(value_sort);
    value_o_term2 = copy_value(value_o_term);
    value_prolog2 = copy_value(value_prolog);
    value_c_o_term2 = copy_value(value_c_o_term);
    value_var2 = copy_value(value_var);
    value_dot2 = copy_value(value_dot);
    value_list2 = copy_value(value_list);
    value_non_struct2 = copy_value(value_non_struct);
    delete_value(value_set);
    delete_value(value_sort);
    delete_value(value_o_term);
    delete_value(value_prolog);
    delete_value(value_c_o_term);
    delete_value(value_var);
    delete_value(value_dot);
    delete_value(value_list);
    delete_value(value_non_struct);
    delete_value(value_set2);
    delete_value(value_sort2);
    delete_value(value_o_term2);
    delete_value(value_prolog2);
    delete_value(value_c_o_term2);
    delete_value(value_var2);
    delete_value(value_dot2);
    delete_value(value_list2);
    delete_value(value_non_struct2);
    check_memory_usage("test_value3");
}

Local void test_value4()
{
    Value *value = new_value(), *value2;
    Value *value_set = create_value_set(new_set()), *value_set2;
    Value *value_sort = create_value_sort(new_sort()), *value_sort2;
    Value *value_o_term = create_value_o_term(new_o_term()), *value_o_term2;
    int n;

    n = strcmp(type_name(value->tag), "VALUE");
    assert(n == 0); 
    assert(is_type(value->tag, VALUE) && 
	   is_type(value_set->tag, value->tag) &&
	   is_type(value_sort->tag, value->tag)&&
	   is_type(value_o_term->tag, value->tag));
    value2 = (Value*)copy_pseudo_object(value);
    value_set2 = (Value*)copy_pseudo_object(value_set);
    value_sort2 = (Value*)copy_pseudo_object(value_sort);
    value_o_term2 = (Value*)copy_pseudo_object(value_o_term);
    print_pseudo_object(value2, fp, INDENT);
    print_pseudo_object(value_set2, fp, INDENT);
    print_pseudo_object(value_sort2, fp, INDENT);
    print_pseudo_object(value_o_term2, fp, INDENT);
    delete_pseudo_object(value2);
    delete_pseudo_object(value_set2);
    delete_pseudo_object(value_sort2);
    delete_pseudo_object(value_o_term2);
    delete_value(value);
    delete_value(value_set);
    delete_value(value_sort);
    delete_value(value_o_term);
    check_memory_usage("test_value4");
}

Public void test_value()
{
    printf("testing value...\n");
    test_value1();
    test_value2();
    test_value3();
    test_value4();
}

/*
 SET (have ObjList)
*/

Local void test_set1()
{
    Set *set = NULL;

    assert(is_set(set));
    set = new_set();
    assert(is_set(set));
    delete_set(set);
    check_memory_usage("test_set1");
}

Local void test_set2()
{
    ObjList *o_terms = new_obj_list(O_TERM), *o_terms2;
    Set *set = create_set(o_terms);

    assert(fis_set(NULL));
    assert(fis_set(set));
    assert(! is_set(o_terms));
    assert(! fis_set(o_terms));
    decompose_set(set, &o_terms2);
    assert(o_terms2 == o_terms);
    assert(read_o_terms_inSet(set) == o_terms);
    assert(mread_o_terms_inSet(set) == o_terms);
    delete_set(set);
    check_memory_usage("test_set2");
}

Local void test_set3()
{
    Set *set = new_set();
    ObjList *o_terms = new_obj_list(O_TERM), *o_terms2;

    decompose_set(set_set(set, o_terms), &o_terms2);
    assert(o_terms2 == o_terms);
    delete_set(set);
    check_memory_usage("test_set3");
}

Local void test_set4()
{
    Set *set = new_set(), *set2, *set3 = new_set();
    ObjList *o_terms = new_obj_list(O_TERM), *o_terms2;

    decompose_set(write_o_terms_inSet(set, o_terms), &o_terms2);
    assert(o_terms2 == o_terms);
    o_terms = new_obj_list(O_TERM),
    decompose_set(mwrite_o_terms_inSet(set3, o_terms), &o_terms2);
    assert(o_terms2 == o_terms);
    set2 = copy_set(set);
    delete_set(set);
    delete_set(set2);
    delete_set(set3);
    check_memory_usage("test_set4");
}

Local void test_set5()
{
    Set *set;
    ObjList *obj_list, *obj_list2;
    OTerm *o_term, *o_term2, *o_term3, *o_term4;

    set = new_set();
    obj_list = new_obj_list(O_TERM);
    obj_list2 = new_obj_list(O_TERM);
    o_term = new_o_term();
    o_term2 = new_o_term();
    o_term3 = new_o_term();
    o_term4 = new_o_term();
    append_to_obj_list(append_to_obj_list(obj_list, o_term), o_term2);
    append_to_obj_list(append_to_obj_list(obj_list2, o_term3), o_term4);
    insert_o_terms_inSet(insert_o_terms_inSet(set, obj_list2), obj_list);
    assert(car_of_o_terms_inSet(set) == o_term &&
	   car_of_o_terms_inSet(set) == o_term2 &&
	   car_of_o_terms_inSet(set) == o_term3 &&
	   car_of_o_terms_inSet(set) == o_term4);

    obj_list = new_obj_list(O_TERM);
    obj_list2 = new_obj_list(O_TERM);
    cons_to_obj_list(cons_to_obj_list(obj_list, o_term), o_term2);
    cons_to_obj_list(cons_to_obj_list(obj_list2, o_term3), o_term4);
    add_o_terms_inSet(add_o_terms_inSet(set, obj_list2), obj_list);
    assert(car_of_o_terms_inSet(set) == o_term4 &&
	   car_of_o_terms_inSet(set) == o_term3 &&
	   car_of_o_terms_inSet(set) == o_term2 &&
	   car_of_o_terms_inSet(set) == o_term);
    delete_o_term(o_term);
    delete_o_term(o_term2);
    delete_o_term(o_term3);
    delete_o_term(o_term4);
    delete_set(set);
    check_memory_usage("test_set5");
}

Local void test_set6()
{
    Set *set = new_set(), *set2;
    ObjList *o_terms = new_obj_list(O_TERM);
    int n;

    n = strcmp(type_name(set->tag), "SET");
    assert(n == 0); 
    assert(is_type(set->tag, SET));
    set2 = (Set*)copy_pseudo_object(set_set(set, o_terms));
    print_pseudo_object(set2, fp, INDENT);
    delete_pseudo_object(set2);
    delete_set(set);
    check_memory_usage("test_set6");
}

Public void test_set()
{
    printf("testing set...\n");
    test_set1();
    test_set2();
    test_set3();
    test_set4();
    test_set5();
    test_set6();
}

/*
 CNSTR (union)
*/

Local void test_cnstr1()
{
    Cnstr *cnstr = NULL;

    assert(is_cnstr(cnstr));
    cnstr = new_cnstr();
    assert(is_cnstr(cnstr));
    delete_cnstr(cnstr);
    check_memory_usage("test_cnstr1");
}

Local void test_cnstr2()
{
    CnstrData *cnstr_data = new_cnstr_data(), 
              *cnstr_data2 = copy_cnstr_data(cnstr_data);
    QueryCnstr *query_cnstr = new_query_cnstr(), 
               *query_cnstr2 = copy_query_cnstr(query_cnstr);
    Cnstr *cnstr = new_cnstr();
    Cnstr *cnstr_cnstr_data = create_cnstr_cnstr(cnstr_data);
    Cnstr *cnstr_query_cnstr = create_cnstr_query_cnstr(query_cnstr);
    PMode *p_mode = new_p_mode();

    assert(fis_cnstr(cnstr_cnstr_data) && fis_cnstr(cnstr_query_cnstr) &&
	   fis_cnstr(cnstr) && fis_cnstr(NULL));
/*
    assert((CnstrData)cnstr_cnstr_data == *cnstr_data2 &&
	   (QueryCnstr)cnstr_query_cnstr == *query_cnstr2);
*/
    assert(! is_cnstr(p_mode));
    assert(! fis_cnstr(p_mode));
    delete_cnstr_data(cnstr_data2);
    delete_query_cnstr(query_cnstr2);
    delete_cnstr(cnstr);
    delete_cnstr(cnstr_cnstr_data);
    delete_cnstr(cnstr_query_cnstr);
    delete_p_mode(p_mode);
    check_memory_usage("test_cnstr2");
}

Local void test_cnstr3()
{

    Cnstr *cnstr_cnstr_data = create_cnstr_cnstr(new_cnstr_data()), 
          *cnstr_cnstr_data2;
    Cnstr *cnstr_query_cnstr = create_cnstr_query_cnstr(new_query_cnstr()),
          *cnstr_query_cnstr2;

    assert(fis_cnstr_data(cnstr_cnstr_data) && 
	   fis_query_cnstr(cnstr_query_cnstr));
    cnstr_cnstr_data2 = copy_cnstr(cnstr_cnstr_data);
    cnstr_query_cnstr2 = copy_cnstr(cnstr_query_cnstr);
    delete_cnstr(cnstr_cnstr_data);
    delete_cnstr(cnstr_query_cnstr);
    delete_cnstr(cnstr_cnstr_data2);
    delete_cnstr(cnstr_query_cnstr2);
    check_memory_usage("test_cnstr3");
}

Local void test_cnstr4()
{
    Cnstr *cnstr = new_cnstr(), *cnstr2;
    Cnstr *cnstr_cnstr_data = create_cnstr_cnstr(new_cnstr_data()), 
          *cnstr_cnstr_data2;
    Cnstr *cnstr_query_cnstr = create_cnstr_query_cnstr(new_query_cnstr()), 
          *cnstr_query_cnstr2;
    int n;

    n = strcmp(type_name(cnstr->tag), "CNSTR");
    assert(n == 0);
    assert(is_type(cnstr->tag, CNSTR) &&
	   is_type(cnstr_cnstr_data->tag, cnstr->tag) &&
	   is_type(cnstr_query_cnstr->tag, cnstr->tag));
    cnstr2 = (Cnstr*)copy_pseudo_object(cnstr);
    cnstr_cnstr_data2 = (Cnstr*)copy_pseudo_object(cnstr_cnstr_data);
    cnstr_query_cnstr2 = (Cnstr*)copy_pseudo_object(cnstr_query_cnstr);
    print_pseudo_object(cnstr2, fp, INDENT);
    print_pseudo_object(cnstr_cnstr_data2, fp, INDENT);
    print_pseudo_object(cnstr_query_cnstr2, fp, INDENT);
    delete_pseudo_object(cnstr2);
    delete_pseudo_object(cnstr_cnstr_data2);
    delete_pseudo_object(cnstr_query_cnstr2);
    delete_cnstr(cnstr);
    delete_cnstr(cnstr_cnstr_data);
    delete_cnstr(cnstr_query_cnstr);
    check_memory_usage("test_cnstr4");
}

Public void test_cnstr()
{
    printf("testing cnstr...\n");
    test_cnstr1();
    test_cnstr2();
    test_cnstr3();
    test_cnstr4();
}

/*
 CNSTR_DATA
*/

Local void test_cnstr_data1()
{
    CnstrData *cnstr_data = NULL;

    assert(is_cnstr_data(cnstr_data));
    cnstr_data = new_cnstr_data();
    assert(is_cnstr_data(cnstr_data));
    delete_cnstr_data(cnstr_data);
    check_memory_usage("test_cnstr_data1");
}

Local void test_cnstr_data2()
{
    MId *m_id1 = new_o_term(), *m_id12;
    Value *value1 = new_value(), *value12;
    CnRel rel = NULL, rel2;
    MId *m_id2 = new_o_term(), *m_id22;
    Value *value2 = new_value(), *value22;
    CnstrData *cnstr_data = 
      create_cnstr_data(m_id1, value1, rel, m_id2, value2);

    assert(fis_cnstr_data(NULL));
    assert(fis_cnstr_data(cnstr_data));
    assert(! is_cnstr_data(m_id1));
    assert(! fis_cnstr_data(m_id1));
    decompose_cnstr_data(cnstr_data, &m_id12, &value12, 
			 &rel2, &m_id22, &value22);
    assert(m_id12 == m_id1 && value12 == value1 && rel2 == rel &&
	   m_id22 == m_id2 && value22 == value2);
    assert(read_m_id1_inCnstrData(cnstr_data) == m_id1 &&
	   read_value1(cnstr_data) == value1 &&
	   read_rel_inCnstrData(cnstr_data) == rel &&
	   read_m_id2_inCnstrData(cnstr_data) == m_id2 &&
	   read_value2(cnstr_data) == value2);
    assert(mread_m_id1_inCnstrData(cnstr_data) == m_id1 &&
	   mread_value1(cnstr_data) == value1 &&
	   mread_rel_inCnstrData(cnstr_data) == rel &&
	   mread_m_id2_inCnstrData(cnstr_data) == m_id2 &&
	   mread_value2(cnstr_data) == value2);
    delete_cnstr_data(cnstr_data);
    check_memory_usage("test_cnstr_data2");
}

Local void test_cnstr_data3()
{
    CnstrData *cnstr_data = new_cnstr_data();
    MId *m_id1 = new_o_term(), *m_id12;
    Value *value1 = new_value(), *value12;
    CnRel rel = NULL, rel2;
    MId *m_id2 = new_o_term(), *m_id22;
    Value *value2 = new_value(), *value22;

    decompose_cnstr_data(
      set_cnstr_data(cnstr_data, m_id1, value1, rel, m_id2, value2), 
      &m_id12, &value12, &rel2, &m_id22, &value22);			 
    assert(m_id12 == m_id1 && value12 == value1 && rel2 == rel &&
	   m_id22 == m_id2 && value22 == value2);
    delete_cnstr_data(cnstr_data);
    check_memory_usage("test_cnstr_data3");
}

Local void test_cnstr_data4()
{
    CnstrData *cnstr_data = new_cnstr_data(), *cnstr_data2,
              *cnstr_data3 = new_cnstr_data();
    MId *m_id1 = new_o_term(), *m_id12;
    Value *value1 = new_value(), *value12;
    CnRel rel = NULL, rel2;
    MId *m_id2 = new_o_term(), *m_id22;
    Value *value2 = new_value(), *value22;

    decompose_cnstr_data(
      write_m_id1_inCnstrData(
        write_value1(
          write_rel_inCnstrData(
            write_m_id2_inCnstrData(
              write_value2(cnstr_data, value2),
              m_id2),
            rel),
          value1),
        m_id1),
      &m_id12, &value12, &rel2, &m_id22, &value22);			 
    assert(m_id12 == m_id1 && value12 == value1 && rel2 == rel &&
	   m_id22 == m_id2 && value22 == value2);
    m_id1 = new_o_term();
    value1 = new_value();
    rel = NULL;
    m_id2 = new_o_term();
    value2 = new_value();
    decompose_cnstr_data(
      write_m_id1_inCnstrData(
        write_value1(
          write_rel_inCnstrData(
            write_m_id2_inCnstrData(
              write_value2(cnstr_data3, value2),
              m_id2),
            rel),
          value1),
        m_id1),
      &m_id12, &value12, &rel2, &m_id22, &value22);			 
    decompose_cnstr_data(cnstr_data3, &m_id12, &value12, &rel2, 
			 &m_id22, &value22);			 
    assert(m_id12 == m_id1 && value12 == value1 && rel2 == rel &&
	   m_id22 == m_id2 && value22 == value2);
    cnstr_data2 = copy_cnstr_data(cnstr_data);
    delete_cnstr_data(cnstr_data);
    delete_cnstr_data(cnstr_data2);
    delete_cnstr_data(cnstr_data3);
    check_memory_usage("test_cnstr_data4");
}


Local void test_cnstr_data5()
{
    CnstrData *cnstr_data = new_cnstr_data(), *cnstr_data2;
    MId *m_id1 = new_o_term();
    Value *value1 = new_value();
    CnRel rel = NULL;
    MId *m_id2 = new_o_term();
    Value *value2 = new_value();
    int n;

    n = strcmp(type_name(cnstr_data->tag), "CNSTR_DATA");
    assert(n == 0);
    assert(is_type(cnstr_data->tag, CNSTR_DATA));
    cnstr_data2 = (CnstrData*)copy_pseudo_object
      (set_cnstr_data(cnstr_data, m_id1, value1, rel, m_id2, value2));
    print_pseudo_object(cnstr_data2, fp, INDENT);
    delete_pseudo_object(cnstr_data2);
    delete_cnstr_data(cnstr_data);
    check_memory_usage("test_cnstr_data5");
}

Public void test_cnstr_data()
{
    printf("testing cnstr_data...\n");
    test_cnstr_data1();
    test_cnstr_data2();
    test_cnstr_data3();
    test_cnstr_data4();
    test_cnstr_data5();
}


/*
 QUERY_CNSTR
*/

Local void test_query_cnstr1()
{
    QueryCnstr *query_cnstr = NULL;

    assert(is_query_cnstr(query_cnstr));
    query_cnstr = new_query_cnstr();
    assert(is_query_cnstr(query_cnstr));
    delete_query_cnstr(query_cnstr);
    check_memory_usage("test_query_cnstr1");
}

Local void test_query_cnstr2()
{
    MId *m_id1 = new_o_term(), *m_id12;
    MId *m_id2 = new_o_term(), *m_id22;
    QueryCnstr *query_cnstr = create_query_cnstr(m_id1, m_id2);

    assert(fis_query_cnstr(NULL));
    assert(fis_query_cnstr(query_cnstr));
    assert(! is_query_cnstr(m_id1));
    assert(! fis_query_cnstr(m_id1));
    decompose_query_cnstr(query_cnstr, &m_id12, &m_id22);
    assert(m_id12 == m_id1 && m_id22 == m_id2);
    assert(read_m_id1_inQueryCnstr(query_cnstr) == m_id1 &&
	   read_m_id2_inQueryCnstr(query_cnstr) == m_id2);
    assert(mread_m_id1_inQueryCnstr(query_cnstr) == m_id1 &&
	   mread_m_id2_inQueryCnstr(query_cnstr) == m_id2);
    delete_query_cnstr(query_cnstr);
    check_memory_usage("test_query_cnstr2");
}

Local void test_query_cnstr3()
{
    QueryCnstr *query_cnstr = new_query_cnstr();
    MId *m_id1 = new_o_term(), *m_id12;
    MId *m_id2 = new_o_term(), *m_id22;

    decompose_query_cnstr(
      set_query_cnstr(query_cnstr, m_id1, m_id2), 
      &m_id12, &m_id22);
    assert(m_id12 == m_id1 && m_id22 == m_id2);
    delete_query_cnstr(query_cnstr);
    check_memory_usage("test_query_cnstr3");
}

Local void test_query_cnstr4()
{
    QueryCnstr *query_cnstr = new_query_cnstr(), *query_cnstr2,
               *query_cnstr3 = new_query_cnstr();
    MId *m_id1 = new_o_term(), *m_id12;
    MId *m_id2 = new_o_term(), *m_id22;

    decompose_query_cnstr(
      write_m_id1_inQueryCnstr(
        write_m_id2_inQueryCnstr(query_cnstr, m_id2),
        m_id1),
      &m_id12, &m_id22);
    assert(m_id12 == m_id1 && m_id22 == m_id2);
    m_id1 = new_o_term();
    m_id2 = new_o_term();
    decompose_query_cnstr(
      mwrite_m_id1_inQueryCnstr(
        mwrite_m_id2_inQueryCnstr(query_cnstr3, m_id2),
        m_id1),
      &m_id12, &m_id22);
    assert(m_id12 == m_id1 && m_id22 == m_id2);
    query_cnstr2 = copy_query_cnstr(query_cnstr);
    delete_query_cnstr(query_cnstr);
    delete_query_cnstr(query_cnstr2);
    delete_query_cnstr(query_cnstr3);
    check_memory_usage("test_query_cnstr4");
}

Local void test_query_cnstr5()
{
    QueryCnstr *query_cnstr = new_query_cnstr(), *query_cnstr2;
    MId *m_id1 = new_o_term();
    MId *m_id2 = new_o_term();
    int n;

    n = strcmp(type_name(query_cnstr->tag), "QUERY_CNSTR");
    assert(n == 0);
    assert(is_type(query_cnstr->tag, QUERY_CNSTR));
    query_cnstr2 = (QueryCnstr*)copy_pseudo_object
      (set_query_cnstr(query_cnstr, m_id1, m_id2));
    print_pseudo_object(query_cnstr2, fp, INDENT);
    delete_pseudo_object(query_cnstr2);
    delete_query_cnstr(query_cnstr);
    check_memory_usage("test_query_cnstr5");
}

Public void test_query_cnstr()
{
    printf("testing query_cnstr...\n");
    test_query_cnstr1();
    test_query_cnstr2();
    test_query_cnstr3();
    test_query_cnstr4();
    test_query_cnstr5();
}

/*
 PROLOG (have ObjList)
*/

Local void test_prolog1()
{
    Prolog *prolog = NULL;

    assert(is_prolog(prolog));
    prolog = new_prolog();
    assert(is_prolog(prolog));
    delete_prolog(prolog);
    check_memory_usage("test_prolog1");
}

#define TEST_HEAD_IN_PROLOG "head in prolog"

Local void test_prolog2()
{
    char *head = dotsrc_malloc(strlen(TEST_HEAD_IN_PROLOG) + 1), *head2;
    ObjList *o_terms = new_obj_list(O_TERM), *o_terms2;
    Prolog *prolog = create_prolog(head, o_terms);

    strcpy(head, TEST_HEAD_IN_PROLOG);
    assert(fis_prolog(NULL));
    assert(fis_prolog(prolog));
    assert(! is_prolog(o_terms));
    assert(! fis_prolog(o_terms));
    decompose_prolog(prolog, &head2, &o_terms2);
    assert(head2 == head && o_terms2 == o_terms);
    assert(read_head_inProlog(prolog) == head &&
	   read_o_terms_inProlog(prolog) == o_terms);
    assert(mread_head_inProlog(prolog) == head &&
	   mread_o_terms_inProlog(prolog) == o_terms);
    delete_prolog(prolog);
    check_memory_usage("test_prolog2");
}

Local void test_prolog3()
{
    Prolog *prolog = new_prolog();
    char *head = dotsrc_malloc(strlen(TEST_HEAD_IN_PROLOG)), *head2;
    ObjList *o_terms = new_obj_list(O_TERM), *o_terms2;

    strcpy(head, TEST_HEAD_IN_PROLOG);
    decompose_prolog(
      set_prolog(prolog, head, o_terms), 
      &head2, &o_terms2);
    assert(head2 == head && o_terms2 == o_terms);
    delete_prolog(prolog);
    check_memory_usage("test_prolog3");
}

Local void test_prolog4()
{
    Prolog *prolog = new_prolog(), *prolog2, *prolog3 = new_prolog();
    char *head = dotsrc_malloc(strlen(TEST_HEAD_IN_PROLOG)), *head2;
    ObjList *o_terms = new_obj_list(O_TERM), *o_terms2;

    strcpy(head, TEST_HEAD_IN_PROLOG);
    decompose_prolog(
      write_head_inProlog(
	  write_o_terms_inProlog(prolog, o_terms),
        head),
      &head2, &o_terms2);
    assert(head2 == head && o_terms2 == o_terms);
    head = dotsrc_malloc(strlen(TEST_HEAD_IN_PROLOG));
    o_terms = new_obj_list(O_TERM);
    strcpy(head, TEST_HEAD_IN_PROLOG);
    decompose_prolog(
      mwrite_head_inProlog(
	  mwrite_o_terms_inProlog(prolog3, o_terms),
        head),
      &head2, &o_terms2);
    assert(head2 == head && o_terms2 == o_terms);
    prolog2 = copy_prolog(prolog);
    delete_prolog(prolog);
    delete_prolog(prolog2);
    delete_prolog(prolog3);
    check_memory_usage("test_prolog4");
}

Local void test_prolog5()
{
    Prolog *prolog;
    ObjList *obj_list, *obj_list2;
    OTerm *o_term, *o_term2, *o_term3, *o_term4;

    prolog = new_prolog();
    obj_list = new_obj_list(O_TERM);
    obj_list2 = new_obj_list(O_TERM);
    o_term = new_o_term();
    o_term2 = new_o_term();
    o_term3 = new_o_term();
    o_term4 = new_o_term();
    append_to_obj_list(append_to_obj_list(obj_list, o_term), o_term2);
    append_to_obj_list(append_to_obj_list(obj_list2, o_term3), o_term4);
    insert_o_terms_inProlog(insert_o_terms_inProlog(prolog, obj_list2), 
			      obj_list);
    assert(car_of_o_terms_inProlog(prolog) == o_term &&
	   car_of_o_terms_inProlog(prolog) == o_term2 &&
	   car_of_o_terms_inProlog(prolog) == o_term3 &&
	   car_of_o_terms_inProlog(prolog) == o_term4);

    obj_list = new_obj_list(O_TERM);
    obj_list2 = new_obj_list(O_TERM);
    cons_to_obj_list(cons_to_obj_list(obj_list, o_term), o_term2);
    cons_to_obj_list(cons_to_obj_list(obj_list2, o_term3), o_term4);
    add_o_terms_inProlog(add_o_terms_inProlog(prolog, obj_list2), obj_list);
    assert(car_of_o_terms_inProlog(prolog) == o_term4 &&
	   car_of_o_terms_inProlog(prolog) == o_term3 &&
	   car_of_o_terms_inProlog(prolog) == o_term2 &&
	   car_of_o_terms_inProlog(prolog) == o_term);
    delete_o_term(o_term);
    delete_o_term(o_term2);
    delete_o_term(o_term3);
    delete_o_term(o_term4);
    delete_prolog(prolog);
    check_memory_usage("test_prolog5");
}

Local void test_prolog6()
{
    Prolog *prolog = new_prolog(), *prolog2;
    char *head = dotsrc_malloc(strlen(TEST_HEAD_IN_PROLOG));
    ObjList *o_terms = new_obj_list(O_TERM);
    int n;

    strcpy(head, TEST_HEAD_IN_PROLOG);
    n = strcmp(type_name(prolog->tag), "PROLOG");
    assert(n == 0);
    assert(is_type(prolog->tag, PROLOG));
    prolog2 = (Prolog*)copy_pseudo_object
      (set_prolog(prolog, head, o_terms));
    print_pseudo_object(prolog2, fp, INDENT);
    delete_pseudo_object(prolog2);
    delete_prolog(prolog);
    check_memory_usage("test_prolog6");
}

Public void test_prolog()
{
    printf("testing prolog...\n");
    test_prolog1();
    test_prolog2();
    test_prolog3();
    test_prolog4();
    test_prolog5();
    test_prolog6();
}


/*
 VAR
*/

Local void test_var1()
{
    Var *var = NULL;

    assert(is_var(var));
    var = new_var();
    assert(is_var(var));
    delete_var(var);
    check_memory_usage("test_var1");
}

#define TEST_VAR_DATA "Variable"

Local void test_var2()
{
    VarType type = NULL, type2;
    char *var_data = dotsrc_malloc(strlen(TEST_VAR_DATA) + 1), *var_data2;
    Var *var = create_var(type, var_data);
    Sort *sort = new_sort();

    strcpy(var_data, TEST_VAR_DATA);
    assert(fis_var(NULL));
    assert(fis_var(var));
    assert(! is_var(sort));
    assert(! fis_var(sort));
    decompose_var(var, &type2, &var_data2);
    assert(type2 == type && var_data2 == var_data);
    assert(read_type(var) == type &&
	   read_var_data(var) == var_data);
    assert(mread_type(var) == type &&
	   mread_var_data(var) == var_data);
    delete_var(var);
    delete_sort(sort);
    check_memory_usage("test_var2");
}

Local void test_var3()
{
    Var *var = new_var();
    VarType type = NULL, type2;
    char *var_data = dotsrc_malloc(strlen(TEST_VAR_DATA)), *var_data2;

    strcpy(var_data, TEST_VAR_DATA);
    decompose_var(
      set_var(var, type, var_data), 
      &type2, &var_data2);
    assert(type2 == type && var_data2 == var_data);
    delete_var(var);
    check_memory_usage("test_var3");
}

Local void test_var4()
{
    Var *var = new_var(), *var2, *var3 = new_var();
    VarType type = NULL, type2;
    char *var_data = dotsrc_malloc(strlen(TEST_VAR_DATA)), *var_data2;

    strcpy(var_data, TEST_VAR_DATA);
    decompose_var(
      write_type(write_var_data(var, var_data), type),
      &type2, &var_data2);
    assert(type2 == type && var_data2 == var_data);
    type = NULL;
    var_data = dotsrc_malloc(strlen(TEST_VAR_DATA));
    strcpy(var_data, TEST_VAR_DATA);
    decompose_var(
      mwrite_type(mwrite_var_data(var3, var_data), type),
      &type2, &var_data2);
    assert(type2 == type && var_data2 == var_data);
    var2 = copy_var(var);
    delete_var(var);
    delete_var(var2);
    delete_var(var3);
    check_memory_usage("test_var4");
}


Local void test_var5()
{
    Var *var = new_var(), *var2;
    VarType type = NULL;
    char *var_data = dotsrc_malloc(strlen(TEST_VAR_DATA));
    int n;

    strcpy(var_data, TEST_VAR_DATA);
    n = strcmp(type_name(var->tag), "VAR");
    assert(n == 0);
    assert(is_type(var->tag, VAR));
    var2 = (Var*)copy_pseudo_object(set_var(var, type, var_data));
    print_pseudo_object(var2, fp, INDENT);
    delete_pseudo_object(var2);
    delete_var(var);
    check_memory_usage("test_var5");
}

Public void test_var()
{
    printf("testing var...\n");
    test_var1();
    test_var2();
    test_var3();
    test_var4();
    test_var5();
}

/*
 SORT
*/

Local void test_sort1()
{
    Sort *sort = NULL;

    assert(is_sort(sort));
    sort = new_sort();
    assert(is_sort(sort));
    delete_sort(sort);
    check_memory_usage("test_sort1");
}

Local void test_sort2()
{
    Prolog *prolog = new_prolog(), *prolog2;
    Sort *sort = create_sort(prolog);

    assert(fis_sort(NULL));
    assert(fis_sort(sort));
    assert(! is_sort(prolog));
    assert(! fis_sort(prolog));
    decompose_sort(sort, &prolog2);
    assert(prolog2 == prolog);
    assert(read_prolog(sort) == prolog);
    assert(mread_prolog(sort) == prolog);
    delete_sort(sort);
    check_memory_usage("test_sort2");
}

Local void test_sort3()
{
    Sort *sort = new_sort();
    Prolog *prolog = new_prolog(), *prolog2;

    decompose_sort(set_sort(sort, prolog), &prolog2);
    assert(prolog2 == prolog);
    delete_sort(sort);
    check_memory_usage("test_sort3");
}

Local void test_sort4()
{
    Sort *sort = new_sort(), *sort2, *sort3 = new_sort();
    Prolog *prolog = new_prolog(), *prolog2;

    decompose_sort(write_prolog(sort, prolog), &prolog2);
    assert(prolog2 == prolog);
    prolog = new_prolog();
    decompose_sort(mwrite_prolog(sort, prolog), &prolog2);
    assert(prolog2 == prolog);
    sort2 = copy_sort(sort);
    delete_sort(sort);
    delete_sort(sort2);
    delete_sort(sort3);
    check_memory_usage("test_sort4");
}

Local void test_sort5()
{
    Sort *sort = new_sort(), *sort2;
    Prolog *prolog = new_prolog();
    int n;

    n = strcmp(type_name(sort->tag), "SORT");
    assert(n == 0);
    assert(is_type(sort->tag, SORT));
    sort2 = (Sort*)copy_pseudo_object(set_sort(sort, prolog));
    print_pseudo_object(sort2, fp, INDENT);
    delete_pseudo_object(sort2);
    delete_sort(sort);
    check_memory_usage("test_sort5");
}

Public void test_sort()
{
    printf("testing sort...\n");
    test_sort1();
    test_sort2();
    test_sort3();
    test_sort4();
    test_sort5();
}

/*
 QUERY (have ObjList)
*/

Local void test_query1()
{
    Query *query = NULL;

    assert(is_query(query));
    query = new_query();
    assert(is_query(query));
    delete_query(query);
    check_memory_usage("test_query1");
}

Local void test_query2()
{
    RuleClass query_class = NULL, query_class2;
    ATerm *q_head = new_a_term(), *q_head2;
    ObjList *clusters = new_obj_list(CLUSTER), *clusters2;
    ObjList *cnstrs = new_obj_list(CNSTR), *cnstrs2;
    ObjList *q_modes = new_obj_list(Q_MODE), *q_modes2;
    Program *program = new_program(), *program2;
    Query *query = 
      create_query(query_class, q_head, clusters, cnstrs, q_modes, program);

    assert(fis_query(NULL));
    assert(fis_query(query));
    assert(! is_query(clusters));
    assert(! fis_query(clusters));
    decompose_query(query, &query_class2, &q_head2, &clusters2, &cnstrs2, 
		    &q_modes2, &program2);
    assert(query_class2 == query_class && q_head2 == q_head &&
	   clusters2 == clusters && cnstrs2 == cnstrs && 
	   q_modes2 == q_modes && program2 == program);
    assert(read_query_class(query) == query_class &&
	   read_q_head(query) == q_head &&
	   read_clusters_inQuery(query) == clusters &&
	   read_cnstrs_inQuery(query) == cnstrs &&
	   read_q_modes(query) == q_modes &&
	   read_program_inQuery(query) == program);
    assert(mread_query_class(query) == query_class &&
	   mread_q_head(query) == q_head &&
	   mread_clusters_inQuery(query) == clusters &&
	   mread_cnstrs_inQuery(query) == cnstrs &&
	   mread_q_modes(query) == q_modes &&
	   mread_program_inQuery(query) == program);
    delete_query(query);
    check_memory_usage("test_query2");
}

Local void test_query3()
{
    Query *query = new_query();
    RuleClass query_class = NULL, query_class2;
    ATerm *q_head = new_a_term(), *q_head2;
    ObjList *clusters = new_obj_list(CLUSTER), *clusters2;
    ObjList *cnstrs = new_obj_list(CNSTR), *cnstrs2;
    ObjList *q_modes = new_obj_list(Q_MODE), *q_modes2;
    Program *program = new_program(), *program2;

    decompose_query(
      set_query(query, query_class, q_head, clusters, cnstrs, 
		q_modes, program),
      &query_class2, &q_head2, &clusters2, &cnstrs2, &q_modes2, &program2);
    assert(query_class2 == query_class && q_head2 == q_head &&
	   clusters2 == clusters && cnstrs2 == cnstrs && 
	   q_modes2 == q_modes && program2 == program);
    delete_query(query);
    check_memory_usage("test_query3");
}

Local void test_query4()
{
    Query *query = new_query(), *query2, *query3 = new_query();
    RuleClass query_class = NULL, query_class2;
    ATerm *q_head = new_a_term(), *q_head2;
    ObjList *clusters = new_obj_list(CLUSTER), *clusters2;
    ObjList *cnstrs = new_obj_list(CNSTR), *cnstrs2;
    ObjList *q_modes = new_obj_list(Q_MODE), *q_modes2;
    Program *program = new_program(), *program2;

    decompose_query(
      write_query_class(
        write_q_head(			
          write_clusters_inQuery(
            write_cnstrs_inQuery(
              write_q_modes(
                write_program_inQuery(query, program),
                q_modes),
              cnstrs),
            clusters),
          q_head),
        query_class),
      &query_class2, &q_head2, &clusters2, &cnstrs2, &q_modes2, &program2);
    assert(query_class2 == query_class && q_head2 == q_head &&
	   clusters2 == clusters && cnstrs2 == cnstrs && 
	   q_modes2 == q_modes && program2 == program);
    query_class = NULL;
    q_head = new_a_term();
    clusters = new_obj_list(CLUSTER);
    cnstrs = new_obj_list(CNSTR);
    q_modes = new_obj_list(Q_MODE);
    program = new_program();
    mwrite_query_class(mwrite_q_head(query3, q_head), query_class);
    mwrite_clusters_inQuery(mwrite_cnstrs_inQuery(query3, cnstrs), clusters);
    mwrite_q_modes(mwrite_program_inQuery(query3, program), q_modes);
    decompose_query(query3, &query_class2, &q_head2, &clusters2, 
		    &cnstrs2, &q_modes2, &program2);
    assert(query_class2 == query_class && q_head2 == q_head &&
	   clusters2 == clusters && cnstrs2 == cnstrs && 
	   q_modes2 == q_modes && program2 == program);
    query2 = copy_query(query);
    delete_query(query);
    delete_query(query2);
    delete_query(query3);
    check_memory_usage("test_query4");
}

Local void test_query5()
{
    Query *query;
    ObjList *obj_list, *obj_list2, *obj_list3, *obj_list4, 
            *obj_list5, *obj_list6;
    Cluster *cluster, *cluster2, *cluster3, *cluster4;
    Cnstr *cnstr, *cnstr2, *cnstr3, *cnstr4;
    QMode *q_mode, *q_mode2, *q_mode3, *q_mode4;

    query = new_query();
    obj_list = new_obj_list(CLUSTER);
    obj_list2 = new_obj_list(CLUSTER);
    obj_list3 = new_obj_list(CNSTR);
    obj_list4 = new_obj_list(CNSTR);
    obj_list5 = new_obj_list(Q_MODE);
    obj_list6 = new_obj_list(Q_MODE);
    cluster = new_cluster();
    cluster2 = new_cluster();
    cluster3 = new_cluster();
    cluster4 = new_cluster();
    cnstr = new_cnstr();
    cnstr2 = new_cnstr();
    cnstr3 = new_cnstr();
    cnstr4 = new_cnstr();
    q_mode = new_q_mode();
    q_mode2 = new_q_mode();
    q_mode3 = new_q_mode();
    q_mode4 = new_q_mode();
    append_to_obj_list(append_to_obj_list(obj_list, cluster), cluster2);
    append_to_obj_list(append_to_obj_list(obj_list2, cluster3), cluster4);
    append_to_obj_list(append_to_obj_list(obj_list3, cnstr), cnstr2);
    append_to_obj_list(append_to_obj_list(obj_list4, cnstr3), cnstr4);
    append_to_obj_list(append_to_obj_list(obj_list5, q_mode), q_mode2);
    append_to_obj_list(append_to_obj_list(obj_list6, q_mode3), q_mode4);
    insert_clusters(insert_clusters(query, obj_list2), obj_list);
    insert_cnstrs(insert_cnstrs(query, obj_list4), obj_list3);
    insert_q_modes(insert_q_modes(query, obj_list6), obj_list5);
    assert(car_of_clusters(query) == cluster &&
	   car_of_clusters(query) == cluster2 &&
	   car_of_clusters(query) == cluster3 &&
	   car_of_clusters(query) == cluster4);
    assert(car_of_cnstrs(query) == cnstr &&
	   car_of_cnstrs(query) == cnstr2 &&
	   car_of_cnstrs(query) == cnstr3 &&
	   car_of_cnstrs(query) == cnstr4);
    assert(car_of_q_modes(query) == q_mode &&
	   car_of_q_modes(query) == q_mode2 &&
	   car_of_q_modes(query) == q_mode3 &&
	   car_of_q_modes(query) == q_mode4);

    obj_list = new_obj_list(CLUSTER);
    obj_list2 = new_obj_list(CLUSTER);
    obj_list3 = new_obj_list(CNSTR);
    obj_list4 = new_obj_list(CNSTR);
    obj_list5 = new_obj_list(Q_MODE);
    obj_list6 = new_obj_list(Q_MODE);
    cons_to_obj_list(cons_to_obj_list(obj_list, cluster), cluster2);
    cons_to_obj_list(cons_to_obj_list(obj_list2, cluster3), cluster4);
    cons_to_obj_list(cons_to_obj_list(obj_list3, cnstr), cnstr2);
    cons_to_obj_list(cons_to_obj_list(obj_list4, cnstr3), cnstr4);
    cons_to_obj_list(cons_to_obj_list(obj_list5, q_mode), q_mode2);
    cons_to_obj_list(cons_to_obj_list(obj_list6, q_mode3), q_mode4);
    add_clusters(add_clusters(query, obj_list2), obj_list);
    add_cnstrs(add_cnstrs(query, obj_list4), obj_list3);
    add_q_modes(add_q_modes(query, obj_list6), obj_list5);
    assert(car_of_clusters(query) == cluster4 &&
	   car_of_clusters(query) == cluster3 &&
	   car_of_clusters(query) == cluster2 &&
	   car_of_clusters(query) == cluster);
    assert(car_of_cnstrs(query) == cnstr4 &&
	   car_of_cnstrs(query) == cnstr3 &&
	   car_of_cnstrs(query) == cnstr2 &&
	   car_of_cnstrs(query) == cnstr);
    assert(car_of_q_modes(query) == q_mode4 &&
	   car_of_q_modes(query) == q_mode3 &&
	   car_of_q_modes(query) == q_mode2 &&
	   car_of_q_modes(query) == q_mode);
    delete_cluster(cluster);
    delete_cluster(cluster2);
    delete_cluster(cluster3);
    delete_cluster(cluster4);
    delete_cnstr(cnstr);
    delete_cnstr(cnstr2);
    delete_cnstr(cnstr3);
    delete_cnstr(cnstr4);
    delete_q_mode(q_mode);
    delete_q_mode(q_mode2);
    delete_q_mode(q_mode3);
    delete_q_mode(q_mode4);
    delete_query(query);
    check_memory_usage("test_query5");
}

Local void test_query6()
{
    Query *query = new_query(), *query2;
    RuleClass query_class = NULL;
    ATerm *q_head = new_a_term();
    ObjList *clusters = new_obj_list(CLUSTER);
    ObjList *cnstrs = new_obj_list(CNSTR);
    ObjList *q_modes = new_obj_list(Q_MODE);
    Program *program = new_program();
    int n;

    n = strcmp(type_name(query->tag), "QUERY");
    assert(n == 0);
    assert(is_type(query->tag, QUERY));
    query2 = (Query*)copy_pseudo_object
      (set_query(query, query_class, q_head, clusters, cnstrs, 
		 q_modes, program));
    print_pseudo_object(query2, fp, INDENT);
    delete_pseudo_object(query2);
    delete_query(query);
    check_memory_usage("test_query6");
}

Public void test_query()
{
    printf("testing query...\n");
    test_query1();
    test_query2();
    test_query3();
    test_query4();
    test_query5();
    test_query6();
}

/*
 Q_MODE (union)
*/

Local void test_q_mode1()
{
    QMode *q_mode = NULL;

    assert(is_q_mode(q_mode));
    q_mode = new_q_mode();
    assert(is_q_mode(q_mode));
    delete_q_mode(q_mode);
    check_memory_usage("test_q_mode1");
}

Local void test_q_mode2()
{
    PMode *p_mode = new_p_mode(), *p_mode2 = copy_p_mode(p_mode);
    AMode *a_mode = new_a_mode(), *a_mode2 = copy_a_mode(a_mode);
    IMode *i_mode = new_i_mode(), *i_mode2 = copy_i_mode(i_mode);
    MMode *m_mode = new_m_mode(), *m_mode2 = copy_m_mode(m_mode);
    EMode *e_mode = new_e_mode(), *e_mode2 = copy_e_mode(e_mode);
    QMode *q_mode = new_q_mode();
    QMode *q_mode_p_mode = create_q_mode_p_mode(p_mode);
    QMode *q_mode_a_mode = create_q_mode_a_mode(a_mode);
    QMode *q_mode_i_mode = create_q_mode_i_mode(i_mode);
    QMode *q_mode_m_mode = create_q_mode_m_mode(m_mode);
    QMode *q_mode_e_mode = create_q_mode_e_mode(e_mode);
    Var *var = new_var();

    assert(fis_q_mode(q_mode_p_mode) && fis_q_mode(q_mode_a_mode) &&
	   fis_q_mode(q_mode_i_mode) && fis_q_mode(q_mode_m_mode) &&
	   fis_q_mode(q_mode_e_mode) && fis_q_mode(q_mode) &&
	   fis_q_mode(NULL));
/*
    assert((PMode)q_mode_p_mode == *p_mode2 && 
	   (AMode)q_mode_a_mode == *a_mode2 &&
	   (IMode)q_mode_i_mode == *i_mode2 &&
	   (MMode)q_mode_m_mode == *m_mode2 &&
	   (EMode)q_mode_e_mode == *e_mode2);
*/
    assert(! is_q_mode(var));
    assert(! fis_q_mode(var));
    delete_p_mode(p_mode2);
    delete_a_mode(a_mode2);
    delete_i_mode(i_mode2);
    delete_m_mode(m_mode2);
    delete_e_mode(e_mode2);
    delete_q_mode(q_mode);
    delete_q_mode(q_mode_p_mode);
    delete_q_mode(q_mode_a_mode);
    delete_q_mode(q_mode_i_mode);
    delete_q_mode(q_mode_m_mode);
    delete_q_mode(q_mode_e_mode);
    delete_var(var);
    check_memory_usage("test_q_mode2");
}

Local void test_q_mode3()
{
    QMode *q_mode_p_mode = create_q_mode_p_mode(new_p_mode()), 
          *q_mode_p_mode2;
    QMode *q_mode_a_mode = create_q_mode_a_mode(new_a_mode()), 
          *q_mode_a_mode2;
    QMode *q_mode_i_mode = create_q_mode_i_mode(new_i_mode()), 
          *q_mode_i_mode2;
    QMode *q_mode_m_mode = create_q_mode_m_mode(new_m_mode()), 
          *q_mode_m_mode2;
    QMode *q_mode_e_mode = create_q_mode_e_mode(new_e_mode()), 
          *q_mode_e_mode2;

    assert(fis_p_mode(q_mode_p_mode) && fis_a_mode(q_mode_a_mode) &&
	   fis_i_mode(q_mode_i_mode) && fis_m_mode(q_mode_m_mode) &&
	   fis_e_mode(q_mode_e_mode));
    q_mode_p_mode2 = copy_q_mode(q_mode_p_mode);
    q_mode_a_mode2 = copy_q_mode(q_mode_a_mode);
    q_mode_i_mode2 = copy_q_mode(q_mode_i_mode);
    q_mode_m_mode2 = copy_q_mode(q_mode_m_mode);
    q_mode_e_mode2 = copy_q_mode(q_mode_e_mode);
    delete_q_mode(q_mode_p_mode);
    delete_q_mode(q_mode_a_mode);
    delete_q_mode(q_mode_i_mode);
    delete_q_mode(q_mode_m_mode);
    delete_q_mode(q_mode_e_mode);
    delete_q_mode(q_mode_p_mode2);
    delete_q_mode(q_mode_a_mode2);
    delete_q_mode(q_mode_i_mode2);
    delete_q_mode(q_mode_m_mode2);
    delete_q_mode(q_mode_e_mode2);
    check_memory_usage("test_q_mode3");
}

Local void test_q_mode4()
{
    QMode *q_mode = new_q_mode(), *q_mode2;
    QMode *q_mode_p_mode = create_q_mode_p_mode(new_p_mode()), 
          *q_mode_p_mode2;
    QMode *q_mode_a_mode = create_q_mode_a_mode(new_a_mode()), 
          *q_mode_a_mode2;
    QMode *q_mode_i_mode = create_q_mode_i_mode(new_i_mode()), 
          *q_mode_i_mode2;
    QMode *q_mode_m_mode = create_q_mode_m_mode(new_m_mode()), 
          *q_mode_m_mode2;
    QMode *q_mode_e_mode = create_q_mode_e_mode(new_e_mode()), 
          *q_mode_e_mode2;
    int n;

    n = strcmp(type_name(q_mode->tag), "Q_MODE");
    assert(n == 0);
    assert(is_type(q_mode->tag, Q_MODE) &&
	   is_type(q_mode_p_mode->tag, q_mode->tag) &&
	   is_type(q_mode_a_mode->tag, q_mode->tag) &&
	   is_type(q_mode_i_mode->tag, q_mode->tag) &&
	   is_type(q_mode_m_mode->tag, q_mode->tag) &&
	   is_type(q_mode_e_mode->tag, q_mode->tag));
    q_mode2 = (QMode*)copy_pseudo_object(q_mode);
    q_mode_p_mode2 = (QMode*)copy_pseudo_object(q_mode_p_mode);
    q_mode_a_mode2 = (QMode*)copy_pseudo_object(q_mode_a_mode);
    q_mode_i_mode2 = (QMode*)copy_pseudo_object(q_mode_i_mode);
    q_mode_m_mode2 = (QMode*)copy_pseudo_object(q_mode_m_mode);
    q_mode_e_mode2 = (QMode*)copy_pseudo_object(q_mode_e_mode);
    print_pseudo_object(q_mode2, fp, INDENT);
    print_pseudo_object(q_mode_p_mode2, fp, INDENT);
    print_pseudo_object(q_mode_a_mode2, fp, INDENT);
    print_pseudo_object(q_mode_i_mode2, fp, INDENT);
    print_pseudo_object(q_mode_m_mode2, fp, INDENT);
    print_pseudo_object(q_mode_e_mode2, fp, INDENT);
    delete_pseudo_object(q_mode2);
    delete_pseudo_object(q_mode_p_mode2);
    delete_pseudo_object(q_mode_a_mode2);
    delete_pseudo_object(q_mode_i_mode2);
    delete_pseudo_object(q_mode_m_mode2);
    delete_pseudo_object(q_mode_e_mode2);
    delete_q_mode(q_mode);
    delete_q_mode(q_mode_p_mode);
    delete_q_mode(q_mode_a_mode);
    delete_q_mode(q_mode_i_mode);
    delete_q_mode(q_mode_m_mode);
    delete_q_mode(q_mode_e_mode);
    check_memory_usage("test_q_mode4");
}

Public void test_q_mode()
{
    printf("testing q_mode...\n");
    test_q_mode1();
    test_q_mode2();
    test_q_mode3();
    test_q_mode4();
}

/*
 P_MODE
*/

Local void test_p_mode1()
{
    PMode *p_mode = NULL;

    assert(is_p_mode(p_mode));
    p_mode = new_p_mode();
    assert(is_p_mode(p_mode));
    delete_p_mode(p_mode);
    check_memory_usage("test_p_mode1");
}

Local void test_p_mode2()
{
    PModeData p_mode_data = NULL, p_mode_data2;
    PMode *p_mode = create_p_mode(p_mode_data);
    Var *var = new_var();

    assert(fis_p_mode(NULL));
    assert(fis_p_mode(p_mode));
    assert(! is_p_mode(var));
    assert(! fis_p_mode(var));
    decompose_p_mode(p_mode, &p_mode_data2);
    assert(p_mode_data2 == p_mode_data);
    assert(read_p_mode_data(p_mode) == p_mode_data);
    assert(mread_p_mode_data(p_mode) == p_mode_data);
    delete_p_mode(p_mode);
    delete_var(var);
    check_memory_usage("test_p_mode2");
}

Local void test_p_mode3()
{
    PMode *p_mode = new_p_mode();
    PModeData p_mode_data = NULL, p_mode_data2;

    decompose_p_mode(set_p_mode(p_mode, p_mode_data), &p_mode_data2);
    assert(p_mode_data2 == p_mode_data);
    delete_p_mode(p_mode);
    check_memory_usage("test_p_mode3");
}

Local void test_p_mode4()
{
    PMode *p_mode = new_p_mode(), *p_mode2, *p_mode3 = new_p_mode();
    PModeData p_mode_data = NULL, p_mode_data2;

    decompose_p_mode(write_p_mode_data(p_mode, p_mode_data), &p_mode_data2);
    assert(p_mode_data2 == p_mode_data);
    p_mode_data = NULL;
    decompose_p_mode(mwrite_p_mode_data(p_mode3, p_mode_data), &p_mode_data2);
    assert(p_mode_data2 == p_mode_data);
    p_mode2 = copy_p_mode(p_mode);
    delete_p_mode(p_mode);
    delete_p_mode(p_mode2);
    delete_p_mode(p_mode3);
    check_memory_usage("test_p_mode4");
}

Local void test_p_mode5()
{
    PMode *p_mode = new_p_mode(), *p_mode2;
    PModeData p_mode_data = NULL;
    int n;

    n = strcmp(type_name(p_mode->tag), "P_MODE");
    assert(n == 0);
    assert(is_type(p_mode->tag, P_MODE));
    p_mode2 = (PMode*)copy_pseudo_object(set_p_mode(p_mode, p_mode_data));
    print_pseudo_object(p_mode2, fp, INDENT);
    delete_pseudo_object(p_mode2);
    delete_p_mode(p_mode);
    check_memory_usage("test_p_mode5");
}

Public void test_p_mode()
{
    printf("testing p_mode...\n");
    test_p_mode1();
    test_p_mode2();
    test_p_mode3();
    test_p_mode4();
    test_p_mode5();
}

/*
 A_MODE
*/

Local void test_a_mode1()
{
    AMode *a_mode = NULL;

    assert(is_a_mode(a_mode));
    a_mode = new_a_mode();
    assert(is_a_mode(a_mode));
    delete_a_mode(a_mode);
    check_memory_usage("test_a_mode1");
}

Local void test_a_mode2()
{
    AModeData a_mode_data = NULL, a_mode_data2;
    AMode *a_mode = create_a_mode(a_mode_data);
    Var *var = new_var();

    assert(fis_a_mode(NULL)); 
    assert(fis_a_mode(a_mode)); 
    assert(! is_a_mode(var)); 
    assert(! fis_a_mode(var)); 
    decompose_a_mode(a_mode, &a_mode_data2); 
    assert(a_mode_data2 == a_mode_data);
    assert(read_a_mode_data(a_mode) == a_mode_data);
    assert(mread_a_mode_data(a_mode) == a_mode_data);
    delete_a_mode(a_mode); delete_var(var);
    check_memory_usage("test_a_mode2"); 
}

Local void test_a_mode3()
{
    AMode *a_mode = new_a_mode();
    AModeData a_mode_data = NULL, a_mode_data2;

    decompose_a_mode(set_a_mode(a_mode, a_mode_data), &a_mode_data2);
    assert(a_mode_data2 == a_mode_data);
    delete_a_mode(a_mode);
    check_memory_usage("test_a_mode3");
}

Local void test_a_mode4()
{
    AMode *a_mode = new_a_mode(), *a_mode2, *a_mode3 = new_a_mode();
    AModeData a_mode_data = NULL, a_mode_data2;

    decompose_a_mode(write_a_mode_data(a_mode, a_mode_data), &a_mode_data2);
    assert(a_mode_data2 == a_mode_data);
    a_mode_data = NULL;
    decompose_a_mode(mwrite_a_mode_data(a_mode3, a_mode_data), &a_mode_data2);
    assert(a_mode_data2 == a_mode_data);
    a_mode2 = copy_a_mode(a_mode);
    delete_a_mode(a_mode);
    delete_a_mode(a_mode2);
    delete_a_mode(a_mode3);
    check_memory_usage("test_a_mode4");
}

Local void test_a_mode5()
{
    AMode *a_mode = new_a_mode(), *a_mode2;
    AModeData a_mode_data = NULL;
    int n;

    n = strcmp(type_name(a_mode->tag), "A_MODE");
    assert(n == 0);
    assert(is_type(a_mode->tag, A_MODE));
    a_mode2 = (AMode*)copy_pseudo_object(set_a_mode(a_mode, a_mode_data));
    print_pseudo_object(a_mode2, fp, INDENT);
    delete_pseudo_object(a_mode2);
    delete_a_mode(a_mode);
    check_memory_usage("test_a_mode5");
}

Public void test_a_mode()
{
    printf("testing a_mode...\n");
    test_a_mode1();
    test_a_mode2();
    test_a_mode3();
    test_a_mode4();
    test_a_mode5();
}

/*
 I_MODE
*/

Local void test_i_mode1()
{
    IMode *i_mode = NULL;

    assert(is_i_mode(i_mode));
    i_mode = new_i_mode();
    assert(is_i_mode(i_mode));
    delete_i_mode(i_mode);
    check_memory_usage("test_i_mode1");
}

Local void test_i_mode2()
{
    IModeData i_mode_data = NULL, i_mode_data2;
    IMode *i_mode = create_i_mode(i_mode_data);
    Var *var = new_var();

    assert(fis_i_mode(NULL));
    assert(fis_i_mode(i_mode));
    assert(! is_i_mode(var));
    assert(! fis_i_mode(var));
    decompose_i_mode(i_mode, &i_mode_data2);
    assert(i_mode_data2 == i_mode_data);
    assert(read_i_mode_data(i_mode) == i_mode_data);
    assert(mread_i_mode_data(i_mode) == i_mode_data);
    delete_i_mode(i_mode);
    delete_var(var);
    check_memory_usage("test_i_mode2");
}

Local void test_i_mode3()
{
    IMode *i_mode = new_i_mode();
    IModeData i_mode_data = NULL, i_mode_data2;

    decompose_i_mode(set_i_mode(i_mode, i_mode_data), &i_mode_data2);
    assert(i_mode_data2 == i_mode_data);
    delete_i_mode(i_mode);
    check_memory_usage("test_i_mode3");
}

Local void test_i_mode4()
{
    IMode *i_mode = new_i_mode(), *i_mode2, *i_mode3 = new_i_mode();
    IModeData i_mode_data = NULL, i_mode_data2;

    decompose_i_mode(write_i_mode_data(i_mode, i_mode_data), &i_mode_data2);
    assert(i_mode_data2 == i_mode_data);
    i_mode_data = NULL;
    decompose_i_mode(mwrite_i_mode_data(i_mode3, i_mode_data), &i_mode_data2);
    assert(i_mode_data2 == i_mode_data);
    i_mode2 = copy_i_mode(i_mode);
    delete_i_mode(i_mode);
    delete_i_mode(i_mode2);
    delete_i_mode(i_mode3);
    check_memory_usage("test_i_mode4");
}

Local void test_i_mode5()
{
    IMode *i_mode = new_i_mode(), *i_mode2;
    IModeData i_mode_data = NULL;
    int n;

    n = strcmp(type_name(i_mode->tag), "I_MODE");
    assert(n == 0);
    assert(is_type(i_mode->tag, I_MODE));
    i_mode2 = (IMode*)copy_pseudo_object(set_i_mode(i_mode, i_mode_data));
    print_pseudo_object(i_mode2, fp, INDENT);
    delete_pseudo_object(i_mode2);
    delete_i_mode(i_mode);
    check_memory_usage("test_i_mode5");
}

Public void test_i_mode()
{
    printf("testing i_mode...\n");
    test_i_mode1();
    test_i_mode2();
    test_i_mode3();
    test_i_mode4();
    test_i_mode5();
}

/*
 M_MODE
*/

Local void test_m_mode1()
{
    MMode *m_mode = NULL;

    assert(is_m_mode(m_mode));
    m_mode = new_m_mode();
    assert(is_m_mode(m_mode));
    delete_m_mode(m_mode);
    check_memory_usage("test_m_mode1");
}

Local void test_m_mode2()
{
    MModeData m_mode_data = NULL, m_mode_data2;
    MMode *m_mode = create_m_mode(m_mode_data);
    Var *var = new_var();

    assert(fis_m_mode(NULL));
    assert(fis_m_mode(m_mode));
    assert(! is_m_mode(var));
    assert(! fis_m_mode(var));
    decompose_m_mode(m_mode, &m_mode_data2);
    assert(m_mode_data2 == m_mode_data);
    assert(read_m_mode_data(m_mode) == m_mode_data);
    assert(mread_m_mode_data(m_mode) == m_mode_data);
    delete_m_mode(m_mode);
    delete_var(var);
    check_memory_usage("test_m_mode2");
}

Local void test_m_mode3()
{
    MMode *m_mode = new_m_mode();
    MModeData m_mode_data = NULL, m_mode_data2;

    decompose_m_mode(set_m_mode(m_mode, m_mode_data), &m_mode_data2);
    assert(m_mode_data2 == m_mode_data);
    delete_m_mode(m_mode);
    check_memory_usage("test_m_mode3");
}

Local void test_m_mode4()
{
    MMode *m_mode = new_m_mode(), *m_mode2, *m_mode3 = new_m_mode();
    MModeData m_mode_data = NULL, m_mode_data2;

    decompose_m_mode(write_m_mode_data(m_mode, m_mode_data), &m_mode_data2);
    assert(m_mode_data2 == m_mode_data);
    m_mode_data = NULL;
    decompose_m_mode(mwrite_m_mode_data(m_mode3, m_mode_data), &m_mode_data2);
    assert(m_mode_data2 == m_mode_data);
    m_mode2 = copy_m_mode(m_mode);
    delete_m_mode(m_mode);
    delete_m_mode(m_mode2);
    delete_m_mode(m_mode3);
    check_memory_usage("test_m_mode4");
}

Local void test_m_mode5()
{
    MMode *m_mode = new_m_mode(), *m_mode2;
    MModeData m_mode_data = NULL;
    int n;

    n = strcmp(type_name(m_mode->tag), "M_MODE");
    assert(n == 0);    
    assert(is_type(m_mode->tag, M_MODE));
    m_mode2 = (MMode*)copy_pseudo_object(set_m_mode(m_mode, m_mode_data));
    print_pseudo_object(m_mode2, fp, INDENT);
    delete_pseudo_object(m_mode2);
    delete_m_mode(m_mode);
    check_memory_usage("test_m_mode5");
}

Public void test_m_mode()
{
    printf("testing m_mode...\n");
    test_m_mode1();
    test_m_mode2();
    test_m_mode3();
    test_m_mode4();
    test_m_mode5();
}

/*
 E_MODE
*/

Local void test_e_mode1()
{
    EMode *e_mode = NULL;

    assert(is_e_mode(e_mode));
    e_mode = new_e_mode();
    assert(is_e_mode(e_mode));
    delete_e_mode(e_mode);
    check_memory_usage("test_e_mode1");
}

Local void test_e_mode2()
{
    EModeData e_mode_data = NULL, e_mode_data2;
    EMode *e_mode = create_e_mode(e_mode_data);
    Var *var = new_var();

    assert(fis_e_mode(NULL));
    assert(fis_e_mode(e_mode));
    assert(! is_e_mode(var));
    assert(! fis_e_mode(var));
    decompose_e_mode(e_mode, &e_mode_data2);
    assert(e_mode_data2 == e_mode_data);
    assert(read_e_mode_data(e_mode) == e_mode_data);
    assert(mread_e_mode_data(e_mode) == e_mode_data);
    delete_e_mode(e_mode);
    delete_var(var);
    check_memory_usage("test_e_mode2");
}

Local void test_e_mode3()
{
    EMode *e_mode = new_e_mode();
    EModeData e_mode_data = NULL, e_mode_data2;

    decompose_e_mode(set_e_mode(e_mode, e_mode_data), &e_mode_data2);
    assert(e_mode_data2 == e_mode_data);
    delete_e_mode(e_mode);
    check_memory_usage("test_e_mode3");
}

Local void test_e_mode4()
{
    EMode *e_mode = new_e_mode(), *e_mode2, *e_mode3 = new_e_mode();
    EModeData e_mode_data = NULL, e_mode_data2;

    decompose_e_mode(write_e_mode_data(e_mode, e_mode_data), &e_mode_data2);
    assert(e_mode_data2 == e_mode_data);
    e_mode_data = NULL;
    decompose_e_mode(mwrite_e_mode_data(e_mode3, e_mode_data), &e_mode_data2);
    assert(e_mode_data2 == e_mode_data);
    e_mode2 = copy_e_mode(e_mode);
    delete_e_mode(e_mode);
    delete_e_mode(e_mode2);
    delete_e_mode(e_mode3);
    check_memory_usage("test_e_mode4");
}

Local void test_e_mode5()
{
    EMode *e_mode = new_e_mode(), *e_mode2;
    EModeData e_mode_data = NULL;
    int n;

    n = strcmp(type_name(e_mode->tag), "E_MODE");
    assert(n == 0);    
    assert(is_type(e_mode->tag, E_MODE));
    e_mode2 = (EMode*)copy_pseudo_object(set_e_mode(e_mode, e_mode_data));
    print_pseudo_object(e_mode2, fp, INDENT);
    delete_pseudo_object(e_mode2);
    delete_e_mode(e_mode);
    check_memory_usage("test_e_mode5");
}

Public void test_e_mode()
{
    printf("testing e_mode...\n");
    test_e_mode1();
    test_e_mode2();
    test_e_mode3();
    test_e_mode4();
    test_e_mode5();
}

/*
 ANSWER (have ObjList)
*/

Local void test_answer1()
{
    Answer *answer = NULL;

    assert(is_answer(answer));
    answer = new_answer();
    assert(is_answer(answer));
    delete_answer(answer);
    check_memory_usage("test_answer1");
}

Local void test_answer2()
{
    ObjList *answer_elements = new_obj_list(ANSWER_ELEMENT), *answer_elements2;
    Answer *answer = create_answer(answer_elements);

    assert(fis_answer(NULL));
    assert(fis_answer(answer));
    assert(! is_answer(answer_elements));
    assert(! fis_answer(answer_elements));
    decompose_answer(answer, &answer_elements2);
    assert(answer_elements2 == answer_elements);
    assert(read_answer_elements(answer) == answer_elements);
    assert(mread_answer_elements(answer) == answer_elements);
    delete_answer(answer);
    check_memory_usage("test_answer2");
}

Local void test_answer3()
{
    Answer *answer = new_answer();
    ObjList *answer_elements = new_obj_list(ANSWER_ELEMENT), *answer_elements2;

    decompose_answer(set_answer(answer, answer_elements), &answer_elements2);
    assert(answer_elements2 == answer_elements);
    delete_answer(answer);
    check_memory_usage("test_answer3");
}

Local void test_answer4()
{
    Answer *answer = new_answer(), *answer2, *answer3 = new_answer();
    ObjList *answer_elements = new_obj_list(ANSWER_ELEMENT), *answer_elements2;

    decompose_answer(
      write_answer_elements(answer, answer_elements), 
      &answer_elements2);
    assert(answer_elements2 == answer_elements);
    answer_elements = new_obj_list(ANSWER_ELEMENT);
    decompose_answer(
      mwrite_answer_elements(answer3, answer_elements), 
      &answer_elements2);
    assert(answer_elements2 == answer_elements);
    answer2 = copy_answer(answer);
    delete_answer(answer);
    delete_answer(answer2);
    delete_answer(answer3);
    check_memory_usage("test_answer4");
}

Local void test_answer5()
{
    Answer *answer;
    ObjList *obj_list, *obj_list2;
    AnswerElement *answer_element, *answer_element2, *answer_element3, 
                  *answer_element4;

    answer = new_answer();
    obj_list = new_obj_list(ANSWER_ELEMENT);
    obj_list2 = new_obj_list(ANSWER_ELEMENT);
    answer_element = new_answer_element();
    answer_element2 = new_answer_element();
    answer_element3 = new_answer_element();
    answer_element4 = new_answer_element();
    append_to_obj_list(append_to_obj_list(obj_list, answer_element), 
		         answer_element2);
    append_to_obj_list(append_to_obj_list(obj_list2, answer_element3), 
		         answer_element4);
    insert_answer_elements(insert_answer_elements(answer, obj_list2), 
			     obj_list);
    assert(car_of_answer_elements(answer) == answer_element &&
	   car_of_answer_elements(answer) == answer_element2 &&
	   car_of_answer_elements(answer) == answer_element3 &&
	   car_of_answer_elements(answer) == answer_element4);

    obj_list = new_obj_list(ANSWER_ELEMENT);
    obj_list2 = new_obj_list(ANSWER_ELEMENT);
    cons_to_obj_list(cons_to_obj_list(obj_list, answer_element), 
		       answer_element2);
    cons_to_obj_list(cons_to_obj_list(obj_list2, answer_element3), 
		       answer_element4);
    add_answer_elements(add_answer_elements(answer, obj_list2), obj_list);
    assert(car_of_answer_elements(answer) == answer_element4 &&
	   car_of_answer_elements(answer) == answer_element3 &&
	   car_of_answer_elements(answer) == answer_element2 &&
	   car_of_answer_elements(answer) == answer_element);
    delete_answer_element(answer_element);
    delete_answer_element(answer_element2);
    delete_answer_element(answer_element3);
    delete_answer_element(answer_element4);
    delete_answer(answer);
    check_memory_usage("test_answer5");
}

Local void test_answer6()
{
    Answer *answer = new_answer(), *answer2;
    ObjList *answer_elements = new_obj_list(ANSWER_ELEMENT);
    int n;

    n = strcmp(type_name(answer->tag), "ANSWER");
    assert(n == 0);
    assert(is_type(answer->tag, ANSWER));
    answer2 = (Answer*)copy_pseudo_object(set_answer(answer, answer_elements));
    print_pseudo_object(answer2, fp, INDENT);
    delete_pseudo_object(answer2);
    delete_answer(answer);
    check_memory_usage("test_answer6");
}

Public void test_answer()
{
    printf("testing answer...\n");
    test_answer1();
    test_answer2();
    test_answer3();
    test_answer4();
    test_answer5();
    test_answer6();
}

/*
 ANSWER_ELEMENT (have ObjList)
*/

Local void test_answer_element1()
{
    AnswerElement *answer_element = NULL;

    assert(is_answer_element(answer_element));
    answer_element = new_answer_element();
    assert(is_answer_element(answer_element));
    delete_answer_element(answer_element);
    check_memory_usage("test_answer_element1");
}

Local void test_answer_element2()
{
    ObjList *dot_cnstrs = new_obj_list(DOT_CNSTR), *dot_cnstrs2;
    ObjList *var_cnstrs = new_obj_list(VAR_CNSTR), *var_cnstrs2;
    AnseExplanation *explanation = new_anse_explanation(), *explanation2;
    AnswerElement *answer_element = 
      create_answer_element(dot_cnstrs, var_cnstrs, explanation);

    assert(fis_answer_element(NULL));
    assert(fis_answer_element(answer_element));
    assert(! is_answer_element(dot_cnstrs));
    assert(! fis_answer_element(dot_cnstrs));
    decompose_answer_element(answer_element, &dot_cnstrs2, 
      &var_cnstrs2, &explanation2);
    assert(dot_cnstrs2 == dot_cnstrs && var_cnstrs2 == var_cnstrs && 
	   explanation2 == explanation);
    assert(read_dot_cnstrs(answer_element) == dot_cnstrs &&
	   read_var_cnstrs(answer_element) == var_cnstrs &&
           read_anse_explanation(answer_element) == explanation);
    assert(mread_dot_cnstrs(answer_element) == dot_cnstrs &&
	   mread_var_cnstrs(answer_element) == var_cnstrs &&
           mread_anse_explanation(answer_element) == explanation);
    delete_answer_element(answer_element);
    check_memory_usage("test_answer_element2");
}

Local void test_answer_element3()
{
    AnswerElement *answer_element = new_answer_element();
    ObjList *dot_cnstrs = new_obj_list(DOT_CNSTR), *dot_cnstrs2;
    ObjList *var_cnstrs = new_obj_list(VAR_CNSTR), *var_cnstrs2;
    AnseExplanation *explanation = new_anse_explanation(), *explanation2;

    decompose_answer_element(
      set_answer_element(answer_element, dot_cnstrs, var_cnstrs, explanation), 
      &dot_cnstrs2, &var_cnstrs2, &explanation2);
    assert(dot_cnstrs2 == dot_cnstrs && var_cnstrs2 == var_cnstrs && 
	   explanation2 == explanation);
    delete_answer_element(answer_element);
    check_memory_usage("test_answer_element3");
}

Local void test_answer_element4()
{
    AnswerElement *answer_element = new_answer_element(), *answer_element2,
                  *answer_element3 = new_answer_element();
    ObjList *dot_cnstrs = new_obj_list(DOT_CNSTR), *dot_cnstrs2;
    ObjList *var_cnstrs = new_obj_list(VAR_CNSTR), *var_cnstrs2;
    AnseExplanation *explanation = new_anse_explanation(), *explanation2;

    decompose_answer_element(
      write_dot_cnstrs(
        write_var_cnstrs(
          write_anse_explanation(answer_element, explanation),
          var_cnstrs),
        dot_cnstrs),
      &dot_cnstrs2, &var_cnstrs2, &explanation2);
    assert(dot_cnstrs2 == dot_cnstrs && var_cnstrs2 == var_cnstrs && 
	   explanation2 == explanation);
    dot_cnstrs = new_obj_list(DOT_CNSTR);
    var_cnstrs = new_obj_list(VAR_CNSTR);
    explanation = new_anse_explanation();
    decompose_answer_element(
      mwrite_dot_cnstrs(
        mwrite_var_cnstrs(
          mwrite_anse_explanation(answer_element3, explanation),
          var_cnstrs),
        dot_cnstrs),
      &dot_cnstrs2, &var_cnstrs2, &explanation2);
    assert(dot_cnstrs2 == dot_cnstrs && var_cnstrs2 == var_cnstrs && 
	   explanation2 == explanation);
    answer_element2 = copy_answer_element(answer_element);
    delete_answer_element(answer_element);
    delete_answer_element(answer_element2);
    delete_answer_element(answer_element3);
    check_memory_usage("test_answer_element4");
}

Local void test_answer_element5()
{
    AnswerElement *answer_element;
    ObjList *obj_list, *obj_list2, *obj_list3, *obj_list4;
    DotCnstr *dot_cnstr, *dot_cnstr2, *dot_cnstr3, *dot_cnstr4;
    VarCnstr *var_cnstr, *var_cnstr2, *var_cnstr3, *var_cnstr4;

    answer_element = new_answer_element();
    obj_list = new_obj_list(DOT_CNSTR);
    obj_list2 = new_obj_list(DOT_CNSTR);
    obj_list3 = new_obj_list(VAR_CNSTR);
    obj_list4 = new_obj_list(VAR_CNSTR);
    dot_cnstr = new_dot_cnstr();
    dot_cnstr2 = new_dot_cnstr();
    dot_cnstr3 = new_dot_cnstr();
    dot_cnstr4 = new_dot_cnstr();
    var_cnstr = new_var_cnstr();
    var_cnstr2 = new_var_cnstr();
    var_cnstr3 = new_var_cnstr();
    var_cnstr4 = new_var_cnstr();
    append_to_obj_list(append_to_obj_list(obj_list, dot_cnstr), dot_cnstr2);
    append_to_obj_list(append_to_obj_list(obj_list2, dot_cnstr3), dot_cnstr4);
    append_to_obj_list(append_to_obj_list(obj_list3, var_cnstr), var_cnstr2);
    append_to_obj_list(append_to_obj_list(obj_list4, var_cnstr3), var_cnstr4);
    insert_dot_cnstrs(insert_dot_cnstrs(answer_element, obj_list2), obj_list);
    insert_var_cnstrs(insert_var_cnstrs(answer_element, obj_list4), obj_list3);
    assert(car_of_dot_cnstrs(answer_element) == dot_cnstr &&
	   car_of_dot_cnstrs(answer_element) == dot_cnstr2 &&
	   car_of_dot_cnstrs(answer_element) == dot_cnstr3 &&
	   car_of_dot_cnstrs(answer_element) == dot_cnstr4);
    assert(car_of_var_cnstrs(answer_element) == var_cnstr &&
	   car_of_var_cnstrs(answer_element) == var_cnstr2 &&
	   car_of_var_cnstrs(answer_element) == var_cnstr3 &&
	   car_of_var_cnstrs(answer_element) == var_cnstr4);

    obj_list = new_obj_list(DOT_CNSTR);
    obj_list2 = new_obj_list(DOT_CNSTR);
    obj_list3 = new_obj_list(VAR_CNSTR);
    obj_list4 = new_obj_list(VAR_CNSTR);
    cons_to_obj_list(cons_to_obj_list(obj_list, dot_cnstr), dot_cnstr2);
    cons_to_obj_list(cons_to_obj_list(obj_list2, dot_cnstr3), dot_cnstr4);
    cons_to_obj_list(cons_to_obj_list(obj_list3, var_cnstr), var_cnstr2);
    cons_to_obj_list(cons_to_obj_list(obj_list4, var_cnstr3), var_cnstr4);
    add_dot_cnstrs(add_dot_cnstrs(answer_element, obj_list2), obj_list);
    add_var_cnstrs(add_var_cnstrs(answer_element, obj_list4), obj_list3);
    assert(car_of_dot_cnstrs(answer_element) == dot_cnstr4 &&
	   car_of_dot_cnstrs(answer_element) == dot_cnstr3 &&
	   car_of_dot_cnstrs(answer_element) == dot_cnstr2 &&
	   car_of_dot_cnstrs(answer_element) == dot_cnstr);
    assert(car_of_var_cnstrs(answer_element) == var_cnstr4 &&
	   car_of_var_cnstrs(answer_element) == var_cnstr3 &&
	   car_of_var_cnstrs(answer_element) == var_cnstr2 &&
	   car_of_var_cnstrs(answer_element) == var_cnstr);
    delete_dot_cnstr(dot_cnstr);
    delete_dot_cnstr(dot_cnstr2);
    delete_dot_cnstr(dot_cnstr3);
    delete_dot_cnstr(dot_cnstr4);
    delete_var_cnstr(var_cnstr);
    delete_var_cnstr(var_cnstr2);
    delete_var_cnstr(var_cnstr3);
    delete_var_cnstr(var_cnstr4);
    delete_answer_element(answer_element);
    check_memory_usage("test_answer_element5");
}

Local void test_answer_element6()
{
    AnswerElement *answer_element = new_answer_element(), *answer_element2;
    ObjList *dot_cnstrs = new_obj_list(DOT_CNSTR);
    ObjList *var_cnstrs = new_obj_list(VAR_CNSTR);
    AnseExplanation *explanation = new_anse_explanation();
    int n;

    n = strcmp(type_name(answer_element->tag), "ANSWER_ELEMENT");
    assert(n == 0);
    assert(is_type(answer_element->tag, ANSWER_ELEMENT));
    answer_element2 = (AnswerElement*)copy_pseudo_object
     (set_answer_element(answer_element, dot_cnstrs, var_cnstrs, explanation));
    print_pseudo_object(answer_element2, fp, INDENT);
    delete_pseudo_object(answer_element2);
    delete_answer_element(answer_element);
    check_memory_usage("test_answer_element6");
}

Public void test_answer_element()
{
    printf("testing answer_element...\n");
    test_answer_element1();
    test_answer_element2();
    test_answer_element3();
    test_answer_element4();
    test_answer_element5();
    test_answer_element6();
}

/*
 ANSE_EXPLANATION (have ObjList)
*/

Local void test_anse_explanation1()
{
    AnseExplanation *anse_explanation = NULL;

    assert(is_anse_explanation(anse_explanation));
    anse_explanation = new_anse_explanation();
    assert(is_anse_explanation(anse_explanation));
    delete_anse_explanation(anse_explanation);
    check_memory_usage("test_anse_explanation1");
}

Local void test_anse_explanation2()
{
    Explanation *explanation = new_explanation(), *explanation2;
    ObjList *rir_pairs = new_obj_list(RIR_PAIR), *rir_pairs2;
    AnseExplanation *anse_explanation = 
      create_anse_explanation(explanation, rir_pairs);

    assert(fis_anse_explanation(NULL));
    assert(fis_anse_explanation(anse_explanation));
    assert(! is_anse_explanation(explanation));
    assert(! fis_anse_explanation(explanation));
    decompose_anse_explanation(anse_explanation, &explanation2, &rir_pairs2);
    assert(explanation2 == explanation && rir_pairs2 == rir_pairs);
    assert(read_explanation_inAnseExplanation(anse_explanation) == 
	     explanation &&
	   read_rir_pairs(anse_explanation) == rir_pairs);
    assert(mread_explanation_inAnseExplanation(anse_explanation) == 
	     explanation &&
	   mread_rir_pairs(anse_explanation) == rir_pairs);
    delete_anse_explanation(anse_explanation);
    check_memory_usage("test_anse_explanation2");
}

Local void test_anse_explanation3()
{
    AnseExplanation *anse_explanation = new_anse_explanation();
    Explanation *explanation = new_explanation(), *explanation2;
    ObjList *rir_pairs = new_obj_list(RIR_PAIR), *rir_pairs2;

    decompose_anse_explanation(
      set_anse_explanation(anse_explanation, explanation, rir_pairs), 
      &explanation2, &rir_pairs2);
    assert(explanation2 == explanation && rir_pairs2 == rir_pairs);
    delete_anse_explanation(anse_explanation);
    check_memory_usage("test_anse_explanation3");
}

Local void test_anse_explanation4()
{
    AnseExplanation *anse_explanation = new_anse_explanation(), 
                    *anse_explanation2,
                    *anse_explanation3 = new_anse_explanation();
    Explanation *explanation = new_explanation(), *explanation2;
    ObjList *rir_pairs = new_obj_list(RIR_PAIR), *rir_pairs2;

    decompose_anse_explanation(
      write_explanation_inAnseExplanation(
        write_rir_pairs(anse_explanation, rir_pairs),
        explanation),
      &explanation2, &rir_pairs2);
    assert(explanation2 == explanation && rir_pairs2 == rir_pairs);
    explanation = new_explanation();
    rir_pairs = new_obj_list(RIR_PAIR);
    decompose_anse_explanation(
      mwrite_explanation_inAnseExplanation(
        mwrite_rir_pairs(anse_explanation3, rir_pairs),
        explanation),
      &explanation2, &rir_pairs2);
    assert(explanation2 == explanation && rir_pairs2 == rir_pairs);
    anse_explanation2 = copy_anse_explanation(anse_explanation);
    delete_anse_explanation(anse_explanation);
    delete_anse_explanation(anse_explanation2);
    delete_anse_explanation(anse_explanation3);
    check_memory_usage("test_anse_explanation4");
}

Local void test_anse_explanation5()
{
    AnseExplanation *anse_explanation;
    ObjList *obj_list, *obj_list2; 
    RirPair *rir_pair, *rir_pair2, *rir_pair3, *rir_pair4;

    anse_explanation = new_anse_explanation();
    obj_list = new_obj_list(RIR_PAIR);
    obj_list2 = new_obj_list(RIR_PAIR);
    rir_pair = new_rir_pair();
    rir_pair2 = new_rir_pair();
    rir_pair3 = new_rir_pair();
    rir_pair4 = new_rir_pair();
    append_to_obj_list(append_to_obj_list(obj_list, rir_pair), 
		       rir_pair2);
    append_to_obj_list(append_to_obj_list(obj_list2, rir_pair3), 
		       rir_pair4);
    insert_rir_pairs(insert_rir_pairs(anse_explanation, obj_list2), obj_list);
    assert(car_of_rir_pairs(anse_explanation) == rir_pair &&
	   car_of_rir_pairs(anse_explanation) == rir_pair2 &&
	   car_of_rir_pairs(anse_explanation) == rir_pair3 &&
	   car_of_rir_pairs(anse_explanation) == rir_pair4);

    obj_list = new_obj_list(RIR_PAIR);
    obj_list2 = new_obj_list(RIR_PAIR);
    cons_to_obj_list(cons_to_obj_list(obj_list, rir_pair), rir_pair2);
    cons_to_obj_list(cons_to_obj_list(obj_list2, rir_pair3), rir_pair4);
    add_rir_pairs(add_rir_pairs(anse_explanation, obj_list2), obj_list);
    assert(car_of_rir_pairs(anse_explanation) == rir_pair4 &&
	   car_of_rir_pairs(anse_explanation) == rir_pair3 &&
	   car_of_rir_pairs(anse_explanation) == rir_pair2 &&
	   car_of_rir_pairs(anse_explanation) == rir_pair);
    delete_rir_pair(rir_pair);
    delete_rir_pair(rir_pair2);
    delete_rir_pair(rir_pair3);
    delete_rir_pair(rir_pair4);
    delete_anse_explanation(anse_explanation);
    check_memory_usage("test_anse_explanation5");
}

Local void test_anse_explanation6()
{
    AnseExplanation *anse_explanation = new_anse_explanation(), 
                    *anse_explanation2;
    Explanation *explanation = new_explanation();
    ObjList *rir_pairs = new_obj_list(RIR_PAIR);
    int n;

    n = strcmp(type_name(anse_explanation->tag), "ANSE_EXPLANATION");
    assert(n == 0);
    assert(is_type(anse_explanation->tag, ANSE_EXPLANATION));
    anse_explanation2 = (AnseExplanation*)copy_pseudo_object
     (set_anse_explanation(anse_explanation, explanation, rir_pairs));
    print_pseudo_object(anse_explanation2, fp, INDENT);
    delete_pseudo_object(anse_explanation2);
    delete_anse_explanation(anse_explanation);
    check_memory_usage("test_anse_explanation6");
}

Public void test_anse_explanation()
{
    printf("testing anse_explanation...\n");
    test_anse_explanation1();
    test_anse_explanation2();
    test_anse_explanation3();
    test_anse_explanation4();
    test_anse_explanation5();
    test_anse_explanation6();
}

/*
 RIR_PAIR
*/

Local void test_rir_pair1()
{
    RirPair *rir_pair = NULL;

    assert(is_rir_pair(rir_pair));
    rir_pair = new_rir_pair();
    assert(is_rir_pair(rir_pair));
    delete_rir_pair(rir_pair);
    check_memory_usage("test_rir_pair1");
}

Local void test_rir_pair2()
{
    RuleId *rule_id = new_rule_id(), *rule_id2;
    Rule *rule = new_rule(), *rule2;
    RirPair *rir_pair = 
      create_rir_pair(rule_id, rule);

    assert(fis_rir_pair(NULL));
    assert(fis_rir_pair(rir_pair));
    assert(! is_rir_pair(rule_id));
    assert(! fis_rir_pair(rule_id));
    decompose_rir_pair(rir_pair, &rule_id2, &rule2);
    assert(rule_id2 == rule_id && rule2 == rule);
    assert(read_rule_id_inRirPair(rir_pair) == rule_id && 
	   read_rule(rir_pair) == rule);
    assert(mread_rule_id_inRirPair(rir_pair) == rule_id && 
	   mread_rule(rir_pair) == rule);
    delete_rir_pair(rir_pair);
    check_memory_usage("test_rir_pair2");
}

Local void test_rir_pair3()
{
    RirPair *rir_pair = new_rir_pair();
    RuleId *rule_id = new_rule_id(), *rule_id2;
    Rule *rule = new_rule(), *rule2;

    decompose_rir_pair(
      set_rir_pair(rir_pair, rule_id, rule), &rule_id2, &rule2);
    assert(rule_id2 == rule_id && rule2 == rule);
    delete_rir_pair(rir_pair);
    check_memory_usage("test_rir_pair3");
}

Local void test_rir_pair4()
{
    RirPair *rir_pair = new_rir_pair(), *rir_pair2, 
            *rir_pair3 = new_rir_pair();
    RuleId *rule_id = new_rule_id(), *rule_id2;
    Rule *rule = new_rule(), *rule2;

    decompose_rir_pair(
      write_rule_id_inRirPair(
        write_rule(rir_pair, rule),
        rule_id),
      &rule_id2, &rule2);
    assert(rule_id2 == rule_id && rule2 == rule);
    rule_id = new_rule_id();
    rule = new_rule();
    decompose_rir_pair(
      mwrite_rule_id_inRirPair(
        mwrite_rule(rir_pair3, rule),
        rule_id),
      &rule_id2, &rule2);
    assert(rule_id2 == rule_id && rule2 == rule);
    rir_pair2 = copy_rir_pair(rir_pair);
    delete_rir_pair(rir_pair);
    delete_rir_pair(rir_pair2);
    delete_rir_pair(rir_pair3);
    check_memory_usage("test_rir_pair4");
}

Local void test_rir_pair5()
{
    RirPair *rir_pair = new_rir_pair(), *rir_pair2;
    RuleId *rule_id = new_rule_id();
    Rule *rule = new_rule();
    int n;

    n = strcmp(type_name(rir_pair->tag), "RIR_PAIR");
    assert(n == 0);
    assert(is_type(rir_pair->tag, RIR_PAIR));
    rir_pair2 = (RirPair*)copy_pseudo_object
      (set_rir_pair(rir_pair, rule_id, rule));
    print_pseudo_object(rir_pair2, fp, INDENT);
    delete_pseudo_object(rir_pair2);
    delete_rir_pair(rir_pair);
    check_memory_usage("test_rir_pair5");
}

Public void test_rir_pair()
{
    printf("testing rir_pair...\n");
    test_rir_pair1();
    test_rir_pair2();
    test_rir_pair3();
    test_rir_pair4();
    test_rir_pair5();
}

/*
 DOT_CNSTR
*/

Local void test_dot_cnstr1()
{
    DotCnstr *dot_cnstr = NULL;

    assert(is_dot_cnstr(dot_cnstr));
    dot_cnstr = new_dot_cnstr();
    assert(is_dot_cnstr(dot_cnstr));
    delete_dot_cnstr(dot_cnstr);
    check_memory_usage("test_dot_cnstr1");
}

Local void test_dot_cnstr2()
{
    MId *m_id = new_o_term(), *m_id2;
    Dot *dot = new_dot(), *dot2;
    CnRel rel = NULL, rel2;
    Value *value = new_value(), *value2;
    DotCnstr *dot_cnstr = create_dot_cnstr(m_id, dot, rel, value);

    assert(fis_dot_cnstr(NULL));
    assert(fis_dot_cnstr(dot_cnstr));
    assert(! is_dot_cnstr(m_id));
    assert(! fis_dot_cnstr(m_id));
    decompose_dot_cnstr(dot_cnstr, &m_id2, &dot2, &rel2, &value2);
    assert(m_id2 == m_id && dot2 == dot && rel2 == rel && value2 == value);
    assert(read_m_id_inDotCnstr(dot_cnstr) == m_id &&
	   read_dot_inDotCnstr(dot_cnstr) == dot &&
	   read_rel_inDotCnstr(dot_cnstr) == rel &&
	   read_value_inDotCnstr(dot_cnstr) == value);
    assert(mread_m_id_inDotCnstr(dot_cnstr) == m_id &&
	   mread_dot_inDotCnstr(dot_cnstr) == dot &&
	   mread_rel_inDotCnstr(dot_cnstr) == rel &&
	   mread_value_inDotCnstr(dot_cnstr) == value);
    delete_dot_cnstr(dot_cnstr);
    check_memory_usage("test_dot_cnstr2");
}

Local void test_dot_cnstr3()
{
    DotCnstr *dot_cnstr = new_dot_cnstr();
    MId *m_id = new_o_term(), *m_id2;
    Dot *dot = new_dot(), *dot2;
    CnRel rel = NULL, rel2;
    Value *value = new_value(), *value2;

    decompose_dot_cnstr(
      set_dot_cnstr(dot_cnstr, m_id, dot, rel, value), 
      &m_id2, &dot2, &rel2, &value2);
    assert(m_id2 == m_id && dot2 == dot && rel2 == rel && value2 == value);
    delete_dot_cnstr(dot_cnstr);
    check_memory_usage("test_dot_cnstr3");
}

Local void test_dot_cnstr4()
{
    DotCnstr *dot_cnstr = new_dot_cnstr(), *dot_cnstr2, 
             *dot_cnstr3 = new_dot_cnstr();
    MId *m_id = new_o_term(), *m_id2;
    Dot *dot = new_dot(), *dot2;
    CnRel rel = NULL, rel2;
    Value *value = new_value(), *value2;

    decompose_dot_cnstr(
      write_m_id_inDotCnstr(
        write_dot_inDotCnstr(
          write_rel_inDotCnstr(
            write_value_inDotCnstr(dot_cnstr, value),
            rel),
          dot),
        m_id),
      &m_id2, &dot2, &rel2, &value2);
    assert(m_id2 == m_id && dot2 == dot && rel2 == rel && value2 == value);
    m_id = new_o_term();
    dot = new_dot();
    rel = NULL;
    value = new_value();
    decompose_dot_cnstr(
      mwrite_m_id_inDotCnstr(
        mwrite_dot_inDotCnstr(
          mwrite_rel_inDotCnstr(
            mwrite_value_inDotCnstr(dot_cnstr3, value),
            rel),
          dot),
        m_id),
      &m_id2, &dot2, &rel2, &value2);
    assert(m_id2 == m_id && dot2 == dot && rel2 == rel && value2 == value);
    dot_cnstr2 = copy_dot_cnstr(dot_cnstr);
    delete_dot_cnstr(dot_cnstr);
    delete_dot_cnstr(dot_cnstr2);
    delete_dot_cnstr(dot_cnstr3);
    check_memory_usage("test_dot_cnstr4");
}

Local void test_dot_cnstr5()
{
    DotCnstr *dot_cnstr = new_dot_cnstr(), *dot_cnstr2;
    MId *m_id = new_o_term();
    Dot *dot = new_dot();
    CnRel rel = NULL;
    Value *value = new_value();
    int n;

    n = strcmp(type_name(dot_cnstr->tag), "DOT_CNSTR");
    assert(n == 0);
    assert(is_type(dot_cnstr->tag, DOT_CNSTR));
    dot_cnstr2 = (DotCnstr*)copy_pseudo_object
      (set_dot_cnstr(dot_cnstr, m_id, dot, rel, value));
    print_pseudo_object(dot_cnstr2, fp, INDENT);
    delete_pseudo_object(dot_cnstr2);
    delete_dot_cnstr(dot_cnstr);
    check_memory_usage("test_dot_cnstr5");
}

Public void test_dot_cnstr()
{
    printf("testing dot_cnstr...\n");
    test_dot_cnstr1();
    test_dot_cnstr2();
    test_dot_cnstr3();
    test_dot_cnstr4();
    test_dot_cnstr5();
}

/*
 VAR_CNSTR
*/

Local void test_var_cnstr1()
{
    VarCnstr *var_cnstr = NULL;

    assert(is_var_cnstr(var_cnstr));
    var_cnstr = new_var_cnstr();
    assert(is_var_cnstr(var_cnstr));
    delete_var_cnstr(var_cnstr);
    check_memory_usage("test_var_cnstr1");
}

Local void test_var_cnstr2()
{
    Var *var = new_var(), *var2;
    CnRel rel = NULL, rel2;
    Value *value = new_value(), *value2;
    VarCnstr *var_cnstr = create_var_cnstr(var, rel, value);

    assert(fis_var_cnstr(NULL));
    assert(fis_var_cnstr(var_cnstr));
    assert(! is_var_cnstr(var));
    assert(! fis_var_cnstr(var));
    decompose_var_cnstr(var_cnstr, &var2, &rel2, &value2);
    assert(var2 == var && rel2 == rel && value2 == value);
    assert(read_var_inVarCnstr(var_cnstr) == var &&
	   read_rel_inVarCnstr(var_cnstr) == rel &&
	   read_value_inVarCnstr(var_cnstr) == value);
    assert(mread_var_inVarCnstr(var_cnstr) == var &&
	   mread_rel_inVarCnstr(var_cnstr) == rel &&
	   mread_value_inVarCnstr(var_cnstr) == value);
    delete_var_cnstr(var_cnstr);
    check_memory_usage("test_var_cnstr2");
}

Local void test_var_cnstr3()
{
    VarCnstr *var_cnstr = new_var_cnstr();
    Var *var = new_var(), *var2;
    CnRel rel = NULL, rel2;
    Value *value = new_value(), *value2;

    decompose_var_cnstr(
      set_var_cnstr(var_cnstr, var, rel, value), 
      &var2, &rel2, &value2);
    assert(var2 == var && rel2 == rel && value2 == value);
    delete_var_cnstr(var_cnstr);
    check_memory_usage("test_var_cnstr3");
}

Local void test_var_cnstr4()
{
    VarCnstr *var_cnstr = new_var_cnstr(), *var_cnstr2,
             *var_cnstr3 = new_var_cnstr();
    Var *var = new_var(), *var2;
    CnRel rel = NULL, rel2;
    Value *value = new_value(), *value2;

    decompose_var_cnstr(
      write_var_inVarCnstr(
        write_rel_inVarCnstr(
          write_value_inVarCnstr(var_cnstr, value),
          rel),
        var),
      &var2, &rel2, &value2);
    assert(var2 == var && rel2 == rel && value2 == value);
    var = new_var();
    rel = NULL;
    value = new_value();
    decompose_var_cnstr(
      mwrite_var_inVarCnstr(
        mwrite_rel_inVarCnstr(
          mwrite_value_inVarCnstr(var_cnstr3, value),
          rel),
        var),
      &var2, &rel2, &value2);
    assert(var2 == var && rel2 == rel && value2 == value);
    var_cnstr2 = copy_var_cnstr(var_cnstr);
    delete_var_cnstr(var_cnstr);
    delete_var_cnstr(var_cnstr2);
    delete_var_cnstr(var_cnstr3);
    check_memory_usage("test_var_cnstr4");
}

Local void test_var_cnstr5()
{
    VarCnstr *var_cnstr = new_var_cnstr(), *var_cnstr2;
    Var *var = new_var();
    CnRel rel = NULL;
    Value *value = new_value();
    int n;

    n = strcmp(type_name(var_cnstr->tag), "VAR_CNSTR");
    assert(n == 0);
    assert(is_type(var_cnstr->tag, VAR_CNSTR));
    var_cnstr2 = (VarCnstr*)copy_pseudo_object
      (set_var_cnstr(var_cnstr, var, rel, value));
    print_pseudo_object(var_cnstr2, fp, INDENT);
    delete_pseudo_object(var_cnstr2);
    delete_var_cnstr(var_cnstr);
    check_memory_usage("test_var_cnstr5");
}

Public void test_var_cnstr()
{
    printf("testing var_cnstr...\n");
    test_var_cnstr1();
    test_var_cnstr2();
    test_var_cnstr3();
    test_var_cnstr4();
    test_var_cnstr5();
}

