#include <assert.h>
#include <ctype.h>

#define MALLOC_DEBUG

#include "dotsrc.h"
/************************/
/*   mod_def            */
/************************/
void test_mod_def1()
{
    ModDef* mod_def  = NULL;
    assert(is_mod_def(mod_def));
    mod_def = new_mod_def();
    assert(is_mod_def(mod_def));
    delete_mod_def(mod_def);
    check_memory_usage("test_mod_def1");
}

void test_mod_def2()
{
    ObjList* m_subs = new_obj_list(M_SUB), *m_subs2;
    ModDef*  mod_def;

    assert(fis_mod_def(NULL));
    assert(fis_mod_def(mod_def = create_mod_def(m_subs)));

    assert(! is_mod_def(m_subs));
    assert(! fis_mod_def(m_subs));
    decompose_mod_def(mod_def, &m_subs2);
    assert(m_subs2 == m_subs);
    delete_mod_def(mod_def);
    check_memory_usage("test_mod_def2");
}

void test_mod_def3()
{
    ModDef *mod_def = new_mod_def(), *mod_def2;
    ObjList *m_subs = new_obj_list(M_SUB), *m_subs2;

    decompose_mod_def(set_mod_def(mod_def,m_subs),&m_subs2);
    assert(m_subs2 == m_subs);
    mod_def2 = copy_mod_def(mod_def);
    delete_mod_def(mod_def);
    delete_mod_def(mod_def2);
    check_memory_usage("test_mod_def3");
}

void test_mod_def4()
{
    ModDef *mod_def = new_mod_def();
    ObjList *m_subs = new_obj_list(M_SUB);

    mwrite_m_subs_inModDef(mod_def,m_subs);

    assert(m_subs == mread_m_subs_inModDef(mod_def));
    delete_mod_def(mod_def);
  }


void  test_mod_def5()
{
  ModDef   *mod_def;
  ObjList   *obj_list,*obj_list2;
  MSub  *m_sub,*m_sub2,*m_sub3,*m_sub4;

  mod_def = new_mod_def();
  obj_list = new_obj_list(M_SUB);
  obj_list2 = new_obj_list(M_SUB);
  m_sub = new_m_sub();
  m_sub2 = new_m_sub();
  m_sub3 = new_m_sub();
  m_sub4 = new_m_sub();
  append_to_obj_list(append_to_obj_list(obj_list,m_sub),m_sub2);
  append_to_obj_list(append_to_obj_list(obj_list2,m_sub3),m_sub4);
  insert_m_subs(insert_m_subs(mod_def,obj_list2),obj_list);
  assert(car_of_m_subs(mod_def) == m_sub &&
         car_of_m_subs(mod_def) == m_sub2 &&
         car_of_m_subs(mod_def) == m_sub3 &&
         car_of_m_subs(mod_def) == m_sub4);

  obj_list = new_obj_list(M_SUB);
  obj_list2 = new_obj_list(M_SUB);  
  cons_to_obj_list(cons_to_obj_list(obj_list,m_sub),m_sub2);
  cons_to_obj_list(cons_to_obj_list(obj_list2,m_sub3),m_sub4);
  add_m_subs(add_m_subs(mod_def,obj_list2),obj_list);
  assert(car_of_m_subs(mod_def) == m_sub4 &&
         car_of_m_subs(mod_def) == m_sub3 &&
         car_of_m_subs(mod_def) == m_sub2 &&
         car_of_m_subs(mod_def) == m_sub);
  delete_m_sub(m_sub);
  delete_m_sub(m_sub2);
  delete_m_sub(m_sub3);
  delete_m_sub(m_sub4);
  delete_mod_def(mod_def);
  check_memory_usage("test_mod_def5");
}

void test_mod_def()
{
    printf("testing mod_def...\n");
    test_mod_def1();
    test_mod_def2();
    test_mod_def3();
    test_mod_def4();
    test_mod_def5();
}

/************************/
/*   m_sub              */
/************************/
void test_m_sub1()
{
    MSub* m_sub = new_m_sub();
    assert(is_m_sub(m_sub));
    delete_m_sub(m_sub);
    check_memory_usage("test_m_sub1");
}

void test_m_sub2()
{
     MId* m_id = new_o_term(), *m_id2;
     MDesc*   m_desc = new_m_desc(),*m_desc2;
     MSub*  m_sub;
  
     assert(fis_m_sub(NULL));
     assert(fis_m_sub(m_sub = create_m_sub(m_id,m_desc)));
 
     assert(! is_m_sub(m_desc));
     assert(! fis_m_sub(m_desc));

     decompose_m_sub(m_sub, &m_id2,&m_desc2);
     assert(m_id2 == m_id && m_desc2 == m_desc);
     assert(read_m_id_inMSub(m_sub) == m_id && 
            read_m_desc(m_sub) == m_desc);
    delete_m_sub(m_sub);
    check_memory_usage("test_m_sub2");
}

void test_m_sub3()
{
    MSub *m_sub = new_m_sub();
    MId  *m_id = new_o_term(), *m_id2;
    MDesc *m_desc = new_m_desc(),*m_desc2;

    decompose_m_sub(set_m_sub(m_sub,m_id,m_desc),&m_id2,&m_desc2);
    assert(m_id2 == m_id && m_desc2 == m_desc);
    delete_m_sub(m_sub);
    check_memory_usage("test_m_sub3");
}

void test_m_sub4()
{
    MSub *m_sub = new_m_sub(), *m_sub2;
    MId  *m_id = new_o_term(), *m_id2;
    MDesc *m_desc = new_m_desc(),*m_desc2;

    decompose_m_sub(
          write_m_id_inMSub(
              write_m_desc(m_sub,m_desc),
                         m_id),&m_id2,&m_desc2);
    assert(m_id2 == m_id && m_desc2 == m_desc);
    m_sub2 = copy_m_sub(m_sub);
    delete_m_sub(m_sub);
    delete_m_sub(m_sub2);
    check_memory_usage("test_m_sub4");
  }

void test_m_sub5()
{
    MSub *m_sub = new_m_sub();
    MId  *m_id = new_o_term();
    MDesc *m_desc = new_m_desc();

    mwrite_m_id_inMSub(m_sub,m_id);
    mwrite_m_desc(m_sub,m_desc);
    assert(m_id == mread_m_id_inMSub(m_sub) && m_desc == mread_m_desc(m_sub));
    delete_m_sub(m_sub);
  }

void test_m_sub()
{
    printf("testing m_sub...\n");
    test_m_sub1();
    test_m_sub2();
    test_m_sub3();
    test_m_sub4();
    test_m_sub5();
  }

/************************/
/*   m_desc             */
/************************/
void  test_m_desc1()
{
   MDesc *m_desc = new_m_desc();
   assert(is_m_desc(m_desc));
   delete_m_desc(m_desc);
   check_memory_usage("test_m_desc1");
}   

void  test_m_desc2()
{
   MId    *m_id = new_o_term();
   MDesc  *m_desc;
   ModDef *mod_def = new_mod_def();

   assert(fis_m_desc(NULL));
   assert(fis_m_desc(m_desc = create_m_desc_m_id(m_id)));
   assert(! is_m_desc(mod_def));
   assert(! fis_m_desc(mod_def));
   delete_m_desc(m_desc);
   delete_mod_def(mod_def);
   check_memory_usage("test_m_desc2");
 }

void  test_m_desc3()
{
   M2Desc    *m2_desc = new_m2_desc();
   MDesc     *m_desc, *m_desc2;

   assert(fis_m_desc(m_desc = create_m_desc_m2_desc(m2_desc)));
   m_desc2 = copy_m_desc(m_desc);
   delete_m_desc(m_desc);
   delete_m_desc(m_desc2);
   check_memory_usage("test_m_desc3");
 }

void test_m_desc()
{
    printf("testing m_desc...\n");
    test_m_desc1();
    test_m_desc2();
    test_m_desc3();
}

/************************/
/*     m2_desc          */
/************************/
void test_m2_desc1()
{
    M2Desc   *m2_desc = new_m2_desc();
    assert(is_m2_desc(m2_desc));
    delete_m2_desc(m2_desc);
    check_memory_usage("test_m2_desc1");
}

void test_m2_desc2()
{

     MDesc   *m_desc1 = new_m_desc(), *m_desc12;
     char    op = '+', op2;
     MDesc   *m_desc2 = new_m_desc(), *m_desc22;
     M2Desc  *m2_desc;

     assert(fis_m2_desc(NULL));
     assert(fis_m2_desc(m2_desc = create_m2_desc(m_desc1,op,m_desc2)));

     assert(! is_m2_desc(m_desc1));
     assert(! fis_m2_desc(m_desc1));
     decompose_m2_desc(m2_desc,&m_desc12,&op2,&m_desc22);
     assert(m_desc12 == m_desc1 && op == op2 && m_desc22 == m_desc2);
     assert(read_m_desc1(m2_desc) == m_desc1 && read_m_op(m2_desc) == op &&
            read_m_desc2(m2_desc) == m_desc2);
     delete_m2_desc(m2_desc);
     check_memory_usage("test_m2_desc2");
}

void test_m2_desc3()
{
     M2Desc  *m2_desc = new_m2_desc();
     MDesc   *m_desc1 = new_m_desc(), *m_desc12;
     char    op = '+', op2;
     MDesc   *m_desc2 = new_m_desc(), *m_desc22;

    decompose_m2_desc(set_m2_desc(m2_desc,m_desc1,op,m_desc2),&m_desc12,&op2,
                      &m_desc22);
    assert(m_desc12 == m_desc1 && op == op2 && m_desc2 == m_desc22);
    delete_m2_desc(m2_desc);
    check_memory_usage("test_m2_desc3");
}

void test_m2_desc4()
{
     M2Desc  *m2_desc = new_m2_desc(),*m2_desc2;
     MDesc   *m_desc1 = new_m_desc(), *m_desc12;
     char    op = '+', op2;
     MDesc   *m_desc2 = new_m_desc(), *m_desc22;

    decompose_m2_desc(
          write_m_desc1(
            write_m_op(
              write_m_desc2(m2_desc,m_desc2),
                          op),
                         m_desc1),&m_desc12,&op2,&m_desc22);
    assert(m_desc12 == m_desc1 && op == op2 && m_desc22 == m_desc2);
    m2_desc2 = copy_m2_desc(m2_desc);
    delete_m2_desc(m2_desc);
    delete_m2_desc(m2_desc2);
    check_memory_usage("test_m2_desc4"); 
  }

void test_m2_desc5()
{
     M2Desc  *m2_desc = new_m2_desc();
     MDesc   *m_desc1 = new_m_desc();
     char    op = '+';
     MDesc   *m_desc2 = new_m_desc();

     mwrite_m_desc1(m2_desc,m_desc1);
     mwrite_m_op(m2_desc,op);
     mwrite_m_desc2(m2_desc,m_desc2);
     assert(m_desc1 == mread_m_desc1(m2_desc) && op == mread_m_op(m2_desc) 
            && m_desc2 == mread_m_desc2(m2_desc));
      delete_m2_desc(m2_desc);
   }

void test_m2_desc()
{
    printf("testing m2_desc...\n");
    test_m2_desc1();
    test_m2_desc2();
    test_m2_desc3();
    test_m2_desc4();
    test_m2_desc5();
}

/************************/
/*   o_term             */
/************************/
void  test_o_term1()
{
   OTerm *o_term = new_o_term();
   assert(is_o_term(o_term));
   delete_o_term(o_term);
   check_memory_usage("test_o_term1");
}   

void  test_o_term2()
{
   Prolog *prolog = new_prolog();
   OTerm  *o_term;
   ModDef *mod_def = new_mod_def();

   assert(fis_o_term(NULL));
   assert(fis_o_term(o_term = create_o_term_prolog(prolog)));
   assert(! is_o_term(mod_def));
   assert(! fis_o_term(mod_def));
   delete_o_term(o_term);
   delete_mod_def(mod_def);
   check_memory_usage("test_o_term2");
 }

void  test_o_term3()
{
   COTerm    *c_o_term = new_c_o_term();
   OTerm     *o_term, *o_term2;

   assert(fis_o_term(o_term = create_o_term_c_o_term(c_o_term)));
   o_term2 = copy_o_term(o_term);
   delete_o_term(o_term);
   delete_o_term(o_term2);
   check_memory_usage("test_o_term3");
 }

void  test_o_term4()
{
   Var       *var = new_var();
   OTerm     *o_term;

   assert(fis_o_term(o_term = create_o_term_var(var)));
   delete_o_term(o_term);
   check_memory_usage("test_o_term4");
 }

void  test_o_term5()
{
   Dot       *dot = new_dot();
   OTerm     *o_term;

   assert(fis_o_term(o_term = create_o_term_dot(dot)));
   delete_o_term(o_term);
      check_memory_usage("test_o_term5");
 }

void  test_o_term6()
{
   List      *list = new_list();
   OTerm     *o_term;

   assert(fis_o_term(o_term = create_o_term_list(list)));
   delete_o_term(o_term);
   check_memory_usage("test_o_term6");
 }

void  test_o_term7()
{
   NonStruct *non_struct = new_non_struct();
   OTerm     *o_term;

   assert(fis_o_term(o_term = create_o_term_non_struct(non_struct)));
   delete_o_term(o_term);
     check_memory_usage("test_o_term7");
 }

void test_o_term()
{
    printf("testing o_term...\n");
    test_o_term1();
    test_o_term2();
    test_o_term3();
    test_o_term4();
    test_o_term5();
    test_o_term6();
    test_o_term7();
}

/************************/
/*   link_def           */
/************************/
void test_link_def1()
{
    LinkDef* link_def  = NULL;
    assert(is_link_def(link_def));
    link_def = new_link_def();
    assert(is_link_def(link_def));
    delete_link_def(link_def);
    check_memory_usage("test_link_def1");
}

void test_link_def2()
{
    ObjList* links = new_obj_list(LINK), *links2;
    LinkDef*  link_def;

    assert(fis_link_def(NULL));
    assert(fis_link_def(link_def = create_link_def(links)));
    
    assert(! is_link_def(links));
    assert(! fis_link_def(links));
    decompose_link_def(link_def, &links2);
    assert(links2 == links);
    delete_link_def(link_def);
    check_memory_usage("test_link_def2");
}

void test_link_def3()
{
    LinkDef *link_def = new_link_def(), *link_def2;
    ObjList *links = new_obj_list(LINK), *links2;

    decompose_link_def(set_link_def(link_def,links),&links2);
    assert(links2 == links);
    link_def2 = copy_link_def(link_def);
    delete_link_def(link_def);
    delete_link_def(link_def2);
    check_memory_usage("test_link_def3");
}

void test_link_def4()
{
    LinkDef *link_def = new_link_def();
    ObjList *links = new_obj_list(LINK);

    mwrite_links(link_def,links);
    assert(links == mread_links(link_def));
    delete_link_def(link_def);
  }


void  test_link_def5()
{
  LinkDef   *link_def;
  ObjList   *obj_list,*obj_list2;
  Link  *link,*link2,*link3,*link4;

  link_def = new_link_def();
  obj_list = new_obj_list(LINK);
  obj_list2 = new_obj_list(LINK);
  link = new_link();
  link2 = new_link();
  link3 = new_link();
  link4 = new_link();
  append_to_obj_list(append_to_obj_list(obj_list,link),link2);
  append_to_obj_list(append_to_obj_list(obj_list2,link3),link4);
  insert_links(insert_links(link_def,obj_list2),obj_list);
  assert(car_of_links(link_def) == link &&
         car_of_links(link_def) == link2 &&
         car_of_links(link_def) == link3 &&
         car_of_links(link_def) == link4);

  obj_list = new_obj_list(LINK);
  obj_list2 = new_obj_list(LINK);  
  cons_to_obj_list(cons_to_obj_list(obj_list,link),link2);
  cons_to_obj_list(cons_to_obj_list(obj_list2,link3),link4);
  add_links(add_links(link_def,obj_list2),obj_list);
  assert(car_of_links(link_def) == link4 &&
         car_of_links(link_def) == link3 &&
         car_of_links(link_def) == link2 &&
         car_of_links(link_def) == link);
  delete_link(link);
  delete_link(link2);
  delete_link(link3);
  delete_link(link4);
  delete_link_def(link_def);
  check_memory_usage("test_link_def5");
}

void test_link_def()
{
    printf("testing link_def...\n");
    test_link_def1();
    test_link_def2();
    test_link_def3();
    test_link_def4();
    test_link_def5();
}

/************************/
/*   link               */
/************************/
void test_link1()
{
    Link  *link = new_link();
    assert(is_link(link));
    delete_link(link);
    check_memory_usage("test_link1");
}

void test_link2()
{
    char     *link_name = dotsrc_malloc(strlen("test") +1), *link_name2;
    ObjList  *m_ids = new_obj_list(M_ID_PAIR), *m_ids2;
    ObjList  *o_terms = new_obj_list(O_TERM_PAIR),*o_terms2;
    Link     *link;

    strcpy(link_name,"test");
    assert(fis_link(NULL));
    assert(fis_link(link = create_link(link_name,m_ids,o_terms)));

    assert(! is_link(o_terms));
    assert(! is_link(o_terms));
    decompose_link(link, &link_name2,&m_ids2, &o_terms2);
    assert(link_name2 == link_name  && m_ids2 == m_ids && o_terms == o_terms2);
    assert(read_link_name(link) == link_name && 
           read_m_ids_inLink(link) == m_ids &&
           read_o_terms_inLink(link) == o_terms);
    delete_link(link);
    if(link_name2 != NULL)
    check_memory_usage("test_link2");
}

void test_link3()
{
    Link *link = new_link();
    char *link_name = dotsrc_malloc(strlen("test")), *link_name2;
    ObjList  *m_ids = new_obj_list(M_ID_PAIR), *m_ids2;
    ObjList  *o_terms = new_obj_list(O_TERM_PAIR),*o_terms2;
    
    strcpy(link_name,"test");
    decompose_link(set_link(link,link_name,m_ids,o_terms),
                            &link_name2,&m_ids2,&o_terms2);
    assert(link_name2 == link_name && m_ids2 == m_ids && o_terms2 == o_terms);
    delete_link(link);
    if(link_name2 != NULL)
    check_memory_usage("test_link3");
}

void test_link4()
{
    Link     *link = new_link(),*link2;
    char     *link_name = dotsrc_malloc(strlen("test")), *link_name2;
    ObjList  *m_ids = new_obj_list(M_ID_PAIR), *m_ids2;
    ObjList  *o_terms = new_obj_list(O_TERM_PAIR),*o_terms2;

    strcpy(link_name,"test");
    decompose_link(
          write_link_name(
           write_m_ids_inLink(
            write_o_terms_inLink(link,o_terms),m_ids),link_name),
                    &link_name2,&m_ids2,&o_terms2);
    assert(strcmp(link_name2,link_name) == 0  && m_ids2 == m_ids && o_terms2 == o_terms);
    link2 = copy_link(link);
    delete_link(link);
    delete_link(link2);
    check_memory_usage("test_link4");
}

void test_link5()
{
    Link     *link = new_link();
    char     *link_name = dotsrc_malloc(strlen("test"));
    ObjList  *m_ids = new_obj_list(M_ID_PAIR);
    ObjList  *o_terms = new_obj_list(O_TERM_PAIR);

    strcpy(link_name,"test");
    mwrite_link_name(link,link_name);
    mwrite_m_ids_inLink(link,m_ids);
    mwrite_o_terms_inLink(link,o_terms);
    assert(link_name == mread_link_name(link) && m_ids == mread_m_ids_inLink(link)
           && o_terms == mread_o_terms_inLink(link));
    delete_link(link);
  }


void  test_link6()
{
  Link   *link;
  ObjList   *obj_list,*obj_list2;
  MId  *m_id,*m_id2,*m_id3,*m_id4;

  link = new_link();
  obj_list = new_obj_list(M_ID);
  obj_list2 = new_obj_list(M_ID);
  m_id = new_o_term();
  m_id2 = new_o_term();
  m_id3 = new_o_term();
  m_id4 = new_o_term();
  append_to_obj_list(append_to_obj_list(obj_list,m_id),m_id2);
  append_to_obj_list(append_to_obj_list(obj_list2,m_id3),m_id4);
  insert_m_ids_inLink(insert_m_ids_inLink(link,obj_list2),obj_list);
  assert(car_of_m_ids_inLink(link) == m_id &&
         car_of_m_ids_inLink(link) == m_id2 &&
         car_of_m_ids_inLink(link) == m_id3 &&
         car_of_m_ids_inLink(link) == m_id4);

  obj_list = new_obj_list(M_ID);
  obj_list2 = new_obj_list(M_ID);  
  cons_to_obj_list(cons_to_obj_list(obj_list,m_id),m_id2);
  cons_to_obj_list(cons_to_obj_list(obj_list2,m_id3),m_id4);
  add_m_ids_inLink(add_m_ids_inLink(link,obj_list2),obj_list);
  assert(car_of_m_ids_inLink(link) == m_id4 &&
         car_of_m_ids_inLink(link) == m_id3 &&
         car_of_m_ids_inLink(link) == m_id2 &&
         car_of_m_ids_inLink(link) == m_id);
  delete_o_term(m_id);
  delete_o_term(m_id2);
  delete_o_term(m_id3);
  delete_o_term(m_id4);
  delete_link(link);
  check_memory_usage("test_link6");
}

void  test_link7()
{
  Link      *link;
  ObjList   *obj_list,*obj_list2;
  OTerm     *o_term,*o_term2,*o_term3,*o_term4;

  link = new_link();
  obj_list = new_obj_list(O_TERM);
  obj_list2 = new_obj_list(O_TERM);
  o_term = new_o_term();
  o_term2 = new_o_term();
  o_term3 = new_o_term();
  o_term4 = new_o_term();
  append_to_obj_list(append_to_obj_list(obj_list,o_term),o_term2);
  append_to_obj_list(append_to_obj_list(obj_list2,o_term3),o_term4);
  insert_o_terms_inLink(insert_o_terms_inLink(link,obj_list2),obj_list);
  assert(car_of_o_terms_inLink(link) == o_term &&
         car_of_o_terms_inLink(link) == o_term2 &&
         car_of_o_terms_inLink(link) == o_term3 &&
         car_of_o_terms_inLink(link) == o_term4);

  obj_list = new_obj_list(O_TERM);
  obj_list2 = new_obj_list(O_TERM);  
  cons_to_obj_list(cons_to_obj_list(obj_list,o_term),o_term2);
  cons_to_obj_list(cons_to_obj_list(obj_list2,o_term3),o_term4);
  add_o_terms_inLink(add_o_terms_inLink(link,obj_list2),obj_list);
  assert(car_of_o_terms_inLink(link) == o_term4 &&
         car_of_o_terms_inLink(link) == o_term3 &&
         car_of_o_terms_inLink(link) == o_term2 &&
         car_of_o_terms_inLink(link) == o_term);
  delete_o_term(o_term);
  delete_o_term(o_term2);
  delete_o_term(o_term3);
  delete_o_term(o_term4);
  delete_link(link);
  check_memory_usage("test_link7");
}

 void test_link()
{
    printf("testing link...\n");
    test_link1();
    test_link2();
    test_link3();
    test_link4();
    test_link5();
    test_link6();
    test_link7();
}

/************************/
/*    m_id_pair       */
/************************/
void test_m_id_pair1()
{
    MIdPair  *m_id_pair = new_m_id_pair();
    assert(is_m_id_pair(m_id_pair));
    delete_m_id_pair(m_id_pair);
    check_memory_usage("test_m_id_pair1");
}

void test_m_id_pair2()
{
   MId     *m_id1 = new_o_term(), *m_id12,
           *m_id2 = new_o_term(), *m_id22;
  MIdPair  *m_id_pair;
    assert(fis_m_id_pair(NULL));
    assert(fis_m_id_pair(m_id_pair = create_m_id_pair(m_id1,m_id2)));

    assert(! is_m_id_pair(m_id1));
    assert(! is_m_id_pair(m_id1));
    decompose_m_id_pair(m_id_pair,&m_id12,&m_id22);
    assert(m_id12 == m_id1 && m_id22 == m_id2);
    assert(read_m_id1(m_id_pair) == m_id1 && 
           read_m_id2(m_id_pair) == m_id2);
    delete_m_id_pair(m_id_pair);
    check_memory_usage("test_m_id_pair2");
}

void test_m_id_pair3()
{
   MIdPair  *m_id_pair = new_m_id_pair();
   MId      *m_id1 = new_o_term(), *m_id12,
            *m_id2 = new_o_term(), *m_id22;

    decompose_m_id_pair(set_m_id_pair(m_id_pair,m_id1,m_id2),
                            &m_id12,&m_id22);
    assert(m_id12 == m_id1 && m_id22 == m_id2);
    delete_m_id_pair(m_id_pair);
    check_memory_usage("test_m_id_pair3");
}

void test_m_id_pair4()
{
   MIdPair  *m_id_pair = new_m_id_pair(), *m_id_pair2;
   MId      *m_id1 = new_o_term(), *m_id12,
            *m_id2 = new_o_term(), *m_id22;

    decompose_m_id_pair(
           write_m_id1(write_m_id2(m_id_pair,m_id2),m_id1),
                    &m_id12,&m_id22);
    assert(m_id12 == m_id1 && m_id22 == m_id2);
    m_id_pair2 = copy_m_id_pair(m_id_pair);
    delete_m_id_pair(m_id_pair);
    delete_m_id_pair(m_id_pair2);
    check_memory_usage("test_m_id_pair4");
}

void test_m_id_pair5()
{
   MIdPair  *m_id_pair = new_m_id_pair();
   MId      *m_id1 = new_o_term(),*m_id2 = new_o_term();
    
    mwrite_m_id1(m_id_pair,m_id1);
    mwrite_m_id2(m_id_pair,m_id2);
    assert(m_id1 == mread_m_id1(m_id_pair) && m_id2 == mread_m_id2(m_id_pair));
    delete_m_id_pair(m_id_pair);
 }

 void test_m_id_pair()
{
    printf("testing m_id_pair...\n");
    test_m_id_pair1();
    test_m_id_pair2();
    test_m_id_pair3();
    test_m_id_pair4();
    test_m_id_pair5();
}

/************************/
/*    o_term_pair       */
/************************/
void test_o_term_pair1()
{
    OTermPair  *o_term_pair = new_o_term_pair();
    assert(is_o_term_pair(o_term_pair));
    delete_o_term_pair(o_term_pair);
    check_memory_usage("test_o_term_pair1");
}

void test_o_term_pair2()
{
   OTerm     *o_term1 = new_o_term(), *o_term12,
             *o_term2 = new_o_term(), *o_term22;
  OTermPair  *o_term_pair;
    assert(fis_o_term_pair(NULL));
    assert(fis_o_term_pair(o_term_pair = create_o_term_pair(o_term1,o_term2)));

    assert(! is_o_term_pair(o_term1));
    assert(! is_o_term_pair(o_term1));
    decompose_o_term_pair(o_term_pair,&o_term12,&o_term22);
    assert(o_term12 == o_term1 && o_term22 == o_term2);
    assert(read_o_term1(o_term_pair) == o_term1 && 
           read_o_term2(o_term_pair) == o_term2);
    delete_o_term_pair(o_term_pair);
    check_memory_usage("test_o_term_pair2");
}

void test_o_term_pair3()
{
   OTermPair  *o_term_pair = new_o_term_pair();
   OTerm      *o_term1 = new_o_term(), *o_term12,
              *o_term2 = new_o_term(), *o_term22;

    decompose_o_term_pair(set_o_term_pair(o_term_pair,o_term1,o_term2),
                            &o_term12,&o_term22);
    assert(o_term12 == o_term1 && o_term22 == o_term2);
    delete_o_term_pair(o_term_pair);
    check_memory_usage("test_o_term_pair3");
}

void test_o_term_pair4()
{
   OTermPair  *o_term_pair = new_o_term_pair(),*o_term_pair2;
   OTerm      *o_term1 = new_o_term(), *o_term12,
              *o_term2 = new_o_term(), *o_term22;

    decompose_o_term_pair(
           write_o_term1(write_o_term2(o_term_pair,o_term2),o_term1),
                    &o_term12,&o_term22);
    assert(o_term12 == o_term1 && o_term22 == o_term2);
    o_term_pair2 = copy_o_term_pair(o_term_pair);
    delete_o_term_pair(o_term_pair);
    delete_o_term_pair(o_term_pair2);
    check_memory_usage("test_o_term_pair4");
}

void test_o_term_pair5()
{
   OTermPair  *o_term_pair = new_o_term_pair();
   OTerm      *o_term1 = new_o_term(), *o_term2 = new_o_term();
    
    mwrite_o_term1(o_term_pair,o_term1);
    mwrite_o_term2(o_term_pair,o_term2);
    assert(o_term1 == mread_o_term1(o_term_pair) && o_term2 == mread_o_term2(o_term_pair));
    delete_o_term_pair(o_term_pair);
 }

 void test_o_term_pair()
{
    printf("testing o_term_pair...\n");
    test_o_term_pair1();
    test_o_term_pair2();
    test_o_term_pair3();
    test_o_term_pair4();
    test_o_term_pair5();
}

/************************/
/*   rule_def           */
/************************/
void test_rule_def1()
{
    RuleDef* rule_def  = NULL;
    assert(is_rule_def(rule_def));
    rule_def = new_rule_def();
    assert(is_rule_def(rule_def));
    delete_rule_def(rule_def);
    check_memory_usage("test_rule_def1");
}

void test_rule_def2()
{
    ObjList* rules = new_obj_list(RULE), *rules2;
    RuleDef*  rule_def;

    assert(fis_rule_def(NULL));
    assert(fis_rule_def(rule_def = create_rule_def(rules)));
    
    assert(! is_rule_def(rules));
    assert(! fis_rule_def(rules));
    decompose_rule_def(rule_def, &rules2);
    assert(rules2 == rules);
    delete_rule_def(rule_def);
    check_memory_usage("test_rule_def2");
}

void test_rule_def3()
{
    RuleDef *rule_def = new_rule_def(), *rule_def2;
    ObjList *rules = new_obj_list(RULE), *rules2;

    decompose_rule_def(set_rule_def(rule_def,rules),&rules2);
    assert(rules2 == rules);
    rule_def2 = copy_rule_def(rule_def);
    delete_rule_def(rule_def);
    delete_rule_def(rule_def2);
    check_memory_usage("test_rule_def3");
  }

void test_rule_def4()
{
    RuleDef *rule_def = new_rule_def();
    ObjList *rules = new_obj_list(RULE);

    mwrite_rules(rule_def,rules);
    assert(rules == mread_rules(rule_def));
    delete_rule_def(rule_def);
  }

void  test_rule_def5()
{
  RuleDef   *rule_def;
  ObjList   *obj_list,*obj_list2;
  Rule  *rule,*rule2,*rule3,*rule4;

  rule_def = new_rule_def();
  obj_list = new_obj_list(RULE);
  obj_list2 = new_obj_list(RULE);
  rule = new_rule();
  rule2 = new_rule();
  rule3 = new_rule();
  rule4 = new_rule();
  append_to_obj_list(append_to_obj_list(obj_list,rule),rule2);
  append_to_obj_list(append_to_obj_list(obj_list2,rule3),rule4);
  insert_rules(insert_rules(rule_def,obj_list2),obj_list);
  assert(car_of_rules(rule_def) == rule &&
         car_of_rules(rule_def) == rule2 &&
         car_of_rules(rule_def) == rule3 &&
         car_of_rules(rule_def) == rule4);

  obj_list = new_obj_list(RULE);
  obj_list2 = new_obj_list(RULE);  
  cons_to_obj_list(cons_to_obj_list(obj_list,rule),rule2);
  cons_to_obj_list(cons_to_obj_list(obj_list2,rule3),rule4);
  add_rules(add_rules(rule_def,obj_list2),obj_list);
  assert(car_of_rules(rule_def) == rule4 &&
         car_of_rules(rule_def) == rule3 &&
         car_of_rules(rule_def) == rule2 &&
         car_of_rules(rule_def) == rule);
  delete_rule(rule);
  delete_rule(rule2);
  delete_rule(rule3);
  delete_rule(rule4);
  delete_rule_def(rule_def);
  check_memory_usage("test_rule_def5");
}

void test_rule_def()
{
    printf("testing rule_def...\n");
    test_rule_def1();
    test_rule_def2();
    test_rule_def3();
    test_rule_def4();
    test_rule_def5();
  }

/************************/
/*   rule               */
/************************/
void test_rule1()
{
    Rule  *rule = new_rule();
    assert(is_rule(rule));
    delete_rule(rule);
    check_memory_usage("test_rule1");
}

void test_rule2()
{
    RuleClass         rule_class = RCUPDATE, rule_class2;
    ObjList           *m_ids = new_obj_list(O_TERM), *m_ids2;
    RuleId            *rule_id = new_rule_id(), *rule_id2;
    InheritanceMode   inheritance_mode = IML, inheritance_mode2;
    NoAssume          no_assume = NOASSUME, no_assume2;
    ATerm             *a_term = new_a_term(), *a_term2;
    ObjList           *clusters = new_obj_list(CLUSTER),*clusters2;     
    ObjList           *cnstrs = new_obj_list(CNSTR),*cnstrs2;
    Rule              *rule;

    assert(fis_rule(NULL));
    assert(fis_rule(rule = create_rule(rule_class,m_ids,
                           rule_id,inheritance_mode,no_assume,a_term,
                           clusters,cnstrs)));
    assert(! is_rule(a_term));
    assert(! is_rule(a_term));
    decompose_rule(rule, &rule_class2,&m_ids2,&rule_id2,&inheritance_mode2,
                   &no_assume2,&a_term2,&clusters2,&cnstrs2);
    assert(rule_class2 == rule_class && m_ids2 == m_ids && 
           rule_id2 == rule_id && inheritance_mode == inheritance_mode2 &&
           no_assume2 == no_assume && a_term2 == a_term &&
           clusters2 == clusters && cnstrs2 == cnstrs);
    assert(read_rule_class(rule) == rule_class  &&
           read_m_ids_inRule(rule) == m_ids &&
           read_rule_id_inRule(rule) == rule_id &&
           read_inheritance_mode(rule) == inheritance_mode &&
           read_no_assume(rule) == no_assume &&
	   read_head_inRule(rule) == a_term  &&
           read_clusters_inRule(rule) == clusters &&
           read_cnstrs_inRule(rule) == cnstrs);
    delete_rule(rule);
    check_memory_usage("test_rule2");
}

void test_rule3()
{
    Rule *rule = new_rule();
    RuleClass         rule_class = RCUPDATE, rule_class2;
    ObjList           *m_ids = new_obj_list(O_TERM), *m_ids2;
    RuleId            *rule_id = new_rule_id(), *rule_id2;
    InheritanceMode   inheritance_mode = IML, inheritance_mode2;
    NoAssume          no_assume = NOASSUME, no_assume2;
    ATerm             *a_term = new_a_term(), *a_term2;
    ObjList           *clusters = new_obj_list(CLUSTER),*clusters2;     
    ObjList           *cnstrs = new_obj_list(CNSTR),*cnstrs2;

    decompose_rule(set_rule(rule,rule_class,m_ids,rule_id,inheritance_mode,
                            no_assume,a_term,clusters,cnstrs),
                            &rule_class2,&m_ids2,&rule_id2,&inheritance_mode2,
                            &no_assume2,&a_term2,&clusters2,&cnstrs2);
    assert(rule_class2 == rule_class && m_ids2 == m_ids && 
           rule_id2 == rule_id && inheritance_mode == inheritance_mode2 &&
           no_assume2 == no_assume && a_term2 == a_term &&
           clusters2 == clusters && cnstrs2 == cnstrs);
    delete_rule(rule);
    check_memory_usage("test_rule3");
}

void test_rule4()
{
    Rule     *rule = new_rule(),*rule2;
    RuleClass         rule_class = RCUPDATE, rule_class2;
    ObjList           *m_ids = new_obj_list(O_TERM), *m_ids2;
    RuleId            *rule_id = new_rule_id(), *rule_id2;
    InheritanceMode   inheritance_mode = IML, inheritance_mode2;
    NoAssume          no_assume = NOASSUME, no_assume2;
    ATerm             *a_term = new_a_term(), *a_term2;
    ObjList           *clusters = new_obj_list(CLUSTER),*clusters2;
    ObjList           *cnstrs = new_obj_list(CNSTR),*cnstrs2;

    decompose_rule(
          write_rule_class(
           write_m_ids_inRule(
            write_rule_id_inRule(
             write_inheritance_mode_inRule(
              write_no_assume_inRule(
               write_head_inRule(
                write_clusters_inRule(
                 write_cnstrs_inRule(rule,cnstrs),clusters),a_term),
                  no_assume),inheritance_mode),rule_id),m_ids),rule_class),
            &rule_class2,&m_ids2,&rule_id2,&inheritance_mode2,&no_assume2,
            &a_term2,&clusters2,&cnstrs2);
    assert(rule_class2 == rule_class && m_ids2 == m_ids && 
           rule_id2 == rule_id && inheritance_mode == inheritance_mode2 &&
           no_assume2 == no_assume && a_term2 == a_term &&
           clusters2 == clusters && cnstrs2 == cnstrs);
    rule2 = copy_rule(rule);
    delete_rule(rule);
    delete_rule(rule2);
    check_memory_usage("test_rule4");
  }

void test_rule5()
{
    Rule              *rule = new_rule();
    RuleClass         rule_class = RCUPDATE;
    ObjList           *m_ids = new_obj_list(O_TERM);
    RuleId            *rule_id = new_rule_id();
    InheritanceMode   inheritance_mode = IML;
    NoAssume          no_assume = NOASSUME;
    ATerm             *a_term = new_a_term();
    ObjList           *clusters = new_obj_list(CLUSTER);
    ObjList           *cnstrs = new_obj_list(CNSTR);

     mwrite_rule_class(rule,rule_class);
     mwrite_m_ids_inRule(rule,m_ids);
     mwrite_rule_id(rule,rule_id);
     mwrite_inheritance_mode(rule,inheritance_mode);
     mwrite_no_assume(rule,no_assume);
     mwrite_a_term_inRule(rule,a_term);
     mwrite_clusters_inRule(rule,clusters);
     mwrite_cnstrs_inRule(rule,cnstrs);
     assert(rule_class == mread_rule_class(rule) && m_ids == mread_m_ids_inRule(rule)
            && inheritance_mode == mread_inheritance_mode(rule) 
            && no_assume == mread_no_assume(rule) && a_term == mread_a_term_inRule(rule)
            && clusters == mread_clusters_inRule(rule) && cnstrs == mread_cnstrs_inRule(rule));
     delete_rule(rule);
}

void  test_rule6()
{
  Rule   *rule;
  ObjList   *obj_list,*obj_list2;
  MId  *m_id,*m_id2,*m_id3,*m_id4;

  rule = new_rule();
  obj_list = new_obj_list(M_ID);
  obj_list2 = new_obj_list(M_ID);
  m_id = new_o_term();
  m_id2 = new_o_term();
  m_id3 = new_o_term();
  m_id4 = new_o_term();
  append_to_obj_list(append_to_obj_list(obj_list,m_id),m_id2);
  append_to_obj_list(append_to_obj_list(obj_list2,m_id3),m_id4);
  insert_m_ids_inRule(insert_m_ids_inRule(rule,obj_list2),obj_list);
  assert(car_of_m_ids_inRule(rule) == m_id &&
         car_of_m_ids_inRule(rule) == m_id2 &&
         car_of_m_ids_inRule(rule) == m_id3 &&
         car_of_m_ids_inRule(rule) == m_id4);

  obj_list = new_obj_list(M_ID);
  obj_list2 = new_obj_list(M_ID);  
  cons_to_obj_list(cons_to_obj_list(obj_list,m_id),m_id2);
  cons_to_obj_list(cons_to_obj_list(obj_list2,m_id3),m_id4);
  add_m_ids_inRule(add_m_ids_inRule(rule,obj_list2),obj_list);
  assert(car_of_m_ids_inRule(rule) == m_id4 &&
         car_of_m_ids_inRule(rule) == m_id3 &&
         car_of_m_ids_inRule(rule) == m_id2 &&
         car_of_m_ids_inRule(rule) == m_id);
  delete_o_term(m_id);
  delete_o_term(m_id2);
  delete_o_term(m_id3);
  delete_o_term(m_id4);
  delete_rule(rule);
  check_memory_usage("test_rule6");
}
 
void  test_rule7()
{
  Rule   *rule;
  ObjList   *obj_list,*obj_list2;
  Cluster  *cluster,*cluster2,*cluster3,*cluster4;

  rule = new_rule();
  obj_list = new_obj_list(CLUSTER);
  obj_list2 = new_obj_list(CLUSTER);
  cluster = new_cluster();
  cluster2 = new_cluster();
  cluster3 = new_cluster();
  cluster4 = new_cluster();
  append_to_obj_list(append_to_obj_list(obj_list,cluster),cluster2);
  append_to_obj_list(append_to_obj_list(obj_list2,cluster3),cluster4);
  insert_clusters_inRule(insert_clusters_inRule(rule,obj_list2),obj_list);
  assert(car_of_clusters_inRule(rule) == cluster &&
         car_of_clusters_inRule(rule) == cluster2 &&
         car_of_clusters_inRule(rule) == cluster3 &&
         car_of_clusters_inRule(rule) == cluster4);

  obj_list = new_obj_list(CLUSTER);
  obj_list2 = new_obj_list(CLUSTER);  
  cons_to_obj_list(cons_to_obj_list(obj_list,cluster),cluster2);
  cons_to_obj_list(cons_to_obj_list(obj_list2,cluster3),cluster4);
  add_clusters_inRule(add_clusters_inRule(rule,obj_list2),obj_list);
  assert(car_of_clusters_inRule(rule) == cluster4 &&
         car_of_clusters_inRule(rule) == cluster3 &&
         car_of_clusters_inRule(rule) == cluster2 &&
         car_of_clusters_inRule(rule) == cluster);
  delete_cluster(cluster);
  delete_cluster(cluster2);
  delete_cluster(cluster3);
  delete_cluster(cluster4);
  delete_rule(rule);
  check_memory_usage("test_rule7");
}
 
void  test_rule8()
{
  Rule   *rule;
  ObjList   *obj_list,*obj_list2;
  Cnstr  *cnstr,*cnstr2,*cnstr3,*cnstr4;

  rule = new_rule();
  obj_list = new_obj_list(CNSTR);
  obj_list2 = new_obj_list(CNSTR);
  cnstr = new_cnstr();
  cnstr2 = new_cnstr();
  cnstr3 = new_cnstr();
  cnstr4 = new_cnstr();
  append_to_obj_list(append_to_obj_list(obj_list,cnstr),cnstr2);
  append_to_obj_list(append_to_obj_list(obj_list2,cnstr3),cnstr4);
  insert_cnstrs_inRule(insert_cnstrs_inRule(rule,obj_list2),obj_list);
  assert(car_of_cnstrs_inRule(rule) == cnstr &&
         car_of_cnstrs_inRule(rule) == cnstr2 &&
         car_of_cnstrs_inRule(rule) == cnstr3 &&
         car_of_cnstrs_inRule(rule) == cnstr4);

  obj_list = new_obj_list(CNSTR);
  obj_list2 = new_obj_list(CNSTR);  
  cons_to_obj_list(cons_to_obj_list(obj_list,cnstr),cnstr2);
  cons_to_obj_list(cons_to_obj_list(obj_list2,cnstr3),cnstr4);
  add_cnstrs_inRule(add_cnstrs_inRule(rule,obj_list2),obj_list);
  assert(car_of_cnstrs_inRule(rule) == cnstr4 &&
         car_of_cnstrs_inRule(rule) == cnstr3 &&
         car_of_cnstrs_inRule(rule) == cnstr2 &&
         car_of_cnstrs_inRule(rule) == cnstr);
  delete_cnstr(cnstr);
  delete_cnstr(cnstr2);
  delete_cnstr(cnstr3);
  delete_cnstr(cnstr4);
  delete_rule(rule);
  check_memory_usage("test_rule8");
}
 
 void test_rule()
{
    printf("testing rule...\n");
    test_rule1();
    test_rule2();
    test_rule3();
    test_rule4();
    test_rule5();
    test_rule6();
    test_rule7();
    test_rule8();
}

/************************/
/*     rule_id          */
/************************/
void test_rule_id1()
{
    RuleId*  rule_id = new_rule_id();
    assert(is_rule_id(rule_id));
    delete_rule_id(rule_id);
    check_memory_usage("test_rule_id1");
}

void test_rule_id2()
{
    char      *rule_id_string = dotsrc_malloc(strlen("test") + 1), 
              *rule_id_string2;
    RuleId    *rule_id; 
    ModDef    *mod_def = new_mod_def();

    strcpy(rule_id_string,"test");
    assert(fis_rule_id(NULL));
    assert(fis_rule_id(rule_id = create_rule_id(rule_id_string)));

    assert(! is_rule_id(mod_def));
    assert(! fis_rule_id(mod_def));
    decompose_rule_id(rule_id, &rule_id_string2);
    assert(rule_id_string2 == rule_id_string);
    delete_rule_id(rule_id);
    delete_mod_def(mod_def);
    if(rule_id_string2 != NULL)
    check_memory_usage("test_rule_id2");
}

void test_rule_id3()
{
    RuleId   *rule_id = new_rule_id(), *rule_id2;
    char     *rule_id_string = dotsrc_malloc(strlen("test")), 
             *rule_id_string2;

    strcpy(rule_id_string,"test");
    decompose_rule_id(set_rule_id(rule_id,rule_id_string),&rule_id_string2);
    assert(rule_id_string2 == rule_id_string);
    rule_id2 = copy_rule_id(rule_id);
    delete_rule_id(rule_id);
    delete_rule_id(rule_id2);
    check_memory_usage("test_rule_id3");
}

void test_rule_id4()
{
    RuleId   *rule_id = new_rule_id();
    char     *rule_id_string = dotsrc_malloc(strlen("test"));

    strcpy(rule_id_string,"test");
    mwrite_rule_id_string(rule_id,rule_id_string);
    assert(rule_id_string == mread_rule_id_string(rule_id));
    delete_rule_id(rule_id);
  }

void test_rule_id()
{
    printf("testing rule_id...\n");
    test_rule_id1();
    test_rule_id2();
    test_rule_id3();
    test_rule_id4();
}

/************************/
/*   cluster             */
/************************/
void  test_cluster1()
{
   Cluster *cluster = new_cluster();
   assert(is_cluster(cluster));
   delete_cluster(cluster);
   check_memory_usage("test_cluster1");
}   

void  test_cluster2()
{
   Normal   *normal = new_normal();
   Cluster  *cluster;
   ModDef   *mod_def = new_mod_def();

   assert(fis_cluster(NULL));
   assert(fis_cluster(cluster = create_cluster_normal(normal)));
   assert(! is_cluster(mod_def));
   assert(! fis_cluster(mod_def));
   delete_cluster(cluster);
   delete_mod_def(mod_def);
   check_memory_usage("test_cluster2");
 }

 void  test_cluster3()
{
   Rel       *rel = new_rel();
   Cluster   *cluster, *cluster2;

   assert(fis_cluster(cluster = create_cluster_rel(rel)));
   cluster2 = copy_cluster(cluster);
   delete_cluster(cluster);
   delete_cluster(cluster2);
   check_memory_usage("test_cluster3");
 }

 void  test_cluster4()
{
   Update    *update = new_update();
   Cluster   *cluster;

   assert(fis_cluster(cluster = create_cluster_update(update)));
   delete_cluster(cluster);
   check_memory_usage("test_cluster4");
 }

 void  test_cluster5()
{
   Transaction  *transaction = new_transaction();
   Cluster      *cluster;

   assert(fis_cluster(cluster = create_cluster_transaction(transaction)));
   delete_cluster(cluster);
   check_memory_usage("test_cluster5");
 }

 void  test_cluster6()
{
   Consis    *consis = new_i_check();
   Cluster   *cluster;

   consis->tag = CONSIS;
   assert(fis_cluster(cluster = create_cluster_consis(consis)));
   delete_cluster(cluster);
   check_memory_usage("test_cluster6");
 }

 void  test_cluster7()
{
   InConsis  *inconsis = new_i_check();
   Cluster   *cluster;

   inconsis->tag = INCONSIS;
   assert(fis_cluster(cluster = create_cluster_inconsis(inconsis)));
   delete_cluster(cluster);
   check_memory_usage("test_cluster7");
 }

void test_cluster()
{
    printf("testing cluster...\n");
    test_cluster1();
    test_cluster2();
    test_cluster3();
    test_cluster4();
    test_cluster5();
    test_cluster6();
    test_cluster7();
}

/************************/
/*    normal            */
/************************/
void test_normal1()
{
    Normal  *normal = new_normal();
    assert(is_normal(normal));
    delete_normal(normal);
    check_memory_usage("test_normal1");
}

void test_normal2()
{
  MId     *m_id = new_o_term(),*m_id2;
  ATerm   *a_term = new_a_term(), *a_term2;
  Normal  *normal;

    assert(fis_normal(NULL));
    assert(fis_normal(normal = create_normal(m_id,a_term)));

    assert(! is_normal(a_term));
    assert(! is_normal(a_term));
    decompose_normal(normal,&m_id2,&a_term2);
    assert(m_id2 == m_id && a_term2 == a_term);
    assert(read_m_id_inNormal(normal) == m_id && 
           read_a_term_inNormal(normal) == a_term);
    delete_normal(normal);
    check_memory_usage("test_normal2");
}

void test_normal3()
{
  Normal   *normal = new_normal();
  MId      *m_id = new_o_term(),*m_id2;
  ATerm    *a_term = new_a_term(), *a_term2;

    decompose_normal(set_normal(normal,m_id,a_term),
                            &m_id2,&a_term2);
    assert(m_id2 == m_id && a_term2 == a_term);
    delete_normal(normal);
    check_memory_usage("test_normal3");
}

void test_normal4()
{
   Normal  *normal = new_normal(),*normal2;
  MId      *m_id = new_o_term(),*m_id2;
  ATerm    *a_term = new_a_term(), *a_term2;

    decompose_normal(
           write_m_id_inNormal(write_a_term_inNormal(normal,a_term),m_id),
                    &m_id2,&a_term2);
    assert(m_id2 == m_id && a_term2 == a_term);
    normal2 = copy_normal(normal);
    delete_normal(normal);
    delete_normal(normal2);
    check_memory_usage("test_normal4");
}

void test_normal5()
{
  Normal  *normal = new_normal();
  MId      *m_id = new_o_term();
  ATerm    *a_term = new_a_term();

  mwrite_m_id_inNormal(normal,m_id);
  mwrite_a_term_inNormal(normal,a_term);
  assert(m_id == mread_m_id_inNormal(normal) && a_term == mread_a_term_inNormal(normal));
  delete_normal(normal);
}

 void test_normal()
{
    printf("testing normal...\n");
    test_normal1();
    test_normal2();
    test_normal3();
    test_normal4();
    test_normal5();
}

/************************/
/*    rel               */
/************************/
void test_rel1()
{
    Rel  *rel = new_rel();
    assert(is_rel(rel));
    delete_rel(rel);
    check_memory_usage("test_rel1");
}

void test_rel2()
{
  OTerm  *o_term1 = new_o_term(), *o_term12,
         *o_term2 = new_o_term(), *o_term22;
  CnRel  sub_rel = CNLE, sub_rel2;
  Rel    *rel;

    assert(fis_rel(NULL));
    assert(fis_rel(rel = create_rel(o_term1,sub_rel,o_term2)));

    assert(! is_rel(o_term1));
    assert(! is_rel(o_term1));
    decompose_rel(rel,&o_term12,&sub_rel2,&o_term22);
    assert(o_term12 == o_term1 && sub_rel2 == sub_rel && o_term22 == o_term2);
    assert(read_o_term1_inRel(rel) == o_term1 && 
           read_sub_rel_inRel(rel) == sub_rel &&
           read_o_term2_inRel(rel) == o_term2);
    delete_rel(rel);
    check_memory_usage("test_rel2");
}

void test_rel3()
{
  Rel   *rel = new_rel();
  OTerm  *o_term1 = new_o_term(), *o_term12,
         *o_term2 = new_o_term(), *o_term22;
  CnRel  sub_rel = CNLE, sub_rel2;
    decompose_rel(set_rel(rel,o_term1,sub_rel,o_term2),
                         &o_term12,&sub_rel2,&o_term22);
    assert(o_term12 == o_term1 && sub_rel2 == sub_rel && o_term22 == o_term2);
    delete_rel(rel);
    check_memory_usage("test_rel3");
}

void test_rel4()
{
  Rel    *rel = new_rel(),*rel2;
  OTerm  *o_term1 = new_o_term(), *o_term12,
         *o_term2 = new_o_term(), *o_term22;
  CnRel  sub_rel = CNLE, sub_rel2;

    decompose_rel(
           write_o_term1_inRel(
              write_sub_rel_inRel(
                write_o_term2_inRel(rel,o_term2),
              sub_rel),
           o_term1), &o_term12,&sub_rel2,&o_term22);
    assert(o_term12 == o_term1 && sub_rel2 == sub_rel && o_term22 == o_term2);
    rel2 = copy_rel(rel);
    delete_rel(rel);
    delete_rel(rel2);
    check_memory_usage("test_rel4");
}

void test_rel5()
{
  Rel    *rel = new_rel();
  OTerm  *o_term1 = new_o_term(), *o_term2 = new_o_term();
  CnRel  sub_rel = CNLE;

  mwrite_o_term1_inRel(rel,o_term1);
  mwrite_sub_rel_inRel(rel,sub_rel);
  mwrite_o_term2_inRel(rel,o_term2);
  assert(o_term1 == mread_o_term1_inRel(rel) && sub_rel == mread_sub_rel_inRel(rel) &&
         o_term2 == mread_o_term2_inRel(rel));
  delete_rel(rel);
}

 void test_rel()
{
    printf("testing rel...\n");
    test_rel1();
    test_rel2();
    test_rel3();
    test_rel4();
    test_rel5();
}

/************************/
/*    update               */
/************************/
void test_update1()
{
    Update  *update = new_update();
    assert(is_update(update));
    delete_update(update);
    check_memory_usage("test_update1");
}

void test_update2()
{
  UFlag     uflag = UFPLUS, uflag2;
  MId       *m_id = new_o_term(), *m_id2;
  ATerm     *a_term = new_a_term(),*a_term2;
  Update    *update;

    assert(fis_update(NULL));
    assert(fis_update(update = create_update(uflag,m_id,a_term)));

    assert(! is_update(a_term));
    assert(! is_update(a_term));
    decompose_update(update,&uflag2,&m_id2,&a_term2);
    assert(uflag2 == uflag && m_id2 == m_id && a_term2 == a_term);
    assert(read_u_flag(update) == uflag && 
           read_m_id_inUpdate(update) == m_id &&
           read_a_term_inUpdate(update) == a_term);
    delete_update(update);
    check_memory_usage("test_update2");
}

void test_update3()
{
  UFlag     uflag = UFPLUS, uflag2;
  MId       *m_id = new_o_term(), *m_id2;
  ATerm     *a_term = new_a_term(),*a_term2;
  Update    *update = new_update();

    decompose_update(set_update(update,uflag,m_id,a_term),
                        &uflag2,&m_id2,&a_term2);
    assert(uflag2 == uflag && m_id2 == m_id && a_term2 == a_term);
    delete_update(update);
    check_memory_usage("test_update3");
}

void test_update4()
{
  Update    *update = new_update(),*update2;
  UFlag     uflag = UFPLUS, uflag2;
  MId       *m_id = new_o_term(), *m_id2;
  ATerm     *a_term = new_a_term(),*a_term2;

    decompose_update(
           write_u_flag(
              write_m_id_inUpdate(
                write_a_term_inUpdate(update,a_term),
              m_id),
           uflag), &uflag2,&m_id2,&a_term2);
    assert(uflag2 == uflag && m_id2 == m_id && a_term2 == a_term);
    update2 = copy_update(update);
    delete_update(update);
    delete_update(update2);
    check_memory_usage("test_update4");
}

void test_update5()
{
  Update    *update = new_update();
  UFlag     uflag = UFPLUS;
  MId       *m_id = new_o_term();
  ATerm     *a_term = new_a_term();

  mwrite_u_flag(update,uflag);
  mwrite_m_id_inUpdate(update,m_id);
  mwrite_a_term_inUpdate(update,a_term);
  assert(uflag == mread_u_flag(update) && m_id == mread_m_id_inUpdate(update)
         && a_term == mread_a_term_inUpdate(update));
  delete_update(update);
}

 void test_update()
{
    printf("testing update...\n");
    test_update1();
    test_update2();
    test_update3();
    test_update4();
    test_update5();
}

/************************/
/*     transaction      */
/************************/
void test_transaction1()
{
    Transaction *transaction = new_transaction();
    assert(is_transaction(transaction));
    delete_transaction(transaction);
    check_memory_usage("test_transaction1");
}

void test_transaction2()
{
    TrnData  trn_data = TDBT, trn_data2;
    Transaction *transaction;
    ModDef      *mod_def = new_mod_def();

    assert(fis_transaction(NULL));
    assert(fis_transaction(transaction = create_transaction(trn_data)));

    assert(! is_transaction(mod_def));
    assert(! fis_transaction(mod_def));
    decompose_transaction(transaction, &trn_data2);
    assert(trn_data2 == trn_data);
    delete_transaction(transaction);
    delete_mod_def(mod_def);
    check_memory_usage("test_transaction2");
}

void test_transaction3()
{
    Transaction  *transaction = new_transaction(), *transaction2;
    TrnData      trn_data = TDBT,trn_data2;

    decompose_transaction(set_transaction(transaction,trn_data),&trn_data2);
    assert(trn_data2 == trn_data);
    transaction2 = copy_transaction(transaction);
    delete_transaction(transaction);
    delete_transaction(transaction2);
    check_memory_usage("test_transaction3");
}

void test_transaction4()
{
    Transaction  *transaction = new_transaction();
    TrnData      trn_data = TDBT;

    mwrite_trn_data(transaction,trn_data);
    assert(trn_data == mread_trn_data(transaction));
    delete_transaction(transaction);
  }

void test_transaction()
{
    printf("testing transaction...\n");
    test_transaction1();
    test_transaction2();
    test_transaction3();
    test_transaction4();
}

/************************/
/*   i_check_content    */
/************************/
void  test_i_check_content1()
{
   ICheckContent *i_check_content = new_i_check_content();
   assert(is_i_check_content(i_check_content));
   delete_i_check_content(i_check_content);
   check_memory_usage("test_i_check_content1");
}   

void  test_i_check_content2()
{
   Prop    *prop = new_prop();
   ICheckContent  *i_check_content;
   ModDef *mod_def = new_mod_def();

   assert(fis_i_check_content(NULL));
   assert(fis_i_check_content(i_check_content = create_i_check_content_prop(prop)));
   assert(! is_i_check_content(mod_def));
   assert(! fis_i_check_content(mod_def));
   delete_i_check_content(i_check_content);
   delete_mod_def(mod_def);
   check_memory_usage("test_i_check2_content");
 }

void  test_i_check_content3()
{
   ObjList   *cnstrs = new_obj_list(CNSTR);
   ICheckContent    *i_check_content, *i_check_content2;

   assert(fis_i_check_content(i_check_content = create_i_check_content_cnstrs(cnstrs)));
   i_check_content2 = copy_i_check_content(i_check_content);
   delete_i_check_content(i_check_content);
   delete_i_check_content(i_check_content2);
   check_memory_usage("test_i_check_content3");
 }

void test_i_check_content()
{
    printf("testing i_check_content...\n");
    test_i_check_content1();
    test_i_check_content2();
    test_i_check_content3();
}

/************************/
/*   i_check            */
/************************/
void test_i_check1()
{
    ICheck* i_check  = NULL;
    assert(is_i_check(i_check));
    i_check = new_i_check();
    assert(is_i_check(i_check));
    delete_i_check(i_check);
    check_memory_usage("test_i_check1");
}

void test_i_check2()
{
    ICheckContent* i_check_content = new_i_check_content(), *i_check_content2;
    ICheck*  i_check;

    assert(fis_i_check(NULL));
    assert(fis_i_check(i_check = create_i_check(i_check_content)));
    assert(! is_i_check(i_check_content));
    assert(! fis_i_check(i_check_content));
    decompose_i_check(i_check, &i_check_content2);
    assert(i_check_content2 == i_check_content);
    delete_i_check(i_check);
    check_memory_usage("test_i_check2");
}

void test_i_check3()
{
    ICheck *i_check = new_i_check(), *i_check2;
    ICheckContent *i_check_content = new_i_check_content(), *i_check_content2;

    decompose_i_check(set_i_check(i_check,i_check_content),&i_check_content2);
    assert(i_check_content2 == i_check_content);
    i_check2 = copy_i_check(i_check);
    delete_i_check(i_check);
    delete_i_check(i_check2);
    check_memory_usage("test_i_check3");
}

void test_i_check4()
{
    ICheck *i_check = new_i_check();
    ICheckContent *i_check_content = new_i_check_content();

    mwrite_i_check_content(i_check,i_check_content);

    assert(i_check_content == mread_i_check_content(i_check));
    delete_i_check(i_check);
  }

void test_i_check()
{
    printf("testing i_check...\n");
    test_i_check1();
    test_i_check2();
    test_i_check3();
    test_i_check4();
}

/***************/
/*   consis    */
/***************/
void test_consis1()
{
    Consis* consis  = NULL;
    assert(is_consis(consis));
    consis = new_consis();
    assert(is_consis(consis));
    delete_i_check(consis);
    check_memory_usage("test_consis1");
}

void test_consis2()
{
    ICheckContent* i_check_content = new_i_check_content(), *i_check_content2;
    Consis*  consis;
    ICheck*  i_check = new_i_check();

    assert(fis_consis(NULL));
    assert(fis_consis(consis = create_consis(i_check_content)));
    assert(! is_consis(i_check));
    assert(! fis_consis(i_check));
    decompose_i_check(consis, &i_check_content2);
    assert(i_check_content2 == i_check_content);
    delete_i_check(consis);
    delete_i_check(i_check);
    check_memory_usage("test_i_check2");
}

void test_consis3()
{
    Consis *consis = new_consis(), *consis2;
    ICheckContent *i_check_content = new_i_check_content(), *i_check_content2;

    decompose_i_check(set_i_check(consis,i_check_content),&i_check_content2);
    assert(i_check_content2 == i_check_content);
    consis2 = copy_i_check(consis);
    delete_i_check(consis);
    delete_i_check(consis2);
    check_memory_usage("test_consis3");
}

void test_consis4()
{
    Consis *consis = new_consis();
    ICheckContent *i_check_content = new_i_check_content();

    mwrite_i_check_content(consis,i_check_content);

    assert(i_check_content == mread_i_check_content(consis));
    delete_i_check(consis);
  }

void test_consis()
{
    printf("testing consis...\n");
    test_consis1();
    test_consis2();
    test_consis3();
    test_consis4();
}

/***************/
/*   inconsis    */
/***************/
void test_inconsis1()
{
    InConsis* inconsis  = NULL;
    assert(is_inconsis(inconsis));
    inconsis = new_inconsis();
    assert(is_inconsis(inconsis));
    delete_i_check(inconsis);
    check_memory_usage("test_inconsis1");
}

void test_inconsis2()
{
    ICheckContent* i_check_content = new_i_check_content(), *i_check_content2;
    InConsis*  inconsis;
    ICheck*  i_check = new_i_check();

    assert(fis_inconsis(NULL));
    assert(fis_inconsis(inconsis = create_inconsis(i_check_content)));
    assert(! is_inconsis(i_check));
    assert(! fis_inconsis(i_check));
    decompose_i_check(inconsis, &i_check_content2);
    assert(i_check_content2 == i_check_content);
    delete_i_check(inconsis);
    delete_i_check(i_check);
    check_memory_usage("test_i_check2");
}

void test_inconsis3()
{
    InConsis *inconsis = new_inconsis(), *inconsis2;
    ICheckContent *i_check_content = new_i_check_content(), *i_check_content2;

    decompose_i_check(set_i_check(inconsis,i_check_content),&i_check_content2);
    assert(i_check_content2 == i_check_content);
    inconsis2 = copy_i_check(inconsis);
    delete_i_check(inconsis);
    delete_i_check(inconsis2);
    check_memory_usage("test_inconsis3");
}

void test_inconsis4()
{
    InConsis *inconsis = new_inconsis();
    ICheckContent *i_check_content = new_i_check_content();

    mwrite_i_check_content(inconsis,i_check_content);

    assert(i_check_content == mread_i_check_content(inconsis));
    delete_i_check(inconsis);
  }

void test_inconsis()
{
    printf("testing inconsis...\n");
    test_inconsis1();
    test_inconsis2();
    test_inconsis3();
    test_inconsis4();
}

/************************/
/*   prop               */
/************************/
void test_prop1()
{
    Prop   *prop = new_prop();

    assert(is_prop(prop));
    delete_prop(prop);
    check_memory_usage("test_prop1");
}

void test_prop2()
{
     MId      *m_id = new_o_term(), *m_id2;
     ATerm    *a_term = new_a_term(),*a_term2;
     Prop     *prop;

     assert(fis_prop(NULL));
     assert(fis_prop(prop = create_prop(m_id,a_term)));

     assert(! is_prop(a_term));
     assert(! fis_prop(a_term));
     decompose_prop(prop,&m_id2,&a_term2);
    assert(m_id2 == m_id && a_term2 == a_term);
    assert(read_m_id_inProp(prop) == m_id && 
           read_a_term_inProp(prop) == a_term);
    delete_prop(prop);
    check_memory_usage("test_prop2");
}

void test_prop3()
{
     Prop   *prop = new_prop();
     MId      *m_id = new_o_term(), *m_id2;
     ATerm    *a_term = new_a_term(),*a_term2;  

    decompose_prop(set_prop(prop,m_id,a_term),&m_id2,&a_term2);
    assert(m_id == m_id2 && a_term2 == a_term);
    delete_prop(prop);
    check_memory_usage("test_prop3");
}

void test_prop4()
{
     Prop   *prop = new_prop(), *prop2;
     MId      *m_id = new_o_term(), *m_id2;
     ATerm    *a_term = new_a_term(),*a_term2;  

    decompose_prop(
          write_m_id_inProp(
              write_a_term_inProp(prop,a_term),
                         m_id),&m_id2,&a_term2);
    assert(m_id2 == m_id && a_term2 == a_term);
    prop2 = copy_prop(prop);
    delete_prop(prop);
    delete_prop(prop2);
    check_memory_usage("test_prop4");   
  }
void test_prop5()
{
     Prop   *prop = new_prop();
     MId      *m_id = new_o_term();
     ATerm    *a_term = new_a_term();

     mwrite_m_id_inProp(prop,m_id);
     mwrite_a_term_inProp(prop,a_term);
     assert(m_id == mread_m_id_inProp(prop) && a_term == mread_a_term_inProp(prop));
     delete_prop(prop);
   }

void test_prop()
{
    printf("testing prop...\n");
    test_prop1();
    test_prop2();
    test_prop3();
    test_prop4();
    test_prop5();
}

/************************/
/*   a_term             */
/************************/
void test_a_term1()
{
    ATerm  *a_term = new_a_term();

    assert(is_a_term(a_term));
    delete_a_term(a_term);
    check_memory_usage("test_a_term1");
}

void test_a_term2()
{
     OTerm    *o_term = new_o_term(),*o_term2;
     ObjList  *attrs = new_obj_list(ATTR), *attrs2;
     ObjList  *cnstrs = new_obj_list(CNSTR),  *cnstrs2;
     ATerm    *a_term;
  
    assert(fis_a_term(NULL));
    assert(fis_a_term(a_term  = create_a_term(o_term,attrs,cnstrs)));
    
    assert(! is_a_term(attrs));
    assert(! fis_a_term(attrs));
    decompose_a_term(a_term, &o_term2,&attrs2,&cnstrs2);
    assert(o_term2 == o_term && attrs2 == attrs && cnstrs2 == cnstrs);
    assert(read_o_term_inATerm(a_term) == o_term && 
           read_attrs_inATerm(a_term) == attrs &&
           read_cnstrs_inATerm(a_term) == cnstrs);
    delete_a_term(a_term);
    check_memory_usage("test_a_term2");
}

void test_a_term3()
{
    ATerm  *a_term = new_a_term();
    OTerm    *o_term = new_o_term(),*o_term2;
    ObjList  *attrs = new_obj_list(ATTR), *attrs2;
    ObjList  *cnstrs = new_obj_list(CNSTR), *cnstrs2;

    decompose_a_term(set_a_term(a_term,o_term,attrs,cnstrs),
                               &o_term2,&attrs2,&cnstrs2);
    assert(o_term2 == o_term && attrs2 == attrs && cnstrs2 == cnstrs);
    delete_a_term(a_term);
    check_memory_usage("test_a_term3");
}

void test_a_term4()
{
    ATerm  *a_term = new_a_term(), *a_term2;
    OTerm    *o_term = new_o_term(),*o_term2;
    ObjList  *attrs = new_obj_list(ATTR), *attrs2;
    ObjList  *cnstrs = new_obj_list(CNSTR),  *cnstrs2;

    decompose_a_term(
          write_o_term_inATerm(
              write_attrs_inATerm(
                write_cnstrs_inATerm(a_term,cnstrs),
                              attrs),
                         o_term),&o_term2,&attrs2,&cnstrs2);
    assert(o_term2 == o_term && attrs2 == attrs && cnstrs2 == cnstrs);
    a_term2 = copy_a_term(a_term);
    delete_a_term(a_term);
    delete_a_term(a_term2);
    check_memory_usage("test_a_term4"); 
  }

void test_a_term5()
{
    ATerm  *a_term = new_a_term();
    OTerm    *o_term = new_o_term();
    ObjList  *attrs = new_obj_list(ATTR);
    ObjList  *cnstrs = new_obj_list(CNSTR);

    mwrite_o_term_inATerm(a_term,o_term);
    mwrite_attrs_inATerm(a_term,attrs);
    mwrite_cnstrs_inATerm(a_term,cnstrs);
    assert(o_term == mread_o_term_inATerm(a_term) && attrs == mread_attrs_inATerm(a_term)
           && cnstrs == mread_cnstrs_inATerm(a_term));
    delete_a_term(a_term);
  }


void  test_a_term6()
{
  ATerm     *a_term;
  ObjList   *obj_list,*obj_list2;
  Attr      *attr,*attr2,*attr3,*attr4;

  a_term = new_a_term();
  obj_list = new_obj_list(ATTR);
  obj_list2 = new_obj_list(ATTR);
  attr = new_attr();
  attr2 = new_attr();
  attr3 = new_attr();
  attr4 = new_attr();
  append_to_obj_list(append_to_obj_list(obj_list,attr),attr2);
  append_to_obj_list(append_to_obj_list(obj_list2,attr3),attr4);
  insert_attrs_inATerm(insert_attrs_inATerm(a_term,obj_list2),obj_list);
  assert(car_of_attrs_inATerm(a_term) == attr &&
         car_of_attrs_inATerm(a_term) == attr2 &&
         car_of_attrs_inATerm(a_term) == attr3 &&
         car_of_attrs_inATerm(a_term) == attr4);

  obj_list = new_obj_list(ATTR);
  obj_list2 = new_obj_list(ATTR);  
  cons_to_obj_list(cons_to_obj_list(obj_list,attr),attr2);
  cons_to_obj_list(cons_to_obj_list(obj_list2,attr3),attr4);
  add_attrs_inATerm(add_attrs_inATerm(a_term,obj_list2),obj_list);
  assert(car_of_attrs_inATerm(a_term) == attr4 &&
         car_of_attrs_inATerm(a_term) == attr3 &&
         car_of_attrs_inATerm(a_term) == attr2 &&
         car_of_attrs_inATerm(a_term) == attr);
  delete_attr(attr);
  delete_attr(attr2);
  delete_attr(attr3);
  delete_attr(attr4);
  delete_a_term(a_term);
  check_memory_usage("test_a_term6");
}

void  test_a_term7()
{
  ATerm     *a_term;
  ObjList   *obj_list,*obj_list2;
  Cnstr     *cnstr,*cnstr2,*cnstr3,*cnstr4;

  a_term = new_a_term();
  obj_list = new_obj_list(CNSTR);
  obj_list2 = new_obj_list(CNSTR);
  cnstr = new_cnstr();
  cnstr2 = new_cnstr();
  cnstr3 = new_cnstr();
  cnstr4 = new_cnstr();
  append_to_obj_list(append_to_obj_list(obj_list,cnstr),cnstr2);
  append_to_obj_list(append_to_obj_list(obj_list2,cnstr3),cnstr4);
  insert_cnstrs_inATerm(insert_cnstrs_inATerm(a_term,obj_list2),obj_list);
  assert(car_of_cnstrs_inATerm(a_term) == cnstr &&
         car_of_cnstrs_inATerm(a_term) == cnstr2 &&
         car_of_cnstrs_inATerm(a_term) == cnstr3 &&
         car_of_cnstrs_inATerm(a_term) == cnstr4);

  obj_list = new_obj_list(CNSTR);
  obj_list2 = new_obj_list(CNSTR);  
  cons_to_obj_list(cons_to_obj_list(obj_list,cnstr),cnstr2);
  cons_to_obj_list(cons_to_obj_list(obj_list2,cnstr3),cnstr4);
  add_cnstrs_inATerm(add_cnstrs_inATerm(a_term,obj_list2),obj_list);
  assert(car_of_cnstrs_inATerm(a_term) == cnstr4 &&
         car_of_cnstrs_inATerm(a_term) == cnstr3 &&
         car_of_cnstrs_inATerm(a_term) == cnstr2 &&
         car_of_cnstrs_inATerm(a_term) == cnstr);
  delete_cnstr(cnstr);
  delete_cnstr(cnstr2);
  delete_cnstr(cnstr3);
  delete_cnstr(cnstr4);
  delete_a_term(a_term);
  check_memory_usage("test_a_term7");
}

void test_a_term()
{
    printf("testing a_term...\n");
    test_a_term1();
    test_a_term2();
    test_a_term3();
    test_a_term4();
    test_a_term5();
    test_a_term6();
    test_a_term7();
}

/************************/
/*   c_o_term            */
/************************/
void test_c_o_term1()
{
    COTerm   *c_o_term = new_c_o_term();

    assert(is_c_o_term(c_o_term));
    delete_c_o_term(c_o_term);
    check_memory_usage("test_c_o_term1");
}

void test_c_o_term2()
{
     char     *head = dotsrc_malloc(strlen("test") + 1), *head2;
     ObjList  *attrs = new_obj_list(ATTR), *attrs2;
     ObjList  *cnstrs = new_obj_list(CNSTR), *cnstrs2;
     COTerm   *c_o_term;

    strcpy(head,"test");
    assert(fis_c_o_term(NULL));
    assert(fis_c_o_term(c_o_term  = create_c_o_term(head,attrs,cnstrs)));
    assert(! is_c_o_term(attrs));
    assert(! fis_c_o_term(attrs));
    decompose_c_o_term(c_o_term, &head2,&attrs2,&cnstrs2);
    assert(strcmp(head2,head) == 0  && attrs2 == attrs && cnstrs2 == cnstrs);
    assert(strcmp(read_head_inCOTerm(c_o_term),head) == 0 && 
           read_attrs_inCOTerm(c_o_term) == attrs &&
           read_cnstrs_inCOTerm(c_o_term) == cnstrs);
    delete_c_o_term(c_o_term);
    check_memory_usage("test_c_o_term2");
}

void test_c_o_term3()
{
    COTerm   *c_o_term = new_c_o_term();
    char     *head = dotsrc_malloc(sizeof("test")), *head2;
    ObjList  *attrs = new_obj_list(ATTR), *attrs2;
    ObjList  *cnstrs = new_obj_list(CNSTR), *cnstrs2;

    strcpy(head,"test");
    decompose_c_o_term(set_c_o_term(c_o_term,head,attrs,cnstrs),
                                        &head2,&attrs2,&cnstrs2);
    assert(strcmp(head2,head) == 0  && attrs2 == attrs && cnstrs2 == cnstrs);
    assert(read_head_inCOTerm(c_o_term) == head &&
           read_attrs_inCOTerm(c_o_term) == attrs &&
           read_cnstrs_inCOTerm(c_o_term) == cnstrs);
    delete_c_o_term(c_o_term);
    check_memory_usage("test_c_o_term3");
}

void test_c_o_term4()
{
    COTerm   *c_o_term = new_c_o_term(), *c_o_term2;
    char     *head = "test", *head2;
    ObjList  *attrs = new_obj_list(ATTR), *attrs2;
    ObjList  *cnstrs = new_obj_list(CNSTR), *cnstrs2;

    decompose_c_o_term(
          write_head_inCOTerm(
              write_attrs_inCOTerm(
                write_cnstrs_inCOTerm(c_o_term,cnstrs),
                              attrs),
                         head),&head2,&attrs2,&cnstrs2);
    assert((strcmp(head,head2) == 0) &&  attrs2 == attrs && cnstrs2 == cnstrs);
    c_o_term2 = copy_c_o_term(c_o_term);
    delete_c_o_term(c_o_term);
    delete_c_o_term(c_o_term2);
    check_memory_usage("test_c_o_term4"); 
  }

void test_c_o_term5()
{
    COTerm   *c_o_term = new_c_o_term();
    char     *head = dotsrc_malloc(sizeof("test")), *head2;
    ObjList  *attrs = new_obj_list(ATTR);
    ObjList  *cnstrs = new_obj_list(CNSTR);

    strcpy(head, "test");
    mwrite_head_inCOTerm(c_o_term,head);
    mwrite_attrs_inCOTerm(c_o_term,attrs);
    mwrite_cnstrs_inCOTerm(c_o_term,cnstrs);
    assert(head == mread_head_inCOTerm(c_o_term) && attrs == mread_attrs_inCOTerm(c_o_term)
           && cnstrs == mread_cnstrs_inCOTerm(c_o_term));
    delete_c_o_term(c_o_term);
  }

void  test_c_o_term6()
{
  COTerm     *c_o_term;
  ObjList   *obj_list,*obj_list2;
  Attr      *attr,*attr2,*attr3,*attr4;

  c_o_term = new_c_o_term();
  obj_list = new_obj_list(ATTR);
  obj_list2 = new_obj_list(ATTR);
  attr = new_attr();
  attr2 = new_attr();
  attr3 = new_attr();
  attr4 = new_attr();
  append_to_obj_list(append_to_obj_list(obj_list,attr),attr2);
  append_to_obj_list(append_to_obj_list(obj_list2,attr3),attr4);
  insert_attrs_inCOTerm(insert_attrs_inCOTerm(c_o_term,obj_list2),obj_list);
  assert(car_of_attrs_inCOTerm(c_o_term) == attr &&
         car_of_attrs_inCOTerm(c_o_term) == attr2 &&
         car_of_attrs_inCOTerm(c_o_term) == attr3 &&
         car_of_attrs_inCOTerm(c_o_term) == attr4);

  obj_list = new_obj_list(ATTR);
  obj_list2 = new_obj_list(ATTR);  
  cons_to_obj_list(cons_to_obj_list(obj_list,attr),attr2);
  cons_to_obj_list(cons_to_obj_list(obj_list2,attr3),attr4);
  add_attrs_inCOTerm(add_attrs_inCOTerm(c_o_term,obj_list2),obj_list);
  assert(car_of_attrs_inCOTerm(c_o_term) == attr4 &&
         car_of_attrs_inCOTerm(c_o_term) == attr3 &&
         car_of_attrs_inCOTerm(c_o_term) == attr2 &&
         car_of_attrs_inCOTerm(c_o_term) == attr);
  delete_attr(attr);
  delete_attr(attr2);
  delete_attr(attr3);
  delete_attr(attr4);
  delete_c_o_term(c_o_term);
  check_memory_usage("test_c_o_term6");
}

void  test_c_o_term7()
{
  COTerm     *c_o_term;
  ObjList   *obj_list,*obj_list2;
  Cnstr     *cnstr,*cnstr2,*cnstr3,*cnstr4;

  c_o_term = new_c_o_term();
  obj_list = new_obj_list(CNSTR);
  obj_list2 = new_obj_list(CNSTR);
  cnstr = new_cnstr();
  cnstr2 = new_cnstr();
  cnstr3 = new_cnstr();
  cnstr4 = new_cnstr();
  append_to_obj_list(append_to_obj_list(obj_list,cnstr),cnstr2);
  append_to_obj_list(append_to_obj_list(obj_list2,cnstr3),cnstr4);
  insert_cnstrs_inCOTerm(insert_cnstrs_inCOTerm(c_o_term,obj_list2),obj_list);
  assert(car_of_cnstrs_inCOTerm(c_o_term) == cnstr &&
         car_of_cnstrs_inCOTerm(c_o_term) == cnstr2 &&
         car_of_cnstrs_inCOTerm(c_o_term) == cnstr3 &&
         car_of_cnstrs_inCOTerm(c_o_term) == cnstr4);

  obj_list = new_obj_list(CNSTR);
  obj_list2 = new_obj_list(CNSTR);  
  cons_to_obj_list(cons_to_obj_list(obj_list,cnstr),cnstr2);
  cons_to_obj_list(cons_to_obj_list(obj_list2,cnstr3),cnstr4);
  add_cnstrs_inCOTerm(add_cnstrs_inCOTerm(c_o_term,obj_list2),obj_list);
  assert(car_of_cnstrs_inCOTerm(c_o_term) == cnstr4 &&
         car_of_cnstrs_inCOTerm(c_o_term) == cnstr3 &&
         car_of_cnstrs_inCOTerm(c_o_term) == cnstr2 &&
         car_of_cnstrs_inCOTerm(c_o_term) == cnstr);
  delete_cnstr(cnstr);
  delete_cnstr(cnstr2);
  delete_cnstr(cnstr3);
  delete_cnstr(cnstr4);
  delete_c_o_term(c_o_term);
  check_memory_usage("test_c_o_term7");
}

void test_c_o_term()
{
    printf("testing c_o_term...\n");
    test_c_o_term1();
    test_c_o_term2();
    test_c_o_term3();
    test_c_o_term4();
    test_c_o_term5();
    test_c_o_term6();
    test_c_o_term7();
}


/************************/
/*     dot              */
/************************/
void test_dot1()
{
    Dot*   dot = new_dot();
    assert(is_dot(dot));
    delete_dot(dot);
    check_memory_usage("test_dot1");
}

void test_dot2()
{
    OTerm    *o_term = new_o_term(), *o_term2;
    Label    *label = new_label(), *label2;
    Dot      *dot;

    assert(fis_dot(NULL));
    assert(fis_dot(dot  = create_dot(o_term,label)));
    assert(! is_dot(label));
    assert(! fis_dot(label));
    decompose_dot(dot, &o_term2,&label2);
    assert(o_term2 == o_term && label2 == label);
    assert(read_o_term_inDot(dot) == o_term && read_label_inDot(dot)== label);
    delete_dot(dot);
    check_memory_usage("test_dot2");
}

void test_dot3()
{
    Dot      *dot = new_dot();
    OTerm    *o_term = new_o_term(), *o_term2;
    Label    *label = new_label(), *label2;

    decompose_dot(set_dot(dot,o_term,label),&o_term2,&label2);
    assert(o_term2 == o_term && label2 == label);
    delete_dot(dot);
    check_memory_usage("test_dot3");
}

void test_dot4()
{
    Dot      *dot = new_dot(), *dot2;
    OTerm    *o_term = new_o_term(), *o_term2;
    Label    *label = new_label(), *label2;

    decompose_dot(
          write_o_term_inDot(
              write_label_inDot(dot,label),
                         o_term),&o_term2,&label2);
    assert(o_term2 == o_term && label2 == label);
    dot2 = copy_dot(dot);
    delete_dot(dot);
    delete_dot(dot2);
    check_memory_usage("test_dot4");
  }

void test_dot5()
{
    Dot      *dot = new_dot();
    OTerm    *o_term = new_o_term();
    Label    *label = new_label();

    mwrite_o_term_inDot(dot,o_term);
    mwrite_label_inDot(dot,label);
    assert(o_term == mread_o_term_inDot(dot) && label == mread_label_inDot(dot));
    delete_dot(dot);
  }

void test_dot()
{
    printf("testing dot...\n");
    test_dot1();
    test_dot2();
    test_dot3();
    test_dot4();
    test_dot5();
}

/************************/
/*     label              */
/************************/
void test_label1()
{
    Label*  label = new_label();
    assert(fis_label(label));
    delete_label(label);
    check_memory_usage("test_label1");
}

void test_label2()
{
    OTerm    *o_term = new_o_term(), *o_term2;
    Label      *label;

    assert(fis_label(NULL));
    assert(fis_label(label  = create_label(o_term)));
    assert(! is_label(o_term));
    assert(! fis_label(o_term));
    decompose_label(label, &o_term2);
    assert(o_term2 == o_term);
    delete_label(label);
    check_memory_usage("test_label2");
}

void test_label3()
{
    Label      *label = new_label(), *label2;
    OTerm      *o_term = new_o_term(), *o_term2;

    decompose_label(set_label(label,o_term),&o_term2);
    assert(o_term2 == o_term);
    label2 = copy_label(label);
   delete_label(label);
   delete_label(label2);
    check_memory_usage("test_label3");
}

void test_label4()
{
    Label      *label = new_label();
    OTerm    *o_term = new_o_term();
  
    mwrite_o_term_inLabel(label,o_term);
    assert(o_term == mread_o_term_inLabel(label));
    delete_label(label);
  }

void test_label()
{
    printf("testing label...\n");
    test_label1();
    test_label2();
    test_label3();
    test_label4();
}

/************************/
/*     ind_lab              */
/************************/
void test_ind_lab1()
{
    IndLab*  ind_lab = new_ind_lab();
    assert(fis_ind_lab(ind_lab));
    delete_label(ind_lab);
    check_memory_usage("test_ind_lab1");
}

void test_ind_lab2()
{
    OTerm    *o_term = new_o_term(), *o_term2;
    IndLab      *ind_lab;

    assert(fis_ind_lab(NULL));
    assert(fis_ind_lab(ind_lab  = create_ind_lab(o_term)));
    assert(! is_ind_lab(o_term));
    assert(! fis_ind_lab(o_term));
    decompose_label(ind_lab, &o_term2);
    assert(o_term2 == o_term);
    delete_label(ind_lab);
    check_memory_usage("test_ind_lab2");
}

void test_ind_lab3()
{
    IndLab      *ind_lab = new_ind_lab(), *ind_lab2;
    OTerm      *o_term = new_o_term(), *o_term2;

    decompose_label(set_label(ind_lab,o_term),&o_term2);
    assert(o_term2 == o_term);
   ind_lab2 = copy_label(ind_lab);
   delete_label(ind_lab);
   delete_label(ind_lab2);
    check_memory_usage("test_ind_lab3");
}

void test_ind_lab4()
{
    IndLab      *ind_lab = new_ind_lab();
    OTerm       *o_term = new_o_term();
  
    mwrite_o_term_inLabel(ind_lab,o_term);
    assert(o_term == mread_o_term_inLabel(ind_lab));
    delete_label(ind_lab);
  }

void test_ind_lab()
{
    printf("testing ind_lab...\n");
    test_ind_lab1();
    test_ind_lab2();
    test_ind_lab3();
    test_ind_lab4();
}

/************************/
/*     set_lab              */
/************************/
void test_set_lab1()
{
    SetLab*  set_lab = new_set_lab();
    assert(fis_set_lab(set_lab));
    delete_label(set_lab);
    check_memory_usage("test_set_lab1");
}

void test_set_lab2()
{
    OTerm    *o_term = new_o_term(), *o_term2;
    SetLab      *set_lab;

    assert(fis_set_lab(NULL));
    assert(fis_set_lab(set_lab  = create_set_lab(o_term)));
    assert(! is_set_lab(o_term));
    assert(! fis_set_lab(o_term));
    decompose_label(set_lab, &o_term2);
    assert(o_term2 == o_term);
    delete_label(set_lab);
    check_memory_usage("test_set_lab2");
}

void test_set_lab3()
{
    SetLab      *set_lab = new_set_lab(), *set_lab2;
    OTerm      *o_term = new_o_term(), *o_term2;

    decompose_label(set_label(set_lab,o_term),&o_term2);
    assert(o_term2 == o_term);
   set_lab2 = copy_label(set_lab);
   delete_label(set_lab);
   delete_label(set_lab2);
    check_memory_usage("test_set_lab3");
}

void test_set_lab4()
{
    SetLab      *set_lab = new_set_lab();
    OTerm       *o_term = new_o_term();
  
    mwrite_o_term_inLabel(set_lab,o_term);
    assert(o_term == mread_o_term_inLabel(set_lab));
    delete_label(set_lab);
  }

void test_set_lab()
{
    printf("testing set_lab...\n");
    test_set_lab1();
    test_set_lab2();
    test_set_lab3();
    test_set_lab4();
}

/************************/
/*     curl_ind         */
/************************/
void test_curl_ind1()
{
    CurlInd*  curl_ind = new_curl_ind();
    assert(fis_curl_ind(curl_ind));
    delete_label(curl_ind);
    check_memory_usage("test_curl_ind1");
}

void test_curl_ind2()
{
    OTerm    *o_term = new_o_term(), *o_term2;
    CurlInd      *curl_ind;

    assert(fis_curl_ind(NULL));
    assert(fis_curl_ind(curl_ind  = create_curl_ind(o_term)));
    assert(! is_curl_ind(o_term));
    assert(! fis_curl_ind(o_term));
    decompose_label(curl_ind, &o_term2);
    assert(o_term2 == o_term);
    delete_label(curl_ind);
    check_memory_usage("test_curl_ind2");
}

void test_curl_ind3()
{
    CurlInd      *curl_ind = new_curl_ind(), *curl_ind2;
    OTerm      *o_term = new_o_term(), *o_term2;

    decompose_label(set_label(curl_ind,o_term),&o_term2);
    assert(o_term2 == o_term);
   curl_ind2 = copy_label(curl_ind);
   delete_label(curl_ind);
   delete_label(curl_ind2);
    check_memory_usage("test_curl_ind3");
}

void test_curl_ind4()
{
    CurlInd     *curl_ind = new_curl_ind();
    OTerm       *o_term = new_o_term();
  
    mwrite_o_term_inLabel(curl_ind,o_term);
    assert(o_term == mread_o_term_inLabel(curl_ind));
    delete_label(curl_ind);
  }

void test_curl_ind()
{
    printf("testing curl_ind...\n");
    test_curl_ind1();
    test_curl_ind2();
    test_curl_ind3();
    test_curl_ind4();
}
/************************/
/*     curl_set         */
/************************/
void test_curl_set1()
{
    CurlSet*  curl_set = new_curl_set();
    assert(fis_curl_set(curl_set));
    delete_label(curl_set);
    check_memory_usage("test_curl_set1");
}

void test_curl_set2()
{
    OTerm    *o_term = new_o_term(), *o_term2;
    CurlSet      *curl_set;

    assert(fis_curl_set(NULL));
    assert(fis_curl_set(curl_set  = create_curl_set(o_term)));
    assert(! is_curl_set(o_term));
    assert(! fis_curl_set(o_term));
    decompose_label(curl_set, &o_term2);
    assert(o_term2 == o_term);
    delete_label(curl_set);
    check_memory_usage("test_curl_set2");
}

void test_curl_set3()
{
    CurlSet      *curl_set = new_curl_set(), *curl_set2;
    OTerm      *o_term = new_o_term(), *o_term2;

    decompose_label(set_label(curl_set,o_term),&o_term2);
    assert(o_term2 == o_term);
   curl_set2 = copy_label(curl_set);
   delete_label(curl_set);
   delete_label(curl_set2);
    check_memory_usage("test_curl_set3");
}

void test_curl_set4()
{
    CurlSet     *curl_set = new_curl_set();
    OTerm       *o_term = new_o_term();
  
    mwrite_o_term_inLabel(curl_set,o_term);
    assert(o_term == mread_o_term_inLabel(curl_set));
    delete_label(curl_set);
  }

void test_curl_set()
{
    printf("testing curl_set...\n");
    test_curl_set1();
    test_curl_set2();
    test_curl_set3();
    test_curl_set4();
}

/************************/
/*   list             */
/************************/
void  test_list1()
{
   List *list = new_list();
   assert(is_list(list));
   delete_list(list);
      check_memory_usage("test_list1");  
}   

 void  test_list2()
{
   ObjList *normal = new_obj_list(NORMAL);
   List    *list,*list2;
   ModDef  *mod_def = new_mod_def();

   assert(fis_list(NULL));
   assert(fis_list(list = create_list_normal(normal)));
   assert(! is_list(mod_def));
   assert(! fis_list(mod_def));
   list2 = copy_list(list);
   delete_list(list);
   delete_list(list2);
   delete_mod_def(mod_def);
      check_memory_usage("test_list2");  
 }

 void  test_list3()
{
   SubList  *sub_list = new_sub_list();
   List     *list;

   assert(fis_list(NULL));
   assert(fis_list(list = create_list_sub_list(sub_list)));
   delete_list(list);
      check_memory_usage("test_list3");
 }


void test_list()
{
    printf("testing list...\n");
    test_list1();
    test_list2();
    test_list3();
}

/************************/
/*   sub_list           */
/************************/
void test_sub_list1()
{
    SubList   *sub_list = new_sub_list();
    assert(is_sub_list(sub_list));
    delete_sub_list(sub_list);
    check_memory_usage("test_sub_list1");
}

void test_sub_list2()
{
     ObjList   *o_terms = new_obj_list(O_TERM),*o_terms2;
     Remain    *remain = new_remain(),*remain2;
     SubList   *sub_list;

    assert(fis_sub_list(NULL));
    assert(fis_sub_list(sub_list  = create_sub_list(o_terms,remain)));
    assert(! is_sub_list(remain));
    assert(! fis_sub_list(remain));
    decompose_sub_list(sub_list, &o_terms2,&remain2);
    assert(o_terms2 == o_terms && remain2 == remain);
    assert(read_o_terms_inSubList(sub_list) == o_terms && 
           read_remain_inSubList(sub_list) == remain);
    delete_sub_list(sub_list);
    check_memory_usage("test_sub_lsit2");
}

void test_sub_list3()
{
    SubList   *sub_list = new_sub_list();
    ObjList   *o_terms = new_obj_list(O_TERM),*o_terms2;
    Remain    *remain = new_remain(),*remain2;

    decompose_sub_list(set_sub_list(sub_list,o_terms,remain),
                               &o_terms2,&remain2);
    assert(o_terms2 == o_terms && remain2 == remain);
    delete_sub_list(sub_list);
    check_memory_usage("test_sub_list3");
}

void test_sub_list4()
{
    SubList   *sub_list = new_sub_list(), *sub_list2;
    ObjList   *o_terms = new_obj_list(O_TERM),*o_terms2;
    Remain    *remain = new_remain(),*remain2;

    decompose_sub_list(
          write_o_terms_inSubList(
            write_remain_inSubList(sub_list,remain),
                         o_terms),&o_terms2,&remain2);
    assert(o_terms2 == o_terms && remain2 == remain);
    sub_list2 = copy_sub_list(sub_list);
    delete_sub_list(sub_list);
    delete_sub_list(sub_list2);
    check_memory_usage("test_sub_list4");   
  }

void test_sub_list5()
{
    SubList   *sub_list = new_sub_list();
    ObjList   *o_terms = new_obj_list(O_TERM);
    Remain    *remain = new_remain();

    mwrite_o_terms_inSubList(sub_list,o_terms);
    mwrite_remain_inSubList(sub_list,remain);
    assert(o_terms == mread_o_terms_inSubList(sub_list) 
           && remain == mread_remain_inSubList(sub_list));
    delete_sub_list(sub_list);
  }

void  test_sub_list6()
{
  SubList   *sub_list;
  ObjList   *obj_list,*obj_list2;
  OTerm     *o_term,*o_term2,*o_term3,*o_term4;

  sub_list = new_sub_list();
  obj_list = new_obj_list(O_TERM);
  obj_list2 = new_obj_list(O_TERM);
  o_term = new_o_term();
  o_term2 = new_o_term();
  o_term3 = new_o_term();
  o_term4 = new_o_term();
  append_to_obj_list(append_to_obj_list(obj_list,o_term),o_term2);
  append_to_obj_list(append_to_obj_list(obj_list2,o_term3),o_term4);
  insert_o_terms_inSubList(insert_o_terms_inSubList(sub_list,obj_list2),obj_list);
  assert(car_of_o_terms_inSubList(sub_list) == o_term &&
         car_of_o_terms_inSubList(sub_list) == o_term2 &&
         car_of_o_terms_inSubList(sub_list) == o_term3 &&
         car_of_o_terms_inSubList(sub_list) == o_term4);

  obj_list = new_obj_list(O_TERM);
  obj_list2 = new_obj_list(O_TERM);  
  cons_to_obj_list(cons_to_obj_list(obj_list,o_term),o_term2);
  cons_to_obj_list(cons_to_obj_list(obj_list2,o_term3),o_term4);
  add_o_terms_inSubList(add_o_terms_inSubList(sub_list,obj_list2),obj_list);
  assert(car_of_o_terms_inSubList(sub_list) == o_term4 &&
         car_of_o_terms_inSubList(sub_list) == o_term3 &&
         car_of_o_terms_inSubList(sub_list) == o_term2 &&
         car_of_o_terms_inSubList(sub_list) == o_term);
  delete_o_term(o_term);
  delete_o_term(o_term2);
  delete_o_term(o_term3);
  delete_o_term(o_term4);
  delete_sub_list(sub_list);
  check_memory_usage("test_sub_list6");
}

void test_sub_list()
{
    printf("testing sub_list...\n");
    test_sub_list1();
    test_sub_list2();
    test_sub_list3();
    test_sub_list4();
    test_sub_list5();
    test_sub_list6();
}

/************************/
/*   remain             */
/************************/
void  test_remain1()
{
   Remain *remain = new_remain();
   assert(is_remain(remain));
   delete_remain(remain);
   check_memory_usage("test_remain1");
}   

 void  test_remain2()
{
   List    *list = new_list();
   Remain  *remain,*remain2;
   ModDef  *mod_def = new_mod_def();

   assert(fis_remain(NULL));
   assert(fis_remain(remain = create_remain_list(list)));
   assert(! is_remain(mod_def));
   assert(! fis_remain(mod_def));
   remain2 = copy_remain(remain);
   delete_remain(remain);
   delete_remain(remain2);
   delete_mod_def(mod_def);
   check_memory_usage("test_remain2"); 
 }

 void  test_remain3()
{
   Var        *var = new_var();
   Remain     *remain;

   assert(fis_remain(NULL));
   assert(fis_remain(remain = create_remain_var(var)));
   delete_remain(remain);
   check_memory_usage("test_remain3");
 }


void test_remain()
{
    printf("testing remain...\n");
    test_remain1();
    test_remain2();
    test_remain3();
}

/************************/
/*   non_struct         */
/************************/
void  test_non_struct1()
{
   NonStruct *non_struct = new_non_struct();
   assert(is_non_struct(non_struct));
   delete_non_struct(non_struct);
   check_memory_usage("test_non_struct1");
}   

 void  test_non_struct2()
{
   ExpName    *exp_name = new_exp_name();
   NonStruct  *non_struct,*non_struct2;
   ModDef     *mod_def = new_mod_def();

   assert(fis_non_struct(NULL));
   assert(fis_non_struct(non_struct = create_non_struct_exp_name(exp_name)));
   assert(! is_non_struct(mod_def));
   assert(! fis_non_struct(mod_def));
   non_struct2 = copy_non_struct(non_struct);
   delete_non_struct(non_struct);
   delete_non_struct(non_struct2);
   delete_mod_def(mod_def);
   check_memory_usage("test_non_struct2");
 }

 void  test_non_struct3()
{
   String        *string = new_string();
   NonStruct     *non_struct;

/*   string->str_data = dotsrc_malloc(strlen("test"));
   strcpy(string->str_data,"test");*/
   assert(fis_non_struct(non_struct = create_non_struct_string(string)));
   delete_non_struct(non_struct);
   check_memory_usage("test_non_struct3");
 }

 void  test_non_struct4()
{
   Integer       *integer = new_integer();
   NonStruct     *non_struct;

   assert(fis_non_struct(NULL));
   assert(fis_non_struct(non_struct = create_non_struct_integer(integer)));
   delete_non_struct(non_struct);
   check_memory_usage("test_non_struct4");
 }

void test_non_struct()
{
    printf("testing non_struct...\n");
    test_non_struct1();
    test_non_struct2();
    test_non_struct3();
    test_non_struct4();
}

/************************/
/*     exp_name         */
/************************/
void test_exp_name1()
{
    ExpName*  exp_name = new_exp_name();
    assert(is_exp_name(exp_name));
    delete_exp_name(exp_name);
    check_memory_usage("test_exp_name1");
}

void test_exp_name2()
{
    char  *name = dotsrc_malloc(strlen("test") + 1), *name2;
    ExpName*   exp_name;
    ModDef*   mod_def = new_mod_def();

    strcpy(name,"test");
    assert(fis_exp_name(NULL));
    assert(fis_exp_name(exp_name = create_exp_name(name)));
    assert(fis_exp_name(exp_name));
    assert(! is_exp_name(mod_def));
    assert(! fis_exp_name(mod_def));
    decompose_exp_name(exp_name, &name2);
    assert(name2 == name);
    delete_exp_name(exp_name);
    delete_mod_def(mod_def);
    if(name2 != NULL)
    check_memory_usage("test_exp_name2");
}

void test_exp_name3()
{
    ExpName  *exp_name = new_exp_name(), *exp_name2;
    char  *name = dotsrc_malloc(strlen("test")), *name2;

    strcpy(name,"test");
    decompose_exp_name(set_exp_name(exp_name,name),&name2);
    assert(name2 == name);
    exp_name2 = copy_exp_name(exp_name);
    delete_exp_name(exp_name);
    delete_exp_name(exp_name2);
    check_memory_usage("test_exp_name3");
}

void test_exp_name4()
{
    ExpName  *exp_name = new_exp_name();
    char     *name = dotsrc_malloc(strlen("test"));

    strcpy(name,"test");
    mwrite_name_inExpName(exp_name,name);
    assert(name == mread_name_inExpName(exp_name));
    delete_exp_name(exp_name);
  }

void test_exp_name()
{
    printf("testing exp_name...\n");
    test_exp_name1();
    test_exp_name2();
    test_exp_name3();
    test_exp_name4();
}

/************************/
/*     integer          */
/************************/
void test_integer1()
{
    Integer*  integer = new_integer();
    assert(is_integer(integer));
    delete_integer(integer);
    check_memory_usage("test_integer1");
}

void test_integer2()
{
    int   value = 1, value2;
    Integer    *integer;
    ModDef     *mod_def = new_mod_def();

   assert(fis_integer(NULL));
   assert(fis_integer(integer = create_integer(value)));
   assert(! is_integer(mod_def));
   assert(! fis_integer(mod_def));
   decompose_integer(integer, &value2);
   assert(value2 == value);
   delete_integer(integer);
   delete_mod_def(mod_def);
   check_memory_usage("test_integer2");
}

void test_integer3()
{
    Integer  *integer = new_integer(), *integer2;
    int      value = 1, value2;

    decompose_integer(set_integer(integer,value),&value2);
    assert(value2 == value);
    integer2 = copy_integer(integer);
    delete_integer(integer);
    delete_integer(integer2);
    check_memory_usage("test_integer3");
}

void test_integer4()
{
    Integer  *integer = new_integer();
    int      value = 1;

    mwrite_value_inInteger(integer,value);
    assert(value == mread_value_inInteger(integer));
    delete_integer(integer);
  }

void test_integer()
{
    printf("testing integer...\n");
    test_integer1();
    test_integer2();
    test_integer3();
    test_integer4();
}

/************************/
/*   attr               */
/************************/
void test_attr1()
{
    Attr   *attr = new_attr();

    assert(is_attr(attr));
    delete_attr(attr);
    check_memory_usage("test_attr1");
}

void test_attr2()
{
     Label   *label = new_label(),*label2;
     AttrOp   attr_op = ATRARROW, attr_op2;
     Value   *value = new_value(),*value2;
     Attr    *attr;

    assert(fis_attr(NULL));
    assert(fis_attr(attr  = create_attr(label,attr_op,value)));
    assert(! is_attr(value));
    assert(! fis_attr(value));
    decompose_attr(attr, &label2,&attr_op2,&value2);
    assert(label2 == label && attr_op2 == attr_op && value2 == value);
    assert(read_label_inAttr(attr) == label && 
           read_attr_op(attr) == attr_op &&
           read_value(attr) == value);
    delete_attr(attr);
    check_memory_usage("test_attr_2");
}

void test_attr3()
{
    Attr   *attr = new_attr();
    Label  *label = new_label(),*label2;
    AttrOp   attr_op = ATRARROW, attr_op2;
    Value  *value = new_value(),*value2;    

    decompose_attr(set_attr(attr,label,attr_op,value),
                               &label2,&attr_op2,&value2);
    assert(label2 == label && attr_op2 == attr_op && value2 == value);
    delete_attr(attr);
    check_memory_usage("test_attr3");
}

void test_attr4()
{
    Attr   *attr = new_attr(), *attr2;
    Label  *label = new_label(),*label2;
    AttrOp   attr_op = ATLARROW, attr_op2;
    Value  *value = new_value(),*value2;    

    decompose_attr(
          write_label_inAttr(
              write_attr_op(
                write_value(attr,value),
                              attr_op),
                         label),&label2,&attr_op2,&value2);
    assert(label2 == label && attr_op2 == attr_op && value2 == value);
    attr2 = copy_attr(attr);
    delete_attr(attr);
    delete_attr(attr2);
    check_memory_usage("test_attr4"); 
  }

void test_attr5()
{
    Attr   *attr = new_attr();
    Label  *label = new_label();
    AttrOp   attr_op = ATLARROW;
    Value  *value = new_value();

    mwrite_label_inAttr(attr,label);
    mwrite_attr_op(attr,attr_op);
    mwrite_value_inAttr(attr,value);
    assert(label == mread_label_inAttr(attr) &&
           attr_op == mread_attr_op(attr) &&
           value == mread_value_inAttr(attr));
    delete_attr(attr);
  }

void test_attr()
{
    printf("testing attr...\n");
    test_attr1();
    test_attr2();
    test_attr3();
    test_attr4();
    test_attr5();
}
