#include <assert.h>
#include <ctype.h>
#include <string.h>

#define MALLOC_DEBUG

#define INDENT 4

#include "dotsrc.h"

extern FILE *fp;

/*
 PROGRAM
*/

Local void test_program1()
{
    Program* program = NULL;
    EnvDef* env_def = NULL;
    int n;

    assert(is_program(program) && fis_program(NULL));
    program = new_program();
    assert(is_program(program) && fis_program(program));
    n = strcmp(type_name(program->tag), "PROGRAM");
    assert(n == 0);
    assert(is_type(program->tag, PROGRAM));
    delete_program(program);
    assert(is_program(env_def) && fis_program(env_def));
    env_def = new_env_def();
    assert(! is_program(env_def) && ! fis_program(env_def));
    delete_env_def(env_def);
    check_memory_usage("test_program1");
}

Local void test_program2()
{
    EnvDef* env_def = new_env_def(), *env_def2;
    ExpDef* exp_def = new_exp_def(), *exp_def2;
    ObjDef* obj_def = new_obj_def(), *obj_def2;
    ModDef* mod_def = new_mod_def(), *mod_def2;
    LinkDef* link_def = new_link_def(), *link_def2;
    RuleDef* rule_def = new_rule_def(), *rule_def2;
    Program* program;

    assert(fis_program(program = create_program(env_def, exp_def,
						obj_def, mod_def,
						link_def, rule_def)));
    decompose_program(program, &env_def2, &exp_def2, &obj_def2,
		      &mod_def2, &link_def2, &rule_def2);
    assert(env_def2 == env_def && exp_def2 == exp_def &&
	   obj_def2 == obj_def && mod_def2 == mod_def &&
	   link_def2 == link_def && rule_def2 == rule_def);
    assert(read_env_def(program) == env_def &&
	   read_exp_def(program) == exp_def &&
	   read_obj_def(program) == obj_def &&
	   read_mod_def(program) == mod_def &&
	   read_link_def(program) == link_def &&
	   read_rule_def(program) == rule_def);
    assert(mread_env_def(program) == env_def &&
	   mread_exp_def(program) == exp_def &&
	   mread_obj_def(program) == obj_def &&
	   mread_mod_def(program) == mod_def &&
	   mread_link_def(program) == link_def &&
	   mread_rule_def(program) == rule_def);
    print_pseudo_object(program, fp, INDENT);
    fputc('\n', fp);
    delete_program(program);
    check_memory_usage("test_program2");
}

Local void test_program3()
{
    Program *program = new_program(), *program2, *program3;
    EnvDef *env_def = new_env_def(), *env_def2;
    ExpDef *exp_def = new_exp_def(), *exp_def2;
    ObjDef *obj_def = new_obj_def(), *obj_def2;
    ModDef *mod_def = new_mod_def(), *mod_def2;
    LinkDef *link_def = new_link_def(), *link_def2;
    RuleDef *rule_def = new_rule_def(), *rule_def2;

    decompose_program(set_program(program, env_def, exp_def, obj_def,
				  mod_def, link_def, rule_def),
		      &env_def2, &exp_def2, &obj_def2, &mod_def2,
		      &link_def2, &rule_def2);
    assert(env_def2 == env_def && exp_def2 == exp_def &&
	   obj_def2 == obj_def && mod_def2 == mod_def &&
	   link_def2 == link_def && rule_def2 == rule_def);
    program2 = copy_program(program);
    program3 = (Program*)copy_pseudo_object(program);
    delete_program(program);
    delete_program(program2);
    delete_pseudo_object(program3);
    check_memory_usage("test_program3");
}

Local void test_program4()
{
    Program *program = new_program(), *program2 = new_program();
    EnvDef *env_def, *env_def2;
    ExpDef *exp_def, *exp_def2;
    ObjDef *obj_def, *obj_def2;
    ModDef *mod_def, *mod_def2;
    LinkDef *link_def, *link_def2;
    RuleDef *rule_def, *rule_def2;

    env_def = new_env_def();
    exp_def = new_exp_def();
    obj_def = new_obj_def();
    mod_def = new_mod_def();
    link_def = new_link_def();
    rule_def = new_rule_def();
    decompose_program(
      write_env_def(
	    write_exp_def(
		  write_obj_def(
			write_mod_def(
			      write_link_def(
				     write_rule_def(program,
						    rule_def),
					     link_def), mod_def),
				obj_def), exp_def), env_def),
		      &env_def2, &exp_def2, &obj_def2, &mod_def2,
		      &link_def2, &rule_def2);
    assert(env_def2 == env_def && exp_def2 == exp_def &&
	   obj_def2 == obj_def && mod_def2 == mod_def &&
	   link_def2 == link_def && rule_def2 == rule_def);

    env_def = new_env_def();
    exp_def = new_exp_def();
    obj_def = new_obj_def();
    mod_def = new_mod_def();
    link_def = new_link_def();
    rule_def = new_rule_def();
    mwrite_env_def(mwrite_exp_def(program2, exp_def), env_def);
    mwrite_obj_def(mwrite_mod_def(program2, mod_def), obj_def);
    mwrite_link_def(mwrite_rule_def(program2, rule_def), link_def);
    decompose_program(program2, &env_def2, &exp_def2, &obj_def2,
		      &mod_def2, &link_def2, &rule_def2);
    assert(env_def2 == env_def && exp_def2 == exp_def &&
	   obj_def2 == obj_def && mod_def2 == mod_def &&
	   link_def2 == link_def && rule_def2 == rule_def);

    delete_program(program);
    delete_program(program2);
    check_memory_usage("test_program4");
}

Public void test_program()
{
    printf("testing program...\n");
    test_program1();
    test_program2();
    test_program3();
    test_program4();
}

/*
 ENV_DEF
*/

Local void test_env_def1()
{
    EnvDef* env_def = NULL;
    DefLib* def_lib = NULL;
    int n;

    assert(is_env_def(env_def) && fis_env_def(NULL));
    env_def = new_env_def();
    assert(is_env_def(env_def) && fis_env_def(env_def));
    n = strcmp(type_name(env_def->tag), "ENV_DEF");
    assert(n == 0);
    assert(is_type(env_def->tag, ENV_DEF));
    delete_env_def(env_def);
    assert(is_env_def(def_lib) && fis_env_def(def_lib));
    def_lib = new_def_lib();
    assert(! is_env_def(def_lib) && ! fis_env_def(def_lib));
    delete_def_lib(def_lib);
    check_memory_usage("test_env_def1");
}

#define TEST_NAME "test program"
#define TEST_AUTHOR "nishioka"
#define TEST_DATE "Fri Oct 30 16:41:44 GMT+9:00 1992"

Local void test_env_def2()
{
    char* name = dotsrc_malloc(strlen(TEST_NAME) + 1), *name2;
    char* author = dotsrc_malloc(strlen(TEST_AUTHOR) + 1), *author2;
    char* date = dotsrc_malloc(strlen(TEST_DATE) + 1), *date2;
    ObjList* def_libs = new_obj_list(DEF_LIB), *def_libs2;
    EnvDef* env_def; 

    strcpy(name, TEST_NAME);
    strcpy(author, TEST_AUTHOR);
    strcpy(date, TEST_DATE);
    assert(fis_env_def(env_def = create_env_def(name, author, date,
						def_libs)));
    decompose_env_def(env_def, &name2, &author2, &date2, &def_libs2);
    assert(name2 == name && author2 == author && date2 == date &&
	   def_libs2 == def_libs);
    assert(read_name(env_def) == name &&
	   read_author(env_def) == author &&
	   read_date(env_def) == date &&
	   read_def_libs(env_def) == def_libs);
    assert(mread_name(env_def) == name &&
	   mread_author(env_def) == author &&
	   mread_date(env_def) == date &&
	   mread_def_libs(env_def) == def_libs);
    print_pseudo_object(env_def, fp, INDENT);
    fputc('\n', fp);
    delete_env_def(env_def);
    check_memory_usage("test_env_def2");
}

Local void test_env_def3()
{
    EnvDef *env_def = new_env_def(), *env_def2, *env_def3;
    char *name = dotsrc_malloc(strlen(TEST_NAME) + 1), *name2;
    char *author = dotsrc_malloc(strlen(TEST_AUTHOR) + 1), *author2;
    char *date = dotsrc_malloc(strlen(TEST_DATE) + 1), *date2;
    ObjList* def_libs = new_obj_list(DEF_LIB), *def_libs2;

    strcpy(name, TEST_NAME);
    strcpy(author, TEST_AUTHOR);
    strcpy(date, TEST_DATE);
    decompose_env_def(set_env_def(env_def, name, author, date,
				  def_libs),
		      &name2, &author2, &date2, &def_libs2);
    assert(name2 == name && author2 == author && date2 == date &&
	   def_libs2 == def_libs);
    env_def2 = copy_env_def(env_def);
    env_def3 = (EnvDef*)copy_pseudo_object(env_def);
    delete_env_def(env_def);
    delete_env_def(env_def2);
    delete_pseudo_object(env_def3);
    check_memory_usage("test_env_def3");
}

Local void test_env_def4()
{
    EnvDef *env_def = new_env_def(), *env_def2 = new_env_def();
    char *name, *name2;
    char *author, *author2;
    char *date, *date2;
    ObjList *def_libs, *def_libs2;

    name = dotsrc_malloc(strlen(TEST_NAME) + 1);
    strcpy(name, TEST_NAME);
    author = dotsrc_malloc(strlen(TEST_AUTHOR) + 1);
    strcpy(author, TEST_AUTHOR);
    date = dotsrc_malloc(strlen(TEST_DATE) + 1);
    strcpy(date, TEST_DATE);
    def_libs = new_obj_list(DEF_LIB);
    decompose_env_def(
	      write_name_inEnvDef(
			  write_author(
			       write_date(
				  write_def_libs(env_def, def_libs),
					  date), author), name),
		      &name2, &author2, &date2, &def_libs2);
    assert(name2 == name && author2 == author && date2 == date &&
	   def_libs2 == def_libs);

    name = dotsrc_malloc(strlen(TEST_NAME) + 1);
    strcpy(name, TEST_NAME);
    author = dotsrc_malloc(strlen(TEST_AUTHOR) + 1);
    strcpy(author, TEST_AUTHOR);
    date = dotsrc_malloc(strlen(TEST_DATE) + 1);
    strcpy(date, TEST_DATE);
    def_libs = new_obj_list(DEF_LIB);
    decompose_env_def(
	      mwrite_name_inEnvDef(
			  mwrite_author(
			       mwrite_date(mwrite_def_libs(env_def2,
							   def_libs),
					   date), author), name),
		      &name2, &author2, &date2, &def_libs2);

    delete_env_def(env_def);
    delete_env_def(env_def2);
    check_memory_usage("test_env_def4");
}

Public void test_env_def()
{
    printf("testing env_def...\n");
    test_env_def1();
    test_env_def2();
    test_env_def3();
    test_env_def4();
}

/*
 DEF_LIB
*/

Local void test_def_lib1()
{
    DefLib* def_lib = NULL;
    String* string = NULL;
    int n;

    assert(is_def_lib(def_lib) && fis_def_lib(NULL));
    def_lib = new_def_lib();
    assert(is_def_lib(def_lib) && fis_def_lib(def_lib));
    n = strcmp(type_name(def_lib->tag), "DEF_LIB");
    assert(n == 0);
    assert(is_type(def_lib->tag, DEF_LIB));
    delete_def_lib(def_lib);
    assert(is_def_lib(string) && fis_def_lib(string));
    string = new_string();
    assert(! is_def_lib(string) && ! fis_def_lib(string));
    delete_string(string);
    check_memory_usage("test_def_lib1");
}

Local void test_def_lib2()
{
    LibLab lib_lab = EXPLIB, lib_lab2;
    ObjList* lib_names = new_obj_list(STRING), *lib_names2;
    DefLib* def_lib; 

    assert(fis_def_lib(def_lib = create_def_lib(lib_lab, lib_names)));
    decompose_def_lib(def_lib, &lib_lab2, &lib_names2);
    assert(lib_lab2 == lib_lab && lib_names2 == lib_names);
    assert(read_lib_lab(def_lib) == lib_lab &&
	   read_lib_names(def_lib) == lib_names);
    assert(mread_lib_lab(def_lib) == lib_lab &&
	   mread_lib_names(def_lib) == lib_names);
    print_pseudo_object(def_lib, fp, INDENT);
    fputc('\n', fp);
    delete_def_lib(def_lib);
    check_memory_usage("test_def_lib2");
}

Local void test_def_lib3()
{
    DefLib *def_lib = new_def_lib(), *def_lib2, *def_lib3;
    LibLab lib_lab = PGMLIB, lib_lab2;
    ObjList *lib_names = new_obj_list(STRING), *lib_names2;

    decompose_def_lib(set_def_lib(def_lib, lib_lab, lib_names),
		      &lib_lab2, &lib_names2);
    assert(lib_lab2 == lib_lab && lib_names2 == lib_names);
    def_lib2 = copy_def_lib(def_lib);
    def_lib3 = (DefLib*)copy_pseudo_object(def_lib);
    delete_def_lib(def_lib);
    delete_def_lib(def_lib2);
    delete_pseudo_object(def_lib3);
    check_memory_usage("test_def_lib3");
}

Local void test_def_lib4()
{
    DefLib *def_lib = new_def_lib(), *def_lib2 = new_def_lib();
    LibLab lib_lab = SORTLIB, lib_lab2;
    ObjList *lib_names, *lib_names2;

    lib_names = new_obj_list(STRING);
    decompose_def_lib(write_lib_lab(write_lib_names(def_lib,
						    lib_names),
				    lib_lab), &lib_lab2, &lib_names2);
    assert(lib_lab2 == lib_lab && lib_names2 == lib_names);

    lib_names = new_obj_list(STRING);
    decompose_def_lib(mwrite_lib_lab(mwrite_lib_names(def_lib2,
						      lib_names),
				     lib_lab), &lib_lab2,
		      &lib_names2);
    assert(lib_lab2 == lib_lab && lib_names2 == lib_names);

    delete_def_lib(def_lib);
    delete_def_lib(def_lib2);
    check_memory_usage("test_def_lib4");
}

Local void test_def_lib5()
{
    DefLib *def_lib;
    ObjList *obj_list, *obj_list2;
    String *string, *string2, *string3, *string4;

    def_lib = new_def_lib();
    obj_list = new_obj_list(STRING);
    obj_list2 = new_obj_list(STRING);
    string = new_string();
    string2 = new_string();
    string3 = new_string();
    string4 = new_string();
    append_to_obj_list(append_to_obj_list(obj_list, string), string2);
    append_to_obj_list(append_to_obj_list(obj_list2, string3),
		       string4);
    insert_lib_names(insert_lib_names(def_lib, obj_list2), obj_list);
    assert(car_of_lib_names(def_lib) == string &&
	   car_of_lib_names(def_lib) == string2 &&
	   car_of_lib_names(def_lib) == string3 &&
	   car_of_lib_names(def_lib) == string4);

    obj_list = new_obj_list(STRING);
    obj_list2 = new_obj_list(STRING);
    cons_to_obj_list(cons_to_obj_list(obj_list, string), string2);
    cons_to_obj_list(cons_to_obj_list(obj_list2, string3), string4);
    add_lib_names(add_lib_names(def_lib, obj_list2), obj_list);
    assert(car_of_lib_names(def_lib) == string4 &&
	   car_of_lib_names(def_lib) == string3 &&
	   car_of_lib_names(def_lib) == string2 &&
	   car_of_lib_names(def_lib) == string);
    delete_string(string);
    delete_string(string2);
    delete_string(string3);
    delete_string(string4);
    delete_def_lib(def_lib);
    check_memory_usage("test_def_lib5");
}

Public void test_def_lib()
{
    printf("testing def_lib...\n");
    test_def_lib1();
    test_def_lib2();
    test_def_lib3();
    test_def_lib4();
    test_def_lib5();
}

/*
 STRING
*/

Local void test_string1()
{
    String* string = NULL;
    ExpDef* exp_def = NULL;
    int n;

    assert(is_string(string) && fis_string(NULL));
    string = new_string();
    assert(is_string(string) && fis_string(string));
    n = strcmp(type_name(string->tag), "STRING");
    assert(n == 0);
    assert(is_type(string->tag, STRING));
    delete_string(string);
    assert(is_string(exp_def) && fis_string(exp_def));
    exp_def = new_exp_def();
    assert(! is_string(exp_def) && ! fis_string(exp_def));
    delete_exp_def(exp_def);
    check_memory_usage("test_string1");
}

#define TEST_STRING "How are you?"

Local void test_string2()
{
    char* str_data = dotsrc_malloc(strlen(TEST_STRING) + 1), *str_data2;
    String* string;

    strcpy(str_data, TEST_STRING);
    assert(fis_string(string = create_string(str_data)));
    decompose_string(string, &str_data2);
    assert(str_data2 == str_data);
    assert(read_str_data(string) == str_data);
    assert(mread_str_data(string) == str_data);
    print_pseudo_object(string, fp, INDENT);
    fputc('\n', fp);
    delete_string(string);
    check_memory_usage("test_string2");
}

Local void test_string3()
{
    String *string = new_string(), *string2, *string3;
    char* str_data = dotsrc_malloc(strlen(TEST_STRING) + 1), *str_data2;

    strcpy(str_data, TEST_STRING);
    decompose_string(set_string(string, str_data), &str_data2);
    assert(str_data2 == str_data);
    string2 = copy_string(string);
    string3 = (String*)copy_pseudo_object(string);
    delete_string(string);
    delete_string(string2);
    delete_pseudo_object(string3);
    check_memory_usage("test_string3");
}

Local void test_string4()
{
    String *string = new_string(), *string2 = new_string();
    char *str_data, *str_data2;

    str_data = dotsrc_malloc(strlen(TEST_STRING) + 1);
    strcpy(str_data, TEST_STRING);
    decompose_string(write_str_data(string, str_data), &str_data2);
    assert(str_data2 == str_data);

    str_data = dotsrc_malloc(strlen(TEST_STRING) + 1);
    strcpy(str_data, TEST_STRING);
    decompose_string(mwrite_str_data(string2, str_data), &str_data2);
    assert(str_data2 == str_data);

    delete_string(string);
    delete_string(string2);
    check_memory_usage("test_string4");
}

Public void test_string()
{
    printf("testing string...\n");
    test_string1();
    test_string2();
    test_string3();
    test_string4();
}

/*
 EXP_DEF
*/

Local void test_exp_def1()
{
    ExpDef* exp_def = NULL;
    Exp* exp = NULL;
    int n;

    assert(is_exp_def(exp_def) && fis_exp_def(NULL));
    exp_def = new_exp_def();
    assert(is_exp_def(exp_def) && fis_exp_def(exp_def));
    n = strcmp(type_name(exp_def->tag), "EXP_DEF");
    assert(n == 0);
    assert(is_type(exp_def->tag, EXP_DEF));
    delete_exp_def(exp_def);
    assert(is_exp_def(exp) && fis_exp_def(exp));
    exp = new_exp();
    assert(! is_exp_def(exp) && ! fis_exp_def(exp));
    delete_exp(exp);
    check_memory_usage("test_exp_def1");
}

Local void test_exp_def2()
{
    ObjList* exps = new_obj_list(EXP), *exps2;
    ExpDef* exp_def;

    assert(fis_exp_def(exp_def = create_exp_def(exps)));
    decompose_exp_def(exp_def, &exps2);
    assert(exps2 == exps);
    assert(read_exps(exp_def) == exps);
    assert(mread_exps(exp_def) == exps);
    print_pseudo_object(exp_def, fp, INDENT);
    fputc('\n', fp);
    delete_exp_def(exp_def);
    check_memory_usage("test_exp_def2");
}

Local void test_exp_def3()
{
    ExpDef *exp_def = new_exp_def(), *exp_def2, *exp_def3;
    ObjList *exps = new_obj_list(EXP), *exps2;

    decompose_exp_def(set_exp_def(exp_def, exps), &exps2);
    assert(exps2 == exps);
    exp_def2 = copy_exp_def(exp_def);
    exp_def3 = (ExpDef*)copy_pseudo_object(exp_def);
    delete_exp_def(exp_def);
    delete_exp_def(exp_def2);
    delete_pseudo_object(exp_def3);
    check_memory_usage("test_exp_def3");
}

Local void test_exp_def4()
{
    ExpDef *exp_def = new_exp_def(), *exp_def2 = new_exp_def();
    ObjList *exps, *exps2;

    exps = new_obj_list(EXP);
    decompose_exp_def(write_exps(exp_def, exps), &exps2);
    assert(exps2 == exps);

    exps = new_obj_list(EXP);
    decompose_exp_def(mwrite_exps(exp_def2, exps), &exps2);
    assert(exps2 == exps);

    delete_exp_def(exp_def);
    delete_exp_def(exp_def2);
    check_memory_usage("test_exp_def4");
}

Local void test_exp_def5()
{
    ExpDef *exp_def;
    ObjList *obj_list, *obj_list2;
    Exp *exp, *exp2, *exp3, *exp4;

    exp_def = new_exp_def();
    obj_list = new_obj_list(EXP);
    obj_list2 = new_obj_list(EXP);
    exp = new_exp();
    exp2 = new_exp();
    exp3 = new_exp();
    exp4 = new_exp();
    append_to_obj_list(append_to_obj_list(obj_list, exp), exp2);
    append_to_obj_list(append_to_obj_list(obj_list2, exp3), exp4);
    insert_exps(insert_exps(exp_def, obj_list2), obj_list);
    assert(car_of_exps(exp_def) == exp &&
	   car_of_exps(exp_def) == exp2 &&
	   car_of_exps(exp_def) == exp3 &&
	   car_of_exps(exp_def) == exp4);

    obj_list = new_obj_list(EXP);
    obj_list2 = new_obj_list(EXP);
    cons_to_obj_list(cons_to_obj_list(obj_list, exp), exp2);
    cons_to_obj_list(cons_to_obj_list(obj_list2, exp3), exp4);
    add_exps(add_exps(exp_def, obj_list2), obj_list);
    assert(car_of_exps(exp_def) == exp4 &&
	   car_of_exps(exp_def) == exp3 &&
	   car_of_exps(exp_def) == exp2 &&
	   car_of_exps(exp_def) == exp);
    delete_exp(exp);
    delete_exp(exp2);
    delete_exp(exp3);
    delete_exp(exp4);
    delete_exp_def(exp_def);
    check_memory_usage("test_exp_def5");
}

Public void test_exp_def()
{
    printf("testing exp_def...\n");
    test_exp_def1();
    test_exp_def2();
    test_exp_def3();
    test_exp_def4();
    test_exp_def5();
}

/*
 EXP
*/

Local void test_exp1()
{
    Exp* exp = NULL;
    ObjDef* obj_def = NULL;
    int n;

    assert(is_exp(exp) && fis_exp(NULL));
    exp = new_exp();
    assert(is_exp(exp) && fis_exp(exp));
    n = strcmp(type_name(exp->tag), "EXP");
    assert(n == 0);
    assert(is_type(exp->tag, EXP));
    delete_exp(exp);
    assert(is_exp(obj_def) && fis_exp(obj_def));
    obj_def = new_obj_def();
    assert(! is_exp(obj_def) && ! fis_exp(obj_def));
    delete_obj_def(obj_def);
    check_memory_usage("test_exp1");
}

Local void test_exp2()
{
    ExpName* exp_name = new_exp_name(), *exp_name2;
    OTerm* o_term = new_o_term(), *o_term2;
    Exp* exp;

    assert(fis_exp(exp = create_exp(exp_name, o_term)));
    decompose_exp(exp, &exp_name2, &o_term2);
    assert(exp_name2 == exp_name && o_term2 == o_term);
    assert(read_exp_name(exp) == exp_name &&
	   read_o_term_inExp(exp) == o_term);
    assert(mread_exp_name(exp) == exp_name &&
	   mread_o_term_inExp(exp) == o_term);
    print_pseudo_object(exp, fp, INDENT);
    fputc('\n', fp);
    delete_exp(exp);
    check_memory_usage("test_exp2");
}

Local void test_exp3()
{
    Exp *exp = new_exp(), *exp2, *exp3;
    ExpName* exp_name = new_exp_name(), *exp_name2;
    OTerm* o_term = new_o_term(), *o_term2;

    decompose_exp(set_exp(exp, exp_name, o_term), &exp_name2,
		  &o_term2);
    assert(exp_name2 == exp_name && o_term2 == o_term);
    exp2 = copy_exp(exp);
    exp3 = (Exp*)copy_pseudo_object(exp);
    delete_exp(exp);
    delete_exp(exp2);
    delete_pseudo_object(exp3);
    check_memory_usage("test_exp3");
}

Local void test_exp4()
{
    Exp *exp = new_exp(), *exp2 = new_exp();
    ExpName *exp_name, *exp_name2;
    OTerm *o_term, *o_term2;

    exp_name = new_exp_name();
    o_term = new_o_term();
    decompose_exp(write_exp_name(write_o_term_inExp(exp, o_term),
				 exp_name), &exp_name2, &o_term2);
    assert(exp_name2 == exp_name && o_term2 == o_term);

    exp_name = new_exp_name();
    o_term = new_o_term();
    decompose_exp(mwrite_exp_name(mwrite_o_term_inExp(exp2, o_term),
				 exp_name), &exp_name2, &o_term2);
    assert(exp_name2 == exp_name && o_term2 == o_term);

    delete_exp(exp);
    delete_exp(exp2);
    check_memory_usage("test_exp4");
}

Public void test_exp()
{
    printf("testing exp...\n");
    test_exp1();
    test_exp2();
    test_exp3();
    test_exp4();
}

/*
 OBJ_DEF
*/

Local void test_obj_def1()
{
    ObjDef* obj_def = NULL;
    ObjSub* obj_sub = NULL;
    int n;

    assert(is_obj_def(obj_def) && fis_obj_def(obj_def));
    obj_def = new_obj_def();
    assert(is_obj_def(obj_def));
    n = strcmp(type_name(obj_def->tag), "OBJ_DEF");
    assert(n == 0);
    assert(is_type(obj_def->tag, OBJ_DEF));
    delete_obj_def(obj_def);
    assert(is_obj_def(obj_sub) && fis_obj_def(obj_sub));
    obj_sub = new_obj_sub();
    assert(! is_obj_def(obj_sub) && ! fis_obj_def(obj_sub));
    delete_obj_sub(obj_sub);
    check_memory_usage("test_obj_def1");
}

Local void test_obj_def2()
{
    ObjList* obj_subs = new_obj_list(OBJ_SUB), *obj_subs2;
    ObjDef* obj_def;

    assert(fis_obj_def(obj_def = create_obj_def(obj_subs)));
    decompose_obj_def(obj_def, &obj_subs2);
    assert(obj_subs2 == obj_subs);
    assert(read_obj_subs(obj_def) == obj_subs);
    assert(mread_obj_subs(obj_def) == obj_subs);
    print_pseudo_object(obj_def, fp, INDENT);
    fputc('\n', fp);
    delete_obj_def(obj_def);
    check_memory_usage("test_obj_def2");
}

Local void test_obj_def3()
{
    ObjDef *obj_def = new_obj_def(), *obj_def2, *obj_def3;
    ObjList *obj_subs = new_obj_list(OBJ_SUB), *obj_subs2;

    decompose_obj_def(set_obj_def(obj_def, obj_subs), &obj_subs2);
    assert(obj_subs2 == obj_subs);
    obj_def2 = copy_obj_def(obj_def);
    obj_def3 = (ObjDef*)copy_pseudo_object(obj_def);
    delete_obj_def(obj_def);
    delete_obj_def(obj_def2);
    delete_pseudo_object(obj_def3);
    check_memory_usage("test_obj_def3");
}

Local void test_obj_def4()
{
    ObjDef *obj_def = new_obj_def(), *obj_def2 = new_obj_def();
    ObjList *obj_subs, *obj_subs2;

    obj_subs = new_obj_list(OBJ_SUB);
    decompose_obj_def(write_obj_subs(obj_def, obj_subs), &obj_subs2);
    assert(obj_subs2 == obj_subs);

    obj_subs = new_obj_list(OBJ_SUB);
    decompose_obj_def(mwrite_obj_subs(obj_def2, obj_subs), &obj_subs2);
    assert(obj_subs2 == obj_subs);

    delete_obj_def(obj_def);
    delete_obj_def(obj_def2);
    check_memory_usage("test_obj_def4");
}

Local void test_obj_def5()
{
    ObjDef *obj_def;
    ObjList *obj_list, *obj_list2;
    ObjSub *obj_sub, *obj_sub2, *obj_sub3, *obj_sub4;

    obj_def = new_obj_def();
    obj_list = new_obj_list(OBJ_SUB);
    obj_list2 = new_obj_list(OBJ_SUB);
    obj_sub = new_obj_sub();
    obj_sub2 = new_obj_sub();
    obj_sub3 = new_obj_sub();
    obj_sub4 = new_obj_sub();
    append_to_obj_list(append_to_obj_list(obj_list, obj_sub), obj_sub2);
    append_to_obj_list(append_to_obj_list(obj_list2, obj_sub3), obj_sub4);
    insert_obj_subs(insert_obj_subs(obj_def, obj_list2), obj_list);
    assert(car_of_obj_subs(obj_def) == obj_sub &&
	   car_of_obj_subs(obj_def) == obj_sub2 &&
	   car_of_obj_subs(obj_def) == obj_sub3 &&
	   car_of_obj_subs(obj_def) == obj_sub4);

    obj_list = new_obj_list(OBJ_SUB);
    obj_list2 = new_obj_list(OBJ_SUB);
    cons_to_obj_list(cons_to_obj_list(obj_list, obj_sub), obj_sub2);
    cons_to_obj_list(cons_to_obj_list(obj_list2, obj_sub3), obj_sub4);
    add_obj_subs(add_obj_subs(obj_def, obj_list2), obj_list);
    assert(car_of_obj_subs(obj_def) == obj_sub4 &&
	   car_of_obj_subs(obj_def) == obj_sub3 &&
	   car_of_obj_subs(obj_def) == obj_sub2 &&
	   car_of_obj_subs(obj_def) == obj_sub);
    delete_obj_sub(obj_sub);
    delete_obj_sub(obj_sub2);
    delete_obj_sub(obj_sub3);
    delete_obj_sub(obj_sub4);
    delete_obj_def(obj_def);
    check_memory_usage("test_obj_def5");
}

Public void test_obj_def()
{
    printf("testing obj_def...\n");
    test_obj_def1();
    test_obj_def2();
    test_obj_def3();
    test_obj_def4();
    test_obj_def5();
}

/*
 OBJ_SUB
*/

Local void test_obj_sub1()
{
    ObjSub* obj_sub = NULL;
    Program* program = NULL;
    int n;

    assert(is_obj_sub(obj_sub) && fis_obj_sub(NULL));
    obj_sub = new_obj_sub();
    assert(is_obj_sub(obj_sub) && fis_obj_sub(obj_sub));
    n = strcmp(type_name(obj_sub->tag), "OBJ_SUB");
    assert(n == 0);
    assert(is_type(obj_sub->tag, OBJ_SUB));
    delete_obj_sub(obj_sub);
    assert(is_obj_sub(program) && fis_obj_sub(program));
    program = new_program();
    assert(! is_obj_sub(program) && ! fis_obj_sub(program));
    delete_program(program);
    check_memory_usage("test_obj_sub1");
}

#define TEST_BOBJ1 "apple"
#define TEST_BOBJ2 "cider"

Local void test_obj_sub2()
{
    char* bobj1 = dotsrc_malloc(strlen(TEST_BOBJ1) + 1), *bobj12;
    char* bobj2 = dotsrc_malloc(strlen(TEST_BOBJ2) + 1), *bobj22;
    ObjSub* obj_sub;

    strcpy(bobj1, TEST_BOBJ1);
    strcpy(bobj2, TEST_BOBJ2);
    assert(fis_obj_sub(obj_sub = create_obj_sub(bobj1, bobj2)));
    decompose_obj_sub(obj_sub, &bobj12, &bobj22);
    assert(bobj12 == bobj1 && bobj22 == bobj2);
    assert(read_bobj1(obj_sub) == bobj1 &&
	   read_bobj2(obj_sub) == bobj2);
    assert(mread_bobj1(obj_sub) == bobj1 &&
	   mread_bobj2(obj_sub) == bobj2);
    print_pseudo_object(obj_sub, fp, INDENT);
    fputc('\n', fp);
    delete_obj_sub(obj_sub);
    check_memory_usage("test_obj_sub2");
}

Local void test_obj_sub3()
{
    ObjSub *obj_sub = new_obj_sub(), *obj_sub2, *obj_sub3;
    char *bobj1 = dotsrc_malloc(strlen(TEST_BOBJ1) + 1), *bobj12;
    char *bobj2 = dotsrc_malloc(strlen(TEST_BOBJ2) + 1), *bobj22;

    strcpy(bobj1, TEST_BOBJ1);
    strcpy(bobj2, TEST_BOBJ2);
    decompose_obj_sub(set_obj_sub(obj_sub, bobj1, bobj2), &bobj12,
		      &bobj22);
    assert(bobj12 == bobj1 && bobj22 == bobj2);
    obj_sub2 = copy_obj_sub(obj_sub);
    obj_sub3 = (ObjSub*)copy_pseudo_object(obj_sub);
    delete_obj_sub(obj_sub);
    delete_obj_sub(obj_sub2);
    delete_pseudo_object(obj_sub3);
    check_memory_usage("test_obj_sub3");
}

Local void test_obj_sub4()
{
    ObjSub *obj_sub = new_obj_sub(), *obj_sub2 = new_obj_sub();
    char *bobj1, *bobj12;
    char *bobj2, *bobj22;

    bobj1 = dotsrc_malloc(strlen(TEST_BOBJ1) + 1);
    strcpy(bobj1, TEST_BOBJ1);
    bobj2 = dotsrc_malloc(strlen(TEST_BOBJ2) + 1);
    strcpy(bobj2, TEST_BOBJ2);
    decompose_obj_sub(write_bobj1(write_bobj2(obj_sub, bobj2), bobj1),
		      &bobj12, &bobj22);
    assert(bobj12 == bobj1 && bobj22 == bobj2);

    bobj1 = dotsrc_malloc(strlen(TEST_BOBJ1) + 1);
    strcpy(bobj1, TEST_BOBJ1);
    bobj2 = dotsrc_malloc(strlen(TEST_BOBJ2) + 1);
    strcpy(bobj2, TEST_BOBJ2);
    decompose_obj_sub(mwrite_bobj1(mwrite_bobj2(obj_sub2, bobj2),
				   bobj1), &bobj12, &bobj22);
    assert(bobj12 == bobj1 && bobj22 == bobj2);

    delete_obj_sub(obj_sub);
    delete_obj_sub(obj_sub2);
    check_memory_usage("test_obj_sub4");
}

Public void test_obj_sub()
{
    printf("testing obj_sub...\n");
    test_obj_sub1();
    test_obj_sub2();
    test_obj_sub3();
    test_obj_sub4();
}

/*
 OBJ_LIST
*/

Local void test_obj_list1()
{
    ObjList* obj_list = NULL;
    Program *program = NULL;
    int n;

    assert(is_obj_list(obj_list, PROGRAM)
	   && fis_obj_list(NULL, PROGRAM));
    assert(is_any_obj_list(obj_list) && fis_any_obj_list(NULL));
    obj_list = new_obj_list(PROGRAM);
    assert(is_obj_list(obj_list, PROGRAM)
	   && fis_obj_list(obj_list, PROGRAM));
    assert(is_any_obj_list(obj_list) && fis_any_obj_list(obj_list));
    n = strcmp(type_name(obj_list->tag), "OBJ_LIST");
    assert(n == 0);
    assert(is_type(obj_list->tag, OBJ_LIST));
    delete_obj_list(obj_list);

    assert(is_obj_list(program, PROGRAM)
	   && fis_obj_list(program, PROGRAM));
    assert(is_any_obj_list(program) && fis_any_obj_list(program));
    program = new_program();
    assert(! is_obj_list(program, PROGRAM)
	   && ! fis_obj_list(program, PROGRAM));
    assert(! is_any_obj_list(program) && ! fis_any_obj_list(program));
    delete_program(program);

    check_memory_usage("test_obj_list1");
}

Local void test_obj_list2()
{
    Program *program, *program2, *program3, *program4;
    ObjList *obj_list;

    obj_list = new_obj_list(PROGRAM);
    assert(fis_obj_list(obj_list, PROGRAM));
    assert(fis_any_obj_list(obj_list));

    program = new_program();
    program2 = copy_program(program);

    cons_to_obj_list(cons_to_obj_list(obj_list, program), program2);
    program3 = (Program*)extract_last_list_element(obj_list);
    program4 = (Program*)extract_first_list_element(obj_list);
    assert(program == program3 && program2 == program4);

    append_to_obj_list(append_to_obj_list(obj_list, program),
		       program2);
    program3 = (Program*)extract_first_list_element(obj_list);
    program4 = (Program*)extract_last_list_element(obj_list);
    assert(program == program3 && program2 == program4);

    append_to_obj_list(append_to_obj_list(obj_list, program),
		       program2);
    print_pseudo_object(obj_list, fp, INDENT);
    fputc('\n', fp);
    delete_obj_list(obj_list);
    check_memory_usage("test_obj_list2");
}

Local void test_obj_list3()
{
    ObjList *obj_list, *obj_list2, *obj_list3;
    Program *program, *program2, *program3, *program4;
    Program *program5, *program6, *program7, *program8;

    obj_list = new_obj_list(PROGRAM);
    obj_list2 = new_obj_list(PROGRAM);
    program = new_program();
    program2 = new_program();
    program3 = new_program();
    program4 = new_program();
    cons_to_obj_list(cons_to_obj_list(obj_list, program), program2);
    append_to_obj_list(append_to_obj_list(obj_list2, program3), program4);

    insert_list_to_obj_list(obj_list, obj_list2);
    program5 = (Program*)extract_first_list_element(obj_list);
    program6 = (Program*)extract_first_list_element(obj_list);
    program7 = (Program*)extract_first_list_element(obj_list);
    program8 = (Program*)extract_first_list_element(obj_list);
    assert(program5 == program3 && program6 == program4 &&
	   program7 == program2 && program8 == program);

    obj_list2 = new_obj_list(PROGRAM);
    append_to_obj_list(append_to_obj_list(obj_list, program), program2);
    cons_to_obj_list(cons_to_obj_list(obj_list2, program3), program4);
    concat_list_to_obj_list(obj_list2, obj_list);
    program5 = (Program*)extract_last_list_element(obj_list2);
    program6 = (Program*)extract_last_list_element(obj_list2);
    program7 = (Program*)extract_last_list_element(obj_list2);
    program8 = (Program*)extract_last_list_element(obj_list2);
    assert(program5 == program2 && program6 == program &&
	   program7 == program3 && program8 == program4);
    delete_program(program);
    delete_program(program2);
    delete_program(program3);
    delete_program(program4);
    delete_obj_list(obj_list2);
    check_memory_usage("test_obj_list3");
}

Local void test_obj_list4()
{
    ObjList *obj_list, *obj_list2, *obj_list3;
    Program *program, *program2;

    obj_list = new_obj_list(PROGRAM);
    program = new_program();
    program2 = new_program();
    obj_list2 =
      copy_obj_list(cons_to_obj_list(cons_to_obj_list(obj_list,
						      program),
				     program2));
    obj_list3 = (ObjList*)copy_pseudo_object(obj_list);
    delete_obj_list(obj_list);
    delete_obj_list(obj_list2);
    delete_pseudo_object(obj_list3);
    check_memory_usage("test_obj_list4");
}

Public void test_obj_list()
{
    printf("testing obj_list...\n");
    test_obj_list1();
    test_obj_list2();
    test_obj_list3();
    test_obj_list4();
}

/*
 OBJ_ARRAY
*/

Local void test_obj_array1()
{
    ObjArray* obj_array = NULL;
    Program* program = NULL;
    int n;

    assert(is_obj_array(obj_array, PROGRAM)
	   && fis_obj_array(NULL, PROGRAM));
    assert(is_any_obj_array(obj_array) && fis_any_obj_array(NULL));
    obj_array = new_obj_array(PROGRAM, 0);
    assert(is_obj_array(obj_array, PROGRAM)
	   && fis_obj_array(obj_array, PROGRAM));
    assert(is_any_obj_array(obj_array)
	   && fis_any_obj_array(obj_array));
    n = strcmp(type_name(obj_array->tag), "OBJ_ARRAY");
    assert(n == 0);
    assert(is_type(obj_array->tag, OBJ_ARRAY));
    delete_obj_array(obj_array);

    assert(is_obj_array(program, PROGRAM)
	   && fis_obj_array(program, PROGRAM));
    assert(is_any_obj_array(program) && fis_any_obj_array(program));
    program = new_program();
    assert(! is_obj_array(program, PROGRAM)
	   && ! fis_obj_array(program, PROGRAM));
    assert(! is_any_obj_array(program)
	   && ! fis_any_obj_array(program));
    delete_program(program);

    check_memory_usage("test_obj_array1");
}

Public void test_obj_array()
{
    printf("testing obj_array...\n");
    test_obj_array1();
}
