/** identification macros **/

#define is_inherit_non_NULL(A) ((A)->tag == INHERIT)
#define is_reduce_non_NULL(A) ((A)->tag == REDUCE)
#define is_sub_goal_non_NULL(A) ((A)->tag == SUB_GOAL)
#define is_vc_pair_non_NULL(A) ((A)->tag == VC_PAIR)
#define is_query_explanation_non_NULL(A) ((A)->tag == QUERY_EXPLANATION)
#define is_fact_non_NULL(A) ((A)->tag == FACT)
#define is_one_rule_non_NULL(A) ((A)->tag == ONE_RULE || \
  is_reduce_non_NULL(A) || is_fact_non_NULL(A) || \
  is_query_explanation_non_NULL(A))
#define is_unit_explanation_non_NULL(A) ((A)->tag == UNIT_EXPLANATION || \
  is_one_rule_non_NULL(A) || is_inherit_non_NULL(A))
#define is_merge_explanation_non_NULL(A) ((A)->tag == MERGE_EXPLANATION)
#define is_lookup_explanation_non_NULL(A) ((A)->tag == LOOKUP_EXPLANATION)
#define is_explanation_non_NULL(A) ((A)->tag == EXPLANATION || \
  is_unit_explanation_non_NULL(A) || is_merge_explanation_non_NULL(A) || \
  is_lookup_explanation_non_NULL(A))
#define is_constraint_non_NULL(A) ((A)->tag == CONSTRAINT)
#define is_con_non_NULL(A) ((A)->tag == CON)
#define is_assump_non_NULL(A) ((A)->tag == ASSUMP)



#define is_inherit(A) ((A) == NULL || is_inherit_non_NULL(A))
#define is_reduce(A) ((A) == NULL || is_reduce_non_NULL(A))
#define is_sub_goal(A) ((A) == NULL || is_sub_goal_non_NULL(A))
#define is_vc_pair(A) ((A) == NULL || is_vc_pair_non_NULL(A))
#define is_query_explanation(A) ((A) == NULL || \
  is_query_explanation_non_NULL(A))
#define is_fact(A) ((A) == NULL || is_fact_non_NULL(A))
#define is_one_rule(A) ((A) == NULL || is_one_rule_non_NULL(A))
#define is_unit_explanation(A) ((A) == NULL || \
  is_unit_explanation_non_NULL(A))
#define is_merge_explanation(A) ((A) == NULL || \
  is_merge_explanation_non_NULL(A))
#define is_lookup_explanation(A) ((A) == NULL || \
  is_lookup_explanation_non_NULL(A))
#define is_explanation(A) ((A) == NULL || is_explanation_non_NULL(A))
#define is_constraint(A) ((A) == NULL || is_constraint_non_NULL(A))
#define is_con(A) ((A) == NULL || is_con_non_NULL(A))
#define is_assump(A) ((A) == NULL || is_assump_non_NULL(A))
