/** identification macros **/

#define is_program_non_NULL(A) ((A)->tag == PROGRAM)
#define fis_program_non_NULL(A) is_program_non_NULL((A))
#define is_env_def_non_NULL(A) ((A)->tag == ENV_DEF)
#define fis_env_def_non_NULL(A) is_env_def_non_NULL((A))
#define is_def_lib_non_NULL(A) ((A)->tag == DEF_LIB)
#define fis_def_lib_non_NULL(A) is_def_lib_non_NULL((A))
#define is_string_non_NULL(A) ((A)->tag == STRING)
#define fis_string_non_NULL(A) is_string_non_NULL((A))
#define is_exp_def_non_NULL(A) ((A)->tag == EXP_DEF)
#define fis_exp_def_non_NULL(A) is_exp_def_non_NULL((A))
#define is_exp_non_NULL(A) ((A)->tag == EXP)
#define fis_exp_non_NULL(A) is_exp_non_NULL((A))
#define is_obj_def_non_NULL(A) ((A)->tag == OBJ_DEF)
#define fis_obj_def_non_NULL(A) is_obj_def_non_NULL((A))
#define is_obj_sub_non_NULL(A) ((A)->tag == OBJ_SUB)
#define fis_obj_sub_non_NULL(A) is_obj_sub_non_NULL((A))
#define is_obj_list_non_NULL(A, B) \
  ((A)->tag == OBJ_LIST && is_type(((ObjList*)(A))->element_tag, B))
#define is_any_obj_list_non_NULL(A) ((A)->tag == OBJ_LIST)
#define is_obj_array_non_NULL(A, B) \
  ((A)->tag == OBJ_ARRAY && is_type(((ObjList*)(A))->element_tag, B))
#define is_any_obj_array_non_NULL(A) ((A)->tag == OBJ_ARRAY)
#define fis_any_obj_array_non_NULL(A) is_any_obj_array_non_NULL((A))

#define is_program(A) ((A) == NULL || is_program_non_NULL(A))
#define is_env_def(A) ((A) == NULL || is_env_def_non_NULL(A))
#define is_def_lib(A) ((A) == NULL || is_def_lib_non_NULL(A))
#define is_string(A) ((A) == NULL || is_string_non_NULL(A))
#define is_exp_def(A) ((A) == NULL || is_exp_def_non_NULL(A))
#define is_exp(A) ((A) == NULL || is_exp_non_NULL(A))
#define is_obj_def(A) ((A) == NULL || is_obj_def_non_NULL(A))
#define is_obj_sub(A) ((A) == NULL || is_obj_sub_non_NULL(A))
#define is_obj_list(A, B) ((A) == NULL || is_obj_list_non_NULL(A, B))
#define is_any_obj_list(A) ((A) == NULL || is_any_obj_list_non_NULL(A))
#define is_obj_array(A, B) ((A) == NULL || is_obj_array_non_NULL(A, B))
#define is_any_obj_array(A) ((A) == NULL || is_any_obj_array_non_NULL(A))
