#include "dotsrc.h"

/*
 EXPLANATION (union)
*/

Public Bool fis_explanation(object)
     PseudoObject* object;
{
    return object == NULL || object->tag == EXPLANATION ||
      fis_unit_explanation(object) || fis_merge_explanation(object) ||
      fis_lookup_explanation(object);
}

Public Explanation* create_explanation_unit(unit)
     UnitExplanation* unit;
{
    if (unit == NULL)
      return NULL;
    else {
      Explanation* explanation = 
	(Explanation*)dotsrc_malloc(sizeof(Explanation));

      *(UnitExplanation*)explanation = *unit;
      dotsrc_free((char*)unit);
      return (Explanation*)explanation;
    }
}

Public Explanation* create_explanation_merge(merge)
     MergeExplanation* merge;
{
    if (merge == NULL)
      return NULL;
    else {
      Explanation* explanation = 
	(Explanation*)dotsrc_malloc(sizeof(Explanation));

      *(MergeExplanation*)explanation = *merge;
      dotsrc_free((char*)merge);
      return (Explanation*)explanation;
    }
}

Public Explanation* create_explanation_lookup(lookup)
     LookupExplanation* lookup;
{
    if (lookup == NULL)
      return NULL;
    else {
      Explanation* explanation = 
	(Explanation*)dotsrc_malloc(sizeof(Explanation));

      *(LookupExplanation*)explanation = *lookup;
      dotsrc_free((char*)lookup);
      return (Explanation*)explanation;
    }
}

Public Explanation* copy_explanation(explanation)
     Explanation* explanation;
{
    if (explanation == NULL)
      return NULL;
    else if (is_unit_explanation(explanation))
      return (Explanation*)
	       copy_unit_explanation((UnitExplanation*)explanation);
    else
      switch (explanation->tag) {
	case EXPLANATION:
	  return new_explanation();
	  break;
	case MERGE_EXPLANATION:
	  return (Explanation*) copy_merge_explanation
		                  ((MergeExplanation*)explanation);
	  break;
	case LOOKUP_EXPLANATION:
	  return (Explanation*) copy_lookup_explanation
		                  ((LookupExplanation*)explanation);
	  break;
	default:
	  type_error(explanation, "EXPLANATION", "copy_explanation");
	  break;
      }
}

Public Explanation* new_explanation()
{
    Explanation* explanation = 
      (Explanation*)dotsrc_malloc(sizeof(Explanation));
    explanation->tag = EXPLANATION;
    return explanation;
}

Public void delete_explanation(explanation)
     Explanation* explanation;

{
    if (explanation != NULL)
      if (is_unit_explanation(explanation))
	  delete_unit_explanation((UnitExplanation*)explanation);
      else
        switch (explanation->tag) {
	  case EXPLANATION:
	    dotsrc_free((char*)explanation);
  	    break;
          case MERGE_EXPLANATION:
	    delete_merge_explanation((MergeExplanation*)explanation);
	    break;
          case LOOKUP_EXPLANATION:
	    delete_lookup_explanation((LookupExplanation*)explanation);
	    break;
          default:
	    type_error(explanation, "EXPLANATION", "delete_explanation");
	    break;
      }
}


/*
 UNIT_EXPLANATION (union)
*/

Public Bool fis_unit_explanation(object)
     PseudoObject* object;
{
    return object == NULL || object->tag == UNIT_EXPLANATION ||
      fis_one_rule(object) || fis_inherit(object);
}

Public UnitExplanation* create_unit_explanation_one_rule(one_rule)
     OneRule* one_rule;
{
    if (one_rule == NULL)
      return NULL;
    else {
      UnitExplanation* unit_explanation = 
	(UnitExplanation*)dotsrc_malloc(sizeof(UnitExplanation));
      *(OneRule*)unit_explanation = *one_rule;
      dotsrc_free((char*)one_rule);
      return (UnitExplanation*)unit_explanation;
    }
}

Public UnitExplanation* create_unit_explanation_inherit(inherit)
     Inherit* inherit;
{
    if (inherit == NULL)
      return NULL;
    else {
      UnitExplanation* unit_explanation = 
	(UnitExplanation*)dotsrc_malloc(sizeof(UnitExplanation));

      *(Inherit*)unit_explanation = *inherit;
      dotsrc_free((char*)inherit);
      return (UnitExplanation*)unit_explanation;
    }
}

Public UnitExplanation* copy_unit_explanation(unit_explanation)
     UnitExplanation* unit_explanation;
{
    if (unit_explanation == NULL)
      return NULL;
    else if (is_one_rule(unit_explanation))
      return (UnitExplanation*)copy_one_rule((OneRule*)unit_explanation);
    else
      switch (unit_explanation->tag) {
        case UNIT_EXPLANATION:
	  return new_unit_explanation();
	  break;
	case INHERIT:
	  return (UnitExplanation*) copy_inherit((Inherit*)unit_explanation);
	  break;
	default:
	  type_error(unit_explanation, "UNIT_EXPLANATION",
		       "copy_unit_explanation");
	  break;
      }
}

Public UnitExplanation* new_unit_explanation()
{
    UnitExplanation* unit_explanation = (UnitExplanation*)
                                      dotsrc_malloc(sizeof(UnitExplanation));
    unit_explanation->tag = UNIT_EXPLANATION;
    return unit_explanation;
}

Public void delete_unit_explanation(unit_explanation)
     UnitExplanation* unit_explanation;

{
    if (unit_explanation != NULL)
      if (is_one_rule(unit_explanation))
	  delete_one_rule((OneRule*)unit_explanation);
      else
        switch (unit_explanation->tag) {
	  case UNIT_EXPLANATION:
	    dotsrc_free((char*)unit_explanation);
  	    break;
	  case INHERIT:
	    delete_inherit((Inherit*)unit_explanation);
	    break;
	  default:
	    type_error(unit_explanation, "UNIT_EXPLANATION",
		         "delete_unit_explanation");
	    break;
        }
}


/*
 INHERIT (have ObjList)
*/

Public Bool fis_inherit(object)
     PseudoObject* object;
{
    return object == NULL || object->tag == INHERIT;
}

Public void decompose_inherit(inherit, one_rule, ups, downs)
     Inherit* inherit;
     OneRule** one_rule;
     ObjList** ups;
     ObjList** downs;
{
    if (inherit == NULL) {
        *one_rule = NULL;
	*ups = NULL;
	*downs = NULL;
    }
    else if (is_inherit_non_NULL(inherit)) {
        *one_rule = inherit->one_rule;
	*ups = inherit->ups;
	*downs = inherit->downs;
    }
    else
      type_error(inherit, "INHERIT", "decompose_inherit");
}

Public OneRule* read_one_rule(inherit)
     Inherit* inherit;
{
    if (inherit == NULL)
      return NULL;
    else if (is_inherit_non_NULL(inherit))
      return inherit->one_rule;
    else
      type_error(inherit, "INHERIT", "read_one_rule");
}

Public ObjList* read_ups(inherit)
     Inherit* inherit;
{
    if (inherit == NULL)
      return NULL;
    else if (is_inherit_non_NULL(inherit))
      return inherit->ups;
    else
      type_error(inherit, "INHERIT", "read_ups");
}

Public ObjList* read_downs(inherit)
     Inherit* inherit;
{
    if (inherit == NULL)
      return NULL;
    else if (is_inherit_non_NULL(inherit))
      return inherit->downs;
    else
      type_error(inherit, "INHERIT", "read_downs");
}
      
Public Inherit* create_inherit(one_rule, ups, downs)
     OneRule* one_rule;
     ObjList* ups;
     ObjList* downs;
{
    Inherit* inherit = (Inherit*)dotsrc_malloc(sizeof(Inherit));
    inherit->tag = INHERIT;
    inherit->one_rule = one_rule;
    inherit->ups = ups;
    inherit->downs = downs;
    return inherit;
}

Public Inherit* copy_inherit(inherit)
     Inherit* inherit;
{
    if (inherit == NULL) 
      return NULL;
    else if (is_inherit_non_NULL(inherit)) {
        Inherit* copy = (Inherit*)dotsrc_malloc(sizeof(Inherit));
	copy->tag = inherit->tag;
	copy->one_rule = copy_one_rule(inherit->one_rule);
	copy->ups = copy_obj_list(inherit->ups);
	copy->downs = copy_obj_list(inherit->downs);
	return copy;
    }
    else
      type_error(inherit, "INHERIT", "copy_inherit");
}
   
Public Inherit* set_inherit(inherit, one_rule, ups, downs)
     Inherit* inherit;
     OneRule* one_rule;
     ObjList* ups;
     ObjList* downs;
{
    if (inherit == NULL)
      write_through_NULL("set_inherit");
    else if (! is_inherit_non_NULL(inherit))
      type_error(inherit, "INHERIT", "set_inherit");
    else {
        inherit->one_rule = one_rule;
	inherit->ups = ups;
	inherit->downs = downs;
	return inherit;
    }
}

Public Inherit* write_one_rule(inherit, one_rule)
     Inherit* inherit;
     OneRule* one_rule;
{
    if (inherit == NULL)
      write_through_NULL("write_one_rule");
    else if (! is_inherit_non_NULL(inherit))
      type_error(inherit, "INHERIT", "write_one_rule");
    else {
        inherit->one_rule = one_rule;
	return inherit;
    }
}

Public Inherit* write_ups(inherit, ups)
     Inherit* inherit;
     ObjList* ups;
{
    if (inherit == NULL)
      write_through_NULL("write_ups");
    else if (! is_inherit_non_NULL(inherit))
      type_error(inherit, "INHERIT", "write_ups");
    else {
        inherit->ups = ups;
	return inherit;
    }
}

Public Inherit* write_downs(inherit, downs)
     Inherit* inherit;
     ObjList* downs;
{
    if (inherit == NULL)
      write_through_NULL("write_downs");
    else if (! is_inherit_non_NULL(inherit))
      type_error(inherit, "INHERIT", "write_downs");
    else {
        inherit->downs = downs;
	return inherit;
    }
}

Public Inherit* new_inherit()
{
    Inherit* inherit = (Inherit*)dotsrc_malloc(sizeof(Inherit));
    inherit->tag = INHERIT;
    inherit->one_rule = NULL;
    inherit->ups = NULL;
    inherit->downs = NULL;
    return inherit;
}

Public void delete_inherit(inherit)
     Inherit* inherit;
{
    if (inherit != NULL)
      if (is_inherit_non_NULL(inherit)) {
	  delete_one_rule(inherit->one_rule);
	  delete_obj_list(inherit->ups);
	  delete_obj_list(inherit->downs);
	  dotsrc_free((char*)inherit);
      }
      else
	type_error(inherit, "INHERIT", "delete_inherit");
}

Public Inherit* insert_ups(inherit, ups)
     Inherit* inherit;
     ObjList* ups;
{
    if (inherit == NULL)
      write_through_NULL("insert_ups");
    else if (is_inherit_non_NULL(inherit))
      if (inherit->ups == NULL) {
	  inherit->ups = ups;
	  return inherit;
      }
      else {
	  insert_list_to_obj_list(inherit->ups, ups);
	  return inherit;
      }
    else
      type_error(inherit, "INHERIT", "insert_ups");
}

Public Inherit* insert_downs(inherit, downs)
     Inherit* inherit;
     ObjList* downs;
{
    if (inherit == NULL)
      write_through_NULL("insert_downs");
    else if (is_inherit_non_NULL(inherit))
      if (inherit->downs == NULL) {
	  inherit->downs = downs;
	  return inherit;
      }
      else {
	  insert_list_to_obj_list(inherit->downs, downs);
	  return inherit;
      }
    else
      type_error(inherit, "INHERIT", "insert_downs");
}

Public Inherit* add_ups(inherit, ups)
     Inherit* inherit;
     ObjList* ups;
{
    if (inherit == NULL)
      write_through_NULL("add_ups");
    else if (is_inherit_non_NULL(inherit))
      if (inherit->ups == NULL) {
	  inherit->ups = ups;
	  return inherit;
      }
      else {
	  concat_list_to_obj_list(inherit->ups, ups);
	  return inherit;
      }
    else
      type_error(inherit, "INHERIT", "add_ups");
}

Public Inherit* add_downs(inherit, downs)
     Inherit* inherit;
     ObjList* downs;
{
    if (inherit == NULL)
      write_through_NULL("add_downs");
    else if (is_inherit_non_NULL(inherit))
      if (inherit->downs == NULL) {
	  inherit->downs = downs;
	  return inherit;
      }
      else {
	  concat_list_to_obj_list(inherit->downs, downs);
	  return inherit;
      }
    else
      type_error(inherit, "INHERIT", "add_downs");
}

Public OneRule* car_of_ups(inherit)
     Inherit* inherit;
{
    if (inherit == NULL || inherit->ups == NULL)
      return NULL;
    else
      return (OneRule*)extract_first_list_element(inherit->ups);
}

Public OneRule* car_of_downs(inherit)
     Inherit* inherit;
{
    if (inherit == NULL || inherit->downs == NULL)
      return NULL;
    else
      return (OneRule*)extract_first_list_element(inherit->downs);
}


/*
 MERGE_EXPLANATION (have ObjList)
*/

Public Bool fis_merge_explanation(object)
     PseudoObject* object;
{
    return object == NULL || object->tag == MERGE_EXPLANATION;
}

Public void decompose_merge_explanation(merge_explanation, unit_explanations)
     MergeExplanation* merge_explanation;
     ObjList** unit_explanations;
{
    if (merge_explanation == NULL) 
      *unit_explanations = NULL;
    else if (is_merge_explanation_non_NULL(merge_explanation))
      *unit_explanations = merge_explanation->unit_explanations;
    else
      type_error(merge_explanation, "MERGE_EXPLANATION", 
		   "decompose_merge_explanation");
}

Public ObjList* read_unit_explanations(merge_explanation)
     MergeExplanation* merge_explanation;
{
    if (merge_explanation == NULL) 
      return NULL;
    else if (is_merge_explanation_non_NULL(merge_explanation))
      return merge_explanation->unit_explanations;
    else
      type_error(merge_explanation, "MERGE_EXPLANATION", 
		   "read_unit_explanations");
}

Public MergeExplanation* create_merge_explanation(unit_explanations)
     ObjList* unit_explanations;
{
    MergeExplanation* merge_explanation = 
      (MergeExplanation*)dotsrc_malloc(sizeof(MergeExplanation));
    merge_explanation->tag = MERGE_EXPLANATION;
    merge_explanation->unit_explanations = unit_explanations;
    return merge_explanation;
}

Public MergeExplanation* copy_merge_explanation(merge_explanation)
     MergeExplanation* merge_explanation;
{
    if (merge_explanation == NULL) 
      return NULL;
    else if (is_merge_explanation_non_NULL(merge_explanation)) {
        MergeExplanation* copy = 
	  (MergeExplanation*)dotsrc_malloc(sizeof(MergeExplanation));
	copy->tag = merge_explanation->tag;
	copy->unit_explanations = 
	  copy_obj_list(merge_explanation->unit_explanations);
	return copy;
    }
    else
      type_error(merge_explanation, "MERGE_EXPLANATION", 
		   "copy_merge_explanation");
}
   
Public MergeExplanation* set_merge_explanation
                           (merge_explanation, unit_explanations)
     MergeExplanation* merge_explanation;
     ObjList* unit_explanations;
{
    if (merge_explanation == NULL)
      write_through_NULL("set_merge_explanation");
    else if (! is_merge_explanation_non_NULL(merge_explanation))
      type_error(merge_explanation, "MERGE_EXPLANATION", 
		   "set_merge_explanation");
    else {
        merge_explanation->unit_explanations = unit_explanations;
	return merge_explanation;
    }
}

Public MergeExplanation* write_unit_explanations
                           (merge_explanation, unit_explanations)
     MergeExplanation* merge_explanation;
     ObjList* unit_explanations;
{
    if (merge_explanation == NULL)
      write_through_NULL("write_unit_explanations");
    else if (! is_merge_explanation_non_NULL(merge_explanation))
      type_error(merge_explanation, "MERGE_EXPLANATION", 
		   "write_unit_explanations");
    else {
        merge_explanation->unit_explanations = unit_explanations;
	return merge_explanation;
    }
}

Public MergeExplanation* new_merge_explanation()
{
    MergeExplanation* merge_explanation = 
      (MergeExplanation*)dotsrc_malloc(sizeof(MergeExplanation));
    merge_explanation->tag = MERGE_EXPLANATION;
    merge_explanation->unit_explanations = NULL;
    return merge_explanation;
}

Public void delete_merge_explanation(merge_explanation)
     MergeExplanation* merge_explanation;
{
    if (merge_explanation != NULL)
      if (is_merge_explanation_non_NULL(merge_explanation)) {
	  delete_obj_list(merge_explanation->unit_explanations);
	  dotsrc_free((char*)merge_explanation);
	}	  
      else
      type_error(merge_explanation, "MERGE_EXPLANATION", 
		   "delete_merge_explanation");
}

Public MergeExplanation* insert_unit_explanations
                           (merge_explanation, unit_explanations)
     MergeExplanation* merge_explanation;
     ObjList* unit_explanations;
{
    if (merge_explanation == NULL)
      write_through_NULL("insert_unit_explanations");
    else if (is_merge_explanation_non_NULL(merge_explanation))
      if (merge_explanation->unit_explanations == NULL) {
	  merge_explanation->unit_explanations = unit_explanations;
	  return merge_explanation;
      }
      else {
	  insert_list_to_obj_list
	    (merge_explanation->unit_explanations, unit_explanations);
	  return merge_explanation;
      }
    else
      type_error(merge_explanation, "MERGE_EXPLANATION", 
		   "insert_unit_explatnations");
}

Public MergeExplanation* add_unit_explanations
                           (merge_explanation, unit_explanations)
     MergeExplanation* merge_explanation;
     ObjList* unit_explanations;
{
    if (merge_explanation == NULL)
      write_through_NULL("add_unit_explanations");
    else if (is_merge_explanation_non_NULL(merge_explanation))
      if (merge_explanation->unit_explanations == NULL) {
	  merge_explanation->unit_explanations = unit_explanations;
	  return merge_explanation;
      }
      else {
	  concat_list_to_obj_list
	    (merge_explanation->unit_explanations, unit_explanations);
	  return merge_explanation;
      }
    else
      type_error(merge_explanation, "MERGE_EXPLANATION", 
		   "add_unit_explatnations");
}

Public UnitExplanation* car_of_unit_explanations(merge_explanation)
     MergeExplanation* merge_explanation;
{
    if (merge_explanation == NULL || 
	  merge_explanation->unit_explanations == NULL)
      return NULL;
    else
      return (UnitExplanation*)
	extract_first_list_element(merge_explanation->unit_explanations);
}


/*
 LOOKUP_EXPLANATION
*/

Public Bool fis_lookup_explanation(object)
     PseudoObject* object;
{
    return object == NULL || object->tag == LOOKUP_EXPLANATION;
}

Public void decompose_lookup_explanation
              (lookup_explanation, sub_goal, looked_s, 
	       looking_s, explanation)
     LookupExplanation* lookup_explanation;
     SubGoal** sub_goal;
     int* looked_s;
     int* looking_s;
     Explanation** explanation;
{
    if (lookup_explanation == NULL) {
        *sub_goal = NULL;
	*looked_s = NULL;
	*looking_s = NULL;
	*explanation = NULL;
    }
    else if (is_lookup_explanation_non_NULL(lookup_explanation)) {
        *sub_goal = lookup_explanation->sub_goal;
	*looked_s = lookup_explanation->looked_s;
	*looking_s = lookup_explanation->looking_s;
	*explanation = lookup_explanation->explanation;
    }
    else
      type_error(lookup_explanation, "LOOKUP_EXPLANATION", 
		   "decompose_lookup_explanation");
}

Public SubGoal* read_sub_goal_inLookupExplanation(lookup_explanation)
     LookupExplanation* lookup_explanation;
{
    if (lookup_explanation == NULL)
      return NULL;
    else if (is_lookup_explanation_non_NULL(lookup_explanation))
      return lookup_explanation->sub_goal;
    else
      type_error(lookup_explanation, "LOOKUP_EXPLANATION", 
		   "read_sub_goal_inLookupExplanation");
}

Public int read_looked_s(lookup_explanation)
     LookupExplanation* lookup_explanation;
{
    if (lookup_explanation == NULL)
      return NULL;
    else if (is_lookup_explanation_non_NULL(lookup_explanation)) 
      return lookup_explanation->looked_s;
    else
      type_error(lookup_explanation, "LOOKUP_EXPLANATION", "read_looked_s");
}

Public int read_looking_s(lookup_explanation)
     LookupExplanation* lookup_explanation;
{
    if (lookup_explanation == NULL)
      return NULL;
    else if (is_lookup_explanation_non_NULL(lookup_explanation))
      return lookup_explanation->looking_s;
    else
      type_error(lookup_explanation, "LOOKUP_EXPLANATION", "read_looking_s");
}

Public Explanation* read_explanation_inLookupExplanation(lookup_explanation)
     LookupExplanation* lookup_explanation;
{
    if (lookup_explanation == NULL)
      return NULL;
    else if (is_lookup_explanation_non_NULL(lookup_explanation))
      return lookup_explanation->explanation;
    else
      type_error(lookup_explanation, "LOOKUP_EXPLANATION", 
		   "read_explanation_inLookupExplanation");
}

Public LookupExplanation* create_lookup_explanation
                            (sub_goal, looked_s, looking_s, explanation)
     SubGoal* sub_goal;
     int looked_s;
     int looking_s;
     Explanation* explanation;
{
    LookupExplanation* lookup_explanation = 
      (LookupExplanation*)dotsrc_malloc(sizeof(LookupExplanation));
    lookup_explanation->tag = LOOKUP_EXPLANATION;
    lookup_explanation->sub_goal = sub_goal;
    lookup_explanation->looked_s = looked_s;
    lookup_explanation->looking_s = looking_s;
    lookup_explanation->explanation = explanation;
    return lookup_explanation;
}

Public LookupExplanation* copy_lookup_explanation(lookup_explanation)
     LookupExplanation* lookup_explanation;
{
    if (lookup_explanation == NULL) 
      return NULL;
    else if (is_lookup_explanation_non_NULL(lookup_explanation)) {
        LookupExplanation* copy =
	  (LookupExplanation*)dotsrc_malloc(sizeof(LookupExplanation));
	copy->tag = lookup_explanation->tag;
	copy->sub_goal = copy_sub_goal(lookup_explanation->sub_goal);
	copy->looked_s = lookup_explanation->looked_s;
	copy->looking_s = lookup_explanation->looking_s;
	copy->explanation = copy_explanation(lookup_explanation->explanation);
	return copy;
    }
    else
      type_error(lookup_explanation, "LOOKUP_EXPLANATION", 
		   "copy_lookup_explanation");
}
   
Public LookupExplanation* set_lookup_explanation
                            (lookup_explanation, sub_goal, 
			     looked_s, looking_s, explanation)
     LookupExplanation* lookup_explanation;
     SubGoal* sub_goal;
     int looked_s;
     int looking_s;
     Explanation* explanation;
{
    if (lookup_explanation == NULL)
      write_through_NULL("set_lookup_explanation");
    else if (! is_lookup_explanation_non_NULL(lookup_explanation))
      type_error(lookup_explanation, "LOOKUP_EXPLANATION", 
		   "set_lookup_explanation");
    else {
        lookup_explanation->sub_goal = sub_goal;
        lookup_explanation->looked_s = looked_s;
        lookup_explanation->looking_s = looking_s;
        lookup_explanation->explanation = explanation;
	return lookup_explanation;
    }
}

Public LookupExplanation* write_sub_goal_inLookupExplanation
                            (lookup_explanation, sub_goal)
     LookupExplanation* lookup_explanation;
     SubGoal* sub_goal;
{
    if (lookup_explanation == NULL)
      write_through_NULL("write_sub_goal_inLookupExplanation");
    else if (! is_lookup_explanation_non_NULL(lookup_explanation))
      type_error(lookup_explanation, "LOOKUP_EXPLANATION", 
		   "write_sub_goal_inLookupExplanation");
    else {
        lookup_explanation->sub_goal = sub_goal;
	return lookup_explanation;
    }
}

Public LookupExplanation* write_looked_s
                            (lookup_explanation, looked_s)
     LookupExplanation* lookup_explanation;
     int looked_s;
{
    if (lookup_explanation == NULL)
      write_through_NULL("write_looked_s");
    else if (! is_lookup_explanation_non_NULL(lookup_explanation))
      type_error(lookup_explanation, "LOOKUP_EXPLANATION", 
		   "write_looked_s");
    else {
        lookup_explanation->looked_s = looked_s;
	return lookup_explanation;
    }
}

Public LookupExplanation* write_looking_s
                            (lookup_explanation, looking_s)
     LookupExplanation* lookup_explanation;
     int looking_s;
{
    if (lookup_explanation == NULL)
      write_through_NULL("write_looking_s");
    else if (! is_lookup_explanation_non_NULL(lookup_explanation))
      type_error(lookup_explanation, "LOOKUP_EXPLANATION", 
		   "write_looking_s");
    else {
        lookup_explanation->looking_s = looking_s;
	return lookup_explanation;
    }
}

Public LookupExplanation* write_explanation_inLookupExplanation
                            (lookup_explanation, explanation)
     LookupExplanation* lookup_explanation;
     Explanation* explanation;
{
    if (lookup_explanation == NULL)
      write_through_NULL("write_explanation_inLookupExplanation");
    else if (! is_lookup_explanation_non_NULL(lookup_explanation))
      type_error(lookup_explanation, "LOOKUP_EXPLANATION", 
		   "write_explanation_inLookupExplanation");
    else {
        lookup_explanation->explanation = explanation;
	return lookup_explanation;
    }
}

Public LookupExplanation* new_lookup_explanation()
{
    LookupExplanation* lookup_explanation = 
      (LookupExplanation*)dotsrc_malloc(sizeof(LookupExplanation));
    lookup_explanation->tag = LOOKUP_EXPLANATION;
    lookup_explanation->sub_goal = NULL;
    lookup_explanation->looked_s = NULL;
    lookup_explanation->looking_s = NULL;
    lookup_explanation->explanation = NULL;
    return lookup_explanation;
}

Public void delete_lookup_explanation(lookup_explanation)
     LookupExplanation* lookup_explanation;
{
    if (lookup_explanation != NULL)
      if (is_lookup_explanation_non_NULL(lookup_explanation)) {
	  delete_sub_goal(lookup_explanation->sub_goal);
	  delete_explanation(lookup_explanation->explanation);
	  dotsrc_free((char*)lookup_explanation);
      }
      else
        type_error(lookup_explanation, "LOOKUP_EXPLANATION", 
	            "delete_lookup_explanation");
}

/*
 ONE_RULE (union)
*/

Public Bool fis_one_rule(object)
     PseudoObject* object;
{
    return object == NULL || object->tag == ONE_RULE ||
      fis_reduce(object) || fis_fact(object) || 
      is_query_explanation(object);
}

Public OneRule* create_one_rule_reduce(reduce)
     Reduce* reduce;
{
    if (reduce == NULL)
      return NULL;
    else {
      OneRule* one_rule = (OneRule*)dotsrc_malloc(sizeof(OneRule));

      *(Reduce*)one_rule = *reduce;
      dotsrc_free((char*)reduce);
      return (OneRule*)one_rule;
    }
}

Public OneRule* create_one_rule_rule_id(rule_id)
     Fact* rule_id;
{
    if (rule_id == NULL)
      return NULL;
    else {
      OneRule* one_rule = (OneRule*)dotsrc_malloc(sizeof(OneRule));

      *(Fact*)one_rule = *rule_id;
      dotsrc_free((char*)rule_id);
      return (OneRule*)one_rule;
    }
}

Public OneRule* create_one_rule_query(query)
     QueryExplanation* query;
{
    if (query == NULL)
      return NULL;
    else {
      OneRule* one_rule = (OneRule*)dotsrc_malloc(sizeof(OneRule));

      *(QueryExplanation*)one_rule = *query;
      dotsrc_free((char*)query);
      return (OneRule*)one_rule;
    }
}

Public OneRule* copy_one_rule(one_rule)
     OneRule* one_rule;
{
    if (one_rule == NULL)
      return NULL;
    else
      switch (one_rule->tag) {
	case ONE_RULE:
	  return new_one_rule();
	  break;
	case REDUCE:
	  return (OneRule*) copy_reduce((Reduce*)one_rule);
	  break;
	case FACT:
	  return (OneRule*) copy_fact((Fact*)one_rule);
	  break;
	case QUERY_EXPLANATION:
	  return (OneRule*) 
	    copy_query_explanation((QueryExplanation*)one_rule);
	  break;
	default:
	  type_error(one_rule, "ONE_RULE", "copy_one_rule");
	  break;
      }
}

Public OneRule* new_one_rule()
{
    OneRule* one_rule = (OneRule*)dotsrc_malloc(sizeof(OneRule));
    one_rule->tag = ONE_RULE;
    return one_rule;
}

Public void delete_one_rule(one_rule)
     OneRule* one_rule;
{
    if (one_rule != NULL)
      switch (one_rule->tag) {
	case ONE_RULE:
	  dotsrc_free((char*)one_rule);
	  break;
        case REDUCE:
	  delete_reduce((Reduce*)one_rule);
	  break;
	case FACT:
	  delete_fact((Fact*)one_rule);
	  break;
	case QUERY_EXPLANATION:
	  delete_query_explanation((QueryExplanation*)one_rule);
	  break;
	default:
	  type_error(one_rule, "ONE_RULE", "delete_one_rule");
	  break;
      }
}

/*
 FACT
*/

Public Bool fis_fact(object)
     PseudoObject* object;
{
    return object == NULL || object->tag == FACT;
}

Public void decompose_fact(fact, fact_data)
     Fact* fact;
     char** fact_data;
{
    if (fact == NULL) {
	*fact_data = NULL;
    }
    else if (is_fact_non_NULL(fact)) {
	*fact_data = fact->fact_data;
    }
    else
      type_error(fact, "FACT", "decompose_fact");
}
      
Public char* read_fact_data(fact)
     Fact* fact;
{
    if (fact == NULL)
      return NULL;
    else if (is_fact_non_NULL(fact))
      return fact->fact_data;
    else
      type_error(fact, "FACT", "read_fact_data");
}
      
Public Fact* create_fact(fact_data)
     char* fact_data;
{
    Fact* fact = (Fact*)dotsrc_malloc(sizeof(Fact));
    fact->tag = FACT;
    fact->fact_data = fact_data;
    return fact;
}

Public Fact* copy_fact(fact)
     Fact* fact;
{
    if (fact == NULL) 
      return NULL;
    else if (is_fact_non_NULL(fact)) {
	Fact* copy = (Fact*)dotsrc_malloc(sizeof(Fact));
	copy->tag = fact->tag;
	if (fact->fact_data == NULL)
	  copy->fact_data = NULL;
	else
	  copy->fact_data = dotsrc_strdup(fact->fact_data);
	return copy;
    }
    else
      type_error(fact,"FACT","copy_fact");
}
    
Public Fact* set_fact(fact, fact_data)
     Fact* fact;
     char* fact_data;
{
    if (fact == NULL)
      write_through_NULL("set_fact");
    else if (is_fact_non_NULL(fact)) {
	fact->fact_data = fact_data;
	return fact;
    }
    else
      type_error(fact, "FACT", "set_fact");
}

Public Fact* write_fact_data(fact, fact_data)
     Fact* fact;
     char* fact_data;
{
    if (fact == NULL)
      write_through_NULL("write_fact_data");
    else if (is_fact_non_NULL(fact)) {
        fact->fact_data = fact_data;
	return fact;
    }
    else
      type_error(fact, "FACT", "write_fact_data");
}

Public Fact* new_fact()
{
    Fact* fact = (Fact*)dotsrc_malloc(sizeof(Fact));
    fact->tag = FACT;
    fact->fact_data = NULL;
    return fact;
}

Public void delete_fact(fact)
     Fact* fact;
{
    if (fact != NULL)
      if (is_fact_non_NULL(fact)) {
	if (fact->fact_data != NULL)
	    dotsrc_free((char*)fact->fact_data);
	  dotsrc_free((char*)fact);
      }
      else
	type_error(fact, "FACT", "delete_fact");
}

/*
 REDUCE (have ObjList)
*/

Public Bool fis_reduce(object)
     PseudoObject* object;
{
    return object == NULL || object->tag == REDUCE;
}

Public void decompose_reduce(reduce, sub_goal, rule_id, explanations, assumps)
     Reduce* reduce;
     SubGoal** sub_goal;
     RuleId** rule_id;
     ObjList** explanations;
     ObjList** assumps;
{
    if (reduce == NULL) {
        *sub_goal = NULL;
	*rule_id = NULL;
	*explanations = NULL;
	*assumps = NULL;
    }
    else if (is_reduce_non_NULL(reduce)) {
        *sub_goal = reduce->sub_goal;
	*rule_id = reduce->rule_id;
	*explanations = reduce->explanations;
	*assumps = reduce->assumps;
    }
    else
      type_error(reduce, "REDUCE", "decompose_reduce");
}

Public SubGoal* read_sub_goal_inReduce(reduce)
     Reduce* reduce;
{
    if (reduce == NULL)
      return NULL;
    else if (is_reduce_non_NULL(reduce))
      return reduce->sub_goal;
    else
      type_error(reduce, "REDUCE", "read_sub_goal_inReduce");
}

Public RuleId* read_rule_id_inReduce(reduce)
     Reduce* reduce;
{
    if (reduce == NULL)
      return NULL;
    else if (is_reduce_non_NULL(reduce))
      return reduce->rule_id;
    else
      type_error(reduce, "REDUCE", "read_rule_id_inReduce");
}

Public ObjList* read_explanations(reduce)
     Reduce* reduce;
{
    if (reduce == NULL)
      return NULL;
    else if (is_reduce_non_NULL(reduce))
      return reduce->explanations;
    else
      type_error(reduce, "REDUCE", "read_explanations");
}

Public ObjList* read_assumps(reduce)
     Reduce* reduce;
{
    if (reduce == NULL)
      return NULL;
    else if (is_reduce_non_NULL(reduce))
      return reduce->assumps;
    else
      type_error(reduce, "REDUCE", "read_assumps");
}
      
Public Reduce* create_reduce(sub_goal, rule_id, explanations, assumps)
     SubGoal* sub_goal;
     RuleId* rule_id;
     ObjList* explanations;
     ObjList* assumps;
{
    Reduce* reduce = (Reduce*)dotsrc_malloc(sizeof(Reduce));
    reduce->tag = REDUCE;
    reduce->sub_goal = sub_goal;
    reduce->rule_id = rule_id;
    reduce->explanations = explanations;
    reduce->assumps = assumps;
    return reduce;
}

Public Reduce* copy_reduce(reduce)
     Reduce* reduce;
{
    if (reduce == NULL) 
      return NULL;
    else if (is_reduce_non_NULL(reduce)) {
        Reduce* copy = (Reduce*)dotsrc_malloc(sizeof(Reduce));
	copy->tag = reduce->tag;
	copy->sub_goal = copy_sub_goal(reduce->sub_goal);
	copy->rule_id = copy_rule_id(reduce->rule_id);
	copy->explanations = copy_obj_list(reduce->explanations);
	copy->assumps = copy_obj_list(reduce->assumps);
	return copy;
    }
    else
      type_error(reduce, "REDUCE", "copy_reduce");
}
   
Public Reduce* set_reduce(reduce, sub_goal, rule_id, explanations, assumps)
     Reduce* reduce;
     SubGoal* sub_goal;
     RuleId* rule_id;
     ObjList* explanations;
     ObjList* assumps;
{
    if (reduce == NULL)
      write_through_NULL("set_reduce");
    else if (! is_reduce_non_NULL(reduce))
      type_error(reduce, "REDUCE", "set_reduce");
    else {
        reduce->sub_goal = sub_goal;
	reduce->rule_id = rule_id;
	reduce->explanations = explanations;
	reduce->assumps = assumps;
	return reduce;
    }
}

Public Reduce* write_sub_goal_inReduce(reduce, sub_goal)
     Reduce* reduce;
     SubGoal* sub_goal;
{
    if (reduce == NULL)
      write_through_NULL("write_sub_goal_inReduce");
    else if (! is_reduce_non_NULL(reduce))
      type_error(reduce, "REDUCE", "write_sub_goal_inReduce");
    else {
        reduce->sub_goal = sub_goal;
	return reduce;
    }
}

Public Reduce* write_rule_id_inReduce(reduce, rule_id)
     Reduce* reduce;
     RuleId* rule_id;
{
    if (reduce == NULL)
      write_through_NULL("write_rule_id_inReduce");
    else if (! is_reduce_non_NULL(reduce))
      type_error(reduce, "REDUCE", "write_rule_id_inReduce");
    else {
        reduce->rule_id = rule_id;
	return reduce;
    }
}

Public Reduce* write_explanations(reduce, explanations)
     Reduce* reduce;
     ObjList* explanations;
{
    if (reduce == NULL)
      write_through_NULL("write_explanations");
    else if (! is_reduce_non_NULL(reduce))
      type_error(reduce, "REDUCE", "write_explanations");
    else {
        reduce->explanations = explanations;
	return reduce;
    }
}

Public Reduce* write_assumps(reduce, assumps)
     Reduce* reduce;
     ObjList* assumps;
{
    if (reduce == NULL)
      write_through_NULL("write_assumps");
    else if (! is_reduce_non_NULL(reduce))
      type_error(reduce, "REDUCE", "write_assumps");
    else {
        reduce->assumps = assumps;
	return reduce;
    }
}

Public Reduce* new_reduce()
{
    Reduce* reduce = (Reduce*)dotsrc_malloc(sizeof(Reduce));
    reduce->tag = REDUCE;
    reduce->sub_goal = NULL;
    reduce->rule_id = NULL;
    reduce->explanations = NULL;
    reduce->assumps = NULL;
    return reduce;
}

Public void delete_reduce(reduce)
     Reduce* reduce;
{
    if (reduce != NULL)
      if (is_reduce_non_NULL(reduce)) {
	  delete_sub_goal(reduce->sub_goal);
	  delete_rule_id(reduce->rule_id);
	  delete_obj_list(reduce->explanations);
	  delete_obj_list(reduce->assumps);
	  dotsrc_free((char*)reduce);
      }
      else
	type_error(reduce, "REDUCE", "delete_reduce");
}

Public Reduce* insert_explanations(reduce, explanations)
     Reduce* reduce;
     ObjList* explanations;
{
    if (reduce == NULL)
      write_through_NULL("insert_explanations");
    else if (is_reduce_non_NULL(reduce))
      if (reduce->explanations == NULL) {
	  reduce->explanations = explanations;
	  return reduce;
      }
      else {
	  insert_list_to_obj_list(reduce->explanations, explanations);
	  return reduce;
      }
    else
      type_error(reduce, "REDUCE", "insert_explanations");
}

Public Reduce* insert_assumps(reduce, assumps)
     Reduce* reduce;
     ObjList* assumps;
{
    if (reduce == NULL)
      write_through_NULL("insert_assumps");
    else if (is_reduce_non_NULL(reduce))
      if (reduce->assumps == NULL) {
	  reduce->assumps = assumps;
	  return reduce;
      }
      else {
	  insert_list_to_obj_list(reduce->assumps, assumps);
	  return reduce;
      }
    else
      type_error(reduce, "REDUCE", "insert_assumps");
}

Public Reduce* add_explanations(reduce, explanations)
     Reduce* reduce;
     ObjList* explanations;
{
    if (reduce == NULL)
      write_through_NULL("add_explanations");
    else if (is_reduce_non_NULL(reduce))
      if (reduce->explanations == NULL) {
	  reduce->explanations = explanations;
	  return reduce;
      }
      else {
	  concat_list_to_obj_list(reduce->explanations, explanations);
	  return reduce;
      }
    else
      type_error(reduce, "REDUCE", "add_explanations");
}

Public Reduce* add_assumps(reduce, assumps)
     Reduce* reduce;
     ObjList* assumps;
{
    if (reduce == NULL)
      write_through_NULL("add_assumps");
    else if (is_reduce_non_NULL(reduce))
      if (reduce->assumps == NULL) {
	  reduce->assumps = assumps;
	  return reduce;
      }
      else {
	  concat_list_to_obj_list(reduce->assumps, assumps);
	  return reduce;
      }
    else
      type_error(reduce, "REDUCE", "add_assumps");
}

Public Explanation* car_of_explanations(reduce)
     Reduce* reduce;
{
    if (reduce == NULL || reduce->explanations == NULL)
      return NULL;
    else
      return (Explanation*)extract_first_list_element(reduce->explanations);
}

Public Assump* car_of_assumps(reduce)
     Reduce* reduce;
{
    if (reduce == NULL || reduce->assumps == NULL)
      return NULL;
    else
      return (Assump*)extract_first_list_element(reduce->assumps);
}


/*
 SUB_GOAL (have ObjList)
*/

Public Bool fis_sub_goal(object)
     PseudoObject* object;
{
    return object == NULL || object->tag == SUB_GOAL;
}

Public void decompose_sub_goal(sub_goal, m_id, o_term, vc_pairs)
     SubGoal* sub_goal;
     MId** m_id;
     OTerm** o_term;
     ObjList** vc_pairs;
{
    if (sub_goal == NULL) {
        *m_id = NULL;
	*o_term = NULL;
	*vc_pairs = NULL;
    }
    else if (is_sub_goal_non_NULL(sub_goal)) {
        *m_id = sub_goal->m_id;
	*o_term = sub_goal->o_term;
	*vc_pairs = sub_goal->vc_pairs;
    }
    else
      type_error(sub_goal, "SUB_GOAL", "decompose_sub_goal");
}

Public MId* read_m_id_inSubGoal(sub_goal)
     SubGoal* sub_goal;
{
    if (sub_goal == NULL)
      return NULL;
    else if (is_sub_goal_non_NULL(sub_goal))
      return sub_goal->m_id;
    else
      type_error(sub_goal, "SUB_GOAL", "read_m_id_inSubGoal");
}

Public OTerm* read_o_term_inSubGoal(sub_goal)
     SubGoal* sub_goal;
{
    if (sub_goal == NULL)
      return NULL;
    else if (is_sub_goal_non_NULL(sub_goal))
      return sub_goal->o_term;
    else
      type_error(sub_goal, "SUB_GOAL", "read_o_term_inSubGoal");
}

Public ObjList* read_vc_pairs_inSubGoal(sub_goal)
     SubGoal* sub_goal;
{
    if (sub_goal == NULL)
      return NULL;
    else if (is_sub_goal_non_NULL(sub_goal))
      return sub_goal->vc_pairs;
    else
      type_error(sub_goal, "SUB_GOAL", "read_vc_pairs_inSubGoal");
}
      
Public SubGoal* create_sub_goal(m_id, o_term, vc_pairs)
     MId* m_id;
     OTerm* o_term;
     ObjList* vc_pairs;
{
    SubGoal* sub_goal = (SubGoal*)dotsrc_malloc(sizeof(SubGoal));
    sub_goal->tag = SUB_GOAL;
    sub_goal->m_id = m_id;
    sub_goal->o_term = o_term;
    sub_goal->vc_pairs = vc_pairs;
    return sub_goal;
}

Public SubGoal* copy_sub_goal(sub_goal)
     SubGoal* sub_goal;
{
    if (sub_goal == NULL) 
      return NULL;
    else if (is_sub_goal_non_NULL(sub_goal)) {
        SubGoal* copy = (SubGoal*)dotsrc_malloc(sizeof(SubGoal));
	copy->tag = sub_goal->tag;
	copy->m_id = copy_o_term(sub_goal->m_id);
	copy->o_term = copy_o_term(sub_goal->o_term);
	copy->vc_pairs = copy_obj_list(sub_goal->vc_pairs);
	return copy;
    }
    else
      type_error(sub_goal, "SUB_GOAL", "copy_sub_goal");
}
   
Public SubGoal* set_sub_goal(sub_goal, m_id, o_term, vc_pairs)
     SubGoal* sub_goal;
     MId* m_id;
     OTerm* o_term;
     ObjList* vc_pairs;
{
    if (sub_goal == NULL)
      write_through_NULL("set_sub_goal");
    else if (! is_sub_goal_non_NULL(sub_goal))
      type_error(sub_goal, "SUB_GOAL", "set_sub_goal");
    else {
        sub_goal->m_id = m_id;
	sub_goal->o_term = o_term;
	sub_goal->vc_pairs = vc_pairs;
	return sub_goal;
    }
}

Public SubGoal* write_m_id_inSubGoal(sub_goal, m_id)
     SubGoal* sub_goal;
     MId* m_id;
{
    if (sub_goal == NULL)
      write_through_NULL("write_m_id_inSubGoal");
    else if (! is_sub_goal_non_NULL(sub_goal))
      type_error(sub_goal, "SUB_GOAL", "write_m_id_inSubGoal");
    else {
        sub_goal->m_id = m_id;
	return sub_goal;
    }
}

Public SubGoal* write_o_term_inSubGoal(sub_goal, o_term)
     SubGoal* sub_goal;
     OTerm* o_term;
{
    if (sub_goal == NULL)
      write_through_NULL("write_o_term_inSubGoal");
    else if (! is_sub_goal_non_NULL(sub_goal))
      type_error(sub_goal, "SUB_GOAL", "write_o_term_inSubGoal");
    else {
        sub_goal->o_term = o_term;
	return sub_goal;
    }
}

Public SubGoal* write_vc_pairs_inSubGoal(sub_goal, vc_pairs)
     SubGoal* sub_goal;
     ObjList* vc_pairs;
{
    if (sub_goal == NULL)
      write_through_NULL("write_vc_pairs_inSubGoal");
    else if (! is_sub_goal_non_NULL(sub_goal))
      type_error(sub_goal, "SUB_GOAL", "write_vc_pairs_inSubGoal");
    else {
        sub_goal->vc_pairs = vc_pairs;
	return sub_goal;
    }
}

Public SubGoal* new_sub_goal()
{
    SubGoal* sub_goal = (SubGoal*)dotsrc_malloc(sizeof(SubGoal));
    sub_goal->tag = SUB_GOAL;
    sub_goal->m_id = NULL;
    sub_goal->o_term = NULL;
    sub_goal->vc_pairs = NULL;
    return sub_goal;
}

Public void delete_sub_goal(sub_goal)
     SubGoal* sub_goal;
{
    if (sub_goal != NULL)
      if (is_sub_goal_non_NULL(sub_goal)) {
	  delete_o_term(sub_goal->m_id);
	  delete_o_term(sub_goal->o_term);
	  delete_obj_list(sub_goal->vc_pairs);
	  dotsrc_free((char*)sub_goal);
      }
      else
	type_error(sub_goal, "SUB_GOAL", "delete_sub_goal");
}

Public SubGoal* insert_vc_pairs_inSubGoal(sub_goal, vc_pairs)
     SubGoal* sub_goal;
     ObjList* vc_pairs;
{
    if (sub_goal == NULL)
      write_through_NULL("insert_vc_pairs_inSubGoal");
    else if (is_sub_goal_non_NULL(sub_goal))
      if (sub_goal->vc_pairs == NULL) {
	  sub_goal->vc_pairs = vc_pairs;
	  return sub_goal;
      }
      else {
	  insert_list_to_obj_list(sub_goal->vc_pairs, vc_pairs);
	  return sub_goal;
      }
    else
      type_error(sub_goal, "SUB_GOAL", "insert_vc_pairs_inSubGoal");
}

Public SubGoal* add_vc_pairs_inSubGoal(sub_goal, vc_pairs)
     SubGoal* sub_goal;
     ObjList* vc_pairs;
{
    if (sub_goal == NULL)
      write_through_NULL("add_vc_pairs_inSubGoal");
    else if (is_sub_goal_non_NULL(sub_goal))
      if (sub_goal->vc_pairs == NULL) {
	  sub_goal->vc_pairs = vc_pairs;
	  return sub_goal;
      }
      else {
	  concat_list_to_obj_list(sub_goal->vc_pairs, vc_pairs);
	  return sub_goal;
      }
    else
      type_error(sub_goal, "SUB_GOAL", "add_vc_pairs_inSubGoal");
}

Public VcPair* car_of_vc_pairs_inSubGoal(sub_goal)
     SubGoal* sub_goal;
{
    if (sub_goal == NULL || sub_goal->vc_pairs == NULL)
      return NULL;
    else
      return (VcPair*)extract_first_list_element(sub_goal->vc_pairs);
}


/*
 VC_PAIR
*/

Public Bool fis_vc_pair(object)
     PseudoObject* object;
{
    return object == NULL || object->tag == VC_PAIR;
}

Public void decompose_vc_pair(vc_pair, var, constraint)
     VcPair* vc_pair;
     Var** var;
     Constraint** constraint;
{
    if (vc_pair == NULL) {
        *var = NULL;
	*constraint = NULL;
    }
    else if (is_vc_pair_non_NULL(vc_pair)) {
        *var = vc_pair->var;
	*constraint = vc_pair->constraint;
    }
    else
      type_error(vc_pair, "VC_PAIR", "decompose_vc_pair");
}

Public Var* read_var_inVcPair(vc_pair)
     VcPair* vc_pair;
{
    if (vc_pair == NULL)
      return NULL;
    else if (is_vc_pair_non_NULL(vc_pair))
      return vc_pair->var;
    else
      type_error(vc_pair, "VC_PAIR", "read_var_inVcPair");
}

Public Constraint* read_constraint(vc_pair)
     VcPair* vc_pair;
{
    if (vc_pair == NULL)
      return NULL;
    else if (is_vc_pair_non_NULL(vc_pair))
      return vc_pair->constraint;
    else
      type_error(vc_pair, "VC_PAIR", "read_constraint");
}

Public VcPair* create_vc_pair(var, constraint)
     Var* var;
     Constraint* constraint;
{
    VcPair* vc_pair = (VcPair*)dotsrc_malloc(sizeof(VcPair));
    vc_pair->tag = VC_PAIR;
    vc_pair->var = var;
    vc_pair->constraint = constraint;
    return vc_pair;
}

Public VcPair* copy_vc_pair(vc_pair)
     VcPair* vc_pair;
{
    if (vc_pair == NULL) 
      return NULL;
    else if (is_vc_pair_non_NULL(vc_pair)) {
        VcPair* copy = (VcPair*)dotsrc_malloc(sizeof(VcPair));
	copy->tag = vc_pair->tag;
	copy->var = copy_var(vc_pair->var);
	copy->constraint = copy_constraint(vc_pair->constraint);
	return copy;
    }
    else
      type_error(vc_pair, "VC_PAIR", "copy_vc_pair");
}
   
Public VcPair* set_vc_pair(vc_pair, var, constraint)
     VcPair* vc_pair;
     Var* var;
     Constraint* constraint;
{
    if (vc_pair == NULL)
      write_through_NULL("set_vc_pair");
    else if (! is_vc_pair_non_NULL(vc_pair))
      type_error(vc_pair, "VC_PAIR", "set_vc_pair");
    else {
        vc_pair->var = var;
	vc_pair->constraint = constraint;
	return vc_pair;
    }
}

Public VcPair* write_var_inVcPair(vc_pair, var)
     VcPair* vc_pair;
     Var* var;
{
    if (vc_pair == NULL)
      write_through_NULL("write_var_inVcPair");
    else if (! is_vc_pair_non_NULL(vc_pair))
      type_error(vc_pair, "VC_PAIR", "write_var_inVcPair");
    else {
        vc_pair->var = var;
	return vc_pair;
    }
}

Public VcPair* write_constraint(vc_pair, constraint)
     VcPair* vc_pair;
     Constraint* constraint;
{
    if (vc_pair == NULL)
      write_through_NULL("write_constraint");
    else if (! is_vc_pair_non_NULL(vc_pair))
      type_error(vc_pair, "VC_PAIR", "write_constraint");
    else {
	vc_pair->constraint = constraint;
	return vc_pair;
    }
}


Public VcPair* new_vc_pair()
{
    VcPair* vc_pair = (VcPair*)dotsrc_malloc(sizeof(VcPair));
    vc_pair->tag = VC_PAIR;
    vc_pair->var = NULL;
    vc_pair->constraint = NULL;
    return vc_pair;
}

Public void delete_vc_pair(vc_pair)
     VcPair* vc_pair;
{
    if (vc_pair != NULL)
      if (is_vc_pair_non_NULL(vc_pair)) {
	  delete_var(vc_pair->var);
	  delete_constraint(vc_pair->constraint);
	  dotsrc_free((char*)vc_pair);
      }
      else
	type_error(vc_pair, "VC_PAIR", "delete_vc_pair");
}


/*
 CONSTRAINT
*/

Public Bool fis_constraint(object)
     PseudoObject* object;
{
    return object == NULL || object->tag == CONSTRAINT;
}

Public void decompose_constraint(constraint, const_data)
     Constraint* constraint;
     Con** const_data;
{
    if (constraint == NULL) 
      *const_data = NULL;
    else if (is_constraint_non_NULL(constraint)) 
      *const_data = constraint->const_data;
    else
      type_error(constraint, "CONSTRAINT", "decompose_constraint");
}

Public Con* read_const_data(constraint)
     Constraint* constraint;
{
    if (constraint == NULL)
      return NULL;
    else if (is_constraint_non_NULL(constraint))
      return constraint->const_data;
    else
      type_error(constraint, "CONSTRAINT", "read_const_data");
}

Public Constraint* create_constraint(const_data)
     Con* const_data;
{
    Constraint* constraint = 
      (Constraint*)dotsrc_malloc(sizeof(Constraint));
    constraint->tag = CONSTRAINT;
    constraint->const_data = const_data;
    return constraint;
}

Public Constraint* copy_constraint(constraint)
     Constraint* constraint;
{
    if (constraint == NULL) 
      return NULL;
    else if (is_constraint_non_NULL(constraint)) {
        Constraint* copy = 
	  (Constraint*)dotsrc_malloc(sizeof(Constraint));
	copy->tag = constraint->tag;
	copy->const_data = copy_con(constraint->const_data);
	return copy;
    }
    else
      type_error(constraint, "CONSTRAINT", "copy_constraint");
}
   
Public Constraint* set_constraint(constraint, const_data)
     Constraint* constraint;
     Con* const_data;
{
    if (constraint == NULL)
      write_through_NULL("set_constraint");
    else if (! is_constraint_non_NULL(constraint))
      type_error(constraint, "CONSTRAINT", "set_constraint");
    else {
        constraint->const_data = const_data;
	return constraint;
    }
}

Public Constraint* write_const_data(constraint, const_data)
     Constraint* constraint;
     Con* const_data;
{
    if (constraint == NULL)
      write_through_NULL("write_const_data");
    else if (! is_constraint_non_NULL(constraint))
      type_error(constraint, "CONSTRAINT", "write_const_data");
    else {
        constraint->const_data = const_data;
	return constraint;
      }
}

Public Constraint* new_constraint()
{
    Constraint* constraint = 
      (Constraint*)dotsrc_malloc(sizeof(Constraint));
    constraint->tag = CONSTRAINT;
    constraint->const_data = NULL;
    return constraint;
}

Public void delete_constraint(constraint)
     Constraint* constraint;
{
    if (constraint != NULL)
      if (is_constraint_non_NULL(constraint)) {
	  delete_con(constraint->const_data);
	  dotsrc_free((char*)constraint);
      }
      else
	type_error(constraint, "CONSTRAINT", "delete_constraint");
}


/*
 CON (have ObjList)
*/

Public Bool fis_con(object)
     PseudoObject* object;
{
    return object == NULL || object->tag == CON;
}

Public void decompose_con(con, o_terms1, o_terms2)
     Con* con;
     ObjList** o_terms1;
     ObjList** o_terms2;
{
    if (con == NULL) {
        *o_terms1 = NULL;
        *o_terms2 = NULL;
      }
    else if (is_con_non_NULL(con)) {
        *o_terms1 = con->o_terms1;
        *o_terms2 = con->o_terms2;
      }
    else
      type_error(con, "CON", "decompose_con");
}

Public ObjList* read_o_terms1_inCon(con)
     Con* con;
{
    if (con == NULL)
      return NULL;
    else if (is_con_non_NULL(con))
      return con->o_terms1;
    else
      type_error(con, "CON", "read_o_terms1_inCon");
}

Public ObjList* read_o_terms2_inCon(con)
     Con* con;
{
    if (con == NULL)
      return NULL;
    else if (is_con_non_NULL(con))
      return con->o_terms2;
    else
      type_error(con, "CON", "read_o_terms2_inCon");
}

Public Con* create_con(o_terms1, o_terms2)
     ObjList* o_terms1;
     ObjList* o_terms2;
{
    Con* con = (Con*)dotsrc_malloc(sizeof(Con));
    con->tag = CON;
    con->o_terms1 = o_terms1;
    con->o_terms2 = o_terms2;
    return con;
}

Public Con* copy_con(con)
     Con* con;
{
    if (con == NULL) 
      return NULL;
    else if (is_con_non_NULL(con)) {
        Con* copy = (Con*)dotsrc_malloc(sizeof(Con));
	copy->tag = con->tag;
	copy->o_terms1 = copy_obj_list(con->o_terms1);
	copy->o_terms2 = copy_obj_list(con->o_terms2);
	return copy;
    }
    else
      type_error(con, "CON", "copy_con");
}
   
Public Con* set_con(con, o_terms1, o_terms2)
     Con* con;
     ObjList* o_terms1;
     ObjList* o_terms2;
{
    if (con == NULL)
      write_through_NULL("set_con");
    else if (! is_con_non_NULL(con))
      type_error(con, "CON", "set_con");
    else {
        con->o_terms1 = o_terms1;
        con->o_terms2 = o_terms2;
	return con;
    }
}

Public Con* write_o_terms1_inCon(con, o_terms1)
     Con* con;
     ObjList* o_terms1;
{
    if (con == NULL)
      write_through_NULL("write_o_terms1_inCon");
    else if (! is_con_non_NULL(con))
      type_error(con, "CON", "write_o_terms1_inCon");
    else {
        con->o_terms1 = o_terms1;
	return con;
    }
}

Public Con* write_o_terms2_inCon(con, o_terms2)
     Con* con;
     ObjList* o_terms2;
{
    if (con == NULL)
      write_through_NULL("write_o_terms2_inCon");
    else if (! is_con_non_NULL(con))
      type_error(con, "CON", "write_o_terms2_inCon");
    else {
        con->o_terms2 = o_terms2;
	return con;
    }
}

Public Con* new_con()
{
    Con* con = (Con*)dotsrc_malloc(sizeof(Con));
    con->tag = CON;
    con->o_terms1 = NULL;
    con->o_terms2 = NULL;
    return con;
}

Public void delete_con(con)
     Con* con;
{
    if (con != NULL)
      if (is_con_non_NULL(con)) {
	  delete_obj_list(con->o_terms1);
	  delete_obj_list(con->o_terms2);
	  dotsrc_free((char*)con);
      }			  
      else
      type_error(con, "CON", "delete_con");
}

Public Con* insert_o_terms1_inCon(con, o_terms1)
     Con* con;
     ObjList* o_terms1;
{
    if (con == NULL)
      write_through_NULL("insert_o_terms1_inCon");
    else if (is_con_non_NULL(con))
      if (con->o_terms1 == NULL) {
	  con->o_terms1 = o_terms1;
	  return con;
      }
      else {
	  insert_list_to_obj_list(con->o_terms1, o_terms1);
	  return con;
      }
    else
      type_error(con, "CON", "insert_o_terms1_inCon");
}

Public Con* insert_o_terms2_inCon(con, o_terms2)
     Con* con;
     ObjList* o_terms2;
{
    if (con == NULL)
      write_through_NULL("insert_o_terms2_inCon");
    else if (is_con_non_NULL(con))
      if (con->o_terms2 == NULL) {
	  con->o_terms2 = o_terms2;
	  return con;
      }
      else {
	  insert_list_to_obj_list(con->o_terms2, o_terms2);
	  return con;
      }
    else
      type_error(con, "CON", "insert_o_terms2_inCon");
}

Public Con* add_o_terms1_inCon(con, o_terms1)
     Con* con;
     ObjList* o_terms1;
{
    if (con == NULL)
      write_through_NULL("add_o_terms1_inCon");
    else if (is_con_non_NULL(con))
      if (con->o_terms1 == NULL) {
	  con->o_terms1 = o_terms1;
	  return con;
      }
      else {
	  concat_list_to_obj_list(con->o_terms1, o_terms1);
	  return con;
      }
    else
      type_error(con, "CON", "add_o_terms1_inCon");
}

Public Con* add_o_terms2_inCon(con, o_terms2)
     Con* con;
     ObjList* o_terms2;
{
    if (con == NULL)
      write_through_NULL("add_o_terms2_inCon");
    else if (is_con_non_NULL(con))
      if (con->o_terms2 == NULL) {
	  con->o_terms2 = o_terms2;
	  return con;
      }
      else {
	  concat_list_to_obj_list(con->o_terms2, o_terms2);
	  return con;
      }
    else
      type_error(con, "CON", "add_o_terms2_inCon");
}


Public OTerm* car_of_o_terms1_inCon(con)
     Con* con;
{
    if (con == NULL || con->o_terms1 == NULL)
      return NULL;
    else
      return (OTerm*)extract_first_list_element(con->o_terms1);
}

Public OTerm* car_of_o_terms2_inCon(con)
     Con* con;
{
    if (con == NULL || con->o_terms2 == NULL)
      return NULL;
    else
      return (OTerm*)extract_first_list_element(con->o_terms2);
}


/*
 ASSUMP (have ObjList)
*/

Public Bool fis_assump(object)
     PseudoObject* object;
{
    return object == NULL || object->tag == ASSUMP;
}

Public void decompose_assump(assump, m_id, dot, vc_pairs)
     Assump* assump;
     MId** m_id;
     Dot** dot;
     ObjList** vc_pairs;
{
    if (assump == NULL) {
        *m_id = NULL;
	*dot = NULL;
	*vc_pairs = NULL;
      }
    else if (is_assump_non_NULL(assump)) {
        *m_id = assump->m_id;
	*dot = assump->dot;
	*vc_pairs = assump->vc_pairs;
      }
    else
      type_error(assump, "ASSUMP", "decompose_assump");
}

Public MId* read_m_id_inAssump(assump)
     Assump* assump;
{
    if (assump == NULL)
      return NULL;
    else if (is_assump_non_NULL(assump))
      return assump->m_id;
    else
      type_error(assump, "ASSUMP", "read_m_id_inAssump");
}

Public Dot* read_dot_inAssump(assump)
     Assump* assump;
{
    if (assump == NULL)
      return NULL;
    else if (is_assump_non_NULL(assump))
      return assump->dot;
    else
      type_error(assump, "ASSUMP", "read_dot_inAssump");
}

Public ObjList* read_vc_pairs_inAssump(assump)
     Assump* assump;
{
    if (assump == NULL)
      return NULL;
    else if (is_assump_non_NULL(assump))
      return assump->vc_pairs;
    else
      type_error(assump, "ASSUMP", "read_vc_pairs_inAssump");
}

Public Assump* create_assump(m_id, dot, vc_pairs)
     MId* m_id;
     Dot* dot;
     ObjList* vc_pairs;
{
    Assump* assump = (Assump*)dotsrc_malloc(sizeof(Assump));
    assump->tag = ASSUMP;
    assump->m_id = m_id;
    assump->dot = dot;
    assump->vc_pairs = vc_pairs;
    return assump;
}

Public Assump* copy_assump(assump)
     Assump* assump;
{
    if (assump == NULL) 
      return NULL;
    else if (is_assump_non_NULL(assump)) {
        Assump* copy = (Assump*)dotsrc_malloc(sizeof(Assump));
	copy->tag = assump->tag;
	copy->m_id = copy_o_term(assump->m_id);
	copy->dot = copy_dot(assump->dot);
	copy->vc_pairs = copy_obj_list(assump->vc_pairs);
	return copy;
    }
    else
      type_error(assump, "ASSUMP", "copy_assump");
}
   
Public Assump* set_assump(assump, m_id, dot, vc_pairs)
     Assump* assump;
     MId* m_id;
     Dot* dot;
     ObjList* vc_pairs;
{
    if (assump == NULL)
      write_through_NULL("set_assump");
    else if (! is_assump_non_NULL(assump))
      type_error(assump, "ASSUMP", "set_assump");
    else {
        assump->tag = ASSUMP;
	assump->m_id = m_id;
	assump->dot = dot;
	assump->vc_pairs = vc_pairs;
	return assump;
    }
}

Public Assump* write_m_id_inAssump(assump, m_id)
     Assump* assump;
     MId* m_id;
{
    if (assump == NULL)
      write_through_NULL("write_m_id_inAssump");
    else if (! is_assump_non_NULL(assump))
      type_error(assump, "ASSUMP", "write_m_id_inAssump");
    else {
	assump->m_id = m_id;
	return assump;
    }
}

Public Assump* write_dot_inAssump(assump, dot)
     Assump* assump;
     Dot* dot;
{
    if (assump == NULL)
      write_through_NULL("write_dot_inAssump");
    else if (! is_assump_non_NULL(assump))
      type_error(assump, "ASSUMP", "write_dot_inAssump");
    else {
	assump->dot = dot;
	return assump;
    }
}

Public Assump* write_vc_pairs_inAssump(assump, vc_pairs)
     Assump* assump;
     ObjList* vc_pairs;
{
    if (assump == NULL)
      write_through_NULL("write_vc_pairs_inAssump");
    else if (! is_assump_non_NULL(assump))
      type_error(assump, "ASSUMP", "write_vc_pairs_inAssump");
    else {
	assump->vc_pairs = vc_pairs;
	return assump;
    }
}

Public Assump* new_assump()
{
    Assump* assump = (Assump*)dotsrc_malloc(sizeof(Assump));
    assump->tag = ASSUMP;
    assump->m_id = NULL;
    assump->dot = NULL;
    assump->vc_pairs = NULL;
    return assump;
}

Public void delete_assump(assump)
     Assump* assump;
{
    if (assump != NULL)
      if (is_assump_non_NULL(assump)) {
	  delete_o_term(assump->m_id);
	  delete_dot(assump->dot);
	  delete_obj_list(assump->vc_pairs);
	  dotsrc_free((char*)assump);
      }			  
      else
        type_error(assump, "ASSUMP", "delete_assump");
}

Public Assump* insert_vc_pairs_inAssump(assump, vc_pairs)
     Assump* assump;
     ObjList* vc_pairs;
{
    if (assump == NULL)
      write_through_NULL("insert_vc_pairs_inAssump");
    else if (is_assump_non_NULL(assump))
      if (assump->vc_pairs == NULL) {
	  assump->vc_pairs = vc_pairs;
	  return assump;
      }
      else {
	  insert_list_to_obj_list(assump->vc_pairs, vc_pairs);
	  return assump;
      }
    else
        type_error(assump, "ASSUMP", "insert_vc_pairs_inAssump");
}

Public Assump* add_vc_pairs_inAssump(assump, vc_pairs)
     Assump* assump;
     ObjList* vc_pairs;
{
    if (assump == NULL)
      write_through_NULL("add_vc_pairs_inAssump");
    else if (is_assump_non_NULL(assump))
      if (assump->vc_pairs == NULL) {
	  assump->vc_pairs = vc_pairs;
	  return assump;
      }
      else {
	  concat_list_to_obj_list(assump->vc_pairs, vc_pairs);
	  return assump;
      }
    else
        type_error(assump, "ASSUMP", "add_vc_pairs_inAssump");
}


Public VcPair* car_of_vc_pairs_inAssump(assump)
     Assump* assump;
{
    if (assump == NULL || assump->vc_pairs == NULL)
      return NULL;
    else
      return (VcPair*)extract_first_list_element(assump->vc_pairs);
}


/*
 QUERY_EXPLANATION
*/

Public Bool fis_query_explanation(object)
     PseudoObject* object;
{
    return object == NULL || object->tag == QUERY_EXPLANATION;
}

Public QueryExplanation* copy_query_explanation(query_explanation)
     QueryExplanation* query_explanation;
{
    if (query_explanation == NULL) 
      return NULL;
    else if (is_query_explanation_non_NULL(query_explanation)) {
	QueryExplanation* copy = 
	  (QueryExplanation*)dotsrc_malloc(sizeof(QueryExplanation));
	copy->tag = query_explanation->tag;
	if (query_explanation->str_data == NULL)
	  copy->str_data = NULL;
	else
	  copy->str_data = dotsrc_strdup(query_explanation->str_data);
	return copy;
    }
    else
      type_error(query_explanation,"QUERY_EXPLANATION",
		   "copy_query_explanation");
}
    
#define QUERY_NAME_IN_QUERY_EXPLANATION "query" 
Public QueryExplanation* new_query_explanation()
{
    char *string = dotsrc_malloc(strlen(QUERY_NAME_IN_QUERY_EXPLANATION));
    QueryExplanation* query_explanation = 
      (QueryExplanation*)dotsrc_malloc(sizeof(QueryExplanation));
    strcpy(string, QUERY_NAME_IN_QUERY_EXPLANATION);
    query_explanation->tag = QUERY_EXPLANATION;
    query_explanation->str_data = string;
    return query_explanation;
}

Public void delete_query_explanation(query_explanation)
     QueryExplanation* query_explanation;
{
    if (query_explanation != NULL)
      if (is_query_explanation_non_NULL(query_explanation)) {
	if (query_explanation->str_data != NULL)
	    dotsrc_free((char*)query_explanation->str_data);
	  dotsrc_free((char*)query_explanation);
      }
      else
	type_error(query_explanation, "QUERY_EXPLANATION", 
		     "delete_query_explanation");
}

