#include "dotsrc.h"

/*
 VALUE (union)
*/

Public Bool fis_value(object)
     PseudoObject* object;
{
    return object == NULL || object->tag == VALUE ||
      fis_set(object) || fis_sort(object) || fis_o_term(object);
}

Public Value* create_value_set(set)
     Set* set;
{
    if (set == NULL)
      return NULL;
    else {
      Value* value = (Value*)dotsrc_malloc(sizeof(Value));

      *(Set*)value = *set;
      dotsrc_free((char*)set);
      return (Value*)value;
    }
}
    
Public Value* create_value_sort(sort)
     Sort* sort;
{
    if (sort == NULL)
      return NULL;
    else {
      Value* value = (Value*)dotsrc_malloc(sizeof(Value));

      *(Sort*)value = *sort;
      dotsrc_free((char*)sort);
      return (Value*)value;
    }
}

Public Value* create_value_o_term(o_term)
     OTerm* o_term;
{
    if (o_term == NULL)
      return NULL;
    else {
      Value* value = (Value*)dotsrc_malloc(sizeof(Value));

      *(OTerm*)value = *o_term;
      dotsrc_free((char*)o_term);
      return (Value*)value;
    }
}

Public Value* copy_value(value)
     Value* value;
{
    if (value == NULL)
      return NULL;
    else if (is_o_term(value))
      return (Value*) copy_o_term((OTerm*)value);
    else
      switch (value->tag) {
	case VALUE:
	  return new_value();
	  break;
	case SET:
	  return (Value*) copy_set((Set*)value);
	  break;
	case SORT:
	  return (Value*) copy_sort((Sort*)value);
	  break;
	default:
	  type_error(value, "VALUE", "copy_value");
	  break;
      }
}

Public Value* new_value()
{
    Value* value = (Value*)dotsrc_malloc(sizeof(Value));
    value->tag = VALUE;
    return value;
}

Public void delete_value(value)
     Value* value;
{
    if (value != NULL)
      if (is_o_term(value))
	  delete_o_term((OTerm*)value);
      else
        switch (value->tag) {
	  case VALUE:
	    dotsrc_free((char*)value);
  	    break;
	  case SET:
	    delete_set((Set*)value);
	    break;
	  case SORT:
	    delete_sort((Sort*)value);
	    break;
	  default:
	    type_error(value, "VALUE", "delete_value");
	    break;
      }
}


/*
 SET (have ObjList)
*/

Public Bool fis_set(object)
     PseudoObject* object;
{
    return object == NULL || object->tag == SET;
}

Public void decompose_set(set, o_terms)
     Set* set;
     ObjList** o_terms;
{
    if (set == NULL) 
      *o_terms = NULL;
    else if (is_set_non_NULL(set)) 
      *o_terms = set->o_terms;
    else
      type_error(set,"SET","decompose_set");
}

Public ObjList* read_o_terms_inSet(set)
     Set* set;
{
    if (set == NULL)
      return NULL;
    else if (is_set_non_NULL(set))
      return set->o_terms;
    else
      type_error(set, "SET", "read_o_terms_inSet");
}

Public Set* create_set(o_terms)
     ObjList* o_terms;
{
    Set* set = (Set*)dotsrc_malloc(sizeof(Set));
    set->tag = SET;
    set->o_terms = o_terms;
    return set;
}
   
Public Set* copy_set(set)
     Set* set;
{
    if (set == NULL) 
      return NULL;
    else if (is_set_non_NULL(set)) {
	Set* copy = (Set*)dotsrc_malloc(sizeof(Set));
	copy->tag = set->tag;
        copy->o_terms = copy_obj_list(set->o_terms);
	return copy;
    }
    else
      type_error(set, "SET", "copy_set");
}

Public Set* set_set(set, o_terms)
     Set* set;
     ObjList* o_terms;
{
    if (set == NULL)
      write_through_NULL("set_set");
    else if (! is_set_non_NULL(set))
      type_error(set, "SET", "set_set");
    else {
    set->o_terms = o_terms;
    return set;
    }
}

Set* write_o_terms_inSet(set, o_terms)
     Set* set;
     ObjList* o_terms;
{
    if (set == NULL)
      write_through_NULL("write_o_terms_inSet");
    else if (is_set_non_NULL(set)) {
        set->o_terms = o_terms;
	return set;
    }
    else
      type_error(set, "SET", "write_o_terms_inSet");
}

Public Set* new_set()
{
    Set* set = (Set*)dotsrc_malloc(sizeof(Set));
    set->tag = SET;
    set->o_terms = NULL;
    return set;
}

Public void delete_set(set)
     Set* set;
{
    if (set != NULL)
      if (is_set_non_NULL(set)) {
	  delete_obj_list(set->o_terms);
	  dotsrc_free((char*)set);
      }
      else
	type_error(set, "SET", "delete_set");
}

Public Set* insert_o_terms_inSet(set, o_terms)
     Set* set;
     ObjList* o_terms;
{
    if (set == NULL)
      write_through_NULL("insert_o_terms_inSet");
    else if (is_set_non_NULL(set))
      if (set->o_terms == NULL) {
  	  set->o_terms = o_terms;
	  return set;
      }
      else {
	  insert_list_to_obj_list(set->o_terms, o_terms);
	  return set;
      }
    else
      type_error(set, "SET", "insert_o_terms_inSet");
}

Public Set* add_o_terms_inSet(set, o_terms)
     Set* set;
     ObjList* o_terms;
{
    if (set == NULL)
      write_through_NULL("add_o_terms_inSet");
    else if (is_set_non_NULL(set))
      if (set->o_terms == NULL) {
	  set->o_terms = o_terms;
	  return set;
      }
      else {
	  concat_list_to_obj_list(set->o_terms, o_terms);
	  return set;
      }
    else
      type_error(set, "SET", "add_o_terms_inSet");
}
     
Public OTerm* car_of_o_terms_inSet(set)
     Set* set;
{
    if (set == NULL || set->o_terms == NULL)
      return NULL;
    else
      return (OTerm*)extract_first_list_element(set->o_terms);
}


/*
 CNSTR (union)
*/

Public Bool fis_cnstr(object)
     PseudoObject* object;
{
    return object == NULL || object->tag == CNSTR ||
      fis_cnstr_data(object) || fis_query_cnstr(object);
}

Public Cnstr* create_cnstr_cnstr(cnstr_data)
     CnstrData* cnstr_data;
{
    if (cnstr_data == NULL)
      return NULL;
    else {
      Cnstr* cnstr = (Cnstr*)dotsrc_malloc(sizeof(Cnstr));

      *(CnstrData*)cnstr = *cnstr_data;
      dotsrc_free((char*)cnstr_data);
      return (Cnstr*)cnstr;
    }
}

Public Cnstr* create_cnstr_query_cnstr(query_cnstr)
     QueryCnstr* query_cnstr;
{
    if (query_cnstr == NULL)
      return NULL;
    else {
      Cnstr* cnstr = (Cnstr*)dotsrc_malloc(sizeof(Cnstr));

      *(QueryCnstr*)cnstr = *query_cnstr;
      dotsrc_free((char*)query_cnstr);
      return (Cnstr*)cnstr;
    }
}

Public Cnstr* copy_cnstr(cnstr)
     Cnstr* cnstr;
{
    if (cnstr == NULL)
      return NULL;
    else
      switch (cnstr->tag) {
	case CNSTR:
	  return new_cnstr();
	  break;
	case CNSTR_DATA:
	  return (Cnstr*) copy_cnstr_data((CnstrData*)cnstr);
	  break;
        case QUERY_CNSTR:
	  return (Cnstr*) copy_query_cnstr((QueryCnstr*)cnstr);
	  break;
        default:
          type_error(cnstr, "CNSTR", "copy_cnstr");
	  break;
      }
}

Public Cnstr* new_cnstr()
{
    Cnstr* cnstr = (Cnstr*)dotsrc_malloc(sizeof(Cnstr));
    cnstr->tag = CNSTR;
    return cnstr;
}

Public void delete_cnstr(cnstr)
     Cnstr* cnstr;
{
    if (cnstr != NULL)
      switch (cnstr->tag) {
	case CNSTR:
	  dotsrc_free((char*)cnstr);
	  break;
	case CNSTR_DATA:
	  delete_cnstr_data((CnstrData*)cnstr);
	  break;
	case QUERY_CNSTR:
	  delete_query_cnstr((QueryCnstr*)cnstr);
	  break;
	default:
	  type_error(cnstr, "CNSTR", "delete_cnstr");
	  break;
      }
}


/*
 CNSTR_DATA
*/

Public Bool fis_cnstr_data(object)
     PseudoObject* object;
{
    return object == NULL || object->tag == CNSTR_DATA;
}

Public void decompose_cnstr_data(cnstr_data, m_id1,value1, rel, 
				   m_id2, value2)
     CnstrData* cnstr_data;
     MId** m_id1;
     Value** value1;
     CnRel* rel;
     MId** m_id2;
     Value** value2;
{
    if (cnstr_data == NULL) {
        *m_id1 = NULL;
	*value1 = NULL;
	*rel = NULL;
	*m_id2 = NULL;
	*value2 = NULL;
    }
    else if (is_cnstr_data_non_NULL(cnstr_data)) {
        *m_id1 = cnstr_data->m_id1;
	*value1 = cnstr_data->value1;
	*rel = cnstr_data->rel;
	*m_id2 = cnstr_data->m_id2;
	*value2 = cnstr_data->value2;
    }
    else
      type_error(cnstr_data, "CNSTR_DATA", "decompose_cnstr_data");
}

Public MId* read_m_id1_inCnstrData(cnstr_data)
     CnstrData* cnstr_data;
{
    if (cnstr_data == NULL)
      return NULL;
    else if (is_cnstr_data_non_NULL(cnstr_data)) 
      return cnstr_data->m_id1;
    else
      type_error(cnstr_data, "CNSTR_DATA", "read_m_id_inCnstrData");
}

Public Value* read_value1(cnstr_data)        
     CnstrData* cnstr_data;
{
    if (cnstr_data == NULL)
      return NULL;
    else if (is_cnstr_data_non_NULL(cnstr_data))
      return cnstr_data->value1;
    else
      type_error(cnstr_data, "CNSTR_DATA", "read_value1");
}

Public CnRel read_rel_inCnstrData(cnstr_data)
     CnstrData* cnstr_data;
{
    if (cnstr_data == NULL)
      return NULL;
    else if (is_cnstr_data_non_NULL(cnstr_data))
      return cnstr_data->rel;
    else
      type_error(cnstr_data, "CNSTR_DATA", "read_rel_inCnstrData");
}

Public MId* read_m_id2_inCnstrData(cnstr_data)
     CnstrData* cnstr_data;
{
    if (cnstr_data == NULL)
      return NULL;
    else if (is_cnstr_data_non_NULL(cnstr_data))
      return cnstr_data->m_id2;
    else
      type_error(cnstr_data, "CNSTR_DATA", "read_m_id2_inCnstrData");
}

Public Value* read_value2(cnstr_data)        
     CnstrData* cnstr_data;
{
    if (cnstr_data == NULL)
      return NULL;
    else if (is_cnstr_data_non_NULL(cnstr_data))
      return cnstr_data->value2;
    else
      type_error(cnstr_data, "CNSTR_DATA", "read_value2");
}

Public CnstrData* create_cnstr_data(m_id1, value1, rel, m_id2, value2)
     MId*  m_id1;
     Value* value1;
     CnRel rel;
     MId* m_id2;
     Value* value2;
{
    CnstrData* cnstr_data = 
      (CnstrData*)dotsrc_malloc(sizeof(CnstrData));
    cnstr_data->tag = CNSTR_DATA;
    cnstr_data->m_id1 = m_id1;
    cnstr_data->value1 = value1;
    cnstr_data->rel = rel;
    cnstr_data->m_id2 = m_id2;
    cnstr_data->value2 = value2;
    return cnstr_data;
}

Public CnstrData* copy_cnstr_data(cnstr_data)
     CnstrData* cnstr_data;
{
    if (cnstr_data == NULL)
      return NULL;
    else if (is_cnstr_data_non_NULL(cnstr_data)) {
	CnstrData* copy = (CnstrData*)dotsrc_malloc(sizeof(CnstrData));
	copy->tag = cnstr_data->tag;
	copy->m_id1 = copy_o_term(cnstr_data->m_id1);
	copy->value1 = copy_value(cnstr_data->value1);
	copy->rel = cnstr_data->rel;
	copy->m_id2 = copy_o_term(cnstr_data->m_id2);
	copy->value2 = copy_value(cnstr_data->value2);
	return copy;
    }
    else
      type_error(cnstr_data, "CNSTR_DATA", "copy_cnstr_data");
}

Public CnstrData* set_cnstr_data(cnstr_data, m_id1, value1, 
				   rel, m_id2, value2)
     CnstrData* cnstr_data;
     MId* m_id1;
     Value* value1;
     CnRel rel;
     MId* m_id2;
     Value* value2;
{
    if (cnstr_data == NULL)
      write_through_NULL("set_cnstr_data");
    else if (is_cnstr_data_non_NULL(cnstr_data)) {
        cnstr_data->m_id1 = m_id1;
	cnstr_data->value1 = value1;
	cnstr_data->rel = rel;
	cnstr_data->m_id2 = m_id2;
	cnstr_data->value2 = value2;
	return cnstr_data;
      }
    else
      type_error(cnstr_data, "CNSTR_DATA", "set_cnstr_data");
}

Public CnstrData* write_m_id1_inCnstrData(cnstr_data, m_id1)   
     CnstrData* cnstr_data;
     MId* m_id1;
{
    if (cnstr_data == NULL)
      write_through_NULL("write_m_id1_inCnstrData");
    else if (is_cnstr_data_non_NULL(cnstr_data)) {
        cnstr_data->m_id1 = m_id1;
	return cnstr_data;
      }
    else
      type_error(cnstr_data, "CNSTR_DATA", "write_m_id1_inCnstrData");
}

Public CnstrData* write_value1(cnstr_data,value1)   
     CnstrData* cnstr_data;
     Value* value1;
{
    if (cnstr_data == NULL)
      write_through_NULL("write_value1");
    else if (is_cnstr_data_non_NULL(cnstr_data)) {
	cnstr_data->value1 = value1;
	return cnstr_data;
      }
    else
      type_error(cnstr_data, "CNSTR_DATA", "write_value1");
}

Public CnstrData* write_rel_inCnstrData(cnstr_data,rel)
     CnstrData* cnstr_data;
     CnRel rel;
{
    if (cnstr_data == NULL)
      write_through_NULL("write_rel_inCnstrData");
    else if (is_cnstr_data_non_NULL(cnstr_data)) {
        cnstr_data->rel = rel;
	return cnstr_data;
      }
    else
      type_error(cnstr_data, "CNSTR_DATA", "write_rel_inCnstrData");
}

Public CnstrData* write_m_id2_inCnstrData(cnstr_data, m_id2)   
     CnstrData* cnstr_data;
     MId* m_id2;
{
    if (cnstr_data == NULL)
      write_through_NULL("write_m_id2_inCnstrData");
    else if (is_cnstr_data_non_NULL(cnstr_data)) {
        cnstr_data->m_id2 = m_id2;
	return cnstr_data;
      }
    else
      type_error(cnstr_data, "CNSTR_DATA", "write_m_id2_inCnstrData");
}

Public CnstrData* write_value2(cnstr_data, value2)   
     CnstrData* cnstr_data;
     Value* value2;
{
    if (cnstr_data == NULL)
      write_through_NULL("write_value2");
    else if (is_cnstr_data_non_NULL(cnstr_data)) {
        cnstr_data->value2 = value2;
	return cnstr_data;
      }
    else
      type_error(cnstr_data, "CNSTR_DATA", "write_value2");
}

Public CnstrData* new_cnstr_data()
{
    CnstrData* cnstr_data = (CnstrData*)dotsrc_malloc(sizeof(CnstrData));
    cnstr_data->tag = CNSTR_DATA;
    cnstr_data->m_id1 = NULL;
    cnstr_data->value1 = NULL;
    cnstr_data->rel = NULL;
    cnstr_data->m_id2 = NULL;
    cnstr_data->value2 = NULL;
    return cnstr_data;
}

Public void delete_cnstr_data(cnstr_data)
     CnstrData* cnstr_data;
{
    if (cnstr_data != NULL)
      if (is_cnstr_data_non_NULL(cnstr_data)) {
	  delete_o_term(cnstr_data->m_id1);
	  delete_value(cnstr_data->value1);
	  delete_o_term(cnstr_data->m_id2);
	  delete_value(cnstr_data->value2);
	  dotsrc_free((char*)cnstr_data);
      }
      else
	type_error(cnstr_data, "CNSTR_DATA", "delete_cnstr_data");
}


/*
 QUERY_CNSTR
*/
 
Public Bool fis_query_cnstr(object)
     PseudoObject* object;
{
    return object == NULL || object->tag == QUERY_CNSTR;
}

Public void decompose_query_cnstr(query_cnstr, m_id1, m_id2)
     QueryCnstr* query_cnstr;
     MId** m_id1;
     MId** m_id2;
{
    if (query_cnstr == NULL) {
        *m_id1 = NULL;
	*m_id2 = NULL;
    }
    else if (is_query_cnstr_non_NULL(query_cnstr)) {
        *m_id1 = query_cnstr->m_id1;
        *m_id2 = query_cnstr->m_id2;
    }
    else
      type_error(query_cnstr, "QUERY_CNSTR", "decompose_query_cnstr");
}

Public MId* read_m_id1_inQueryCnstr(query_cnstr)
     QueryCnstr* query_cnstr;
{
    if (query_cnstr == NULL)
      return NULL;
    else if (is_query_cnstr_non_NULL(query_cnstr)) 
      return query_cnstr->m_id1;
    else
      type_error(query_cnstr, "QUERY_CNSTR", "read_m_id1_inQuery");
}

Public MId* read_m_id2_inQueryCnstr(query_cnstr)
     QueryCnstr* query_cnstr;
{
    if (query_cnstr == NULL)
      return NULL;
    else if (is_query_cnstr_non_NULL(query_cnstr)) 
      return query_cnstr->m_id2;
    else
      type_error(query_cnstr, "QUERY_CNSTR", "read_m_id2_inQuery");
}

Public QueryCnstr* create_query_cnstr(m_id1, m_id2)
     MId* m_id1;
     MId* m_id2;
{
    QueryCnstr* query_cnstr = 
      (QueryCnstr*)dotsrc_malloc(sizeof(QueryCnstr));
    query_cnstr->tag = QUERY_CNSTR;
    query_cnstr->m_id1 = m_id1;
    query_cnstr->m_id2 = m_id2;
    return query_cnstr;
}

Public QueryCnstr* copy_query_cnstr(query_cnstr)
     QueryCnstr* query_cnstr;
{
    if (query_cnstr == NULL)
      return NULL;
    else if (is_query_cnstr_non_NULL(query_cnstr)) {
        QueryCnstr* copy = 
	  (QueryCnstr*)dotsrc_malloc(sizeof(QueryCnstr));
	copy->tag = query_cnstr->tag;
	copy->m_id1 = copy_o_term(query_cnstr->m_id1);
	copy->m_id2 = copy_o_term(query_cnstr->m_id2);
	return copy;
    }
    else
      type_error(query_cnstr, "QUERY_CNSTR", "copy_query_cnstr");
}

Public QueryCnstr* set_query_cnstr(query_cnstr, m_id1, m_id2)
     QueryCnstr* query_cnstr;
     MId* m_id1;
     MId* m_id2;
{
    if (query_cnstr == NULL)
      write_through_NULL("set_query_cnstr");
    else if (is_query_cnstr_non_NULL(query_cnstr)) {
        query_cnstr->m_id1 = m_id1;
	query_cnstr->m_id2 = m_id2;
	return query_cnstr;
      }
    else
      type_error(query_cnstr, "QUERY_CNSTR", "set_query_cnstr");
}

Public QueryCnstr* write_m_id1_inQueryCnstr(query_cnstr, m_id1)
     QueryCnstr* query_cnstr;
     MId* m_id1;
{
    if (query_cnstr == NULL)
      write_through_NULL("write_m_id1_inQueryCnstr");
    else if (is_query_cnstr_non_NULL(query_cnstr)) {
        query_cnstr->m_id1 = m_id1;
	return query_cnstr;
      }
    else
      type_error(query_cnstr, "QUERY_CNSTR", "write_m_id1_inQueryCnstr");
}

Public QueryCnstr* write_m_id2_inQueryCnstr(query_cnstr, m_id2)
     QueryCnstr* query_cnstr;
     MId* m_id2;
{
    if (query_cnstr == NULL)
      write_through_NULL("write_m_id1_inQueryCnstr");
    else if (is_query_cnstr_non_NULL(query_cnstr)) {
        query_cnstr->m_id2 = m_id2;
	return query_cnstr;
      }
    else
      type_error(query_cnstr, "QUERY_CNSTR", "write_m_id2_inQueryCnstr");
}

Public QueryCnstr* new_query_cnstr()
{
    QueryCnstr* query_cnstr = 
      (QueryCnstr*)dotsrc_malloc(sizeof(QueryCnstr));
    query_cnstr->tag = QUERY_CNSTR;
    query_cnstr->m_id1 = NULL;
    query_cnstr->m_id2 = NULL;
    return query_cnstr;
}

Public void delete_query_cnstr(query_cnstr)
     QueryCnstr* query_cnstr;
{
    if (query_cnstr != NULL)
      if (is_query_cnstr_non_NULL(query_cnstr)) {
	  delete_o_term(query_cnstr->m_id1);
	  delete_o_term(query_cnstr->m_id2);
	  dotsrc_free((char*)query_cnstr);
      }
      else
        type_error(query_cnstr, "QUERY_CNSTR", "delete_query_cnstr");
}


/*
 PROLOG (have ObjList)
*/

Public Bool fis_prolog(object)
     PseudoObject* object;
{
    return object == NULL || object->tag == PROLOG;
}

Public void decompose_prolog(prolog, head, o_terms)
     Prolog* prolog;
     char** head;
     ObjList** o_terms;
{
    if (prolog == NULL) {
        *head = NULL;
	*o_terms = NULL;
      }
    else if (is_prolog_non_NULL(prolog)) {
        *head = prolog->head;
	*o_terms = prolog->o_terms;
      }
    else
      type_error(prolog, "PROLOG", "decompose_prolog");
}

Public char* read_head_inProlog(prolog)
     Prolog* prolog;
{
    if (prolog == NULL)
      return NULL;
    else if (is_prolog_non_NULL(prolog))
      return prolog->head;
    else
      type_error(prolog, "PROLOG", "read_head_inProlog");
}

Public ObjList* read_o_terms_inProlog(prolog)
     Prolog* prolog;
{
    if (prolog == NULL)
      return NULL;
    else if (is_prolog_non_NULL(prolog))
      return prolog->o_terms;
    else
      type_error(prolog, "PROLOG", "read_o_terms_inProlog");
}

Public Prolog* create_prolog(head, o_terms)
     char* head;
     ObjList* o_terms;
{
    Prolog* prolog = (Prolog*)dotsrc_malloc(sizeof(Prolog));
    prolog->tag = PROLOG;
    prolog->head = head;
    prolog->o_terms = o_terms;
    return prolog;
}

Public Prolog* copy_prolog(prolog)
     Prolog* prolog;
{
    if (prolog == NULL) 
      return NULL;
    else if (is_prolog_non_NULL(prolog)) {
        Prolog* copy = (Prolog*)dotsrc_malloc(sizeof(Prolog));
	copy->tag = prolog->tag;
	if (prolog->head == NULL)
	  copy->head = NULL;
	else
	  copy->head = dotsrc_strdup(prolog->head);
	copy->o_terms = copy_obj_list(prolog->o_terms);
	return copy;
    }
    else
      type_error(prolog, "PROLOG", "copy_prolog");
}
   
Public Prolog* set_prolog(prolog, head, o_terms)
     Prolog* prolog;
     char* head;
     ObjList* o_terms;
{
    if (prolog == NULL)
      write_through_NULL("set_prolog");
    else if (! is_prolog_non_NULL(prolog))
      type_error(prolog, "PROLOG", "set_prolog");
    else {
        prolog->tag = PROLOG;
	prolog->head = head;
	prolog->o_terms = o_terms;
	return prolog;
    }
}

Public Prolog* write_head_inProlog(prolog, head)
     Prolog* prolog;
     char* head;
{
    if (prolog == NULL)
      write_through_NULL("write_head_inProlog");
    else if (! is_prolog_non_NULL(prolog))
      type_error(prolog, "PROLOG", "write_head_inProlog");
    else {
	prolog->head = head;
	return prolog;
    }
}

Public Prolog* write_o_terms_inProlog(prolog, o_terms)
     Prolog* prolog;
     ObjList* o_terms;
{
    if (prolog == NULL)
      write_through_NULL("write_o_terms_inProlog");
    else if (! is_prolog_non_NULL(prolog))
      type_error(prolog, "PROLOG", "write_o_terms_inProlog");
    else {
	prolog->o_terms = o_terms;
	return prolog;
    }
}

Public Prolog* new_prolog()
{
    Prolog* prolog = (Prolog*)dotsrc_malloc(sizeof(Prolog));
    prolog->tag = PROLOG;
    prolog->head = NULL;
    prolog->o_terms = NULL;
    return prolog;
}

Public void delete_prolog(prolog)
     Prolog* prolog;
{
    if (prolog != NULL)
      if (is_prolog_non_NULL(prolog)) {
	if (prolog->head != NULL)
	    dotsrc_free((char*)prolog->head);
	  delete_obj_list(prolog->o_terms);
	  dotsrc_free((char*)prolog);
      }			  
      else
        type_error(prolog, "PROLOG", "delete_prolog");
}

Public Prolog* insert_o_terms_inProlog(prolog, o_terms)
     Prolog* prolog;
     ObjList* o_terms;
{
    if (prolog == NULL)
      write_through_NULL("insert_o_terms_inProlog");
    else if (is_prolog_non_NULL(prolog))
      if (prolog->o_terms == NULL) {
	  prolog->o_terms = o_terms;
	  return prolog;
      }
      else {
	  insert_list_to_obj_list(prolog->o_terms, o_terms);
	  return prolog;
      }
    else
        type_error(prolog, "PROLOG", "insert_o_terms_inProlog");
}

Public Prolog* add_o_terms_inProlog(prolog, o_terms)
     Prolog* prolog;
     ObjList* o_terms;
{
    if (prolog == NULL)
      write_through_NULL("add_o_terms_inProlog");
    else if (is_prolog_non_NULL(prolog))
      if (prolog->o_terms == NULL) {
	  prolog->o_terms = o_terms;
	  return prolog;
      }
      else {
	  concat_list_to_obj_list(prolog->o_terms, o_terms);
	  return prolog;
      }
    else
        type_error(prolog, "PROLOG", "add_o_terms_inProlog");
}

Public OTerm* car_of_o_terms_inProlog(prolog)
     Prolog* prolog;
{
    if (prolog == NULL || prolog->o_terms == NULL)
      return NULL;
    else
      return (OTerm*)extract_first_list_element(prolog->o_terms);
}


/*
 VAR
*/

Public Bool fis_var(object)
     PseudoObject* object;
{
    return object == NULL || object->tag == VAR;
}

Public void decompose_var(var, type, var_data)
     Var* var;
     VarType* type;
     char** var_data;
{
    if (var == NULL) {
        *type = NULL;
	*var_data = NULL;
    }
    else if (is_var_non_NULL(var)) {
        *type = var->type;
	*var_data = var->var_data;
    }
    else
      type_error(var, "VAR", "decompose_var");
}
      
Public VarType read_type(var)
     Var* var;
{
    if (var == NULL)
      return NULL;
    else if (is_var_non_NULL(var))
      return var->type;
    else
      type_error(var, "VAR", "read_type");
}
      
Public char* read_var_data(var)
     Var* var;
{
    if (var == NULL)
      return NULL;
    else if (is_var_non_NULL(var))
      return var->var_data;
    else
      type_error(var, "VAR", "read_var_data");
}
      
Public Var* create_var(type, var_data)
     VarType type;
     char* var_data;
{
    Var* var = (Var*)dotsrc_malloc(sizeof(Var));
    var->tag = VAR;
    var->type = type;
    var->var_data = var_data;
    return var;
}

Public Var* copy_var(var)
     Var* var;
{
    if (var == NULL) 
      return NULL;
    else if (is_var_non_NULL(var)) {
	Var* copy = (Var*)dotsrc_malloc(sizeof(Var));
	copy->tag = var->tag;
	copy->type = var->type;
	if (var->var_data == NULL)
	  copy->var_data = NULL;
	else
	  copy->var_data = dotsrc_strdup(var->var_data);
	return copy;
    }
    else
      type_error(var,"VAR","copy_var");
}
    
Public Var* set_var(var, type, var_data)
     Var* var;
     VarType type;
     char* var_data;
{
    if (var == NULL)
      write_through_NULL("set_var");
    else if (is_var_non_NULL(var)) {
        var->type = type;
	var->var_data = var_data;
	return var;
    }
    else
      type_error(var, "VAR", "set_var");
}

Public Var* write_type(var, type)
     Var* var;
     VarType type;
{
    if (var == NULL)
      write_through_NULL("write_type");
    else if (is_var_non_NULL(var)) {
        var->type = type;
	return var;
    }
    else
      type_error(var, "VAR", "write_type");
}

Public Var* write_var_data(var, var_data)
     Var* var;
     char* var_data;
{
    if (var == NULL)
      write_through_NULL("write_var_data");
    else if (is_var_non_NULL(var)) {
        var->var_data = var_data;
	return var;
    }
    else
      type_error(var, "VAR", "write_var_data");
}

Public Var* new_var()
{
    Var* var = (Var*)dotsrc_malloc(sizeof(Var));
    var->tag = VAR;
    var->type = NULL;
    var->var_data = NULL;
    return var;
}

Public void delete_var(var)
     Var* var;
{
    if (var != NULL)
      if (is_var_non_NULL(var)) {
	if (var->var_data != NULL)
	    dotsrc_free((char*)var->var_data);
	  dotsrc_free((char*)var);
      }
      else
	type_error(var, "VAR", "delete_var");
}


/*
 SORT
*/

Public Bool fis_sort(object)
     PseudoObject* object;
{
    return object == NULL || object->tag == SORT;
}

Public void decompose_sort(sort, prolog)
     Sort* sort;
     Prolog** prolog;
{
    if (sort == NULL)
      *prolog = NULL;
    else if (is_sort_non_NULL(sort))
      *prolog = sort->prolog;
    else
      type_error(sort,"SORT","decompose_sort");
}

Public Prolog* read_prolog(sort)
     Sort* sort;
{
    if (sort == NULL)
      return NULL;
    else if (is_sort_non_NULL(sort))
      return sort->prolog;
    else
      type_error(sort,"SORT","read_prolog");
}

Public Sort* create_sort(prolog)
     Prolog* prolog;
{
    Sort* sort = (Sort*)dotsrc_malloc(sizeof(Sort));
    sort->tag = SORT;
    sort->prolog = prolog;
    return sort;
}
   
Public Sort* copy_sort(sort)
     Sort* sort;
{
    if (sort == NULL) 
      return NULL;
    else if (is_sort_non_NULL(sort)) {
	Sort* copy = (Sort*)dotsrc_malloc(sizeof(Sort));
	copy->tag = sort->tag;
        copy->prolog = copy_prolog(sort->prolog);
	return copy;
    }
    else
      type_error(sort, "SORT", "copy_sort");
}

Public Sort* set_sort(sort, prolog)
     Sort* sort;
     Prolog* prolog;
{
    if (sort == NULL)
      write_through_NULL("set_sort");
    else if (! is_sort_non_NULL(sort))
      type_error(sort, "SORT", "set_sort");
    else {
      sort->prolog = prolog;
      return sort;
    }
}

Public Sort* write_prolog(sort, prolog)
     Sort* sort;
     Prolog* prolog;
{
    if (sort == NULL)
      write_through_NULL("write_prolog");
    else if (! is_sort_non_NULL(sort))
      type_error(sort, "SORT", "write_prolog");
    else {
      sort->prolog = prolog;
      return sort;
    }
}

Public Sort* new_sort()
{
    Sort* sort = (Sort*)dotsrc_malloc(sizeof(Sort));
    sort->tag = SORT;
    sort->prolog = NULL;
    return sort;
}

Public void delete_sort(sort)
     Sort* sort;
{
    if (sort != NULL)
      if (is_sort_non_NULL(sort)) {
	  delete_prolog(sort->prolog);
	  dotsrc_free((char*)sort);
      }
      else
	type_error(sort, "SORT", "delete_sort");
}


/*
 QUERY (have ObjList)
*/
 
Public Bool fis_query(object)
     PseudoObject* object;
{
    return object == NULL || object->tag == QUERY;
}

Public void decompose_query(query, query_class, q_head, clusters, 
			      cnstrs, q_modes, program)
     Query*      query;
     RuleClass*  query_class;
     ATerm**     q_head;
     ObjList**   clusters;
     ObjList**   cnstrs;
     ObjList**   q_modes;
     Program**   program;
{
    if (query == NULL) {
        *query_class = NULL;
	*q_head = NULL;
	*clusters = NULL;
	*cnstrs = NULL;
	*q_modes = NULL;
	*program = NULL;
    }
    else if (is_query_non_NULL(query)) {
        *query_class = query->query_class;
	*q_head = query->q_head;
	*clusters = query->clusters;
	*cnstrs = query->cnstrs;
	*q_modes = query->q_modes;
	*program = query->program;
    }
    else
      type_error(query, "QUERY", "decompose_query");
}

Public RuleClass read_query_class(query)
     Query* query;
{
    if (query == NULL)
      return NULL;
    else if (is_query_non_NULL(query)) 
      return query->query_class;
    else
      type_error(query, "QUERY", "read_query_class");
}

Public ATerm* read_q_head(query)
     Query* query;
{
    if (query == NULL)
      return NULL;
    else if (is_query_non_NULL(query)) 
      return query->q_head;
    else
      type_error(query, "QUERY", "read_q_head");
}

Public ObjList* read_clusters_inQuery(query)
     Query* query;
{
    if (query == NULL)
      return NULL;
    else if (is_query_non_NULL(query)) 
      return query->clusters;
    else
      type_error(query, "QUERY", "read_clusters_inQuery");
}

Public ObjList* read_cnstrs_inQuery(query)
     Query* query;
{
    if (query == NULL)
      return NULL;
    else if (is_query_non_NULL(query)) 
      return query->cnstrs;
    else
      type_error(query, "QUERY", "read_cnstrs_inQuery");
}

Public ObjList* read_q_modes(query)
     Query* query;
{
    if (query == NULL)
      return NULL;
    else if (is_query_non_NULL(query)) 
      return query->q_modes;
    else
      type_error(query, "QUERY", "read_q_modes");
}

Public Program* read_program_inQuery(query)
     Query* query;
{
    if (query == NULL)
      return NULL;
    else if (is_query_non_NULL(query)) 
      return query->program;
    else
      type_error(query, "QUERY", "read_program_inQuery");
}

Public Query* create_query(query_class, q_head, clusters, cnstrs, 
			   q_modes, program)
     RuleClass query_class;
     ATerm* q_head;
     ObjList* clusters;
     ObjList* cnstrs;
     ObjList* q_modes;
     Program* program;
{
    Query* query = (Query*)dotsrc_malloc(sizeof(Query));
    query->tag = QUERY;
    query->query_class = query_class;
    query->q_head = q_head;
    query->clusters = clusters;
    query->cnstrs = cnstrs;
    query->q_modes = q_modes;
    query->program = program;
    return query;
}

Public Query* copy_query(query)
     Query* query;
{
    if (query == NULL)
      return NULL;
    else if (is_query_non_NULL(query)) {
	Query* copy = (Query*)dotsrc_malloc(sizeof(Query));
	copy->tag = query->tag;
	copy->query_class = query->query_class;
	copy->q_head = copy_a_term(query->q_head);
	copy->clusters = copy_obj_list(query->clusters);
	copy->cnstrs = copy_obj_list(query->cnstrs);
	copy->q_modes = copy_obj_list(query->q_modes);
	copy->program = copy_program(query->program);
	return copy;
    }
    else
      type_error(query, "QUERY", "copy_query");
}


Public Query* set_query(query, query_class, q_head, clusters, cnstrs, 
			q_modes, program)
     Query* query;
     RuleClass query_class;
     ATerm* q_head;
     ObjList* clusters;
     ObjList* cnstrs;
     ObjList* q_modes;
     Program* program;
{
    if (query == NULL)
      write_through_NULL("set_query");
    else if (is_query_non_NULL(query)) {
        query->query_class = query_class;
	query->q_head = q_head;
	query->clusters = clusters;
	query->cnstrs = cnstrs;
	query->q_modes = q_modes;
	query->program = program;
	return query;
    }
    else
      type_error(query, "QUERY", "set_query");
}

Public Query* write_query_class(query, query_class)
     Query* query;
     RuleClass query_class;
{
    if (query == NULL)
      write_through_NULL("write_query_class");
    else if (is_query_non_NULL(query)) {
        query->query_class = query_class;
	return query;
    }
    else
      type_error(query, "QUERY", "write_query_class");
}

Public Query* write_q_head(query, q_head)
     Query* query;
     ATerm* q_head;
{
    if (query == NULL)
      write_through_NULL("write_q_head");
    else if (is_query_non_NULL(query)) {
        query->q_head = q_head;
	return query;
    }
    else
      type_error(query, "QUERY", "write_q_head");
}

Public Query* write_clusters_inQuery(query, clusters)
   Query* query;
   ObjList* clusters;
{
    if (query == NULL)
      write_through_NULL("write_clusters_inQuery");
    else if (is_query_non_NULL(query)) {
        query->clusters = clusters;
	return query;
    }
    else
      type_error(query, "QUERY", "write_clusters_inQuery");
}

Public Query* write_cnstrs_inQuery(query, cnstrs)
     Query* query;
     ObjList* cnstrs;
{
    if (query == NULL)
      write_through_NULL("write_cnstrs_inQuery");
    else if (is_query_non_NULL(query)) {
        query->cnstrs = cnstrs;
	return query;
    }
    else
      type_error(query, "QUERY", "write_cnstrs_inQuery");
}

Public Query* write_q_modes(query, q_modes)
     Query* query;
     ObjList* q_modes;
{
    if (query == NULL)
      write_through_NULL("write_q_modes");
    else if (is_query_non_NULL(query)) {
        query->q_modes = q_modes;
	return query;
    }
    else
      type_error(query, "QUERY", "write_q_modes");
}

Public Query* write_program_inQuery(query, program)
   Query*      query;
   Program*    program;
{
    if (query == NULL)
      write_through_NULL("write_program_inQuery");
    else if (is_query_non_NULL(query)) {
        query->program = program;
	return query;
    }
    else
      type_error(query, "QUERY", "write_program_inQuery");
}

Public Query* new_query()
{
    Query* query = (Query*)dotsrc_malloc(sizeof(Query));
    query->tag = QUERY;
    query->query_class = NULL;
    query->q_head = NULL;
    query->clusters = NULL;
    query->cnstrs = NULL;
    query->q_modes = NULL;
    query->program = NULL;
    return query;
}

Public void delete_query(query)
     Query* query;
{
    if (query != NULL)
      if (is_query_non_NULL(query)) {
	  delete_a_term(query->q_head);
	  delete_obj_list(query->clusters);
	  delete_obj_list(query->cnstrs);
	  delete_obj_list(query->q_modes);
	  delete_program(query->program);
	  dotsrc_free((char*)query);
      }
      else
	type_error(query, "QUERY", "delete_query");
}

Public Query* insert_clusters(query, clusters)
     Query* query;
     ObjList* clusters;
{
    if (query == NULL)
      write_through_NULL("insert_clusters");
    else if (is_query_non_NULL(query))
      if (query->clusters == NULL) {
	  query->clusters = clusters;
	  return query;
      }
      else {
	  insert_list_to_obj_list(query->clusters, clusters);
	  return query;
      }
    else
      type_error(query, "QUERY", "insert_clusters");
}

Public Query* insert_cnstrs(query, cnstrs)
     Query* query;
     ObjList* cnstrs;
{
    if (query == NULL)
      write_through_NULL("insert_cnstrs");
    else if (is_query_non_NULL(query))
      if (query->cnstrs == NULL) {
	  query->cnstrs = cnstrs;
	  return query;
      }
      else {
	  insert_list_to_obj_list(query->cnstrs, cnstrs);
	  return query;
      }
    else
      type_error(query, "QUERY", "insert_cnstrs");
}

Public Query* insert_q_modes(query, q_modes)
     Query* query;
     ObjList* q_modes;
{
    if (query == NULL)
      write_through_NULL("insert_q_modes");
    else if (is_query_non_NULL(query))
      if (query->q_modes == NULL) {
	  query->q_modes = q_modes;
	  return query;
      }
      else {
	  insert_list_to_obj_list(query->q_modes, q_modes);
	  return query;
      }
    else
      type_error(query, "QUERY", "insert_q_modes");
}


Public Query* add_clusters(query, clusters)
     Query* query;
     ObjList* clusters;
{
    if (query == NULL)
      write_through_NULL("add_clusters");
    else if (is_query_non_NULL(query))
      if (query->clusters == NULL) {
	  query->clusters = clusters;
	  return query;
      }
      else {
	  concat_list_to_obj_list(query->clusters, clusters);
	  return query;
      }
    else
      type_error(query, "QUERY", "add_clusters");
}


Public Query* add_cnstrs(query, cnstrs)
     Query* query;
     ObjList* cnstrs;
{
    if (query == NULL)
      write_through_NULL("add_cnstrs");
    else if (is_query_non_NULL(query))
      if (query->cnstrs == NULL) {
	  query->cnstrs = cnstrs;
	  return query;
      }
      else {
	  concat_list_to_obj_list(query->cnstrs, cnstrs);
	  return query;
      }
    else
      type_error(query, "QUERY", "add_cnstrs");
}

Public Query* add_q_modes(query, q_modes)
     Query* query;
     ObjList* q_modes;
{
    if (query == NULL)
      write_through_NULL("add_q_modes");
    else if (is_query_non_NULL(query))
      if (query->q_modes == NULL) {
	  query->q_modes = q_modes;
	  return query;
      }
      else {
	  concat_list_to_obj_list(query->q_modes, q_modes);
	  return query;
      }
    else
      type_error(query, "QUERY", "add_q_modes");
}

Public Cluster* car_of_clusters(query)
     Query* query;
{
    if (query == NULL || query->clusters == NULL)
      return NULL;
    else
      return (Cluster*)extract_first_list_element(query->clusters);
}

Public Cnstr* car_of_cnstrs(query)
     Query* query;
{
    if (query == NULL || query->cnstrs == NULL)
      return NULL;
    else
      return (Cnstr*)extract_first_list_element(query->cnstrs);
}

Public QMode* car_of_q_modes(query)
     Query* query;
{
    if (query == NULL || query->q_modes == NULL)
      return NULL;
    else
      return (QMode*)extract_first_list_element(query->q_modes);
}


/*
 Q_MODE (union)
*/

Public Bool fis_q_mode(object)
     PseudoObject* object;
{
    return object == NULL || object->tag == Q_MODE ||
      fis_p_mode(object) || fis_a_mode(object) || fis_i_mode(object) ||
      fis_m_mode(object) || fis_e_mode(object);
}

Public QMode* create_q_mode_p_mode(p_mode)
     PMode* p_mode;
{
    if (p_mode == NULL)
      return NULL;
    else {
      QMode* q_mode = (QMode*)dotsrc_malloc(sizeof(QMode));

      *(PMode*)q_mode = *p_mode;
      dotsrc_free((char*)p_mode);
      return (QMode*)q_mode;
    }
}

Public QMode* create_q_mode_a_mode(a_mode)
     AMode* a_mode;
{
    if (a_mode == NULL)
      return NULL;
    else {
      QMode* q_mode = (QMode*)dotsrc_malloc(sizeof(QMode));

      *(AMode*)q_mode = *a_mode;
      dotsrc_free((char*)a_mode);
      return (QMode*)q_mode;
    }
}

Public QMode* create_q_mode_i_mode(i_mode)
     IMode* i_mode;
{
    if (i_mode == NULL)
      return NULL;
    else {
      QMode* q_mode = (QMode*)dotsrc_malloc(sizeof(QMode));

      *(IMode*)q_mode = *i_mode;
      dotsrc_free((char*)i_mode);
      return (QMode*)q_mode;
    }
}
    
Public QMode* create_q_mode_m_mode(m_mode)
     MMode* m_mode;
{
    if (m_mode == NULL)
      return NULL;
    else {
      QMode* q_mode = (QMode*)dotsrc_malloc(sizeof(QMode));

      *(MMode*)q_mode = *m_mode;
      dotsrc_free((char*)m_mode);
      return (QMode*)q_mode;
    }
}

Public QMode* create_q_mode_e_mode(e_mode)
     EMode* e_mode;
{
    if (e_mode == NULL)
      return NULL;
    else {
      QMode* q_mode = (QMode*)dotsrc_malloc(sizeof(QMode));

      *(EMode*)q_mode = *e_mode;
      dotsrc_free((char*)e_mode);
      return (QMode*)q_mode;
    }
}
    
Public QMode* copy_q_mode(q_mode)
     QMode* q_mode;
{
    if (q_mode == NULL)
      return NULL;
    else
      switch (q_mode->tag) {
	case Q_MODE:
	  return new_q_mode();
	  break;
	case P_MODE:
	  return (QMode*) copy_p_mode((PMode*)q_mode);
	  break;
	case A_MODE:
	  return (QMode*) copy_a_mode((AMode*)q_mode);
	  break;
	case I_MODE:
	  return (QMode*) copy_i_mode((IMode*)q_mode);
	  break;
	case M_MODE:
	  return (QMode*) copy_m_mode((MMode*)q_mode);
	  break;
	case E_MODE:
	  return (QMode*) copy_e_mode((EMode*)q_mode);
	  break;
	default:
	  type_error(q_mode, "Q_MODE", "copy_q_mode");
	  break;
      }
}


Public QMode* new_q_mode()
{
    QMode* q_mode = (QMode*)dotsrc_malloc(sizeof(QMode));
    q_mode->tag = Q_MODE;
    return q_mode;
}

Public void delete_q_mode(q_mode)
     QMode* q_mode;
{
    if (q_mode != NULL)
      switch (q_mode->tag) {
	case Q_MODE:
	  dotsrc_free((char*)q_mode);
	  break;
	case P_MODE:
	  delete_p_mode((PMode*)q_mode);
	  break;
	case A_MODE:
	  delete_a_mode((AMode*)q_mode);
	  break;
	case I_MODE:
	  delete_i_mode((IMode*)q_mode);
	  break;
	case M_MODE:
	  delete_m_mode((MMode*)q_mode);
	  break;
	case E_MODE:
	  delete_e_mode((EMode*)q_mode);
	  break;
	default:
	  type_error(q_mode, "Q_MODE", "delete_q_mode");
	  break;
      }
}


/*
 P_MODE
*/

Public Bool fis_p_mode(object)
     PseudoObject* object;
{
    return object == NULL || object->tag == P_MODE;
}

Public void decompose_p_mode(p_mode, p_mode_data) 
     PMode* p_mode;
     PModeData* p_mode_data; 
{ 
    if (p_mode == NULL) 
      *p_mode_data = NULL;
    else if (is_p_mode_non_NULL(p_mode)) 
      *p_mode_data = p_mode->p_mode_data;
    else
      type_error(p_mode,"P_MODE","decompose_p_mode"); 
}

Public PModeData read_p_mode_data(p_mode)
     PMode* p_mode;
{
    if (p_mode == NULL)
      return NULL;
    else if (is_p_mode_non_NULL(p_mode))
      return p_mode->p_mode_data;
    else
      type_error(p_mode, "P_MODE", "read_p_mode_data");
}
      
Public PMode* create_p_mode(p_mode_data)
     PModeData p_mode_data;
{
    PMode* p_mode = (PMode*)dotsrc_malloc(sizeof(PMode));
    p_mode->tag = P_MODE;
    p_mode->p_mode_data = p_mode_data;
    return p_mode;
}

Public PMode* copy_p_mode(p_mode)
     PMode* p_mode;
{
    if (p_mode == NULL) 
      return NULL;
    else if (is_p_mode_non_NULL(p_mode)) {
	PMode* copy = (PMode*)dotsrc_malloc(sizeof(PMode));
	copy->tag = p_mode->tag;
        copy->p_mode_data = p_mode->p_mode_data;
	return copy;
    }
    else
      type_error(p_mode, "P_MODE","copy_p_mode");
}
   
Public PMode* set_p_mode(p_mode, p_mode_data)
     PMode* p_mode;
     PModeData p_mode_data;
{
    if (p_mode == NULL)
      write_through_NULL("set_p_mode");
    else if (! is_p_mode_non_NULL(p_mode))
      type_error(p_mode, "P_MODE", "set_p_mode");
    else {
      p_mode->p_mode_data = p_mode_data;
      return p_mode;
    }
}

Public PMode* write_p_mode_data(p_mode, p_mode_data)
     PMode* p_mode;
     PModeData p_mode_data;
{
    if (p_mode == NULL)
      write_through_NULL("write_p_mode_data");
    else if (! is_p_mode_non_NULL(p_mode))
      type_error(p_mode, "P_MODE", "write_p_mode_data");
    else {
      p_mode->p_mode_data = p_mode_data;
      return p_mode;
    }
}

Public PMode* new_p_mode()
{
    PMode* p_mode = (PMode*)dotsrc_malloc(sizeof(PMode));
    p_mode->tag = P_MODE;
    p_mode->p_mode_data = NULL;
    return p_mode;
}

Public void delete_p_mode(p_mode)
     PMode* p_mode;
{
    if (p_mode != NULL)
      if (is_p_mode_non_NULL(p_mode))
	dotsrc_free((char*)p_mode);
      else
	type_error(p_mode, "P_MODE", "delete_p_mode");
}

/*
 A_MODE
*/
Public Bool fis_a_mode(object)
     PseudoObject* object;
{
    return object == NULL || object->tag == A_MODE;
}

Public void decompose_a_mode(a_mode, a_mode_data) 
     AMode* a_mode;
     AModeData* a_mode_data; 
{ 
    if (a_mode == NULL) 
      *a_mode_data = NULL;
    else if (is_a_mode_non_NULL(a_mode)) 
      *a_mode_data = a_mode->a_mode_data;
    else
      type_error(a_mode,"A_MODE","decompose_a_mode"); 
}

Public AModeData read_a_mode_data(a_mode)
     AMode* a_mode;
{
    if (a_mode == NULL)
      return NULL;
    else if (is_a_mode_non_NULL(a_mode))
      return a_mode->a_mode_data;
    else
      type_error(a_mode, "A_MODE", "read_a_mode_data");
}
      
Public AMode* create_a_mode(a_mode_data)
     AModeData a_mode_data;
{
    AMode* a_mode = (AMode*)dotsrc_malloc(sizeof(AMode));
    a_mode->tag = A_MODE;
    a_mode->a_mode_data = a_mode_data;
    return a_mode;
}

Public AMode* copy_a_mode(a_mode)
     AMode* a_mode;
{
    if (a_mode == NULL) 
      return NULL;
    else if (is_a_mode_non_NULL(a_mode)) {
	AMode* copy = (AMode*)dotsrc_malloc(sizeof(AMode));
	copy->tag = a_mode->tag;
        copy->a_mode_data = a_mode->a_mode_data;
	return copy;
    }
    else
      type_error(a_mode, "A_MODE","copy_a_mode");
}
   
Public AMode* set_a_mode(a_mode, a_mode_data)
     AMode* a_mode;
     AModeData a_mode_data;
{
    if (a_mode == NULL)
      write_through_NULL("set_a_mode");
    else if (! is_a_mode_non_NULL(a_mode))
      type_error(a_mode, "A_MODE", "set_a_mode");
    else {
      a_mode->a_mode_data = a_mode_data;
      return a_mode;
    }
}

Public AMode* write_a_mode_data(a_mode, a_mode_data)
     AMode* a_mode;
     AModeData a_mode_data;
{
    if (a_mode == NULL)
      write_through_NULL("write_a_mode_data");
    else if (! is_a_mode_non_NULL(a_mode))
      type_error(a_mode, "A_MODE", "write_a_mode_data");
    else {
      a_mode->a_mode_data = a_mode_data;
      return a_mode;
    }
}

Public AMode* new_a_mode()
{
    AMode* a_mode = (AMode*)dotsrc_malloc(sizeof(AMode));
    a_mode->tag = A_MODE;
    a_mode->a_mode_data = NULL;
    return a_mode;
}

Public void delete_a_mode(a_mode)
     AMode* a_mode;
{
    if (a_mode != NULL)
      if (is_a_mode_non_NULL(a_mode))
	dotsrc_free((char*)a_mode);
      else
	type_error(a_mode, "A_MODE", "delete_a_mode");
}


/*
 I_MODE
*/
Public Bool fis_i_mode(object)
     PseudoObject* object;
{
    return object == NULL || object->tag == I_MODE;
}

Public void decompose_i_mode(i_mode, i_mode_data) 
     IMode* i_mode;
     IModeData* i_mode_data; 
{ 
    if (i_mode == NULL) 
      *i_mode_data = NULL;
    else if (is_i_mode_non_NULL(i_mode)) 
      *i_mode_data = i_mode->i_mode_data;
    else
      type_error(i_mode,"I_MODE","decompose_i_mode"); 
}

Public IModeData read_i_mode_data(i_mode)
     IMode* i_mode;
{
    if (i_mode == NULL)
      return NULL;
    else if (is_i_mode_non_NULL(i_mode))
      return i_mode->i_mode_data;
    else
      type_error(i_mode, "I_MODE", "read_i_mode_data");
}
      
Public IMode* create_i_mode(i_mode_data)
     IModeData i_mode_data;
{
    IMode* i_mode = (IMode*)dotsrc_malloc(sizeof(IMode));
    i_mode->tag = I_MODE;
    i_mode->i_mode_data = i_mode_data;
    return i_mode;
}

Public IMode* copy_i_mode(i_mode)
     IMode* i_mode;
{
    if (i_mode == NULL) 
      return NULL;
    else if (is_i_mode_non_NULL(i_mode)) {
        IMode* copy = (IMode*)dotsrc_malloc(sizeof(IMode));
	copy->tag = i_mode->tag;
        copy->i_mode_data = i_mode->i_mode_data;
	return copy;
    }
    else
      type_error(i_mode, "I_MODE","copy_i_mode");
}
   
Public IMode* set_i_mode(i_mode, i_mode_data)
     IMode* i_mode;
     IModeData i_mode_data;
{
    if (i_mode == NULL)
      write_through_NULL("set_i_mode");
    else if (! is_i_mode_non_NULL(i_mode))
      type_error(i_mode, "I_MODE", "set_i_mode");
    else {
      i_mode->i_mode_data = i_mode_data;
      return i_mode;
    }
}

Public IMode* write_i_mode_data(i_mode, i_mode_data)
     IMode* i_mode;
     IModeData i_mode_data;
{
    if (i_mode == NULL)
      write_through_NULL("write_i_mode_data");
    else if (! is_i_mode_non_NULL(i_mode))
      type_error(i_mode, "I_MODE", "write_i_mode_data");
    else {
      i_mode->i_mode_data = i_mode_data;
      return i_mode;
    }
}

Public IMode* new_i_mode()
{
    IMode* i_mode = (IMode*)dotsrc_malloc(sizeof(IMode));
    i_mode->tag = I_MODE;
    i_mode->i_mode_data = NULL;
    return i_mode;
}

Public void delete_i_mode(i_mode)
     IMode* i_mode;
{
    if (i_mode != NULL)
      if (is_i_mode_non_NULL(i_mode))
	dotsrc_free((char*)i_mode);
      else
	type_error(i_mode, "I_MODE", "delete_i_mode");
}


/*
 M_MODE
*/

Public Bool fis_m_mode(object)
     PseudoObject* object;
{
    return object == NULL || object->tag == M_MODE;
}

Public void decompose_m_mode(m_mode, m_mode_data) 
     MMode* m_mode;
     MModeData* m_mode_data; 
{ 
    if (m_mode == NULL) 
      *m_mode_data = NULL;
    else if (is_m_mode_non_NULL(m_mode)) 
      *m_mode_data = m_mode->m_mode_data;
    else
      type_error(m_mode,"M_MODE","decompose_m_mode"); 
}

Public MModeData read_m_mode_data(m_mode)
     MMode* m_mode;
{
    if (m_mode == NULL)
      return NULL;
    else if (is_m_mode_non_NULL(m_mode))
      return m_mode->m_mode_data;
    else
      type_error(m_mode, "M_MODE", "read_m_mode_data");
}
      
Public MMode* create_m_mode(m_mode_data)
     MModeData m_mode_data;
{
    MMode* m_mode = (MMode*)dotsrc_malloc(sizeof(MMode));
    m_mode->tag = M_MODE;
    m_mode->m_mode_data = m_mode_data;
    return m_mode;
}

Public MMode* copy_m_mode(m_mode)
     MMode* m_mode;
{
    if (m_mode == NULL) 
      return NULL;
    else if (is_m_mode_non_NULL(m_mode)) {
        MMode* copy = (MMode*)dotsrc_malloc(sizeof(MMode));
	copy->tag = m_mode->tag;
        copy->m_mode_data = m_mode->m_mode_data;
	return copy;
    }
    else
      type_error(m_mode, "M_MODE","copy_m_mode");
}
   
Public MMode* set_m_mode(m_mode, m_mode_data)
     MMode* m_mode;
     MModeData m_mode_data;
{
    if (m_mode == NULL)
      write_through_NULL("set_m_mode");
    else if (! is_m_mode_non_NULL(m_mode))
      type_error(m_mode, "M_MODE", "set_m_mode");
    else {
      m_mode->m_mode_data = m_mode_data;
      return m_mode;
    }
}

Public MMode* write_m_mode_data(m_mode, m_mode_data)
     MMode* m_mode;
     MModeData m_mode_data;
{
    if (m_mode == NULL)
      write_through_NULL("write_m_mode_data");
    else if (! is_m_mode_non_NULL(m_mode))
      type_error(m_mode, "M_MODE", "write_m_mode_data");
    else {
      m_mode->m_mode_data = m_mode_data;
      return m_mode;
    }
}

Public MMode* new_m_mode()
{
    MMode* m_mode = (MMode*)dotsrc_malloc(sizeof(MMode));
    m_mode->tag = M_MODE;
    m_mode->m_mode_data = NULL;
    return m_mode;
}

Public void delete_m_mode(m_mode)
     MMode* m_mode;
{
    if (m_mode != NULL)
      if (is_m_mode_non_NULL(m_mode))
	dotsrc_free((char*)m_mode);
      else
	type_error(m_mode, "M_MODE", "delete_m_mode");
}


/*
 E_MODE
*/

Public Bool fis_e_mode(object)
     PseudoObject* object;
{
    return object == NULL || object->tag == E_MODE;
}

Public void decompose_e_mode(e_mode, e_mode_data) 
     EMode* e_mode;
     EModeData* e_mode_data; 
{ 
    if (e_mode == NULL) 
      *e_mode_data = NULL;
    else if (is_e_mode_non_NULL(e_mode)) 
      *e_mode_data = e_mode->e_mode_data;
    else
      type_error(e_mode,"E_MODE","decompose_e_mode"); 
}

Public EModeData read_e_mode_data(e_mode)
     EMode* e_mode;
{
    if (e_mode == NULL)
      return NULL;
    else if (is_e_mode_non_NULL(e_mode))
      return e_mode->e_mode_data;
    else
      type_error(e_mode, "E_MODE", "read_e_mode_data");
}
      
Public EMode* create_e_mode(e_mode_data)
     EModeData e_mode_data;
{
    EMode* e_mode = (EMode*)dotsrc_malloc(sizeof(EMode));
    e_mode->tag = E_MODE;
    e_mode->e_mode_data = e_mode_data;
    return e_mode;
}

Public EMode* copy_e_mode(e_mode)
     EMode* e_mode;
{
    if (e_mode == NULL) 
      return NULL;
    else if (is_e_mode_non_NULL(e_mode)) {
        EMode* copy = (EMode*)dotsrc_malloc(sizeof(EMode));
	copy->tag = e_mode->tag;
        copy->e_mode_data = e_mode->e_mode_data;
	return copy;
    }
    else
      type_error(e_mode, "E_MODE","copy_e_mode");
}
   
Public EMode* set_e_mode(e_mode, e_mode_data)
     EMode* e_mode;
     EModeData e_mode_data;
{
    if (e_mode == NULL)
      write_through_NULL("set_e_mode");
    else if (! is_e_mode_non_NULL(e_mode))
      type_error(e_mode, "E_MODE", "set_e_mode");
    else {
      e_mode->e_mode_data = e_mode_data;
      return e_mode;
    }
}

Public EMode* write_e_mode_data(e_mode, e_mode_data)
     EMode* e_mode;
     EModeData e_mode_data;
{
    if (e_mode == NULL)
      write_through_NULL("write_e_mode_data");
    else if (! is_e_mode_non_NULL(e_mode))
      type_error(e_mode, "E_MODE", "write_e_mode_data");
    else {
      e_mode->e_mode_data = e_mode_data;
      return e_mode;
    }
}

Public EMode* new_e_mode()
{
    EMode* e_mode = (EMode*)dotsrc_malloc(sizeof(EMode));
    e_mode->tag = E_MODE;
    e_mode->e_mode_data = NULL;
    return e_mode;
}

Public void delete_e_mode(e_mode)
     EMode* e_mode;
{
    if (e_mode != NULL)
      if (is_e_mode_non_NULL(e_mode))
	dotsrc_free((char*)e_mode);
      else
	type_error(e_mode, "E_MODE", "delete_e_mode");
}




/*
 ANSWER (have ObjList)
*/

Public Bool fis_answer(object)
     PseudoObject* object;
{
    return object == NULL || object->tag == ANSWER;
}

Public void decompose_answer(answer, answer_elements)
     Answer* answer;
     ObjList** answer_elements;
{
    if (answer == NULL) 
      *answer_elements = NULL;
    else if (is_answer_non_NULL(answer)) 
      *answer_elements = answer->answer_elements;
    else
      type_error(answer, "ANSWER", "decompose_answer");
}

Public ObjList* read_answer_elements(answer)
     Answer* answer;
{
    if (answer == NULL)
      return NULL;
    else if (is_answer_non_NULL(answer))
      return answer->answer_elements;
    else
      type_error(answer, "ANSWER", "read_answer_elements");
}
      
Public Answer* create_answer(answer_elements)
     ObjList* answer_elements;
{
    Answer* answer = (Answer*)dotsrc_malloc(sizeof(Answer));
    answer->tag = ANSWER;
    answer->answer_elements = answer_elements;
    return answer;
}

Public Answer* copy_answer(answer)
     Answer* answer;
{
    if (answer == NULL) 
      return NULL;
    else if (is_answer_non_NULL(answer)) {
	Answer* copy = (Answer*)dotsrc_malloc(sizeof(Answer));
	copy->tag = answer->tag;
        copy->answer_elements = copy_obj_list(answer->answer_elements);
	return copy;
    }
    else
      type_error(answer, "ANSWER", "copy_answer");
}
   
Public Answer* set_answer(answer, answer_elements)
     Answer* answer;
     ObjList* answer_elements;
{
    if (answer == NULL)
      write_through_NULL("set_answer");
    else if (! is_answer_non_NULL(answer))
      type_error(answer, "ANSWER", "set_answer");
    else {
        answer->answer_elements = answer_elements;
        return answer;
    }
}

Public Answer* write_answer_elements(answer, answer_elements)
     Answer* answer;
     ObjList* answer_elements;
{
    if (answer == NULL)
      write_through_NULL("write_answer_elements");
    else if (! is_answer_non_NULL(answer))
      type_error(answer, "ANSWER", "write_answer_elements");
    else {
        answer->answer_elements = answer_elements;
        return answer;
    }
}


Public Answer* new_answer()
{
    Answer* answer = (Answer*)dotsrc_malloc(sizeof(Answer));
    answer->tag = ANSWER;
    answer->answer_elements = NULL;
    return answer;
}

Public void delete_answer(answer)
     Answer* answer;
{
    if (answer != NULL)
      if (is_answer_non_NULL(answer)) {
	  delete_obj_list(answer->answer_elements);
	  dotsrc_free((char*)answer);
      }
      else
	type_error(answer, "ANSWER", "delete_answer");
}

Public Answer* insert_answer_elements(answer, answer_elements)
     Answer* answer;
     ObjList* answer_elements;
{
    if (answer == NULL)
      write_through_NULL("insert_answer_elements");
    else if (is_answer_non_NULL(answer))
      if (answer->answer_elements == NULL) {
	  answer->answer_elements = answer_elements;
	  return answer;
      }
      else {
	  insert_list_to_obj_list(answer->answer_elements, answer_elements);
	  return answer;
      }
    else
      type_error(answer, "ANSWER", "insert_answer_elements");
}

Public Answer* add_answer_elements(answer, answer_elements)
     Answer* answer;
     ObjList* answer_elements;
{
    if (answer == NULL)
      write_through_NULL("add_answer_elements");
    else if (is_answer_non_NULL(answer))
      if (answer->answer_elements == NULL) {
	  answer->answer_elements = answer_elements;
	  return answer;
      }
      else {
	  concat_list_to_obj_list(answer->answer_elements, answer_elements);
	  return answer;
      }
    else
      type_error(answer, "ANSWER", "add_answer_elements");
}

Public AnswerElement* car_of_answer_elements(answer)
     Answer* answer;
{
    if (answer == NULL || answer->answer_elements == NULL)
      return NULL;
    else
      return (AnswerElement*)
	extract_first_list_element(answer->answer_elements);
}


/*
 ANSWER_ELEMENT  (have ObjList)
*/

Public Bool fis_answer_element(object)
     PseudoObject* object;
{
    return object == NULL || object->tag == ANSWER_ELEMENT;
}

Public void decompose_answer_element(answer_element, dot_cnstrs, var_cnstrs,
				       anse_explanation)
     AnswerElement* answer_element;
     ObjList** dot_cnstrs;
     ObjList** var_cnstrs;
     AnseExplanation** anse_explanation;
{
    if (answer_element == NULL) {
        *dot_cnstrs = NULL;
	*var_cnstrs = NULL;
	*anse_explanation = NULL;
    }
    else if (is_answer_element_non_NULL(answer_element)) {
        *dot_cnstrs = answer_element->dot_cnstrs;
	*var_cnstrs = answer_element->var_cnstrs;
	*anse_explanation = answer_element->anse_explanation;
    }
    else
      type_error(answer_element, "ANSWER_ELEMENT", "decompose_answer_element");
}

Public ObjList* read_dot_cnstrs(answer_element)
     AnswerElement* answer_element;
{
    if (answer_element == NULL)
      return NULL;
    else if (is_answer_element_non_NULL(answer_element))
      return answer_element->dot_cnstrs;
    else
      type_error(answer_element, "ANSWER_ELEMENT", "read_dot_cnstrs");
}
      
Public ObjList* read_var_cnstrs(answer_element)
     AnswerElement* answer_element;
{
    if (answer_element == NULL)
      return NULL;
    else if (is_answer_element_non_NULL(answer_element))
      return answer_element->var_cnstrs;
    else
      type_error(answer_element, "ANSWER_ELEMENT", "read_var_cnstrs");
}

Public AnseExplanation* read_anse_explanation(answer_element)
     AnswerElement* answer_element;
{
    if (answer_element == NULL)
      return NULL;
    else if (is_answer_element_non_NULL(answer_element))
      return answer_element->anse_explanation;
    else
      type_error(answer_element, "ANSWER_ELEMENT", "read_anse_explanation");
}
      
Public AnswerElement* create_answer_element(dot_cnstrs, var_cnstrs, 
					      anse_explanation)
     ObjList* dot_cnstrs;
     ObjList* var_cnstrs;
     AnseExplanation* anse_explanation;
{
    AnswerElement* answer_element = 
      (AnswerElement*)dotsrc_malloc(sizeof(AnswerElement));
    answer_element->tag = ANSWER_ELEMENT;
    answer_element->dot_cnstrs = dot_cnstrs;
    answer_element->var_cnstrs = var_cnstrs;
    answer_element->anse_explanation = anse_explanation;
    return answer_element;
}

Public AnswerElement* copy_answer_element(answer_element)
     AnswerElement* answer_element;
{
    if (answer_element == NULL) 
      return NULL;
    else if (is_answer_element_non_NULL(answer_element)) {
        AnswerElement* copy = 
	  (AnswerElement*)dotsrc_malloc(sizeof(AnswerElement));
	copy->tag = answer_element->tag;
	copy->dot_cnstrs = copy_obj_list(answer_element->dot_cnstrs);
	copy->var_cnstrs = copy_obj_list(answer_element->var_cnstrs);
	copy->anse_explanation = 
	  copy_anse_explanation(answer_element->anse_explanation);
	return copy;
    }
    else
      type_error(answer_element, "ANSWER_ELEMENT", "copy_answer_element");
}
   
Public AnswerElement* set_answer_element(answer_element, dot_cnstrs, 
					   var_cnstrs, anse_explanation)
     AnswerElement* answer_element;
     ObjList* dot_cnstrs;
     ObjList* var_cnstrs;
     AnseExplanation* anse_explanation;
{
    if (answer_element == NULL)
      write_through_NULL("set_answer_element");
    else if (! is_answer_element_non_NULL(answer_element))
      type_error(answer_element, "ANSWER_ELEMENT", "set_answer_element");
    else {
	answer_element->dot_cnstrs = dot_cnstrs;
	answer_element->var_cnstrs = var_cnstrs;
	answer_element->anse_explanation = anse_explanation;
	return answer_element;
    }
}

Public AnswerElement* write_dot_cnstrs(answer_element, dot_cnstrs)
     AnswerElement* answer_element;
     ObjList* dot_cnstrs;
{
    if (answer_element == NULL)
      write_through_NULL("write_dot_cnstrs");
    else if (! is_answer_element_non_NULL(answer_element))
      type_error(answer_element, "ANSWER_ELEMENT", "write_dot_cnstrs");
    else {
        answer_element->dot_cnstrs = dot_cnstrs;
	return answer_element;
    }
}

Public AnswerElement* write_var_cnstrs(answer_element, var_cnstrs)
     AnswerElement* answer_element;
     ObjList* var_cnstrs;
{
    if (answer_element == NULL)
      write_through_NULL("write_var_cnstrs");
    else if (! is_answer_element_non_NULL(answer_element))
      type_error(answer_element, "ANSWER_ELEMENT", "write_var_cnstrs");
    else {
        answer_element->var_cnstrs = var_cnstrs;
	return answer_element;
    }
}

Public AnswerElement* write_anse_explanation(answer_element, anse_explanation)
     AnswerElement* answer_element;
     AnseExplanation* anse_explanation;
{
    if (answer_element == NULL)
      write_through_NULL("write_anse_explanation");
    else if (! is_answer_element_non_NULL(answer_element))
      type_error(answer_element, "ANSWER_ELEMENT", "write_anse_explanation");
    else {
        answer_element->anse_explanation = anse_explanation;
	return answer_element;
    }
}

Public AnswerElement* new_answer_element()
{
    AnswerElement* answer_element = 
      (AnswerElement*)dotsrc_malloc(sizeof(AnswerElement));
    answer_element->tag = ANSWER_ELEMENT;
    answer_element->dot_cnstrs = NULL;
    answer_element->var_cnstrs = NULL;
    answer_element->anse_explanation = NULL;
    return answer_element;
}

Public void delete_answer_element(answer_element)
     AnswerElement* answer_element;
{
    if (answer_element != NULL)
      if (is_answer_element_non_NULL(answer_element)) {
	  delete_obj_list(answer_element->dot_cnstrs);
	  delete_obj_list(answer_element->var_cnstrs);
	  delete_anse_explanation(answer_element->anse_explanation);
	  dotsrc_free((char*)answer_element);
      }	  
      else
	type_error(answer_element, "ANSWER_ELEMENT", "delete_answer_element");
}

Public AnswerElement* insert_dot_cnstrs(answer_element, dot_cnstrs)
     AnswerElement* answer_element;
     ObjList* dot_cnstrs;
{
    if (answer_element == NULL)
      write_through_NULL("insert_dot_cnstrs");
    else if (is_answer_element_non_NULL(answer_element))
      if (answer_element->dot_cnstrs == NULL) {
	  answer_element->dot_cnstrs = dot_cnstrs;
	  return answer_element;
      }
      else {
	  insert_list_to_obj_list(answer_element->dot_cnstrs, dot_cnstrs);
	  return answer_element;
      }
    else
      type_error(answer_element, "ANSWER_ELEMENT", "insert_dot_cnstrs");
}

Public AnswerElement* insert_var_cnstrs(answer_element, var_cnstrs)
     AnswerElement* answer_element;
     ObjList* var_cnstrs;
{
    if (answer_element == NULL)
      write_through_NULL("insert_var_cnstrs");
    else if (is_answer_element_non_NULL(answer_element))
      if (answer_element->var_cnstrs == NULL) {
	  answer_element->var_cnstrs = var_cnstrs;
	  return answer_element;
      }
      else {
	  insert_list_to_obj_list(answer_element->var_cnstrs, var_cnstrs);
	  return answer_element;
      }
    else
      type_error(answer_element, "ANSWER_ELEMENT", "insert_var_cnstrs");
}

Public AnswerElement* add_dot_cnstrs(answer_element, dot_cnstrs)
     AnswerElement* answer_element;
     ObjList* dot_cnstrs;
{
    if (answer_element == NULL)
      write_through_NULL("add_dot_cnstrs");
    else if (is_answer_element_non_NULL(answer_element))
      if (answer_element->dot_cnstrs == NULL) {
	  answer_element->dot_cnstrs = dot_cnstrs;
	  return answer_element;
      }
      else {
	  concat_list_to_obj_list(answer_element->dot_cnstrs, dot_cnstrs);
	  return answer_element;
      }
    else
      type_error(answer_element, "ANSWER_ELEMENT", "add_dot_cnstrs");
}

Public AnswerElement* add_var_cnstrs(answer_element, var_cnstrs)
     AnswerElement* answer_element;
     ObjList* var_cnstrs;
{
    if (answer_element == NULL)
      write_through_NULL("add_var_cnstrs");
    else if (is_answer_element_non_NULL(answer_element))
      if (answer_element->var_cnstrs == NULL) {
	  answer_element->var_cnstrs = var_cnstrs;
	  return answer_element;
      }
      else {
	  concat_list_to_obj_list(answer_element->var_cnstrs, var_cnstrs);
	  return answer_element;
      }
    else
      type_error(answer_element, "ANSWER_ELEMENT", "add_var_cnstrs");
}


Public DotCnstr* car_of_dot_cnstrs(answer_element)
     AnswerElement* answer_element;
{
    if (answer_element == NULL || answer_element->dot_cnstrs == NULL)
      return NULL;
    else
      return (DotCnstr*)extract_first_list_element(answer_element->dot_cnstrs);
}


Public VarCnstr* car_of_var_cnstrs(answer_element)
     AnswerElement* answer_element;
{
    if (answer_element == NULL || answer_element->var_cnstrs == NULL)
      return NULL;
    else
      return (VarCnstr*)extract_first_list_element(answer_element->var_cnstrs);
}


/*
 ANSE_EXPLANATION (have ObjList)
*/

Public Bool fis_anse_explanation(object)
     PseudoObject* object;
{
    return object == NULL || object->tag == ANSE_EXPLANATION;
}

Public void decompose_anse_explanation(anse_explanation, explanation, 
				       rir_pairs)
     AnseExplanation* anse_explanation;
     Explanation** explanation;
     ObjList** rir_pairs;
{
    if (anse_explanation == NULL) {
        *explanation = NULL;
	*rir_pairs = NULL;
    }
    else if (is_anse_explanation_non_NULL(anse_explanation)) {
        *explanation = anse_explanation->explanation;
	*rir_pairs = anse_explanation->rir_pairs;
    }
    else
      type_error(anse_explanation, "ANSE_EXPLANATION", 
		 "decompose_anse_explanation");
}

Public Explanation* read_explanation_inAnseExplanation(anse_explanation)
     AnseExplanation* anse_explanation;
{
    if (anse_explanation == NULL)
      return NULL;
    else if (is_anse_explanation_non_NULL(anse_explanation))
      return anse_explanation->explanation;
    else
      type_error(anse_explanation, "ANSE_EXPLANATION", 
		 "read_explanation_inAnseExplanation");
}

Public ObjList* read_rir_pairs(anse_explanation)
     AnseExplanation* anse_explanation;
{
    if (anse_explanation == NULL)
      return NULL;
    else if (is_anse_explanation_non_NULL(anse_explanation))
      return anse_explanation->rir_pairs;
    else
      type_error(anse_explanation, "ANSE_EXPLANATION", "read_rir_pairs");
}

Public AnseExplanation* create_anse_explanation(explanation, rir_pairs)
     Explanation* explanation;
     ObjList* rir_pairs;
{
    AnseExplanation* anse_explanation = 
      (AnseExplanation*)dotsrc_malloc(sizeof(AnseExplanation));
    anse_explanation->tag = ANSE_EXPLANATION;
    anse_explanation->explanation = explanation;
    anse_explanation->rir_pairs = rir_pairs;
    return anse_explanation;
}

Public AnseExplanation* copy_anse_explanation(anse_explanation)
     AnseExplanation* anse_explanation;
{
    if (anse_explanation == NULL) 
      return NULL;
    else if (is_anse_explanation_non_NULL(anse_explanation)) {
        AnseExplanation* copy = 
	  (AnseExplanation*)dotsrc_malloc(sizeof(AnseExplanation));
	copy->tag = anse_explanation->tag;
	copy->explanation = copy_explanation(anse_explanation->explanation);
	copy->rir_pairs = copy_obj_list(anse_explanation->rir_pairs);
	return copy;
    }
    else
      type_error(anse_explanation, "ANSE_EXPLANATION", 
		 "copy_anse_explanation");
}
   
Public AnseExplanation* set_anse_explanation
                          (anse_explanation, explanation, rir_pairs)
     AnseExplanation* anse_explanation;
     Explanation* explanation;
     ObjList* rir_pairs;
{
    if (anse_explanation == NULL)
      write_through_NULL("set_anse_explanation");
    else if (! is_anse_explanation_non_NULL(anse_explanation))
      type_error(anse_explanation, "ANSE_EXPLANATION", "set_anse_explanation");
    else {
        anse_explanation->explanation = explanation;
	anse_explanation->rir_pairs = rir_pairs;
	return anse_explanation;
    }
}

Public AnseExplanation* 
         write_explanation_inAnseExplanation(anse_explanation, explanation)
     AnseExplanation* anse_explanation;
     Explanation* explanation;
{
    if (anse_explanation == NULL)
      write_through_NULL("write_explanation_inAnseExplanation");
    else if (! is_anse_explanation_non_NULL(anse_explanation))
      type_error(anse_explanation, "ANSE_EXPLANATION", 
		 "write_explanation_inAnseExplanation");
    else {
        anse_explanation->explanation = explanation;
	return anse_explanation;
    }
}

Public AnseExplanation* write_rir_pairs(anse_explanation, rir_pairs)
     AnseExplanation* anse_explanation;
     ObjList* rir_pairs;
{
    if (anse_explanation == NULL)
      write_through_NULL("write_rir_pairs");
    else if (! is_anse_explanation_non_NULL(anse_explanation))
      type_error(anse_explanation, "ANSE_EXPLANATION", "write_rir_pairs");
    else {
        anse_explanation->rir_pairs = rir_pairs;
	return anse_explanation;
    }
}

Public AnseExplanation* new_anse_explanation()
{
    AnseExplanation* anse_explanation = 
      (AnseExplanation*)dotsrc_malloc(sizeof(AnseExplanation));
    anse_explanation->tag = ANSE_EXPLANATION;
    anse_explanation->explanation = NULL;
    anse_explanation->rir_pairs = NULL;
    return anse_explanation;
}

Public void delete_anse_explanation(anse_explanation)
     AnseExplanation* anse_explanation;
{
    if (anse_explanation != NULL)
      if (is_anse_explanation_non_NULL(anse_explanation)) {
	  delete_explanation(anse_explanation->explanation);
	  delete_obj_list(anse_explanation->rir_pairs);
	  dotsrc_free((char*)anse_explanation);
      }
      else
	type_error(anse_explanation, "ANSE_EXPLANATION", 
		   "delete_anse_explanation");
}

Public AnseExplanation* insert_rir_pairs(anse_explanation, rir_pairs)
     AnseExplanation* anse_explanation;
     ObjList* rir_pairs;
{
    if (anse_explanation == NULL)
      write_through_NULL("insert_rir_pairs");
    else if (is_anse_explanation_non_NULL(anse_explanation))
      if (anse_explanation->rir_pairs == NULL) {
	  anse_explanation->rir_pairs = rir_pairs;
	  return anse_explanation;
      }
      else {
	  insert_list_to_obj_list(anse_explanation->rir_pairs, rir_pairs);
	  return anse_explanation;
      }
    else
      type_error(anse_explanation, "ANSE_EXPLANATION", "insert_rir_pairs");
}

Public AnseExplanation* add_rir_pairs(anse_explanation, rir_pairs)
     AnseExplanation* anse_explanation;
     ObjList* rir_pairs;
{
    if (anse_explanation == NULL)
      write_through_NULL("add_rir_pairs");
    else if (is_anse_explanation_non_NULL(anse_explanation))
      if (anse_explanation->rir_pairs == NULL) {
	  anse_explanation->rir_pairs = rir_pairs;
	  return anse_explanation;
      }
      else {
	  concat_list_to_obj_list(anse_explanation->rir_pairs, rir_pairs);
	  return anse_explanation;
      }
    else
      type_error(anse_explanation, "ANSE_EXPLANATION", "add_rir_pairs");
}

Public RirPair* car_of_rir_pairs(anse_explanation)
     AnseExplanation* anse_explanation;
{
    if (anse_explanation == NULL || anse_explanation->rir_pairs == NULL)
      return NULL;
    else
      return (RirPair*)
	       extract_first_list_element(anse_explanation->rir_pairs);
}


/*
 RIR_PAIR
*/

Public Bool fis_rir_pair(object)
     PseudoObject* object;
{
    return object == NULL || object->tag == RIR_PAIR;
}

Public void decompose_rir_pair(rir_pair, rule_id, rule)
     RirPair* rir_pair;
     RuleId** rule_id;
     Rule** rule;
{
    if (rir_pair == NULL) {
        *rule_id = NULL;
	*rule = NULL;
    }
    else if (is_rir_pair_non_NULL(rir_pair)) {
        *rule_id = rir_pair->rule_id;
	*rule = rir_pair->rule;
    }
    else
      type_error(rir_pair, "RIR_PAIR", "decompose_rir_pair");
}

Public RuleId* read_rule_id_inRirPair(rir_pair)
     RirPair* rir_pair;
{
    if (rir_pair == NULL)
      return NULL;
    else if (is_rir_pair_non_NULL(rir_pair))
      return rir_pair->rule_id;
    else
      type_error(rir_pair, "RIR_PAIR", "read_rule_id_inRirPair");
}

Public Rule* read_rule(rir_pair)
     RirPair* rir_pair;
{
    if (rir_pair == NULL)
      return NULL;
    else if (is_rir_pair_non_NULL(rir_pair))
      return rir_pair->rule;
    else
      type_error(rir_pair, "RIR_PAIR", "read_rule");
}

Public RirPair* create_rir_pair(rule_id, rule)
     RuleId* rule_id;
     Rule* rule;
{
    RirPair* rir_pair = (RirPair*)dotsrc_malloc(sizeof(RirPair));
    rir_pair->tag = RIR_PAIR;
    rir_pair->rule_id = rule_id;
    rir_pair->rule = rule;
    return rir_pair;
}

Public RirPair* copy_rir_pair(rir_pair)
     RirPair* rir_pair;
{
    if (rir_pair == NULL) 
      return NULL;
    else if (is_rir_pair_non_NULL(rir_pair)) {
        RirPair* copy = (RirPair*)dotsrc_malloc(sizeof(RirPair));
	copy->tag = rir_pair->tag;
	copy->rule_id = copy_rule_id(rir_pair->rule_id);
	copy->rule = copy_rule(rir_pair->rule);
	return copy;
    }
    else
      type_error(rir_pair, "RIR_PAIR", "copy_rir_pair");
}
   
Public RirPair* set_rir_pair(rir_pair, rule_id, rule)
     RirPair* rir_pair;
     RuleId* rule_id;
     Rule* rule;
{
    if (rir_pair == NULL)
      write_through_NULL("set_rir_pair");
    else if (! is_rir_pair_non_NULL(rir_pair))
      type_error(rir_pair, "RIR_PAIR", "set_rir_pair");
    else {
        rir_pair->rule_id = rule_id;
	rir_pair->rule = rule;
	return rir_pair;
    }
}

Public RirPair* write_rule_id_inRirPair(rir_pair, rule_id)
     RirPair* rir_pair;
     RuleId* rule_id;
{
    if (rir_pair == NULL)
      write_through_NULL("write_rule_id_inRirPair");
    else if (! is_rir_pair_non_NULL(rir_pair))
      type_error(rir_pair, "RIR_PAIR", "write_rule_id_inRirPair");
    else {
        rir_pair->rule_id = rule_id;
	return rir_pair;
    }
}

Public RirPair* write_rule(rir_pair, rule)
     RirPair* rir_pair;
     Rule* rule;
{
    if (rir_pair == NULL)
      write_through_NULL("write_rule");
    else if (! is_rir_pair_non_NULL(rir_pair))
      type_error(rir_pair, "RIR_PAIR", "write_rule");
    else {
        rir_pair->rule = rule;
	return rir_pair;
    }
}

Public RirPair* new_rir_pair()
{
    RirPair* rir_pair = (RirPair*)dotsrc_malloc(sizeof(RirPair));
    rir_pair->tag = RIR_PAIR;
    rir_pair->rule_id = NULL;
    rir_pair->rule = NULL;
    return rir_pair;
}

Public void delete_rir_pair(rir_pair)
     RirPair* rir_pair;
{
    if (rir_pair != NULL)
      if (is_rir_pair_non_NULL(rir_pair)) {
	  delete_rule_id(rir_pair->rule_id);
	  delete_rule(rir_pair->rule);
	  dotsrc_free((char*)rir_pair);
      }
      else
	type_error(rir_pair, "RIR_PAIR", "delete_rir_pair");
}

/*
 DOT_CNSTR
*/

Public Bool fis_dot_cnstr(object)
     PseudoObject* object;
{
    return object == NULL || object->tag == DOT_CNSTR;
}

Public void decompose_dot_cnstr(dot_cnstr, m_id, dot, rel, value)
     DotCnstr* dot_cnstr;
     MId** m_id;
     Dot** dot;
     CnRel* rel;
     Value** value;
{
    if (dot_cnstr == NULL) {
        *m_id = NULL;
	*dot = NULL;
	*rel = NULL;
	*value = NULL;
    }
    else if (is_dot_cnstr_non_NULL(dot_cnstr)) {
        *m_id = dot_cnstr->m_id;
	*dot = dot_cnstr->dot;
	*rel = dot_cnstr->rel;
	*value = dot_cnstr->value;
    }
    else
      type_error(dot_cnstr, "DOT_CNSTR", "decompose_dot_cnstr");
}

Public MId* read_m_id_inDotCnstr(dot_cnstr)
     DotCnstr* dot_cnstr;
{
    if (dot_cnstr == NULL)
      return NULL;
    else if (is_dot_cnstr_non_NULL(dot_cnstr))
      return dot_cnstr->m_id;
    else
      type_error(dot_cnstr, "DOT_CNSTR", "read_m_id_inDotCnstr");
}

Public Dot* read_dot_inDotCnstr(dot_cnstr)
     DotCnstr* dot_cnstr;
{
    if (dot_cnstr == NULL)
      return NULL;
    else if (is_dot_cnstr_non_NULL(dot_cnstr))
      return dot_cnstr->dot;
    else
      type_error(dot_cnstr, "DOT_CNSTR", "read_dot_inDotCnstr");
}

Public CnRel read_rel_inDotCnstr(dot_cnstr)
     DotCnstr* dot_cnstr;
{
    if (dot_cnstr == NULL)
      return NULL;
    else if (is_dot_cnstr_non_NULL(dot_cnstr))
      return dot_cnstr->rel;
    else
      type_error(dot_cnstr, "DOT_CNSTR", "read_rel_inDotCnstr");
}

Public Value* read_value_inDotCnstr(dot_cnstr)
     DotCnstr* dot_cnstr;
{
    if (dot_cnstr == NULL)
      return NULL;
    else if (is_dot_cnstr_non_NULL(dot_cnstr))
      return dot_cnstr->value;
    else
      type_error(dot_cnstr, "DOT_CNSTR", "read_value_inDotCnstr");
}
      
Public DotCnstr* create_dot_cnstr(m_id, dot, rel, value)
     MId* m_id;
     Dot* dot;
     CnRel rel;
     Value* value;
{
    DotCnstr* dot_cnstr = (DotCnstr*)dotsrc_malloc(sizeof(DotCnstr));
    dot_cnstr->tag = DOT_CNSTR;
    dot_cnstr->m_id = m_id;
    dot_cnstr->dot = dot;
    dot_cnstr->rel = rel;
    dot_cnstr->value = value;
    return dot_cnstr;
}

Public DotCnstr* copy_dot_cnstr(dot_cnstr)
     DotCnstr* dot_cnstr;
{
    if (dot_cnstr == NULL) 
      return NULL;
    else if (is_dot_cnstr_non_NULL(dot_cnstr)) {
        DotCnstr* copy = (DotCnstr*)dotsrc_malloc(sizeof(DotCnstr));
	copy->tag = dot_cnstr->tag;
	copy->m_id = copy_o_term(dot_cnstr->m_id);
	copy->dot = copy_dot(dot_cnstr->dot);
	copy->rel = dot_cnstr->rel;
	copy->value = copy_value(dot_cnstr->value);
	return copy;
    }
    else
      type_error(dot_cnstr, "DOT_CNSTR", "copy_dot_cnstr");
}
   
Public DotCnstr* set_dot_cnstr(dot_cnstr, m_id, dot, rel, value)
     DotCnstr* dot_cnstr;
     MId* m_id;
     Dot* dot;
     CnRel rel;
     Value* value;
{
    if (dot_cnstr == NULL)
      write_through_NULL("set_dot_cnstr");
    else if (! is_dot_cnstr_non_NULL(dot_cnstr))
      type_error(dot_cnstr, "DOT_CNSTR", "set_dot_cnstr");
    else {
        dot_cnstr->m_id = m_id;
	dot_cnstr->dot = dot;
	dot_cnstr->rel = rel;
	dot_cnstr->value = value;
	return dot_cnstr;
    }
}

Public DotCnstr* write_m_id_inDotCnstr(dot_cnstr,m_id)
     DotCnstr* dot_cnstr;
     MId* m_id;
{
    if (dot_cnstr == NULL)
      write_through_NULL("write_m_id_inDotCnstr");
    else if (! is_dot_cnstr_non_NULL(dot_cnstr))
      type_error(dot_cnstr, "DOT_CNSTR", "write_m_id_inDotCnstr");
    else {
        dot_cnstr->m_id = m_id;
	return dot_cnstr;
    }
}

Public DotCnstr* write_dot_inDotCnstr(dot_cnstr,dot)
     DotCnstr* dot_cnstr;
     Dot* dot;
{
    if (dot_cnstr == NULL)
      write_through_NULL("write_dot_inDotCnstr");
    else if (! is_dot_cnstr_non_NULL(dot_cnstr))
      type_error(dot_cnstr, "DOT_CNSTR", "write_dot_inDotCnstr");
    else {
        dot_cnstr->dot = dot;
	return dot_cnstr;
    }
}

Public DotCnstr* write_rel_inDotCnstr(dot_cnstr,rel)
     DotCnstr* dot_cnstr;
     CnRel rel;
{
    if (dot_cnstr == NULL)
      write_through_NULL("write_rel_inDotCnstr");
    else if (! is_dot_cnstr_non_NULL(dot_cnstr))
      type_error(dot_cnstr, "DOT_CNSTR", "write_rel_inDotCnstr");
    else {
        dot_cnstr->rel = rel;
	return dot_cnstr;
    }
}

Public DotCnstr* write_value_inDotCnstr(dot_cnstr,value)
     DotCnstr* dot_cnstr;
     Value* value;
{
    if (dot_cnstr == NULL)
      write_through_NULL("write_value_inDotCnstr");
    else if (! is_dot_cnstr_non_NULL(dot_cnstr))
      type_error(dot_cnstr, "DOT_CNSTR", "write_value_inDotCnstr");
    else {
        dot_cnstr->value = value;
	return dot_cnstr;
    }
}

Public DotCnstr* new_dot_cnstr()
{
    DotCnstr* dot_cnstr = (DotCnstr*)dotsrc_malloc(sizeof(DotCnstr));
    dot_cnstr->tag = DOT_CNSTR;
    dot_cnstr->m_id = NULL;
    dot_cnstr->dot = NULL;
    dot_cnstr->rel = NULL;
    dot_cnstr->value = NULL;
    return dot_cnstr;
}

Public void delete_dot_cnstr(dot_cnstr)
     DotCnstr* dot_cnstr;
{
    if (dot_cnstr != NULL)
      if (is_dot_cnstr_non_NULL(dot_cnstr)) {
	  delete_o_term(dot_cnstr->m_id);
	  delete_dot(dot_cnstr->dot);
	  delete_value(dot_cnstr->value);
	  dotsrc_free((char*)dot_cnstr);
      }
      else
	type_error(dot_cnstr, "DOT_CNSTR", "delete_dot_cnstr");
}


/*
 VAR_CNSTR
*/

Public Bool fis_var_cnstr(object)
     PseudoObject* object;
{
    return object == NULL || object->tag == VAR_CNSTR;
}

Public void decompose_var_cnstr(var_cnstr, var, rel, value)
     VarCnstr* var_cnstr;
     Var** var;
     CnRel* rel;
     Value** value;
{
    if (var_cnstr == NULL) {
        *var = NULL;
	*rel = NULL;
	*value = NULL;
    }
    else if (is_var_cnstr_non_NULL(var_cnstr)) {
	*var = var_cnstr->var;
	*rel = var_cnstr->rel;
	*value = var_cnstr->value;
    }
    else
      type_error(var_cnstr, "VAR_CNSTR", "decompose_var_cnstr");
}

Public Var* read_var_inVarCnstr(var_cnstr)
     VarCnstr* var_cnstr;
{
    if (var_cnstr == NULL)
      return NULL;
    else if (is_var_cnstr_non_NULL(var_cnstr))
      return var_cnstr->var;
    else
      type_error(var_cnstr, "VAR_CNSTR", "read_var_inVarCnstr");
}

Public CnRel read_rel_inVarCnstr(var_cnstr)
     VarCnstr* var_cnstr;
{
    if (var_cnstr == NULL)
      return NULL;
    else if (is_var_cnstr_non_NULL(var_cnstr))
      return var_cnstr->rel;
    else
      type_error(var_cnstr, "VAR_CNSTR", "read_rel_inVarCnstr");
}

Public Value* read_value_inVarCnstr(var_cnstr)
     VarCnstr* var_cnstr;
{
    if (var_cnstr == NULL)
      return NULL;
    else if (is_var_cnstr_non_NULL(var_cnstr))
      return var_cnstr->value;
    else
      type_error(var_cnstr, "VAR_CNSTR", "read_value_inVarCnstr");
}
      
Public VarCnstr* create_var_cnstr(var, rel, value)
     Var* var;
     CnRel rel;
     Value* value;
{
    VarCnstr* var_cnstr = (VarCnstr*)dotsrc_malloc(sizeof(VarCnstr));
    var_cnstr->tag = VAR_CNSTR;
    var_cnstr->var = var;
    var_cnstr->rel = rel;
    var_cnstr->value = value;
    return var_cnstr;
}

Public VarCnstr* copy_var_cnstr(var_cnstr)
     VarCnstr* var_cnstr;
{
    if (var_cnstr == NULL) 
      return NULL;
    else if (is_var_cnstr_non_NULL(var_cnstr)) {
        VarCnstr* copy = (VarCnstr*)dotsrc_malloc(sizeof(VarCnstr));
	copy->tag = var_cnstr->tag;
	copy->var = copy_var(var_cnstr->var);
	copy->rel = var_cnstr->rel;
	copy->value = copy_value(var_cnstr->value);
	return copy;
    }
    else
      type_error(var_cnstr, "VAR_CNSTR", "copy_var_cnstr");
}
   
Public VarCnstr* set_var_cnstr(var_cnstr, var, rel, value)
     VarCnstr* var_cnstr;
     Var* var;
     CnRel rel;
     Value* value;
{
    if (var_cnstr == NULL)
      write_through_NULL("set_var_cnstr");
    else if (! is_var_cnstr_non_NULL(var_cnstr))
      type_error(var_cnstr, "VAR_CNSTR", "set_var_cnstr");
    else {
	var_cnstr->var = var;
	var_cnstr->rel = rel;
	var_cnstr->value = value;
	return var_cnstr;
    }
}

Public VarCnstr* write_var_inVarCnstr(var_cnstr,var)
     VarCnstr* var_cnstr;
     Var* var;
{
    if (var_cnstr == NULL)
      write_through_NULL("write_var_inVarCnstr");
    else if (! is_var_cnstr_non_NULL(var_cnstr))
      type_error(var_cnstr, "VAR_CNSTR", "write_var_inVarCnstr");
    else {
        var_cnstr->var = var;
	return var_cnstr;
    }
}

Public VarCnstr* write_rel_inVarCnstr(var_cnstr,rel)
     VarCnstr* var_cnstr;
     CnRel rel;
{
    if (var_cnstr == NULL)
      write_through_NULL("write_rel_inVarCnstr");
    else if (! is_var_cnstr_non_NULL(var_cnstr))
      type_error(var_cnstr, "VAR_CNSTR", "write_rel_inVarCnstr");
    else {
        var_cnstr->rel = rel;
	return var_cnstr;
    }
}

Public VarCnstr* write_value_inVarCnstr(var_cnstr,value)
     VarCnstr* var_cnstr;
     Value* value;
{
    if (var_cnstr == NULL)
      write_through_NULL("write_value_inVarCnstr");
    else if (! is_var_cnstr_non_NULL(var_cnstr))
      type_error(var_cnstr, "VAR_CNSTR", "write_value_inVarCnstr");
    else {
        var_cnstr->value = value;
	return var_cnstr;
    }
}

Public VarCnstr* new_var_cnstr()
{
    VarCnstr* var_cnstr = (VarCnstr*)dotsrc_malloc(sizeof(VarCnstr));
    var_cnstr->tag = VAR_CNSTR;
    var_cnstr->var = NULL;
    var_cnstr->rel = NULL;
    var_cnstr->value = NULL;
    return var_cnstr;
}

Public void delete_var_cnstr(var_cnstr)
     VarCnstr* var_cnstr;
{
    if (var_cnstr != NULL)
      if (is_var_cnstr_non_NULL(var_cnstr)) {
	  delete_var(var_cnstr->var);
	  delete_value(var_cnstr->value);
	  dotsrc_free((char*)var_cnstr);
      }
      else
	type_error(var_cnstr, "VAR_CNSTR", "delete_var_cnstr");
}




