#include "dotsrc.h"
/*******************/
/*   mod_def       */
/*******************/

 Bool   fis_mod_def(object)
  PseudoObject*    object;
{
   return object == NULL || object->tag == MOD_DEF;
 }

/*** decompose ***/
void  decompose_mod_def(mod_def,m_subs)
  ModDef*   mod_def;
  ObjList**  m_subs;
{
   if (mod_def == NULL)
    *m_subs = NULL;
  else if(is_mod_def_non_NULL(mod_def))
   *m_subs = mod_def->m_subs;
  else
   type_error(mod_def,"MOD_DEF","decompose_mod_def"); 
 }

/*** create ***/
  ModDef*  create_mod_def(m_subs)
  ObjList*     m_subs;
{
   ModDef*     mod_def;
 
  mod_def = (ModDef*)dotsrc_malloc(sizeof(ModDef));
  mod_def->tag = MOD_DEF;
  mod_def->m_subs = m_subs;
  return   mod_def;
 }

/*** copy ***/
  ModDef*   copy_mod_def(mod_def)
   ModDef*     mod_def;   
{
   ModDef*     new_mod_def;
  
  if(mod_def == NULL)
    return NULL;
  else
     new_mod_def = (ModDef*)dotsrc_malloc(sizeof(ModDef));
     new_mod_def->tag = mod_def->tag;
     new_mod_def->m_subs = copy_obj_list(mod_def->m_subs);
     return   new_mod_def;
 }

/*** set ***/
  ModDef*   set_mod_def(mod_def, m_subs)
  ModDef*   mod_def;
  ObjList*  m_subs;
{
  if(mod_def == NULL)
    write_through_NULL("set_mod_def");
  if(! is_mod_def_non_NULL(mod_def))
    type_error(mod_def,"MOD_DEF","set_mod_def");
  if(! is_obj_list(m_subs,M_SUB))
    type_error(m_subs,"MSub","set_mod_def");    
   mod_def->m_subs = m_subs;
   return  mod_def;
}

/*** new ***/
 ModDef*   new_mod_def()
{

ModDef*   mod_def;

 mod_def = (ModDef*)dotsrc_malloc(sizeof(ModDef));
 mod_def->tag = MOD_DEF;
 mod_def->m_subs = NULL;
        return  mod_def;
}

/*** insert ***/
ModDef*  insert_m_subs(mod_def,m_subs)
  ModDef*   mod_def;
  ObjList*  m_subs;
{
 if(mod_def == NULL)
   write_through_NULL("insert_m_sub");
 else if (is_mod_def_non_NULL(mod_def))
   if(mod_def->m_subs == NULL)
     {
      mod_def->m_subs = m_subs;
      return mod_def;
      }
  else
     {
        insert_list_to_obj_list(mod_def->m_subs,m_subs);
        return mod_def;
      }
 else
  type_error(mod_def,"MOD_DEF","insert_m_subs");
}

/*** add ***/
ModDef*  add_m_subs(mod_def,m_subs)
  ModDef*   mod_def;
  ObjList*  m_subs;
{
 if(mod_def == NULL)
   write_through_NULL("add_m_sub");
 else if (is_mod_def_non_NULL(mod_def))
   if(mod_def->m_subs == NULL)
    {
      mod_def->m_subs = m_subs;
      return mod_def;
    }
  else
    {
        concat_list_to_obj_list(mod_def->m_subs,m_subs);
        return  mod_def;
    }
 else
  type_error(mod_def,"MOD_DEF","add_m_subs");
}


/*** car ***/
MSub    *car_of_m_subs(mod_def)
   ModDef   *mod_def;
{
    if (mod_def == NULL || mod_def->m_subs == NULL)
      return NULL;
    else
      return (MSub*)extract_first_list_element(mod_def->m_subs);
  }


/*** delete ***/
 void  delete_mod_def(mod_def)
  ModDef*   mod_def;
{
  if(mod_def != NULL)
    if(is_mod_def_non_NULL(mod_def))
      {
         delete_obj_list(mod_def->m_subs);
         dotsrc_free((char*)mod_def);
       }
    else
       type_error(mod_def,"MOD_DEF","delete_mod_def");
}

/********************/ 
/*    m_sub         */
/********************/
/*** fis ***/
Bool  fis_m_sub(object)
   PseudoObject*   object;
 {
   return  object == NULL || object->tag == M_SUB;
 }

/*** decompose ***/
  void  decompose_m_sub(m_sub,m_id,m_desc)
    MSub*     m_sub;
    MId**     m_id;
    MDesc**   m_desc;
{
    if(m_sub == NULL)
      {
         *m_id = NULL;
         *m_desc = NULL;
       }
   else if(is_m_sub_non_NULL(m_sub))
     {
         *m_id = m_sub->m_id;
         *m_desc = m_sub->m_desc;
       }
  else
     type_error(m_sub,"M_SUB","decompose_m_sub");
  }

/*** read ***/
/* m_id */
MId*    read_m_id_inMSub(m_sub)
   MSub*     m_sub;
{
   if(m_sub == NULL)
     return NULL;
   else if(is_m_sub_non_NULL(m_sub)) 
     return m_sub->m_id;
   else
     type_error(m_sub,"M_SUB","read_m_id_inMSub");
 }

/* m_desc */
MDesc*    read_m_desc(m_sub)
   MSub*     m_sub;
{
   if(m_sub == NULL)
     return NULL;
   else if(is_m_sub_non_NULL(m_sub)) 
     return(m_sub->m_desc);
   else
     type_error(m_sub,"M_SUB","read_m_desc");
 }

/*** create ***/
  MSub*   create_m_sub(m_id,m_desc)
   MId*      m_id;
   MDesc*    m_desc;
{
   MSub*     m_sub;
  
  m_sub = (MSub*)dotsrc_malloc(sizeof(MSub));
  m_sub->tag = M_SUB;
  m_sub->m_id = m_id;
  m_sub->m_desc = m_desc;
  return  m_sub;
 }


/*** copy ***/
 MSub*   copy_m_sub(m_sub)
   MSub*   m_sub;
{
   MSub*      m;

   if(m_sub == NULL)
    return  NULL;
   else if(is_m_sub_non_NULL(m_sub))
    {
    m = (MSub*)dotsrc_malloc(sizeof(MSub));
    m->tag = M_SUB;
    m->m_id = copy_o_term(m_sub->m_id);
    m->m_desc = copy_m_desc(m_sub->m_desc);
    return  m;
    }
 else
   type_error(m_sub,"M_SUB","copy_m_sub");
}   

/*** set ***/
 MSub*   set_m_sub(m_sub,m_id,m_desc)
  MSub*   m_sub;
  MId*    m_id;
  MDesc*  m_desc;
{
  if(m_sub == NULL)
    write_through_NULL(m_sub);
  if(! is_m_sub_non_NULL(m_sub))
    type_error(m_sub,"M_SUB","set_m_sub");
  if(! is_m_id(m_id))
    type_error(m_id,"M_ID","set_m_sub");
  if(! is_m_desc(m_desc))
    type_error(m_desc,"MDesc","set_m_sub");
  
  m_sub->m_id = m_id;
  m_sub->m_desc = m_desc;
  return m_sub;
}


/*** write ***/
  MSub*   write_m_id_inMSub(m_sub,m_id)
  MSub*  m_sub;
  MId*   m_id;
{
  if(m_sub == NULL)
    write_through_NULL("write_m_id_inMSub");
  else if(is_m_sub_non_NULL(m_sub))
    {
          if(is_m_id(m_id))
            {
              m_sub->m_id = m_id;
              return  m_sub;
	    }
          else
             type_error(m_id,"M_ID","write_m_id_inMSub");
     }
   else
      type_error(m_sub,"M_SUB","write_m_id_inMSub");
}

MSub*   write_m_desc(m_sub,m_desc)
  MSub*  m_sub;
  MDesc* m_desc;
{
  if(m_sub == NULL)
    write_through_NULL("write_m_desc");
  else if(is_m_sub_non_NULL(m_sub))
    {
          if(is_m_desc(m_desc))
            {
              m_sub->m_desc = m_desc;
              return  m_sub;
	    }
          else
             type_error(m_desc,"MDesc","write_m_desc");
     }
   else
      type_error(m_sub,"M_SUB","write_m_desc");
}

/*** new ***/
MSub  *new_m_sub()
{
  MSub*   m_sub;

 m_sub = (MSub*)dotsrc_malloc(sizeof(MSub));
 m_sub->tag = M_SUB;
 m_sub->m_id = NULL;
 m_sub->m_desc = NULL;
        return  m_sub;
}

/*** delete ***/
void  delete_m_sub(m_sub)
  MSub*   m_sub;
{
   if(m_sub != NULL)
     if(is_m_sub_non_NULL(m_sub))
       {
          delete_o_term(m_sub->m_id);
          delete_m_desc(m_sub->m_desc);
          dotsrc_free((char*)m_sub);
        }
     else
       type_error(m_sub,"M_SUB","delete_m_sub");
 }

/********************/
/*    m_desc        */
/********************/
/*** fis ***/
Bool   fis_m_desc(object)
   PseudoObject*   object;
{
   return  object == NULL || fis_o_term(object) || fis_m2_desc(object);
   }

/*** create ***/
/* m_id */
MDesc*   create_m_desc_m_id(m_id)
   MId*    m_id;
{
   MId*    new_m_id;

     if(m_id == NULL)
       write_through_NULL("create_m_desc_m_id");
     else
       {
            new_m_id = copy_o_term(m_id);
            delete_o_term(m_id);
            return (MDesc*)new_m_id;
	}
 }

/* m2_desc */
MDesc*   create_m_desc_m2_desc(m2_desc)
   M2Desc*     m2_desc;
{
   M2Desc*     new_m2_desc;

     if(m2_desc == NULL)
       write_through_NULL("create_m_desc_m2_desc");
     else
       {
            new_m2_desc = copy_m2_desc(m2_desc);
            delete_m2_desc(m2_desc);
            return (MDesc*)new_m2_desc;
	}
 }

/*** new_m_desc ***/
MDesc*   new_m_desc()
{
   MDesc*   m_desc;

  m_desc = (MDesc*)dotsrc_malloc(sizeof(MDesc));
  m_desc->tag = M_DESC;
  return  m_desc;
 }

/*** copy ***/
MDesc*   copy_m_desc(m_desc)
MDesc*     m_desc;
{
    MDesc*     new_m_desc;

    if (m_desc == NULL)
         return  NULL;
    else
        if (is_m_id(m_desc))
            return  (MDesc*)copy_o_term((MId*)m_desc);
        else if (is_m2_desc(m_desc))
            return  (MDesc*)copy_m2_desc((M2Desc*)m_desc);
        else if (is_m_desc(m_desc)) {
            new_m_desc = (MDesc*)dotsrc_malloc(sizeof(MDesc));
            new_m_desc->tag = M_DESC;
            return    new_m_desc;
        }
        else {
            type_error(m_desc,"M_DESC","copy_m_desc");
        }
}

/*** delete ***/
void delete_m_desc(m_desc)
  MDesc*   m_desc;
{
   if(m_desc != NULL)
     {
        if(is_m_desc(m_desc))
             dotsrc_free((char*)m_desc);
        else if(is_m_id(m_desc))
                  delete_o_term((MId*)m_desc);
        else if(is_m2_desc(m_desc))
                  delete_m2_desc((M2Desc*)m_desc);
        else
                  type_error(m_desc,"M_DESC","delete_m_desc");
     }
}

/*********************/
/*    m2_desc        */
/*********************/
/*** fis ***/
Bool   fis_m2_desc(object)
   PseudoObject*   object;
{
   return  object == NULL || object->tag == M2_DESC;
   }

/*** decompose ***/ 
 void  decompose_m2_desc(m2_desc,m_desc1,op,m_desc2)
  M2Desc*    m2_desc;
  MDesc**    m_desc1;
  char*      op;
  MDesc**    m_desc2;
{
  if(m2_desc == NULL)
    {
        *m_desc1 = NULL;
        *op = NULL;
        *m_desc2 = NULL;
      }
  else if(is_m2_desc(m2_desc))
    {
        *m_desc1 = m2_desc->m_desc1;
        *op = m2_desc->op;
        *m_desc2 = m2_desc->m_desc2;
      }
 else
    type_error(m2_desc,"M2_DESC","decopmpose_m2_desc");
}

/*** read ***/
/* m_desc1 */
 MDesc*   read_m_desc1(m2_desc)
    M2Desc*     m2_desc;
{
   if(m2_desc == NULL)
     return  NULL;
  else if(is_m2_desc_non_NULL(m2_desc))
    return  m2_desc->m_desc1;
  else
    type_error(m2_desc,"M2_DESC","read_m_desc1");
 }

/*  op  */
 char   read_m_op(m2_desc)
    M2Desc*     m2_desc;
{
   if(m2_desc == NULL)
     return  NULL;
  else if(is_m2_desc_non_NULL(m2_desc))
    return  m2_desc->op;
  else
    type_error(m2_desc,"M2_DESC","read_m_op");
 }

/*   m_desc2  */
 MDesc*   read_m_desc2(m2_desc)
    M2Desc*     m2_desc;
{
   if(m2_desc == NULL)
     return  NULL;
  else if(is_m2_desc_non_NULL(m2_desc))
    return  m2_desc->m_desc2;
  else
    type_error(m2_desc,"M2_DESC","read_m_desc2");
 }

/*** create ***/
   M2Desc*   create_m2_desc(m_desc1,op,m_desc2)
  MDesc*    m_desc1;
  char      op;
  MDesc*    m_desc2;
{
   M2Desc*   m2_desc;

  m2_desc = (M2Desc*)dotsrc_malloc(sizeof(M2Desc));
  m2_desc->tag = M2_DESC;
  m2_desc->m_desc1 = m_desc1;
  m2_desc->op = op;
  m2_desc->m_desc2 = m_desc2;
  return  m2_desc;
}

/*** copy ***/
 M2Desc*  copy_m2_desc(m2_desc)
  M2Desc*     m2_desc;
{
   M2Desc*    new_m2_desc;

   if(m2_desc == NULL)
    return  NULL;
  else if(is_m2_desc_non_NULL(m2_desc))
    {
      new_m2_desc =  (M2Desc*)dotsrc_malloc(sizeof(M2Desc));
      new_m2_desc->tag = m2_desc->tag;
      new_m2_desc->m_desc1 = copy_m_desc(m2_desc->m_desc1);
      new_m2_desc->op = m2_desc->op;
      new_m2_desc->m_desc2 = copy_m_desc(m2_desc->m_desc2);
      return  new_m2_desc;
    }
  else
     type_error(m2_desc,"M2_DESC","copy_m2_desc");
 }

/*** set ***/
M2Desc*     set_m2_desc(m2_desc,m_desc1,op,m_desc2)
  M2Desc*    m2_desc;
  MDesc      *m_desc1, *m_desc2;
  char       op;
{
   if(m2_desc == NULL)
     write_through_NULL("set_m2_desc");
   if( !is_m2_desc_non_NULL(m2_desc))
       type_error(m2_desc,"M2DESC","set_m2_desc");
       m2_desc->m_desc1 = m_desc1;
       m2_desc->op = op;
       m2_desc->m_desc2 = m_desc2;
       return   m2_desc;
 }

/*** write  ***/
/*  m_desc1 */
M2Desc*     write_m_desc1(m2_desc,m_desc1)
  M2Desc*    m2_desc;
  MDesc*     m_desc1;
{
   if(m2_desc == NULL)
     write_through_NULL("write_m_desc1");
   else if(is_m2_desc_non_NULL(m2_desc))
     {
        m2_desc->m_desc1 = m_desc1;
        return   m2_desc;
     }
   else
      type_error(m2_desc,"M2DESC","write_m_desc1");
 }

/*  op */
M2Desc*     write_m_op(m2_desc,op)
  M2Desc*    m2_desc;
  char       op;
{
   if(m2_desc == NULL)
     write_through_NULL("write_op");
   else if(is_m2_desc_non_NULL(m2_desc))
     {
        m2_desc->op = op;
        return   m2_desc;
     }
   else
      type_error(m2_desc,"M2DESC","write_op");
 }

/*  m_desc2 */
M2Desc*     write_m_desc2(m2_desc,m_desc2)
  M2Desc*    m2_desc;
  MDesc*     m_desc2;
{
   if(m2_desc == NULL)
     write_through_NULL("write_m_desc2");
   else if(is_m2_desc_non_NULL(m2_desc))
     {
        m2_desc->m_desc2 = m_desc2;
        return   m2_desc;
     }
   else
      type_error(m2_desc,"M2DESC","write_m_desc2");
 }

/*** new ***/ 
  M2Desc*    new_m2_desc()
{
    M2Desc*   m2_desc;

 m2_desc = (M2Desc*)dotsrc_malloc(sizeof(M2Desc));
 m2_desc->tag = M2_DESC;
 m2_desc->m_desc1 = NULL;
 m2_desc->op = NULL;
 m2_desc->m_desc2 = NULL;
        return  m2_desc;
	}

/*** delete ***/
  void  delete_m2_desc(m2_desc)
  M2Desc*     m2_desc;
{
   if(m2_desc != NULL)
   if(is_m2_desc_non_NULL(m2_desc))
     {
        delete_m_desc(m2_desc->m_desc1);
        delete_m_desc(m2_desc->m_desc2);
        dotsrc_free(m2_desc);
     }
   else
       type_error(m2_desc,"M2_DESC","delete_m2_desc");
}


/********************/
/*    link_def      */
/********************/
/*** fis ***/
Bool fis_link_def(object)
    PseudoObject*   object;
{
       return object == NULL || object->tag == LINK_DEF;
}

/*** decompose ***/
void  decompose_link_def(link_def,links)
  LinkDef*       link_def;
  ObjList**      links;
{
   if(link_def == NULL)
     *links = NULL;
   else if(is_link_def_non_NULL(link_def))
        *links = link_def->links;
   else
        type_error(link_def,"LINK_DEF","decompose_link_def");
}

/*** create ***/
LinkDef*  create_link_def(links)
   ObjList*      links;
{
   LinkDef*   link_def;

   link_def = (LinkDef*)dotsrc_malloc(sizeof(LinkDef));
   link_def->tag = LINK_DEF;
   link_def->links = links;
   return   link_def;
}

/*** copy ***/
LinkDef*  copy_link_def(link_def)
  LinkDef*   link_def;
{
   LinkDef*   new_link_def;

   if(link_def == NULL)
     return NULL;
   else if(is_link_def_non_NULL(link_def))
    {
       new_link_def = (LinkDef*)dotsrc_malloc(sizeof(LinkDef));
       new_link_def->tag = LINK_DEF;
       new_link_def->links = copy_obj_list(link_def->links);
       return   new_link_def;
    }        
  else
       type_error(link_def,"LINK_DEF","copy_link_def");
}

/*** set ***/
LinkDef*   set_link_def(link_def,links)
  LinkDef*   link_def;
  ObjList*   links;
{
   if(link_def == NULL)
     write_through_NULL("set_link_def");
   if(! is_link_def_non_NULL(link_def))
     type_error(link_def,"LINK_DEF","set_link_def");
   if(! is_obj_list(links,LINK))
     type_error(links,"OBJ_LIST of LINK","set_link_def");     
   
   link_def->links = links;
   return  link_def;
}

/*** new ***/
LinkDef*   new_link_def()
{
  LinkDef*   link_def;

 link_def = (LinkDef*)dotsrc_malloc(sizeof(LinkDef));
 link_def->tag = LINK_DEF;
 link_def->links = NULL;
    return  link_def;
}

/*** insert  ***/
 LinkDef*   insert_links(link_def,links)
  LinkDef*   link_def;
  ObjList*   links;
{
   if(link_def == NULL)
      write_through_NULL("insert_links");
   else if(is_link_def_non_NULL(link_def))
     if(link_def->links == NULL)
      {
         link_def->links = links;
         return  link_def;
      }
    else
      {  
       insert_list_to_obj_list(link_def->links,links);
       return link_def;
     }
  else
    type_error(link_def,"LINK_DEF","insert_links");
}

/*** add  ***/
LinkDef*   add_links(link_def,links)
  LinkDef*   link_def;
  ObjList*   links;
{
   if(link_def == NULL)
      write_through_NULL("add_links");
   else if(is_link_def_non_NULL(link_def))
     if(link_def->links == NULL)
      {
         link_def->links = links;
         return  link_def;
      }
    else
      {  
       concat_list_to_obj_list(link_def->links,links);
       return  link_def;
     }
  else
    type_error(link_def,"LINK_DEF","add_links");
}


/*** car ***/
Link    *car_of_links(link_def)
   LinkDef   *link_def;
{
    if (link_def == NULL || link_def->links == NULL)
      return NULL;
    else
      return (Link*)extract_first_list_element(link_def->links);
  }


/*** delete ****/
void  delete_link_def(link_def)
  LinkDef*   link_def;
{
   if(link_def != NULL)
     if(is_link_def_non_NULL(link_def))
      {
        delete_obj_list(link_def->links);
        dotsrc_free((char*)link_def);
      }
   else
     type_error(link_def,"LINK_DEF","delete_link_def");
}

/*******************/
/*     link        */
/*******************/
 /*** fis ***/
Bool fis_link(object)
    PseudoObject*   object;
{
       return object == NULL || object->tag == LINK;
}

/*** decompose ***/
void  decompose_link(link,link_name,m_ids,o_terms)
   Link*           link;
   char**          link_name;
   ObjList**       m_ids;
   ObjList**       o_terms;
{
   if (link == NULL)
     {
          *link_name = NULL;
          *m_ids = NULL;
          *o_terms = NULL;
      }
  else if(is_link_non_NULL(link))
    {
        *link_name = link->link_name;
        *m_ids = link->m_ids;
        *o_terms = link->o_terms;
      }
  else
   type_error(link,"LINK","decompose_link"); 
 }

/*** read ***/
/* link_name */
char*  read_link_name(link)
   Link*   link;
{
   if(link == NULL)
     return NULL;
  else if(is_link_non_NULL(link))
    return  link->link_name;
  else
    type_error(link,"LINK","read_link_name");
 }

/* m_ids */
ObjList*  read_m_ids_inLink(link)
   Link*   link;
{
   if(link == NULL)
     return NULL;
  else if(is_link_non_NULL(link))
    return  link->m_ids;
  else
    type_error(link,"LINK","read_m_ids_inLink");
 }

/* o_term */
ObjList*  read_o_terms_inLink(link)
   Link*   link;
{
   if(link == NULL)
     return NULL;
  else if(is_link_non_NULL(link))
    return  link->o_terms;
  else
    type_error(link,"LINK","read_o_terms_inLink");
 }

/*** create ***/
Link*  create_link(link_name,m_ids,o_terms)
      char*        link_name;
      ObjList*     m_ids;
      ObjList*     o_terms;
{
      Link*        link; 

  link = (Link*)dotsrc_malloc(sizeof(Link));
  link->tag = LINK;
  link->link_name = link_name;
  link->m_ids = m_ids;
  link->o_terms = o_terms;
  return  link;
 }

/*** copy ***/
Link*   copy_link(link)
      Link*        link; 
{
      Link*        new_link; 
  if(link == NULL)
    return   NULL;
  else
    {
     new_link = (Link*)dotsrc_malloc(sizeof(Link));
     new_link->tag = link->tag;
     if(link->link_name != NULL)
            new_link->link_name = dotsrc_strdup(link->link_name);
     else
           new_link->link_name = NULL;
     new_link->m_ids = copy_obj_list(link->m_ids);
     new_link->o_terms = copy_obj_list(link->o_terms);
     return    new_link;
   }
 }

/*** set ***/
Link*    set_link(link,link_name,m_ids,o_terms)
      Link*        link; 
      char*        link_name;
      ObjList*     m_ids;
      ObjList*     o_terms;
{
  if(link == NULL)
    write_through_NULL("set_link");
  if(! is_link_non_NULL(link))
    type_error(link,"LINK","set_link");
  link->link_name = link_name;
  link->m_ids = m_ids;
  link->o_terms = o_terms;
  return  link;
}   

/*** write ***/
/* link_name */
Link* write_link_name(link,link_name)
   Link*   link;
   char*   link_name;
{
   if(link == NULL)
     write_through_NULL("write_link_name");
   else if(is_link_non_NULL(link))
     {
       link->link_name = link_name;
       return link;
      }
  else
       type_error(link,"LINK","write_link_name");
 }

Link* write_m_ids_inLink(link,m_ids)
   Link*      link;
   ObjList*   m_ids;
{
   if(link == NULL)
     write_through_NULL("write_m_ids_inLink");
   else if(is_link_non_NULL(link))
     {
        link->m_ids = m_ids;
        return link;
      }
  else
       type_error(link,"LINK","write_m_ids_inLink");
 }

Link* write_o_terms_inLink(link,o_terms)
   Link*      link;
   ObjList*   o_terms;
{
   if(link == NULL)
     write_through_NULL("write_m_ids_inLink");
   else if(is_link_non_NULL(link))
     {
        link->o_terms = o_terms;
        return link;
      }
  else
       type_error(link,"LINK","write_o_terms_inLink");
 }

/*** new ***/
Link*   new_link()
{
  Link*    link;

  link = (Link*)dotsrc_malloc(sizeof(Link));
  link->tag = LINK;
  link->link_name = NULL;
  link->m_ids = NULL;
  link->o_terms = NULL;
  return   link;
 }

/*** insert ***/
/* m_ids */
Link*  insert_m_ids_inLink(link,m_ids)
  Link      *link;
  ObjList   *m_ids;
{
 if(link == NULL)
   write_through_NULL("insert_m_ids_inLink");
 else if (is_link_non_NULL(link))
   if(link->m_ids == NULL)
     {
      link->m_ids = m_ids;
      return link;
      }
  else
     {
        insert_list_to_obj_list(link->m_ids, m_ids);
        return link;
      }
 else
  type_error(link,"LINK","insert_m_ids_inLink");
}

/* o_terms */
Link*  insert_o_terms_inLink(link,o_terms)
  Link      *link;
  ObjList   *o_terms;
{
 if(link == NULL)
   write_through_NULL("insert_o_terms_inLink");
 else if (is_link_non_NULL(link))
   if(link->o_terms == NULL)
     {
      link->o_terms = o_terms;
      return link;
      }
  else
     {
        insert_list_to_obj_list(link->o_terms, o_terms);
        return link;
      }
 else
  type_error(link,"LINK","insert_o_terms_inLink");
}

/*** add ***/
/* m_ids */
Link*  add_m_ids_inLink(link,m_ids)
  Link      *link;
  ObjList   *m_ids;
{
 if(link == NULL)
   write_through_NULL("add_m_ids_inLink");
 else if (is_link_non_NULL(link))
   if(link->m_ids == NULL)
    {
      link->m_ids = m_ids;
      return link;
    }
  else
    {
        concat_list_to_obj_list(link->m_ids,m_ids);
        return  link;
    }
 else
  type_error(link,"LINK","add_m_ids_inLink");
}

/* o_terms */
Link*  add_o_terms_inLink(link,o_terms)
  Link      *link;
  ObjList   *o_terms;
{
 if(link == NULL)
   write_through_NULL("add_o_terms_inLink");
 else if (is_link_non_NULL(link))
   if(link->o_terms == NULL)
    {
      link->o_terms = o_terms;
      return link;
    }
  else
    {
        concat_list_to_obj_list(link->o_terms,o_terms);
        return  link;
    }
 else
  type_error(link,"LINK","add_o_terms_inLink");
}


/*** car ***/
/* m_ids */
MId    *car_of_m_ids_inLink(link)
   Link   *link;
{
    if (link == NULL || link->m_ids == NULL)
      return NULL;
    else
      return (MId*)extract_first_list_element(link->m_ids);
  }

/* o_terms */
OTerm    *car_of_o_terms_inLink(link)
   Link   *link;
{
    if (link == NULL || link->o_terms == NULL)
      return NULL;
    else
      return (OTerm*)extract_first_list_element(link->o_terms);
  }

/*** delete ***/
void   delete_link(link)
  Link*    link;
{
   if(link != NULL)
     if(is_link_non_NULL(link))
       {
         if(link->link_name != NULL)
           dotsrc_free(link->link_name);
         delete_obj_list(link->m_ids);
         delete_obj_list(link->o_terms);
         dotsrc_free((char*)link);
       }
   else
     type_error(link,"LINK","delete_link");
}  

/*********************/
/*  m_id_pair        */
/*********************/
 /*** fis ***/
Bool fis_m_id_pair(object)
    PseudoObject*   object;
{
       return object == NULL || object->tag == M_ID_PAIR;
}

/*** decompose ***/
void  decompose_m_id_pair(m_id_pair,m_id1,m_id2)
   MIdPair     *m_id_pair;
   MId         **m_id1, **m_id2;
{
   if (m_id_pair == NULL)
     {
          *m_id1 = NULL;
          *m_id2 = NULL;
      }
  else if(is_m_id_pair_non_NULL(m_id_pair))
    {
        *m_id1 = m_id_pair->m_id1;
        *m_id2 = m_id_pair->m_id2;
      }
  else
   type_error(m_id_pair,"M_ID_PAIR","decompose_m_id_pair"); 
 }

/*** read ***/
/* m_id1 */
MId*  read_m_id1(m_id_pair)
  MIdPair   *m_id_pair;
{
   if(m_id_pair == NULL)
     return NULL;
  else if(is_m_id_pair_non_NULL(m_id_pair))
    return  m_id_pair->m_id1;
  else
    type_error(m_id_pair,"M_ID_PAIR","read_m_id1");
 }

/* m_id2 */
MId*  read_m_id2(m_id_pair)
  MIdPair   *m_id_pair;
{
   if(m_id_pair == NULL)
     return NULL;
  else if(is_m_id_pair_non_NULL(m_id_pair))
    return  m_id_pair->m_id2;
  else
    type_error(m_id_pair,"M_ID_PAIR","read_m_id2");
 }

/*** create ***/
MIdPair*  create_m_id_pair(m_id1,m_id2)
   MId         *m_id1, *m_id2;
{
   MIdPair     *m_id_pair;

  m_id_pair = (MIdPair*)dotsrc_malloc(sizeof(MIdPair));
  m_id_pair->tag = M_ID_PAIR;
  m_id_pair->m_id1 = m_id1;
  m_id_pair->m_id2 = m_id2;
  return  m_id_pair;
 }

/*** copy ***/
MIdPair*   copy_m_id_pair(m_id_pair)
   MIdPair     *m_id_pair;
{
   MIdPair     *new_m_id_pair;

  if(m_id_pair == NULL)
    return   NULL;
  else
    {
     new_m_id_pair = (MIdPair*)dotsrc_malloc(sizeof(MIdPair));
     new_m_id_pair->tag = m_id_pair->tag;
     new_m_id_pair->m_id1 = copy_o_term(m_id_pair->m_id1);
     new_m_id_pair->m_id2 = copy_o_term(m_id_pair->m_id2);
     return    new_m_id_pair;
   }
 }

/*** set ***/
MIdPair*    set_m_id_pair(m_id_pair,m_id1,m_id2)
   MIdPair*    m_id_pair;
   MId         *m_id1, *m_id2;
{
  if(m_id_pair == NULL)
    write_through_NULL("set_m_id_pair");
  if(! is_m_id_pair_non_NULL(m_id_pair))
    type_error(m_id_pair,"MIdPair","set_m_id_pair");
  m_id_pair->m_id1 = m_id1;
  m_id_pair->m_id2 = m_id2;
  return  m_id_pair;
}   

/*** write ***/
/* m_id1 */
MIdPair* write_m_id1(m_id_pair,m_id1)
   MIdPair   *m_id_pair;
   MId       *m_id1;
{
   if(m_id_pair == NULL)
     write_through_NULL("write_m_id1");
   else if(is_m_id_pair_non_NULL(m_id_pair))
     {
        m_id_pair->m_id1 = m_id1;
        return m_id_pair;
      }
  else
       type_error(m_id_pair,"M_ID_PAIR","write_m_id1");
 }

/* m_id2 */
MIdPair* write_m_id2(m_id_pair,m_id2)
   MIdPair   *m_id_pair;
   MId       *m_id2;
{
   if(m_id_pair == NULL)
     write_through_NULL("write_m_id2");
   else if(is_m_id_pair_non_NULL(m_id_pair))
     {
        m_id_pair->m_id2 = m_id2;
        return m_id_pair;
      }
  else
       type_error(m_id_pair,"M_ID_PAIR","write_m_id2");
 }

/*** new ***/
MIdPair*   new_m_id_pair()
{
  MIdPair   *m_id_pair;

  m_id_pair = (MIdPair*)dotsrc_malloc(sizeof(MIdPair));
  m_id_pair->tag = M_ID_PAIR;
  m_id_pair->m_id1 = NULL;
  m_id_pair->m_id2 = NULL;
  return   m_id_pair;
 }

/*** delete ***/
void   delete_m_id_pair(m_id_pair)
  MIdPair   *m_id_pair;
{
   if(m_id_pair != NULL)
     if(is_m_id_pair_non_NULL(m_id_pair))
       {
         delete_o_term(m_id_pair->m_id1);
         delete_o_term(m_id_pair->m_id2);
         dotsrc_free((char*)m_id_pair);
       }
   else
     type_error(m_id_pair,"M_ID_PAIR","delete_m_id_pair");
}  

/*********************/
/*  o_term_pair        */
/*********************/
 /*** fis ***/
Bool fis_o_term_pair(object)
    PseudoObject*   object;
{
       return object == NULL || object->tag == O_TERM_PAIR;
}

/*** decompose ***/
void  decompose_o_term_pair(o_term_pair,o_term1,o_term2)
   OTermPair*    o_term_pair;
   OTerm         **o_term1, **o_term2;
{
   if (o_term_pair == NULL)
     {
          *o_term1 = NULL;
          *o_term2 = NULL;
      }
  else if(is_o_term_pair_non_NULL(o_term_pair))
    {
        *o_term1 = o_term_pair->o_term1;
        *o_term2 = o_term_pair->o_term2;
      }
  else
   type_error(o_term_pair,"O_TERM_PAIR","decompose_o_term_pair"); 
 }

/*** read ***/
/* o_term1 */
OTerm*  read_o_term1(o_term_pair)
  OTermPair   *o_term_pair;
{
   if(o_term_pair == NULL)
     return NULL;
  else if(is_o_term_pair_non_NULL(o_term_pair))
    return  o_term_pair->o_term1;
  else
    type_error(o_term_pair,"O_TERM_PAIR","read_o_term1");
 }

/* o_term2 */
OTerm*  read_o_term2(o_term_pair)
  OTermPair   *o_term_pair;
{
   if(o_term_pair == NULL)
     return NULL;
  else if(is_o_term_pair_non_NULL(o_term_pair))
    return  o_term_pair->o_term2;
  else
    type_error(o_term_pair,"O_TERM_PAIR","read_o_term2");
 }

/*** create ***/
OTermPair*  create_o_term_pair(o_term1,o_term2)
   OTerm         *o_term1, *o_term2;
{
   OTermPair     *o_term_pair;

  o_term_pair = (OTermPair*)dotsrc_malloc(sizeof(OTermPair));
  o_term_pair->tag = O_TERM_PAIR;
  o_term_pair->o_term1 = o_term1;
  o_term_pair->o_term2 = o_term2;
  return  o_term_pair;
 }

/*** copy ***/
OTermPair*   copy_o_term_pair(o_term_pair)
   OTermPair     *o_term_pair;
{
   OTermPair     *new_o_term_pair;

  if(o_term_pair == NULL)
    return   NULL;
  else
    {
     new_o_term_pair = (OTermPair*)dotsrc_malloc(sizeof(OTermPair));
     new_o_term_pair->tag = o_term_pair->tag;
     new_o_term_pair->o_term1 = copy_o_term(o_term_pair->o_term1);
     new_o_term_pair->o_term2 = copy_o_term(o_term_pair->o_term2);
     return    new_o_term_pair;
   }
 }

/*** set ***/
OTermPair*    set_o_term_pair(o_term_pair,o_term1,o_term2)
   OTermPair*    o_term_pair;
   OTerm         *o_term1, *o_term2;
{
  if(o_term_pair == NULL)
    write_through_NULL("set_o_term_pair");
  if(! is_o_term_pair_non_NULL(o_term_pair))
    type_error(o_term_pair,"OTermPair","set_o_term_pair");
  o_term_pair->o_term1 = o_term1;
  o_term_pair->o_term2 = o_term2;
  return  o_term_pair;
}   

/*** write ***/
/* o_term1 */
OTermPair* write_o_term1(o_term_pair,o_term1)
   OTermPair   *o_term_pair;
   OTerm       *o_term1;
{
   if(o_term_pair == NULL)
     write_through_NULL("write_o_term1");
   else if(is_o_term_pair_non_NULL(o_term_pair))
     {
        o_term_pair->o_term1 = o_term1;
        return o_term_pair;
      }
  else
       type_error(o_term_pair,"O_TAERM_PAIR","write_o_term1");
 }

/* o_term2 */
OTermPair* write_o_term2(o_term_pair,o_term2)
   OTermPair   *o_term_pair;
   OTerm       *o_term2;
{
   if(o_term_pair == NULL)
     write_through_NULL("write_o_term2");
   else if(is_o_term_pair_non_NULL(o_term_pair))
     {
        o_term_pair->o_term2 = o_term2;
        return o_term_pair;
      }
  else
       type_error(o_term_pair,"O_TERM_PAIR","write_o_term2");
 }

/*** new ***/
OTermPair*   new_o_term_pair()
{
  OTermPair   *o_term_pair;

  o_term_pair = (OTermPair*)dotsrc_malloc(sizeof(OTermPair));
  o_term_pair->tag = O_TERM_PAIR;
  o_term_pair->o_term1 = NULL;
  o_term_pair->o_term2 = NULL;
  return   o_term_pair;
 }

/*** delete ***/
void   delete_o_term_pair(o_term_pair)
  OTermPair   *o_term_pair;
{
   if(o_term_pair != NULL)
     if(is_o_term_pair_non_NULL(o_term_pair))
       {
         delete_o_term(o_term_pair->o_term1);
         delete_o_term(o_term_pair->o_term2);
         dotsrc_free((char*)o_term_pair);
       }
   else
     type_error(o_term_pair,"O_TERM_PAIR","delete_o_term_pair");
}  

/*********************/
/*    rule_def       */
/*********************/
/*** fis ***/
Bool fis_rule_def(object)
    PseudoObject*   object;
{
       return object == NULL || object->tag == RULE_DEF;
}

/*** decompose ***/
void  decompose_rule_def(rule_def,rules)
  RuleDef*   rule_def;
  ObjList**   rules;
{
   if(rule_def == NULL)
     *rules = NULL;
   else if(is_rule_def_non_NULL(rule_def))
        *rules = rule_def->rules;
   else
        type_error(rule_def,"RULE_DEF","decompose_rule_def");
}

/*** create ***/
RuleDef*  create_rule_def(rules)
   ObjList*      rules;
{
   RuleDef*   rule_def;

   rule_def = (RuleDef*)dotsrc_malloc(sizeof(RuleDef));
   rule_def->tag = RULE_DEF;
   rule_def->rules = rules;
   return   rule_def;
}

/*** copy ***/
RuleDef*  copy_rule_def(rule_def)
  RuleDef*   rule_def;
{
   RuleDef*   new_rule_def;

   if(rule_def == NULL)
     return NULL;
   else if(is_rule_def_non_NULL(rule_def))
    {
       new_rule_def = (RuleDef*)dotsrc_malloc(sizeof(RuleDef));
       new_rule_def->tag = RULE_DEF;
       new_rule_def->rules = copy_obj_list(rule_def->rules);
       return   new_rule_def;
    }        
  else
       type_error(rule_def,"RULE_DEF","copy_rule_def");
}

/*** set ***/
RuleDef*   set_rule_def(rule_def,rules)
  RuleDef*   rule_def;
  ObjList*   rules;
{
   if(rule_def == NULL)
     write_through_NULL("set_rule_def");
   if(! is_rule_def_non_NULL(rule_def))
     type_error(rule_def,"RULE_DEF","set_rule_def");
   if(! is_obj_list(rules,RULE))
     type_error(rules,"OBJ_LIST of RULE","set_rule_def");     
   rule_def->rules = rules;
   return  rule_def;
}

/*** new ***/
RuleDef*   new_rule_def()
{
   RuleDef*   rule_def;

 rule_def = (RuleDef*)dotsrc_malloc(sizeof(RuleDef));
 rule_def->tag = RULE_DEF;
 rule_def->rules = NULL;
    return  rule_def;
}

/*** insert  ***/
RuleDef*   insert_rules(rule_def,rules)
  RuleDef*   rule_def;
  ObjList*   rules;
{
   if(rule_def == NULL)
      write_through_NULL("insert_rules");
   else if(is_rule_def_non_NULL(rule_def))
     if(rule_def->rules == NULL)
      {
         rule_def->rules = rules;
         return  rule_def;
      }
    else
      {  
       insert_list_to_obj_list(rule_def->rules,rules);
       return   rule_def;
     }
  else
    type_error(rule_def,"RULE_DEF","insert_rules");
}

/*** add  ***/
RuleDef*   add_rules(rule_def,rules)
  RuleDef*   rule_def;
  ObjList*   rules;
{
   if(rule_def == NULL)
      write_through_NULL("add_rules");
   else if(is_rule_def_non_NULL(rule_def))
     if(rule_def->rules == NULL)
      {
         rule_def->rules = rules;
         return  rule_def;
      }
    else
      {  
       concat_list_to_obj_list(rule_def->rules,rules);
       return   rule_def;
     }
  else
    type_error(rule_def,"RULE_DEF","add_rules");
}

/*** car ***/
Rule    *car_of_rules(rule_def)
   RuleDef   *rule_def;
{
    if (rule_def == NULL || rule_def->rules == NULL)
      return NULL;
    else
      return (Rule*)extract_first_list_element(rule_def->rules);
  }

/*** delete ****/
void  delete_rule_def(rule_def)
  RuleDef*   rule_def;
{
   if(rule_def != NULL)
     if(is_rule_def_non_NULL(rule_def))
      {
        delete_obj_list(rule_def->rules);
        dotsrc_free((char*)rule_def);
      }
   else
     type_error(rule_def,"RULE_DEF","delete_rule_def");
}

/********************/
/*     rule         */
/********************/
/*** fis ***/
Bool fis_rule(object)
    PseudoObject*   object;
{
       return object == NULL || object->tag == RULE;
}

/*** decompose ***/
void  decompose_rule(rule,rule_class,m_ids,rule_id,inheritance_mode,
        no_assume,a_term,clusters,cnstrs)
   Rule*            rule; 
   RuleClass*       rule_class;
   ObjList**        m_ids;
   RuleId**         rule_id;
   InheritanceMode* inheritance_mode;
   NoAssume*        no_assume;
   ATerm**          a_term;
   ObjList**        clusters;
   ObjList**        cnstrs;
{
   if (rule == NULL)
     {
        *rule_class = NULL;
        *m_ids = NULL;
        *rule_id = NULL;
        *inheritance_mode = NULL;
        *no_assume = NULL;
        *a_term = NULL;
        *clusters = NULL;
        *cnstrs = NULL;
      }
  else if(is_rule_non_NULL(rule))
    {
        *rule_class = rule->rule_class;
        *m_ids = rule->m_ids;
        *rule_id = rule->rule_id;
        *inheritance_mode = rule->inheritance_mode;
        *no_assume = rule->no_assume;
        *a_term = rule->a_term;
        *clusters = rule->clusters;
        *cnstrs = rule->cnstrs;
      }
  else
   type_error(rule,"RULE","decompose_rule"); 
 }

/*** read ***/
/*  rule_class */
RuleClass  read_rule_class(rule)
   Rule*     rule;
{
   if(rule == NULL)
     return NULL;
  else if(is_rule_non_NULL(rule))
    return  rule->rule_class;
  else
    type_error(rule,"RULE","read_rule_class");
 }

/* m_ids */
ObjList*  read_m_ids_inRule(rule)
   Rule*   rule;
{
   if(rule == NULL)
     return NULL;
  else if(is_rule_non_NULL(rule))
    return  rule->m_ids;
  else
    type_error(rule ,"RULE ","read_m_ids_inRule");
 }

/* rule_id */
RuleId*  read_rule_id_inRule(rule)
   Rule*   rule;
{
   if(rule == NULL)
     return NULL;
  else if(is_rule_non_NULL(rule))
    return  rule->rule_id;
  else
    type_error(rule ,"RULE ","read_rule_id");
 }

/* inheritance_mode */
InheritanceMode   read_inheritance_mode(rule)
   Rule *   rule;
{
   if(rule == NULL)
     return NULL;
  else if(is_rule_non_NULL(rule))
    return  rule->inheritance_mode;
  else
    type_error(rule ,"RULE ","read_inheritance_mode");
 }

/* noassume */
NoAssume  read_no_assume(rule)
   Rule *   rule;
{
   if(rule == NULL)
     return NULL;
  else if(is_rule_non_NULL(rule))
    return  rule->no_assume;
  else
    type_error(rule ,"RULE ","read_noassume");
 }

/* a_term */
ATerm*  read_head_inRule(rule)
   Rule *   rule;
{
   if(rule == NULL)
     return NULL;
  else if(is_rule_non_NULL(rule))
    return  rule->a_term;
  else
    type_error(rule ,"RULE ","read_head_inRule");
 }

/* clusters */
ObjList*  read_clusters_inRule(rule)
   Rule *   rule;
{
   if(rule == NULL)
     return NULL;
  else if(is_rule_non_NULL(rule))
    return  rule->clusters;
  else
    type_error(rule ,"RULE ","read_clusters_inRule");
 }

/* cnstrs */
ObjList*  read_cnstrs_inRule(rule)
   Rule *   rule;
{
   if(rule == NULL)
     return NULL;
  else if(is_rule_non_NULL(rule))
    return  rule->cnstrs;
  else
    type_error(rule ,"RULE ","read_cnstrs");
 }

/*** create ***/
Rule*  create_rule(rule_class,m_ids,rule_id,inheritance_mode,
        no_assume,a_term,clusters,cnstrs)

   RuleClass       rule_class;
   ObjList*        m_ids;
   RuleId*         rule_id;
   InheritanceMode inheritance_mode;
   NoAssume        no_assume;
   ATerm*          a_term;
   ObjList*        clusters;
   ObjList*        cnstrs;

{
   Rule*        rule; 

  rule = (Rule*)dotsrc_malloc(sizeof(Rule));
  rule->tag = RULE;
  rule->rule_class = rule_class;
  rule->m_ids = m_ids;
  rule->rule_id = rule_id;
  rule->inheritance_mode = inheritance_mode;
  rule->no_assume = no_assume;
  rule->a_term = a_term;
  rule->clusters = clusters;
  rule->cnstrs = cnstrs;
  return   rule;
 }

/*** copy ***/
Rule*   copy_rule(rule)
      Rule*        rule; 
{
      Rule*        new_rule; 
  if(rule == NULL)
    return   NULL;
  else
    {
     new_rule = (Rule*)dotsrc_malloc(sizeof(Rule));
    new_rule->tag = rule->tag;
     new_rule->rule_class = rule->rule_class;
     new_rule->m_ids = copy_obj_list(rule->m_ids);
     new_rule->rule_id = copy_rule_id(rule->rule_id);
     new_rule->inheritance_mode = rule->inheritance_mode;
     new_rule->no_assume = rule->no_assume;
     new_rule->a_term = copy_a_term(rule->a_term);
     new_rule->clusters = copy_obj_list(rule->clusters);
     new_rule->cnstrs = copy_obj_list(rule->cnstrs);
     return  new_rule;
   }
 }

/*** set ***/
Rule*    set_rule(rule,rule_class,m_ids,rule_id,inheritance_mode,no_assume,
                    a_term,clusters,cnstrs)
      Rule*            rule; 
      RuleClass        rule_class;
      ObjList*         m_ids;
      RuleId*          rule_id;
      InheritanceMode  inheritance_mode;
      NoAssume         no_assume;
      ATerm*           a_term;
      ObjList*         clusters;
      ObjList*         cnstrs;
{
  if(rule == NULL)
    write_through_NULL("set_rule");
  if(! is_rule_non_NULL(rule))
    type_error(rule,"RULE","set_rule");
  rule->rule_class = rule_class;
  rule->m_ids = m_ids;
  rule->rule_id = rule_id;
  rule->inheritance_mode = inheritance_mode;
  rule->no_assume = no_assume;
  rule->a_term = a_term;
  rule->clusters = clusters;
  rule->cnstrs = cnstrs;
  return  rule;
}   

/*** write ***/
/* rule_class */
Rule* write_rule_class(rule,rule_class)
   Rule*       rule;
   RuleClass   rule_class;
{
   if(rule == NULL)
     write_through_NULL("write_rule_class");
   else if(is_rule_non_NULL(rule))
     {
        rule->rule_class = rule_class;
        return rule;
      }
  else
       type_error(rule,"RULE","write_rule_class");
 }

/* m_ids */
Rule* write_m_ids_inRule(rule,m_ids)
   Rule*      rule;
   ObjList*   m_ids;
{
   if(rule == NULL)
     write_through_NULL("write_m_ids_inRule");
   else if(is_rule_non_NULL(rule))
     {
        rule->m_ids = m_ids;
        return rule;
      }
  else
       type_error(rule,"RULE","write_m_ids_inRule");
 }

/* rule_id */
Rule* write_rule_id_inRule(rule,rule_id)
   Rule*      rule;
   RuleId*    rule_id;
{
   if(rule == NULL)
     write_through_NULL("write_rule_id_inRule");
   else if(is_rule_non_NULL(rule))
     {
        rule->rule_id = rule_id;
        return rule;
      }
  else
       type_error(rule,"RULE","write_rule_id_inRule");
 }

/* inheritance_mode */
Rule* write_inheritance_mode_inRule(rule,inheritance_mode)
   Rule*            rule;
   InheritanceMode  inheritance_mode;
{
   if(rule == NULL)
     write_through_NULL("write_inheritance_mode_inRule");
   else if(is_rule_non_NULL(rule))
     {
        rule->inheritance_mode = inheritance_mode;
        return rule;
      }
  else
       type_error(rule,"RULE","write_inheritance_mode_inRule");
 }

/* no_assume */
Rule* write_no_assume_inRule(rule,no_assume)
   Rule*            rule;
   NoAssume         no_assume;
{
   if(rule == NULL)
     write_through_NULL("write_no_assume_inRule");
   else if(is_rule_non_NULL(rule))
     {
        rule->no_assume = no_assume;
        return rule;
      }
  else
       type_error(rule,"RULE","write_no_assume_inRule");
 }

/* a_term */
Rule* write_head_inRule(rule,a_term)
   Rule*            rule;
   ATerm*           a_term;
{
   if(rule == NULL)
     write_through_NULL("write_aterm_inRule");
   else if(is_rule_non_NULL(rule))
     {
        rule->a_term = a_term;
        return rule;
      }
  else
       type_error(rule,"RULE","write_head_inRule");
 }

/* clusters */
Rule* write_clusters_inRule(rule,clusters)
   Rule*      rule;
   ObjList*   clusters;
{
   if(rule == NULL)
     write_through_NULL("write_clusters_inRule");
   else if(is_rule_non_NULL(rule))
     {
        rule->clusters = clusters;
        return rule;
      }
  else
       type_error(rule,"RULE","write_clusters_inRule");
 }

/* cnstrs */
Rule* write_cnstrs_inRule(rule,cnstrs)
   Rule*      rule;
   ObjList*   cnstrs;
{
   if(rule == NULL)
     write_through_NULL("write_cnstrs_inRule");
   else if(is_rule_non_NULL(rule))
     {
        rule->cnstrs = cnstrs;
        return rule;
      }
  else
       type_error(rule,"RULE","write_cnstrs_inRule");
 }

/*** new ***/
Rule  *new_rule()
{
 Rule      *rule;

 rule  = (Rule*)dotsrc_malloc(sizeof(Rule));
 rule->tag = RULE;
 rule->rule_class = NULL;
 rule->m_ids = NULL;
 rule->rule_id = NULL;
 rule->inheritance_mode = NULL;
 rule->no_assume = NULL;
 rule->a_term = NULL;
 rule->clusters = NULL;
 rule->cnstrs = NULL;
    return  rule;
}

/*** insert  ***/
/* m_ids */
Rule*   insert_m_ids_inRule(rule,m_ids)
  Rule*      rule;
  ObjList*   m_ids;
{
   if(rule == NULL)
      write_through_NULL("insert_m_ids_inRule");
   else if(is_rule_non_NULL(rule))
     if(rule->m_ids == NULL)
      {
         rule->m_ids = m_ids;
         return  rule;
      }
    else
      {  
       insert_list_to_obj_list(rule->m_ids,m_ids);
       return   rule;
     }
  else
    type_error(rule,"RULE","insert_m_ids_inRule");
}

/* clusters */
Rule*   insert_clusters_inRule(rule,clusters)
  Rule*      rule;
  ObjList*   clusters;
{
   if(rule == NULL)
      write_through_NULL("insert_clusters_inRule");
   else if(is_rule_non_NULL(rule))
     if(rule->clusters == NULL)
      {
         rule->clusters = clusters;
         return  rule;
      }
    else
      {  
       insert_list_to_obj_list(rule->clusters,clusters);
       return   rule;
     }
  else
    type_error(rule,"RULE","insert_m_clusters_inRule");
}

/* cnstrs */
Rule*   insert_cnstrs_inRule(rule,cnstrs)
  Rule*      rule;
  ObjList*   cnstrs;
{
   if(rule == NULL)
      write_through_NULL("insert_cnstrs_inRule");
   else if(is_rule_non_NULL(rule))
     if(rule->cnstrs == NULL)
      {
         rule->cnstrs = cnstrs;
         return  rule;
      }
    else
      {  
       insert_list_to_obj_list(rule->cnstrs,cnstrs);
       return   rule;
     }
  else
    type_error(rule,"RULE","insert_m_cnstrs_inRule");
}

/*** add  ***/
/* m_ids */
 Rule*   add_m_ids_inRule(rule,m_ids)
  Rule*      rule;
  ObjList*   m_ids;
{
   if(rule == NULL)
      write_through_NULL("add_m_ids_inRule");
   else if(is_rule_non_NULL(rule))
     if(rule->m_ids == NULL)
      {
         rule->m_ids = m_ids;
         return  rule;
      }
    else
      {  
       concat_list_to_obj_list(rule->m_ids,m_ids);
       return   rule;
     }
  else
    type_error(rule,"RULE","add_m_ids_inRule");
}

/* clusters */
 Rule*   add_clusters_inRule(rule,clusters)
  Rule*      rule;
  ObjList*   clusters;
{
   if(rule == NULL)
      write_through_NULL("add_clusters_inRule");
   else if(is_rule_non_NULL(rule))
     if(rule->clusters == NULL)
      {
         rule->clusters = clusters;
         return  rule;
      }
    else
      {  
       concat_list_to_obj_list(rule->clusters,clusters);
       return   rule;
     }
  else
    type_error(rule,"RULE","add_clusters_inRule");
}

/* cnstrs */
 Rule*   add_cnstrs_inRule(rule,cnstrs)
  Rule*      rule;
  ObjList*   cnstrs;
{
   if(rule == NULL)
      write_through_NULL("add_cnstrs_inRule");
   else if(is_rule_non_NULL(rule))
     if(rule->cnstrs == NULL)
      {
         rule->cnstrs = cnstrs;
         return  rule;
      }
    else
      {  
       concat_list_to_obj_list(rule->cnstrs,cnstrs);
       return   rule;
     }
  else
    type_error(rule,"RULE","add_cnstrs_inRule");
}

/*** car ***/
/* m_id */
MId    *car_of_m_ids_inRule(rule)
   Rule   *rule;
{
    if (rule == NULL || rule->m_ids == NULL)
      return NULL;
    else
      return (MId*)extract_first_list_element(rule->m_ids);
  }

/* clusters */
Cluster    *car_of_clusters_inRule(rule)
   Rule   *rule;
{
    if (rule == NULL || rule->clusters == NULL)
      return NULL;
    else
      return (Cluster*)extract_first_list_element(rule->clusters);
  }

/* cnstrs */
Cnstr    *car_of_cnstrs_inRule(rule)
   Rule   *rule;
{
    if (rule == NULL || rule->cnstrs == NULL)
      return NULL;
    else
      return (Cnstr*)extract_first_list_element(rule->cnstrs);
  }

/*** delete ****/
 void  delete_rule(rule)
  Rule*   rule;
{
   if(rule != NULL)
     if(is_rule_non_NULL(rule))
      {
        delete_obj_list(rule->m_ids);
        delete_rule_id(rule->rule_id);
        delete_a_term(rule->a_term);
        delete_obj_list(rule->clusters);
        delete_obj_list(rule->cnstrs);
        dotsrc_free((char*)rule);
      }
   else
     type_error(rule,"RULE","delete_rule");
}

/***********************/
/*    rule_id          */
/***********************/
/*** fis ***/
Bool fis_rule_id(object)
    PseudoObject*   object;
{
       return object == NULL || object->tag == RULE_ID;
}

/*** decompose ***/
void  decompose_rule_id(rule_id,rule_id_string)
   RuleId*   rule_id;
   char**    rule_id_string;
{
   if (rule_id == NULL)
       *rule_id_string = NULL;
  else if(is_rule_id_non_NULL(rule_id))
           *rule_id_string = rule_id->rule_id_string;
  else
   type_error(rule_id,"RULE_ID","decompose_rule_id"); 
 }

/*** create ***/
RuleId*  create_rule_id(rule_id_string)
   char*    rule_id_string;
{
    RuleId*     rule_id;
 
  rule_id = (RuleId*)dotsrc_malloc(sizeof(RuleId));
  rule_id->tag = RULE_ID;
    rule_id->rule_id_string = rule_id_string;
  return  rule_id;
 }

/*** copy ***/
RuleId*   copy_rule_id(rule_id)
  RuleId*    rule_id;
{
    RuleId*    new_rule_id;
  
  if(rule_id == NULL)
    return  NULL;
  else
    {
     new_rule_id = (RuleId*)dotsrc_malloc(sizeof(RuleId));
     new_rule_id->tag = rule_id->tag;
     if(rule_id->rule_id_string != NULL)
          new_rule_id->rule_id_string = dotsrc_strdup(rule_id->rule_id_string);
     else
          new_rule_id->rule_id_string = NULL;
     return   new_rule_id;
   }
 }

/*** set ***/
RuleId*    set_rule_id(rule_id,rule_id_string)
   RuleId*     rule_id;
   char*       rule_id_string;
{
  if(rule_id == NULL)
    write_through_NULL("set_rule_id");
  if(! is_rule_id_non_NULL(rule_id))
    type_error(rule_id,"RULE_ID","set_rule_id");
  else
       rule_id->rule_id_string = rule_id_string;
  return  rule_id;
}   

/*** new ***/
RuleId*   new_rule_id()
{
  RuleId*      rule_id;

  rule_id = (RuleId*)dotsrc_malloc(sizeof(RuleId));
  rule_id->tag = RULE_ID;
  rule_id->rule_id_string = NULL;
  return   rule_id;
 }

/*** delete ***/
void   delete_rule_id(rule_id)
  RuleId*      rule_id;
{
   if(rule_id != NULL)
     if(is_rule_id_non_NULL(rule_id))
       {
         if(rule_id->rule_id_string != NULL)
           dotsrc_free(rule_id->rule_id_string);
         dotsrc_free((char*)rule_id);
       }
}  

/***********************/
/*    cluster(union)   */
/***********************/
/*** fsi ***/
Bool fis_cluster(object)
    PseudoObject*   object;
{
       return object == NULL || object->tag == CLUSTER || fis_normal(object)
                         || fis_rel(object) || fis_update(object) || 
                            fis_transaction(object) ||fis_i_check(object) || 
                            fis_prop(object);
}

/*** create ***/
/* normal */
Cluster*   create_cluster_normal(normal)
   Normal*   normal;
{
   Normal*   new_normal;

     if(normal == NULL)
       write_through_NULL("create_cluster_normal");
     else
       {
            new_normal = copy_normal(normal);
            delete_normal(normal);
            return (Cluster*)new_normal;
	}
 }

/* rel */
Cluster*   create_cluster_rel(rel)
   Rel*   rel;
{
   Rel*   new_rel;

     if(rel == NULL)
       write_through_NULL("create_cluster_rel");
     else
       {
            new_rel = copy_rel(rel);
            delete_rel(rel);
            return (Cluster*)new_rel;
	}
 }

/* update */
Cluster*   create_cluster_update(update)
   Update*   update;
{
   Update*   new_update;

     if(update == NULL)
       write_through_NULL("create_cluster_update");
     else
       {
            new_update = copy_update(update);
            delete_update(update);
            return (Cluster*)new_update;
	}
 }

/* transaction */
Cluster*   create_cluster_transaction(transaction)
   Transaction*   transaction;
{
   Transaction*   new_transaction;

     if(transaction == NULL)
       write_through_NULL("create_cluster_transaction");
     else
       {
            new_transaction = copy_transaction(transaction);
            delete_transaction(transaction);
            return (Cluster*)new_transaction;
	}
 }

/* consis */
Cluster*   create_cluster_consis(consis)
   Consis*   consis;
{
   Consis*   new_consis;

     if(consis == NULL)
       write_through_NULL("create_cluster_consis");
     else
       {
            new_consis = copy_i_check(consis);
            delete_i_check(consis);
            return (Cluster*)new_consis;
	}
 }

/* inconsis */
Cluster*   create_cluster_inconsis(inconsis)
   InConsis*   inconsis;
{
   InConsis*   new_inconsis;

     if(inconsis == NULL)
       write_through_NULL("create_cluster_inconsis");
     else
       {
            new_inconsis = copy_i_check(inconsis);
            delete_i_check(inconsis);
            return (Cluster*)new_inconsis;
	}
 }

/*** copy ***/
Cluster* copy_cluster(cluster)
  Cluster*   cluster;
{
  Cluster*   new_cluster;

  if(cluster == NULL)
     return NULL;
  else
    {
        if(is_normal(cluster))
            return (Cluster*)copy_normal((Normal*)cluster);
        else if(is_rel(cluster))
            return (Cluster*)copy_rel((Rel*)cluster);
        else if(is_update(cluster))
            return (Cluster*)copy_update((Update*)cluster);
        else if(is_transaction(cluster))
            return (Cluster*)copy_transaction((Transaction*)cluster);
        else if(is_i_check(cluster))
            return (Cluster*)copy_i_check((ICheck*)cluster);
        else if(is_cluster(cluster))
	 {
            new_cluster = (Cluster*)dotsrc_malloc(sizeof(Cluster));
            new_cluster->tag = CLUSTER;
            return   new_cluster;
	  }
       else
            type_error(cluster,"CLUSTER","copy_cluster");
      }
}

/*** new ***/
Cluster*   new_cluster()
{
    Cluster*   cluster;

    cluster = (Cluster*)dotsrc_malloc(sizeof(Cluster));
    cluster->tag = CLUSTER;
    return   cluster;
  }

/*** delete ***/
void  delete_cluster(cluster)
  Cluster*   cluster;
{
   if(cluster != NULL)
      {
        if(is_normal(cluster))
              delete_normal((Normal*)cluster);
        else if(is_rel(cluster))
              delete_rel((Rel*)cluster);
        else if(is_update(cluster))
              delete_update((Update*)cluster);
        else if(is_transaction(cluster))
              delete_transaction((Transaction*)cluster);
        else if(is_i_check(cluster))
              delete_i_check((ICheck*)cluster);
        else if(is_cluster(cluster))
              dotsrc_free((char*)cluster);  
        else
            type_error(cluster,"CLUSTER","copy_cluster");
      }
}

/************************/
/*    normal            */
/************************/
/*** fis ***/
Bool fis_normal(object)
    PseudoObject*   object;
{
       return object == NULL || object->tag == NORMAL;
}

/*** decompose ***/
void  decompose_normal(normal,m_id,a_term)
   Normal*    normal;
   MId**      m_id;
   ATerm**   a_term;
{
   if (normal == NULL)
     {
        *m_id = NULL;
        *a_term = NULL;
     }
  else if(is_normal_non_NULL(normal))
    {
        *m_id = normal->m_id;
        *a_term =  normal->a_term;
     }
  else
   type_error(normal,"NORMAL","decompose_normal"); 
 }

/*** create ***/
Normal*  create_normal(m_id,a_term)
   MId*      m_id;
   ATerm*    a_term;
{
    Normal*     normal;
 
  normal = (Normal*)dotsrc_malloc(sizeof(Normal));
  normal->tag = NORMAL;
  normal->m_id = m_id;
  normal->a_term = a_term;
  return  normal;
 }

/*** read ***/
/* m_id */
MId*  read_m_id_inNormal(normal)
    Normal*   normal;
{
      if(normal == NULL)
     return NULL;
  else if(is_normal_non_NULL(normal))
    return  normal->m_id;
  else
    type_error(normal,"NORMAL","read_m_id_inNormal");
 }

/*  a_term */
ATerm*  read_a_term_inNormal(normal)
    Normal*   normal;
{
      if(normal == NULL)
     return NULL;
  else if(is_normal_non_NULL(normal))
    return  normal->a_term;
  else
    type_error(normal,"NORMAL","read_a_term_inNormal");
 }

/*** copy ***/
Normal*   copy_normal(normal)
  Normal*    normal;
{
    Normal*    new_normal;
  
  if(normal == NULL)
    return  NULL;
  else
    {
     new_normal = (Normal*)dotsrc_malloc(sizeof(Normal));
     new_normal->tag = normal->tag;
     new_normal->m_id = copy_o_term(normal->m_id);
     new_normal->a_term = copy_a_term(normal->a_term); 
     return   new_normal;
   }
 }

/*** set ***/
Normal*    set_normal(normal,m_id,a_term)
   Normal*   normal;
   MId*      m_id;
   ATerm*   a_term;
{
  if(normal == NULL)
    write_through_NULL("set_normal");
  if(! is_normal_non_NULL(normal))
    type_error(normal,"NORMAL","set_normal");
  normal->m_id = m_id;
  normal->a_term = a_term;
  return  normal;
}   

/*** write ***/
/* m_id */
Normal* write_m_id_inNormal(normal,m_id)
   Normal*      normal;
   MId*         m_id;
{
   if(normal == NULL)
     write_through_NULL("write_m_id_inNormal");
   else if(is_normal_non_NULL(normal))
     {
        normal->m_id = m_id;
        return normal;
      }
  else
       type_error(normal,"NORMAL","write_m_id_inNormal");
 }

 /* a_term */
Normal* write_a_term_inNormal(normal,a_term)
   Normal*      normal;
   ATerm*       a_term;
{
   if(normal == NULL)
     write_through_NULL("write_a_term_inNormal");
   else if(is_normal_non_NULL(normal))
     {
        normal->a_term = a_term;
        return normal;
      }
  else
       type_error(normal,"NORMAL","write_a_term_inNormal");
 }

/*** new ***/
Normal*   new_normal()
{
  Normal*      normal;

  normal = (Normal*)dotsrc_malloc(sizeof(Normal));
  normal->tag = NORMAL;
  normal->m_id = NULL;
  normal->a_term = NULL;
  return   normal;
 }

/*** delete ***/
void   delete_normal(normal)
    Normal*      normal;
{
   if(normal != NULL)
     if(is_normal_non_NULL(normal))
       {
         delete_o_term(normal->m_id);
         delete_a_term(normal->a_term);
         dotsrc_free((char*)normal);
       }
}  

/***********************/
/*    rel              */
/***********************/
/*** fsi ***/
Bool fis_rel(object)
    PseudoObject*   object;
{
       return object == NULL || object->tag == REL;
}

/*** decompose ***/
void  decompose_rel(rel,o_term1,sub_rel,o_term2)
   Rel*      rel;
   OTerm**   o_term1;
   CnRel*    sub_rel;
   OTerm**   o_term2;
   
{
   if (rel == NULL)
     {
        *o_term1 = NULL;
        *sub_rel = NULL;
        *o_term2 = NULL;
     }
  else if(is_rel_non_NULL(rel))
    {
        *o_term1 = rel->o_term1;
        *sub_rel = rel->sub_rel;
        *o_term2 = rel->o_term2;
     }
  else
   type_error(rel,"REL","decompose_rel"); 
 }

/*** read ***/
/* o_term1  */
OTerm*  read_o_term1_inRel(rel)
    Rel*    rel;
{
      if(rel == NULL)
     return NULL;
  else if(is_rel_non_NULL(rel))
    return  rel->o_term1;
  else
    type_error(rel,"REL","read_o_term1_inRel");
 }

/* sub_rel  */
CnRel  read_sub_rel_inRel(rel)
    Rel*    rel;
{
      if(rel == NULL)
     return NULL;
  else if(is_rel_non_NULL(rel))
    return  rel->sub_rel;
  else
    type_error(rel,"REL","read_sub_rel_inRel");
 }


/* o_term2  */
OTerm*  read_o_term2_inRel(rel)
    Rel*    rel;
{
      if(rel == NULL)
     return NULL;
  else if(is_rel_non_NULL(rel))
    return  rel->o_term2;
  else
    type_error(rel,"REL","read_o_term2_inRel");
 }

/*** create ***/
Rel*  create_rel(o_term1,sub_rel,o_term2)

   OTerm*   o_term1;
   CnRel    sub_rel;
   OTerm*   o_term2;
{
  Rel*    rel;

  rel = (Rel*)dotsrc_malloc(sizeof(Rel));
  rel->tag = REL;
  rel->o_term1 = o_term1;
  rel->sub_rel = sub_rel;
  rel->o_term2 = o_term2;
  return  rel;
 }

/*** copy ***/
Rel*   copy_rel(rel)
  Rel*    rel;
{
    Rel*    new_rel;
  
  if(rel == NULL)
    return  NULL;
  else
    {
     new_rel = (Rel*)dotsrc_malloc(sizeof(Rel));
     new_rel->tag = rel->tag;
     new_rel->o_term1 = copy_o_term(rel->o_term1);
     new_rel->sub_rel = rel->sub_rel;
     new_rel->o_term2 = copy_o_term(rel->o_term2);
     return   new_rel;
   }
 }

/*** set ***/
Rel*    set_rel(rel,o_term1,sub_rel,o_term2)
   Rel*   rel;
   OTerm*   o_term1;
   CnRel    sub_rel;
   OTerm*   o_term2;
{
  if(rel == NULL)
    write_through_NULL("set_rel");
  if(! is_rel_non_NULL(rel))
    type_error(rel,"REL","set_rel");
  rel->o_term1 = o_term1;
  rel->sub_rel = sub_rel;
  rel->o_term2 = o_term2;
  return  rel;
}   

/*** write ***/
/* o_term1 */
Rel* write_o_term1_inRel(rel,o_term1)
   Rel*         rel;
   OTerm*       o_term1;
{
   if(rel == NULL)
     write_through_NULL("write_o_term1_inRel");
   else if(is_rel_non_NULL(rel))
     {
        rel->o_term1 = o_term1;
        return rel;
      }
  else
       type_error(rel,"REL","write_o_term1_inRel");
 }

/* sub_rel */
Rel* write_sub_rel_inRel(rel,sub_rel)
   Rel*         rel;
   CnRel        sub_rel;
{
   if(rel == NULL)
     write_through_NULL("write_sub_rel_inRel");
   else if(is_rel_non_NULL(rel))
     {
        rel->sub_rel = sub_rel;
        return rel;
      }
  else
       type_error(rel,"REL","write_sub_rel_inRel");
 }

/* o_term2 */
Rel* write_o_term2_inRel(rel,o_term2)
   Rel*         rel;
   OTerm*       o_term2;
{
   if(rel == NULL)
     write_through_NULL("write_o_term2inRel");
   else if(is_rel_non_NULL(rel))
     {
        rel->o_term2 = o_term2;
        return rel;
      }
  else
       type_error(rel,"REL","write_o_term2_inRel");
 }

/*** new ***/
Rel*   new_rel()
{
  Rel*      rel;

  rel = (Rel*)dotsrc_malloc(sizeof(Rel));
  rel->tag = REL;
  rel->o_term1 = NULL;
  rel->sub_rel = NULL;
  rel->o_term2 = NULL;
  return   rel;
 }

/*** delete ***/
void   delete_rel(rel)
  Rel*      rel;
{
   if(rel != NULL)
     if(is_rel_non_NULL(rel))
       {
         delete_o_term(rel->o_term1);
         delete_o_term(rel->o_term2);
         dotsrc_free((char*)rel );
       }
}  

/**********************/
/*   update           */
/**********************/
/*** fsi ***/
Bool fis_update(object)
    PseudoObject*   object;
{
       return object == NULL || object->tag == UPDATE;
}

/*** decompose ***/
void   decompose_update(update,u_flag,m_id,a_term)
   Update*      update;
   UFlag*       u_flag;
   MId**        m_id;
   ATerm**      a_term;
{
   if (update == NULL)
     {
        *u_flag = NULL;
        *m_id = NULL;
        *a_term = NULL;
     }
  else if(is_update_non_NULL(update))
    {
        *u_flag = update->u_flag;
        *m_id = update->m_id;
        *a_term = update->a_term;
     }
  else
   type_error(update,"UPDATE","decompose_update"); 
 }

/*** read ***/
/* u_flag  */
UFlag  read_u_flag(update)
    Update*    update;
{
      if(update == NULL)
     return NULL;
  else if(is_update_non_NULL(update))
    return  update->u_flag;
  else
    type_error(update,"UPDATE","read_u_flag");
 }

/* m_id  */
MId*  read_m_id_inUpdate(update)
    Update*    update;
{
      if(update == NULL)
     return NULL;
  else if(is_update_non_NULL(update))
    return  update->m_id;
  else
    type_error(update,"UPDATE","read_m_id_inUpdate");
 }

/* a_term  */
ATerm*  read_a_term_inUpdate(update)
    Update*    update;
{
      if(update == NULL)
     return NULL;
  else if(is_update_non_NULL(update))
    return  update->a_term;
  else
    type_error(update,"UPDATE","read_a_term_inUpdate");
 }

/*** create ***/
Update*  create_update(u_flag,m_id,a_term)
   UFlag       u_flag;
   MId*        m_id;
   ATerm*      a_term;

{
  Update*      update;

  update = (Update*)dotsrc_malloc(sizeof(Update));
  update->tag = UPDATE;
  update->u_flag = u_flag;
  update->m_id = m_id;
  update->a_term = a_term;
  return   update;
 }

/*** copy ***/
Update*   copy_update(update)
  Update*    update;
{
    Update*    new_update;
  
  if(update == NULL)
    return   NULL;
  else
    {
     new_update = (Update*)dotsrc_malloc(sizeof(Update));
     new_update->tag = update->tag;
     new_update->u_flag = update->u_flag;
     new_update->m_id = copy_o_term(update->m_id);
     new_update->a_term = copy_a_term(update->a_term);
     return   new_update;
   }
 }

/*** set ***/
Update*    set_update(update,u_flag,m_id,a_term)
   Update*     update;
   UFlag       u_flag;
   MId*        m_id;
   ATerm*      a_term;
{
  if(update == NULL)
    write_through_NULL("set_update");
  if(! is_update_non_NULL(update))
    type_error(update,"UPDATE","set_update");
  update->u_flag = u_flag;
  update->m_id = m_id;
  update->a_term = a_term;
  return  update;
}   

/*** write ***/
/* u_flag */
Update* write_u_flag(update,u_flag)
   Update*         update;
   UFlag           u_flag;
{
   if(update == NULL)
     write_through_NULL("write_u_flag");
   else if(is_update_non_NULL(update))
     {
        update->u_flag = u_flag;
        return update;
      }
  else
       type_error(update,"UPDATE","write_u_flag");
 }

/* m_id */
Update* write_m_id_inUpdate(update,m_id)
   Update*         update;
   MId*            m_id;
{
   if(update == NULL)
     write_through_NULL("write_m_id_inUpdate");
   else if(is_update_non_NULL(update))
     {
        update->m_id = m_id;
        return update;
      }
  else
       type_error(update,"UPDATE","write_m_id_inUpdate");
 }

/* a_term */
Update* write_a_term_inUpdate(update,a_term)
   Update*         update;
   ATerm*          a_term;
{
   if(update == NULL)
     write_through_NULL("write_a_term_inUpdate");
   else if(is_update_non_NULL(update))
     {
        update->a_term = a_term;
        return update;
      }
  else
       type_error(update,"UPDATE","write_a_term_inUpdate");
 }

/*** new ***/
Update*   new_update()
{
  Update*      update;

  update = (Update*)dotsrc_malloc(sizeof(Update));
  update->tag = UPDATE;
  update->u_flag = NULL;
  update->m_id = NULL;
  update->a_term = NULL;
  return   update;
 }

/*** delete ***/
void   delete_update(update)
  Update*      update;
{
   if(update != NULL)
     if(is_update_non_NULL(update))
       {
         delete_o_term(update->m_id);
         delete_a_term(update->a_term);
         dotsrc_free((char*)update);
       }
}  

/**********************/
/*   transaction      */
/**********************/
/*** fsi ***/
Bool fis_transaction(object)
    PseudoObject*   object;
{
       return object == NULL || object->tag == TRANSACTION;
}

/*** decompose ***/
void  decompose_transaction(transaction,trn_data)
   Transaction*   transaction;
   TrnData*       trn_data;
{
   if (transaction == NULL)
       *trn_data = NULL;
  else if(is_transaction_non_NULL(transaction))
       *trn_data = transaction->trn_data;
  else
   type_error(transaction,"TRANSACTION","decompose_transaction"); 
 }

/*** create ***/
Transaction*  create_transaction(trn_data)
   TrnData   trn_data;
{
    Transaction*     transaction;
 
  transaction = (Transaction*)dotsrc_malloc(sizeof(Transaction));
  transaction->tag = TRANSACTION;
  transaction->trn_data = trn_data;
  return  transaction;
 }

/*** copy ***/
Transaction*   copy_transaction(transaction)
  Transaction*    transaction;
{
    Transaction*    new_transaction;
  
  if(transaction == NULL)
    return  NULL;
  else
    {
     new_transaction = (Transaction*)dotsrc_malloc(sizeof(Transaction));
     new_transaction->tag = transaction->tag;
     new_transaction->trn_data = transaction->trn_data;
     return   new_transaction;
   }
 }

/*** set ***/
Transaction*    set_transaction(transaction,trn_data)
   Transaction*     transaction;
   TrnData          trn_data;
{
  if(transaction == NULL)
    write_through_NULL("set_transaction");
  if(! is_transaction_non_NULL(transaction))
    type_error(transaction,"TRANSACTION","set_transaction");
  transaction->trn_data = trn_data;
   return  transaction;
}   
/*** new ***/
Transaction*   new_transaction()
{
  Transaction*      transaction;

  transaction = (Transaction*)dotsrc_malloc(sizeof(Transaction));
  transaction->tag = TRANSACTION;
  transaction->trn_data = NULL;
  return   transaction;
 }

/*** delete ***/
void   delete_transaction(transaction)
  Transaction*      transaction;
{
   if(transaction != NULL)
     if(is_transaction_non_NULL(transaction))
         dotsrc_free((char*)transaction);
}  

/*****************************/
/*  i_check_content(union)   */
/******************************/
/*** fsi ***/
Bool fis_i_check_content(object)
    PseudoObject*   object;
{
       return object == NULL || object->tag == I_CHECK_CONTENT || 
                        fis_prop(object) || fis_obj_list(object,CNSTR);
}

/*** copy ***/
ICheckContent* copy_i_check_content(i_check_content)
  ICheckContent*   i_check_content;
{

  ICheckContent*   new_i_check_content;

  if(i_check_content == NULL)
     return NULL;
  else
       {
          if(fis_prop(i_check_content))
             return  (ICheckContent*)copy_prop((Prop*)i_check_content);
          else if(fis_obj_list(i_check_content,CNSTR))
             return  (ICheckContent*)copy_obj_list((ObjList*)i_check_content);
          else if(fis_i_check_content(i_check_content))
	    {
               new_i_check_content = 
                       (ICheckContent*)dotsrc_malloc(sizeof(ICheckContent));
               new_i_check_content->tag = I_CHECK_CONTENT;
               return    new_i_check_content;
	     }
          else
             type_error(i_check_content,"I_CHECK_CONTENT",
                                                "copy_i_check_content");

       }
}

/* prop */
ICheckContent*  create_i_check_content_prop(prop)
    Prop*     prop;
{
    Prop*     new_prop;

     if(prop == NULL)
       write_through_NULL("create_i_check_content_prop");
     else
       {
            new_prop = copy_prop(prop);
            delete_prop(prop);
            return (ICheckContent*)new_prop;
	}
 }

/* cnstrs */
 ICheckContent*   create_i_check_content_cnstrs(cnstrs)
    ObjList*     cnstrs;
{
    ObjList*     new_cnstrs;

     if(cnstrs == NULL)
       write_through_NULL("create_i_check_content_cnstrs");
     else
       {
            new_cnstrs = copy_obj_list(cnstrs);
            delete_obj_list(cnstrs);
            return (ICheckContent*)new_cnstrs;
	}
 }

/*** new ***/
ICheckContent*   new_i_check_content()
{
    ICheckContent*   i_check_content;

    i_check_content = (ICheckContent*)dotsrc_malloc(sizeof(ICheckContent));
    i_check_content->tag = I_CHECK_CONTENT
;
    return   i_check_content;
  }

/*** delete ***/
void  delete_i_check_content(i_check_content)
  ICheckContent *   i_check_content;
{
   if(i_check_content != NULL)
	{
           if(fis_prop(i_check_content))
              delete_prop((Prop*)i_check_content);
           else if(fis_obj_list(i_check_content,CNSTR))
              delete_obj_list((ObjList*)i_check_content);
           else if(fis_i_check_content(i_check_content))
	      dotsrc_free((char*)i_check_content);
           else
              type_error(i_check_content,"I_CHECK_CONTENT",
                                        "delete_i_check_content");
	 }
}

/**********************/
/*    i_check         */
/**********************/
 /*** fis ***/
/* i_check */
Bool fis_i_check(object)
    PseudoObject*   object;
{
       return object == NULL || object->tag == I_CHECK || object->tag == CONSIS
	                || object->tag == INCONSIS ;
}

/* consis */
Bool fis_consis(object)
    PseudoObject*   object;
{
       return object == NULL || object->tag == CONSIS;
}

/* inconsis */
Bool fis_inconsis(object)
    PseudoObject*   object;
{
       return object == NULL || object->tag == INCONSIS;
}

/*** decompose ***/
void  decompose_i_check(i_check,i_check_content)
   ICheck*             i_check;
   ICheckContent**    i_check_content;
   
{
   if (i_check == NULL)
        *i_check_content = NULL;
  else if(is_i_check_non_NULL(i_check))
        *i_check_content = i_check->i_check_content;
  else
   type_error(i_check,"ICheck","decompose_i_check"); 
 }

/*** create ***/
/* i_check */
ICheck*  create_i_check(i_check_content)
   ICheckContent*  i_check_content;
{
   ICheck*         i_check;

  i_check = (ICheck*)dotsrc_malloc(sizeof(ICheck));
  i_check->tag = I_CHECK;
  i_check->i_check_content = i_check_content;
  return  i_check;
 }

/* consis */
Consis*  create_consis(i_check_content)
   ICheckContent*  i_check_content;
{
   Consis*         consis;

  consis = (ICheck*)dotsrc_malloc(sizeof(ICheck));
  consis->tag = CONSIS;
  consis->i_check_content = i_check_content;
  return  consis;
 }

/* inconsis */
InConsis*  create_inconsis(i_check_content)
   ICheckContent*  i_check_content;
{
   InConsis*         inconsis;

  inconsis = (ICheck*)dotsrc_malloc(sizeof(ICheck));
  inconsis->tag = INCONSIS;
  inconsis->i_check_content = i_check_content;
  return  inconsis;
 }

/*** copy ***/
ICheck*   copy_i_check(i_check)
    ICheck*  i_check;
{
    ICheck*  new_i_check;
  
  if(i_check == NULL)
    return  NULL;
  else
    {
     new_i_check = (ICheck*)dotsrc_malloc(sizeof(ICheck));
     new_i_check->tag = i_check->tag;
     new_i_check->i_check_content = 
                          copy_i_check_content(i_check->i_check_content);
     return   new_i_check;
   }
 }

/*** set ***/
ICheck*    set_i_check(i_check,i_check_content)
   ICheck*         i_check;
   ICheckContent*  i_check_content;
{
  if(i_check == NULL)
    write_through_NULL("set_i_check");
  if(! is_i_check_non_NULL(i_check))
    type_error(i_check,"I_CHECK","set_i_check");
  i_check->i_check_content = i_check_content;
  return  i_check;
}   

/*** new ***/
/* i_check */
ICheck*   new_i_check()
{
  ICheck*      i_check;

  i_check = (ICheck*)dotsrc_malloc(sizeof(ICheck));
  i_check->tag = I_CHECK;
  i_check->i_check_content = NULL;
  return   i_check;
 }

/* consis */
Consis*   new_consis()
{
  Consis*      consis;

  consis = (Consis*)dotsrc_malloc(sizeof(Consis));
  consis->tag = CONSIS;
  consis->i_check_content = NULL;
  return   consis;
 }

/* inconsis */
InConsis*   new_inconsis()
{
  InConsis*      inconsis;

  inconsis = (InConsis*)dotsrc_malloc(sizeof(InConsis));
  inconsis->tag = INCONSIS;
  inconsis->i_check_content = NULL;
  return   inconsis;
 }

/*** delete ***/
void   delete_i_check(i_check)
  ICheck*      i_check;
{
   if(i_check != NULL)
     if(is_i_check_non_NULL(i_check))
       {
         delete_i_check_content(i_check->i_check_content);
         dotsrc_free((char*)i_check);
       }
}  



/**********************/
/*    prop            */
/**********************/
 /*** fis ***/
Bool fis_prop(object)
    PseudoObject*   object;
{
       return object == NULL || object->tag == PROP;
}

/*** decompose ***/
void  decompose_prop(prop,m_id,a_term)
   Prop*      prop;
   MId**      m_id;
   ATerm**    a_term;
   
{
   if (prop == NULL)
     {
        *m_id = NULL;
        *a_term = NULL;
     }
  else if(is_prop_non_NULL(prop))
    {
        *m_id = prop->m_id;
        *a_term = prop->a_term;
     }
  else
   type_error(prop,"PROP","decompose_prop"); 
 }

/*** read ***/
/* m_id */
MId*  read_m_id_inProp(prop)
    Prop*    prop;
{
      if(prop == NULL)
     return NULL;
  else if(is_prop_non_NULL(prop))
    return  prop->m_id;
  else
    type_error(prop,"PROP","read_m_id_inProp");
 }

/* a_term  */
ATerm*  read_a_term_inProp(prop)
    Prop*    prop;
{
      if(prop == NULL)
     return NULL;
  else if(is_prop_non_NULL(prop))
    return  prop->a_term;
  else
    type_error(prop,"PROP","read_a_term_inProp");
 }

/*** create ***/
Prop*  create_prop(m_id,a_term)
   MId*     m_id;
   ATerm*   a_term;
{
  Prop*    prop;

  prop = (Prop*)dotsrc_malloc(sizeof(Prop));
  prop->tag = PROP;
  prop->m_id = m_id;
  prop->a_term = a_term;
  return  prop;
 }

/*** copy ***/
Prop*   copy_prop(prop)
  Prop*    prop;
{
    Prop*    new_prop;
  
  if(prop == NULL)
    return  NULL;
  else
    {
     new_prop = (Prop*)dotsrc_malloc(sizeof(Prop));
     new_prop->tag = prop->tag;
     new_prop->m_id = copy_o_term(prop->m_id);
     new_prop->a_term = copy_a_term(prop->a_term);
     return   new_prop;
   }
 }

/*** set ***/
Prop*    set_prop(prop,m_id,a_term)
   Prop*   prop;
   MId*    m_id;
   ATerm*  a_term;
{
  if(prop == NULL)
    write_through_NULL("set_prop");
  if(! is_prop_non_NULL(prop))
    type_error(prop,"PROP","set_prop");
  prop->m_id = m_id;
  prop->a_term = a_term;
  return  prop;
}   

/*** write ***/
/* m_id */
Prop* write_m_id_inProp(prop,m_id)
   Prop*         prop;
   MId*          m_id;
{
   if(prop == NULL)
     write_through_NULL("write_m_id_inProp");
   else if(is_prop_non_NULL(prop))
     {
        prop->m_id = m_id;
        return prop;
      }
  else
       type_error(prop,"PROP","write_m_id_inProp");
 }

/* a_term */
Prop* write_a_term_inProp(prop,a_term)
   Prop*         prop;
   ATerm*        a_term;
{
   if(prop == NULL)
     write_through_NULL("write_a_term_inProp");
   else if(is_prop_non_NULL(prop))
     {
        prop->a_term = a_term;
        return prop;
      }
  else
       type_error(prop,"PROP","write_a_term_inProp");
 }

/*** new ***/
Prop*   new_prop()
{
  Prop*      prop;

  prop = (Prop*)dotsrc_malloc(sizeof(Prop));
  prop->tag = PROP;
  prop->m_id = NULL;
  prop->a_term = NULL;
  return   prop;
 }

/*** delete ***/
void   delete_prop(prop)
  Prop*      prop;
{
   if(prop != NULL)
     if(is_prop_non_NULL(prop))
       {
         delete_o_term(prop->m_id);
         delete_a_term(prop->a_term);
         dotsrc_free((char*)prop);
       }
}  

/**********************/
/*    a_term          */
/**********************/
/*** fis ***/
Bool fis_a_term(object)
    PseudoObject*   object;
{
       return object == NULL || object->tag == A_TERM;
}

/*** decompose ***/
void  decompose_a_term(a_term,o_term,attrs,cnstrs)
   ATerm*      a_term;
   OTerm**     o_term;
   ObjList**   attrs;
   ObjList**   cnstrs;
{
   if (a_term == NULL)
     {
         *o_term = NULL;
         *attrs = NULL;
         *cnstrs = NULL;
     }
  else if(is_a_term_non_NULL(a_term))
    {
         *o_term = a_term->o_term;
         *attrs =a_term->attrs;
         *cnstrs = a_term->cnstrs;
     }
  else
   type_error(a_term,"ATERM","decompose_a_term"); 
 }

/*** read ***/
/* o_term */
OTerm*  read_o_term_inATerm(a_term)
    ATerm*    a_term;
{
      if(a_term == NULL)
     return NULL;
  else if(is_a_term_non_NULL(a_term))
    return  a_term->o_term;
  else
    type_error(a_term,"A_TERM","read_o_term_inATerm");
 }

/* attrs */
ObjList*  read_attrs_inATerm(a_term)
    ATerm*    a_term;
{
      if(a_term == NULL)
     return NULL;
  else if(is_a_term_non_NULL(a_term))
    return  a_term->attrs;
  else
    type_error(a_term,"ATERM","read_attrs_inATerm");
 }

/* cnstrs */
ObjList*  read_cnstrs_inATerm(a_term)
    ATerm*    a_term;
{
      if(a_term == NULL)
     return NULL;
  else if(is_a_term_non_NULL(a_term))
    return  a_term->cnstrs;
  else
    type_error(a_term,"ATERM","read_cnstrs_inATerm");
 }

/*** create ***/
ATerm*  create_a_term(o_term,attrs,cnstrs)
   OTerm*   o_term;
   ObjList* attrs;
   ObjList* cnstrs;
{
  ATerm*    a_term;

  a_term = (ATerm*)dotsrc_malloc(sizeof(ATerm));
  a_term->tag = A_TERM;
  a_term->o_term = o_term;
  a_term->attrs = attrs;
  a_term->cnstrs = cnstrs;
  return  a_term;
 }

/*** copy ***/
ATerm*   copy_a_term(a_term)
  ATerm*    a_term;
{
    ATerm*    new_a_term;
  
  if(a_term == NULL)
    return  NULL;
  else
    {
     new_a_term = (ATerm*)dotsrc_malloc(sizeof(ATerm));
     new_a_term->tag = a_term->tag;

     new_a_term->o_term = copy_o_term(a_term->o_term);
     new_a_term->attrs = copy_obj_list(a_term->attrs);
     new_a_term->cnstrs = copy_obj_list(a_term->cnstrs);
     return   new_a_term;
   }
 }

/*** set ***/
ATerm*    set_a_term(a_term,o_term,attrs,cnstrs)
   ATerm*   a_term;
   OTerm*   o_term;
   ObjList* attrs;
   ObjList* cnstrs;
{
  if(a_term == NULL)
    write_through_NULL("set_a_term");
  if(! is_a_term_non_NULL(a_term))
    type_error(a_term,"ATERM","set_a_term");
  a_term->o_term = o_term;
  a_term->attrs = attrs;
  a_term->cnstrs = cnstrs;
  return  a_term;
}   

/*** write ***/
/* o_term */
ATerm*  write_o_term_inATerm(a_term,o_term)
   ATerm*         a_term;
   OTerm*         o_term;
{
   if(a_term == NULL)
     write_through_NULL("write_o_term_inATerm");
   else if(is_a_term_non_NULL(a_term))
     {
        a_term->o_term = o_term;
        return a_term;
      }
  else
       type_error(a_term,"ATERM","write_o_term_inATerm");
 }

/* attrs */
ATerm* write_attrs_inATerm(a_term,attrs)
   ATerm*         a_term;
   ObjList*        attrs;
{
   if(a_term == NULL)
     write_through_NULL("write_attrs_inATerm");
   else if(is_a_term_non_NULL(a_term))
     {
        a_term->attrs = attrs;
        return a_term;
      }
  else
       type_error(a_term,"ATERM","write_attrs_inATerm");
 }

/*  cnstrs */
ATerm* write_cnstrs_inATerm(a_term,cnstrs)
   ATerm*         a_term;
   ObjList*       cnstrs;
{
   if(a_term == NULL)
     write_through_NULL("write_cnstrs_inATerm");
   else if(is_a_term_non_NULL(a_term))
     {
        a_term->cnstrs = cnstrs;
        return a_term;
      }
  else
       type_error(a_term,"ATERM","write_cnstrs_inATerm");
 }

/*** new ***/
ATerm*   new_a_term()
{
  ATerm*      a_term;

  a_term = (ATerm*)dotsrc_malloc(sizeof(ATerm));
  a_term->tag = A_TERM;
  a_term->o_term = NULL;
  a_term->attrs = NULL;
  a_term->cnstrs = NULL;
  return   a_term;
 }

/*** insert ***/
/* attrs */
ATerm*   insert_attrs_inATerm(a_term,attrs)
  ATerm      *a_term;
  ObjList    *attrs;
{
   if(a_term == NULL)
      write_through_NULL("insert_attrs_inATerm");
   else if(is_a_term_non_NULL(a_term))
     if(a_term->attrs == NULL)
      {
         a_term->attrs = attrs;
         return  a_term;
      }
    else
      {  
       insert_list_to_obj_list(a_term->attrs,attrs);
       return   a_term;
     }
  else
    type_error(a_term,"A_TERM","insert_attrs_inATerm");
}

/* cnstrs */
ATerm*   insert_cnstrs_inATerm(a_term,cnstrs)
  ATerm      *a_term;
  ObjList    *cnstrs;
{
   if(a_term == NULL)
      write_through_NULL("insert_cnstrs_inATerm");
   else if(is_a_term_non_NULL(a_term))
     if(a_term->cnstrs == NULL)
      {
         a_term->cnstrs = cnstrs;
         return  a_term;
      }
    else
      {  
       insert_list_to_obj_list(a_term->cnstrs,cnstrs);
       return   a_term;
     }
  else
    type_error(a_term,"A_TERM","insert_cnstrs_inATerm");
}

/*** add  ***/
/* attrs */
ATerm*   add_attrs_inATerm(a_term,attrs)
  ATerm      *a_term;
  ObjList    *attrs;
{
   if(a_term == NULL)
      write_through_NULL("add_attrs_inATerm");
   else if(is_a_term_non_NULL(a_term))
     if(a_term->attrs == NULL)
      {
         a_term->attrs = attrs;
         return  a_term;
      }
    else
      {  
       concat_list_to_obj_list(a_term->attrs,attrs);
       return   a_term;
     }
  else
    type_error(a_term,"A_TERM","add_attrs_inATerm");
}

/* cnstrs */
ATerm*   add_cnstrs_inATerm(a_term,cnstrs)
  ATerm      *a_term;
  ObjList    *cnstrs;
{
   if(a_term == NULL)
      write_through_NULL("add_cnstrs_inATerm");
   else if(is_a_term_non_NULL(a_term))
     if(a_term->cnstrs == NULL)
      {
         a_term->cnstrs = cnstrs;
         return  a_term;
      }
    else
      {  
       concat_list_to_obj_list(a_term->cnstrs,cnstrs);
       return   a_term;
     }
  else
    type_error(a_term,"A_TERM","add_cnstrs_inATerm");
}


/*** car ***/
/* attrs */
Attr    *car_of_attrs_inATerm(a_term)
   ATerm   *a_term;
{
    if (a_term == NULL || a_term->attrs == NULL)
      return NULL;
    else
      return (Attr*)extract_first_list_element(a_term->attrs);
  }

/* cnstrs */
Cnstr    *car_of_cnstrs_inATerm(a_term)
   ATerm   *a_term;
{
    if (a_term == NULL || a_term->cnstrs == NULL)
      return NULL;
    else
      return (Cnstr*)extract_first_list_element(a_term->cnstrs);
  }

/*** delete ***/
void   delete_a_term(a_term)
  ATerm*      a_term;
{
   if(a_term != NULL)
     if(is_a_term_non_NULL(a_term))
       {
         delete_o_term(a_term->o_term);
         delete_obj_list(a_term->attrs);
         delete_obj_list(a_term->cnstrs);
         dotsrc_free((char*)a_term);
       }
}  

/**********************/
/*    o_term          */
/**********************/
/*** fis ***/
Bool fis_o_term(object)
   PseudoObject*   object;
{
       return object == NULL || object->tag == O_TERM  || fis_prolog(object)
                        || fis_c_o_term(object) ||  fis_var(object)
                        || fis_dot(object) || fis_list(object)
                        || fis_non_struct(object);
}

/*** create ***/
/* prolog */
OTerm*   create_o_term_prolog(prolog)
   Prolog*   prolog;
{
   Prolog*   new_prolog;

     if(prolog == NULL)
       write_through_NULL("create_o_term_prolog");
     else
       {
            new_prolog = copy_prolog(prolog);
            delete_prolog(prolog);
            return (OTerm*)new_prolog;
	}
 }

/* c_o_term */
OTerm*   create_o_term_c_o_term(c_o_term)
   COTerm*   c_o_term;
{
   COTerm*   new_c_o_term;

     if(c_o_term == NULL)
       write_through_NULL("create_o_term_c_o_term");
     else
       {
            new_c_o_term = copy_c_o_term(c_o_term);
            delete_c_o_term(c_o_term);
            return (OTerm*)new_c_o_term;
	}
 }

/* var */
OTerm*   create_o_term_var(var)
   Var*   var;
{
   Var*   new_var;

     if(var == NULL)
       write_through_NULL("create_o_term_var");
     else
       {
            new_var = copy_var(var);
            delete_var(var);
            return (OTerm*)new_var;
	}
 }

/* dot */
OTerm*   create_o_term_dot(dot)
   Dot*   dot;
{
   Dot*   new_dot;

     if(dot == NULL)
       write_through_NULL("create_o_term_dot");
     else
       {
            new_dot = copy_dot(dot);
            delete_dot(dot);
            return (OTerm*)new_dot;
	}
 }

/* list */
OTerm*   create_o_term_list(list)
   List*   list;
{
   List*   new_list;

     if(list == NULL)
       write_through_NULL("create_o_term_list");
     else
       {
            new_list = copy_list(list);
            delete_list(list);
            return (OTerm*)new_list;
	}
 }

/* non_struct */
OTerm*   create_o_term_non_struct(non_struct)
   NonStruct*   non_struct;
{
   NonStruct*   new_non_struct;

     if(non_struct == NULL)
       write_through_NULL("create_o_term_non_struct");
     else
       {
            new_non_struct = copy_non_struct(non_struct);
            delete_non_struct(non_struct);
            return (OTerm*)new_non_struct;
	}
 }

/*** copy ***/
OTerm* copy_o_term(o_term)
  OTerm*   o_term;
{
  OTerm*   new_o_term;

  if(o_term == NULL)
     return NULL;
  else
    {
      if(is_prolog(o_term))       
        return (OTerm*)copy_prolog((Prolog*)o_term);
      else if(is_c_o_term(o_term))
        return (OTerm*)copy_c_o_term((COTerm*)o_term);
      else if(is_var(o_term))
        return (OTerm*)copy_var((Var*)o_term);
      else if(is_dot(o_term))
        return (OTerm*)copy_dot((Dot*)o_term);
      else if(is_list(o_term))
        return (OTerm*)copy_list((List*)o_term);
      else if(is_non_struct(o_term))
        return (OTerm*)copy_non_struct((NonStruct*)o_term);
      else if(is_o_term(o_term))
      {
        new_o_term = (OTerm*)dotsrc_malloc(sizeof(OTerm));
        new_o_term->tag = O_TERM;
        return new_o_term;
      }
     else
         type_error(o_term,"O_TERM","copy_o_term");
    }
}

/*** new ****/
OTerm*    new_o_term()
{
    OTerm*    o_term;

   o_term = (OTerm*)dotsrc_malloc(sizeof(OTerm));
   o_term->tag = O_TERM;
   return   o_term;
  }

/*** delete ***/
void  delete_o_term(o_term)
  OTerm*   o_term;
{
   if(o_term != NULL)
     {
       if(is_prolog(o_term))
           delete_prolog((Prolog*)o_term);
       else if(is_c_o_term(o_term))
           delete_c_o_term((COTerm*)o_term);
       else if(is_var(o_term))
           delete_var((Var*)o_term);
       else if(is_dot(o_term))
           delete_dot((Dot*)o_term);
       else if(is_list(o_term))
           delete_list((List*)o_term);
       else if(is_non_struct(o_term))
           delete_non_struct((NonStruct*)o_term);
       else if(is_o_term(o_term))
           dotsrc_free((char*)o_term);
       else
          type_error(o_term,"O_TERM","delete_o_term");
     }
}

/**********************/
/*   c_o_term         */
/**********************/
/*** fis ***/
Bool fis_c_o_term(object)
    PseudoObject*   object;
{
       return object == NULL || object->tag == C_O_TERM;
}

/*** decompose ***/
void  decompose_c_o_term(c_o_term,head,attrs,cnstrs)
   COTerm*     c_o_term;
   char**      head;
   ObjList**   attrs;
   ObjList**   cnstrs;
{
   if (c_o_term == NULL)
     {
         *head = NULL;
         *attrs = NULL;
         *cnstrs = NULL;
     }
  else if(is_c_o_term_non_NULL(c_o_term))
    {
         *head = c_o_term->head;
         *attrs =c_o_term->attrs;
         *cnstrs = c_o_term->cnstrs;
     }
  else
   type_error(c_o_term,"COTerm","decompose_c_o_term"); 
 }

/*** read ***/
/* head*/
char*  read_head_inCOTerm(c_o_term)
    COTerm*    c_o_term;
{
      if(c_o_term == NULL)
     return NULL;
  else if(is_c_o_term_non_NULL(c_o_term))
    return  c_o_term->head;
  else
    type_error(c_o_term,"C_O_TERM","read_head_inCOTerm");
 }

/* attrs */
ObjList*  read_attrs_inCOTerm(c_o_term)
    COTerm*    c_o_term;
{
      if(c_o_term == NULL)
     return NULL;
  else if(is_c_o_term_non_NULL(c_o_term))
    return  c_o_term->attrs;
  else
    type_error(c_o_term,"COTerm","read_attrs_inCOTerm");
 }

/* cnstrs */
ObjList*  read_cnstrs_inCOTerm(c_o_term)
    COTerm*    c_o_term;
{
      if(c_o_term == NULL)
     return NULL;
  else if(is_c_o_term_non_NULL(c_o_term))
    return  c_o_term->cnstrs;
  else
    type_error(c_o_term,"COTerm","read_cnstrs_inCOTerm");
 }

/*** create ***/
COTerm*  create_c_o_term(head,attrs,cnstrs)
   char*    head;
   ObjList* attrs;
   ObjList* cnstrs;
{
  COTerm*    c_o_term;

  c_o_term = (COTerm*)dotsrc_malloc(sizeof(COTerm));
  c_o_term->tag = C_O_TERM;
  c_o_term->head = head;
  c_o_term->attrs = attrs;
  c_o_term->cnstrs = cnstrs;
  return  c_o_term;
 }

/*** copy ***/
COTerm*   copy_c_o_term(c_o_term)
  COTerm*    c_o_term;
{
    COTerm*    new_c_o_term;
  
  if(c_o_term == NULL)
    return  NULL;
  else
    {
     new_c_o_term = (COTerm*)dotsrc_malloc(sizeof(COTerm));
     new_c_o_term->tag = c_o_term->tag;
     if(c_o_term->head != NULL)
       {
          new_c_o_term->head = (char*)dotsrc_malloc(strlen(c_o_term->head));
          strcpy(new_c_o_term->head,c_o_term->head);
        }
     else 
          new_c_o_term->head = NULL;
     new_c_o_term->attrs = copy_obj_list(c_o_term->attrs);
     new_c_o_term->cnstrs = copy_obj_list(c_o_term->cnstrs);
     return   new_c_o_term;
   }
 }

/*** set ***/
COTerm*    set_c_o_term(c_o_term,head,attrs,cnstrs)
   COTerm*  c_o_term;
   char*    head;
   ObjList* attrs;
   ObjList* cnstrs;
{
  if(c_o_term == NULL)
    write_through_NULL("set_c_o_term");
  if(! is_c_o_term_non_NULL(c_o_term))
    type_error(c_o_term,"COTerm","set_c_o_term");
  c_o_term->head = head;
  c_o_term->attrs = attrs;
  c_o_term->cnstrs = cnstrs;
  return  c_o_term;
}   

/*** write ***/
/* head */
COTerm*  write_head_inCOTerm(c_o_term,head)
   COTerm*         c_o_term;
   char*           head;
{
   if(c_o_term == NULL)
     write_through_NULL("write_head_inCOTerm");
   else if(is_c_o_term_non_NULL(c_o_term))
     {
        if(head != NULL)
	  {
              c_o_term->head = (char*)dotsrc_malloc(strlen(head));
              strcpy(c_o_term->head,head);
	    }
       else        
              c_o_term->head = NULL;
        return c_o_term;
      }
  else
       type_error(c_o_term,"COTerm","write_head_inCOTerm");
 }

/* attrs */
COTerm* write_attrs_inCOTerm(c_o_term,attrs)
   COTerm*       c_o_term;
   ObjList*        attrs;
{
   if(c_o_term == NULL)
     write_through_NULL("write_attrs_inCOTerm");
   else if(is_c_o_term_non_NULL(c_o_term))
     {
        c_o_term->attrs = attrs;
        return c_o_term;
      }
  else
       type_error(c_o_term,"COTerm","write_attrs_inCOTerm");
 }

/*  cnstrs */
COTerm* write_cnstrs_inCOTerm(c_o_term,cnstrs)
   COTerm*        c_o_term;
   ObjList*       cnstrs;
{
   if(c_o_term == NULL)
     write_through_NULL("write_cnstrs_inCOTerm");
   else if(is_c_o_term_non_NULL(c_o_term))
     {
        c_o_term->cnstrs = cnstrs;
        return c_o_term;
      }
  else
       type_error(c_o_term,"COTerm","write_cnstrs_inCOTerm");
 }

/*** new ***/
COTerm*   new_c_o_term()
{
  COTerm*      c_o_term;

  c_o_term = (COTerm*)dotsrc_malloc(sizeof(COTerm));
  c_o_term->tag = C_O_TERM;
  c_o_term->head = NULL;
  c_o_term->attrs = NULL;
  c_o_term->cnstrs = NULL;
  return   c_o_term;
 }

/*** insert ***/
/* attrs */
COTerm*   insert_attrs_inCOTerm(c_o_term,attrs)
  COTerm      *c_o_term;
  ObjList    *attrs;
{
   if(c_o_term == NULL)
      write_through_NULL("insert_attrs_inCOTerm");
   else if(is_c_o_term_non_NULL(c_o_term))
     if(c_o_term->attrs == NULL)
      {
         c_o_term->attrs = attrs;
         return  c_o_term;
      }
    else
      {  
       insert_list_to_obj_list(c_o_term->attrs,attrs);
       return   c_o_term;
     }
  else
    type_error(c_o_term,"C_O_TERM","insert_attrs_inCOTerm");
}

/* cnstrs */
COTerm*   insert_cnstrs_inCOTerm(c_o_term,cnstrs)
  COTerm      *c_o_term;
  ObjList    *cnstrs;
{
   if(c_o_term == NULL)
      write_through_NULL("insert_cnstrs_inCOTerm");
   else if(is_c_o_term_non_NULL(c_o_term))
     if(c_o_term->cnstrs == NULL)
      {
         c_o_term->cnstrs = cnstrs;
         return  c_o_term;
      }
    else
      {  
       insert_list_to_obj_list(c_o_term->cnstrs,cnstrs);
       return   c_o_term;
     }
  else
    type_error(c_o_term,"C_O_TERM","insert_cnstrs_inCOTerm");
}

/*** add  ***/
/* attrs */
COTerm*   add_attrs_inCOTerm(c_o_term,attrs)
  COTerm      *c_o_term;
  ObjList    *attrs;
{
   if(c_o_term == NULL)
      write_through_NULL("add_attrs_inCOTerm");
   else if(is_c_o_term_non_NULL(c_o_term))
     if(c_o_term->attrs == NULL)
      {
         c_o_term->attrs = attrs;
         return  c_o_term;
      }
    else
      {  
       concat_list_to_obj_list(c_o_term->attrs,attrs);
       return   c_o_term;
     }
  else
    type_error(c_o_term,"C_O_TERM","add_attrs_inCOTerm");
}

/* cnstrs */
COTerm*   add_cnstrs_inCOTerm(c_o_term,cnstrs)
  COTerm      *c_o_term;
  ObjList    *cnstrs;
{
   if(c_o_term == NULL)
      write_through_NULL("add_cnstrs_inCOTerm");
   else if(is_c_o_term_non_NULL(c_o_term))
     if(c_o_term->cnstrs == NULL)
      {
         c_o_term->cnstrs = cnstrs;
         return  c_o_term;
      }
    else
      {  
       concat_list_to_obj_list(c_o_term->cnstrs,cnstrs);
       return   c_o_term;
     }
  else
    type_error(c_o_term,"C_O_TERM","add_cnstrs_inCOTerm");
}


/*** car ***/
/* attrs */
Attr    *car_of_attrs_inCOTerm(c_o_term)
   COTerm   *c_o_term;
{
    if (c_o_term == NULL || c_o_term->attrs == NULL)
      return NULL;
    else
      return (Attr*)extract_first_list_element(c_o_term->attrs);
  }

/* cnstrs */
Cnstr    *car_of_cnstrs_inCOTerm(c_o_term)
   COTerm   *c_o_term;
{
    if (c_o_term == NULL || c_o_term->cnstrs == NULL)
      return NULL;
    else
      return (Cnstr*)extract_first_list_element(c_o_term->cnstrs);
  }

/*** delete ***/
void   delete_c_o_term(c_o_term)
  COTerm*      c_o_term;
{
   if(c_o_term != NULL)
     if(is_c_o_term_non_NULL(c_o_term))
       {
         if(c_o_term->head != NULL)
            dotsrc_free(c_o_term->head);
         if(c_o_term->attrs != NULL)
            delete_obj_list(c_o_term->attrs);
         if(c_o_term->cnstrs != NULL)
            delete_obj_list(c_o_term->cnstrs);
         dotsrc_free((char*)c_o_term);
       }
}  

/**********************/
/*    dot             */
/**********************/
/*** fis ***/
Bool fis_dot(object)
    PseudoObject*   object;
{
       return object == NULL || object->tag == DOT;
}

/*** decompose ***/
void  decompose_dot(dot,o_term,label)
   Dot*            dot;
   OTerm**         o_term;
   Label**         label;
{
   if (dot == NULL)
     {
        *o_term = NULL;
        *label = NULL;
      }
  else if(is_dot_non_NULL(dot))
    {
        *o_term = dot->o_term;
        *label = dot->label;
      }
  else
   type_error(dot,"DOT","decompose_dot"); 
 }

/*** read ***/
/* o_term */
OTerm*  read_o_term_inDot(dot)
   Dot*        dot;
{
   if(dot == NULL)
     return NULL;
  else if(is_dot_non_NULL(dot))
    return  dot->o_term;
  else
    type_error(dot,"DOT","read_o_term_inDot");
 }

/* label */
Label*  read_label_inDot(dot)
   Dot*           dot;
{
   if(dot == NULL)
     return NULL;
  else if(is_dot_non_NULL(dot))
    return  dot->label;
  else
    type_error(dot,"DOT","read_label_inDot");
 }

/*** create ***/
Dot*  create_dot(o_term,label)
      OTerm*     o_term;
      Label*     label;
{
      Dot*       dot;
 
  dot = (Dot*)dotsrc_malloc(sizeof(Dot));
  dot->tag = DOT;
  dot->o_term = o_term;
  dot->label = label;
  return   dot;
 }

/*** copy ***/
Dot*   copy_dot(dot)
   Dot*           dot;
{
   Dot*           new_dot;
  
  if(dot == NULL)
    return  NULL;
  else
    {
     new_dot = (Dot*)dotsrc_malloc(sizeof(Dot));
     new_dot->tag = dot->tag;
     new_dot->o_term = copy_o_term(dot->o_term);
     new_dot->label = copy_label(dot->label);
     return  new_dot;
   }
 }

/*** set ***/
Dot*    set_dot(dot,o_term,label)
   Dot*    dot;
   OTerm*  o_term;
   Label*  label;
{
  if(dot == NULL)
    write_through_NULL("set_dot");
  if(! is_dot_non_NULL(dot))
    type_error(dot,"DOT","set_dot");
  dot->o_term = o_term;
  dot->label = label;
  return  dot;
}   

/*** write ***/
/* o_term */
Dot* write_o_term_inDot(dot,o_term)
   Dot*         dot;
   OTerm*     o_term;
{
   if(dot == NULL)
     write_through_NULL("write_o_term_inDot");
   else if(is_dot_non_NULL(dot))
     {
        dot->o_term = o_term;
        return dot;
      }
  else
       type_error(dot,"DOT","write_o_term_inDot");
 }

/* label */
Dot* write_label_inDot(dot,label)
   Dot*         dot;
   Label*       label;
{
   if(dot == NULL)
     write_through_NULL("write_label_inDot");
   else if(is_dot_non_NULL(dot))
     {
        dot->label = label;
        return dot;
      }
  else
       type_error(dot,"DOT","write_label_inDot");
 }

/*** new ***/
Dot*   new_dot()
{
  Dot*    dot;

  dot = (Dot*)dotsrc_malloc(sizeof(Dot));
  dot->tag = DOT;
  dot->o_term = NULL;
  dot->label = NULL;
  return  dot;
 }

/*** delete ***/
void   delete_dot(dot)
  Dot*    dot;
{
   if(dot != NULL)
     if(is_dot_non_NULL(dot))
       {
         delete_o_term(dot->o_term);
         delete_label(dot->label);
         dotsrc_free((char*)dot);
       }
}  

/********************/
/*   label          */
/********************/
/*** fis ***/
/* label */
Bool   fis_label(object)
  PseudoObject*   object;
{
   return object == NULL || object->tag == LABEL || object->tag == IND_LAB 
                    || object->tag == SET_LAB || object->tag == CURL_IND 
                    || object->tag == CURL_SET;
 }

/* ind_lab */
Bool   fis_ind_lab(object)
  PseudoObject*   object;
{
   return object == NULL || object->tag == IND_LAB;
 }

/* set_lab */
Bool   fis_set_lab(object)
  PseudoObject*   object;
{
   return object == NULL || object->tag == SET_LAB;
 }

/* curl_ind */
Bool   fis_curl_ind(object)
  PseudoObject*   object;
{
   return object == NULL || object->tag == CURL_IND;
 }

/* curl_set */
Bool   fis_curl_set(object)
  PseudoObject*   object;
{
   return object == NULL || object->tag == CURL_SET;
 }

/*** decompose ***/
void   decompose_label(label,o_term)
  Label*     label;
  OTerm**    o_term;
{
   if(label == NULL)
     *o_term = NULL;
  else if(is_label_non_NULL(label))
     *o_term = label->o_term;
  else
     type_error(label,"LABEL","decompose_label");
 }

/*** create ***/
/* label */
Label*  create_label(o_term)
   OTerm*    o_term;
{
    Label*   label;
 
 label = (Label*)dotsrc_malloc(sizeof(Label));
 label->tag = LABEL;
 label->o_term = o_term;
 return  label;
  }

/* ind_lab */
IndLab*  create_ind_lab(o_term)
   OTerm*    o_term;
{
    IndLab*   ind_lab;
 
 ind_lab = (IndLab*)dotsrc_malloc(sizeof(IndLab));
 ind_lab->tag = IND_LAB;
 ind_lab->o_term = o_term;
 return  ind_lab;
  }

/* set_lab */
SetLab*  create_set_lab(o_term)
   OTerm*    o_term;
{
    SetLab*   set_lab;
 
 set_lab = (SetLab*)dotsrc_malloc(sizeof(SetLab));
 set_lab->tag = SET_LAB;
 set_lab->o_term = o_term;
 return  set_lab;
  }

/* curl_ind */
CurlInd*  create_curl_ind(o_term)
   OTerm*    o_term;
{
    CurlInd*   curl_ind;
 
 curl_ind = (CurlInd*)dotsrc_malloc(sizeof(CurlInd));
 curl_ind->tag = CURL_IND;
 curl_ind->o_term = o_term;
 return  curl_ind;
  }

/* curl_set */
CurlSet*  create_curl_set(o_term)
   OTerm*    o_term;
{
    CurlSet*   curl_set;
 
 curl_set = (CurlSet*)dotsrc_malloc(sizeof(CurlSet));
 curl_set->tag = CURL_SET;
 curl_set->o_term = o_term;
 return  curl_set;
  }

/*** copy ***/
Label*  copy_label(label)
   Label*     label;
{
   Label*     new_label;

  if(label == NULL)
     return   NULL;
  else
     new_label = (Label*)dotsrc_malloc(sizeof(Label));
     new_label->tag = label->tag;
     new_label->o_term = copy_o_term(label->o_term);
     return   new_label;
}

/*** set ***/
Label*   set_label(label,o_term)
   Label*     label;
   OTerm*   o_term;
{
   if(label == NULL)
     write_through_NULL("set_label");
   if(! is_label_non_NULL(label))
       type_error(label,"LABEL","set_label");
   if( ! is_o_term(o_term))
       type_error(o_term,"O_TERM","set_label");
   label->o_term = o_term;
   return   label;
 }

/*** new ***/
/* label */
Label*   new_label()
{
   Label*   label;
  
   label = (Label*)dotsrc_malloc(sizeof(Label));
   label->tag = LABEL;
   label->o_term = NULL;
   return  label;
 }

/* ind_lab */
IndLab*   new_ind_lab()
{
   IndLab*   ind_lab;
  
   ind_lab = (IndLab*)dotsrc_malloc(sizeof(IndLab));
   ind_lab->tag = IND_LAB;
   ind_lab->o_term = NULL;
   return  ind_lab;
 }

/* set_lab */
SetLab*   new_set_lab()
{
   SetLab*   set_lab;
  
   set_lab = (SetLab*)dotsrc_malloc(sizeof(SetLab));
   set_lab->tag = SET_LAB;
   set_lab->o_term = NULL;
   return  set_lab;
 }

/* curl_ind */
CurlInd*   new_curl_ind()
{
   CurlInd*   curl_ind;
  
   curl_ind = (CurlInd*)dotsrc_malloc(sizeof(CurlInd));
   curl_ind->tag = CURL_IND;
   curl_ind->o_term = NULL;
   return  curl_ind;
 }

/* curl_set */
CurlSet*   new_curl_set()
{
   CurlSet*   curl_set;
  
   curl_set = (CurlSet*)dotsrc_malloc(sizeof(CurlSet));
   curl_set->tag = CURL_SET;
   curl_set->o_term = NULL;
   return  curl_set;
 }

/*** delete ***/
void   delete_label(label)
     Label*     label;
{
    if(label != NULL)
     if(is_label_non_NULL(label))
       {
          if(label->o_term != NULL)
             delete_o_term(label->o_term);
          dotsrc_free((char*)label);

	}
     else
          type_error(label,"LABEL","delete_label");
  }

/***********************/
/*      list (union)   */
/***********************/
/*** fis ***/
Bool fis_list(object)
    PseudoObject*   object;
{
       return object == NULL || object->tag == LIST || fis_obj_list(object,NORMAL)
               || fis_sub_list(object);
}

/*** create ***/
/* normal */
List*   create_list_normal(normal)
   ObjList*    normal;
{
   ObjList*    new_normal;

     if(normal == NULL)
       write_through_NULL("create_list_normal");
     else
       {
            new_normal = copy_obj_list(normal);
            delete_obj_list(normal);
            return (List*)new_normal;
	}
 }

/* sub_list */
List*   create_list_sub_list(sub_list)
   SubList*    sub_list;
{
   SubList*    new_sub_list;

     if(sub_list == NULL)
       write_through_NULL("create_list_list_sub_list");
     else
       {
            new_sub_list = copy_sub_list(sub_list);
            delete_sub_list(sub_list);
            return (List*)new_sub_list;
	}
 }

/*** copy ***/
List*   copy_list(list)
   List*     list;
{
   List*     new_list;


  if(list == NULL)
     return NULL;
  else
  {
    if(is_obj_list(list,NORMAL))
      return  (List*)copy_obj_list((ObjList*)list);
    else if(is_sub_list(list))
      return  (List*)copy_sub_list((SubList*)list);
    else if(is_list(list))
    {
      new_list =  (List*)dotsrc_malloc(sizeof(List));
      new_list->tag = LIST;
      return  new_list;
     }
   else
        type_error(list,"list","copy_list");
   }
 }

/*** new ***/
List*  new_list()
{
    List*   list;
  
    list = (List*)dotsrc_malloc(sizeof(List));
    list->tag = LIST;
    return list;
  }

/*** delete ***/
void  delete_list(list)
  List*   list;
{
  if(list != NULL)
  {
    if(is_obj_list(list,NORMAL))
         delete_obj_list((ObjList*)list);
    else if(is_sub_list(list))
         delete_sub_list((SubList*)list);
    else  if(is_list(list))
         dotsrc_free((char*)list);
    else
        type_error(list,"LIST","delete_ist");

   }
}

/**********************/
/*   sub_list         */
/**********************/
/*** fis ***/
Bool fis_sub_list(object)
    PseudoObject*   object;
{
       return object == NULL || object->tag == SUB_LIST;
}

/*** decompose ***/
void  decompose_sub_list(sub_list,o_terms,remain)
      SubList*      sub_list;
      ObjList**     o_terms;
      Remain**      remain;
{
   if (sub_list == NULL)
     {
        *o_terms = NULL;
        *remain = NULL;
      }
  else if(is_sub_list_non_NULL(sub_list))
    {
        *o_terms = sub_list->o_terms;
        *remain = sub_list->remain;
      }
  else
   type_error(sub_list,"SUB_LIST","decompose_sub_list"); 
 }

/*** read ***/
/* o_terms */
ObjList*  read_o_terms_inSubList(sub_list)
    SubList*     sub_list;
{
   if(sub_list == NULL)
     return NULL;
  else if(is_sub_list_non_NULL(sub_list))
    return  sub_list->o_terms;
  else
    type_error(sub_list,"SubList","read_o_terms_inSubList");
 }

/* remain */
Remain*  read_remain_inSubList(sub_list)
    SubList*     sub_list;
{
   if(sub_list == NULL)
     return NULL;
  else if(is_sub_list_non_NULL(sub_list))
    return  sub_list->remain;
  else
    type_error(sub_list,"SubList","read_o_terms_inSubList");
 }

/*** create ***/
SubList*  create_sub_list(o_terms,remain)
      ObjList*     o_terms;
      Remain*      remain;
{
      SubList*     sub_list;
 
  sub_list = (SubList*)dotsrc_malloc(sizeof(SubList));
  sub_list->tag = SUB_LIST;
  sub_list->o_terms = o_terms;
  sub_list->remain = remain;
  return  sub_list;
 }

/*** copy ***/
SubList*   copy_sub_list(sub_list)
   SubList*    sub_list;
{
   SubList*    new_sub_list;
  
  if(sub_list == NULL)
    return NULL;
  else
    {
     new_sub_list = (SubList*)dotsrc_malloc(sizeof(SubList));
     new_sub_list->tag  = sub_list->tag;
     new_sub_list->o_terms  = copy_obj_list(sub_list->o_terms);
     new_sub_list->remain  = copy_remain(sub_list->remain);
     return new_sub_list;
   }
 }

/*** set ***/
SubList*    set_sub_list(sub_list,o_terms,remain)
      SubList*     sub_list;
      ObjList*     o_terms;
      Remain*      remain;
{
  if(sub_list == NULL)
    write_through_NULL("set_sub_list");
  if(! is_sub_list_non_NULL(sub_list))
    type_error(sub_list,"SUB_LIST","set_sub_list");
  sub_list->o_terms = o_terms;
  sub_list->remain = remain;
  return  sub_list;
}   

/*** write ***/
/* o_terms */
SubList* write_o_terms_inSubList(sub_list,o_terms)
   SubList*     sub_list;
   ObjList*     o_terms;
{
   if(sub_list == NULL)
     write_through_NULL("write_o_terms_inSubList");
   else if(is_sub_list_non_NULL(sub_list))
     {
        sub_list->o_terms = o_terms;
        return sub_list;
      }
  else
       type_error(sub_list,"SUB_LIST","write_o_terms_inSubList");
 }

/* remain */
SubList* write_remain_inSubList(sub_list,remain)
   SubList*     sub_list;
   Remain*      remain;
{
   if(sub_list == NULL)
     write_through_NULL("write_remain");
   else if(is_sub_list_non_NULL(sub_list))
     {
        sub_list->remain = remain;
        return sub_list;
      }
  else
       type_error(sub_list,"SUB_LIST","write_remain");
 }

/*** new ***/
SubList*   new_sub_list()
{
  SubList*     sub_list;

  sub_list = (SubList*)dotsrc_malloc(sizeof(SubList));
  sub_list->tag = SUB_LIST;
  sub_list->o_terms = NULL;
  sub_list->remain = NULL;
  return   sub_list;
 }

/*** insert ***/
SubList*   insert_o_terms_inSubList(sub_list,o_terms)
  SubList      *sub_list;
  ObjList      *o_terms;
{
   if(sub_list == NULL)
      write_through_NULL("insert_o_terms_inSubList");
   else if(is_sub_list_non_NULL(sub_list))
     if(sub_list->o_terms == NULL)
      {
         sub_list->o_terms = o_terms;
         return  sub_list;
      }
    else
      {  
       insert_list_to_obj_list(sub_list->o_terms,o_terms);
       return   sub_list;
     }
  else
    type_error(sub_list,"SUB_LIST","insert_o_terms_inSubList");
}

/*** add  ***/
SubList*   add_o_terms_inSubList(sub_list,o_terms)
  SubList      *sub_list;
  ObjList      *o_terms;
{
   if(sub_list == NULL)
      write_through_NULL("add_o_terms_inSubList");
   else if(is_sub_list_non_NULL(sub_list))
     if(sub_list->o_terms == NULL)
      {
         sub_list->o_terms = o_terms;
         return  sub_list;
      }
    else
      {  
       concat_list_to_obj_list(sub_list->o_terms,o_terms);
       return   sub_list;
     }
  else
    type_error(sub_list,"SUB_LIST","add_o_terms_inSubList");
}

/*** car ***/
OTerm    *car_of_o_terms_inSubList(sub_list)
   SubList    *sub_list;
{
    if (sub_list == NULL || sub_list->o_terms == NULL)
      return NULL;
    else
      return (OTerm*)extract_first_list_element(sub_list->o_terms);
  }

/*** delete ***/
void   delete_sub_list(sub_list)
  SubList*     sub_list;
{
   if(sub_list != NULL)
     if(is_sub_list_non_NULL(sub_list))
       {
         if(sub_list->o_terms != NULL)
            delete_obj_list(sub_list->o_terms);
         if(sub_list->remain != NULL)
            delete_remain(sub_list->remain);
         dotsrc_free((char*)sub_list);
       }
}  

/**********************/
/*   remain(union)    */
/**********************/
/*** fis ***/
Bool fis_remain(object)
    PseudoObject*   object;
{
       return object == NULL || object->tag == REMAIN || fis_list(object) ||
       fis_var(object);
}

/***  create ***/
  Remain*   create_remain_list(list)
     List*    list;
{
     List*       new_list;

     if(list == NULL)
       write_through_NULL("create_remain_list");
     else
       {
            new_list = copy_list(list);
            delete_list(list);
            return (Remain*)new_list;
	  }
   }

Remain*   create_remain_var(var)
  Var*  var;  
{
     Var*        new_var;

     if(var == NULL)
       write_through_NULL("create_remain_var");
     else
       {
            new_var = copy_var(var);
            delete_var(var);
            return    (Remain*)new_var;
	  }
   }

/*** copy ***/
Remain* copy_remain(remain)
  Remain*   remain;
{
  Remain*   new_remain;

  if(remain == NULL)
     return NULL;
  else
       {
          if(is_list(remain))
            {
                new_remain =  (Remain*)copy_list((List*)remain);
                return  new_remain;
	    }
          else if(is_var(remain))
            return  (Remain*)copy_var((Var*)remain);
          else if(is_remain(remain))
	    {
               new_remain = (Remain*)dotsrc_malloc(sizeof(Remain));
               new_remain->tag = REMAIN;
               return  new_remain;
	     }
          else
           type_error(remain,"remain","copy_remain");
	 }
}

/*** new ***/
Remain*    new_remain()
{

    Remain*   remain;

 remain = (Remain*)dotsrc_malloc(sizeof(Remain));
 remain->tag = REMAIN;
        return  remain;
}

/*** delete ***/
void  delete_remain(remain)
  Remain*   remain;
{
   if(remain != NULL)
       {
           if(is_list(remain))         
               delete_list((List*)remain);
           else if(is_var(remain))
               delete_var((Var*)remain);
           else if(is_remain(remain))
               dotsrc_free((char*)remain);
           else
             type_error(remain,"REMAIN","delete_remain");

	 }
}

/**************************/
/*   non_struct (union)   */
/**************************/
/*** fis ***/
Bool fis_non_struct(object)
    PseudoObject*   object;
{
       return object == NULL || object->tag == NON_STRUCT ||
       object->tag == EXP_NAME || object->tag == STRING || 
       object->tag == INTEGER;
}

/***  create ***/
NonStruct*   create_non_struct_exp_name(exp_name)
  ExpName*    exp_name;  
     
{
     ExpName*        new_exp_name;

     if(exp_name == NULL)
       write_through_NULL("create_non_struct_exp_name");
     else
       {
            new_exp_name = copy_exp_name(exp_name);
            delete_exp_name(exp_name);
            return   (NonStruct*)new_exp_name;
	  }
   }

  NonStruct*   create_non_struct_string(string)
     String*    string;
{
     String*        new_string;

     if(string == NULL)
       write_through_NULL("create_non_struct_string");
     else
       {
            new_string = copy_string(string);
            delete_string(string);
            return   (NonStruct*)new_string;
	  }
   }

  NonStruct*   create_non_struct_integer(integer)
          Integer*        integer;
{
     Integer*       new_integer;

     if(integer == NULL)
       write_through_NULL("create_non_struct_integer");
     else
       {
            new_integer = copy_integer(integer);
            delete_integer(integer);
            return    (NonStruct*)new_integer;
	  }
   }

/*** copy ***/
NonStruct* copy_non_struct(non_struct)
  NonStruct*   non_struct;
{
  NonStruct*   new_non_struct;

  if(non_struct == NULL)
     return NULL;
  else
     switch(non_struct->tag)
       {
          case  NON_STRUCT:
	   {
              new_non_struct = (NonStruct*)dotsrc_malloc(sizeof(NonStruct));
              new_non_struct->tag = NON_STRUCT;
              return   new_non_struct;
           }
          case  EXP_NAME: 
           return  (NonStruct*)copy_exp_name((ExpName*)non_struct);
          case  STRING:
           return  (NonStruct*)copy_string((String*)non_struct);
          case  INTEGER:
           return  (NonStruct*)copy_integer((Integer*)non_struct);
	  default:
              type_error(non_struct,"NON_STRUCT","copy_non_struct");
          break;
       }
}

/*** new ***/
NonStruct*   new_non_struct()
{

    NonStruct*   non_struct;

         non_struct = (NonStruct*)dotsrc_malloc(sizeof(NonStruct));
         non_struct->tag = NON_STRUCT;
         return  non_struct;
 }

/*** delete ***/
void  delete_non_struct(non_struct)
  NonStruct*   non_struct;
{
   if(non_struct != NULL)
       switch(non_struct->tag)
	 {
	    case  NON_STRUCT:
                  dotsrc_free((char*)non_struct);
            case  EXP_NAME:
                 delete_exp_name((ExpName*)non_struct);
                 break;
            case  STRING:
                 delete_string((String*)non_struct);
                 break;
            case  INTEGER:
                 delete_integer((Integer*)non_struct);
                 break;
	    default:
                 type_error(non_struct,"NON_STRUCT","delete_non_struct");
         }
}

/**********************/
/*   exp_name         */
/**********************/
/*** fis ***/
Bool fis_exp_name(object)
    PseudoObject*   object;
{
       return object == NULL || object->tag == EXP_NAME;
}

/*** decompose ***/
void  decompose_exp_name(exp_name,name)
   ExpName*    exp_name;
   char**      name;
{
   if (exp_name == NULL)
       *name = NULL;
  else if(is_exp_name_non_NULL(exp_name))
           *name = exp_name->name;
  else
   type_error(exp_name,"EXP_NAME","decompose_exp_name"); 
 }

/*** create ***/
ExpName*  create_exp_name(name)
   char*    name;
{
    ExpName*     exp_name;
 
  exp_name = (ExpName*)dotsrc_malloc(sizeof(ExpName));
  exp_name->tag = EXP_NAME;
       exp_name->name = name;
  return   exp_name;
 }

/*** copy ***/
ExpName*   copy_exp_name(exp_name)
  ExpName*    exp_name;
{
    ExpName*    new_exp_name;

  if(exp_name == NULL)
    return  NULL;
  else
    {
     new_exp_name = (ExpName*)dotsrc_malloc(sizeof(ExpName));
     new_exp_name->tag = exp_name->tag;
     if(exp_name->name != NULL)
        new_exp_name->name = dotsrc_strdup(exp_name->name);
     else
         new_exp_name->name = NULL;
     return   new_exp_name;
   }
 }

/*** set ***/
ExpName*    set_exp_name(exp_name,name)
   ExpName*     exp_name;
   char*        name;
{
  if(exp_name == NULL)
    write_through_NULL("set_exp_name");
  if(! is_exp_name_non_NULL(exp_name))
    type_error(exp_name,"EXP_NAME","set_exp_name");
  else
     exp_name->name = name;
  return  exp_name;
}   

/*** new ***/
ExpName*   new_exp_name()
{
  ExpName*      exp_name;

  exp_name = (ExpName*)dotsrc_malloc(sizeof(ExpName));
  exp_name->tag = EXP_NAME;
  exp_name->name = NULL;
  return   exp_name;
 }

/*** delete ***/
void   delete_exp_name(exp_name)
  ExpName*      exp_name;
{
   if(exp_name != NULL)
     if(is_exp_name_non_NULL(exp_name))
       {
         if(exp_name->name != NULL)
            dotsrc_free(exp_name->name);
         dotsrc_free((char*)exp_name);
       }
}  

/**********************/
/*   integer          */
/**********************/
/*** fis ***/
Bool fis_integer(object)
    PseudoObject*   object;
{
       return object == NULL || object->tag == INTEGER;
}

/*** decompose ***/
void  decompose_integer(integer,value)
   Integer*   integer;
   int*       value;
{
   if (integer == NULL)
       *value = NULL;
  else if(is_integer_non_NULL(integer))
       *value = integer->value;
  else
   type_error(integer,"INTEGER","decompose_integer"); 
 }

/*** create ***/
Integer*  create_integer(value)
 int    value;
{
   Integer*    integer;
 
  integer = (Integer*)dotsrc_malloc(sizeof(Integer));
  integer->tag = INTEGER;
  integer->value = value;
  return  integer;
 }

/*** copy ***/
Integer*   copy_integer(integer)
   Integer*    integer;
{
   Integer*    new_integer;
  
  if(integer == NULL)
    return  NULL;
  else
    {
     new_integer = (Integer*)dotsrc_malloc(sizeof(Integer));
     new_integer->tag = integer->tag;
     new_integer->value = integer->value;
     return   new_integer;
   }
 }

/*** set ***/
Integer*    set_integer(integer,value)
  Integer*   integer;
  int        value;
{
  if(integer == NULL)
    write_through_NULL("set_integer");
  if(! is_integer_non_NULL(integer))
    type_error(integer,"INTEGER","set_integer");
  integer->value = value;
  return  integer;
}   
/*** new ***/
Integer*   new_integer()
{
   Integer*   integer;

  integer = (Integer*)dotsrc_malloc(sizeof(Integer));
  integer->tag = INTEGER;
  integer->value = NULL;
  return  integer;
 }

/*** delete ***/
void   delete_integer(integer)
  Integer*   integer;
{
   if(integer != NULL)
     if(is_integer_non_NULL(integer))
         dotsrc_free((char*)integer);
}  

/**********************/
/*   attr             */
/**********************/
/*** fis ***/
Bool   fis_attr(object)
  PseudoObject*    object;
{
   return object == NULL || object->tag == ATTR;
 }

/*** decompose ***/
void  decompose_attr(attr,label,attr_op,value)
  Attr*     attr;
  Label**    label;
  AttrOp*    attr_op;
  Value**    value;
{
   if (attr == NULL)
     {
       *label = NULL;
       *attr_op = NULL;
       *value = NULL;
     }
  else if(is_attr_non_NULL(attr))
    {
       *label = attr->label;
       *attr_op = attr->attr_op;
       *value = attr->value;
     }
  else
   type_error(attr,"ATTR","decompose_attr"); 
 }

/*** read ***/
/* label */
Label*  read_label_inAttr(attr)
  Attr*   attr;
{
   if(attr == NULL)
     return NULL;
  else if(is_attr_non_NULL(attr))
    return  attr->label;
  else
    type_error(attr,"ATTR","read_label_inAttr");
 }

/* attr_op */
AttrOp  read_attr_op(attr)
  Attr*   attr;
{
   if(attr == NULL)
     return NULL;
  else if(is_attr_non_NULL(attr))
    return  attr->attr_op;
  else
    type_error(attr,"ATTR","read_attr_op");
 }

/* value */
Value*  read_value(attr)
  Attr*   attr;
{
   if(attr == NULL)
     return NULL;
  else if(is_attr_non_NULL(attr))
    return  attr->value;
  else
    type_error(attr,"ATTR","read_value");
 }

/*** create ***/
Attr*  create_attr(label,attr_op,value)
  Label*    label;
  AttrOp    attr_op;
  Value*    value;
{
  Attr*     attr;
 
  attr = (Attr*)dotsrc_malloc(sizeof(Attr));
  attr->tag = ATTR;
  attr->label = label;
  attr->attr_op = attr_op;
  attr->value = value;
  return  attr;
 }

/*** copy ***/
Attr*   copy_attr(attr)
   Attr*       attr;
{
   Attr*       new_attr;
  
  if(attr == NULL)
    return  NULL;
  else
    {
     new_attr = (Attr*)dotsrc_malloc(sizeof(Attr));
     new_attr->tag = attr->tag;
     new_attr->label = copy_label(attr->label);
     new_attr->attr_op = attr->attr_op;
     new_attr->value = copy_value(attr->value);
     return   new_attr;
   }
 }

/*** set ***/
Attr*   set_attr(attr,label,attr_op,value)
  Attr*     attr;
  Label*    label;
  AttrOp    attr_op;
  Value*    value;
{
  if(attr == NULL)
    write_through_NULL("set_attr");
  if(! is_attr_non_NULL(attr))
    type_error(attr,"ATTR","set_attr");
  if(! is_label(label))
    type_error(label,"LABEL","set_attr");    
  if(! is_value(value))
    type_error(value,"VALUE","set_attr");
  attr->label = label;
  attr->attr_op = attr_op;
  attr->value = value;
  return  attr;
}

/*** write ***/
/* label */
Attr* write_label_inAttr(attr,label)
  Attr*    attr;
  Label*   label;
{
   if(attr == NULL)
     write_through_NULL("write_label_inAttr");
   else if(is_attr_non_NULL(attr))
     {
        attr->label = label;
        return attr;
      }
  else
       type_error(attr,"ATTR","write_label_inAttr");
 }

/* attr_op */
Attr* write_attr_op(attr,attr_op)
  Attr*    attr;
  AttrOp   attr_op;
{
   if(attr == NULL)
     write_through_NULL("write_attr_op");
   else if(is_attr_non_NULL(attr))
     {
        attr->attr_op = attr_op;
        return attr;
      }
  else
       type_error(attr,"ATTR","write_attr_op");
 }

/* value */
Attr* write_value(attr,value)
  Attr*    attr;
  Value*   value;
{
   if(attr == NULL)
     write_through_NULL("write_value");
   else if(is_attr_non_NULL(attr))
     {
        attr->value = value;
        return attr;
      }
  else
       type_error(attr,"ATTR","write_value");
 }

/*** new ***/
Attr*   new_attr()
{
   Attr*   attr;

   attr = (Attr*)dotsrc_malloc(sizeof(Attr));
   attr->tag = ATTR;
   attr->label = NULL;
   attr->value = NULL;
   return  attr;
 }

/*** delete ***/
void   delete_attr(attr)
  Attr*        attr;
{


  if(attr != NULL)
   if(is_attr_non_NULL(attr))
     {
       delete_label(attr->label);
       delete_value(attr->value);
       dotsrc_free((char*)attr);
     }
}
