#define Public
#define Local static

#define TRUE (0==0)
#define FALSE (!TRUE)

/** read write macro prototypes **/

#define mread(OBJECT, STRUCT_IN_STRING, IS_NON_NULL, MEMBER, MACRO) \
  ((OBJECT) == NULL \
   ? NULL \
   : IS_NON_NULL((OBJECT)) \
       ? (OBJECT)->MEMBER \
       : (type_error((OBJECT), (STRUCT_IN_STRING), (MACRO)), \
	  (OBJECT)->MEMBER))

#define mwrite(OBJECT, ARG, STRUCT_IN_STRING, IS_NON_NULL, MEMBER, MACRO) \
  ((OBJECT) == NULL \
   ? (write_through_NULL((MACRO)), (OBJECT)) \
   : IS_NON_NULL((OBJECT)) \
     ? ((OBJECT)->MEMBER = (ARG), (OBJECT)) \
     : (type_error((OBJECT), (STRUCT_IN_STRING), (MACRO)), (OBJECT)))

/** memory management macros and tyep definitions **/

#include "mdebug.h"

#ifdef MALLOC_DEBUG
#define dotsrc_malloc(A)   dotsrc_dmalloc(A)
#define dotsrc_calloc(A,B) dotsrc_dcalloc(A,B)
#define dotsrc_free(A)     dotsrc_dfree(A)
#else
#define dotsrc_malloc(A)   dotsrc_cmalloc(A)
#define dotsrc_calloc(A,B) dotsrc_ccalloc(A,B)
#define dotsrc_free(A)     dotsrc_cfree(A)
#endif

typedef enum {Malloc, Calloc} AllocType;

typedef struct malloc_log {
    AllocType tag;
    char* ptr;
    int size;
} MallocLog;

typedef struct calloc_log {
    AllocType tag;
    char* ptr;
    int nelem;
    int elsize;
} CallocLog;

typedef union alloc_log {
    AllocType tag;
    MallocLog malloc_log;
    CallocLog calloc_log;
} AllocLog;

/** declarations for common functions **/

char*         type_name();

Bool          is_type();

void          print_program();
void          print_env_def();
void          print_def_lib();
void          print_string();
void          print_exp_def();
void          print_exp();
void          print_obj_def();
void          print_obj_sub();
void          print_mod_def();
void          print_m_sub();
void          print_m_desc();
void          print_m2_desc();
void          print_o_term();
void          print_link_def();
void          print_link();
void          print_m_id_pair();
void          print_o_term_pair();
void          print_rule_def();
void          print_rule();
void          print_rule_id();
void          print_cluster();
void          print_normal();
void          print_rel();
void          print_update();
void          print_transaction();
void          print_i_check();
void          print_prop();
void          print_a_term();
void          print_o_term();
void          print_c_o_term();
void          print_dot();
void          print_label();
void          print_lab();
void          print_list();
void          print_sub_list();
void          print_remain();
void          print_non_struct();
void          print_exp_name();
void          print_integer();
void          print_attr();
void          print_value();
void          print_set();
void          print_cnstr();
void          print_cnstr_data();
void          print_query_cnstr();
void          print_var();
void          print_sort();
void          print_query();
void          print_q_mode();
void          print_p_mode();
void          print_a_mode();
void          print_i_mode();
void          print_m_mode();
void          print_e_mode();
void          print_answer();
void          print_answer_element();
void	      print_anse_explanation();
void	      print_rir_pair();
void          print_dot_cnstr();
void          print_var_cnstr();
void          print_explanation();
void          print_explanation_data();
void          print_lookup();
void          print_unit_explanation();
void          print_unit_exp_data();
void          print_inherit();
void          print_up_down();
void          print_merge_explanation();
void          print_lookup_explanation();
void          print_one_rule();
void          print_fact();
void          print_reduce();
void          print_sub_goal();
void          print_vc_pair();
void          print_constraint();
void          print_con();
void          print_assump();
void          print_query_explanation();
void          print_obj_list();
void          print_obj_array();
void          print_pseudo_object();

void          delete_pseudo_object();

PseudoObject* copy_pseudo_object();

void          type_error();
void          type_conflict();
void          write_through_NULL();
void          illegal_type_descriptor();

char*         dotsrc_cmalloc();
char*         dotsrc_ccalloc();
void          dotsrc_cfree();
char*         dotsrc_strdup();

char*         dotsrc_dmalloc();
char*         dotsrc_dcalloc();
void          dotsrc_dfree();
void          check_memory_usage();

char*         malloc();
char*         calloc();
