/*
/*	(C)1992, 1993, 1995 Institute for New Generation Computer Technology
/*		ۤ¾COPYRIGHTե򻲾ȤƲ
/*		(Read COPYRIGHT for detailed information.)
 */
/***********************************************************************
 *   FILE NAME
 *	shp_print.c
 *   DESCRIPTION
 *	ޥץݻ
 *   INTERFACE ROUTINES
 *      shp_CDataPrint
 *   NOTES       
 *	
 *$  EDITOR : Tooru Shida
 *$           (MITSUBISHI ELECTRIC COMPUTER SYSTEMS (TOKYO) CORPORATION)
 *$  CREATE : '94-03-22 Tue
 *$  UPDATE : 
 ***********************************************************************/

#include <stdio.h>
#include <klic/gdobject.h>
#include <klic/gd_macro.h>
#include "shp.h"
#include "shp_print.h"

/* --------------------------------------------------------------------
 *    shp_CDataPrint
 *
 *      KLICǡȤɽƤ륹޾ɸϤ˰
 *      
 *      ARGUMENT: c_info    : ޾(C Language data)
 * 
 *      RETURN:  ʤ
 *
 * --------------------------------------------------------------------
 */

void
shp_CDataPrint(struct shp_SchemaInfo *c_info, FILE *g_fp)
{
    switch(c_info->type) {
    case Table:
	print_table_info(c_info->sch_info->table_info, g_fp);
	break;
    case Group:
	/* FALL THROUGH */
    case Repeat_Group:
	print_group_info(c_info->sch_info->attr_info1, g_fp);
	break;
    case Simple:
	/* FALL THROUGH */
    case Repeat_Simple:
	print_simple_info(c_info->sch_info->attr_info2, g_fp);
	break;
    case Index:
	print_index_info(c_info->sch_info->index_info, g_fp);
	break;
    default:
	break;
    }
}


/* --------------------------------------------------------------------
 *    print_table_info
 *
 *      ARGUMENT: table_info    : ơ֥륹޾(C Language data)
 * 
 *      RETURN:  ʤ
 *
 * --------------------------------------------------------------------
 */

void
print_table_info(struct shp_TableSchemaInfo *table_info, FILE *g_fp)
{
    GD_PUTC('{');
    GD_PRINT("table, ");
    GD_PRINTF("%s, ", table_info->table_name);
    print_table_key(table_info->table_key_info, g_fp);
    print_nil_request(table_info->nil_request, g_fp);
    print_direct_del_flag(table_info->direct_del_flag, g_fp);
    GD_PRINTF("%d, ", table_info->child_attr_cnt);
    print_child_info(table_info->child_attr_info, g_fp);
    print_nest_seq(table_info->nest_seq, g_fp);
    GD_PRINT("horizontal_info(KLIC_DATA)");
/*    GD_PRINT_KL1_TERM(table_info->horizontal_info); */
    GD_PUTC('}');
}


/* --------------------------------------------------------------------
 *    print_group_info
 *
 *      ARGUMENT: group_info    : °(C Language data)
 * 
 *      RETURN:  ʤ
 *
 * --------------------------------------------------------------------
 */

void
print_group_info(struct shp_AttrInfo1 *group_info, FILE *g_fp)
{
    GD_PUTC('{');
    if ( group_info->type == Group ) {
	GD_PRINT("group, ");
    } else {
	GD_PRINT("repeat_group, ");
    }
    GD_PRINTF("%s, ", group_info->attr_name);
    GD_PRINTF("%d, ", group_info->attr_id);
    print_access_path(group_info->acc_path, g_fp);
    print_nil_request(group_info->nil_request, g_fp);
    print_direct_del_flag(group_info->direct_del_flag, g_fp);
    print_set_key(group_info->set_key_info, g_fp);
    GD_PRINTF("%d, ", group_info->occ_depth);
    GD_PRINTF("%s, ", group_info->parent_info);
    print_repeating_path(group_info->repeating_path, g_fp);
    GD_PRINTF("%d, ", group_info->child_attr_cnt);
    print_child_info(group_info->child_attr_info, g_fp);
    GD_PRINTF("%d", group_info->next_nint_posi);
    GD_PUTC('}');
}


/* --------------------------------------------------------------------
 *    print_simple_info
 *
 *      ARGUMENT: simple_info    : ñ°(C Language data)
 * 
 *      RETURN:  ʤ
 *
 * --------------------------------------------------------------------
 */

void
print_simple_info(struct shp_AttrInfo2 *simple_info, FILE *g_fp)
{
    GD_PUTC('{');
    if ( simple_info->type == Simple ) {
	GD_PRINT("simple, ");
    } else if ( simple_info->type == Repeat_Simple ) {
	GD_PRINT("repeat_simple, ");
    } else {
	GD_PRINT("simple_integer, ");
    }
    GD_PRINTF("%s, ", simple_info->attr_name);
    GD_PRINTF("%d, ", simple_info->attr_id);
    print_access_path(simple_info->acc_path, g_fp);
    print_data_type(simple_info->data_type, g_fp);
    GD_PRINTF("%d, ", simple_info->max_length);
    print_key_request(simple_info->key_request, g_fp);
    print_access_request(simple_info->acc_request, g_fp);
    print_nil_request(simple_info->nil_request, g_fp);
    print_foreign_key(simple_info->foreign_key, g_fp);
    GD_PRINTF("%d, ", simple_info->overflow);
    GD_PRINTF("%d, ", simple_info->occ_depth);
    GD_PRINTF("%s, ", simple_info->parent_info);
    print_repeating_path(simple_info->repeating_path, g_fp);
    GD_PRINTF("%d", simple_info->next_nint_posi);
    GD_PUTC('}');
}


/* --------------------------------------------------------------------
 *    print_index_info
 *
 *      ARGUMENT: index_info    : ǥå°(C Language data)
 * 
 *      RETURN:  ʤ
 *
 * --------------------------------------------------------------------
 */

void
print_index_info(struct shp_IndexInfo *index_info, FILE *g_fp)
{
    GD_PUTC('{');
    GD_PRINT("index, ");
    GD_PRINTF("%s, ", index_info->attr_name);
    GD_PRINTF("%d, ", index_info->attr_id);
    GD_PRINTF("%d, ", index_info->index_id);
    GD_PRINTF("%s", index_info->base_attr_name);
    GD_PUTC('}');
}


/* --------------------------------------------------------------------
 *    print_table_key
 *
 *      ARGUMENT: table_key    : ơ֥륭(C Language data)
 * 
 *      RETURN:  ʤ
 *
 * --------------------------------------------------------------------
 */

void
print_table_key(struct shp_TableKeyInfo *table_key_info, FILE *g_fp)
{
    GD_PUTC('[');
    if ( table_key_info != NULL ) {
	GD_PRINTF("%d", table_key_info->attr_posi);
	table_key_info = table_key_info->next;
    }
    while( table_key_info != NULL ) {
	GD_PRINT(", ");
	GD_PRINTF("%d", table_key_info->attr_posi);
	table_key_info = table_key_info->next;
    }
    GD_PUTC(']');
    GD_PRINT(", ");
}



/* --------------------------------------------------------------------
 *    print_nil_request
 *
 *      ARGUMENT: nil_request    : ͻ
 * 
 *      RETURN:  ʤ
 *
 * --------------------------------------------------------------------
 */

void
print_nil_request(enum shp_NilRequest nil_request, FILE *g_fp)
{
    switch( nil_request ) {
    case Not_Allowed:
	GD_PRINT("not_allowed");
	break;
    case Allowed:
	GD_PRINT("allowed");
	break;
    case Not_Nil:
	GD_PRINT("not_nil");
	break;
    case Not_Bottom:
	GD_PRINT("not_bottom");
	break;
    default:
	break;
    }
    GD_PRINT(", ");
}


/* --------------------------------------------------------------------
 *    print_direct_del_flag
 *
 *      ARGUMENT: direct_del_flag    : ľܺ
 * 
 *      RETURN:  ʤ
 *
 * --------------------------------------------------------------------
 */

void
print_direct_del_flag(enum shp_DirectDelFlag direct_del_flag, FILE *g_fp)
{
    switch( direct_del_flag ) {
    case Off:
	GD_PRINT("off");
	break;
    case On:
	GD_PRINT("on");
	break;
    default:
	break;
    }
    GD_PRINT(", ");
}


/* --------------------------------------------------------------------
 *    print_child_info
 *
 *      ARGUMENT: chlid_info    : °
 * 
 *      RETURN:  ʤ
 *
 * --------------------------------------------------------------------
 */

void
print_child_info(struct shp_ChildInfo *child_attr_info, FILE *g_fp)
{
    GD_PUTC('{');
    if ( child_attr_info != NULL ){ 
	print_child_attr_element(child_attr_info, g_fp);
	child_attr_info = child_attr_info->next;
    }
    while ( child_attr_info != NULL ) {    
	GD_PRINT(", ");
	print_child_attr_element(child_attr_info, g_fp);
	child_attr_info = child_attr_info->next;
    }
    GD_PUTC('}');
    GD_PRINT(", ");
}	    


void
print_child_attr_element(struct shp_ChildInfo *child_attr_info, FILE *g_fp)
{
    switch( child_attr_info->type ) {
    case Group:
	/* FALL THROUGH */
    case Repeat_Group:
	print_group_info(child_attr_info->attr_info.info1, g_fp);
	break;
    case Simple:
	/* FALL THROUGH */
    case Repeat_Simple:
	/* FALL THROUGH */
    case Simple_Integer:
	print_simple_info(child_attr_info->attr_info.info2, g_fp);
	break;
    dafault:
	break;
    }
}


/* --------------------------------------------------------------------
 *    print_nest_seq
 *
 *      ARGUMENT: nest_seq    : ͥȥ
 * 
 *      RETURN:  ʤ
 *
 * --------------------------------------------------------------------
 */

void
print_nest_seq(struct shp_NestSequence *nest_seq, FILE *g_fp)
{
    GD_PUTC('[');
    if ( nest_seq != NULL ) {
	GD_PRINTF("%s", nest_seq->attr_name);
	nest_seq = nest_seq->next;
    }
    while( nest_seq != NULL ) {
	GD_PRINT(", ");
	GD_PRINTF("%s", nest_seq->attr_name);
	nest_seq = nest_seq->next;
    }
    GD_PUTC(']');
    GD_PRINT(", ");
}
    

/* --------------------------------------------------------------------
 *    print_access_path
 *
 *      ARGUMENT: acc_path   : ѥ
 * 
 *      RETURN:  ʤ
 *
 * --------------------------------------------------------------------
 */

void
print_access_path(struct shp_AccessPath *acc_path, FILE *g_fp)
{
    GD_PUTC('[');
    if ( acc_path != NULL ) {
	print_access_path_element(acc_path, g_fp);
	acc_path = acc_path->next;
    }
    while( acc_path != NULL ) {
	GD_PRINT(", ");
	print_access_path_element(acc_path, g_fp);
	acc_path = acc_path->next;
    }
    GD_PUTC(']');
    GD_PRINT(", ");
}
    
void
print_access_path_element(struct shp_AccessPath *acc_path, FILE *g_fp)
{
    GD_PUTC('{');
    GD_PRINTF("%s, ", acc_path->attr_name);
    if ( acc_path->repeat == Set ) {
	GD_PRINT("set, ");
    } else {
	GD_PRINT("single, ");
    }
    GD_PRINTF("%d, ", acc_path->position);
    GD_PRINTF("%d", acc_path->next_nint_posi);
    GD_PUTC('}');
}


/* --------------------------------------------------------------------
 *    print_repeating_path
 *
 *      ARGUMENT: repeating_path   : ԡƥ󥰥ѥ
 * 
 *      RETURN:  ʤ
 *
 * --------------------------------------------------------------------
 */

void
print_repeating_path(struct shp_RepPath *repeating_path, FILE *g_fp)
{
    GD_PUTC('[');
    if ( repeating_path != NULL ) {
	GD_PRINTF("%d", repeating_path->attr_id);
	repeating_path = repeating_path->next;
    }
    while( repeating_path != NULL ) {
	GD_PRINT(", ");
	GD_PRINTF("%d", repeating_path->attr_id);
	repeating_path = repeating_path->next;
    }
    GD_PUTC(']');
    GD_PRINT(", ");
}

    
/* --------------------------------------------------------------------
 *    print_data_type
 *
 *      ARGUMENT: data_type      : ǡ
 * 
 *      RETURN:  ʤ
 *
 * --------------------------------------------------------------------
 */

void
print_data_type(enum shp_DataType data_type, FILE *g_fp)
{
    switch( data_type ) {
    case String:
	GD_PRINT("string");
	break;
    case Integer:
	GD_PRINT("integer");
	break;
    case Float:
	GD_PRINT("float");
	break;
    case Double:
	GD_PRINT("double");
	break;
    case Term:
	GD_PRINT("term");
	break;
    case Psi_String:
	GD_PRINT("psi_string");
	break;
    defalut:
	break;
    }
    GD_PRINT(", ");
}


/* --------------------------------------------------------------------
 *    print_key_request
 *
 *      ARGUMENT: key_request      : 
 * 
 *      RETURN:  ʤ
 *
 * --------------------------------------------------------------------
 */

void
print_key_request(enum shp_KeyRequest key_request, FILE *g_fp)
{
    switch( key_request ) {
    case Non_Key:
	GD_PRINT("non_key");
	break;
    case Table_Key:
	GD_PRINT("table_key");
	break;
    case Set_Key:
	GD_PRINT("set_key");
	break;
    case Primary_Key:
	GD_PRINT("primary_key");
	break;
    default:
	break;
    }
    GD_PRINT(", ");
}


/* --------------------------------------------------------------------
 *    print_foreign_key
 *
 *      ARGUMENT: foreign_key      : 
 * 
 *      RETURN:  ʤ
 *
 * --------------------------------------------------------------------
 */

void
print_foreign_key(struct shp_ForeignKey *foreign_key, FILE *g_fp)
{
    GD_PUTC('{');
    GD_PRINTF("%s, ", foreign_key->table_name);
    GD_PRINTF("%s, ", foreign_key->attr_name);
    print_reference_rule(foreign_key->delete_rule, g_fp);
    GD_PRINT(", ");
    print_reference_rule(foreign_key->replace_rule, g_fp);
    GD_PRINT("}, ");
}

void
print_reference_rule(enum shp_ReferenceRule reference_rule, FILE *g_fp)
{
    switch( reference_rule ) {
    case Cascades:
	GD_PRINT("cascades");
	break;
    case Restricted:
	GD_PRINT("restricted");
	break;
    case Nullifies:
	GD_PRINT("nullifies");
	break;
    default:
	break;
    }
}


/* --------------------------------------------------------------------
 *    print_access_request
 *
 *      ARGUMENT: access_request      : 
 * 
 *      RETURN:  ʤ
 *
 * --------------------------------------------------------------------
 */

void
print_access_request(struct shp_AccessRequest *acc_request, FILE *g_fp)
{
    GD_PUTC('{');
    if ( acc_request->index_id == 0 ) {
	GD_PRINT("not_indexed");
    } else {
	GD_PRINTF("%d", acc_request->index_id);
    }
    GD_PRINT(", [");
    print_index_attr(acc_request->ia_list, g_fp);
    GD_PRINT("]}, ");
}


void
print_index_attr(struct shp_IndexAttrList *ia_list, FILE *g_fp)
{
    if ( ia_list != NULL ) {
	print_index_attr_element(ia_list, g_fp);
	ia_list = ia_list->next;
    }
    while ( ia_list != NULL ) {
	GD_PUTC(',');
	print_index_attr_element(ia_list, g_fp);
	ia_list = ia_list->next;
    }
}


void
print_index_attr_element(struct shp_IndexAttrList *ia_list, FILE *g_fp)
{
    GD_PUTC('{');
    switch( ia_list->id ) {
    case Substr:
	GD_PRINT("substring, ");
	break;
    case Concat1:
	GD_PRINT("concat1, ");
	break;
    case Concat2:
	GD_PRINT("concat2, ");
	break;
    case Concat3:
	GD_PRINT("concat3, ");
	break;
    case Reverse:
	GD_PRINT("revrese, ");
	break;
    case Scan:
	GD_PRINT("scan, ");
	break;
    default:
	break;
    }
    GD_PRINTF("%s, ", ia_list->attr_name);
    GD_PRINTF("%d, ", ia_list->attr_id);
    GD_PRINTF("%d", ia_list->index_id);
    switch( ia_list->id ) {
    case Substr:
	GD_PRINTF(", %d, ", ia_list->index_attr->substr->position);
	GD_PRINTF("%d", ia_list->index_attr->substr->length);
	break;
    case Concat1:
	/* FALL THROUGH */
    case Concat2:
	GD_PRINTF(", %s", ia_list->index_attr->string_list);
	break;
    case Concat3:
	GD_PRINTF(", %s, ", ia_list->index_attr->concat3->string1);
	GD_PRINTF("%s", ia_list->index_attr->concat3->string2);
	break;
    case Scan:
	GD_PRINTF(", %d", ia_list->index_attr->length);
	break;
    default:
	break;
    }
    GD_PUTC('}');
}

/* --------------------------------------------------------------------
 *    print_set_key
 *
 *      ARGUMENT: set_key    : set_key
 * 
 *      RETURN:  ʤ
 *
 * --------------------------------------------------------------------
 */

void
print_set_key(struct shp_SetKeyInfo *set_key_info, FILE *g_fp)
{
    GD_PUTC('[');
    if ( set_key_info != NULL ) {
	GD_PRINTF("%d", set_key_info->attr_posi);
	set_key_info = set_key_info->next;
    }
    while( set_key_info != NULL ) {
	GD_PRINT(", ");
	GD_PRINTF("%d", set_key_info->attr_posi);
	set_key_info = set_key_info->next;
    }
    GD_PUTC(']');
    GD_PRINT(", ");
}
