/*
/*	(C)1992, 1993, 1995 Institute for New Generation Computer Technology
/*		ۤ¾COPYRIGHTե򻲾ȤƲ
/*		(Read COPYRIGHT for detailed information.)
 */
/***********************************************************************
 *   FILE NAME
 *	shp_convert.c
 *   DESCRIPTION
 *	KLICǡȤɽƤ륹޾򡢣øǡ
 *      Ѵ
 *   INTERFACE ROUTINES
 *      shp_ConvertKLIC2C
 *      
 *   NOTES  :
 *	
 *$  EDITOR : Tooru Shida
 *$           (MITSUBISHI ELECTRIC COMPUTER SYSTEMS (TOKYO) CORPORATION)
 *$  CREATE : '94-03-02 Wed
 *$  UPDATE : 
 ***********************************************************************/

#include <stdio.h>
#include "shp_convert.h"

/* --------------------------------------------------------------------
 *	shp_ConvertKLIC2C
 *
 *      KLICǡȤɽƤ륹޾Ϥøǡ
 *      Υ޾Ѵ
 *      
 *      ARGUMENT: klic_info : ޾(KLIC data struct)
 *                c_info    : ޾(C Language data)
 * 
 *      RETURN:  0 : 
 *              -1 : 顼
 *
 * --------------------------------------------------------------------
 */

int
shp_ConvertKLIC2C(q klic_info, struct shp_SchemaInfo *c_info)
{
    char *type;

    c_info->sch_info = (union shp_Info *) malloc(sizeof(union shp_Info));
    type = namestringof(shp_DerefOne(ELEMENT(klic_info, FIRST)));
    if ( !strcmp(type, TABLE) ) {
	c_info->type = Table;         /* ơ֥ */
	c_info->sch_info->table_info
	    = (struct shp_TableSchemaInfo *)
		malloc(sizeof(struct shp_TableSchemaInfo));
	convert_table_info(klic_info,
			   c_info->sch_info->table_info);
    } else if ( !strcmp(type, GROUP) ) {
	c_info->type = Group;         /* ° */
	c_info->sch_info->attr_info1
	    = (struct shp_AttrInfo1 *)
		malloc(sizeof(struct shp_AttrInfo1));
	c_info->sch_info->attr_info1->type = Group;
	convert_group_info(klic_info, 
			   c_info->sch_info->attr_info1);
    } else if ( !strcmp(type, REPEAT_GROUP) ) {
	c_info->type = Repeat_Group;  /* ֤° */
	c_info->sch_info->attr_info1
	    = (struct shp_AttrInfo1 *)
		malloc(sizeof(struct shp_AttrInfo1));
	c_info->sch_info->attr_info1->type = Repeat_Group;
	convert_group_info(klic_info,
			   c_info->sch_info->attr_info1);
    } else if ( !strcmp(type, SIMPLE) ) {
	c_info->type = Simple;        /* ñ° */
	c_info->sch_info->attr_info2
	    = (struct shp_AttrInfo2 *)
		malloc(sizeof(struct shp_AttrInfo2));
	convert_simple_info(klic_info,
			    c_info->sch_info->attr_info2);
	if ( c_info->sch_info->attr_info2->data_type == Integer ) {
	    c_info->sch_info->attr_info2->type = Simple_Integer;
	} else {
	    c_info->sch_info->attr_info2->type = Simple;
	}
    } else if ( !strcmp(type, REPEAT_SIMPLE) ) {
	c_info->type = Repeat_Simple; /* ֤ñ° */
	c_info->sch_info->attr_info2
	    = (struct shp_AttrInfo2 *)
		malloc(sizeof(struct shp_AttrInfo2));
	c_info->sch_info->attr_info2->type = Repeat_Simple;
	convert_simple_info(klic_info,
			    c_info->sch_info->attr_info2);
    } else if ( !strcmp(type, INDEX) ) {
	c_info->type = Index;         /* ǥåΤ° */
	c_info->sch_info->index_info
	    = (struct shp_IndexInfo *)
		malloc(sizeof(struct shp_IndexInfo));
	c_info->sch_info->index_info->type = Index;
	convert_index_info(klic_info,
			   c_info->sch_info->index_info);
    }
    return (NORMAL);
}
	 

/* --------------------------------------------------------------------
 *	convert_table_info
 *
 *      KLICǡȤɽƤơ֥롦޾ø
 *      ǡѴ롣
 *      
 *      RETURN:  0 : 
 *              -1 : 顼
 *
 * --------------------------------------------------------------------
 */

int	     
convert_table_info(q klic_info,
		   struct shp_TableSchemaInfo *table_info)
{
    table_info->type = Table;
    table_info->table_name
	= (char *)(namestringof(shp_DerefOne(ELEMENT(klic_info, SECOND))));
    if ( G_ISCONS(shp_DerefOne(ELEMENT(klic_info, THIRD))) ) {
	    /* ꥹȤɤȽ */
	table_info->table_key_info
	    = (struct shp_TableKeyInfo *)
		malloc(sizeof(struct shp_TableKeyInfo));
	convert_table_key_info(shp_DerefOne(ELEMENT(klic_info, THIRD)),
			       table_info->table_key_info);
    }
    table_info->nil_request 
	= convert_nil_request(shp_DerefOne(ELEMENT(klic_info, FOURTH)));
    table_info->direct_del_flag
	= convert_direct_del_flag(shp_DerefOne(ELEMENT(klic_info, FIFTH)));
    table_info->child_attr_cnt
	= G_INTVAL(shp_DerefOne(ELEMENT(klic_info, SIXTH)));
    table_info->child_attr_info
	= (struct shp_ChildInfo *) malloc(sizeof(struct shp_ChildInfo));
    convert_child_attr_info(shp_DerefOne(ELEMENT(klic_info, SEVENTH)),
			    table_info->child_attr_cnt,
			    table_info->child_attr_info);
    if ( G_ISCONS(shp_DerefOne(ELEMENT(klic_info, EIGHTH))) ) {
	/* ꥹȤɤȽ */
	table_info->nest_seq
	    = (struct shp_NestSequence *)
		malloc(sizeof(struct shp_NestSequence));
	convert_nest_seq(shp_DerefOne(ELEMENT(klic_info, EIGHTH)),
			 table_info->nest_seq);
    }
    table_info->horizontal_info = shp_DerefOne(ELEMENT(klic_info, NINETH));
}


/* --------------------------------------------------------------------
 *	convert_group_info
 *
 *      KLICǡȤɽƤ°޾󣱡ʽġ
 *      °ˤøǡѴ롣
 *      
 *      RETURN:  0 : 
 *              -1 : 顼
 *
 * --------------------------------------------------------------------
 */

int	     
convert_group_info(q klic_info,
		   struct shp_AttrInfo1 *group_info)
{
    group_info->attr_name
	= (char *)(namestringof(shp_DerefOne(ELEMENT(klic_info, SECOND))));
    group_info->attr_id = G_INTVAL(shp_DerefOne(ELEMENT(klic_info, THIRD)));
    group_info->acc_path
	= (struct shp_AccessPath *) malloc(sizeof(struct shp_AccessPath));
    if ( G_ISCONS(shp_DerefOne(ELEMENT(klic_info, FOURTH))) ) {
	convert_access_path(shp_DerefOne(ELEMENT(klic_info, FOURTH)),
			    group_info->acc_path);
    } else {
	group_info->acc_path = NULL;
    }
    group_info->nil_request 
	= convert_nil_request(shp_DerefOne(ELEMENT(klic_info, FIFTH)));
    group_info->direct_del_flag
	= convert_direct_del_flag(shp_DerefOne(ELEMENT(klic_info, SIXTH)));
    if ( G_ISCONS(shp_DerefOne(ELEMENT(klic_info, SEVENTH))) ) {
	group_info->set_key_info
	    = (struct shp_SetKeyInfo *) malloc(sizeof(struct shp_SetKeyInfo));
	convert_set_key_info(shp_DerefOne(ELEMENT(klic_info, SEVENTH)),
			     group_info->set_key_info);
    }
    group_info->occ_depth = G_INTVAL(shp_DerefOne(ELEMENT(klic_info, EIGHTH)));
    group_info->parent_info
	= (char *)(namestringof(shp_DerefOne(ELEMENT(klic_info, NINETH))));
    if ( G_ISCONS(shp_DerefOne(ELEMENT(klic_info, TENTH))) ) {
	group_info->repeating_path
	    = (struct shp_RepPath *) malloc(sizeof(struct shp_RepPath));
	convert_repeating_path(shp_DerefOne(ELEMENT(klic_info, TENTH)), 
			       group_info->repeating_path);
    }
    group_info->child_attr_cnt
	= G_INTVAL(shp_DerefOne(ELEMENT(klic_info, ELEVENTH)));
    group_info->child_attr_info
	= (struct shp_ChildInfo *) malloc(sizeof(struct shp_ChildInfo));
    convert_child_attr_info(shp_DerefOne(ELEMENT(klic_info,TWELFTH)),
			    group_info->child_attr_cnt,
			    group_info->child_attr_info);
    group_info->next_nint_posi
	= G_INTVAL(shp_DerefOne(ELEMENT(klic_info, THIRTEENTH)));
}


/* --------------------------------------------------------------------
 *	convert_simple_info
 *
 *      KLICǡȤɽƤ°޾󣲡ñ㡿
 *      ñ°ˤøǡѴ롣
 *      
 *      RETURN:  0 : 
 *              -1 : 顼
 *
 * --------------------------------------------------------------------
 */

int	     
convert_simple_info(q klic_info,
		    struct shp_AttrInfo2 *simple_info)
{
    q tmp;    /* Ȥ߹ߴؿȽ */

    simple_info->attr_name
	= (char *)(namestringof(shp_DerefOne(ELEMENT(klic_info, SECOND))));
    simple_info->attr_id = G_INTVAL(shp_DerefOne(ELEMENT(klic_info, THIRD)));
    simple_info->acc_path
	= (struct shp_AccessPath *) malloc(sizeof(struct shp_AccessPath));
    if ( G_ISCONS(shp_DerefOne(ELEMENT(klic_info, FOURTH))) ) {
	convert_access_path(shp_DerefOne(ELEMENT(klic_info, FOURTH)),
			    simple_info->acc_path);
    } else {
	simple_info->acc_path = NULL;
    }    
    simple_info->data_type
	= convert_data_type(shp_DerefOne(ELEMENT(klic_info, FIFTH)));
    if ( G_ISINT(shp_DerefOne(ELEMENT(klic_info, SIXTH))) ) {
	simple_info->max_length
	    = G_INTVAL(shp_DerefOne(ELEMENT(klic_info, SIXTH)));
    } else {
	simple_info->max_length = 0;
    }
    simple_info->key_request 
	= convert_key_request(shp_DerefOne(ELEMENT(klic_info, SEVENTH)));
    simple_info->acc_request = (struct shp_AccessRequest *)
	malloc(sizeof(struct shp_AccessRequest));
    tmp = shp_DerefOne(ELEMENT(klic_info, EIGHTH));
    if ( G_ISCONS(shp_DerefOne(ELEMENT(tmp, SECOND))) ) {
	/* Ȥ߹ߴؿΰ */
	simple_info->acc_request->ia_list
	    = (struct shp_IndexAttrList *)
		malloc(sizeof(struct shp_IndexAttrList));
	simple_info->acc_request->ia_list->index_attr
	    = (union shp_PredicateFunction *)
		malloc(sizeof(union shp_PredicateFunction));
    }
    convert_access_request(tmp, simple_info->acc_request);
    simple_info->nil_request
	= convert_nil_request(shp_DerefOne(ELEMENT(klic_info, NINETH)));
    simple_info->foreign_key = (struct shp_ForeignKey *)
	    malloc(sizeof(struct shp_ForeignKey));
    convert_foreign_key(shp_DerefOne(ELEMENT(klic_info, TENTH)),
			simple_info->foreign_key);
    simple_info->overflow = G_INTVAL(-1);    /* not_allowed */
    simple_info->occ_depth
	= G_INTVAL(shp_DerefOne(ELEMENT(klic_info, TWELFTH)));       
    simple_info->parent_info
	= (char *)(namestringof(shp_DerefOne(ELEMENT(klic_info, THIRTEENTH))));
    if ( G_ISCONS(shp_DerefOne(ELEMENT(klic_info, FOURTEENTH))) ) {
	simple_info->repeating_path
	    = (struct shp_RepPath *) malloc(sizeof(struct shp_RepPath));
	convert_repeating_path(shp_DerefOne(ELEMENT(klic_info, FOURTEENTH)),
			       simple_info->repeating_path);
    }
    simple_info->next_nint_posi
	= G_INTVAL(shp_DerefOne(ELEMENT(klic_info, FIFTEENTH)));
}


/* --------------------------------------------------------------------
 *	convert_index_info
 *
 *      KLICǡȤɽƤ륤ǥå°޾
 *      øǡѴ롣
 *      
 *      RETURN:  0 : 
 *              -1 : 顼
 *
 * --------------------------------------------------------------------
 */

int	     
convert_index_info(q klic_info,
		   struct shp_IndexInfo *index_info)
{
    index_info->attr_name
	= (char *)(namestringof(shp_DerefOne(ELEMENT(klic_info, SECOND))));
    /*°̾*/
    index_info->attr_id = G_INTVAL(shp_DerefOne(ELEMENT(klic_info, THIRD)));
    /*°ID*/
    index_info->index_id = G_INTVAL(shp_DerefOne(ELEMENT(klic_info, FOURTH)));
    /*ǥåID*/
    index_info->base_attr_name
	= (char *)(namestringof(shp_DerefOne(ELEMENT(klic_info, FIFTH))));
    /*°̾*/
}


/* --------------------------------------------------------------------
 *	convert_table_key_info
 *
 *      ơ֥륭Ѵ
 *      
 *      RETURN: ʤ
 *
 * --------------------------------------------------------------------
 */

void
convert_table_key_info(q table_key_klic, struct shp_TableKeyInfo *table_key_c)
{
    table_key_klic = shp_DerefOne(table_key_klic);

    while( table_key_klic != NILATOM ) {    /* ǽǤˤʤޤǥ롼 */
	/* ꥹǤøǡ(INTEGER)Ѵ */
	if ( G_ISINT(G_CAR_OF(table_key_klic)) ) {
	    table_key_c->attr_posi = G_INTVAL(G_CAR_OF(table_key_klic));
	}
	table_key_klic = G_CDR_OF(table_key_klic);
	table_key_klic = shp_DerefOne(table_key_klic);
	if ( table_key_klic != NILATOM ) {  /* ϺǽǤǤʤ */
	    table_key_c->next               /* Yes:ΰդ */
		= (struct shp_TableKeyInfo *)
		    malloc(sizeof(struct shp_TableKeyInfo));
	    table_key_c = table_key_c->next;
	} else {
	    table_key_c->next = NULL;       /* No :nextNULLǼ */
	}
    }
}


/* --------------------------------------------------------------------
 *	convert_nil_request
 *
 *      ͻѴ
 *      
 *      RETURN: ʤ
 *
 * --------------------------------------------------------------------
 */

enum shp_NilRequest
convert_nil_request(q nil_request_klic)
{
    if ( !strcmp(namestringof(shp_DerefOne(nil_request_klic)),
		 NOT_ALLOWED) ) {
	return (Not_Allowed);
    } else if ( !strcmp(namestringof(shp_DerefOne(nil_request_klic)),
			ALLOWED) ) {
	return (Allowed);
    } else if ( !strcmp(namestringof(shp_DerefOne(nil_request_klic)),
			NOT_NIL) ) {
	return (Not_Nil);
    } else if ( !strcmp(namestringof(shp_DerefOne(nil_request_klic)),
			NOT_BOTTOM) ) {
	return (Not_Bottom);
    }
}


/* --------------------------------------------------------------------
 *	convert_direct_del_flag
 *
 *      ľܺե饰Ѵ
 *      
 *      RETURN: ʤ
 *
 * --------------------------------------------------------------------
 */

enum shp_DirectDelFlag
convert_direct_del_flag(q direct_del_flag_klic)
{
    if ( !strcmp(namestringof(shp_DerefOne(direct_del_flag_klic)), ON) ) {
	return (On);
    } else {
	return (Off);
    }
}


/* --------------------------------------------------------------------
 *	convert_child_attr_info
 *
 *      °Ѵ
 *      
 *      RETURN: ʤ
 *
 * --------------------------------------------------------------------
 */

void
convert_child_attr_info(q child_info_klic, int child_attr_cnt,
			struct shp_ChildInfo *child_info_c)
{
    int i;                  /* FOR LOOP */
    q child_info_ele_klic;  /* ° */

    for ( i = 0; i < child_attr_cnt; i++ ) {
        child_info_ele_klic = shp_DerefOne(ELEMENT(child_info_klic, i));
	if ( !strcmp(namestringof(shp_DerefOne(ELEMENT(child_info_ele_klic,
						   FIRST))),
		     GROUP) ) {
	    child_info_c->type = Group;         /* °Ѵ */
	    child_info_c->attr_info.info1
		= (struct shp_AttrInfo1 *)
		    malloc(sizeof(struct shp_AttrInfo1));
	    convert_group_info(child_info_ele_klic,
			       child_info_c->attr_info.info1);
	} else if ( !strcmp(namestringof(shp_DerefOne(ELEMENT(child_info_ele_klic,
							  FIRST))),
			    REPEAT_GROUP) ) {
	    child_info_c->type = Repeat_Group;  /* ֤°Ѵ */
	    child_info_c->attr_info.info1
		= (struct shp_AttrInfo1 *)
		    malloc(sizeof(struct shp_AttrInfo1));
	    convert_group_info(child_info_ele_klic,
			       child_info_c->attr_info.info1);
	} else if ( !strcmp(namestringof(shp_DerefOne(ELEMENT(child_info_ele_klic,
							  FIRST))),
			    SIMPLE) ) {
	    child_info_c->type = Simple;        /* ñ°Ѵ */
	    child_info_c->attr_info.info2
		= (struct shp_AttrInfo2 *)
		    malloc(sizeof(struct shp_AttrInfo2));
	    convert_simple_info(child_info_ele_klic,
				child_info_c->attr_info.info2);
	    if ( child_info_c->attr_info.info2->data_type == Integer ) {
		child_info_c->attr_info.info2->type = Simple_Integer;
	    } else {
		child_info_c->attr_info.info2->type = Simple;
	    }
	} else if ( !strcmp(namestringof(shp_DerefOne(ELEMENT(child_info_ele_klic,
							  FIRST))),
			    REPEAT_SIMPLE) ) {
	    child_info_c->type = Repeat_Simple; /* ֤ñ°Ѵ */
	    child_info_c->attr_info.info2
		= (struct shp_AttrInfo2 *)
		    malloc(sizeof(struct shp_AttrInfo2));
	    convert_simple_info(child_info_ele_klic,
				child_info_c->attr_info.info2);
	    child_info_c->attr_info.info2->type = Repeat_Simple;
	}
	if ( (i + 1) < child_attr_cnt ) {  /* ϺǽǤǤʤ */
	    child_info_c->next             /* Yes:ΰդ */
		= (struct shp_ChildInfo *)
		    malloc(sizeof(struct shp_ChildInfo));
	    child_info_c = child_info_c->next;
	} else {
	    child_info_c->next = NULL;     /* No :nextNULLǼ */
	}
    }
}


/* --------------------------------------------------------------------
 *	convert_nest_seq
 *
 *      ͥȥ󥹤Ѵ
 *      
 *      RETURN: ʤ
 *
 * --------------------------------------------------------------------
 */

void
convert_nest_seq(q nest_seq_klic, struct shp_NestSequence *nest_seq_c)
{
    nest_seq_klic = shp_DerefOne(nest_seq_klic);

    while ( nest_seq_klic != NILATOM ) {  /* ǽǤˤʤޤǥ롼 */
	/* ꥹǤøǡ(STRING)Ѵ */
	if ( G_ISATOMIC(G_CAR_OF(nest_seq_klic)) ) {
	    nest_seq_c->attr_name
		= (char *)(namestringof(shp_DerefOne(G_CAR_OF(nest_seq_klic))));
	}
	nest_seq_klic = G_CDR_OF(nest_seq_klic);
	nest_seq_klic = shp_DerefOne(nest_seq_klic);
	if ( nest_seq_klic != NILATOM ) {  /* ϺǽǤǤʤ */
	    nest_seq_c->next               /* Yes:ΰդ */
		= (struct shp_NestSequence *)
		    malloc(sizeof(struct shp_NestSequence));
	    nest_seq_c = nest_seq_c->next;
	} else {
	    nest_seq_c->next = NULL;       /* No :nextNULLǼ */
	}
    }
}

    
/* --------------------------------------------------------------------
 *	convert_access_path
 *
 *      ѥѴ
 *      
 *      RETURN: ʤ
 *
 * --------------------------------------------------------------------
 */

void
convert_access_path(q acc_path_klic, struct shp_AccessPath *acc_path_c)
{
    q acc_path_ele_klic;    /* ѥ˳ǼƤ */

    acc_path_klic = shp_DerefOne(acc_path_klic);

    while ( acc_path_klic != NILATOM ) {   /* ǽǤˤʤޤǥ롼 */
	/* ꥹǤøǡѴ */
	if ( G_ISGOBJ(G_CAR_OF(acc_path_klic)) ) {
	    acc_path_ele_klic = G_CAR_OF(acc_path_klic);
	    acc_path_c->attr_name
		= (char *)(namestringof(shp_DerefOne(ELEMENT(acc_path_ele_klic,
							     FIRST))));
	    if ( !strcmp(namestringof(shp_DerefOne(ELEMENT(acc_path_ele_klic,
							   SECOND))), SET) ) {
		acc_path_c->repeat = Set;
	    } else {
		acc_path_c->repeat = SingleNode;
	    }
	    acc_path_c->position
		= G_INTVAL(ELEMENT(acc_path_ele_klic, THIRD));
	    acc_path_c->next_nint_posi
		= G_INTVAL(ELEMENT(acc_path_ele_klic, FOURTH));
	}
	acc_path_klic = G_CDR_OF(acc_path_klic);
	acc_path_klic = shp_DerefOne(acc_path_klic);
	if ( acc_path_klic != NILATOM ) {  /* ϺǽǤǤʤ */
	    acc_path_c->next               /* Yes:ΰդ */
		= (struct shp_AccessPath *)
		    malloc(sizeof(struct shp_AccessPath));
	    acc_path_c = acc_path_c->next;
	} else {
	    acc_path_c->next = NULL;       /* No :nextNULLǼ */
	}
    }
}

    
/* --------------------------------------------------------------------
 *	convert_set_key_info
 *
 *      setѴ
 *      
 *      RETURN: ʤ
 *
 * --------------------------------------------------------------------
 */

void
convert_set_key_info(q set_key_klic, struct shp_SetKeyInfo *set_key_c)
{
    set_key_klic = shp_DerefOne(set_key_klic);

    while ( set_key_klic != NILATOM ) {    /* ǽǤˤʤޤǥ롼 */
	/* ꥹǤøǡ(INTEGER)Ѵ */
	if ( G_ISINT(G_CAR_OF(set_key_klic)) ) {
	    set_key_c->attr_posi = G_INTVAL(G_CAR_OF(set_key_klic));
	}
	set_key_klic = G_CDR_OF(set_key_klic);
	set_key_klic = shp_DerefOne(set_key_klic);
	if ( set_key_klic != NILATOM ) {  /* ϺǽǤǤʤ */
	    set_key_c->next               /* Yes:ΰդ */
		= (struct shp_SetKeyInfo *)
		    malloc(sizeof(struct shp_SetKeyInfo));
	    set_key_c = set_key_c->next;
	} else {
	    set_key_c->next = NULL;       /* No :nextNULLǼ */
	}
    }
}


/* --------------------------------------------------------------------
 *	convert_repeating_path
 *
 *      ԡƥ󥰥ѥѴ
 *      
 *      RETURN: ʤ
 *
 * --------------------------------------------------------------------
 */

void
convert_repeating_path(q rep_path_klic, struct shp_RepPath *rep_path_c)
{
    rep_path_klic = shp_DerefOne(rep_path_klic);

    while ( rep_path_klic != NILATOM) {    /* ǽǤˤʤޤǥ롼 */
	/* ꥹǤøǡ(INTEGER)Ѵ */
	if ( G_ISINT(G_CAR_OF(rep_path_klic)) ) {
	    rep_path_c->attr_id = G_INTVAL(G_CAR_OF(rep_path_klic));
	}
	rep_path_klic = G_CDR_OF(rep_path_klic);
	rep_path_klic = shp_DerefOne(rep_path_klic);
	if ( rep_path_klic != NILATOM ) {  /* ϺǽǤǤʤ */
	    rep_path_c->next               /* Yes:ΰդ */
		= (struct shp_RepPath *) malloc(sizeof(struct shp_RepPath));
	    rep_path_c = rep_path_c->next;
	} else {
	    rep_path_c->next = NULL;       /* No :nextNULLǼ */
	}
    }
}


/* --------------------------------------------------------------------
 *	convert_data_type
 *
 *      °ǡѴ
 *      
 *      RETURN: ʤ
 *
 * --------------------------------------------------------------------
 */

enum shp_DataType
convert_data_type(q data_type_klic)
{
    if ( !strcmp(namestringof(shp_DerefOne(data_type_klic)), STRING) ) {
	return (String);
    } else if ( !strcmp(namestringof(shp_DerefOne(data_type_klic)), INTEGER) ) {
	return (Integer);
    } else if ( !strcmp(namestringof(shp_DerefOne(data_type_klic)), FLOAT) ) {
	return (Float);
    } else if ( !strcmp(namestringof(shp_DerefOne(data_type_klic)),
			DOUBLE_FLOAT) ) {
	return (Double);
    } else if ( !strcmp(namestringof(shp_DerefOne(data_type_klic)), TERM) ) {
	return (Term);
    } else if ( !strcmp(namestringof(shp_DerefOne(data_type_klic)), PSI_STRING) ) {
	return (Psi_String);
    }
}


/* --------------------------------------------------------------------
 *	convert_key_request
 *
 *      Ѵ
 *      
 *      RETURN: ʤ
 *
 * --------------------------------------------------------------------
 */

enum shp_KeyRequest
convert_key_request(q key_request_klic)
{
    if ( !strcmp(namestringof(shp_DerefOne(key_request_klic)), TABLE) ) {
	return (Table_Key);
    } else if ( !strcmp(namestringof(shp_DerefOne(key_request_klic)), SET) ) {
	return (Set_Key);
    } else if ( !strcmp(namestringof(shp_DerefOne(key_request_klic)), PRIMARY) ) {
	return (Primary_Key);
    } else if ( !strcmp(namestringof(shp_DerefOne(key_request_klic)), NON_KEY) ) {
	return (Non_Key);
    }
}


/* --------------------------------------------------------------------
 *	convert_access_request
 *
 *      Ѵ
 *      
 *      RETURN: ʤ
 *
 * --------------------------------------------------------------------
 */

void
convert_access_request(q access_request_klic,
		    struct shp_AccessRequest *access_request_c)
{
    q list;                          /* ǥå°ꥹ */

    if ( G_ISINT(shp_DerefOne(ELEMENT(access_request_klic, FIRST))) ) {
	/* ǥå */
	access_request_c->index_id
	    = G_INTVAL(shp_DerefOne(ELEMENT(access_request_klic, FIRST)));
    } else {
	access_request_c->index_id = 0;
	/* ǥåʤ */
    }

    list = shp_DerefOne(ELEMENT(access_request_klic, SECOND));
    if ( list == NILATOM ) {
	access_request_c->ia_list = NULL;
    } else {
	access_request_c->ia_list = (struct shp_IndexAttrList *)
	    malloc(sizeof(struct shp_IndexAttrList));
	convert_predicate_function(list, access_request_c->ia_list);
    }
}


/* --------------------------------------------------------------------
 *	convert_predicate_function
 *
 *      Ȥ߹ߴؿѴ
 *      
 *      RETURN: ʤ
 *
 * --------------------------------------------------------------------
 */

void
convert_predicate_function(q list, struct shp_IndexAttrList *pred_func_list)
{
    q index_attr_ele;                /* ǥå°ꥹ(KLIC) */
    
    while ( list != NILATOM ) {
	/* ꥹǤøǡ(¤)Ѵ */
	if ( G_ISGOBJ(G_CAR_OF(list)) ) {
	    index_attr_ele = shp_DerefOne(ELEMENT(G_CAR_OF(list), FIRST));
	    if ( !strcmp(namestringof(shp_DerefOne(index_attr_ele)), SUBSTRING) ) {
		/* Ȥ߹ߴؿ */
		pred_func_list->id = Substr;
	    } else if ( !strcmp(namestringof(shp_DerefOne(index_attr_ele)),
				CONCAT1) ) {
		pred_func_list->id = Concat1;
	    } else if ( !strcmp(namestringof(shp_DerefOne(index_attr_ele)),
				CONCAT2) ) {
		pred_func_list->id = Concat2;
	    } else if ( !strcmp(namestringof(shp_DerefOne(index_attr_ele)),
				CONCAT3) ) {
		pred_func_list->id = Concat3;
	    } else if ( !strcmp(namestringof(shp_DerefOne(index_attr_ele)),
				REVERSE) ) {
		pred_func_list->id = Reverse;
	    } else if ( !strcmp(namestringof(shp_DerefOne(index_attr_ele)),
				SCAN) ) {
		pred_func_list->id = Scan;
	    }
	    pred_func_list->attr_name      /* °̾ */
		= (char *)(namestringof(shp_DerefOne(ELEMENT(G_CAR_OF(list),
							 SECOND))));
	    pred_func_list->attr_id        /* °ID */
		= G_INTVAL(shp_DerefOne(ELEMENT(G_CAR_OF(list), THIRD)));
	    pred_func_list->index_id       /* ǥåID */
		= G_INTVAL(shp_DerefOne(ELEMENT(G_CAR_OF(list), FOURTH)));
	    switch( pred_func_list->id ) {
	    case Substr:    /* substring */
		pred_func_list->index_attr
		    = (union shp_PredicateFunction *)
			malloc(sizeof(union shp_PredicateFunction));
		pred_func_list->index_attr->substr
		    = (struct shp_Substr *)
			malloc(sizeof(struct shp_Substr));
		pred_func_list->index_attr->substr->position
		    = G_INTVAL(shp_DerefOne(ELEMENT(G_CAR_OF(list), FIFTH)));
		/* ǥåڤФϰ */
		pred_func_list->index_attr->substr->length
		    = G_INTVAL(shp_DerefOne(ELEMENT(G_CAR_OF(list), SIXTH)));
		/* ǥåڤФĹ */
		break;
	    case Concat1:   /* concatenate 1 */
		/* FALL THROUGH */
	    case Concat2:   /* concatenate 2 */
		pred_func_list->index_attr
		    = (union shp_PredicateFunction *)
			malloc(sizeof(union shp_PredicateFunction));
		pred_func_list->index_attr->string_list
		    = convert_klic_string_to_c_string(shp_DerefOne(ELEMENT(G_CAR_OF(list), FIFTH)));
		/* оݥǥå or ʸ */
		break;
	    case Concat3:   /* concatenate 3 */
		pred_func_list->index_attr
		    = (union shp_PredicateFunction *)
			malloc(sizeof(union shp_PredicateFunction));
		pred_func_list->index_attr->concat3
		    = (struct shp_Concatenate3 *)
			malloc(sizeof(struct shp_Concatenate3));
		pred_func_list->index_attr->concat3->string1
		    = convert_klic_string_to_c_string(shp_DerefOne(ELEMENT(G_CAR_OF(list), FIFTH)));
		/* оݥǥåʸ */
		pred_func_list->index_attr->concat3->string2
		    = convert_klic_string_to_c_string(shp_DerefOne(ELEMENT(G_CAR_OF(list), SIXTH)));
		/* оݥǥå͸ʸ */
		break;
	    case Reverse:   /* reverse_string */
		break;
	    case Scan:      /* scan_string */
		pred_func_list->index_attr
		    = (union shp_PredicateFunction *)
			malloc(sizeof(union shp_PredicateFunction));
		pred_func_list->index_attr->length
		    = G_INTVAL(shp_DerefOne(ELEMENT(G_CAR_OF(list), FIFTH)));
		/* оݥǥåʸĹ */ 
		break;
	    default:
		/* 顼ʤ */
		break;
	    }
	}
	list = G_CDR_OF(list);
	list = shp_DerefOne(list);
	if ( list != NILATOM ) {             /* ϺǽǤǤʤ */
	    pred_func_list->next             /* Yes:ΰդ */
		= (struct shp_IndexAttrList *)
		    malloc(sizeof(struct shp_IndexAttrList));
	    pred_func_list = pred_func_list->next;
	    pred_func_list->index_attr
		= (union shp_PredicateFunction *)
		    malloc(sizeof(union shp_PredicateFunction));
	} else {
	    pred_func_list->next = NULL;     /* No :nextNULLǼ */
	}
    }
}



/* --------------------------------------------------------------------
 *	convert_foreign_key
 *
 *      Ѵ
 *      
 *      RETURN: ʤ
 *
 * --------------------------------------------------------------------
 */

void
convert_foreign_key(q foreign_key_klic,
		    struct shp_ForeignKey *foreign_key_c)
{
    q foreign_key_ele;    /*  */

    if ( !strcmp(namestringof(shp_DerefOne(foreign_key_klic)), NIL) ) {
	/*  nil ξ */
	foreign_key_c->table_name = "Nil";
	foreign_key_c->attr_name = "Nil";
	foreign_key_c->delete_rule = Cascades;
	foreign_key_c->replace_rule = Cascades;
    } else {                            /*  nil ʳξ */
	if ( G_ISGOBJ(foreign_key_klic) ) {
	    foreign_key_c->table_name
		= (char *)(namestringof(shp_DerefOne(ELEMENT(foreign_key_klic,
							 FIRST))));
	    foreign_key_c->attr_name
		= (char *)(namestringof(shp_DerefOne(ELEMENT(foreign_key_klic,
							 SECOND))));
	    if ( !strcmp(namestringof(shp_DerefOne(ELEMENT(foreign_key_klic,
						       THIRD))),
			 CASCADES) ) {
		foreign_key_c->delete_rule = Cascades;
	    } else if ( !strcmp(namestringof(shp_DerefOne(ELEMENT(foreign_key_klic,
							      THIRD))),
				RESTRICTED) ) {
		foreign_key_c->delete_rule = Restricted;
	    } else if ( !strcmp(namestringof(shp_DerefOne(ELEMENT(foreign_key_klic,
							      THIRD))),
				NULLIFIES) ) {
		foreign_key_c->delete_rule = Nullifies;
	    }
	    if ( !strcmp(namestringof(shp_DerefOne(ELEMENT(foreign_key_klic,
						       FOURTH))),
			 CASCADES) ) {
		foreign_key_c->replace_rule = Cascades;
	    } else if ( !strcmp(namestringof(shp_DerefOne(ELEMENT(foreign_key_klic,
						     FOURTH))), RESTRICTED) ) {
		foreign_key_c->replace_rule = Restricted;
	    } else if ( !strcmp(namestringof(shp_DerefOne(ELEMENT(foreign_key_klic,
						     FOURTH))), NULLIFIES) ) {
		foreign_key_c->replace_rule = Nullifies;
	    }
	}
    }
}


/* --------------------------------------------------------------------
 *	shp_DerefOne
 *
 *      ѿΥХԤ
 *      
 *      RETURN: ʤ
 *
 * --------------------------------------------------------------------
 */

q shp_DerefOne(q x)
{
    KP_GD_TDDEREF(x);
    return(x);
}
