/*
/*	(C)1992, 1993, 1995 Institute for New Generation Computer Technology
/*		ۤ¾COPYRIGHTե򻲾ȤƲ
/*		(Read COPYRIGHT for detailed information.)
 */
/*************************************************************************
 *   FILE NAME
 *      term_decode.c
 *   DESCRIPTION
 *      ȥ󥰤˳Ǽ줿ǥɤƥǡKlicǡ
 *      롣
 *   INTERFACE ROUTINES
 *      term_Decode  - ȥ󥰡ʤΥꥹȡˤ˳Ǽ줿ǥ
 *                     ơꥢɥ쥹˥ǡKlicǡˤ֤
 *   NOTES
 *$  EDITOR : Toru Kawamura
 *$  CREATE : '94-04-2
 *$  UPDATE : '94-06-17     
 *$               06-24     string16 supported
 *$               07-27     _g_new => macro
 *$               09-02     change of structure in  string, atom data
 *$               09-14
 *$               09-27
 *$           '95-03-23     GetTagInfo modified
 *$                         GetShort   added
 **************************************************************************/
#include "term.h"
#include "atom.h"
#include "funct.h"

static q *DecodeTerm(sl *stl, q *termp, q *g_allocp);
static unsigned short GetShort(sl *stl);
static void CopyString(sl *stl, int len, char *ostr);
static void MoveStrPtr(sl *stl, int len);
static int  GetTagInfo(sl *stl, int *infop);
static void GetSpecialSymbol(int info, sl *stl, q *termp);
static void GetSymbol(int size, sl *stl, q *termp);
static void GetInteger32(int info, sl *stl, q *termp);
static void GetInteger28(int info, sl *stl, q *termp);
static void GetInteger12(int info, sl *stl, q *termp);
static q *GetString(int kind, sl *stl, q *termp, q *g_allocp);
static q *GetString16(int kind, sl *stl, q *termp, q *g_allocp);
static q *GetList(int cnt, sl *stl, q *termp, q *g_allocp);
static q *GetVector(int size, sl *stl, q *termp, q *g_allocp);
static q *GetFunctor(int arity, sl *stl, q *termp, q *g_allocp);

/*-----------------------------------------------------------------------
 *      term_Decode
 *
 *      ȥ󥰡ʤΥꥹȡˤ˳Ǽ줿ǥɤơꥢ
 *      쥹˥ǡKlicǡˤ֤
 *
 *      ARGUMENT: str      - Ǽȥ󥰡Cǡ
 *                strlen   - 嵭ȥ󥰤Ĺ
 *                stol     - ǥɤ줿γǼ줿ȥ
 *                           KlicǡˤΥꥹȡKlicǡˡ
 *                termp    - ǥɤ֤ɥ쥹
 *                g_allocp - KlicΥҡΰΥȥݥ
 *
 *      RETURN: g_allocp֤ͤ
 *
 *      NOTE:
 *-----------------------------------------------------------------------
 */
q *
term_Decode(char *str, int strlen, q stol, q *termp, q *g_allocp)
{
    sl  stl;

    stl.sp   = str;
    stl.ep   = str + strlen;
    stl.list_type = 0;
    stl.u.stolist = stol;
    return DecodeTerm(&stl, termp, g_allocp);
}

/*-----------------------------------------------------------------------
 *      term_DecodeRec   --- REC interface ---
 *
 *      ȥ󥰡ʤΥꥹȡˤ˳Ǽ줿ǥɤơꥢ
 *      쥹˥ǡKlicǡˤ֤
 *
 *      ARGUMENT: str      - Ǽȥ󥰡ʣåǡ
 *                strlen   - 嵭ȥ󥰤Ĺ
 *                recstolp - ǥɤ줿γǼ줿ȥ
 *                           ʣåǡˤΥꥹȡʣåǡˤؤΥݥ󥿡
 *                termp    - ǥɤ֤ɥ쥹
 *                g_allocp - KlicΥҡΰΥȥݥ
 *
 *      RETURN: g_allocp֤ͤ
 *
 *      NOTE:
 *-----------------------------------------------------------------------
 */
q *
term_DecodeRec(char *str, int strlen, struct term_StringList *recstolp,
                                                     q *termp, q *g_allocp)
{
    sl  stl, newstl;

    stl.sp   = str;
    stl.ep   = str + strlen;
    stl.list_type = 1;
    stl.u.rstolp  = recstolp;
    return DecodeTerm(&stl, termp, g_allocp);
}

/*-----------------------------------------------------------------------
 *      DecodeTerm
 *
 *      ȥ󥰡ʤΥꥹȡˤ˳Ǽ줿ǥɤǡ
 *      Klicǡˤ롣
 *
 *      ARGUMENT: stl      - γǼ줿ȥ󥰤ξ
 *                termp    - ǥɤ֤ɥ쥹
 *                g_allocp - KlicΥҡΰΥȥݥ
 *
 *      RETURN: g_allocp֤ͤ
 *
 *      NOTE:
 *-----------------------------------------------------------------------
 */
static q *
DecodeTerm(sl *stl, q *termp, q *g_allocp)
{
    int  info;

    switch (GetTagInfo(stl, &info)) {
    case TAG_SPECIAL_ATOM:
	GetSpecialSymbol(info, stl, termp);
	return g_allocp;
    case TAG_ATOM:
	GetSymbol(info, stl, termp);
	return g_allocp;
    case TAG_INTEGER32:
	GetInteger32(info,stl,termp);
	return g_allocp;
    case TAG_INTEGER28:
	GetInteger28(info,stl,termp);
	return g_allocp;
    case TAG_INTEGER12:
	GetInteger12(info,stl,termp);
	return g_allocp;
    case TAG_FLOATING:  
	*termp = G_MAKEINT(info);
	return g_allocp;
    case TAG_VECTOR:
	return GetVector(info, stl, termp, g_allocp);
    case TAG_LIST:
	return GetList(info, stl, termp, g_allocp);
    case TAG_STRING8:
	return GetString(info, stl, termp, g_allocp);
    case TAG_STRING16:
	return GetString16(info, stl, termp, g_allocp);
    case TAG_FUNCTOR:
	return GetFunctor(info, stl, termp, g_allocp);
    default:
	printf("invalid tag\n");
	break;
    }	
}

/*-----------------------------------------------------------------------
 *    GetTagInfo
 *
 *      󤫤ǡ̤ȾФƻꤵ줿ɥ쥹֤  
 *
 *      ARGUMENT: stl      - γǼ줿ȥ󥰤ξ
 *                infop    - ֤ɥ쥹
 *
 *      RETURN: ǡ̤֤
 *
 *      NOTE:
 *-----------------------------------------------------------------------
 */
static int
GetTagInfo(sl *stl, int *infop) 
{
    unsigned short tag;

    tag = GetShort(stl);
    *infop = 0x0FFF & tag;
    return tag >> 12;
}

/*-----------------------------------------------------------------------
 *   GetSpecialSymbol
 *
 *     ü쥢ȥǡǥɤKlicǡ롣
 *
 *     ARGUMENT: info  - ü쥢ȥɽ
 *               stl  - Ǽȥ󥰤ξ
 *               termp - ȥǡ...0110ˤǼ륢ɥ쥹
 *
 *     RETURN: g_allocp
 *
 *     NOTE:  Ǽ¤
 *      +--------+
 *      |  Tag   |     TagInfo(12bit) => ü쥢ȥɽ
 *      +--------+
 *          2   (byte)
 *-------------------------------------------------------------------
 */
static void 
GetSpecialSymbol(int info, sl *stl, q *termp) 
{
    switch (info) {
    case TAG_EMPTY_LIST: 
	*termp = NILATOM;
	break;
    case TAG_NIL: 
/*	*termp = G_MAKESYM(enter_atom_cstring("nil")); */
	*termp = G_MAKESYM(G_atom(nil));
	break;
    }
    return;
}

/*-----------------------------------------------------------------------
 *   GetSybmol
 *
 *     ȥǡǥɤKlicǡ롣
 *
 *     ARGUMENT: tag_info  - Tag
 *               stl       - Ǽȥ󥰤ξ
 *               termp     - ȥǡ...0110ˤǼ륢ɥ쥹
 *
 *     RETURN: ʤ
 *
 *     NOTE:  Ǽ¤
 *      ĹϣХñ̤ǳǼ롣
 *        2                        (byte)
 *    +--------+---------------------+
 *    | Tag    |   ATOM String       |
 *    +--------+---------------------+
 *    Tag  0-3  bits : ǡ    1
 *           4    bit  : ե饰    0--, 1--
 *           5-15 bits : Ĺ          2047ޤ, 4094 byteΥǡ
 *-------------------------------------------------------------------
 */
static void
GetSymbol(int tag_info, sl *stl, q *termp)
{
    declare_globals;
    int valid_size, size;
    char atomstr[MAX_ATOM_LENGTH + 1];

    if (tag_info & 0x800) {                      /* Ĺ */
	size = (tag_info - 0x800) * 2;
	valid_size = size - 1;
    }
    else {                                       /* Ĺ */
	size = tag_info * 2;
	valid_size = size;
    }
    CopyString(stl, size, atomstr);
    atomstr[valid_size] = '\0';
    *termp = G_MAKESYM(enter_atom_cstring(atomstr));
    return;
}

/*-----------------------------------------------------------------------
 *   GetInterger12, GetInteger28, GetInteger32
 *
 *     ǡǥɤKlicǡ롣
 *
 *     ARGUMENT: info  - ǡʤΰ
 *               stl  - Ǽȥ󥰤ξ
 *               termp - ǡǼ륢ɥ쥹
 *
 *     RETURN: ʤ
 *
 *     NOTE:  Ǽ¤ -- 礭ˤäƳǼ¤Ѥ롣
 *      (1)
 *      +--------+
 *      |  Tag   |                    TagInfo(12bit) => 
 *      +--------+
 *          2  (byte)
 *      (2)
 *      +--------+--------+
 *      |  Tag   |    |           TagInfo(12bit) => 
 *      +--------+--------+
 *          2        2  (byte)
 *      (3)
 *      +--------+--------+--------+
 *      |  Tag   |             |  TagInfo(12bit) => Ѥ
 *      +--------+--------+--------+
 *          2             4      (byte)
 *-------------------------------------------------------------------
 */
static void 
GetInteger12(int info, sl *stl, q *termp)
{
    int val;

    val = info;
    if (val <= 0x7FF)
	*termp = G_MAKEINT(val);
    else 
	*termp = G_MAKEINT(val | 0xFFFFF000);
    return;
}

static void 
GetInteger28(int info, sl *stl, q *termp)
{
    unsigned short lower;
    sl datal;
    char tmp[2];

    CopyString(stl, 2, tmp);
    GET_SHORT_INTEGER_NM(lower, tmp);
    if (info <= 0x7FF) 
	*termp = G_MAKEINT((info << 16) | lower);
    else
	*termp = G_MAKEINT(((info << 16) | lower) | 0xF0000000);
    return;
}

static void 
GetInteger32(int info, sl *stl, q *termp)
{
    sl datal;
    char tmp[4];
    int value;

    CopyString(stl, 4, tmp);
    GET_INTEGER_NM(value, tmp);
    *termp = G_MAKEINT(value);
    return;
}

/*-----------------------------------------------------------------------
 *   GetVector
 *
 *     ٥ǡǥɤKlicǡ롣
 *
 *     ARGUMENT: size     - ǿ
 *               stl      - Ǽȥ󥰤ξ
 *               termp    - ٥ǡǼ륢ɥ쥹
 *               g_allocp - KlicҡΰؤΥȥݥ
 *
 *     RETURN: g_allocp
 *
 *     NOTE:  Ǽ¤
 *      +--------+------+------+-----+------+
 *      |  Tag   | Elm1 | Elm2 | ... | ElmN |
 *      +--------+------+------+-----+------+
 *          2                             (byte)
 *
 *        TagInfo(12bit) => ǿ
 *-------------------------------------------------------------------
 */
static q *
GetVector(int size, sl *stl, q *termp, q *g_allocp)
{
    int i;
    q argv[1];
    declare_globals;

    NEW_VECTOR(size, *termp);
    for(i=0; i < size; i++) {
	g_allocp = DecodeTerm(stl,
         ((struct vector_object *)G_FUNCTORP(*termp))->body + i, g_allocp);
    } 
    return g_allocp;
}

/*-----------------------------------------------------------------------
 *   GetList
 *
 *    ꥹȥǡǥɤKlicǡ롣
 *
 *     ARGUMENT: cnt      - ǿ
 *               stl      - Ǽȥ󥰤ξ
 *               termp    - ꥹȥǡǼ륢ɥ쥹
 *               g_allocp - KlicҡΰؤΥȥݥ
 *
 *     RETURN: g_allocp
 *
 *     NOTE:  Ǽ¤
 *      +--------+------+------+-----+------+
 *      |  Tag   | Elm1 | Elm2 | ... | ElmN |
 *      +--------+------+------+-----+------+
 *          2                             (byte)
 *
 *        TagInfo => ǿ
 *       [1,2,3]  [1,2,3|[]] ȸ路ǿ4ǡ1,2,3,[]Ǽ롣
 *-------------------------------------------------------------------
 */
static q *
GetList(int cnt, sl *stl, q *termp, q *g_allocp)
{
    int i;
    q  *tmp;
    struct cons *consp;

    tmp = termp;
    G_HEAPALLOC((q)consp, G_SIZE_IN_Q(struct cons)*cnt, (q));
    for(i=1; i < cnt; i++, consp++) {
	g_allocp = DecodeTerm(stl, &consp->car, g_allocp);
	*tmp = G_MAKECONS(consp);
	tmp  = &consp->cdr;
    }
    g_allocp = DecodeTerm(stl, tmp, g_allocp);
    return g_allocp;
}

/*-----------------------------------------------------------------------
 *   GetString
 *
 *    ȥ󥰥ǡǥɤKlicǡ롣
 *
 *     ARGUMENT: kind     - ȥ󥰼
 *               stl      - Ǽȥ󥰤ξ
 *               termp    - ȥ󥰥ǡǼ륢ɥ쥹
 *               g_allocp - KlicҡΰؤΥȥݥ
 *
 *     RETURN: g_allocp
 *
 *     NOTE:  Ǽ¤
 *     Ĺϡ٤ƣХȤñ̤Ȥ롣
 *
 *     (1) ǡ 2046 byteʲξ
 *         2                        (byte)
 *      +--------+---------------------+
 *      | Tag    |   String            |
 *      +--------+---------------------+
 *     Tag  0-3  bits : ǡ    8
 *            4    bit  : ǡĹե饰0--1023ʲ
 *            5    bit  : ե饰    0--, 1--
 *            6-15 bits : Ĺ          1023ޤ, 2046 byteΥǡ
 *
 *     (2) ǡ 2047 byteʾξ
 *         2        4                    (byte)
 *      +--------+------+--------------------+
 *      | Tag    | Size |  String            |
 *      +--------+------+--------------------+
 *     Tag  0-3  bits : ǡ    8
 *            4    bit  : ǡĹե饰1--1024ʾ
 *            5    bit  : ե饰    0--, 1--
 *            6-15 bits : ̤
 *     Size 4 byte ˥ȥ󥰤ĹǼ롣
 *
 *-------------------------------------------------------------------
 */
static q *
GetString(int tag_info, sl *stl, q *termp, q *g_allocp)
{
    q argv[1];
    declare_globals;
    int size, valid_size = 0;
    char intstr[4];

    switch (tag_info & 0xC00) {
    case 0x000:
#ifdef OLD_TYPE_TBD           /* OLD_TYPE_TBD */
	CopyString(stl, 4, intstr);
        GET_INTEGER_NM(size, intstr);
	if (tag_info == 8) {          /* 8bit string */
	    NEW_BYTE_STRING(size, *termp);
	    CopyString(stl, size, (char *)STRING_OBJ(*termp)->body);
	}
	else {                        /* 16bit string */
	    NEW_DBYTE_STRING(size, *termp);
	    CopyString(stl, size * 2, (char *)STRING16_OBJ(*termp)->body);
	}
	return g_allocp;
#else   
        size = tag_info * 2;
        valid_size = size;
	break;
#endif
    case 0x400:
	size = (tag_info - 0x400) * 2;
	valid_size = size - 1;
	break;
    case 0xC00:
	valid_size = -1;
    case 0x800:
	CopyString(stl, 4, intstr);
	GET_INTEGER_NM(size, intstr);
	size *= 2;
	valid_size += size;
	break;
    }
    NEW_BYTE_STRING(valid_size, *termp);
    CopyString(stl, valid_size, (char *)STRING_OBJ(*termp)->body);
/*#ifdef OLD_TYPE_TBD
/*    if (*(STRING_OBJ(*termp)->body + valid_size - 1) == '\0')
/*	STRING_OBJ(*termp)->index = valid_size - 1;
/*#endif
 */
    MoveStrPtr(stl, size - valid_size);
    return g_allocp;
}


/*-----------------------------------------------------------------------
 *   GetString16
 *
 *    ȥ󥰥ǡǥɤKlicǡ롣
 *
 *     ARGUMENT: size     - ȥĹ
 *               stl      - Ǽȥ󥰤ξ
 *               termp    - ȥ󥰥ǡǼ륢ɥ쥹
 *               g_allocp - KlicҡΰؤΥȥݥ
 *
 *     RETURN: g_allocp
 *
 *     NOTE:  Ǽ¤
 *     Ĺϡ٤ƣХȤñ̤Ȥ롣
 *     (a) ǡ 2047 Ȱʲξ
 *          2                        (byte)
 *      +--------+---------------------+
 *      | Tag    |   String            |
 *      +--------+---------------------+
 *     Tag  0-3  bits : ǡ    9
 *            4    bit  : ǡĹե饰0--2047ʲ
 *            5-15 bits : Ĺ          2047ޤ, 4094 byteΥǡ
 *
 *      (b) ǡ 2048 byteʾξ
 *          2        4                    (byte)
 *      +--------+------+--------------------+
 *      | Tag    | Size |  String            |
 *      +--------+------+--------------------+
 *     Tag  0-3  bits : ǡ    9
 *            4    bit  : ǡĹե饰1--2048ʾ
 *            5-15 bits : ̤
 *     Size 4 byte ˥ȥ󥰤ĹǼ롣
 *-------------------------------------------------------------------
 */
static q *
GetString16(int tag_info, sl *stl, q *termp, q *g_allocp)
{
    q argv[1];
    declare_globals;
    char intstr[4];
    int size;

    if (tag_info & 0x800) {                /* ǡĹ 2048ʾ */
	CopyString(stl, 4, intstr);
	GET_INTEGER_NM(size, intstr);
	size *= 2;
    }
    else                                   /* ǡĹ 2047ʲ */
	size = tag_info * 2;
    NEW_DBYTE_STRING(size, *termp);
    CopyString(stl, size, (char *)STRING16_OBJ(*termp)->body);
    return g_allocp;
}


/*-----------------------------------------------------------------------
 *   GetFunctor
 *
 *     ե󥯥ǡǥɤKlicǡ롣
 *
 *     ARGUMENT: arity    - ο
 *               stl      - Ǽȥ󥰤ξ
 *               termp    - ե󥯥ǡǼ륢ɥ쥹
 *               g_allocp - KlicҡΰؤΥȥݥ
 *
 *     RETURN: g_allocp
 *
 *     NOTE:  Ǽ¤
 *      +--------+----+--------------+------+------+-----+------+
 *      |  Tag   |Size|FuncNameString| Elm1 | Elm2 | ... | ElmN |
 *      +--------+----+--------------+------+------+-----+------+
 *         2       2   (8bit string)                         (byte)
 *
 *    Tag  0-3  bits : ǡ    10
 *           4-15 bits : ǿ
 *    Size 0-3  bits : ̤
 *           4    bit  : ե饰0--, 1--
 *           5-15 bits : ե󥯥̾ΥХñ̤ǳǼ롣
 *                      SizeեɤĹϴޤޤʤ
 *-------------------------------------------------------------------
 */
static q *
GetFunctor(int arity, sl *stl, q *termp, q *g_allocp)
{
    q funcatom;
    struct functor *funcp;
    int i;
    declare_globals;
    unsigned short fnsz;

    G_HEAPALLOC((q)funcp, arity + 1, (q));
    fnsz = GetShort(stl);
    GetSymbol((int)fnsz, stl, &funcatom);
    funcp->functor = G_MAKESYM(enter_functor(G_SYMVAL(funcatom),arity));
    for (i=0; i<arity; i++)
	g_allocp = DecodeTerm(stl, funcp->args + i, g_allocp);
    *termp =  G_MAKEFUNCTOR(funcp);
    return g_allocp;
}

/*-----------------------------------------------------------------------
 *   GetShort
 *
 *     Ǽȥ󥰤Υȥݥ󤫤unsigned short 
 *     Ф֤
 *
 *     ARGUMENT: stl  - Ǽȥ󥰤ξ
 *
 *     RETURN: unsigned short
 *
 *     NOTE:  tag ͤμФ
 *-------------------------------------------------------------------
 */
static unsigned short
GetShort(sl *stl)
{
    static void NewStl(sl *stl);
    unsigned short sval;

    if(stl->ep - stl->sp >= 2) {
	GET_SHORT_INTEGER(sval, stl->sp);
    }
    else {
        NewStl(stl);
        sval = GetShort(stl);
    }
    return sval;
}

/*-----------------------------------------------------------------------
 *   CopyString
 *
 *     Ǽȥ󥰤Υȥݥ󤫤Ĺ
 *     ΰ˥ԡ롣
 *
 *     ARGUMENT: stl  - Ǽȥ󥰤ξ
 *               len  - ԡĹ
 *               ostr - ԡ襹ȥ
 *
 *     RETURN: ʤ
 *
 *     NOTE:  
 *-------------------------------------------------------------------
 */
static void
CopyString(sl *stl, int len, char *ostr)
{
    static void NewStl(sl *stl);

    if(stl->ep - stl->sp >= len) {
	BCOPY(stl->sp, ostr, len);
	stl->sp += len;
    }
    else {
	int sublen = stl->ep - stl->sp;
	BCOPY(stl->sp, ostr, sublen);
	NewStl(stl);
	CopyString(stl, len - sublen, ostr + sublen);
    }
    return;
}

/*-----------------------------------------------------------------------
 *   MoveStrPtr
 *
 *     Ǽȥ󥰤Υȥݥ󤫤Ĺ
 *     ȥݥ󥿤ʤ롣
 *
 *     ARGUMENT: stl  - Ǽȥ󥰤ξ
 *               len  - ʤ륵
 *
 *     RETURN: ʤ
 *
 *     NOTE:  
 *-------------------------------------------------------------------
 */
static void
MoveStrPtr(sl *stl, int len)
{
    static void NewStl(sl *stl);

    if(stl->ep - stl->sp >= len)
	stl->sp += len;
    else {
	int restlen = stl->ep - stl->sp;
	NewStl(stl);
	MoveStrPtr(stl, len - restlen);
    }
    return;
}

/*-----------------------------------------------------------------------
 *   NewStl
 *
 *     Ǽȥ󥰾ˡΥȥ󥰤ξ򥻥åȤ롣
 *
 *     ARGUMENT: stl  - Ǽȥ󥰤ξ
 *
 *     RETURN: ʤ
 *
 *     NOTE:  Ǽȥ󥰾ι¤
 *         Rec-interface ǸƤФ줿ˤϡsto_listˤStringΥꥹ
 *           ؤΥݥ󥿤äƤ롣
 *        +-----------+
 *        |cur_ptr(sp)|  # ȥ󥰤Υȥݥ
 *        +-----------+
 *        |end_ptr(ep)|  # ȥ󥰤νλݥ
 *        +-----------+
 *        |list_type  |  # ȥ󥰥ꥹȤμ
 *        +-----------+
 *        | sto_list  |  # StringObjectΥꥹȡKlicǡ    type=0
 *        +-----------+  # ޤϡ
 *                       # StringΥꥹȤؤΥݥ󥿡ʣåǡtype=1
 *-------------------------------------------------------------------
 */
static void
NewStl(sl *stl)
{
    if (stl->list_type == 0) {         /* StrObjΥꥹȡKlicǡ*/
	q stobj, stolist;
	stolist = stl->u.stolist;
	deref_and_switch(stolist, othercdr, atomiccdr, conscdr, othercdr);
    conscdr:
	stobj = G_CAR_OF(stolist);
	stl->sp = (char *)generic_string16_body(STRING16_OBJ(stobj));
	stl->ep = (char *)stl->sp +
	    generic_string16_size(STRING16_OBJ(stobj)) * 
                                               sizeof(unsigned short);
	stl->u.stolist = G_CDR_OF(stolist);
    }
    else {                              /* StringΥꥹȡCǡ*/
	struct term_StringList *rstolp;
	rstolp = stl->u.rstolp;
	stl->sp = rstolp->sp;
	stl->ep = rstolp->sp + rstolp->length;
	stl->u.rstolp = rstolp->next;
    }
    return;
 othercdr:
 atomiccdr:
}
