/*
/*	(C)1992, 1993, 1995 Institute for New Generation Computer Technology
/*		ۤ¾COPYRIGHTե򻲾ȤƲ
/*		(Read COPYRIGHT for detailed information.)
 */
/***********************************************************************
 *   FILE NAME
 *	rec_read_gr.c
 *   DESCRIPTION
 *	롼ԥ󥰻եޥåɤߤԤʤ
 *   INTERFACE ROUTINES
 *	rec_ReadGrouping - եޥåȤ˽롼ԥ
 *                         եޥåɤߤԤʤ
 *   NOTES       
 *	
 *$  EDITOR : Tooru Shida
 *$           (MITSUBISHI ELECTRIC COMPUTER SYSTEMS (TOKYO) CORPORATION)
 *$  CREATE : '94-01-21 Friday
 *$  UPDATE : '94-04-22~25 by Shida(MTC) for Kappa ver.Q02
 *$         : '94-07-11    by Shida(MTC) for Kappa ver.Q02
 *$         : '94-07-15    by Shida(MTC) for Kappa ver.Q02
 *$         : '94-07-28    by Shida(MTC) for Kappa ver.Q02
 *$         : '94-09-02    by Shida(MTC) for Kappa ver.Q03
 *$         : '94-09-06    by Shida(MTC) 
 *$           '95-03-23 modified for linux (rec_StrnCpy)
 *$
 ***********************************************************************/

#include <stdio.h>
#include <string.h>
#include "rec_read_gr.h"

/* --------------------------------------------------------------------
 *	rec_ReadGrouping
 *        եޥåȤ˽쥳ɥȥ󥰤°ͤ
 *        ڤФ롼ԥ󥰻եޥåɤߤԤʤ
 *      
 *      ARGUMENT: internal_format : եޥåȤؤΥݥ
 *                                  (¤TBPեޥå)
 *                rec_sri         : ֥쥳ɾؤΥݥ(KLICǡ)
 *                record          : 쥳ɥȥ󥰤ؤΥݥ
 *                str_cnt         : 쥳ɥȥ󥰿
 *                rid             : 쥳ID
 *                page_size       : ڡΥ(Хñ)
 *                record_length   : 쥳ĹʥХñ̡
 *                value_list      : 쥳ɥȥ󥰤Ѵ줿
 *                                  ͥꥹ(KLICǡ)
 * 
 *      RETURN:   g_allocp        : KLICǡĥҡΰ賫ϥɥ쥹
 *
 * --------------------------------------------------------------------
 */

q *
rec_ReadGrouping(struct ifmt_IFormat *internal_format, q *rec_sri,
		 char **record, int str_cnt, int page_size, int record_length,
		 q *value_list, q *g_allocp)
{
    q sri_ele;     /* ֥쥳ɾ */

    if( str_cnt == NOT_SPAND ) {          /* ѥɥ쥳ɤǤʤ */
	if( internal_format->format_kind == Grouping ) {
	    struct ifmt_Group *group    /* 롼ԥ󥰥եޥåȻ */
		= internal_format->i_format.grouping->group;
	    struct shp_AccessPath *access_path
		= internal_format->i_format.grouping->access_path;
	                                /* ѥ */
	    if ( access_path != LAST ) {
		sri_ele = GetSRI(*rec_sri, access_path->position);
		/* ѥꥹȤǤʤ */
		/* ʤϤơ֥ľ°Ǥʤ */
	    } else {
		sri_ele = *rec_sri;     /* ѥꥹ */
	    }
	    g_allocp = MoveAndReadField(access_path, group, &sri_ele,
					record[FIRST_RECORD], str_cnt,
					record_length, value_list,
					g_allocp);
	    /* о°եɤؤΰư°ɤ */
	} else {                     /* դNilɤߥեޥå */
	    g_allocp = ReadKeyField(internal_format, rec_sri,
				    record[FIRST_RECORD], record_length,
				    value_list, g_allocp);
	}
	return (g_allocp);
    } else {                    /* ѥɥ쥳ɤξ̤ݡȡ */
	return (g_allocp);
    }
}


/* --------------------------------------------------------------------
 *	MoveAndReadField
 *        ѥ򻲾Ȥƽо°եɤޤǥݥ󥿤
 *        ưƤͥꥹȤѴ
 *
 *      RETURN:   g_allocp        : KLICǡĥҡΰ賫ϥɥ쥹
 *
 * --------------------------------------------------------------------
 */

q *
MoveAndReadField(struct shp_AccessPath *access_path,
		 struct ifmt_Group *group, q *rec_sri, char *record,
		 int str_cnt, int field_length, q *value_list,
		 q *g_allocp)
{
    int offset_position;   /* եåͤǼƤ */
    int offset;            /* եå */
    int next_offset;       /* INTEGER°Υեå */
    int nil_flag;          /* ͥե饰 */
    int gk_flag;           /* ե饰 */

    if( access_path == LAST ) {
	/* Ūν°եɤã */
	if ( group->repeat == Single ) {        /* ñ㽸°ξ */
	    g_allocp
		= GetGroupAttr(group, rec_sri, record, str_cnt, field_length, 
			       value_list, g_allocp);
	} else {                                /* ֤°ξ */
	    g_allocp
		= GetRepeatGroupAttr(group, rec_sri, record, str_cnt,
				     field_length, value_list, g_allocp);
	}
    } else {                        /* °ѥӾǤ */
	if( access_path->repeat == SingleNode ) {   /* ñ㽸°ξ */
	    GetOffsetAndNextOffset(access_path->position, 
				   access_path->next_nint_posi, record,
				   field_length, &offset, &next_offset,
				   &nil_flag, &gk_flag);
	    g_allocp = MoveAndReadField(access_path->next, group, rec_sri,
					record + (offset * TWO_BYTE), 
					str_cnt, (next_offset - offset),
					value_list, g_allocp);
	} else {                                /* ֤°ξ */
	    short occ_cnt;            /* оݥեɤΥ󥹿 */

	    REC_GetShortInt(occ_cnt, record);
	        /* 󥹿 */
	    g_allocp = MoveAndReadSRI(occ_cnt, rec_sri, record, str_cnt,
				      field_length, access_path, group,
				      value_list, g_allocp);
	}
    }
    return (g_allocp);
}


/* --------------------------------------------------------------------
 *	GetGroupAttr
 *        ñ㽸°°եޥåȤ˽쥳ɤڤФ
 *        ͥꥹȤν֤˳Ǽ롣
 *
 *      RETURN:   g_allocp        : KLICǡĥҡΰ賫ϥɥ쥹
 *
 * --------------------------------------------------------------------
 */

q *
GetGroupAttr(struct ifmt_Group *group, q *rec_sri, char *record,
	     int str_cnt, int field_length, q *value_list, q *g_allocp)
{
    q work_value;                         /* °Ͱΰ */
    q sri_ele;                            /* ֥쥳ɾ */

    struct ifmt_GroupChildList *group_child_list;
                                          /* 롼ԥ󥰻եޥå */
    struct ifmt_ValuePosiList *posi_list; /* ͥꥹǼ֥ꥹ */
    struct shp_ChildInfo *child_info;     /* Ĥӷ֤° */
    int child_attr_cnt;                   /* Ĥӷ֤°   */
                                          /* ° */
    int offset;                           /* оݥեå */
    int next_offset;                      /* եå */
    int nil_flag;                         /* ͥե饰 */
    int gk_flag;                          /* EUCȥѶե饰 */

    declare_globals;

    q argv[1];                               /* ٥ */
    q vector_g_new();

    group_child_list = group->child_list;

    NEW_VECTOR(group->vector_size, *value_list);

    while( group_child_list ) {
	posi_list = group_child_list->value_posi_list;
	GetOffsetAndNextOffset(group_child_list->attr_posi,
			       group_child_list->next_posi, record,
			       field_length, &offset, &next_offset,
			       &nil_flag, &gk_flag);
	sri_ele = GetSRI(*rec_sri, group_child_list->attr_posi);

	if( group_child_list->type == Attribute ) { /* Attribute */
	    struct shp_SchemaInfo *schema_info      /* ° */
		= group_child_list->group_child.schema_info;
	    nil_flag = (nil_flag & NIL_FLAG_MASK) >> NIL_FLAG_SHIFT;
	    if ( nil_flag == NIL_FIELD ) {
		/* ͥե饰 Nil */
		work_value = G_MAKESYM(G_atom(nil));
	    } else if ( nil_flag == BOTTOM_FIELD ) {
		/* ͥե饰 Bottom */
		work_value = G_MAKESYM(G_atom(bottom));
	    } else {
		switch( schema_info->type ) {
		case Simple_Integer:
		    /* FALL THROUGH */
		case Simple:
		    /* о°ñ°ʴޤINTEGERñ° */
		    g_allocp
			= ReadSimple(offset, next_offset,
				     schema_info->sch_info->attr_info2->data_type,
				     gk_flag, (record + (offset * 2)),
				     &work_value, g_allocp);
		    break;
		case Repeat_Simple:
		    /* о°֤ñ° */
		    g_allocp
			= ReadRepeatSimple((next_offset - offset), gk_flag,
					   (record + (offset * 2)), &sri_ele,
					   schema_info->sch_info->attr_info2->data_type,
					   &work_value, g_allocp);
		    break;
		case Group:
		    /* о°° */
		    child_info
			= schema_info->sch_info->attr_info1->child_attr_info;
		    child_attr_cnt
			= schema_info->sch_info->attr_info1->child_attr_cnt;
		    g_allocp
			= ReadGroup(child_info, &sri_ele,
				    (record + (offset * 2)),
				    str_cnt, (next_offset - offset),
				    child_attr_cnt, &work_value, g_allocp);
		    break;
		case Repeat_Group:
		    /* о°֤° */
		    child_info
			= schema_info->sch_info->attr_info1->child_attr_info;
		    child_attr_cnt
			= schema_info->sch_info->attr_info1->child_attr_cnt;
		    g_allocp
			= ReadRepeatGroup(child_info, &sri_ele,
					  (record + (offset * 2)), str_cnt,
					  (next_offset - offset),
					  child_attr_cnt, &work_value,
					  g_allocp);
		    break;
		default:
		    /* ° */
		    break;
		}
	    }
	} else {                                     /* Grouping */
	    sri_ele = GetSRI(*rec_sri, group_child_list->attr_posi);
	    g_allocp
		= MoveAndReadField(LAST, group_child_list->group_child.group,
				   &sri_ele, (record + (offset * 2)), 
				   str_cnt, (next_offset - offset),
				   &work_value, g_allocp);
	}
	while( posi_list ) {
	        /* Ф°֤ͤ˳Ǽ */
	    *(((struct vector_object *)G_FUNCTORP(*value_list))->body
	      + posi_list->value_posi) = work_value;
	    posi_list = posi_list->next;
	}
	group_child_list = group_child_list->next;
    }
    return (g_allocp);
}

    
/* --------------------------------------------------------------------
 *	GetRepeatGroupAttr
 *        ֤°°եޥåȤ˽쥳ɤڤФ
 *        ͥꥹȤν֤˳Ǽ롣
 *
 *      RETURN:   g_allocp        : KLICǡĥҡΰ賫ϥɥ쥹
 *
 * --------------------------------------------------------------------
 */

q *
GetRepeatGroupAttr(struct ifmt_Group *group, q *rec_sri, char *record,
		   int str_cnt, int field_length, q *value_list,
		   q *g_allocp)
{
    q *tmp;             /* ͥꥹ */
    q sri_ele;          /* ֥쥳ɾ롼 */
    q occ_list;         /* SRI⥪ֹꥹ */
    q occ_list_ele;     /* SRI⥪ֹꥹ */
    q tmp_sri;          /* SRI */

    struct cons *consp; /* ͥꥹ */

    short occ_cnt;      /* 󥹿 */
    int i;              /* FOR LOOP */
    int offset;         /* եå */
    int next_offset;    /* եå */
    int nil_flag;       /* ͥե饰 */
    int gk_flag;        /* ե饰 */

    tmp = value_list;
    REC_GetShortInt(occ_cnt, record);
        /* 󥹿եɼ */
    G_HEAPALLOC((q)consp, G_SIZE_IN_Q(struct cons)*occ_cnt, (q));
    for( i = 1; i <= occ_cnt && *rec_sri != NILATOM; i++ ) {
	/* 󥹤Ф롼ԥɤߤԤʤ */
	if ( i == occ_cnt ) {
	    /* ǽ */
	    GetOffsetAndNextOffset((i - 1), LAST, record, field_length,
				   &offset, &next_offset, &nil_flag,
				   &gk_flag);
	} else {
	    /* ǽ */
	    GetOffsetAndNextOffset((i - 1), i, record, field_length,
				   &offset, &next_offset, &nil_flag,
				   &gk_flag);
	}

	if ( G_ISATOMIC(*rec_sri) ) { /* SRI == '*', 'nil' */
	    g_allocp = GetGroupAttr(group, rec_sri,
				    record + (offset * TWO_BYTE),
				    str_cnt, (next_offset - offset),
				    &consp->car, g_allocp);
	    *tmp = G_MAKECONS(consp);
	    tmp = &consp->cdr;
	    consp++;
	} else if ( G_ISFUNCTOR(*rec_sri) ) {
	    /* Leaf Select Info. (Negative) = nega(OccNumList) */
	    occ_list = arg(*rec_sri, SECOND);
	    KP_GD_TDDEREF(occ_list);
	    if ( occ_list == NILATOM ) {
		tmp_sri = NILATOM;
		g_allocp = GetGroupAttr(group, &tmp_sri,
					record + (offset * TWO_BYTE),
					str_cnt, (next_offset - offset),
					&consp->car, g_allocp);
		*tmp = G_MAKECONS(consp);
		tmp = &consp->cdr;
		consp++;
	    } else {
		while( occ_list != NILATOM ) {
		    occ_list_ele = G_CAR_OF(occ_list);
		    KP_GD_TDDEREF(occ_list);
		    if ( i == (G_INTVAL(occ_list_ele) - 1) ) {
			break;
		    } else {
			tmp_sri = NILATOM;
			g_allocp = GetGroupAttr(group, &tmp_sri,
						record + (offset * TWO_BYTE),
						str_cnt,
						(next_offset - offset),
						&consp->car, g_allocp);
			*tmp = G_MAKECONS(consp);
			tmp = &consp->cdr;
			consp++;
			break;
		    }
		    occ_list = G_CDR_OF(occ_list);
		    KP_GD_TDDEREF(occ_list);
		}
	    }
	} else if ( G_ISCONS(*rec_sri) ) {
	    /* Leaf Select Info. (Positive) = INTEGER */
	    KP_GD_TDDEREF(*rec_sri);
	    sri_ele = G_CAR_OF(*rec_sri);
	    KP_GD_TDDEREF(sri_ele);
	    if ( G_ISINT(sri_ele) ) {
		if ( i == (G_INTVAL(sri_ele)) ) {
		    tmp_sri = NILATOM;
		    g_allocp = GetGroupAttr(group, &tmp_sri,
					    record + (offset * TWO_BYTE),
					    str_cnt,
					    (next_offset - offset),
					    &consp->car, g_allocp);
		    *tmp = G_MAKECONS(consp);
		    tmp = &consp->cdr;
		    consp++;
		    *rec_sri = G_CDR_OF(*rec_sri);
		    KP_GD_TDDEREF(*rec_sri);
		}
	    } else if ( G_ISGOBJ(sri_ele) ) {
		/* Node Select Info. (Positive or Negative) */
		if ( G_ISINT(shp_DerefOne(ELEMENT(sri_ele, FIRST))) ) {
		    /* Positive = {OccNum, SRI} */
		    if ( i == G_INTVAL(shp_DerefOne(ELEMENT(sri_ele,
							    FIRST))) ) {
			tmp_sri = shp_DerefOne(ELEMENT(sri_ele, SECOND));
			KP_GD_TDDEREF(tmp_sri);
			g_allocp = GetGroupAttr(group, &tmp_sri,
						record
						+ (offset * TWO_BYTE),
						str_cnt,
						(next_offset - offset),
						&consp->car,
						g_allocp);
			*tmp = G_MAKECONS(consp);
			tmp = &consp->cdr;
			consp++;
			*rec_sri = G_CDR_OF(*rec_sri);
			KP_GD_TDDEREF(*rec_sri);
		    }
		} else if ( G_ISFUNCTOR(shp_DerefOne(ELEMENT(sri_ele,
							     FIRST))) ) {
		    /* Negative = {nega(OccNumList), SRI} */
		    occ_list = arg(shp_DerefOne(ELEMENT(sri_ele, FIRST)),
				   SECOND);
		    KP_GD_TDDEREF(occ_list);
		    if ( occ_list == NILATOM ) {
			tmp_sri = NILATOM;
			g_allocp = GetGroupAttr(group, &tmp_sri,
						record
						+ (offset * TWO_BYTE),
						str_cnt,
						(next_offset - offset),
						&consp->car,
						g_allocp);
			*tmp = G_MAKECONS(consp);
			tmp = &consp->cdr;
			consp++;
		    } else {
			while( occ_list != NILATOM ) {
			    occ_list_ele = G_CAR_OF(occ_list);
			    KP_GD_TDDEREF(occ_list_ele);
			    if ( i == G_INTVAL(occ_list_ele) ) {
				break;
			    } else if ( i < G_INTVAL(occ_list_ele) ) {
				tmp_sri
				    = shp_DerefOne(ELEMENT(sri_ele, SECOND));
				KP_GD_TDDEREF(tmp_sri);
				g_allocp = GetGroupAttr(group, &tmp_sri,
							record
							+ (offset * TWO_BYTE),
							str_cnt,
							(next_offset - offset),
							&consp->car,
							g_allocp);
				*tmp = G_MAKECONS(consp);
				tmp = &consp->cdr;
				consp++;
				break;
			    }
			    occ_list = G_CDR_OF(occ_list);
			    KP_GD_TDDEREF(occ_list);
			}
		    }
		    *rec_sri = G_CDR_OF(*rec_sri);
		    KP_GD_TDDEREF(*rec_sri);
		}
	    }
	}
    }
/*
    if ( value_list == (q *)((consp - 1)->cdr) ) {
	consp->car = NILATOM;
 */
    if ( tmp == value_list ) {          /* ͤڤФʤä */
	*value_list = NILATOM;
    } else {                            /* ͤĤǤڤФ */
	(--consp)->cdr = NILATOM;
    }
    return (g_allocp);
}


/* --------------------------------------------------------------------
 *	GetOffsetAndNextOffset
 *        ȤʥեåͤӼinteger°Υեåͤ
 *        Ф
 *
 *      RETURN: եåͤΰ֤˹碌쥳ɥȥ󥰤ؤΥ
 *              
 *
 * --------------------------------------------------------------------
 */

char *
GetOffsetAndNextOffset(int posi, int next_posi, char *record,
		       int field_length, int *offset, int *next_offset,
		       int *nil_flag, int *gk_flag)
{
    int work;          /* ΰ */

    REC_GetInt(work, record+(FOUR_BYTE*posi)+TWO_BYTE);
    *offset = work & OFFSET_MASK;
    *nil_flag = work & NIL_FLAG_MASK;
    *gk_flag = work & GKFLAG_MASK;
    if ( next_posi == LAST ) {
	*next_offset = field_length;
    } else {
	REC_GetInt(work, record+(FOUR_BYTE*next_posi)+TWO_BYTE);
	*next_offset = work & OFFSET_MASK;
    }
    return (record + (*offset * 2));
}


/* --------------------------------------------------------------------
 *	MoveAndReadSRI
 *        ֥쥳ɾ˽󥹥եɤɤ
 *
 *      RETURN:   g_allocp        : KLICǡĥҡΰ賫ϥɥ쥹
 *
 * --------------------------------------------------------------------
 */

q *
MoveAndReadSRI(short occ_cnt, q *rec_sri, char *record, int str_cnt,
	       int field_length, struct shp_AccessPath *access_path,
	       struct ifmt_Group *group, q *value_list, q *g_allocp)
{
    q node_occ_sri;     /* Node */
    q sri_ele;          /* ֥쥳ɾ */
    q sri_child;        /* ֥쥳ɾҾ */
    q occ_list;         /* ֹ */
    q occ_list_ele;     /* ֹ */
    q *tmp;             /* ͥꥹ */

    struct cons *consp; /* ͥꥹ */

    int i, j;           /* FOR LOOP */
    int tmp_cnt = 1;    /* ͥꥹ */
    int work;           /* եåͼ */
    int offset;         /* եå */
    int next_offset;    /* INTEGER°եå */

    tmp = value_list;
    
    G_HEAPALLOC((q)consp, G_SIZE_IN_Q(struct cons)*occ_cnt, (q));
        /* 󥹿ʬΥꥹȥǡΰ */

    for( i = 1; i <= occ_cnt && *rec_sri != NILATOM; i++ ) {
	REC_GetInt(work, (record + ((i - 1) * FOUR_BYTE) + TWO_BYTE));
            /* եåͼФ */
	offset = work & OFFSET_MASK;
	if ( i == occ_cnt ) {        /* INTEGERեåͼФ */
	    work = (int)GetNextOffset(offset, record, LAST, field_length);
 	} else {
	    work = (int)GetNextOffset(offset, record, i, field_length);
	}
	next_offset = work & OFFSET_MASK;
	if ( G_ISATOMIC(*rec_sri) ) { /* SRI == '*', 'nil' */
	    g_allocp
		= ReadAndMoveGroupField(rec_sri, record + (offset * TWO_BYTE),
					str_cnt, (next_offset - offset),
					access_path, group, &consp->car,
					g_allocp);
	    *tmp = G_MAKECONS(consp);
	    tmp = &consp->cdr;
	    consp++;
	} else if ( G_ISFUNCTOR(*rec_sri) ) {
	    /* Leaf Select Info. (Negative) = nega(OccNumList) */
	    occ_list = arg(*rec_sri, SECOND);
	    KP_GD_TDDEREF(occ_list);
	    for( j = 1; j < occ_cnt; j++ ) {
		occ_list_ele = G_CAR_OF(occ_list);
		KP_GD_TDDEREF(occ_list_ele);
		if ( G_INTVAL(occ_list_ele) != j ) {
		    g_allocp
			= ReadAndMoveGroupField(LAST, record
						+ (offset * TWO_BYTE),
						str_cnt,
						(next_offset - offset),
						access_path, group,
						&consp->car, g_allocp);
		    *tmp = G_MAKECONS(consp);
		    tmp = &consp->cdr;
		    consp++;
		} 
		occ_list = G_CDR_OF(occ_list);
		KP_GD_TDDEREF(occ_list);
	    }
	    i = 0;    /* ֹκǽ餫饵ľ */
	} else if ( G_ISCONS(*rec_sri) ) {   /* SRIꥹ */
	    KP_GD_TDDEREF(*rec_sri);
	    sri_ele = G_CAR_OF(*rec_sri);
	    KP_GD_TDDEREF(sri_ele);
	    if ( G_ISINT(sri_ele) ) {
		/* Leaf Select Info. (Positive) = INTEGER */
		if ( G_INTVAL(sri_ele) == i ) {
		    g_allocp
			= ReadAndMoveGroupField(LAST, record
						+ (offset * TWO_BYTE),
						str_cnt,
						(next_offset - offset),
						access_path, group,
						&consp->car, g_allocp);
		    *tmp = G_MAKECONS(consp);
		    tmp = &consp->cdr;
		    consp++;
		    *rec_sri = G_CDR_OF(*rec_sri);
		    KP_GD_TDDEREF(*rec_sri);
		} else if ( G_INTVAL(sri_ele) < i ) {
		    i = 0;    /* ֹκǽ餫饵 */
		}
	    } else if ( G_ISGOBJ(sri_ele) ) {
		/* Node Select Info. (Positive or Negative) */
		if ( G_ISINT(shp_DerefOne(ELEMENT(sri_ele, FIRST))) ) {
		    /* Positive = {OccNum, SRI} */
		    if ( G_INTVAL(shp_DerefOne(ELEMENT(sri_ele, FIRST)))
			== i ) {
			sri_child
			    = (q)(shp_DerefOne(ELEMENT(sri_ele, SECOND)));
			KP_GD_TDDEREF(sri_child);
			g_allocp
			    = ReadAndMoveGroupField(&sri_child, record
						    + (offset * TWO_BYTE),
						    str_cnt,
						    (next_offset - offset),
						    access_path, group,
						    &consp->car, g_allocp);
			*tmp = G_MAKECONS(consp);
			tmp = &consp->cdr;
			consp++;
			*rec_sri = G_CDR_OF(*rec_sri);
			KP_GD_TDDEREF(*rec_sri);
		    } else if ( G_INTVAL(shp_DerefOne(ELEMENT(sri_ele,
							      FIRST))) < i ) {
			i = 0;    /* ֹκǽ餫饵 */
		    }
		} else if ( G_ISFUNCTOR(shp_DerefOne(ELEMENT(sri_ele,
							     FIRST))) ) {
		    /* Negative = {nega(OccNumList), SRI} */
		    occ_list = arg(shp_DerefOne(ELEMENT(sri_ele, FIRST)),
				   SECOND);
		    KP_GD_TDDEREF(occ_list);
		    for( j = 1; j < occ_cnt; j++ ) {
			occ_list_ele = G_CAR_OF(occ_list);
			KP_GD_TDDEREF(occ_list_ele);
			if ( G_INTVAL(occ_list_ele) != j ) {
			    sri_child
				= (q)(shp_DerefOne(ELEMENT(sri_ele, SECOND)));
			    KP_GD_TDDEREF(sri_child);
			    g_allocp 
				= ReadAndMoveGroupField(&sri_child, record
							+ (offset * TWO_BYTE),
							str_cnt,
							(next_offset - offset),
							access_path,
							group, &consp->car,
							g_allocp);
			    *tmp = G_MAKECONS(consp);
			    tmp = &consp->cdr;
			    consp++;
			}
			occ_list = G_CDR_OF(occ_list);
			KP_GD_TDDEREF(occ_list);
		    }
		    *rec_sri = G_CDR_OF(*rec_sri);
		    KP_GD_TDDEREF(*rec_sri);
		    i = 0;    /* ֹκǽ餫饵ľ */
		} else {                       /* Almigty = {*, SRI} */
		    sri_child = (q)(shp_DerefOne(ELEMENT(sri_ele, SECOND)));
		    KP_GD_TDDEREF(sri_child);
		    g_allocp = ReadAndMoveGroupField(&sri_child, record
						     + (offset * TWO_BYTE),
						     str_cnt,
						     (next_offset - offset),
						     access_path, group,
						     &consp->car, g_allocp);
		    *tmp = G_MAKECONS(consp);
		    tmp = &consp->cdr;
		    consp++;
		}
	    }
	}
    }
/*
    if ( value_list == (q *)((consp - 1)->cdr) ) {
	consp->car = NILATOM;
 */
    if ( tmp == value_list ) {          /* ͤڤФʤä */
	*value_list = NILATOM;
    } else {                            /* ͤĤǤڤФ */
	(--consp)->cdr = NILATOM;
    }
    return (g_allocp);
}


/* --------------------------------------------------------------------
 *	ReadAndMoveGroupField
 *        ѥӾν°եڤեɤ
 *        ưԤʤ
 *
 *      RETURN:   g_allocp        : KLICǡĥҡΰ賫ϥɥ쥹
 *
 * --------------------------------------------------------------------
 */

q *
ReadAndMoveGroupField(q *rec_sri, char *record, int str_cnt,
		      int field_length, struct shp_AccessPath *access_path,
		      struct ifmt_Group *group, q *value_list, q *g_allocp)
{
    int offset;         /* եå */
    int next_offset;    /* INTEGER°Υեå */
    int nil_flag;       /* ͥե饰 */
    int gk_flag;        /* ե饰 */
    q sri_ele;          /* ֥쥳ɾ */

    GetOffsetAndNextOffset(access_path->position, 
			   access_path->next_nint_posi,
			   record, field_length, &offset,
			   &next_offset, &nil_flag, &gk_flag);
    if ( access_path != LAST ) {
	sri_ele = GetSRI(*rec_sri, access_path->position);
	/* ѥꥹȤǤʤ */
	/* ʤϤơ֥ľ°Ǥʤ */
    } else {
	sri_ele = *rec_sri;     /* ѥꥹ */
    }
    nil_flag = (nil_flag & NIL_FLAG_MASK) >> NIL_FLAG_SHIFT;
    if ( nil_flag == NIL_FIELD ) {
	*value_list = G_MAKESYM(G_atom(nil));
    } else if ( nil_flag == BOTTOM_FIELD ) {
	*value_list = NILATOM;
    } else {
	g_allocp = MoveAndReadField(access_path->next, group, &sri_ele,
				    record + (offset * TWO_BYTE), 
				    str_cnt, (next_offset - offset),
				    value_list, g_allocp);
    }
    return (g_allocp);
}
