/*
/*	(C)1992, 1993, 1995 Institute for New Generation Computer Technology
/*		ۤ¾COPYRIGHTե򻲾ȤƲ
/*		(Read COPYRIGHT for detailed information.)
 */
/***********************************************************************
 *   FILE NAME
 *	rec_delete.c
 *   DESCRIPTION
 *	RIDΥ쥳ɤ롣
 *   INTERFACE ROUTINES
 *      rec_Delete            - RIDΥ쥳ɤ
 *      
 *   NOTES       
 *	
 *$  EDITOR : Tooru Shida
 *$           (MITSUBISHI ELECTRIC COMPUTER SYSTEMS (TOKYO) CORPORATION)
 *$  CREATE : '94-02-01
 *$  UPDATE : '94-04-20 Wed by Shida(MTC) for Kappa ver.Q02
 *$         : '95-01-13 Fri for Kappa IFS version
 *$
 ***********************************************************************/

#include <stdio.h>
#include <string.h>
#include "rec_delete.h"

short rec_GetShortInt(char **record, int position, int page_size);
int rec_GetInt(char **record, int position, int page_size);

#define GetStringNumber(position, page_size) ((position) / (page_size))

#define NEW_VECTOR3(VECTOR,E0,E1,E2)\
{\
  q *new_vector3_local_vector_body;\
  q argv[1];\
  q vector_g_new();\
  NEW_VECTOR(3, VECTOR);\
  new_vector3_local_vector_body\
    = ((struct vector_object *) G_FUNCTORP(VECTOR))->body;\
  new_vector3_local_vector_body[0] = E0;\
  new_vector3_local_vector_body[1] = E1;\
  new_vector3_local_vector_body[2] = E2;\
}

#define NEW_VECTOR2(VECTOR,E0,E1)\
{\
  q *new_vector2_local_vector_body;\
  q argv[1];\
  q vector_g_new();\
  NEW_VECTOR(2, VECTOR);\
  new_vector2_local_vector_body\
    = ((struct vector_object *) G_FUNCTORP(VECTOR))->body;\
  new_vector2_local_vector_body[0] = E0;\
  new_vector2_local_vector_body[1] = E1;\
}

#define NEW_CONS(LIST,CAR,CDR)\
{\
  struct cons *new_list_local_cons;\
  G_HEAPALLOC((q)new_list_local_cons, G_SIZE_IN_Q(struct cons), (q));\
  new_list_local_cons->car = CAR;\
  new_list_local_cons->cdr = CDR;\
  LIST = G_MAKECONS(new_list_local_cons);\
}


/* --------------------------------------------------------------------
 *	rec_DeleteRecord
 *        ꤵ줿RIDΥ쥳ɤ
 *      
 *      ARGUMENT: table_schema_info : եޥåȤι¤ΤؤΥݥ
 *                string_list       : 쥳ID
 *                page_size         : ڡΥ(Хñ)
 *                idx_del_strm      : ǥå(KLICǡ)
 *                length            : 쥳Ĺ(쥳ɹ)
 *                position          : 쥳ɰ(쥳ɹ)
 *                rec_length        : 쥳Ĺ(쥳ɹ)
 * 
 *      RETURN:   g_allocp        : KLICǡĥҡΰ賫ϥɥ쥹
 *
 * --------------------------------------------------------------------
 */

q *
rec_DeleteRecord(struct shp_SchemaInfo *table_schema_info, char **record,
		 int str_cnt, int page_size, q *idx_del_strm, int *length,
		 int *position, int *rec_length, q *g_allocp)
{
  int record_length;           /* 쥳Ĺ */
  int child_attr_cnt;          /* ° */
  int posi;                    /* 쥳ɥȥ󥰤Ƭа */
  struct shp_ChildInfo *child_attr_info;
                               /* °ꥹ */
  struct shp_TableSchemaInfo *work_schema_info;
                               /* ϤեޥåѴ */
  q occ_list = NILATOM;        /* ǥåѥֹꥹ */

  posi = ( str_cnt == 1 ) ? ZERO : TWO_BYTE;
         /* ѥɥ쥳ɤǤʤ: Ƭȥ󥰤Ƭ֤˰դ */
         /* ѥɥ쥳ɤξ:     ֥åĹ򥹥å */

  record_length = rec_GetInt(record,posi,page_size); /* 쥳Ĺ */
  if ( table_schema_info->sch_info->table_info == NULL ) {
    work_schema_info =
      ((struct ifmt_IFormat *)table_schema_info)->i_format.table_schema_info;
  } else {
    work_schema_info = table_schema_info->sch_info->table_info;
  }
  child_attr_info = work_schema_info->child_attr_info;
  child_attr_cnt = work_schema_info->child_attr_cnt;
  if ( record_length == ALL_NULL_RECORD ) { /* 쥳Τ */
    g_allocp =
      DeleteEmptyAttr(child_attr_info, record, child_attr_cnt, &occ_list,
		      page_size, idx_del_strm, length, position, g_allocp);
  } else { /* 嵭ʳΥ쥳ɷ */
    posi += FOUR_BYTE + FOUR_BYTE;
    record_length -= RL_AREA_LENGTH + RID_AREA_LENGTH;
	   /*  쥳ĹRIDǼΰΥå */
    g_allocp =
      DeleteAttrField(child_attr_info, child_attr_cnt, record, &occ_list,
		      page_size, record_length, posi, idx_del_strm, length,
		      position, g_allocp);
  }
  *rec_length = record_length;
  return g_allocp;
}


/* --------------------------------------------------------------------
 *	DeleteEmptyAttr
 *        ΤͤΥ쥳ɤκ
 *      
 *      RETURN:   g_allocp        : KLICǡĥҡΰ賫ϥɥ쥹
 *
 * --------------------------------------------------------------------
 */

q*
DeleteEmptyAttr(struct shp_ChildInfo *attr_info, char **record, int child_cnt,
		q *occ_list, int page_size, q *idx_del_strm, int *length,
		int *position, q *g_allocp)
{
  declare_globals;

  int i;                     /* FOR LOOP */
  int insert_element = 1;    /* 󥹥ꥹ */
  short empty;               /* ΰǼ 0:nil, 1:bottom */
  q idx_del_strm_ele;        /* ǥå */
  q work_idx_del_strm;       /* ǥåΰ */
  q fix_occ_list;            /* ֤°ѳꥪ󥹥ꥹ */
  q argv[1];                 /* ٥ */
  q vector_g_new();

  empty = rec_GetShortInt(record, (FOUR_BYTE + FOUR_BYTE), page_size);
  empty = (empty = EMPTY_NIL) ? REP_NIL : REP_BOTTOM;

  NEW_VECTOR(child_cnt, work_idx_del_strm);

  for ( i = 0; i < child_cnt || attr_info != NULL; i++) {
    switch( attr_info->type ) {
      /* °ꥹȤƬǤ°פˤʬ */
    case Simple_Integer:   /* ñINTEGER° */ /* FALL THROUGH */
    case Simple:           /* ñ° */
      g_allocp = DeleteEmptySAttr(attr_info->attr_info.info2, empty, occ_list,
				  &idx_del_strm_ele, g_allocp);
      break;
    case Repeat_Simple:    /* ֤ñ° */
      fix_occ_list = GetFixOccList(occ_list, insert_element, g_allocp);
      g_allocp = heapp;
      g_allocp = DeleteEmptyRSAttr(attr_info->attr_info.info2, empty,
				   &fix_occ_list, &idx_del_strm_ele, g_allocp);
      break;
    case Group:            /* ° */
      g_allocp
	= DeleteEmptyGAttr(attr_info->attr_info.info1->child_attr_info,
			   attr_info->attr_info.info1->child_attr_cnt, empty,
			   occ_list, &idx_del_strm_ele, g_allocp);
      break;
    case Repeat_Group:     /* ֤° */
      fix_occ_list = GetFixOccList(occ_list, insert_element, g_allocp);
      g_allocp = heapp;
      g_allocp
	= DeleteEmptyGAttr(attr_info->attr_info.info1->child_attr_info,
			   attr_info->attr_info.info1->child_attr_cnt, empty,
			   &fix_occ_list, &idx_del_strm_ele, g_allocp);
      break;
    default:          /* 嵭ʳ */
      break;
    }
    *(((struct vector_object *)G_FUNCTORP(work_idx_del_strm))->body + i)
      = idx_del_strm_ele;
    attr_info = attr_info->next;
  }
  *idx_del_strm = work_idx_del_strm;

  return g_allocp;
}


/* --------------------------------------------------------------------
 *	DeleteEmptySAttr
 *        ΤͤǤñ°ͤκ
 *      
 *      RETURN:   g_allocp        : KLICǡĥҡΰ賫ϥɥ쥹
 *
 * --------------------------------------------------------------------
 */

q *
DeleteEmptySAttr(struct shp_AttrInfo2 *simple_info, short empty,
		 q *occ_list, q *idx_del_strm, q *g_allocp)
{
  q work_idx_del_strm;       /* ǥåΰ */
  q idx_del_strm_ele;

  declare_globals;

  if ( simple_info->acc_request->index_id == NOT_INDEXED ) {
    *idx_del_strm = NILATOM;
    /* ǥå˶ꥹȤǼƽλ */
  } else {
    NEW_VECTOR3(idx_del_strm_ele,
		G_MAKESYM(enter_atom_cstring(simple_info->attr_name)),
		*occ_list,
		G_MAKESYM((empty==REP_NIL) ? G_atom(nil) : G_atom(bottom)));
    NEW_CONS(*idx_del_strm, idx_del_strm_ele, NILATOM);
  }
  return g_allocp;
}


/* --------------------------------------------------------------------
 *	DeleteEmptyRSAttr
 *        ΤͤǤñ°ͤκ
 *      
 *      RETURN:   g_allocp        : KLICǡĥҡΰ賫ϥɥ쥹
 *
 * --------------------------------------------------------------------
 */

q *
DeleteEmptyRSAttr(struct shp_AttrInfo2 *simple_info, short empty,
		  q *occ_list, q *idx_del_strm, q *g_allocp)
{
  int insert_element = 1;    /* 󥹥ꥹ */
  q attr_name;               /* ǥåդ°̾ */
  q fix_occ_list;            /* ꥪ󥹥ꥹ */
  q idx_del_strm_ele;

  declare_globals;

  if ( simple_info->acc_request->index_id == NOT_INDEXED ) {
    /* ǥå˶ꥹȤǼƽλ */
    *idx_del_strm = NILATOM;
  } else {
    fix_occ_list = GetFixOccList(occ_list, insert_element, g_allocp);
    g_allocp = heapp;
    NEW_VECTOR3(idx_del_strm_ele,
		G_MAKESYM(enter_atom_cstring(simple_info->attr_name)),
		fix_occ_list,
		G_MAKESYM((empty == REP_NIL) ?G_atom(nil):G_atom(bottom)));
    NEW_CONS(*idx_del_strm, idx_del_strm_ele, NILATOM);
  }
  return g_allocp;
}


/* --------------------------------------------------------------------
 *	DeleteEmptyGAttr
 *        ΤͤΥ쥳ɤκ
 *      
 *      RETURN:   g_allocp        : KLICǡĥҡΰ賫ϥɥ쥹
 *
 * --------------------------------------------------------------------
 */

q *
DeleteEmptyGAttr(struct shp_ChildInfo *child_attr_info, int attr_cnt,
		 short empty, q *occ_list, q *idx_del_strm, q *g_allocp)
{
  declare_globals;

  int i;                 /* FOR LOOP */
  int insert_element = 1;/* 󥹥ꥹ */
  q idx_del_strm_ele;    /* ǥå */
  q work_idx_del_strm;   /* ǥåΰ */
  q fix_occ_list;        /* ֤°ѳꥪ󥹥ꥹ */
  struct shp_AttrInfo2 *simple_info;    /* ñ° */
  struct shp_AttrInfo1 *group_info;     /* ° */

  q argv[1];             /* ٥ */
  q vector_g_new();      /* ٥ */

  NEW_VECTOR(attr_cnt, work_idx_del_strm);

  for ( i = 0; i < attr_cnt || child_attr_info != NULL ; i++) {
    switch( child_attr_info->type ) {
	    /* °ꥹȤƬǤ°פˤʬ */
    case Simple_Integer:   /* ñINTEGER° */ /* FALL THROUGH */
    case Simple:           /* ñ° */
      simple_info = child_attr_info->attr_info.info2;
      g_allocp = DeleteEmptySAttr(simple_info, empty, occ_list,
				  &idx_del_strm_ele, g_allocp);
      break;
    case Repeat_Simple:    /* ֤ñ° */
      simple_info = child_attr_info->attr_info.info2;
      fix_occ_list = GetFixOccList(occ_list, insert_element, g_allocp);
      g_allocp = heapp;
      g_allocp = DeleteEmptyRSAttr(simple_info, empty, &fix_occ_list,
				   &idx_del_strm_ele, g_allocp);
      break;
    case Group:            /* ° */
      group_info = child_attr_info->attr_info.info1,
      g_allocp = DeleteEmptyGAttr(group_info->child_attr_info,
				  group_info->child_attr_cnt, empty, occ_list,
				  &idx_del_strm_ele, g_allocp);
      break;
    case Repeat_Group:     /* ֤° */
      group_info = child_attr_info->attr_info.info1,
      fix_occ_list = GetFixOccList(occ_list, insert_element, g_allocp);
      g_allocp = heapp;
      g_allocp = DeleteEmptyGAttr(group_info->child_attr_info,
				  group_info->child_attr_cnt, empty,
				  &fix_occ_list, &idx_del_strm_ele, g_allocp);
      break;
    default:          /* 嵭ʳ */
      break;
    }
    *(((struct vector_object *) G_FUNCTORP(work_idx_del_strm))->body + i)
      = idx_del_strm_ele;
    child_attr_info = child_attr_info->next;
  }
  *idx_del_strm = work_idx_del_strm;

  return g_allocp;
}


/* --------------------------------------------------------------------
 *	DeleteAttrField
 *        ̾Υ쥳ɤκ
 *      
 *      RETURN:   g_allocp        : KLICǡĥҡΰ賫ϥɥ쥹
 *
 * --------------------------------------------------------------------
 */

q *
DeleteAttrField(struct shp_ChildInfo *child_attr_info, int child_attr_cnt,
		char **record, q *occ_list, int page_size, int record_length,
		int posi,q *idx_del_strm,int *length,int *position,q *g_allocp)
{
  declare_globals;

  int i;                            /* FOR LOOP */
  int next_posi;                    /* о° */
  int work;                         /* եåͼФѺΰ */
  int offset;                       /* о°եå */
  int next_offset;                  /* о°եå */
  short empty;                      /* ͥե饰 */
  short child_cnt;                  /* 롼פλ° */
  struct shp_AttrInfo2 *simple_info;/* ñ° */
  struct shp_AttrInfo1 *group_info; /* ° */
  q work_idx_del_strm;              /* ǥåɲþΰ */
  q idx_del_strm_ele;               /* ǥåɲþ */

  q argv[1];                        /* ٥ */
  q vector_g_new();                 /* ٥ */

  child_cnt = rec_GetShortInt(record, posi, page_size);
  NEW_VECTOR(child_attr_cnt, work_idx_del_strm);

/*    if ( i == (child_cnt - ONE_ATTR) ) {  /* о°ǽ°ξ */
/*      next_posi = REC_LAST_ATTR;
/*    } else { /* о°ǽ°ξ */
/*      next_posi = i + ONE_ATTR;
/*    }
/*    work = rec_GetInt(record, (posi+(i*FOUR_BYTE)+TWO_BYTE), page_size);
/*    offset = work & OFFSET_MASK;
/*    empty = (work & NIL_FLAG_MASK) >> NIL_FLAG_SHIFT;
/*    if ( empty & REP_NIL_BOTTOM ) { /* ͥե饰nilޤbottomξ */
/*      switch( child_attr_info->type ) {
/*      case Simple_Integer: /* FALL THROUGH */
/*      case Simple:
/*	g_allocp = DeleteEmptySAttr(child_attr_info->attr_info.info2, empty,
/*				    occ_list, &idx_del_strm_ele, g_allocp);
/*	break;
/*      case Repeat_Simple:
/*	g_allocp = DeleteEmptyRSAttr(child_attr_info->attr_info.info2, empty,
/*				     occ_list, &idx_del_strm_ele, g_allocp);
/*	break;
/*      case Group: /* FALL THROUGH */
/*      case Repeat_Group:
/*	g_allocp =
/*	  DeleteEmptyGAttr(child_attr_info->attr_info.info1->child_attr_info,
/*			   child_attr_info->attr_info.info1->child_attr_cnt,
/*			   empty, occ_list, &idx_del_strm_ele, g_allocp);
/*	break;
/*      default:
/*	break;
/*      }
 */

  for( i = 0; i < child_cnt; i++ ) {
    if ( i == (child_cnt - ONE_ATTR) ) { /* о°ǽ°ξ */
      next_offset= record_length;
    } else { /* ǽ°ξ */
      if ( child_attr_info->type == Group ||
	  child_attr_info->type == Repeat_Group ) {
	if ( child_attr_info->attr_info.info1->next_nint_posi == 0 ) {
	  next_offset= record_length;
	} else {
	  work = rec_GetInt(record, (posi+(TWO_BYTE+(FOUR_BYTE*
		       child_attr_info->attr_info.info1->next_nint_posi))),
			    page_size);
	  next_offset = work & OFFSET_MASK;
	}
      } else { /* Simple_Integer, Simple, Repeat_Simple */
	if ( child_attr_info->attr_info.info2->next_nint_posi == 0 ) {
	  next_offset= record_length;
	} else {
	  work = rec_GetInt(record, (posi+(TWO_BYTE+(FOUR_BYTE*
		       child_attr_info->attr_info.info2->next_nint_posi))),
			    page_size);
	  next_offset = work & OFFSET_MASK;
	}
      }
    }
    if ( i == (child_cnt - ONE_ATTR) ) {  /* о°ǽ°ξ */
      next_posi = REC_LAST_ATTR;
    } else { /* о°ǽ°ξ */
      next_posi = i + ONE_ATTR;
    }
    offset = rec_GetInt(record, (posi+(i*FOUR_BYTE)+TWO_BYTE), page_size)
      & OFFSET_MASK;

    switch( child_attr_info->type ) {
    case Simple_Integer: /* FALL THROUGH */
    case Simple:
      simple_info = child_attr_info->attr_info.info2;
      g_allocp =
	DeleteSimpleAttr(simple_info->acc_request, posi, i, next_posi,
			 next_offset, simple_info->data_type,
			 simple_info->attr_name, occ_list, record, page_size,
			 &idx_del_strm_ele, length, position, g_allocp);
      break;
    case Repeat_Simple:
      simple_info = child_attr_info->attr_info.info2;
      g_allocp =
	DeleteRepeatSimpleAttr(simple_info->acc_request, (posi+(offset*2)),
			       (next_offset-offset), simple_info->data_type,
			       simple_info->attr_name, occ_list, record,
			       page_size, &idx_del_strm_ele, length,
			       position, g_allocp);
      break;
    case Group:
      group_info = child_attr_info->attr_info.info1;
      g_allocp = 
	DeleteAttrField(group_info->child_attr_info,group_info->child_attr_cnt,
			record, occ_list, page_size, (next_offset-offset),
			(posi+(offset*2)), &idx_del_strm_ele, length, position,
			g_allocp);
      break;
    case Repeat_Group:
      group_info = child_attr_info->attr_info.info1;
      g_allocp =
	DeleteRepeatGroupAttr(group_info, (posi+(offset*2)), 
			      (next_offset-offset),record,occ_list,page_size,
			      &idx_del_strm_ele, length, position, g_allocp);
      break;
    default:
      break;
    }
    child_attr_info = child_attr_info->next;
    *(((struct vector_object *) G_FUNCTORP(work_idx_del_strm))->body + i)
      = idx_del_strm_ele;
  }
  empty = REP_NIL;
  for( ; i < child_attr_cnt; i++ ) {
    switch( child_attr_info->type ) {
    case Simple_Integer: /* FALL THROUGH */
    case Simple:
      g_allocp = DeleteEmptySAttr(child_attr_info->attr_info.info2, empty,
				  occ_list, &idx_del_strm_ele, g_allocp);
      break;
    case Repeat_Simple:
      g_allocp = DeleteEmptyRSAttr(child_attr_info->attr_info.info2, empty,
				   occ_list, &idx_del_strm_ele, g_allocp);
      break;
    case Group: /* FALL THROUGH */
    case Repeat_Group:
      g_allocp =
	DeleteEmptyGAttr(child_attr_info->attr_info.info1->child_attr_info,
			 child_attr_info->attr_info.info1->child_attr_cnt,
			 empty, occ_list, &idx_del_strm_ele, g_allocp);
      break;
    default:
      break;
    }
    child_attr_info = child_attr_info->next;
    *(((struct vector_object *) G_FUNCTORP(work_idx_del_strm))->body + i)
      = idx_del_strm_ele;
  }
  *idx_del_strm = work_idx_del_strm;
  return g_allocp;
}

/* --------------------------------------------------------------------
 *	DeleteSimpleAttr
 *        ñ°եɤκ
 *
 *      RETURN:   g_allocp        : KLICǡĥҡΰ賫ϥɥ쥹
 *
 * --------------------------------------------------------------------
 */

q *
DeleteSimpleAttr(struct shp_AccessRequest *acc_request, int posi,int attr_posi,
		 int next_posi, int record_length, enum shp_DataType data_type,
		 char *attr_name, q *occ_list, char **record, int page_size,
		 q *idx_del_strm, int *length, int *position, q *g_allocp)
{
    int work;                  /* ͼѺΰ */
    int offset;                /* о°եå */
    int next_offset;           /* о°եå */
    int gk_flag;               /* ե饰 */
    int nil_flag;              /* ͥե饰 */
    q tmp;                     /* ꥹȥǡ */
    struct shp_IndexAttrList *ia_list;
                               /* ǥåΤ° */
    q idx_del_strm_ele;        /* ǥå */
    q idx_del_strm_tail;        /* ǥå */
    q attr_value;              /* ǥå°° */
    q attr_name_klic;          /* ǥå°̾KLICǡ */

    declare_globals;

    work = rec_GetInt(record, (posi+(attr_posi*FOUR_BYTE)+TWO_BYTE),page_size);
    nil_flag = (work & NIL_FLAG_MASK) >> NIL_FLAG_SHIFT;
    gk_flag = (work & GKFLAG_MASK) >> GKFLAG_SHIFT;
    offset = work & OFFSET_MASK;

    if ( next_posi == REC_LAST_ATTR ) {	/* о°ǽ°ξ */
      next_offset = record_length;
    } else {                            /* о°ǽ°ξ */
      work =rec_GetInt(record,(posi+(next_posi*FOUR_BYTE)+TWO_BYTE),page_size);
      next_offset = work & OFFSET_MASK;
    }

    ia_list = acc_request->ia_list;

    if ( acc_request->index_id == NOT_INDEXED && ia_list == NULL ) {
	/* ǥåʤǥåΤ°ʤ */
      *idx_del_strm = NILATOM;
    } else if(nil_flag != 0 && acc_request->index_id != NOT_INDEXED
	      && ia_list == NULL) {
      NEW_VECTOR3(idx_del_strm_ele,
		  G_MAKESYM(enter_atom_cstring(attr_name)), *occ_list,
		  G_MAKESYM((nil_flag==REP_NIL) ? G_atom(nil):G_atom(bottom)));
      NEW_CONS(*idx_del_strm, idx_del_strm_ele, NILATOM);
    } else if ( acc_request->index_id != NOT_INDEXED && ia_list == NULL ) {
      /* ǥåꡣǥåΤ°ʤ */
      g_allocp =
	ReadSimple(offset, next_offset, (posi+(offset*TWO_BYTE)), data_type,
		   gk_flag, page_size, record, &attr_value, g_allocp);
      NEW_VECTOR3(idx_del_strm_ele, G_MAKESYM(enter_atom_cstring(attr_name)),
		  *occ_list, attr_value);
      NEW_CONS(*idx_del_strm, idx_del_strm_ele, NILATOM);
    } else if ( acc_request->index_id == NOT_INDEXED && ia_list != NULL ) {
      /* ǥåʤǥåΤ° */
      g_allocp =
	ReadSimple(offset, next_offset, (posi+(offset*TWO_BYTE)), data_type,
		   gk_flag, page_size, record, &attr_value, g_allocp);
      g_allocp = CreateOnlyIndexDeleteInfo(attr_name, ia_list, &attr_value,
					   occ_list, idx_del_strm, g_allocp);
    } else { /* ǥåꡣǥåΤ° */
      g_allocp =
	ReadSimple(offset, next_offset, (posi+(offset*TWO_BYTE)), data_type,
		   gk_flag, page_size, record, &attr_value, g_allocp);
      g_allocp = 
	  CreateOnlyIndexDeleteInfo(attr_name, ia_list, &attr_value,
				    occ_list, &idx_del_strm_tail, g_allocp);
      NEW_VECTOR3(idx_del_strm_ele, G_MAKESYM(enter_atom_cstring(attr_name)),
		  *occ_list, attr_value);
      NEW_CONS(*idx_del_strm, idx_del_strm_ele, idx_del_strm_tail);
    }
    return g_allocp;
}


/* --------------------------------------------------------------------
 *	DeleteRepeatSimpleAttr
 *        ֤ñ°եɤκ
 *
 *      RETURN:   g_allocp        : KLICǡĥҡΰ賫ϥɥ쥹
 *
 * --------------------------------------------------------------------
 */

q *
DeleteRepeatSimpleAttr(struct shp_AccessRequest *acc_request, int posi,
		       int record_length, enum shp_DataType data_type,
		       char *attr_name, q *occ_list, char **record,
		       int page_size, q *idx_del_strm, int *length,
		       int *position, q *g_allocp)
{
  declare_globals;

  int i;                      /* FOR LOOP */
  int work;                   /* եåͼѺΰ */
  int offset;                 /* оݥ󥹥եå */
  int next_offset;            /* оݥ󥹥եå */
  int gk_flag;                /* ե饰 */
  short occ_cnt;              /* о°󥹿 */
  short empty;                /* ͥե饰 */
  int empty_cnt;              /* ͥե饰 */
  q attr_value;               /*  */
  q idx_del_strm_ele;         /* ƥ󥹤Υǥå */
  q work_idx_del_strm;        /* ǥåΰ */
  q work_idx_del_strm_ele;    /* ǥåΰ */
  q work_idx_del_strm_head;   /* ǥåΰ */
  q work_idx_del_strm_tail;   /* ǥåΰ */
  q tmp;                      /* ꥹȥǡ */
  q attr_name_klic;           /* ǥå°̾KLICǡ */
  q fix_occ_list;             /* ֤°ѳꥪ󥹥ꥹ */
  q argv[1];                  /* ٥ */
  q vector_g_new();           /* ٥ */
  q *vector_body;
  q *work_idx_del_strm_body;

  if ( acc_request->index_id == NOT_INDEXED && acc_request->ia_list == NULL ) {
                               /* ǥåʤǥåΤ°ʤ */
    *idx_del_strm = NILATOM;
    return g_allocp;
  }

  /* ʤ餫ΥǥåΤǥͤɤ */
  occ_cnt = rec_GetShortInt(record, posi, page_size);
  empty = rec_GetShortInt(record, (posi+TWO_BYTE), page_size);
  if ( empty == REP_NIL_BOTTOM ) {
    empty_cnt = 2;
  } else if ( empty == 0 ) { 
    empty_cnt = 0;
  } else {
    empty_cnt = 1;
  }
  /* оݷ֤ñ°Υ󥹿Ф */
  NEW_VECTOR((occ_cnt + empty_cnt), work_idx_del_strm);
  work_idx_del_strm_body
    = ((struct vector_object *) G_FUNCTORP(work_idx_del_strm))->body;
    /* ǥåΥȥ꡼򥪥󥹿ʬʬ */
  for( i = 1; i <= occ_cnt; i++ ) {
	    /* ƥ󥹤°ͤФ륤ǥå */
    work = rec_GetInt(record,
		      (posi+(TWO_BYTE+TWO_BYTE+(FOUR_BYTE*(i-1)))),page_size);
    offset = work & OFFSET_MASK;
    gk_flag = (work & GKFLAG_MASK) >> GKFLAG_SHIFT;
    if ( i == occ_cnt ) { /* ǽ󥹤ξ */
      next_offset = record_length;
    } else {              /* ǽ󥹤ξ */
      work =
	rec_GetInt(record, (posi+(TWO_BYTE+TWO_BYTE+(FOUR_BYTE*i))),page_size);
      next_offset = work & OFFSET_MASK;
    }
    g_allocp =
      ReadSimple(offset, next_offset, (posi+(offset*TWO_BYTE)), data_type,
		 gk_flag, page_size, record, &attr_value, g_allocp);
    fix_occ_list = GetFixOccList(occ_list, i, g_allocp);
    g_allocp = heapp;
    if(acc_request->index_id != NOT_INDEXED && acc_request->ia_list == NULL){
		/* ǥåꡣǥåΤ°ʤ */
      NEW_VECTOR3(work_idx_del_strm_ele,
		  G_MAKESYM(enter_atom_cstring(attr_name)),
		  fix_occ_list, attr_value);
      NEW_CONS(idx_del_strm_ele, work_idx_del_strm_ele, NILATOM);
    } else if ( acc_request->index_id == NOT_INDEXED
	       && acc_request->ia_list != NULL ) {
		/* ǥåʤǥåΤ° */
      g_allocp =
	CreateOnlyIndexDeleteInfo(attr_name,acc_request->ia_list,&attr_value,
				  &fix_occ_list, &idx_del_strm_ele,g_allocp);
    } else { /* ǥåꡣǥåΤ° */
      g_allocp =
	CreateOnlyIndexDeleteInfo(attr_name,acc_request->ia_list,&attr_value,
			       &fix_occ_list,&work_idx_del_strm_tail,g_allocp);
      NEW_VECTOR3(work_idx_del_strm_head,
		  G_MAKESYM(enter_atom_cstring(attr_name)),
		  fix_occ_list, attr_value);
      NEW_CONS(idx_del_strm_ele,work_idx_del_strm_head,work_idx_del_strm_tail);
    }
    work_idx_del_strm_body[i-1] = idx_del_strm_ele;
  }
  if ( empty & REP_NIL ) { 
    fix_occ_list = GetFixOccList(occ_list, i, g_allocp);
    g_allocp = heapp;
    NEW_VECTOR3(work_idx_del_strm_ele,G_MAKESYM(enter_atom_cstring(attr_name)),
		fix_occ_list, G_MAKESYM(G_atom(nil)));
    NEW_CONS(idx_del_strm_ele, work_idx_del_strm_ele, NILATOM);
    work_idx_del_strm_body[i++ -1] = idx_del_strm_ele;
  }
  if ( empty & REP_BOTTOM ) { 
    fix_occ_list = GetFixOccList(occ_list, i, g_allocp);
    g_allocp = heapp;
    NEW_VECTOR3(work_idx_del_strm_ele,
		G_MAKESYM(enter_atom_cstring(attr_name)),
		fix_occ_list, G_MAKESYM(G_atom(bottom)));
    NEW_CONS(idx_del_strm_ele, work_idx_del_strm_ele, NILATOM);
    work_idx_del_strm_body[i-1] = idx_del_strm_ele;
  }	
  *idx_del_strm = work_idx_del_strm;
  return g_allocp;
}

/* --------------------------------------------------------------------
 *	DeleteRepeatGroupAttr
 *        ֤°եɤκ
 *
 *      RETURN:   g_allocp        : KLICǡĥҡΰ賫ϥɥ쥹
 *
 * --------------------------------------------------------------------
 */

q *
DeleteRepeatGroupAttr(struct shp_AttrInfo1 *attr_info, int posi,
		      int record_length, char **record, q *occ_list,
		      int page_size, q *idx_del_strm, int *length,
		      int *position, q *g_allocp)
{
  declare_globals;

  int i;                  /* FOR LOOP */
  int occ_cnt;          /* 󥹿 */
  int empty, empty_cnt;
  struct shp_ChildInfo *child_attr_info;
  int child_attr_cnt;
  int offset;             /* о°եå */
  int next_offset;        /* о°եå */
  int work;               /* եåͼФѺΰ */
  int gk_flag;            /* ե饰 */
  q idx_del_strm_ele;     /* ǥå */
  q work_idx_del_strm;    /* ǥåΰ */
  q *work_idx_del_strm_body;
  q fix_occ_list;         /* ֤°ѳꥪ󥹥ꥹ */
  q argv[1];              /* ٥ */
  q vector_g_new();

  occ_cnt = rec_GetShortInt(record, posi, page_size);
  empty = rec_GetShortInt(record, (posi+TWO_BYTE), page_size);
  if ( empty == REP_NIL_BOTTOM ) {
    empty_cnt = 2;
  } else if ( empty == 0 ) { 
    empty_cnt = 0;
  } else {
    empty_cnt = 1;
  }
  NEW_VECTOR((occ_cnt + empty_cnt), work_idx_del_strm);
  work_idx_del_strm_body =
    ((struct vector_object *)G_FUNCTORP(work_idx_del_strm))->body;

  child_attr_info = attr_info->child_attr_info;
  child_attr_cnt  = attr_info->child_attr_cnt;

  for ( i = 1; i <= occ_cnt; i++ ) {
    work = rec_GetInt(record, (posi+(TWO_BYTE+(FOUR_BYTE*(i-1)))), page_size);
    offset = work & OFFSET_MASK;
    gk_flag = (work & GKFLAG_MASK) >> GKFLAG_SHIFT;
    if ( i == occ_cnt ) { /* ǽ󥹤ξ */
      next_offset = record_length;
    } else { /* ǽ󥹤ξ */
      work = rec_GetInt(record, (posi+(TWO_BYTE+(FOUR_BYTE*i))), page_size);
      next_offset = work & OFFSET_MASK;
    }
    fix_occ_list = GetFixOccList(occ_list, i, g_allocp);
    g_allocp = heapp;
    g_allocp =
      DeleteAttrField(child_attr_info, child_attr_cnt, record, &fix_occ_list,
		      page_size, (next_offset - offset), (posi + (offset * 2)),
		      &idx_del_strm_ele, length, position, g_allocp);
    work_idx_del_strm_body[i-1] = idx_del_strm_ele;
  }

  if ( empty & REP_NIL ) { 
    fix_occ_list = GetFixOccList(occ_list, i, g_allocp);
    g_allocp = heapp;
    g_allocp =
      DeleteEmptyGAttr(child_attr_info, child_attr_cnt, REP_NIL, occ_list,
		       &idx_del_strm_ele, g_allocp);
    work_idx_del_strm_body[i++ -1] = idx_del_strm_ele;
  }
  if ( empty & REP_BOTTOM ) { 
    fix_occ_list = GetFixOccList(occ_list, i, g_allocp);
    g_allocp = heapp;
    g_allocp =
      DeleteEmptyGAttr(child_attr_info, child_attr_cnt, REP_BOTTOM, occ_list,
		       &idx_del_strm_ele, g_allocp);
    work_idx_del_strm_body[i-1] = idx_del_strm_ele;
  }	
  *idx_del_strm = work_idx_del_strm;
  return g_allocp;
}

/* --------------------------------------------------------------------
 *	rec_GetShortInt
 *        Kappa쥳ɽʸǼؿ
 *
 *      RETURN:   ԡʸؤΥݥ
 *
 * --------------------------------------------------------------------
 */

short
rec_GetShortInt(char **record, int position, int page_size)
{
    char *string;           /* оʸ */
    int string_posi;        /* Ǽ쥳ɥȥֹ */
    int offset_position;    /* Ǽ٤쥳ΰǤа */
    short ret_val;

    offset_position = position % page_size;
    string_posi = GetStringNumber(position, page_size);
    string = record[string_posi] + offset_position;

    GET_SHORT_INTEGER_NM(ret_val, string);
    return ret_val;
}

/* --------------------------------------------------------------------
 *	rec_GetShortInt
 *        Kappa쥳ɽʸǼؿ
 *
 *      RETURN:   ԡʸؤΥݥ
 *
 * --------------------------------------------------------------------
 */

int
rec_GetInt(char **record, int position, int page_size)
{
    char *string;           /* оʸ */
    int string_posi;        /* Ǽ쥳ɥȥֹ */
    int offset_position;    /* Ǽ٤쥳ΰǤа */
    int ret_val;
    unsigned short ret_val_h, ret_val_l;

    offset_position = position % page_size;
    string_posi = GetStringNumber(position, page_size);
    string = record[string_posi] + offset_position;

    if( offset_position == (page_size - 2) ) {
      GET_SHORT_INTEGER_NM(ret_val_h, string);
      GET_SHORT_INTEGER_NM(ret_val_l, record[string_posi+1]);
      ret_val = (ret_val_h << 16) | ret_val_l;
    } else {
      GET_INTEGER_NM(ret_val, string);
    }
    return ret_val;
}


/* --------------------------------------------------------------------
 *	ReadSimple
 *        ñ°եɤ°ͼФ
 *
 *      RETURN:   g_allocp        : KLICǡĥҡΰ賫ϥɥ쥹
 *
 * --------------------------------------------------------------------
 */

q *
ReadSimple(int offset, int next_offset, int posi,
	   enum shp_DataType data_type,
	   int gk_flag, int page_size, char **record, q *attr_value,
	   q *g_allocp)
{
    int i, j;                  /* FOR LOOP */
    int string_number;         /* о°եɥȥֹ */
    int string_cnt;            /* °ͤѤƤ륹ȥܿ */
    int work_attr_length;      /* °Ĺ */
    char *work_record;         /* оݥȥ */
    char *tmp;                 /* string°ΰ */
    q old_string;              /* ° decode ѥꥢ */
    int malloc_f, conv_str_len;

    declare_globals;

    int attr_length = (((next_offset & OFFSET_MASK) << FOUR_BYTE)
		       >> FOUR_BYTE) - (((offset) << FOUR_BYTE)
					>> FOUR_BYTE);
    /* о°Ĺ  INTEGER°  о° */

    attr_length = attr_length * 2;
    if ( data_type == Integer ) {
	/* о°Υǡ Integer */
	*attr_value = G_MAKEINT(offset);
    } else {
	/* о°Υǡ Integer ʳ */
	string_number = GetStringNumber(posi, page_size);
	if ( ((posi % page_size) + attr_length) > page_size ) {
	    /* °ͤʣڡϤäƤ */
	    string_cnt
		= ((posi % page_size) + attr_length) / page_size;
	    if ( (((posi % page_size) + attr_length)
		  / page_size) > 0 ) {
		string_cnt = string_cnt + 1;
	    }
	    malloc_f = 1;
	    work_record = (char *)malloc(attr_length);
	    work_attr_length = attr_length;
	    for ( i = (posi % page_size); i < page_size;
		 i++, work_record++, work_attr_length-- ) {
		/* °ƬʬڤФ */
		*work_record = record[string_number][i];
	    }
	    for ( i = 1; i < string_cnt; i++, string_number++ ) {
		/* ³°եɤڤФ */
		for ( j = 0; j < page_size || work_attr_length != 0;
		     j++, work_record++, work_attr_length--) {
		    *work_record = record[string_number + i][j];
		}
	    }
	} else {
	  malloc_f = 0;
	  work_record = &record[string_number][posi];
	}
	switch( data_type ) {
	case String:
	    /* о°Υǡ String (= EUC) */
	    if ( gk_flag ) attr_length--;
	    CONVERT_BINARY_C_STRING_TO_KLIC_STRING(work_record,
						   attr_length, *attr_value);
	    break;
	case Psi_String:
	    /* о°Υǡ Psi_String (= PSI) */
	    tmp = (char *) malloc(attr_length);
	    conv_str_len = Psi2Euc(attr_length, work_record, tmp);
	    CONVERT_BINARY_C_STRING_TO_KLIC_STRING(tmp, conv_str_len, *attr_value);
	    free(tmp);
	    break;
	default:
	    break;
	}
	if(malloc_f) free(work_record);
    }
    
    return (g_allocp);
}
	


/* --------------------------------------------------------------------
 *	CreateOnlyIndexDeleteInfo
 *        ǥåΤ°κ
 *      
 *      RETURN:   g_allocp        : KLICǡĥҡΰ賫ϥɥ쥹
 *
 *$   UPDATE : '95-01-13 Fri for Kappa IFS version
 * --------------------------------------------------------------------
 */

q *
CreateOnlyIndexDeleteInfo(char *attr_name,
			  struct shp_IndexAttrList *ia_list,
			  q *attr_value, q *occ_list, q *idx_del_strm,
			  q *g_allocp)
{
    declare_globals;

    char *work;           /* KLIC -> C ʸ¸ */
    char *work_str;       /* ʸùѺΰ */
    char *work_work;      /* ʸùѺΰ */
    char *index_str;      /* ǥåʸ */
    char *index_str2;     /* ǥåɲʸ */
    int position;         /* ʸڤ */
    int length;           /* ʸڤĹ */
    int string_size;      /* °ͤĹ */
    struct cons *consp;   /* ǥåꥹ */
    q *tmp;               /* ǥå */
    q idx_del_info;       /* ǥåΥ٥ȥ */
    q sub_info;           /* SubString, ScanStringѥ٥ΰ */
    q work_attr;          /* Ȥ߹ߴؿˤ뽤° */
    q argv[1];            /* ٥ */
    q vector_g_new();

    KP_GD_TDDEREF(*attr_value);
    tmp = idx_del_strm;
    work_str = convert_klic_string_to_c_string(*attr_value);
    string_size = strlen(work_str);

    while ( ia_list != NULL ) {
	/* ƤΥǥåΤ°Фɲþ */
	switch ( ia_list->id ) {
	case Substr:        /* substring */
	    CONVERT_C_STRING_TO_KLIC_STRING(work_str, work_attr);
	    NEW_VECTOR3(sub_info, work_attr,
			G_MAKEINT(ia_list->index_attr->substr->position),
			G_MAKEINT(ia_list->index_attr->substr->length));
	    work_attr = sub_info;
	    break;
	case Concat1:       /* concatenate 1 (tail) */
	    index_str = (char *) malloc(string_size
			 + strlen(ia_list->index_attr->string_list) + 1);
	    index_str[0] = 0;
	    index_str = strcat(index_str, work_str);
	    index_str = strcat(index_str, ia_list->index_attr->string_list);
	    CONVERT_C_STRING_TO_KLIC_STRING(index_str, work_attr);
	    free(index_str);
	    break;
	case Concat2:       /* concatenate 2 (head) */
	    index_str = (char *) malloc(string_size
			 + strlen(ia_list->index_attr->string_list) + 1);
	    index_str[0] = 0;
	    index_str = strcat(index_str, ia_list->index_attr->string_list);
	    index_str = strcat(index_str, work_str);
	    CONVERT_C_STRING_TO_KLIC_STRING(index_str, work_attr);
	    free(index_str);
	    break;
	case Concat3:       /* concatenate 3 (head & tail) */
	    index_str =
	      (char *) malloc(string_size + 1
			      + strlen(ia_list->index_attr->concat3->string1),
			      + strlen(ia_list->index_attr->concat3->string2));
	    index_str[0] = 0;
	    index_str = strcat(index_str, ia_list->index_attr->concat3->string1);
	    index_str = strcat(index_str, work_str);
	    index_str = strcat(index_str, ia_list->index_attr->concat3->string2);
	    CONVERT_C_STRING_TO_KLIC_STRING(index_str, work_attr);
	    free(index_str);
	    break;
	case Reverse:       /* reverse string */
	    index_str = ReverseString(work_str);
	    CONVERT_C_STRING_TO_KLIC_STRING(index_str, work_attr);
	    free(index_str);
	    break;
	case Scan:          /* scan string */
	    CONVERT_C_STRING_TO_KLIC_STRING(work_str, work_attr);
	    NEW_VECTOR2(sub_info, work_attr,
			G_MAKEINT(ia_list->index_attr->length));
	    work_attr = sub_info;
	    break;
	default:
	    /* defaultʤ */
	    break;
	}
	NEW_VECTOR3(idx_del_info,
		    G_MAKESYM(enter_atom_cstring(ia_list->attr_name)),
		    *occ_list, work_attr);
	G_HEAPALLOC((q)consp, G_SIZE_IN_Q(struct cons)*(ONE_ATTR), (q));
	consp->car = idx_del_info;
	*tmp = G_MAKECONS(consp);
	tmp = &consp->cdr;
	consp++;
	ia_list = ia_list->next;
    }
    (--consp)->cdr = NILATOM;

    free(work_str);

    return (g_allocp);
}
