/*
/*	(C)1992, 1993, 1995 Institute for New Generation Computer Technology
/*		ۤ¾COPYRIGHTե򻲾ȤƲ
/*		(Read COPYRIGHT for detailed information.)
 */
/* ---------------------------------------------------------- 
%   (C)1993,1994 Institute for New Generation Computer Technology 
%       (Read COPYRIGHT for detailed information.) 
----------------------------------------------------------- */

#include <stdio.h>
#include <klic/gdobject.h>
#include <klic/g_string.h>
/* #include "../kgobj/g_string16.h" */
#include "atom.h"
#include "funct.h"

#define GD_CLASS_NAME() regexp__checker
#define GD_OBJ_TYPE struct regexp_object
#define GD_OBJ_SIZE(obj) (G_SIZE_IN_Q(GD_OBJ_TYPE))

#define INIT   register char *regsp = instring;
#define GETC() (*regsp++)
#define PEEKC()     (*regsp)
#define UNGETC(c)   (--regsp)
#define RETURN(c)   return((char *)0)
#define ERROR(c)    return((char *)c)

#include <regexp.h>
/*
/* extern char *loc1, *loc2, *compile();
/* extern int circf, step();
 */

GD_OBJ_TYPE {
  struct data_object_method_table *method_table;
  long type;    /* 1:^STR  2:STR$  3:STR  4:REGEXP */
  long strlen;
  long circf;  /* Global Variable for compile/step */
  char *expbuf;
};

#define STRING_CLASS_NAME byte__string
#define STRING_OBJ_TYPE struct byte_string_object
#define STRING_ELEMSIZE 8
#define STRING_ELEMCTYPE unsigned char

#define KLIC2C(STR) convert_klic_string_to_c_string(STR)
#define STRING_BODY(STR) generic_string_body(STR)
#define STRING_SIZE(STR) generic_string_size(STR)

#define DUMMYARG
extern char *KLIC2C(DUMMYARG);
extern STRING_ELEMCTYPE *STRING_BODY(DUMMYARG);
extern long STRING_SIZE(DUMMYARG);

#include <klic/gd_macro.h>

extern struct data_object_method_table *GD_method_table0(STRING_CLASS_NAME);

/* basic method definitions */

GDDEF_GC()
{
  G_STD_DECL;
  GD_OBJ_TYPE *newself;

  GDSET_NEWOBJ_IN_NEWGEN(newself);
  newself->type = GD_SELF->type;
  newself->strlen = GD_SELF->strlen;
  newself->circf = GD_SELF->circf;
  newself->expbuf = GD_SELF->expbuf;
  GD_RETURN_FROM_GC(newself);
}

/* Generic method */
/* Empty */

/* guard generic methods */

GDDEF_GMETHOD(check_3)
{
  G_STD_DECL;
  q otherq = GD_ARGV[0];
  long ret = 0, matchloc, matchlen, checkstrlen;
  char *strbody;
  STRING_OBJ_TYPE *stringobj;

  if (!G_ISGOBJ(otherq) || !GD_IS_CLASS(STRING_CLASS_NAME, otherq)) GD_GFAIL;

  stringobj = (STRING_OBJ_TYPE *)G_FUNCTORP(otherq);

  switch(GD_SELF->type) {
  case 1:
      matchlen = GD_SELF->strlen/(STRING_ELEMSIZE/8);
      matchloc = 0;
      if(STRING_SIZE(stringobj)*(STRING_ELEMSIZE/8) < GD_SELF->strlen) break;
      ret = !strncmp((char *)STRING_BODY(stringobj),GD_SELF->expbuf,GD_SELF->strlen);
      break;
  case 2:
      checkstrlen = STRING_SIZE(stringobj)*(STRING_ELEMSIZE/8);
      matchlen = GD_SELF->strlen/(STRING_ELEMSIZE/8);
      matchloc = (checkstrlen-GD_SELF->strlen)/(STRING_ELEMSIZE/8);
      if(checkstrlen < GD_SELF->strlen) break;
      ret = !strncmp(&((char *)STRING_BODY(stringobj))[checkstrlen-GD_SELF->strlen],
		     GD_SELF->expbuf,GD_SELF->strlen);
      break;
  case 3:
  case 4:
      strbody = KLIC2C(otherq);
      circf = GD_SELF->circf;
      ret = step(strbody,GD_SELF->expbuf);
      matchlen = (loc2 - loc1)/(STRING_ELEMSIZE/8);
      matchloc = (loc1 - strbody)/(STRING_ELEMSIZE/8);
      free(strbody);
      break;
  }
  if (ret) {
      GD_ARGV[1] = G_MAKEINT(matchloc);
      GD_ARGV[2] = G_MAKEINT(matchlen);
      GD_GSUCCEED;
  } else {
      GD_GFAIL;
  }
}

GDDEF_GGENERIC()
{
  G_STD_DECL;
  GD_SWITCH_ON_GMETHOD {
    GD_GMETHOD_CASE(check_3);
    GD_GMETHOD_CASE_DEFAULT;
  }
}

GDDEF_PRINT()
{
  G_STD_DECL;
  GD_PRINT("<REGEXP_OBJ>");
  GD_RETURN_FROM_PRINT;
}

GDDEF_DEALLOCATE()
{
  G_STD_DECL;

  if(GD_SELF->expbuf != NULL) free(GD_SELF->expbuf);

  return 0; /* GD_RETURN_FROM_DEALLOCTE; */
}

#define GDUSE_MY_PRINT
#define GDUSE_MY_GC
#define GDUSE_MY_GGENERIC
/* 
/* #define GDUSE_MY_GUNIFY
/* #define GDUSE_MY_UNIFY
/* #define GDUSE_MY_GENERIC
/* #define GDUSE_MY_COMPARE
/* #define GDUSE_MY_HASH
 */

/* define the method table structure of the vector */

#include <klic/gd_methtab.h>

/*  new_regexp function */
GDDEF_NEW()
{
  GD_STD_DECL_FOR_NEW;
  q initstr;
  long type, expbufsize, i;
  char *strbody, *regexpstrbody, *c;

  STRING_OBJ_TYPE *regexpstr;
  char *expbuf, *compret;
  GD_OBJ_TYPE *newobj;
  struct functor *retstruct;

  if (GD_ARGC != 2) GD_ERROR_IN_NEW("Too few or too many arguments");

  GDSET_INTARG_FOR_NEW(type, GD_ARGV[0]);
  if(type < 1 || type > 4) GD_ERROR_IN_NEW("2nd parameter is out of range.");

  initstr = GD_ARGV[1];
  GD_DEREF_FOR_NEW(initstr);
  if (!G_ISGOBJ(initstr) || !GD_IS_CLASS(STRING_CLASS_NAME, initstr))
	  GD_ERROR_IN_NEW("3rd parameter is not byte string.");

  GDSET_NEWOBJ_FOR_NEW(newobj, G_SIZE_IN_Q(GD_OBJ_TYPE));
  GD_ALLOC_AREA_FOR_NEW(retstruct, (struct functor *), sizeof(struct functor));
  retstruct->functor = G_MAKESYM(G_functor(normal_1));
  retstruct->args[0] = G_MAKEFUNCTOR(newobj);

  newobj->type = type;
  regexpstr = (STRING_OBJ_TYPE *)G_FUNCTORP(initstr);
  newobj->strlen = STRING_SIZE(regexpstr)*(STRING_ELEMSIZE/8);
  newobj->expbuf = NULL;

  strbody = KLIC2C(initstr);

  switch(type) {
  case 1:
  case 2:
      newobj->expbuf = strbody;
      break;
  case 3:
      regexpstrbody = strbody;
      strbody = c = (char *) malloc(newobj->strlen*2+1);

      for(i=0; i < newobj->strlen; i++) {
	  switch(regexpstrbody[i]) {
	  case '\\':
	  case '.':
	  case '^':
	  case '$':
	  case '[':
	  case ']':
	  case '*':
	      *c++ = '\\';
	  default:
	      *c++ = regexpstrbody[i];
	      break;
	  }
      }
      *c = 0;
      free(regexpstrbody);
  case 4:
      expbufsize = (newobj->strlen < 512) ? 1024:(newobj->strlen)*2;

      for(i=10;i>0;i--) {
	  expbufsize += newobj->strlen;
	  expbuf = (char *) malloc(expbufsize);
	  compret = compile(strbody, expbuf, &expbuf[expbufsize], '\0');
	  if(compret != (char *)50) break;
	  free(expbuf);
      }
      free(strbody);
      if(compret) {
	  free(expbuf);
	  retstruct->functor = G_MAKESYM(G_functor(abnormal_1));
	  retstruct->args[0] = G_MAKEINT(compret);
      } else {
	  newobj->circf  = circf;
	  newobj->expbuf = expbuf;
      }
      break;
  }

  GD_RETURN_FROM_NEW(retstruct);
}
