/*
/*	(C)1992, 1993, 1995 Institute for New Generation Computer Technology
/*		ۤ¾COPYRIGHTե򻲾ȤƲ
/*		(Read COPYRIGHT for detailed information.)
 */
/* ---------------------------------------------------------- 
%   (C)1993,1994 Institute for New Generation Computer Technology 
%       (Read COPYRIGHT for detailed information.) 
----------------------------------------------------------- */

#include <stdio.h>
/*#include <klic/basic.h>*/
#include <klic/gdobject.h>
#include "g_string16.h"
#include "atom.h"
#include "funct.h"
#ifdef STRINGH
#include <string.h>
#else
#include <strings.h>
#endif

/* #define PURE_GSTRING16 */
/*
#ifdef USEBCMP
#define BCMP			bcmp
#else
#define BCMP			memcmp
#endif

#ifdef USEBCOPY
#define BCOPY(from,to,len)	bcopy(from,to,len)
#else
#define BCOPY(from,to,len)	memcpy(to,from,len)
#endif

#ifdef USEBZERO
#define BZERO(from,len)		bzero(from,len)
#else
#define BZERO(from,len)		memset(from,0,len)
#endif
*/
#define GD_CLASS_NAME() dbyte__string
#define GD_OBJ_TYPE struct dbyte_string_object
#define GD_OBJ_SIZE(obj) (G_SIZE_IN_Q(GD_OBJ_TYPE))
#define ELEMSIZE 16
#define ELEMMAXVAL  (0xFFFF)
#define ELEMCTYPE unsigned short

#include <klic/gd_macro.h>

#define STRING_OBJ(x)	((GD_OBJ_TYPE *)(G_FUNCTORP(x)))

/* shallowing */

static do_shallow(string)
     GD_OBJ_TYPE *string;
{
  q s, last, next;

  /* Go down to the shallwed version inverting pointers */
  last = STRING16_SHALLOW_MARK;
  s = GD_OBJ(string);
  do {
    next = STRING_OBJ(s)->next;
    STRING_OBJ(s)->next = last;
    last = s;
    s = next;
  } while (s != STRING16_SHALLOW_MARK);
  s = last;

  /* Update physical string elements tracing the inverted pointers */
  {
    long size = STRING_OBJ(s)->index;
    ELEMCTYPE *body = STRING_OBJ(s)->body;
    next = STRING_OBJ(s)->next;
    do {
      long index;
      index = STRING_OBJ(next)->index;
      STRING_OBJ(s)->index = index;
      STRING_OBJ(s)->body = (ELEMCTYPE *)((unsigned long)body[index]);
      body[index] = (ELEMCTYPE)(unsigned long)(STRING_OBJ(next)->body);
      s = next;
      next = STRING_OBJ(s)->next;
    } while (next != STRING16_SHALLOW_MARK);
    STRING_OBJ(s)->index = size;
    STRING_OBJ(s)->body = body;
  }
}

#define Shallow(string) \
{ if (!IS_SHALLOW_STRING16(string)) do_shallow(string); }

/* basic method definitions */

GDDEF_GUNIFY()
{
  G_STD_DECL;
  long size, k;
  if (GD_SELF->method_table != GD_OTHER->method_table) GD_GUNIFY_FAIL;
  Shallow(GD_SELF);
  size = GD_SELF->index;
  Shallow(GD_OTHER);
  if (GD_OTHER->index != size) GD_GUNIFY_FAIL;
  if (IS_SHALLOW_STRING16(GD_SELF)) {
    if (BCMP(GD_SELF->body, GD_OTHER->body, size*(ELEMSIZE/8)) != 0) GD_GUNIFY_FAIL;
  } else {
    for (k=0; k<size; k++) {
      q retval;
      ELEMCTYPE c = GD_OTHER->body[k];
      Shallow(GD_SELF);
      if (GD_SELF->body[k] != c) GD_GUNIFY_FAIL;
      Shallow(GD_OTHER);
    }
  }
  GD_GSUCCEED;
}

GDDEF_UNIFY()
{
  G_STD_DECL;
  long size, k;
  if (GD_SELF->method_table != GD_OTHER->method_table) GD_UNIFY_FAIL;
  Shallow(GD_SELF);
  size = GD_SELF->index;
  Shallow(GD_OTHER);
  if (GD_OTHER->index != size) GD_UNIFY_FAIL;
  if (IS_SHALLOW_STRING16(GD_SELF)) {
    if (BCMP(GD_SELF->body, GD_OTHER->body, size*(ELEMSIZE/8)) != 0) GD_UNIFY_FAIL;
  } else {
    for (k=0; k<size; k++) {
      q retval;
      ELEMCTYPE c = GD_OTHER->body[k];
      Shallow(GD_SELF);
      if (GD_SELF->body[k] != c) GD_UNIFY_FAIL;
      Shallow(GD_OTHER);
    }
  }
  GD_RETURN;
}

#define ROUND_UP(size)	((((size)*ELEMSIZE/8)+sizeof(q)-1)/sizeof(q))

GDDEF_GC()
{
  G_STD_DECL;
  GD_OBJ_TYPE *newself;

  GDSET_NEWOBJ_IN_NEWGEN(newself);
  if (GD_SELF->iscnst) {
    fatal("GC method for constant string unexpected");
  }
  newself->iscnst = 0;
  if (IS_SHALLOW_STRING16(GD_SELF)) {
    ELEMCTYPE *body = GD_SELF->body;
    ELEMCTYPE *newbody;
    unsigned long size = GD_SELF->index;
    unsigned long qsize = ROUND_UP(size);
    long k;
    if ((g_allocp+qsize)>real_heaplimit) fatal("Not enough space collected");
    newbody = (ELEMCTYPE *)g_allocp;
    g_allocp += qsize;
    newself->next = STRING16_SHALLOW_MARK;
    newself->index = size;
    newself->body = newbody;
    BCOPY(body,newbody,qsize*sizeof(q));
  } else {
    newself->index = GD_SELF->index;
    newself->body = GD_SELF->body;
    GD_COPY_KL1_TERM_TO_NEWGEN(GD_SELF->next, newself->next);
  }
  GD_RETURN_FROM_GC(newself);
}

/* Generic method */

GDDEF_METHOD(string_2)
{
  G_STD_DECL;
  long position;
  Shallow(GD_SELF);
  GD_UNIFY_VALUE(GD_ARGV[0],G_MAKEINT(GD_SELF->index));
  GD_UNIFY_VALUE(GD_ARGV[1],G_MAKEINT(ELEMSIZE));
  GD_RETURN;
}

GDDEF_METHOD(element_2)
{
  G_STD_DECL;
  long position;
  Shallow(GD_SELF);
  GDSET_INTARG_WITHIN_RANGE(position,GD_ARGV[0],0,(long)(GD_SELF->index));
  GD_UNIFY_VALUE(GD_ARGV[1],
		 G_MAKEINT((unsigned long)(GD_SELF->body[position])));
  GD_RETURN;
}

GDDEF_METHOD(size_1)
{
  G_STD_DECL;
  Shallow(GD_SELF);
  GD_UNIFY_VALUE(GD_ARGV[0],G_MAKEINT(GD_SELF->index));
  GD_RETURN;
}

GDDEF_METHOD(element__size_1)
{
  G_STD_DECL;
  Shallow(GD_SELF);
  GD_UNIFY_VALUE(GD_ARGV[0],G_MAKEINT(ELEMSIZE));
  GD_RETURN;
}

GDDEF_METHOD(set__element_3)
{
  G_STD_DECL;
  long position, newelem;
  GD_OBJ_TYPE *newstr;
  ELEMCTYPE *body;
  int iscnst;
  unsigned long size;

  Shallow(GD_SELF);
  size = GD_SELF->index;
  iscnst = GD_SELF->iscnst;
  body = GD_SELF->body;
  GDSET_INTARG_WITHIN_RANGE(position,GD_ARGV[0],0,size);
  GDSET_INTARG_WITHIN_RANGE(newelem,GD_ARGV[1],0,ELEMMAXVAL+1);
  GDSET_NEWOBJ(newstr);
  if (!iscnst) {
    ELEMCTYPE olddata = body[position];

    GD_SELF->index = position;
    GD_SELF->body = (ELEMCTYPE *)(unsigned long)olddata;
    body[position] = newelem;
    GD_SELF->next = GD_OBJ(newstr);
    newstr->body = body;
  } else {
    ELEMCTYPE *newbody;
    unsigned long qsize = ROUND_UP(size);
    GD_ALLOC_AREA(newbody, (ELEMCTYPE *), qsize);
    BCOPY(body, newbody, qsize*sizeof(q));
    newbody[position] = newelem;
    newstr->body = newbody;
  }
  newstr->next = STRING16_SHALLOW_MARK;
  newstr->index = size;
  newstr->iscnst = 0;
  GD_UNIFY_VALUE(GD_ARGV[2], GD_OBJ(newstr));
  GD_RETURN;
}

GDDEF_METHOD(search__character_4)
{
  G_STD_DECL;
  unsigned long start, end, code;
  unsigned long k;

  Shallow(GD_SELF);
  GDSET_INTARG_WITHIN_RANGE(start,GD_ARGV[0],0,GD_SELF->index);
  GDSET_INTARG_WITHIN_RANGE(end,GD_ARGV[1],0,GD_SELF->index);
  GDSET_INTARG_WITHIN_RANGE(code,GD_ARGV[2],0,ELEMMAXVAL+1);
  if (start <= end) {
    for (k=start; k<=end; k++) {
      if (((unsigned long) GD_SELF->body[k]) == code) goto done;
    }
  } else {
    for (k=start; k>=end; k--) {
      if (((unsigned long) GD_SELF->body[k]) == code) goto done;
    }
  }
  GD_UNIFY_VALUE(GD_ARGV[3],G_MAKEINT(-1L));
  GD_RETURN;

  done:
    GD_UNIFY_VALUE(GD_ARGV[3],G_MAKEINT(k));
  GD_RETURN;
}

extern ELEMCTYPE *generic_string16_body();
extern unsigned long generic_string16_size();
extern q gd_new_string16();
extern q convert_c_string_to_klic_string16();
extern q convert_binary_c_string_to_klic_string16();
extern char *convert_klic_string16_to_c_string();

#ifndef PURE_GSTRING16

/*  Kappa Original Method  */
#include "GO_IDX.h"
#include "GO_IDX.c"
#include "GO_REC.c"
#include "GO_LIB.c"
#include "GO_get_term.c"

#endif

/*  Generic Method Table */
GDDEF_GENERIC()
{
  G_STD_DECL;

  GD_SWITCH_ON_METHOD{
    GD_METHOD_CASE(string_2);
    GD_METHOD_CASE(element_2);
    GD_METHOD_CASE(size_1);
    GD_METHOD_CASE(element__size_1);
    GD_METHOD_CASE(set__element_3);
    GD_METHOD_CASE(search__character_4);
#ifndef PURE_GSTRING16
    GD_METHOD_CASE(get__kappa__integer_2);
    GD_METHOD_CASE(set__kappa__integer_3);
    GD_METHOD_CASE(binary__search__from__leaf__int_5);
    GD_METHOD_CASE(binary__search__from__leaf__str_6);
    GD_METHOD_CASE(binary__search__from__node__int_5);
    GD_METHOD_CASE(binary__search__from__node__str_6);
    GD_METHOD_CASE(get__from__type1__int_13);
    GD_METHOD_CASE(get__from__type1__str_14);
    GD_METHOD_CASE(get__from__type2_5);
    GD_METHOD_CASE(get__from__type3_5);
    GD_METHOD_CASE(read__record_9);
    GD_METHOD_CASE(get__and__set__bit_5);
    GD_METHOD_CASE(set__bit_4);
    GD_METHOD_CASE(get__term_3);
    GD_METHOD_CASE(add__record_8);
    GD_METHOD_CASE(delete__record_8);
    GD_METHOD_CASE(ixp__set__key_7);
#endif
    GD_METHOD_CASE_DEFAULT;
  }
  GD_RETURN;
}

/* guard generic methods */

GDDEF_GMETHOD(element_2)
{
  G_STD_DECL;
  unsigned long position;

  Shallow(GD_SELF);
  GDSET_GINTARG_WITHIN_RANGE(position,GD_ARGV[0],0,GD_SELF->index);
  GD_ARGV[1] = G_MAKEINT((long)(GD_SELF->body[position]));
  GD_GSUCCEED;
}

GDDEF_GMETHOD(string_2)
{
  G_STD_DECL;
  unsigned long position;

  Shallow(GD_SELF);
  GD_ARGV[0] = G_MAKEINT(GD_SELF->index);
  GD_ARGV[1] = G_MAKEINT(ELEMSIZE);
  GD_GSUCCEED;
}

static int compare_two_strings(s1, s2)
     GD_OBJ_TYPE *s1, *s2;
{
  long size1, size2, minsize, k;
  Shallow(s1);
  size1 = s1->index;
  Shallow(s2);
  size2 = s2->index;
  minsize = ((size1 < size2) ? size1 : size2);
  if (!IS_SHALLOW_STRING16(s1)) {
    /* s1 and s2 are different versions of the same string */
    for (k=0; k<minsize; k++) {
      ELEMCTYPE c;
      Shallow(s1);
      c = s1->body[k];
      Shallow(s2);
      if (c != s2->body[k]) {
	return ((c < s2->body[k]) ? -(k+1) : k+1);
      }
    }
  } else {
    for (k=0; k<minsize; k++) {
      if (s1->body[k] != s2->body[k]) {
	return ((s1->body[k] < s2->body[k]) ? -(k+1) : k+1);
      }
    }
  }
  if (size1 != size2) {
    return ((size1<size2) ? -(size1+1) : size2+1);
  } else {
    return 0;
  }
}

GDDEF_GMETHOD(less__than_1)
{
  G_STD_DECL;
  q otherq = GD_ARGV[0];
  GD_OBJ_TYPE *other;
  int cmp;

  if (!G_ISGOBJ(otherq)) GD_GFAIL;
  other = (GD_OBJ_TYPE *)G_FUNCTORP(otherq);
  if (other->method_table != GD_SELF->method_table) GD_GFAIL;
  cmp = compare_two_strings(GD_SELF, other);
  if (cmp < 0) GD_GSUCCEED; else GD_GFAIL;
}

GDDEF_GMETHOD(not__less__than_1)
{
  G_STD_DECL;
  q otherq = GD_ARGV[0];
  GD_OBJ_TYPE *other;
  int cmp;

  if (!G_ISGOBJ(otherq)) GD_GFAIL;
  other = (GD_OBJ_TYPE *)G_FUNCTORP(otherq);
  if (other->method_table != GD_SELF->method_table) GD_GFAIL;
  cmp = compare_two_strings(GD_SELF, other);
  if (cmp >= 0) GD_GSUCCEED; else GD_GFAIL;
}

GDDEF_GMETHOD(estring_3)
{
  G_STD_DECL;
  long size, k;
  q tmp;

  Shallow(GD_SELF);
  size = GD_SELF->index;
  if (G_INTVAL(GD_ARGV[0])!= size) GD_GFAIL;
  if (G_INTVAL(GD_ARGV[1])!= ELEMSIZE) GD_GFAIL;
  tmp = GD_ARGV[2];
  for(k=0; k<size; k++, tmp = G_CDR_OF(tmp)) {
    if(G_INTVAL(G_CAR_OF(tmp))!= GD_SELF->body[k]) GD_GFAIL;
  }
  GD_GSUCCEED;
}

GDDEF_GGENERIC()
{
  G_STD_DECL;

  GD_SWITCH_ON_GMETHOD {
    GD_GMETHOD_CASE(element_2);
    GD_GMETHOD_CASE(string_2);
    GD_GMETHOD_CASE(less__than_1);
    GD_GMETHOD_CASE(not__less__than_1);
    GD_GMETHOD_CASE(estring_3);
    GD_GMETHOD_CASE_DEFAULT;
  }
}

GDDEF_PRINT()
{
  G_STD_DECL;
  unsigned long size, limit, k;
  ELEMCTYPE e;
  unsigned char *short_buf;

  Shallow(GD_SELF);
  size = GD_SELF->index;
  limit = (size > g_length ? g_length : size);
  GD_PRINT("string16#\"");
  for (k = 0; k < limit; k++) {
      short_buf = (unsigned char *) &GD_SELF->body[k];
      GD_PUTC(short_buf[0]);
      GD_PUTC(short_buf[1]);
  }
  if (limit != size) GD_PRINT("..");
  GD_PUTC('"');
  GD_RETURN_FROM_PRINT;
}

GDDEF_COMPARE()
{
  G_STD_DECL;
  unsigned long size1, size2, limit, k;
  Shallow(GD_SELF);
  size1 = GD_SELF->index;
  Shallow(GD_OTHER);
  size2 = GD_OTHER->index;
  limit = (size1 <= size2 ? size1 : size2);
  for (k = 0; k < limit; k++) {
    ELEMCTYPE elem;
    Shallow(GD_SELF);
    elem = GD_SELF->body[k];
    Shallow(GD_OTHER);
    if (elem != GD_OTHER->body[k]) {
      return G_MAKEINT(elem > GD_OTHER->body[k] ? k+1 : -(k+1));
    }
  }
  if (size1 != size2) {
    return G_MAKEINT(size1 >= size2 ? size1+1 : -(size2+1));
  } else {
    return G_MAKEINT(0);
  }
}

GDDEF_HASH()
{
  G_STD_DECL;
  unsigned long size;
  Shallow(GD_SELF);
  size = GD_SELF->index;
  if (size == 0) {
    return G_MAKEINT(0);
  } else {
    return
      G_MAKEINT(0x813 * GD_SELF->body[0] +
		0x425 * GD_SELF->body[size>>1] +
		0x3c9 * GD_SELF->body[size-1]);
  }
}

#define GDUSE_MY_GUNIFY
#define GDUSE_MY_UNIFY
#define GDUSE_MY_PRINT
#define GDUSE_MY_GC
#define GDUSE_MY_GENERIC
#define GDUSE_MY_GGENERIC
#define GDUSE_MY_COMPARE
#define GDUSE_MY_HASH

/* define the method table structure of the vector */
#include <klic/gd_methtab.h>

/*  new_string function */
#ifndef PURE_GSTRING16

#include "GO_newstr.c"
/*#include "GO_encord_term.c"*/

#else

/*  new_string function */
GDDEF_NEW()
{
  GD_STD_DECL_FOR_NEW;
  GD_OBJ_TYPE *newstr;
  ELEMCTYPE *body;
  unsigned long size;
  q result;
  q init;

  if (GD_ARGC!=1) GD_ERROR_IN_NEW("Too few or too many arguments");
  init = GD_ARGV[0];
  GD_DEREF_FOR_NEW(init);
  GDSET_NEWOBJ_FOR_NEW(newstr, G_SIZE_IN_Q(GD_OBJ_TYPE));
  if (G_ISINT(init)) {
    unsigned long qsize;
    size = G_INTVAL(init);
    if (size < 0) GD_ERROR_IN_NEW("Negative size specified");
    qsize = ROUND_UP(size);
    GD_ALLOC_AREA_FOR_NEW(body, (ELEMCTYPE *), qsize);
    BZERO(body, qsize*sizeof(q));
  } else if (init==NILATOM || G_ISCONS(init)) {
    unsigned long qsize, k;
    for (size=0; ; size++) {
      q elem;
      if (init == NILATOM) break;
      elem = G_CAR_OF(init);
      GD_DEREF_FOR_NEW(elem);
      if (!G_ISINT(elem) || G_INTVAL(elem) < 0 || ELEMMAXVAL+1 <= G_INTVAL(elem)) {
	GD_ERROR_IN_NEW("Illegal parameter");
      }
      init = G_CDR_OF(init);
      GD_DEREF_FOR_NEW(init);
      if (init!=NILATOM && !G_ISCONS(init))
	GD_ERROR_IN_NEW("Illegal parameter");
    }
    qsize = ROUND_UP(size);
    init = GD_ARGV[0];
    GD_ALLOC_AREA_FOR_NEW(body, (ELEMCTYPE *), qsize);
    for (k=0; k<size; k++) {
      q elem;
      GD_DEREF_FOR_NEW(init);
      elem = G_CAR_OF(init);
      GD_DEREF_FOR_NEW(elem);
      body[k] = G_INTVAL(elem);
      init = G_CDR_OF(init);
    }
  } else {
    GD_ERROR_IN_NEW("Illegal parameter");
  }
  newstr->next = STRING16_SHALLOW_MARK;
  newstr->iscnst = 0;
  newstr->index = size;
  newstr->body = body;
  GD_RETURN_FROM_NEW(newstr);
}
#endif

ELEMCTYPE *generic_string16_body(str)
GD_OBJ_TYPE *str;
{
  Shallow(str);
  return (str->body);
}

unsigned long generic_string16_size(str)
GD_OBJ_TYPE *str;
{
  Shallow(str);
  return (str->index);
}

q gd_new_string16(size,g_allocp)
     long size;
     q *g_allocp;
{
  q argv[1];
  argv[0] = makeint(size);
  return dbyte__string_g_new(1,argv,g_allocp);
}

q gd_list_to_string16(list,g_allocp)
     q list;
     q *g_allocp;
{
  q argv[2];
  argv[0] = list;
  return dbyte__string_g_new(1,argv,g_allocp);
}

q convert_c_string_to_klic_string16(cstr,g_allocp)
     char *cstr;
     q *g_allocp;
{
  q argv[1];
  q str;
  long len = strlen(cstr);
  argv[0] = makeint((len+(ELEMSIZE/8)-1)/(ELEMSIZE/8));
  str = dbyte__string_g_new(1,argv,g_allocp);
  if (!G_ISREF(str)) {
    BCOPY(cstr, ((GD_OBJ_TYPE *)functorp(str))->body, len);
  }
  return str;
}

q convert_binary_c_string_to_klic_string16(cstr,len,g_allocp)
     char *cstr;
     long len;
     q *g_allocp;
{
  q argv[1];
  q str;
  argv[0] = makeint((len+(ELEMSIZE/8)-1)/(ELEMSIZE/8));
  str = dbyte__string_g_new(1,argv,g_allocp);
  if (!G_ISREF(str)) {
    BCOPY(cstr, ((GD_OBJ_TYPE *)functorp(str))->body, len);
  }
  return str;
}

char *convert_klic_string16_to_c_string(s)
     q s;
{
  extern char *malloc_check();
  GD_OBJ_TYPE *str = (GD_OBJ_TYPE *)functorp(s);
  char *cstr;
  Shallow(str);
  cstr = (char *)malloc_check(1+(str->index*(ELEMSIZE/8)));
  BCOPY((char *)str->body, cstr, str->index*(ELEMSIZE/8));
  cstr[(str->index*(ELEMSIZE/8))] = '\0';
  return cstr;
}

/* Interface with builtin */

q size_of_string16(s)
     q s;
{
  Shallow(STRING_OBJ(s));
  return G_MAKEINT(STRING_OBJ(s)->index);
}

q element_of_string16(s, k)
     q s, k;
{
  Shallow(STRING_OBJ(s));
  if (G_INTVAL(k) < 0 || (long)(STRING_OBJ(s)->index) <= G_INTVAL(k)) {
    return (q) 0;
  } else {
    return G_MAKEINT(STRING_OBJ(s)->body[G_INTVAL(k)]);
  }
}
