/*
/*	(C)1992, 1993, 1995 Institute for New Generation Computer Technology
/*		ۤ¾COPYRIGHTե򻲾ȤƲ
/*		(Read COPYRIGHT for detailed information.)
 */

/************************************************************
 *
 *  FILE NAME
 *    ixp_SrcStr.c
 *  DESCLIPTION
 *    ǥåץΥ⥸塼롣եڡΤʤ
 *    ꥭ˴ؤȤ¤Τ˳Ǽ֤
 *    ǡ string/psi_string ν
 *  INTERFACE ROUTINES
 *  NOTES
 *
 *$ EDITOR : Sugizaki Gen
 *$ CREATE : 93.12.21 Tue
 *$ UPDATE : 94.02.25 Mon
 *
 ************************************************************/

/* Υڡؤΰդ */

#include <stdio.h>
#include <string.h>
#include "ixp.h"
#include "ixp_SrcStr.h"



/*------------------------------------------------------------
 *  ixp_StrSearch 
 *    ǥåեڡ饭˳ǡФ
 *    ǡ string ޤϡ psi_string ΤȤ
 *  ARGUMENT
 *    STRING    ::= ڡȥ󥰡ʤ
 *    LowKey    ::= ¥͡ʥȥ󥰡
 *    LowRange  ::= 0  % ¥ϰ     (equ)
 *                | 1  % ¥ϰ   (ge)
 *                | 2  % ¥ϰ     (gt)
 *    HighKey   ::= ¥͡ʥȥ󥰡
 *    HighRange ::= 1  % ¥ϰ   (le)
 *                | 2  % ¥ϰ     (lt)
 *    Scan      ::= 1  % ascend, equ
 *                | 2  % descend
 *    RDataPosi ::= integer % RData ΰ
 *                          % 16bit ȥ󥰤Ǥ
 *                          % ᡹ 8bit ñ̤Ѵ
 *    SInfoPosi ::= integer % RDataбSearchInfo ΰ
 *                          % 16bit ȥ󥰤Ǥ
 *                          % ᡹ 8bit ñ̤Ѵ
 *    DType     ::= 0  % integer    ǡ
 *                | 1  % string
 *                | 2  % psi_string
 *    Nest      ::=   󥹤ο
 *    plength   ::= integer % PageSize
 *    HitFlag   ::= 0  % ҥåȤ     ꥿
 *                | 1  % ҥåȤʤ
 *                | 2  % ¡¤ۤ
 *    PageFlag  ::= 0  % Υڡ˥ǡä    ꥿
 *                | 1  % ҶΥڡ
 *                | -1 % ʤ
 *    NextFlag  ::= 0  % ܥڡǸλ
 *                | LPN % ΥڡϤLPNǤ
 *    Result    ::= ̤Υꥹȹ¤KLICǡˤؤΥݥ
 *    g_allocp   ::= KLIC ҡץꥢ ݥ
 *
 *  Return
 *    g_allocp   ::= ꥹȹ¤ƻѤΰʬʤ᤿
 *                  g_allocp
 *
 *------------------------------------------------------------
 */

/* (psi_)string° θ */

q *
ixp_SearchStr(char *String, char *LowKey, int LowRange, 
	      char *HighKey, int HighRange, int Scan, int RDataPosi, 
	      int SInfoPosi, int DType, int Nest, int plength, int *HitFlag, 
	      int *PageFlag, int *NextFlag, q *Result, q *current_g_allocp)

/* q *
/* ixp_StrSearch(char *String, char *LowKey, int LowRange, 
/* 		 char *HighKey, int HighRange, int Scan, 
/* 		 int RDataPosi, int SInfoPosi, int DType, 
/* 		 int Nest, int *HitFlag, 
/* 		 int *PageFlag, int *NextFlag, q *Result, q *current_gallocp);
 */
{
    q *g_allocp;
    RDataPosi = RDataPosi * 2; /* 16bit Position to 8bit Position */
    SInfoPosi = SInfoPosi * 2; /* 16bit Position to 8bit Position */

    *PageFlag = HERE_LPN;
    switch(LowRange) {
    case EQU :
	g_allocp = equal_search(String, LowKey, RDataPosi, DType, 
				Nest, HitFlag, PageFlag, Result, 
				current_g_allocp);
	*NextFlag = OnPage;
	break;
    default :
	switch(Scan) {
	case ascend_type :
	    *NextFlag = HERE_LPN;
	    g_allocp = 
		ascend_range_search(String, plength, HighKey, 
				    HighRange, Scan, RDataPosi, SInfoPosi, 
				    DType, Nest, HitFlag, PageFlag, 
				    NextFlag, Result, current_g_allocp);
	    break;
	case descend_type :
	    *NextFlag = HERE_LPN;
	    g_allocp = 
		descend_range_search(String, plength, LowKey, 
				     LowRange, Scan, RDataPosi, SInfoPosi, 
				     DType, Nest, HitFlag, PageFlag, 
				     NextFlag, Result, current_g_allocp);
	    break;
	default :
	    printf("Error Occurd in IXP Search, Para Scan Illegal");
	    break;
	}
    }
    return g_allocp;

}



/*------------------------------------------------------------
 *  equal_search
 *    郎 Attr = Value ΤȤν
 *  ARGUMENT
 *    STRING    ::= ڡȥ󥰡ʤ
 *    Key       ::= ͡ʥȥ󥰡
 *    RDataPosi ::= integer % RData ΰ
 *    DType     ::= 0  % integer    ǡ
 *                | 1  % string
 *                | 2  % psi_string
 *    Nest      ::=   󥹤ο
 *    HitFlag   ::= 0  % ҥåȤ     ꥿
 *                | 1  % ҥåȤʤ
 *                | 2  % ¡¤ۤ
 *    PageFlag  ::= 0  % Υڡ˥ǡä    ꥿
 *                | 1  % ҶΥڡ
 *                | -1 % ʤ
 *    Result    ::= ̤Υꥹȹ¤KLICǡˤؤΥݥ
 *    g_allocp   ::= KLIC ҡץꥢ ݥ
 *
 *  Return
 *    g_allocp   ::= ꥹȹ¤ƻѤΰʬʤ᤿
 *                  g_allocp
 *
 *------------------------------------------------------------
 */

static q *
equal_search(char *String, char *Key, int RDataPosi, int DType, 
	     int Nest, int *HitFlag, int *PageFlag, q *Result, q *g_allocp)
{
    struct cons *consp;
    int  RidEPosiPosi;  /* RIDǰ֤γǼ */
    int  RidEPosi;      /* RIDǰ */
    int  RidEN;         /* RIDǿ   */
    int  LPN;           /* LPN */


    switch(ixp_compare_key(String, NULL, Key, DType, RDataPosi)) {
    /* Ʊλ */
    case Same :
	RidEPosiPosi = ixp_get_rid_posi(String, DType, RDataPosi);

	/* [LPN]  */
	if(ixp_is_value_lpn(String, RidEPosiPosi) == YES) {
	    *PageFlag = ChildPage;

	    G_HEAPALLOC((q)consp, G_SIZE_IN_Q(struct cons), (q));
	    ixp_get_child_LPN(String, RidEPosiPosi, &LPN);
	    consp->car = G_MAKEINT(LPN);
	    *Result = G_MAKECONS(consp);
	    Result  = &consp->cdr;
	    consp->cdr = NILATOM;
	}

	/* ꥹȤκϰʲˤޤ */
	else{
	    RidEN = ixp_get_int(String, RidEPosiPosi + 2);  
	                        /* 2RidElement Posi Ĺ */
	    RidEPosi = ixp_get_int(String, RidEPosiPosi);
	    RidEPosi = RidEPosi * 2;  
	               /* 16bit Offset to 8bit Offset */
	    g_allocp = ixp_set_RidEle(String, RidEPosi, RidEN,
				 Nest, PageFlag, Result, g_allocp);
	}
	HitFlag = HIT;
	break;

    /* ۤʤʰդФƤΤˡʻΤ */
    default :
	*HitFlag  = NO_HIT;
	*PageFlag = NoData;
	break;
    }
    return g_allocp;
}


/*------------------------------------------------------------
 *  ascend_range_search
 *    ǥåեڡ饭˳ǡФ
 *    ϰϻξξν
 *  ARGUMENT
 *    STRING    ::= ڡȥ󥰡ʤ
 *    plength   ::= ڡĹ
 *    HighKey   ::= ¥͡ʥȥ󥰡
 *    HighRange ::= 1  % ¥ϰ   (le)
 *                | 2  % ¥ϰ     (lt)
 *    Scan      ::= 1  % ascend, equ
 *                | 2  % descend
 *    RDataPosi ::= integer % RData ΰ
 *    DType     ::= 0  % integer    ǡ
 *                | 1  % string
 *                | 2  % psi_string
 *    Nest      ::=   󥹤ο
 *    HitFlag   ::= 0  % ҥåȤ     ꥿
 *                | 1  % ҥåȤʤ
 *                | 2  % ¡¤ۤ
 *    PageFlag  ::= 0  % Υڡ˥ǡä    ꥿
 *                | 1  % ҶΥڡ
 *                | -1 % ʤ
 *    NextFlag  ::= 0  % ܥڡǸλ
 *                | LPN % ΥڡϤLPNǤ
 *    Result    ::= ̤Υꥹȹ¤KLICǡˤؤΥݥ
 *    g_allocp   ::= KLIC ҡץꥢ ݥ
 *
 *  Return
 *    g_allocp   ::= ꥹȹ¤ƻѤΰʬʤ᤿
 *                  g_allocp
 *
 * ڡ⤫ǧ롣ʤλ
 *     ʤ顢ݥȤƤǡȡꥭ٤
 *     ϰϳʤλ
 *           ϰʤ̤ΥꥹȤ롣
 *
 *------------------------------------------------------------
 */

static q *
ascend_range_search(char *String, int plength, char *HighKey, int HighRange, 
		    int Scan, int RDataPosi, int SInfoPosi, 
		    int DType, int Nest, int *HitFlag, 
		    int *PageFlag, int *NextFlag, q *Result, q *g_allocp)
{

    if(NextFlag == HERE_LPN) {
	switch(ixp_compare_key(String, NULL, HighKey, DType, RDataPosi)) {

	/* Ȥ */
	case Small :
	    break;

	/* Ȥ */
	case Same :
	    if(HighRange == LT) {
		break;
	    }
	    else {
		*HitFlag = HIT;
		g_allocp = set_RData(String, plength, HighKey, 
				     HighRange, Scan, RDataPosi, 
				     SInfoPosi, DType, Nest, HitFlag, 
				     PageFlag, NextFlag, Result, g_allocp);
		break;
	    }
	/* ޤ¤ǤʤȤ */
	default :
	    *HitFlag = HIT;
	    g_allocp = set_RData(String, plength, HighKey, 
				 HighRange, Scan, RDataPosi,
				 SInfoPosi, DType, Nest, HitFlag, 
				PageFlag, NextFlag, Result, g_allocp);
	};
    }
    return g_allocp;
}




/*------------------------------------------------------------
 *  descend_range_search
 *    ǥåեڡ饭˳ǡФ
 *    ϰϻι߽ξν
 *  ARGUMENT
 *    STRING    ::= ڡȥ󥰡ʤ
 *    plength   ::= ڡĹ
 *    LowKey    ::= ¥͡ʥȥ󥰡
 *    LowRange  ::= 0  % ¥ϰ     (equ)
 *                | 1  % ¥ϰ   (ge)
 *                | 2  % ¥ϰ     (gt)
 *    Scan      ::= 1  % ascend, equ
 *                | 2  % descend
 *    RDataPosi ::= integer % RData ΰ
 *    DType     ::= 0  % integer    ǡ
 *                | 1  % string
 *                | 2  % psi_string
 *    Nest      ::=   󥹤ο
 *    HitFlag   ::= 0  % ҥåȤ     ꥿
 *                | 1  % ҥåȤʤ
 *                | 2  % ¡¤ۤ
 *    PageFlag  ::= 0  % Υڡ˥ǡä    ꥿
 *                | 1  % ҶΥڡ
 *                | -1 % ʤ
 *    LPN       ::= 0  % Υڡ˥ǡä    ꥿
 *                | integer % ҥڡڡֹ
 *                | -1 % ʤ
 *    NextFlag  ::= 0  % ܥڡǸλ
 *                | LPN % ΥڡϤLPNǤ
 *    ResPnt     ::= ФǡγǼ ؤΥݥ
 *  Return
 *    0  ::= 
 *    -1 ::= ۾
 *
 *------------------------------------------------------------
 */


static q *
descend_range_search(char *String, int plength, char *LowKey, int LowRange, 
		     int Scan, int RDataPosi, int SInfoPosi, 
		     int DType, int Nest, int *HitFlag, 
		     int *PageFlag, int *NextFlag, q *Result, q *g_allocp)
{
    if(NextFlag == HERE_LPN) {
	switch(ixp_compare_key(String, NULL, LowKey, DType, RDataPosi)) {

	/* Ȥ */
	case Small :
	    break;

	/* Ȥ */
	case Same :
	    if(LowRange == GT) {
		break;
	    }
	    else {
		*HitFlag = HIT;
		g_allocp = set_RData(String, plength, LowKey, 
				     LowRange, Scan, RDataPosi, 
				     SInfoPosi, DType, Nest, HitFlag, 
				     PageFlag, NextFlag, Result, g_allocp);
		break;
	    }
	/* ޤ¤ǤʤȤ */
	default :
	    *HitFlag = HIT;
	    g_allocp = set_RData(String, plength, LowKey, 
				 LowRange, Scan, RDataPosi, 
				 SInfoPosi, DType, Nest, HitFlag, 
				 PageFlag, NextFlag, Result, g_allocp);
	};
    }
    return g_allocp;
}



/*------------------------------------------------------------
 *  set_RData
 *    ǥåեڡ饭˳ǡФ
 *    ϰϻξξν
 *  ARGUMENT
 *    STRING    ::= ڡȥ󥰡ʤ
 *    plength   ::= ڡĹ
 *    HighKey   ::= ¥͡ʥȥ󥰡
 *    HighRange ::= 1  % ¥ϰ   (le)
 *                | 2  % ¥ϰ     (lt)
 *    Scan      ::= 1  % ascend, equ
 *                | 2  % descend
 *    RDataPosi ::= integer % RData ΰ
 *    DType     ::= 0  % integer    ǡ
 *                | 1  % string
 *                | 2  % psi_string
 *    Nest      ::=   󥹤ο
 *    HitFlag   ::= 0  % ҥåȤ     ꥿
 *                | 1  % ҥåȤʤ
 *                | 2  % ¡¤ۤ
 *    PageFlag  ::= 0  % Υڡ˥ǡä    ꥿
 *                | 1  % ҶΥڡ
 *                | -1 % ʤ
 *    NextFlag  ::= 0  % ܥڡǸλ
 *                | LPN % ΥڡϤLPNǤ
 *    Result    ::= ̤Υꥹȹ¤KLICǡˤؤΥݥ
 *    g_allocp   ::= KLIC ҡץꥢ ݥ
 *
 *  Return
 *    g_allocp   ::= ꥹȹ¤ƻѤΰʬʤ᤿
 *                  g_allocp
 *
 *  LPN ξȤǤʤǽʬ
 *       LPN ʤͤФƥꥹȤͤù
 *           Ǥʤʤ顢ixp_Set_RidEle Ƥ
 *  ꥹȤˤĤäǤ顢ƵƤӽФ򤫤롣
 *  
 *------------------------------------------------------------
 */


static q *
set_RData(char *String, int plength, char *Key, int Range, 
	  int Scan, int RDataPosi, int SInfoPosi, 
	  int DType, int Nest, int *HitFlag, int *PageFlag, 
	  int *NextFlag, q *Result, q *g_allocp)
{
    struct cons *consp;

    int  RidEPosiPosi;  /* RIDǰ֤γǼ */
    int  RidEPosi;      /* RIDǰ */
    int  RidEN;         /* RIDǿ   */
    int  LPN;           /* LPN */

    int NextRData;
    int NextSIPosi;

    
    RidEPosiPosi = ixp_get_rid_posi(String, DType, RDataPosi);
    /* [LPN]  */
    if(ixp_is_value_lpn(String, RidEPosiPosi) == YES) {
	*PageFlag = ChildPage;
	
	G_HEAPALLOC((q)consp, G_SIZE_IN_Q(struct cons), (q));
	ixp_get_child_LPN(String, RidEPosiPosi, &LPN);
	consp->car = G_MAKEINT(LPN);
	*Result = G_MAKECONS(consp);
	Result  = &consp->cdr;
	consp->cdr = NILATOM;
    }
    /* ꥹȤκϰʲˤޤ */
    else{
	RidEN = ixp_get_int(String, RidEPosiPosi + 2);  
	/* 2RidElement Posi Ĺ */
	RidEPosi = ixp_get_int(String, RidEPosiPosi);
	RidEPosi = RidEPosi * 2;  
        	/* 16bit Offset to 8bit Offset */
	g_allocp = ixp_set_RidEle(String, RidEPosi, 
			     RidEN, Nest, PageFlag, Result, g_allocp);
    }


    NextRData = ixp_get_next_RDataPosi(Scan, plength, String, 
				   SInfoPosi, &NextSIPosi);
    if(NextSIPosi == HERE_LPN) 
	if(Scan == ascend_type)
	    ascend_range_search(String, plength, Key, Range, Scan, 
				NextRData, NextSIPosi, DType, Nest, HitFlag, 
				PageFlag, NextFlag, Result, g_allocp);
	else
	    descend_range_search(String, plength, Key, Range, Scan, 
				NextRData, NextSIPosi, DType, Nest, HitFlag, 
				PageFlag, NextFlag, Result, g_allocp);
    else {
	*NextFlag = ixp_get_4byte_int(String, NLPN_Posi);
/*	return; */
    }
    return g_allocp;
}

