/*
/*	(C)1992, 1993, 1995 Institute for New Generation Computer Technology
/*		ۤ¾COPYRIGHTե򻲾ȤƲ
/*		(Read COPYRIGHT for detailed information.)
 */

/************************************************************
 *
 *  FILE NAME
 *    ixp_SrcRID.c
 *  DESCLIPTION
 *    Type2 ǥåեڡΤʤRIDǤФ
 *    ꥹȤˤ֤
 *    ꥹȤKLICΥǡľ֤ܺ
 *  INTERFACE ROUTINES
 *  NOTES
 *
 *$ EDITOR : Sugizaki Gen
 *$ CREATE : 94.04.25 Mon
 *$ UPDATE :
 *
 ************************************************************/

#include <stdio.h>
#include <string.h>
#include "ixp.h"
#include "ixp_SrcRID.h"


/*------------------------------------------------------------
 *  ixp_Get_from_Type2
 *    Type2 ǥåեڡRIDǾФ
 *  ARGUMENT
 *    STRING    ::= ڡȥ󥰡ʤ
 *    Scan      ::= 1  % ascend, equ
 *                | 2  % descend
 *    Nest      ::=   󥹤ο
 *    plength   ::= ڡĹ
 *    PageFlag  ::= ҥڡ̵ͭ
 *    Result    ::= ̤Υꥹȹ¤KLICǡˤؤΥݥ
 *    current_gallocp ::= ܽƤӤ g_allocp
 *
 *  Return
 *    g_allocp  ::= ꥹȹ¤ƻѤΰʬʤ᤿
 *                  g_allocp
 *
 *------------------------------------------------------------
 */

q *
ixp_GetSubRIDs(char *String, int Scan, int Nest, int plength,
	       int *PageFlag, q *RID_info, q *current_g_allocp)

/* q *
/* ixp_Get_from_Type2(char *String, int Scan, int Nest,
/* 		      int *PageFlag, q *RID_info, q *g_allocp)
 */
{
    q *g_allocp;
    int  N, SInfoPosi, RidEPosi;

    N = ixp_get_int(String, SICPOSI);

    switch(Scan) {
    /* ξ */
    case ascend_type:
/*	SInfoPosi = PLENGTH - 2; */
	SInfoPosi = plength - 2;
	RidEPosi = ixp_get_int(String, SInfoPosi);
	RidEPosi = RidEPosi * 2;
	/*  16bit offset -> 8bit offset */

	g_allocp = get_ascend(String, SInfoPosi, RidEPosi, N, 
			      Nest, PageFlag, RID_info, current_g_allocp);
	break;

    /* ߽ξ */
    default:
/*	SInfoPosi = PLENGTH - N * 2; */
	SInfoPosi = plength - N * 2;
	RidEPosi = ixp_get_int(String, SInfoPosi);
	RidEPosi = RidEPosi * 2;
	/*  16bit offset -> 8bit offset */
	g_allocp = get_descend(String, SInfoPosi, RidEPosi, N, 
			       Nest, PageFlag, RID_info, current_g_allocp);
    }
    return g_allocp;
}




/*------------------------------------------------------------
 *  get_ascend
 *    Type2 ǥåեڡ˳ǼƤ뤹٤ƤRidE
 *    ˼Ф
 *  ARGUMENT
 *    STRING    ::= ڡȥ󥰡ʤ
 *    SInfoPosi ::= integer % ߽SInfo ΰ
 *    RidEPosi ::= integer % ߽RidE ΰ
 *    N         ::= integer % Sinfo ο
 *    Nest      ::=   󥹤ο
 *    PageFlag  ::= 0  % Υڡ˥ǡä    ꥿
 *                | 1  % ҶΥڡ
 *    RID_info  ::= ̤Υꥹȹ¤KLICǡˤؤΥݥ
 *    g_allocp   ::= KLIC ҡץꥢ ݥ
 *
 *  Return
 *    g_allocp   ::= ꥹȹ¤ƻѤΰʬʤ᤿
 *                  g_allocp
 *
 *------------------------------------------------------------
 */

static q *
get_ascend(char *String, int SInfoPosi, int RidEPosi, int N, 
		     int Nest, int *PageFlag, q *RID_info, q *g_allocp)
{
    struct cons *consp;
    q    *TMP_RES;     /* 롼θ̥ݥ */
    int i;
    int RID;
    q   SubRIDs;


    TMP_RES = RID_info;
    *PageFlag = OnPage;
    G_HEAPALLOC((q)consp, G_SIZE_IN_Q(struct cons)*N, (q));
    for(i = 1; i <= N; i++, consp++) {

	RID = ixp_get_4byte_int(String, RidEPosi); 

	/* 󥹤ʤ */
	if(Nest == NO_OCC) {
	    consp->car = G_MAKEINT(RID);
	}
	/* ͭ */
	else{
	    g_allocp = ixp_get_SubRids(String, RID, RidEPosi, Nest, 
				       PageFlag, &SubRIDs, g_allocp);
	    consp->car = SubRIDs;
	}
	*TMP_RES = G_MAKECONS(consp);
	TMP_RES  = &consp->cdr;

	SInfoPosi = SInfoPosi - 2;
	RidEPosi = ixp_get_int(String, SInfoPosi);
	RidEPosi = RidEPosi * 2;
    }
    (--consp)->cdr = NILATOM;
    return g_allocp;
}


/*------------------------------------------------------------
 *  get_descend
 *    Type2 ǥåեڡ˳ǼƤ뤹٤ƤRidE
 *    ߽˼Ф
 *  ARGUMENT
 *    STRING    ::= ڡȥ󥰡ʤ
 *    SInfoPosi ::= integer % ߽SInfo ΰ
 *    RidEPosi ::= integer % ߽RidE ΰ
 *    N         ::= integer % Sinfo ο
 *    Nest      ::=   󥹤ο
 *    PageFlag  ::= 0  % Υڡ˥ǡä    ꥿
 *                | 1  % ҶΥڡ
 *    RID_info  ::= ̤Υꥹȹ¤KLICǡˤؤΥݥ
 *    g_allocp   ::= KLIC ҡץꥢ ݥ
 *
 *  Return
 *    g_allocp   ::= ꥹȹ¤ƻѤΰʬʤ᤿
 *                  g_allocp
 *
 *------------------------------------------------------------
 */

static q *
get_descend(char *String, int SInfoPosi, int RidEPosi, int N, 
		      int Nest, int *PageFlag, q *RID_info, q *g_allocp)
{
    struct cons *consp;
    q    *TMP_RES;     /* 롼θ̥ݥ */
    int i;
    int RID;
    q   SubRIDs;

    TMP_RES = RID_info;
    *PageFlag = OnPage;
    G_HEAPALLOC((q)consp, G_SIZE_IN_Q(struct cons)*N, (q));
    for(i = 1; i <= N; i++, consp++) {

	RID = ixp_get_4byte_int(String, RidEPosi); 

	/* 󥹤ʤ */
	if(Nest == NO_OCC) {
	    consp->car = G_MAKEINT(RID);
	}
	/* ͭ */
	else{
	    g_allocp = ixp_get_SubRids(String, RID, RidEPosi, Nest,
				       PageFlag, &SubRIDs, g_allocp);
	    consp->car = SubRIDs;
	}
	*TMP_RES = G_MAKECONS(consp);
	TMP_RES  = &consp->cdr;

	SInfoPosi = SInfoPosi + 2;
	RidEPosi = ixp_get_int(String, SInfoPosi);
	RidEPosi = RidEPosi * 2;
    }
    (--consp)->cdr = NILATOM;
    return g_allocp;
}
