/*
/*	(C)1992, 1993, 1995 Institute for New Generation Computer Technology
/*		ۤ¾COPYRIGHTե򻲾ȤƲ
/*		(Read COPYRIGHT for detailed information.)
 */

/************************************************************
 *
 *  FILE NAME
 *    ixp_SrcCom.c
 *  DESCLIPTION
 *    ǥåζ̽
 *  INTERFACE ROUTINES
 *  NOTES
 *
 *$ EDITOR : Sugizaki Gen
 *$ CREATE : 93.12.21 Tue
 *$ UPDATE : 94.05.24 Tue
 *$          94.11.09 Wed
 *
 ************************************************************/

#include <stdio.h>
#include <stdlib.h>
#include "ixp.h"
#include "ixp_SrcCom.h"
#include "../lib/libstring.h"


/*------------------------------------------------------------
 *  ixp_get_rid_posi
 *    Type1ǥåդRIDǼ֤
 *  ARGUMENT
 *    STRING    ::= ڡȥ󥰡ʤ
 *    DType     ::= 0  % integer
 *                | 1  % string
 *                | 2  % psi_string
 *    RDataPosi ::= RData ΰ
 *
 *  Return
 *    RID  ::= RDataPosi ˳ǼƤ RID(integer)
 *
 *------------------------------------------------------------
 */

int
ixp_get_rid_posi(char *String, int DType, int RDataPosi)
{
    int HousedKeyL;
    int RidPosi;

    switch(DType) {
    /*  */
    case TYP_INT :
	RidPosi = KINT_L + RDataPosi;
	return RidPosi;
	break;
    /* psi_string */
    case TYP_PSTR : 
/*    case TYP_STR :  */
	HousedKeyL  = ixp_get_int(String, RDataPosi);
	RidPosi = KEYL + HousedKeyL * 2 + RDataPosi;
	return RidPosi;
	break;
    /* string */
    default :
	HousedKeyL  = ixp_get_int(String, RDataPosi);
	HousedKeyL  = HousedKeyL & ODD_MASK;
	RidPosi = KEYL + HousedKeyL * 2 + RDataPosi;
	return RidPosi;
	break;
    }
}



/*------------------------------------------------------------
 *  ixp_is_value_lpn
 *  ֤˳ǼƤΤLPNɤȽꤹ
 *  ARGUMENT
 *    STRING    ::= ڡȥ󥰡ʤ
 *    RIDPosi   ::= RID ΰ
 *
 *  Return
 *    YES or NO  ::= LPNʤYES ,ʤʤNO
 *
 *------------------------------------------------------------
 */

int
ixp_is_value_lpn(char *String, int RidPosi)
{
/*    int  Head = String[RidPosi] & 0xF0;
/*
/*    switch(Head) {
/*      case 0x20:  /* LPN ξ 1*  E*LPNˤǼƤ */
/*      case 0xE0:
/*	return YES;
/*     default:
/*	return NO;
/*    }
 */

    return (*((short *)&String[RidPosi]) < 0) ? YES : NO;

}



/*------------------------------------------------------------
 *  ixp_get_child_LPN
 *    ֤˳ǼƤLPNФ
 *    ǥåλҥڡLPN LPNǳǼƤ뤿ᡢ
 *    饤֥굡ǽϻͤǤʤ
 *  ARGUMENT
 *    STRING    ::= ڡȥ󥰡ʤ
 *    Posi      ::= ҥڡLPNǼ
 *    LPN       ::= ǼƤLPN
 *
 *  Return
 *
 *------------------------------------------------------------
 */

int
ixp_get_child_LPN(char *String, int Posi, int *LPN)
{
    int i;
    char *ptr;

    ptr = String + Posi;
    GET_INTEGER_NM(i, ptr);
    *LPN = (((i & 0x30000000) >> 2) | (i & 0x03FFFFFF)) | 0xF0000000;
    return 0;

/*    unsigned int work[4];                    /* Ѵΰ */
/*    int TMP_LPN;
/*
/*    TMP_LPN = (((String[Posi] & 0x03) |
/*		((String[Posi] & 0x30) >> 2)) << 24);
/*    TMP_LPN = TMP_LPN | 0xF0000000;
/*        /* 1.̣ӥåȤ򥯥ꥢ̣ӥåȤݻ
/*         * 2.裲ӥåȤݻʥڡ̻ҡ
/*	 * 3.2.Υڡ̻Ҥ򱦤ˣӥåȥեȤ
/*	 * 4.13¤򣲣ӥåȺ˥եȤ
/*	 * 5.40xF0000000¤ꡢȤ
/*	 * 6.ǡǾ8bitδ
/*	 */
/*    TMP_LPN = TMP_LPN | ((String[Posi + 1] & 0xFF) << 16);
/*    TMP_LPN = TMP_LPN | ((String[Posi + 2] & 0xFF) << 8);
/*    TMP_LPN = TMP_LPN | (String[Posi + 3] & 0xFF);
/*
/*    TMP_LPN = ~TMP_LPN;
/*    *LPN = TMP_LPN;
/*    return 0;
 */
}


/*------------------------------------------------------------
 *  ixp_get_next_RDataPosi
 *     RData ΰ֤롣
 *  ARGUMENT
 *    Scan      ::= 1  % ascend, equ
 *                | 2  % descend
 *    STRING    ::= ڡȥ󥰡ʤ
 *    plength   ::= ڡĹ
 *    DType     ::= 0  % integer    ǡ
 *                | 1  % string
 *                | 2  % psi_string
 *    RDataPosi ::= integer % RData ΰ
 *  Return
 *    0  ::= 
 *    -1 ::= ۾
 *
 *------------------------------------------------------------
 */

int
ixp_get_next_RDataPosi(int Scan, char *String, int plength,
		       int SInfoPosi, int *NextSInfoPosi)
{
    int  NextRDataPosi;
    int  NextSI;
    int  RDataCount;

    switch(Scan) {
    case ascend_type :
	NextSI = SInfoPosi - 2;
	RDataCount = ixp_get_int(String, SICPOSI);
/*	if(NextSI < PLENGTH - RDataCount * 2) { */
	if(NextSI < plength - RDataCount * 2) {
	    *NextSInfoPosi = NEXT_LPN;
	    NextRDataPosi  = NEXT_LPN;
	}
	else {
	    *NextSInfoPosi = NextSI;
	    NextRDataPosi =  ixp_get_int(String, *NextSInfoPosi);
	}
	NextRDataPosi = NextRDataPosi * 2; /* 16bit posi to 8 bit posi */
	return NextRDataPosi;
	break;
    default :
	NextSI = SInfoPosi + 2;
/*	if(NextSI >= PLENGTH) { */
	if(NextSI >= plength) {
	    *NextSInfoPosi = NEXT_LPN;
	    NextRDataPosi  = NEXT_LPN;
	}
	else {
	    *NextSInfoPosi = NextSI;
	    NextRDataPosi =  ixp_get_int(String, *NextSInfoPosi);
	}
	NextRDataPosi = NextRDataPosi * 2; /* 16bit posi to 8 bit posi */
	return NextRDataPosi;
	break;
    }
}




/*------------------------------------------------------------
 *  ixp_set_RidEle
 *    Type1 վRIDǤ̤˳Ǽ롣
 *
 *  ARGUMENT
 *    STRING    ::= ڡȥ󥰡ʤ
 *    RidEPosi  ::= integer % Rid Elemnt ΰ
 *    RidEN     ::= RIDǿ
 *    OccFlag   ::= SubRID ̵ͭ򼨤ϡ
 *    PageFlag  ::= ҥڡ̵֤ͭ
 *    Result    ::= ̤Υꥹȹ¤KLICǡˤؤΥݥ
 *                  [RID_ele {"," RID_ele}]
 *    g_allocp   ::= KLIC ҡץꥢ ݥ
 *
 *  Return
 *    g_allocp   ::= ꥹȹ¤ƻѤΰʬʤ᤿
 *                  g_allocp
 *
 *------------------------------------------------------------
 */

q *
ixp_set_RidEle(char *String, int RidEPosi, int RidEN, 
	       int OccFlag, int *PageFlag, q *Result, q *g_allocp)
{
    struct cons *consp;

    int  i;            /* for loop counter */
    q    *TMP_RES;     /* 롼θ̥ݥ */
    int  RID;          /* RID  */
    int  NextPosi;     /* RID Element ΰ֡byte ñ */
    q    SubRID;

    

    TMP_RES = Result;
    *PageFlag = OnPage;
    G_HEAPALLOC((q)consp, G_SIZE_IN_Q(struct cons)*RidEN, (q));
    for(i = 1; i <= RidEN; i++, consp++) {
	NextPosi = ixp_get_int(String, RidEPosi);
	NextPosi = NextPosi * 2;  /* 16bit Posi to 8bit Posi */
	RID = ixp_get_4byte_int(String, RidEPosi + 2); /* 2 NPΥ */
	/* 󥹤ʤ */
	if(OccFlag == NO_OCC) {
	    consp->car = G_MAKEINT(RID);
	}
	/* ͭ */
	else{
	    g_allocp = ixp_get_SubRids(String, RID, RidEPosi + 2, OccFlag, 
				       PageFlag, &SubRID, g_allocp);
	    consp->car = SubRID;
	}
	*TMP_RES = G_MAKECONS(consp);
	TMP_RES  = &consp->cdr;
	RidEPosi = NextPosi;
    }
    (--consp)->cdr = NILATOM;
    return g_allocp;
}




/*  LOCAL  */

/*------------------------------------------------------------
 *  ixp_get_SubRids
 *    Type1 վRIDǤΤSubRIDľΥǡ̤
 *    Ǽ롣
 *
 *  ARGUMENT
 *    STRING    ::= ڡȥ󥰡ʤ
 *    RidEPosi  ::= integer % Rid Elemnt ΰ  RIDΰ
 *    PageFlag  ::= ҥڡ̵֤ͭ
 *    SubRID    ::= ̤Υꥹȹ¤KLICǡˤؤΥݥ
 *                  [RID, SubRid]
 *    g_allocp   ::= KLIC ҡץꥢ ݥ
 *
 *  Return
 *    g_allocp   ::= ꥹȹ¤ƻѤΰʬʤ᤿
 *                  g_allocp
 *
 *------------------------------------------------------------
 */


q *
ixp_get_SubRids(char *String, int RID, int RidEPosi, 
		int OccNest, int *PageFlag, q *SubRID, q *g_allocp)
{
    struct cons *consp;
    int  LPN;
    q    *TMP_RES;     /* 롼θ̥ݥ */
    q    Occ;          /* 󥹾Ǽѿ */

    *PageFlag = OnPage;

    TMP_RES = SubRID;
    G_HEAPALLOC((q)consp, G_SIZE_IN_Q(struct cons)*2, (q));

    /* ꥹȤ裱ǤRIDǼ */
    consp->car = G_MAKEINT(RID);
    *TMP_RES = G_MAKECONS(consp);
    TMP_RES  = &consp->cdr;

    /* ꥹȤ裲ǤSubRIDǼ */
    consp++;
    if(ixp_is_value_lpn(String, RidEPosi + 4) == YES) {
	*PageFlag = ChildPage;
	
	ixp_get_child_LPN(String, RidEPosi + 4, &LPN);
	consp->car = G_MAKEINT(LPN);
    }
    else{
	g_allocp = get_occ_infos(String, RidEPosi, OccNest, &Occ, g_allocp);
	consp->car = Occ;
    }
    *TMP_RES = G_MAKECONS(consp);

    consp->cdr = NILATOM;
    return g_allocp;
}



/*------------------------------------------------------------
 *  get_OccInfos
 *    Type1 վΥ󥹾󷲤̤˳Ǽ
 *
 *  ARGUMENT
 *    STRING    ::= ڡȥ󥰡ʤ
 *    RidEPosi  ::= integer % Rid Elemnt ΰ  RIDΰ
 *    Occ       ::= ̤Υꥹȹ¤KLICǡˤؤΥݥ
 *                  [OccInfo {"," OccInfo} ]
 *    g_allocp   ::= KLIC ҡץꥢ ݥ
 *
 *  Return
 *    g_allocp   ::= ꥹȹ¤ƻѤΰʬʤ᤿
 *                  g_allocp
 *
 *------------------------------------------------------------
 */


static q *
get_occ_infos(char *String, int RidEPosi, 
	      int OccNest, q *Occ, q *g_allocp)

{
    struct cons *consp;
    int  i;            /* for loop  */
    q    *TMP_RES;     /* 롼θ̥ݥ */
    q    Occ_info;     /* ġΥ󥹾 */
    int  SubRidP;      /* 󥹾(SubRid)Ǽ */
    int  OccCnt;       /* 󥹾ο */

    SubRidP =  ixp_get_int(String, RidEPosi + 4);
    SubRidP = SubRidP * 2;  /* 16bit Posi to 8bit Posi */
    OccCnt  =  ixp_get_int(String, RidEPosi + 6);

    TMP_RES = Occ;
    G_HEAPALLOC((q)consp, G_SIZE_IN_Q(struct cons)*OccCnt, (q));

    for(i=1; i <= OccCnt; i++, consp++) {
	g_allocp = ixp_get_occ_info(String, OccNest,
				SubRidP + 2, &Occ_info, g_allocp);
        consp->car = Occ_info;
        *TMP_RES = G_MAKECONS(consp);
        TMP_RES  = &consp->cdr;
	SubRidP = ixp_get_int(String, SubRidP);
	SubRidP = SubRidP * 2;
    }
    (--consp)->cdr = NILATOM;
    return g_allocp;
}



/*------------------------------------------------------------
 *  get_OccInfo
 *    Type1 վΥ󥹾ᣱĤSubRid̤˳Ǽ
 *
 *  ARGUMENT
 *    STRING    ::= ڡȥ󥰡ʤ
 *    OccStart  ::= 줫륪󥹾ΰ֡NPʬʤǤ
 *    Occ_info  ::= ̤Υꥹȹ¤KLICǡˤؤΥݥ
 *                  [OccNum {"," OccNum} ]
 *    g_allocp   ::= KLIC ҡץꥢ ݥ
 *
 *  Return
 *    g_allocp   ::= ꥹȹ¤ƻѤΰʬʤ᤿
 *                  g_allocp
 *
 *------------------------------------------------------------
 */

q *
ixp_get_occ_info(char *String, int OccNest, 
		 int OccStart, q *Occ_info, q *g_allocp)
{
    struct cons *consp;
    int  i;            /* fro loop  */
    q    *TMP_RES;     /* 롼θ̥ݥ */
    int  OccPosi;      /* ֹǼ */
    int  Occ;          /* ֹ */

    G_HEAPALLOC((q)consp, G_SIZE_IN_Q(struct cons)*OccNest, (q));

    TMP_RES = Occ_info;
    for(i= 1, OccPosi = OccStart; i <= OccNest; i++, consp++) {
	Occ = ixp_get_4byte_int(String, OccPosi); 
	consp->car = G_MAKEINT(Occ);
        *TMP_RES = G_MAKECONS(consp);
        TMP_RES  = &consp->cdr;
	OccPosi = OccPosi + 4;
    }
    (--consp)->cdr = NILATOM;
    return g_allocp;
}









