/*
/*	(C)1992, 1993, 1995 Institute for New Generation Computer Technology
/*		ۤ¾COPYRIGHTե򻲾ȤƲ
/*		(Read COPYRIGHT for detailed information.)
 */

/************************************************************
 *
 *  FILE NAME
 *    ixp_point.c
 *  DESCLIPTION
 *    ǥåץΥ⥸塼롣ȥǤΥ
 *    Ǽ֤ؤΰդԤʤ
 *  INTERFACE ROUTINES
 *    binary_search1 - Type1 դΤʤ RData ΰ֤֤
 *    binary_search2 - Type2,3 դҶ LPN ֤
 *  NOTES
 *
 *$ EDITOR : Sugizaki Gen
 *$ CREATE : 93.12.21 Tue
 *$ UPDATE : 94.04.25 Mon
 *
 ************************************************************/

#include <stdio.h>
#include <string.h>
#include "ixp.h"
#include "ixp_PntLef.h"



/*------------------------------------------------------------
 *  ixp_BinarySearch1_int
 *   ǥåդ椫ꥭ RData ֤Ф
 *   ΰդǤRDataΰ֤ޤǤϵʤ
 *  ARGUMENT
 *    STRING ::= ڡȥ󥰡ʤ
 *    IntKey ::= ͡
 *    Access ::= 0  % =  euqal
 *               1  % <  ascend
 *               2  % =< asecnd_equal
 *               3  % >  descend
 *               4  % >= descend_equal
 *    plength   ::= ڡĹ
 *    RDataPosi ::= integer % RData ΰ
 *                  -1      % Υڡ¸ߤ
 *  Return
 *    0  ::= 
 *    -1 ::= ۾
 *
 *------------------------------------------------------------
 */

/* Хʥꥵ */

int
ixp_BinarySearch1_int(char *String, int IntKey, int Access, 
                      int plength, int *RDataPosi, int *SinfoPosi)

/* int 
/* ixp_BinalySearch1_Int(char *String, int IntKey,
/* 		      int Access, int *RDataPosi, int *SinfoPosi)
 */
{
    switch(Access) {
    /* Equal */
    case equal_idx :
	equ_b_search(String, IntKey, 
		     NULL, TYP_INT, plength, RDataPosi, SinfoPosi);
	break;
    /* Ascend */
    case ascend :
	ascend_b_search(String, IntKey, NULL,
			Access, TYP_INT, plength, RDataPosi, SinfoPosi);
	break;
    /* Ascend_Equal */
    case ascend_e :
	ascend_b_search(String, IntKey, NULL,
			Access, TYP_INT, plength, RDataPosi, SinfoPosi);
	break;
    /* Descend, Descend_Equal */
    default:
	descend_b_search(String, IntKey, NULL,
			 Access, TYP_INT, plength, RDataPosi, SinfoPosi);
    }
    return Normal;
}


/*------------------------------------------------------------
 *  ixp_BinarySearch1_Str
 *   ǥåդ椫ꥭ RData ֤Ф
 *   ΰդǤRDataΰ֤ޤǤϵʤ
 *  ARGUMENT
 *    STRING ::= ڡȥ󥰡ʤ
 *    Key    ::= ͡ʥȥ󥰡
 *    DType  ::= 0  % integer    ǡ
 *               1  % string
 *               2  % psi_string
 *    Access ::= 0  % =  euqal
 *               1  % <  ascend
 *               2  % =< asecnd_equal
 *               3  % >  descend
 *               4  % >= descend_equal
 *    DType     ::= ǡ
 *    plength   ::= ڡĹ
 *    RDataPosi ::= integer % RData ΰ
 *                  -1      % Υڡ¸ߤ
 *  Return
 *    0  ::= 
 *    -1 ::= ۾
 *
 *------------------------------------------------------------
 */
/* Хʥꥵ */

int 
ixp_BinarySearch1_str(char *String, char *StrKey,int Access, 
		      int DType, int plength, int *RDataPosi, int *SinfoPosi)

/* int 
/* ixp_BinalySearch1_Str(char *String, char *StrKey,int Access, 
/* 		      int DType, int *RDataPosi, int *SinfoPosi)
 */
{
    switch(Access) {
    /* Equal */
    case equal_idx :
	equ_b_search(String, NULL, StrKey, 
			DType, plength, RDataPosi, SinfoPosi);
	break;
    /* Ascend */
    case ascend :
	ascend_b_search(String, NULL, StrKey, 
			Access, DType, plength, RDataPosi, SinfoPosi);
	break;
    /* Ascend_Equal */
    case ascend_e :
	ascend_b_search(String, NULL, StrKey, 
			Access, DType, plength, RDataPosi, SinfoPosi);
	break;
    /* Descend, Descend_Equal */
    default:
	descend_b_search(String, NULL, StrKey, 
			 Access, DType, plength, RDataPosi, SinfoPosi);
    }
    return Normal;
}





/*---------------------------------------------------------------
 * equ_b_search
 * ΡɤΥڡҶ RData ǼƤ֤ȡSinfo 
 * ǼƤ֤Ф硣
 * ڡ RData οǽʬʣΤȤʣΤȤˡ
 *
 * ARGUMENT : String ::= ڡȥؤΥݥ
 *            Key    ::= ͡
 *    DType  ::= 0  % integer    ǡ
 *               1  % string
 *               2  % psi_string
 *            RDataPosi ::= RData γǼ֡ʥ꥿͡
 *            SinfoPosi ::= Sinfo γǼ֡ʥ꥿͡
 *
 *---------------------------------------------------------------
 */

/* equalΥХʥꥵ */

void static
equ_b_search(char *String, int IntKey, char *StrKey,
	     int DType, int plength, int *RDataPosi, int *SinfoPosi)
{
    int SinfoN = 0;       /* Search Info ο */
    int Quotient = 0;     /* SinfoN / 2 ξ  */
    int CurrentPosi = 0;  /* ߥݥȤƤ Sinfo  */
    int Left_rest = 0;    /* Хʥ긡ͤκȾʬ */
    int Right_rest = 0;   /* Хʥ긡ͤαȾʬ */
    int LastPosi = 0;     /* Хʥꥵκǽ  Sinfoκü */

    SinfoN = ixp_get_int(String, 2); /* 2 is Search Info Count Posi */

    /* ǥåʤȤʺ줿ФդΤȤ */
    if(SinfoN == 0) {
/*	*SinfoPosi = PLENGTH / 2; */
	*SinfoPosi = plength / 2;
	*RDataPosi = -1;
    }
    else {
	/* ǥåΤȤ */
	if(SinfoN == 1) {
/*	    CurrentPosi = PLENGTH - 2;  /* -2 1 Sinfo */
	    CurrentPosi = plength - 2;  /* -2 1 Sinfo */
	    compare_one_info(String, IntKey, StrKey, equal_idx, DType, 
			     CurrentPosi, plength, RDataPosi, SinfoPosi);
	}
	/* ǥåʾΤȤ */
	else{
/*	    LastPosi = PLENGTH - SinfoN * 2; */
	    LastPosi = plength - SinfoN * 2;
	    ixp_get_quotient(SinfoN, &Quotient, &Left_rest, &Right_rest);
/*	    CurrentPosi = PLENGTH - 2 - Quotient * 2; */
/*	    CurrentPosi = PLENGTH - 2 - Right_rest * 2;  */
	    CurrentPosi = plength - 2 - Right_rest * 2;
	    equ_binary_search(String, IntKey, StrKey, DType, LastPosi,
			      CurrentPosi, SinfoN, Left_rest, Right_rest, 
			      plength, RDataPosi, SinfoPosi);
	}
    }
}
    


/*---------------------------------------------------------------
 * equ_binaly_search
 * ΡɤΥڡҶ RData ǼƤ֤ȡSinfo 
 * ǼƤ֤Ф硣
 * ڡʣ RData ǼƤν
 *
 * ARGUMENT : String ::= ڡȥؤΥݥ
 *            Key    ::= ͡
 *            DType  ::= 0  % integer    ǡ
 *                       1  % string
 *                       2  % psi_string
 *            LastPosi ::= Хʥꥵκǽ  Sinfo κü
 *            CurrenrPosi ::= Bynaly_SearchΤθߤSinfoΰ
 *            SinfoN      ::= Bynaly_SearchΤλĤSinfo
 *            Left_rest ::= Sinfoΰ֤κλĤ
 *            Right_rest ::= Sinfoΰ֤αλĤ
 *            RDataPosi ::= RData γǼ֡ʥ꥿͡
 *            SinfoPosi ::= Sinfo γǼ֡ʥ꥿͡
 *
 *---------------------------------------------------------------
 */

/* ȥ RData İʾ¸ߤȤ  Хʥꥵ */
void static 
equ_binary_search(char *String, int IntKey, char *StrKey,
                  int DType, int LastPosi, int CurrentPosi, 
		  int SinfoN, int Left_rest, int Right_rest, 
                  int plength, int *RDataPosi, int *SinfoPosi)

{
    int   RDP = 0;       /* ȤSearchInfoݥȤRData ΰ */
    int   RData = 0;     /*  */
    int   RD_Key = 0;    /* RData  ǼƤ륭 */
    int   Quotient = 0;  /* Хʥꥵξ */
    int   NewCurPosi = 0;     /* Ȱ */
    int   New_Left_rest = 0;  /* Bynery_Search οʤޤ */
    int   New_Right_rest = 0; /* Binary_Search οʤޤ */


    RDP = ixp_get_int(String, CurrentPosi);
    RDP = RDP * 2;  /* 16bit offset to 8bit Offset */

    switch(ixp_compare_key(String, IntKey, StrKey, DType, RDP)) {

    /* RData ΥͤȻꥭͤƱȤ */
    case Same :
	*SinfoPosi = CurrentPosi / 2 ;
	*RDataPosi = RDP / 2;
/* 	return Normal; */
	break;


    /*  RData õˤ */
    /* RData ΥΤۤ */
    case Small :
	/* դΰֺʺˤͤꥭ礭 */
	if(CurrentPosi == LastPosi){
	    *SinfoPosi = CurrentPosi / 2;
	    *RDataPosi  = -1;
	}
	else{
	    if(SinfoN == 0){
		*SinfoPosi = CurrentPosi / 2;
		*RDataPosi = -1;
	    }
	    else{
		ixp_get_quotient(Left_rest, 
				 &Quotient, &New_Left_rest, &New_Right_rest);
/*		NewCurPosi = CurrentPosi - 2 - Quotient * 2;  */
                /* -2  Left_rest κǱüؤΰդ */
		NewCurPosi = CurrentPosi - 2 - New_Right_rest * 2;  
		equ_binary_search(String, IntKey, 
				  StrKey, DType, LastPosi, NewCurPosi, 
				  Quotient, New_Left_rest, New_Right_rest, 
				  plength, RDataPosi, SinfoPosi);
	    }
	}
/* 	return Normal; */
	break;
	
    /* RData ΥΤۤ礭 */
    default :
	if(SinfoN == 0){
	    *SinfoPosi = CurrentPosi / 2;
	    *SinfoPosi = *SinfoPosi + 1;      /* For kappa Q03.01 */
	                                      /*$ '94.11.08 by Sugizaki */
	    *RDataPosi = -1;
	}
	else{
	    ixp_get_quotient(Right_rest, 
			     &Quotient, &New_Left_rest, &New_Right_rest);
/*  	    NewCurPosi = CurrentPosi + 2 + Quotient * 2;  */
                /* +2  Right_rest κǺüؤΰդ */
  	    NewCurPosi = CurrentPosi + Quotient * 2;

	    equ_binary_search(String, IntKey, 
				 StrKey, DType, LastPosi, NewCurPosi, 
				 Quotient, New_Left_rest, New_Right_rest, 
				 plength, RDataPosi, SinfoPosi);
	}
/* 	return Normal; */
	break;
    }
}





/*---------------------------------------------------------------
 * ascend_b_search
 * ΡɤΥڡҶ RData ǼƤ֤ȡSinfo 
 * ǼƤ֤Ф硣
 * ڡ RData οǽʬʣΤȤʣΤȤˡ
 *
 * ARGUMENT : String ::= ڡȥؤΥݥ
 *            Key    ::= ͡
 *            Access ::= ׼̻ҡ
 *                       1 = ascend, 2 = asecnd_equal
 *                       3 = descend, 4 = descend_equal
 *    DType  ::= 0  % integer    ǡ
 *               1  % string
 *               2  % psi_string
 *            RDataPosi ::= RData γǼ֡ʥ꥿͡
 *            SinfoPosi ::= Sinfo γǼ֡ʥ꥿͡
 *
 *---------------------------------------------------------------
 */

/* Ascend ϤΥХʥꥵ */

void static 
ascend_b_search(char *String, int IntKey, char *StrKey,int Access, 
		int DType, int plength, int *RDataPosi, int *SinfoPosi)

{
    int SinfoN = 0;       /* Search Info ο */
    int Quotient = 0;     /* SinfoN / 2 ξ  */
    int CurrentPosi = 0;  /* ߥݥȤƤ Sinfo  */
    int Left_rest = 0;    /* Хʥ긡ͤκȾʬ */
    int Right_rest = 0;   /* Хʥ긡ͤαȾʬ */
    int LastPosi = 0;     /* Хʥꥵκǽ  Sinfoκü */

    SinfoN = ixp_get_int(String, 2); /* 2 is Search Info Count Posi */

    /* ǥåʤȤʺ줿ФդΤȤ */
    if(SinfoN == 0) {
/*	*SinfoPosi = PLENGTH / 2; */
	*SinfoPosi = plength / 2;
	*RDataPosi = -1;
    }
    else {
	/* ǥåΤȤ */
	if(SinfoN == 1) {
/*	    CurrentPosi = PLENGTH - 2;  /* -2 1 Sinfo */
	    CurrentPosi = plength - 2;  /* -2 1 Sinfo */
	    compare_one_info(String, IntKey, StrKey, Access, DType, 
			     CurrentPosi, plength, RDataPosi, SinfoPosi);
	}
	/* ǥåʾΤȤ */
	else{
/*	    LastPosi = PLENGTH - SinfoN * 2; */
	    LastPosi = plength - SinfoN * 2;
	    ixp_get_quotient(SinfoN, &Quotient, &Left_rest, &Right_rest);
/* 	    CurrentPosi = PLENGTH - 2 - Quotient * 2;  */
/*	    CurrentPosi = PLENGTH - 2 - Right_rest * 2; */
	    CurrentPosi = plength - 2 - Right_rest * 2;
	    ascend_binary_search(String, IntKey, StrKey, Access, 
				 DType, LastPosi, CurrentPosi, SinfoN, 
				 Left_rest, Right_rest, plength, 
                                 RDataPosi, SinfoPosi);
	}
    }
}
    


/*---------------------------------------------------------------
 * ascend_binaly_search
 * ΡɤΥڡҶ RData ǼƤ֤ȡSinfo 
 * ǼƤ֤Ф硣
 * ڡʣ RData ǼƤν
 *
 * ARGUMENT : String ::= ڡȥؤΥݥ
 *            Key    ::= ͡
 *            Access ::= ׼̻ҡ
 *                       1 = ascend, 2 = asecnd_equal
 *                       3 = descend, 4 = descend_equal
 *            DType  ::= 0  % integer    ǡ
 *                       1  % string
 *                       2  % psi_string
 *            LastPosi ::= Хʥꥵκǽ  Sinfo κü
 *            CurrenrPosi ::= Bynaly_SearchΤθߤSinfoΰ
 *            SinfoN      ::= Bynaly_SearchΤλĤSinfo
 *            Left_rest ::= Sinfoΰ֤κλĤ
 *            Right_rest ::= Sinfoΰ֤αλĤ
 *            RDataPosi ::= RData γǼ֡ʥ꥿͡
 *            SinfoPosi ::= Sinfo γǼ֡ʥ꥿͡
 *
 *---------------------------------------------------------------
 */

/* ȥ RData İʾ¸ߤȤ  Хʥꥵ */
void static 
ascend_binary_search(char *String, int IntKey, char *StrKey,
		     int Access, int DType, int LastPosi, int CurrentPosi, 
		     int SinfoN, int Left_rest, int Right_rest, 
		     int plength, int *RDataPosi, int *SinfoPosi)
{
    int   RDP = 0;       /* ȤSearchInfoݥȤRData ΰ */
    int   RData = 0;     /*  */
    int   RD_Key = 0;    /* RData  ǼƤ륭 */
    int   Quotient = 0;  /* Хʥꥵξ */
    int   NewCurPosi = 0;     /* Ȱ */
    int   New_Left_rest = 0;  /* Bynery_Search οʤޤ */
    int   New_Right_rest = 0; /* Binary_Search οʤޤ */


    RDP = ixp_get_int(String, CurrentPosi);
    RDP = RDP * 2;  /* 16bit Offset to 8bit Offset */

    switch(ixp_compare_key(String, IntKey, StrKey, DType, RDP)) {
    case Same :    /* RData ΥͤȻꥭͤƱȤ */
	if(Access == ascend){	/* ascend ΤȤ */
	    if(CurrentPosi == LastPosi){
/*		*SinfoPosi = CurrentPosi / 2; */
/*		*RDataPosi = -1; */
		*SinfoPosi = (CurrentPosi - 2) / 2;
		*RDataPosi = 2;
	    } else {
		*SinfoPosi = (CurrentPosi - 2) / 2;
		*RDataPosi = ixp_get_int(String, CurrentPosi - 2);
	    }
	} else { 	/* ascend_equal ΤȤ */
	    *SinfoPosi = CurrentPosi / 2 ;
	    *RDataPosi = RDP / 2;
	}
/*	return Normal; */
	break;

    case Small :    /* RData ΥΤۤ */
                    /*  RData õˤ */
	if(CurrentPosi == LastPosi){
/*	    *SinfoPosi = CurrentPosi / 2; */
/*	    *RDataPosi = -1; */
	    *SinfoPosi = (CurrentPosi - 2) / 2;
	    *RDataPosi = 2;
	} else {
	    if(SinfoN == 0){
		*SinfoPosi = (CurrentPosi - 2) / 2 ; /* ĺ٤SinfoN */
		RDP = ixp_get_int(String, CurrentPosi - 2);
		*RDataPosi = RDP;
/*		return Normal; */
		break;
	    } else {
		ixp_get_quotient(Left_rest, 
				 &Quotient, &New_Left_rest, &New_Right_rest);
/*		NewCurPosi = CurrentPosi - 2 - Quotient * 2; */
		NewCurPosi = CurrentPosi - 2 - New_Right_rest * 2;
                    /* -2  Left_rest κǱüؤΰդ */
		ascend_binary_search(String, IntKey, StrKey, 
				     Access, DType, LastPosi,NewCurPosi, 
				     Quotient, New_Left_rest, New_Right_rest, 
				     plength, RDataPosi, SinfoPosi);
	    }
	}
	break;

    default :     /* RData ΥΤۤ礭 */
	if(SinfoN == 0){
	    *SinfoPosi = CurrentPosi / 2;  /* դαüSinfoN */
	    *RDataPosi = RDP / 2;
/*	    return Normal; */
	    break;
	} else {
	    ixp_get_quotient(Right_rest, 
			     &Quotient, &New_Left_rest, &New_Right_rest);
/* 	    NewCurPosi = CurrentPosi + 2 + Quotient * 2; */
                /* +2  Right_rest κǺüؤΰդ */
 	    NewCurPosi = CurrentPosi + Quotient * 2;
	    ascend_binary_search(String, IntKey, StrKey, 
				 Access, DType, LastPosi, NewCurPosi, 
				 Quotient, New_Left_rest, New_Right_rest, 
				 plength, RDataPosi, SinfoPosi);
	}
	break;
    }
}


/*---------------------------------------------------------------
 * descend_b_search
 * ΡɤΥڡҶ RData ǼƤ֤ȡSinfo 
 * ǼƤ֤Ф߽硣
 * ڡ RData οǽʬʣΤȤʣΤȤˡ
 *
 * ARGUMENT : String ::= ڡȥؤΥݥ
 *            Key    ::= ͡
 *            Access ::= ׼̻ҡ
 *                       1 = ascend, 2 = asecnd_equal
 *                       3 = descend, 4 = descend_equal
 *            DType  ::= 0  % integer    ǡ
 *                       1  % string
 *                       2  % psi_string
 *            RDataPosi ::= RData γǼ֡ʥ꥿͡
 *            SinfoPosi ::= Sinfo γǼ֡ʥ꥿͡
 *
 *---------------------------------------------------------------
 */


/* Desend ϤΥХʥꥵ */
void static 
descend_b_search(char *String, int IntKey, char *StrKey, int Access, 
		 int DType, int plength, int *RDataPosi, int *SinfoPosi)
{
    int SinfoN = 0;       /* Search Info ο */
    int Quotient = 0;     /* SinfoN / 2 ξ  */
    int CurrentPosi = 0;  /* ߥݥȤƤ Sinfo  */
    int Left_rest = 0;    /* Хʥ긡ͤκȾʬ */
    int Right_rest = 0;   /* Хʥ긡ͤαȾʬ */
    int LastPosi = 0;     /* Хʥꥵκǽ  Sinfo κü */

    SinfoN = ixp_get_int(String, 2); /* 2 is Search Info Count Posi */

    /* ǥåʤȤʺ줿ФդΤȤ */
    if(SinfoN == 0) {
/* 	*SinfoPosi = PLENGTH / 2; */
 	*SinfoPosi = plength / 2; 
	*RDataPosi = -1;
    }
    else {
	/* ǥåΤȤ */
	if(SinfoN == 1) {
/*	    CurrentPosi = PLENGTH - 2; */
	    CurrentPosi = plength - 2;
	    compare_one_info(String, IntKey, StrKey, Access, DType, 
			     CurrentPosi, plength, RDataPosi, SinfoPosi);
	}
	/* ǥåʾΤȤ */
	else{
	    ixp_get_quotient(SinfoN, &Quotient, &Left_rest, &Right_rest);
/*	    LastPosi = PLENGTH - SinfoN * 2; */
	    LastPosi = plength - SinfoN * 2;
	    Quotient = SinfoN / 2;
/*	    CurrentPosi = PLENGTH - 2 - Quotient * 2; */
/*	    CurrentPosi = PLENGTH - 2 - Right_rest * 2;  */
	    CurrentPosi = plength - 2 - Right_rest * 2; 
	    descend_binary_search(String, IntKey, StrKey, Access, DType, 
				  LastPosi, CurrentPosi, SinfoN, Left_rest, 
				  Right_rest, plength, RDataPosi, SinfoPosi);
	}
    }
}
    

/*---------------------------------------------------------------
 * descend_binaly_search
 * ΡɤΥڡҶ RData ǼƤ֤ȡSinfo 
 * ǼƤ֤Ф߽硣
 * ڡʣ RData ǼƤν
 *
 * ARGUMENT : String ::= ڡȥؤΥݥ
 *            Key    ::= ͡
 *            Access ::= ׼̻ҡ
 *                       1 = ascend, 2 = asecnd_equal
 *                       3 = descend, 4 = descend_equal
 *            DType  ::= 0  % integer    ǡ
 *                       1  % string
 *                       2  % psi_string
 *            LastPosi ::= Хʥꥵκǽ  Sinfoκü
 *            CurrenrPosi ::= Bynaly_SearchΤθߤSinfoΰ
 *            SinfoN      ::= Bynaly_SearchΤλĤSinfo
 *            Left_rest ::= Sinfoΰ֤κλĤ
 *            Right_rest ::= Sinfoΰ֤αλĤ
 *            RDataPosi ::= RData γǼ֡ʥ꥿͡
 *            SinfoPosi ::= Sinfo γǼ֡ʥ꥿͡
 *
 *---------------------------------------------------------------
 */

/* ȥ RData İʾ¸ߤȤ  Хʥꥵ */
void static 
descend_binary_search(char *String, int IntKey, char *StrKey, int Access, 
		      int DType, int LastPosi, int CurrentPosi, 
		      int SinfoN, int Left_rest, int Right_rest, 
		      int plength, int *RDataPosi, int *SinfoPosi)
{
    int   RDP = 0;       /* ȤSearchInfoݥȤRData ΰ */
    int   RData = 0;     /*  */
    int   RD_Key = 0;    /* RData  ǼƤ륭 */
    int   Quotient = 0;  /* Хʥꥵξ */
    int   New_Left_rest = 0;  /* Bynery_Search οʤޤ */
    int   New_Right_rest = 0; /* Binary_Search οʤޤ */
    int   NewCurPosi = 0;     /* ΥȰ */

    RDP = ixp_get_int(String, CurrentPosi);
    RDP = RDP * 2;  /* 16bit Offset to 8bit Offset */

    switch(ixp_compare_key(String, IntKey, StrKey, DType, RDP)) {

    /* RData ΥͤȻꥭͤƱȤ */
    case Same :
	/* descend ΤȤ */
	if(Access ==  descend){
/*	    if(CurrentPosi == PLENGTH - 2){ */
	    if(CurrentPosi == plength - 2){
		*SinfoPosi = CurrentPosi / 2;
		*RDataPosi = -1;
	    }
	    else{
		*SinfoPosi = (CurrentPosi + 2) / 2;
		RDP = ixp_get_int(String, CurrentPosi + 2);
		*RDataPosi = RDP;
	    }
	}
	/* descend_equal ΤȤ */
	else{
	    *SinfoPosi = CurrentPosi / 2 ;
	    *RDataPosi = RDP / 2;
	}
/* 	return Normal; */
	break;

    /*  RData õˤ */
    /* RData Υꥭ꾮 */
    case Small :
	if(CurrentPosi == LastPosi){
	    *SinfoPosi = CurrentPosi / 2;
	    *RDataPosi = RDP / 2;
	}
	else{
	    if(SinfoN == 0){
		*SinfoPosi = CurrentPosi / 2;
		*RDataPosi = RDP / 2;
/* 		return Normal; */
	    }
	    else{
		ixp_get_quotient(Left_rest, 
				 &Quotient, &New_Left_rest, &New_Right_rest);
/*		NewCurPosi = CurrentPosi - 2 - Quotient * 2; */
		    /* -2  Left_rest κǱüؤΰդ */
		NewCurPosi = CurrentPosi - 2 - New_Right_rest * 2;
		descend_binary_search(String, IntKey, StrKey, Access, DType,
				      LastPosi, NewCurPosi, Quotient, 
				      New_Left_rest, New_Right_rest, 
				      plength, RDataPosi, SinfoPosi);
	    }
	}
	break;

    /* RData Υꥭ礭 */
    default :
	if(SinfoN == 0){
/*	    if(CurrentPosi == PLENGTH - 2){ */
	    if(CurrentPosi == plength - 2){
		*SinfoPosi = CurrentPosi / 2;
		*RDataPosi = -1;
	    }
	    else{
		*SinfoPosi = (CurrentPosi + 2) / 2;
		RDP = ixp_get_int(String, CurrentPosi + 2);
		*RDataPosi = RDP;
	    }
/* 	    return Normal; */
	    break;
	}
	else{
	    ixp_get_quotient(Right_rest, 
			     &Quotient, &New_Left_rest, &New_Right_rest);
/*	    NewCurPosi = CurrentPosi +2 + Quotient * 2; */
	        /* +2  Right_rest κǺüؤΰդ */
	    NewCurPosi = CurrentPosi +2 + New_Left_rest * 2;
	    descend_binary_search(String, IntKey, StrKey, Access, DType, 
				  LastPosi, NewCurPosi, Quotient, 
				  New_Left_rest, New_Right_rest, 
				  plength, RDataPosi, SinfoPosi);
	}
	break;
    }
}



/*  Common Function  */


/*---------------------------------------------------------------
 * compare_one_info
 * ΡɤΥڡҶ CData ǼƤ֤ȡSinfo 
 * ǼƤ֤Ф硿߽硣
 * ڡ CData ҤȤĳǼƤν
 *
 * ARGUMENT : String ::= ڡȥؤΥݥ
 *            Key    ::= ͡
 *            Access ::= ׼̻ҡ
 *                       1 = ascend, 2 = asecnd_equal
 *                       3 = descend, 4 = descend_equal
 *           DType  ::= 0  % integer    ǡ
 *                      1  % string
 *                      2  % psi_string
 *            CurrenrPosi ::= Bynaly_SearchΤθߤSinfoΰ
 *            CDataPosi ::= CData γǼ֡ʥ꥿͡
 *            SinfoPosi ::= Sinfo γǼ֡ʥ꥿͡
 *
 *---------------------------------------------------------------
 */
/* Search Info Ĥʤ */

void static 
compare_one_info(char *String, int IntKey, char *StrKey,
		 int Access, int DType, int CurrentPosi,
		 int plength, int *CDataPosi, int *SinfoPosi)
{
    int   RDP = 0;     /* ȤSearchInfoݥȤCData ΰ */
    int   CData = 0;   /*  */
    int   RD_Key = 0;  /* CData  ǼƤ륭 */

    RDP = ixp_get_int(String, CurrentPosi);
    RDP = RDP * 2;  /* 16bit String offset  to 8bit String Offset */

    switch(ixp_compare_key(String, IntKey, StrKey, DType, RDP)) {

    /* CData ΥͤȻꥭͤƱȤ */
    case Same : 
	switch(Access) {
	/* descend ΤȤ */
	case descend :
	    *CDataPosi = -1;
	    *SinfoPosi = CurrentPosi / 2;
/*     	    return Normal; */
	    break;
	/* ascend ΤȤ */
	case ascend :
	    *CDataPosi = -1;
	    *SinfoPosi = CurrentPosi / 2;
/*     	    return Normal; */
	    break;
	/* equal, ascend_equal, descend_equal ΤȤ */
	default :
	    *CDataPosi = RDP / 2;
	    *SinfoPosi = CurrentPosi / 2; 
/*          return Normal; */
	    break;
	}
	break;
    /* CData Υͤꥭ礭Ȥ */
    case Large :
	switch(Access) {
	/* descend */
	case descend :
	    *CDataPosi = -1;
	    *SinfoPosi = CurrentPosi / 2;
/*     	    return Normal; */
/*	    printf("Error Occurd in IXP Positioning, Desend Point error");
	    return ERROR;
*/
	    break;
	/* descend_e */
	case descend_e :
	    *CDataPosi = -1;
	    *SinfoPosi = CurrentPosi / 2;
/*     	    return Normal; */
/*	    printf("Error Occurd in IXP Positioning, Desend Point error");
	    return ERROR;
*/
	    break;
	/* equal */
	case equal_idx :
	    *CDataPosi = -1;
	    *SinfoPosi = CurrentPosi / 2; 
	    *SinfoPosi = *SinfoPosi + 1;      /* For kappa Q03.01 */
	                                      /*$ '94.11.08 by Sugizaki */
/*     	    return Normal; */
	    break;
	/* ascend or ascend_e */
	default :
	    *CDataPosi = RDP / 2;
	    *SinfoPosi = CurrentPosi / 2;
/*          return Normal; */
	    break;
	}
	break;
    /* CData Υͤꥭ꾮Ȥ */
    case Small :
	switch(Access) {
	/* ascend */
	case ascend :
	    *CDataPosi = -1;
	    *SinfoPosi = CurrentPosi / 2 ;
/*     	    return Normal; */
/*	    printf("Error Occurd in IXP Positioning, Asend Point error");
	    return ERROR;
*/
	    break;
	/* ascend_e */
	case ascend_e :
	    *CDataPosi = -1;
	    *SinfoPosi = CurrentPosi / 2;
/*     	    return Normal; */
/*	    printf("Error Occurd in IXP Positioning, Asend Point error");
	    return ERROR;
*/
	    break;
	/* equal */
	case equal_idx :
	    *CDataPosi = -1;
	    *SinfoPosi = CurrentPosi / 2;
/*     	    return Normal; */
	    break;
	/* desecend or descend_e */
	default :
	    *CDataPosi = RDP / 2;
	    *SinfoPosi = CurrentPosi / 2;
/* 	    return Normal; */
	    break;
	}
    }
}
