/*
/*	(C)1992, 1993, 1995 Institute for New Generation Computer Technology
/*		ۤ¾COPYRIGHTե򻲾ȤƲ
/*		(Read COPYRIGHT for detailed information.)
 */
/************************************************************
 *
 *  FILE NAME
 *    ixp_PntCom.c
 *  DESCLIPTION
 *    ǥåץΥ⥸塼롣ȥǤΥ
 *    Ǽ֤ؤΰդԤʤݤζ̵ǽ
 *  INTERFACE ROUTINES
 *  NOTES
 *
 *$ EDITOR : Sugizaki Gen
 *$ CREATE : 93.12.21 Tue
 *$ UPDATE : 95.03.24  for linux
 *
 ************************************************************/

#include <stdio.h>
#include <string.h>
#include "ixp.h"
#include "ixp_PntCom.h"
#include "../lib/libstring.h"

/*---------------------------------------------------------------
 * ixp_get_int
 * ڡȥΡ֤ͤФ
 * ºݤˤϥ饤֥ƤǤ
 *
 * ARGUMENT : String ::= ڡȥؤΥݥ
 *            Posi   ::= Ǽ
 *
 *---------------------------------------------------------------
 */

/* 8bit 2element ͤΤȤ */

int 
ixp_get_int(unsigned char *String, int Posi)
{
    int value;
    char *ptr;

    ptr = String + Posi;
    GET_SHORT_INTEGER_NM(value, ptr);
    return value;

/*    unsigned int   INT1 = 0;
/*    unsigned int   INT2 = 0;
/*
/*
/*    INT1 = String[Posi];
/*    INT1 = INT1 << 8;
/*    INT2 = String[Posi + 1];
/*    INT1 = INT1 | INT2;
/*    return(INT1);
 */
}
    

/*---------------------------------------------------------------
 * ixp_get_quotient
 * Хʥꥵκݤ˼Ρ֤롣
 *
 * ARGUMENT : SinfoN ::= SInfo ο
 *            Quotient   ::= õ٤
 *            Left_rest  ::= ֤Ĥʬ麸˻Ĥ
 *            Right_rest ::= ֤Ĥʬ鱦˻Ĥ
 *
 *              SinfoN / 2 = 3 = Quotient
 *                        Left_rest  = 2
 *              Quotient    Right_rest = 3
 *
 *---------------------------------------------------------------
 */

int 
ixp_get_quotient(int SinfoN, int *Quotient, 
		     int *Left_rest, int *Right_rest)
{
    /* ΤȤ */
    if(SinfoN == 1){
/*	*Quotient = 0;
	*Left_rest  = 0;
	*Right_rest = 1;
*/
	*Quotient = 1;
	*Left_rest  = 0;
	*Right_rest = 0;

	return Normal;
    }
    else{
	*Quotient   = SinfoN / 2;
	/*  */
	if((SinfoN - (SinfoN / 2) * 2) == 0) {
	    *Left_rest  = *Quotient - 1;
	    *Right_rest = SinfoN - *Quotient;
	    return Normal;
	}
	/*  */
	else{
	    *Left_rest  = *Quotient;
	    *Right_rest = *Quotient;
	    *Quotient = ++*Quotient;  /* Added */
	    return Normal;
	}
    }
}


/*---------------------------------------------------------------
 * ixp_get_4byte_int
 * ڡȥλꤵ줿֤ˤΣХȤ˳Ǽ
 * Ƥ ͤФ饤֥Ƥ֤
 *
 * ARGUMENT : String ::= ڡȥؤΥݥ
 *            IntKey    ::= ꥭ͡
 *            StrKey    ::= ꥭ͡ʥȥ󥰡
 *            CDataPosi ::= CData Ǽ
 *
 *---------------------------------------------------------------
 */

int 
ixp_get_4byte_int(char *String, int Posi)
{
    int  INT_VL = 0;

/*    lib_GetInteger(String, Posi, &INT_VL); */
    Posi = Posi / 2;         /* 8bit ΰ  16bit ΰ  */
    GetInteger(String, Posi, &INT_VL);

    return INT_VL;
}


/*---------------------------------------------------------------
 * ixp_compare_key
 * ڡȥλꤵ줿֤˳ǼƤ CData 
 * ݻ륭ȡꥭͤӤ롣
 *
 * ARGUMENT : String ::= ڡȥؤΥݥ
 *            IntKey    ::= ꥭ͡
 *            StrKey    ::= ꥭ͡ʥȥ󥰡
 *            CDataPosi ::= CData Ǽ
 *
 *---------------------------------------------------------------
 */

int 
ixp_compare_key(char *String, int IntKey, 
		char *StrKey, int DType, int CDataPosi)
{
    switch(DType) {
    case TYP_INT :
	return compare_int_key(String, IntKey, CDataPosi);
	break;
    /* Data_Type is String */
    case TYP_STR :
	return compare_str_key(String, StrKey, CDataPosi);
	break;
    /* Data_Type is PSI_String */
    default :
	return compare_psi_str_key(String, StrKey, CDataPosi);
	break;
    }
}


/*---------------------------------------------------------------
 * compare_int_key
 * ڡȥλꤵ줿֤˳ǼƤ CData 
 * ݻ륭ȡꥭͤӤ롣
 * 
 * ǼƤ륭ꥭƱ硢 Same ֤
 * ǼƤ륭ꥭ礭硢 Large ֤
 * ǼƤ륭ꥭ꾮硢 Small ֤
 *
 * ARGUMENT : String ::= ڡȥؤΥݥ
 *            Key    ::= ꥭ͡
 *            CDataPosi ::= CData Ǽ
 *
 *---------------------------------------------------------------
 */

/* ǡ */
static int 
compare_int_key(char *String, int Key, int CDataPosi)
{
    int  Housed_key = 0;


    Housed_key = ixp_get_4byte_int(String, CDataPosi);
    if(Housed_key == Key) 
	return Same;
    if(Housed_key > Key) 
	return Large;
    return Small;
}


/* string ǡ */
static int 
compare_str_key(char *String, char *Key, int CDataPosi)
{
    int HousedKeyLength = 0;
    int KeyLength = 0;
    int CompareRet = 0;

    unsigned int KisuuFlag;

    HousedKeyLength = ixp_get_int(String, CDataPosi);

    KisuuFlag = 0x8000 & HousedKeyLength;
    if(KisuuFlag == 0x8000){
	/* ե饰  */
	HousedKeyLength = ODD_MASK & HousedKeyLength;
	KeyLength = HousedKeyLength * 2 - 1;
    }
    else
/*	KeyLength = (( 0x7f & HousedKeyLength) * 2); */
	KeyLength = HousedKeyLength * 2;

    CDataPosi = CDataPosi + KEYL;
    CompareRet = compare_str(String, Key, CDataPosi, 0, KeyLength); 
    if(CompareRet == 0) 
	return Same;
    if(CompareRet > 0)
	return Large;
    return Small;
}


/* psi_string ǡ */
static int 
compare_psi_str_key(char *String, char *Key, int  CDataPosi)
{
    int KeyLength = 0;
    int CompareRet = 0;

/*    KeyLength = (ixp_get_int(String, CDataPosi) * 2); */
    KeyLength = (ixp_get_int(String, CDataPosi) * KEYL); 
    CDataPosi = CDataPosi + KEYL;
    CompareRet = compare_str(String, Key, CDataPosi, 0, KeyLength);

    if(CompareRet == 0) 
	return Same;
    if(CompareRet > 0)
	return Large;
    return Small;
    return 0;
}


/*---------------------------------------------------------------
 * compare_str
 * S1  Posi1 ǻꤵ֤ȡS2  Posi2 ǻꤵ
 * ֤ Length ĤΥȥ󥰤Ӥ롣
 * S1 = S2 ʤ 0, S1 > S2 ʤS1 < S2 ʤ֤ͤ
 *
 * ARGUMENT : S1     ::= ȥؤΥݥ ڡ
 *            S2     ::= ȥؤΥݥ ꥭ
 *            Posi1  ::= S1ΥȰ֡
 *            Posi2  ::= S2ΥȰ֡
 *            Length ::= ӤĹ ǼĹ
 *
 *---------------------------------------------------------------
 */

static int 
compare_str(char *S1, char *S2, int Posi1, int Posi2, int HouseLen)
{
    int  Ret = 0;
    int  KeyLen = 0;


    Ret = strncmp(&S1[Posi1], &S2[Posi2], HouseLen); 
    if(Ret == 0){
	KeyLen = strlen(S2);
	if(KeyLen == HouseLen)  /* ꥭͤȳǼͤƱ */
	    Ret == 0;
	else 
	    Ret = -1;           /* ꥭͤΤۤ     */
    }
    return Ret;
}






