#include <sys/types.h>
#define _SIZE_T
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <dirent.h>
#include <memory.h>

#include "pmhead.h"

/**********************************************************
 *
 * module name : ls_c()
 *
 * input :
 *
 * output :
 *
 **********************************************************/
void ls_c(buf)
char *buf;
	{
	char wbuf[80],dirbuf[BUF_MAX],dbbuf[BUF_MAX];
	char *dir,*wp;
	int ret;
	unsigned int strcnt = 0,dircnt = 0,filecnt = 0;

	DIR *dirp,*wdirp;
	struct dirent *dp;

	/*** buffer clear ***/
	dirbuf[0] = NULL;
	dbbuf[0] = NULL;

	/*** parameter set *************************************/
	if((ret = pm_sep_prm(buf,prm_buf)) != 1)
	    {
	    strcpy(wr_data,"{result_ls,{abnormal,\"invalid prm\"},\'&void\',\'&void\',done}");
/*	    write(sn,wr_data,strlen(wr_data)); */
	    return;
	    }
	dir = prm_buf;
	/*** execute *******************************************/
	/*** change directory ***/
	pm_mkdir_name(dir,wbuf);
	if( (ret = opr_cd(wbuf)) == -1 )
	    {
	    strcpy(wr_data,"{result_ls,{abnormal,\"dir not found\"},\'&void\',\'&void\',done}");
/*	    write(sn,wr_data,strlen(wr_data)); */
	    return;
	    }

	/*** get directory stream ***/
	dirp = opendir(".");
	while((dp = readdir(dirp)) != NULL)
	    {
	    strncpy(wbuf,dp->d_name,sizeof(wbuf));

	    if((wdirp = opendir(wbuf)) == NULL)
		continue;
	    else
		closedir(wdirp);

	    if(check_dbname(wbuf))
		{
		filecnt++;
		wbuf[strlen(wbuf)-3] = NULL;
		sprintf(dbbuf+strlen(dbbuf),"\"%s\",",wbuf);
		}
	    else
		{
		dircnt++;
		sprintf(dirbuf+strlen(dirbuf),"\"%s\",",wbuf);
		}
	    }
	closedir(dirp);

	/*** set response ***/
	if( filecnt != 0 )
		dbbuf[strlen(dbbuf)-1] = NULL;
	if( dircnt != 0 )
		dirbuf[strlen(dirbuf)-1] = NULL;

	sprintf(wr_data,"{result_ls,normal,[%s],[%s],done}",dirbuf,dbbuf);

	/*** write response ***/
/*	write(sn,wr_data,strlen(wr_data)); */
  
	/*** change directory ***/
	opr_cd(cur_dir);
	}

static check_dbname(b)
char *b;
	{
	register i;

	if((i = strlen(b) - 3) > 0)
		{
		if(strcmp(&b[i],".db") == NULL)
			return(1);
		}
	return(0);
	}

/**********************************************************
 *
 * module name : ls_l_c()
 *
 * input :
 *
 * output :
 *
 **********************************************************/

/*** option element status definition ***/
#define  STAT_L   1
#define  STAT_F   2
#define  STAT_N   4
#define  STAT_LN  5
#define  STAT_FN  6
#define  STAT_S   8

void ls_l_c(buf)
char *buf;
	{
	char wbuf[80],options[80],dirbuf[BUF_MAX],dbbuf[BUF_MAX];
	char *dir,*wp,*filterinfo;
	int ret,option;
	unsigned int strcnt = 0,dircnt = 0,filecnt = 0;

	DIR *dirp,*wdirp;
	struct dirent *dp;

	/*** buffer clear ***/
	dirbuf[0] = NULL;
	dbbuf[0] = NULL;
	/*** parameter set *************************************/
	if((ret = pm_sep_prm(buf,prm_buf)) != 2)
	    {
	    strcpy(wr_data,"{result_ls_l,{abnormal,\"invalid prm\"},\'&void\',\'&void\',done}");
/*	    write(sn,wr_data,strlen(wr_data)); */
	    return;
	    }

	dir = prm_buf;
	/*** execute *******************************************/
	/*** change directory ***/
	pm_mkdir_name(dir,wbuf);
	if( (ret = opr_cd(wbuf)) == -1 )
	    {
	    strcpy(wr_data,"{result_ls_l,{abnormal,\"dir not found\"},\'&void\',\'&void\',done}");
/*	    write(sn,wr_data,strlen(wr_data)); */
	    return;
	    }

        filterinfo=prm_buf+strlen(dir)+1;
        if((ret=pm_sep_prm(filterinfo+1,options))!=2)
	    {
	    strcpy(wr_data,"{result_ls_l,{abnormal,\"invalid filter info\"},\'&void\',\'&void\',done}");
/*	    write(sn,wr_data,strlen(wr_data)); */
	    return;
	    }
        option=get_option(options);
	/*** get directory stream ***/
	dirp = opendir(".");
	while((dp = readdir(dirp)) != NULL)
	    {
	    strncpy(wbuf,dp->d_name,sizeof(wbuf));

	    if((wdirp = opendir(wbuf)) == NULL)
		continue;
	    else
		closedir(wdirp);

	    if(check_dbname(wbuf))
		{
                opr_cd(wbuf);
		filecnt++;
		wbuf[strlen(wbuf)-3] = NULL;
		sprintf(dbbuf+strlen(dbbuf),"{\"%s\",[",wbuf);
		pversion(dbbuf+strlen(dbbuf),option);
		strcat(dbbuf,"]},");
		opr_cd("..");
		}
	    else
		{
		dircnt++;
		sprintf(dirbuf+strlen(dirbuf),"\"%s\",",wbuf);
		}
	  }
	closedir(dirp);

	/*** set response ***/
	if( filecnt != 0 )
		dbbuf[strlen(dbbuf)-1] = NULL;
	if( dircnt != 0 )
		dirbuf[strlen(dirbuf)-1] = NULL;

	sprintf(wr_data,"{result_ls_l,normal,[%s],[%s],done}",dirbuf,dbbuf);

	/*** write response ***/
/*	write(sn,wr_data,strlen(wr_data)); */
  
	/*** change directory ***/
	opr_cd(cur_dir);
	}

static pversion(b,option)
char *b;
int option;
	{
	FILE *fp,*fpx;
	char buf[16],buf2[20],dbinfo[256],dbinfo2[256],*dbinfop;
	fp = fopen("cntrl","r");
	fgets(buf,sizeof(buf),fp);
	switch(option){
	case STAT_L :
        case STAT_F:
	case STAT_S:

	while(fgets(buf,sizeof(buf),fp))
		{
		if(buf[0] == 'd') continue;
		buf[strlen(buf)-1] = NULL;
 		strcat(b,"{");     
		strcat(b,buf+1);
               switch(option){
	       case STAT_L :
		break;
	      case STAT_F:
	      case STAT_S:
        sprintf(buf2,"%s.cntrl",buf+1);
	fpx = fopen(buf2,"r");
	fgets(dbinfo,sizeof(dbinfo),fpx);
	fgets(buf2,sizeof(buf2),fpx);
        fclose(fpx);
	if(dbinfo[0]!='{')
	  strcpy(dbinfo,"\{&void\,&void\,&void\,&void\,&void\}");
        else{
	        dbinfo[strlen(dbinfo)-1]=0;
	       }
	pm_sep_prm2(dbinfo+1,dbinfo2);
	strcat(b,",");
	strcat(b,dbinfo2);/**  Tag ***/
	strcat(b,",");
	dbinfop=dbinfo2+strlen(dbinfo2)+1;
	strcat(b,dbinfop);/**  Program name ***/
	strcat(b,",");
	dbinfop=dbinfop+strlen(dbinfop)+1;
       	strcat(b,dbinfop);/**  Auther ***/
	strcat(b,",");
	dbinfop=dbinfop+strlen(dbinfop)+1;
	strcat(b,dbinfop);        /**  Date ***/
        strcat(b,",");
        buf2[strlen(buf2)-1]=0;
	strcat(b,buf2);
        strcat(b,",");
	dbinfop=dbinfop+strlen(dbinfop)+1;
	strcat(b,dbinfop);        /** Include ***/
	      }
		strcat(b,",[");
		prevision(b+strlen(b),buf+1,option);
		strcat(b,"]},");
	      }
	break;

        case STAT_LN:
	case STAT_N:
	case STAT_FN:

	while(fgets(buf2,sizeof(buf2),fp))
		{
		if(buf2[0] == 'd') continue;
                strcpy(buf,buf2);
	      }
		buf[strlen(buf)-1] = NULL;
 		strcat(b,"{");     
		strcat(b,buf+1);
               switch(option){
               case STAT_LN:
		break;
	      case STAT_N:
	      case STAT_FN:
        sprintf(buf2,"%s.cntrl",buf+1);
	fpx = fopen(buf2,"r");
	fgets(dbinfo,sizeof(dbinfo),fpx);
	fgets(buf2,sizeof(buf2),fpx);
        fclose(fpx);
	if(dbinfo[0]!='{')
	  strcpy(dbinfo,"{&void\,&void\,&void\,&void\,&void}");
        else{
	        dbinfo[strlen(dbinfo)-1]=0;
	       }
	pm_sep_prm2(dbinfo+1,dbinfo2);
	strcat(b,",");
	strcat(b,dbinfo2);/**  Tag ***/
	strcat(b,",");
	dbinfop=dbinfo2+strlen(dbinfo2)+1;
	strcat(b,dbinfop);/**  Program name ***/
	strcat(b,",");
	dbinfop=dbinfop+strlen(dbinfop)+1;
       	strcat(b,dbinfop);/**  Auther ***/
	strcat(b,",");
	dbinfop=dbinfop+strlen(dbinfop)+1;
	strcat(b,dbinfop);        /**  Date ***/
        strcat(b,",");
        buf2[strlen(buf2)-1]=0;
	strcat(b,buf2);
        strcat(b,",");
	dbinfop=dbinfop+strlen(dbinfop)+1;
	strcat(b,dbinfop);        /** Include ***/
	      }
		strcat(b,",[");
		prevision(b+strlen(b),buf+1,option);
		strcat(b,"]},");
        break;
      }
	if(b[0] != NULL)
		b[strlen(b)-1] = NULL;
	fclose(fp);
	}

static prevision(b,v,option)
char *b,*v;
int option;
	{
	FILE *fp;
	char buf[64];
	char buf2[64];

	sprintf(buf,"%s.cntrl",v);
	fp = fopen(buf,"r");
	fgets(buf,sizeof(buf),fp);
	fgets(buf,sizeof(buf),fp);
	fgets(buf,sizeof(buf),fp);
	fgets(buf,sizeof(buf),fp);
	fgets(buf2,sizeof(buf2),fp);
	buf[strlen(buf)-1] = NULL;
	buf2[strlen(buf2)-1] = NULL;
		switch(option){
		case STAT_L:
		case STAT_LN:
	        	strcat(b,"[");/** add 94/5/10  by M.gouda **/
			strcat(b,buf);/** add 94/5/10  by M.gouda **/
			strcat(b,"]");/** add 94/5/10  by M.gouda **/
			break;
		default:
         		strcat(b,"{");
                        strcat(b,"[");/** add 94/6/2  by M.gouda **/
         		strcat(b,buf);/** add 94/6/2  by M.gouda **/
		        strcat(b,"],");/** add 94/6/2  by M.gouda **/
         		strcat(b,buf2);/** add 94/6/2  by M.gouda **/
		        strcat(b,"}");/** add 94/6/2  by M.gouda **/
		      }
	while(fgets(buf,sizeof(buf),fp))
		{
		buf[strlen(buf)-1] = NULL;
		fgets(buf2,sizeof(buf2),fp);	
		buf2[strlen(buf2)-1] = NULL;
		switch(option){
		case STAT_L:
		case STAT_LN:
            		strcat(b,",[");/** add 94/5/10  by M.gouda **/
         		strcat(b,buf);/** add 94/5/10  by M.gouda **/
		        strcat(b,"]");/** add 94/5/10  by M.gouda **/
		        break;
		default:
         		strcat(b,",{");
                        strcat(b,"[");/** add 94/5/10  by M.gouda **/
         		strcat(b,buf);/** add 94/5/10  by M.gouda **/
		        strcat(b,"],");/** add 94/5/10  by M.gouda **/
         		strcat(b,buf2);/** add 94/5/10  by M.gouda **/
		        strcat(b,"}");/** add 94/5/10  by M.gouda **/
		        break;
		      }
		}

	fclose(fp);
	}

/**********************************************************
 *
 * module name : mkdir_c()
 *
 * input :
 *
 * output :
 *
 **********************************************************/

void mkdir_c(buf)
char *buf;
	{
	char *wp,wbuf[80];
	char *dir,*mkdir;
	int ret;

	wbuf[0] = NULL;		/* buffer clear */

	/*** parameter set, check count of parameters ***/
  	if((ret = pm_sep_prm(buf,prm_buf)) != 2)
		{
    		strcpy(wr_data,
		       "{result_mkdir,{abnormal,\"invalid prm\"},done}");
/*    		write(sn,wr_data,strlen(wr_data)); */
    		return;
  		}

	dir = prm_buf;				/* current dir name */
	mkdir = prm_buf + strlen(dir) + 1;      /* new dir name */

	/*** change directory ***/
	pm_mkdir_name(dir,wbuf);
  	if((ret = opr_cd(wbuf)) == -1)
		{
    		strcpy(wr_data,
		       "{result_mkdir,{abnormal,\"dir not found\"},done}");
/*    		write(sn,wr_data,strlen(wr_data)); */
    		return;
  		}

  	/*** make command string ***/
  	sprintf(wbuf,"mkdir %s",mkdir);

  	/*** execute "mkdir" command ***/
  	if((opr_cmnd(wbuf)) < 0)
		{
    		strcpy(wr_data,
		       "{result_mkdir,normal,{abnormal,\"dir exists\"}}");
		}
	else
    		strcpy(wr_data,"{result_mkdir,normal,done}");

  	/*** write response to pm_client ***/
/*  	write(sn,wr_data,strlen(wr_data)); */
  
  	/*** change directory ***/
  	opr_cd(cur_dir);
	}

/**********************************************************
 *
 * module name : rmdir_c()
 *
 * input :
 *
 * output :
 *
 **********************************************************/

void rmdir_c(buf)
char *buf;
	{
	char *wp,wbuf[80];
	char *dir,*rmdir;
	int ret;

	wbuf[0] = NULL;		/* buffer clear */

	/*** parameter set, check count of parameters ***/
  	if((ret = pm_sep_prm(buf,prm_buf)) != 2)
		{
    		strcpy(wr_data,
		       "{result_rmdir,{abnormal,\"invalid prm\"},done}");
/*    		write(sn,wr_data,strlen(wr_data)); */
    		return;
  		}

	dir = prm_buf;				/* current dir name */
	rmdir = prm_buf + strlen(dir) + 1;      /* dir name */

	/*** change directory ***/

	pm_mkdir_name(dir,wbuf);

  	if((ret = opr_cd(wbuf)) == -1)
		{
    		strcpy(wr_data,
		       "{result_rmdir,{abnormal,\"dir not found\"},done}");
/*    		write(sn,wr_data,strlen(wr_data)); */
    		return;
  		}

	/*** change directory for check ***/
  	if((ret = opr_cd(rmdir)) == -1)
		{
    		strcpy(wr_data,
		       "{result_rmdir,{abnormal,\"dir not found\"},done}");
/*    		write(sn,wr_data,strlen(wr_data)); */
    		return;
  		}
	opr_cd(cur_dir);
	opr_cd(wbuf);
	/*** execute "rmdir" command ***/
  	sprintf(wbuf,"rmdir %s",rmdir);
  	if((ret = opr_cmnd(wbuf)) == -1)   /** update M.gouda **/
		{
    		strcpy(wr_data,
		       "{result_rmdir,{abnormal,\"sub-dir or DB exist\"},done}");

       	/*** change directory ***/
	 opr_cd(cur_dir);
/*    		write(sn,wr_data,strlen(wr_data)); */
    		return;
  		} 

	/*** response ***/
	strcpy(wr_data,"{result_rmdir,normal,done}");
/*	write(sn,wr_data,strlen(wr_data)); */
  
	/*** change directory ***/
	opr_cd(cur_dir);
	}

/**********************************************************
 *
 * module name : rm_c()
 *
 * input :
 *
 * output :
 *
 **********************************************************/
void rm_c(buf)
char *buf;
	{
	char *dir;
	char *DB_name;
	char *VerNO;
	char *RevNO,RevNOx[80];
	long int RevisionNo;
	FILE *fp,*fpx;
	char wbuf[80],xbuf[80];
	char *wp;
	char temp[L_tmpnam];
	int i;

	/*** parameter set *************************************/
	if( pm_sep_prm(buf,prm_buf) != 3 )
	    {
	    strcpy(wr_data,"{result_rm,{abnormal,\"invalid prm\"},done}");
/*	    write(sn,wr_data,strlen(wr_data)); */
	    return;
	    }

	dir = prm_buf;				/* get dir */
	DB_name = (dir+strlen(dir))+1;		/* get DB_name */
	wp = (DB_name+strlen(DB_name))+1;
	VerNO = opr_search_vstart(wp,0);	/* get VerNO */
	wp = opr_search_comma(VerNO,0);
	wp[-1] = NULL;
	RevNO = wp;				/* get RevNO */
	RevNO[-1] = NULL;

	/*** execute *******************************************/
	/*** change directory ***/
	pm_mkdir_name(dir,wbuf);
	if( opr_cd(wbuf) == -1 )
	    {
	    strcpy(wr_data,"{result_rm,");
 	    strcat(wr_data,"{abnormal,\"dir not found\"},");
 	    strcat(wr_data,"done}");
/*	    write(sn,wr_data,strlen(wr_data)); */
	    opr_cd(cur_dir);
	    return;
	    }

	/*** cd 'DB_name.db' ***/
	sprintf(wbuf,"%s.db",DB_name);
	if( opr_cd(wbuf) == -1 )
	    {
	    strcpy(wr_data,"{result_rm,");
 	    strcat(wr_data,"{abnormal,\"DB not found\"},");
 	    strcat(wr_data,"done}");
/*	    write(sn,wr_data,strlen(wr_data)); */
	    opr_cd(cur_dir);
	    return;
	    }
	    sprintf(wbuf,"%s.cntrl",VerNO);
        if(pm_check_file_exist(wbuf)==-1)       /* add 94.04.28 by M.gouda */
	    {
	    strcpy(wr_data,"{result_rm,");
 	    strcat(wr_data,"{abnormal,\"DB version not found\"},");
 	    strcat(wr_data,"done}");
	    opr_cd(cur_dir);
	    return;
	    }

	if( !strcmp(RevNO,"\'&void\'") )
	    {				/*** update 'VerNO.cntrl' ***/
	    tmpnam(temp);
	    sprintf(wbuf,"mv %s.cntrl %s",VerNO,temp);
	    opr_cmnd(wbuf);
	    sprintf(wbuf,"%s.cntrl",VerNO);
	    fp = fopen(wbuf,"w");
	    fpx = fopen(temp,"r");

	    fgets(wbuf,sizeof(wbuf),fpx);
	    fputs(wbuf,fp);
	    fgets(wbuf,sizeof(wbuf),fpx);
	    fputs(wbuf,fp);
	    fgets(wbuf,sizeof(wbuf),fpx);
	    fputs(wbuf,fp);

	    fclose(fp);
	    fclose(fpx);
	    unlink(temp);

	    sprintf(wbuf,"rm -f %s_*.src",VerNO); /*update 94.4.28 by M.gouda*/
	    opr_cmnd(wbuf);
	    sprintf(wbuf,"rm -f %s_*.obj",VerNO);/*update 94.4.28 by M.gouda*/
	    opr_cmnd(wbuf);
	    }
	else
	    {
	    tmpnam(temp);
	    sprintf(wbuf,"mv %s.cntrl %s",VerNO,temp);
	    opr_cmnd(wbuf);
	    sprintf(wbuf,"%s.cntrl",VerNO);
	    fp = fopen(wbuf,"w");
	    fpx = fopen(temp,"r");

	    fgets(wbuf,sizeof(wbuf),fpx);
	    fputs(wbuf,fp);
	    fgets(wbuf,sizeof(wbuf),fpx);
	    fputs(wbuf,fp);
	    fgets(wbuf,sizeof(wbuf),fpx);
	    fputs(wbuf,fp);

	    pm_rep_rev(RevNO,RevNOx);
	    while(fgets(wbuf,sizeof(wbuf),fpx))
		{
		if(strncmp(wbuf,RevNOx,strlen(RevNOx)) == 0)
			{
			wbuf[strlen(wbuf)-1] = NULL;
			RevisionNo = 0;
			for(i=0;wbuf[i] != NULL;i++)
				{
				if(wbuf[i] == ',')
					RevisionNo <<= 4;
				else
					RevisionNo += wbuf[i] & 0x0f;
				}
			sprintf(xbuf,"rm -f %s_%ld.*",VerNO,RevisionNo);
			opr_cmnd(xbuf);
			}
		else
			{
			fputs(wbuf,fp);
			}
		}

	    fclose(fp);
	    fclose(fpx);
	    unlink(temp);
	    }

	/*** response ***/
	strcpy(wr_data,"{result_rm,normal,done}");
/*	write(sn,wr_data,strlen(wr_data)); */
  
	/*** change directory ***/
	opr_cd(cur_dir);
	}

/**********************************************************
 *
 * module name : rm_all_c()
 *
 * input :
 *
 * output :
 *
 **********************************************************/

void rm_all_c(buf)
char *buf;
	{
	char *dir;
	char *DB_name;
	char *VerNO;
	FILE *fp,*fpx;
	char wbuf[80],xbuf[80];
	char *wp;
	char temp[L_tmpnam];

	/*** parameter set *************************************/
	if( pm_sep_prm(buf,prm_buf) != 3 )
	    {
	    strcpy(wr_data,"{result_rm_all,{abnormal,\"invalid prm\"},done}");
/*	    write(sn,wr_data,strlen(wr_data)); */
	    return;
	    }

	dir = prm_buf;				/* get dir */
	DB_name = (dir+strlen(dir)+1);		/* get DB_name */
	VerNO = (DB_name+strlen(DB_name)+1);	/* get VerNO */
  
	/*** execute *******************************************/
	/*** change directory ***/
	pm_mkdir_name(dir,wbuf);
	if( opr_cd(wbuf) == -1 )
	    {
	    strcpy(wr_data,"{result_rm_all,");
 	    strcat(wr_data,"{abnormal,\"dir not found\"},");
 	    strcat(wr_data,"done}");
/*	    write(sn,wr_data,strlen(wr_data)); */
            opr_cd(cur_dir);
	    return;
	    }

	if( !strcmp(VerNO,"\'&void\'") )
	    {				/* delete all DBname file */
	    sprintf(wbuf,"rm -r %s.db",DB_name);
	    opr_cmnd(wbuf);
	    }
	else
	    {
	    sprintf(wbuf,"%s.db",DB_name);
	if( opr_cd(wbuf) == -1 )
	    {
	    strcpy(wr_data,"{result_rm_all,");
 	    strcat(wr_data,"{abnormal,\"db not found\"},");
 	    strcat(wr_data,"done}");
/*	    write(sn,wr_data,strlen(wr_data)); */
            opr_cd(cur_dir);
	    return;
	    }

	    /*** update cntrl ***/
	    tmpnam(temp);
	    sprintf(wbuf,"mv cntrl %s",temp);
	    opr_cmnd(wbuf);
	    fp = fopen("cntrl","w");
	    fpx = fopen(temp,"r");

	    fgets(wbuf,sizeof(wbuf),fpx);
	    fputs(wbuf,fp);

	    while(fgets(wbuf,sizeof(wbuf),fpx))
		{
		if(strncmp(wbuf+1,VerNO,strlen(wbuf)-2) == 0)
			{
			fprintf(fp,"d%s\n",VerNO);
			}
		else
			{
			fputs(wbuf,fp);
			}
		}
	    fclose(fp);
	    fclose(fpx);
	    unlink(temp);

/*	    sprintf(wbuf,"rm -f %s*",VerNO); */
	    sprintf(wbuf,"rm -f %s.* %s_*",VerNO,VerNO); 
	    opr_cmnd(wbuf);
	    }

	/*** response ***/
	strcpy(wr_data,"{result_rm_all,normal,done}");
/*	write(sn,wr_data,strlen(wr_data)); */
  
	/*** change directory ***/
	opr_cd(cur_dir);
	}

/**********************************************************
 *
 * module name : check_c()
 *
 * input :
 *
 * output :
 *
 **********************************************************/

void check_c(buf)
char *buf;
	{
        char *wp, wbuf[80];
  	char *dir;
  	int ret;

	/*** parameter set *************************************/
  	if((ret = pm_sep_prm(buf,prm_buf)) != 1)
		{
    		strcpy(wr_data,
		       "{result_check,{abnormal,\"invalid prm\"},done}");
/*    		write(sn,wr_data,strlen(wr_data)); */
    		return;
  		}

  	dir = prm_buf;                           /* get dir */

	/*** change directory ***/
  	pm_mkdir_name(dir,wbuf);
  	if((ret = opr_cd(wbuf)) == -1)
		{
    		strcpy(wr_data,
		       "{result_check,{abnormal,\"dir not found\"},done}");
/*    		write(sn,wr_data,strlen(wr_data)); */
    		return;
  		}

  	/*** response ***/
  	strcpy(wr_data,"{result_check,normal,done}");
/*  	write(sn,wr_data,strlen(wr_data)); */
  
  	/*** change directory ***/
  	opr_cd(cur_dir);
	}

/**********************************************************
 *
 * module name : purge_c()
 *
 * input :
 *
 * output :
 *
 **********************************************************/

void purge_c(buf)
char *buf;
	{
	char *dir;
	char *DB_name;
	FILE *fp,*fpx;
	char wbuf[80],xbuf[80];
	char *wp;
	int lc = 0,lcx = 0;
	char temp[L_tmpnam];

	/*** parameter set *************************************/
	if(pm_sep_prm(buf,prm_buf) != 2)
		{
		strcpy(wr_data,"{result_purge,");
		strcat(wr_data,"{abnormal,\"invalid prm\"},");
		strcat(wr_data,"done}");
/*		write(sn,wr_data,strlen(wr_data)); */
		return;
		}

	dir = prm_buf;                           /* get dir */
	DB_name = (dir+strlen(dir)+1);           /* get DB_name */
  
	/*** execute *******************************************/
	/*** change directory ***/
	pm_mkdir_name(dir,wbuf);
	if( opr_cd(wbuf) == -1 )
		{
		strcpy(wr_data,"{result_purge,");
		strcat(wr_data,"{abnormal,\"dir not found\"},");
		strcat(wr_data,"done}");
/*		write(sn,wr_data,strlen(wr_data)); */
		return;
		}

	/*** cd ".db" ***/
	sprintf(wbuf,"%s.db",DB_name);
	if( opr_cd(wbuf) == -1 )
		{
		strcpy(wr_data,"{result_purge,");
		strcat(wr_data,"{abnormal,\"db not found\"},");
		strcat(wr_data,"done}");
/*		write(sn,wr_data,strlen(wr_data)); */
		opr_cd(cur_dir);
		return;
		}

	/*** read cntrl ***/
	if((fp = fopen("cntrl","r")) == NULL)
		{
		strcpy(wr_data,"{result_purge,");
		strcat(wr_data,"{abnormal,\"db not found\"},");
		strcat(wr_data,"done}");
/*		write(sn,wr_data,strlen(wr_data)); */
		opr_cd(cur_dir);
		return;
		}

	/*** get latest version number ***/
	fgets(wbuf,sizeof(wbuf),fp);lc++;	/* skip 1 line */
	while(fgets(wbuf,sizeof(wbuf),fp))
		{
		lc++;
		if(wbuf[0] == ' ')
			{
			lcx = lc;
			}
		}	
	fclose(fp);

	/*** execute "purge" , update cntrl ***/
	tmpnam(temp);
	sprintf(wbuf,"mv cntrl %s",temp);
	opr_cmnd(wbuf);
	fp = fopen("cntrl","w");
	fpx = fopen(temp,"r");
	lc = 0;

	fgets(wbuf,sizeof(wbuf),fpx);lc++;
	fputs(wbuf,fp);

	while(fgets(wbuf,sizeof(wbuf),fpx))
		{
		if(++lc == lcx)
			{
			fputs(wbuf,fp);
			break;
			}
		if(wbuf[0] == ' ')
			{
			wbuf[strlen(wbuf)-1] = NULL;
			sprintf(xbuf,"rm -f %s_* %s.*",wbuf+1,wbuf+1);
			opr_cmnd(xbuf);
			}
		}
	fclose(fp);
	fclose(fpx);
	unlink(temp);

	/*** response ***/
	strcpy(wr_data,"{result_purge,normal,done}");
/*	write(sn,wr_data,strlen(wr_data)); */
  
	/*** change directory ***/
	opr_cd(cur_dir);
	}


get_option(options)
char *options;
{
  int coption,c,i;
  coption=-1;
  for(i=0;(c=options[i])!=NULL;i++)
    {
     switch(c){

     case 'l':
       switch(coption){
       
       case STAT_L:
       case STAT_F:
       case STAT_LN:
       case STAT_FN:
       case STAT_S:
            break;
       case STAT_N:
	    coption=STAT_LN;
            break;
       default:
	    coption=STAT_L;
	    break;
	  }
              break;
     case 'n':
       switch(coption){
       case STAT_L:
	    coption=STAT_LN;
            break;
       case STAT_F:
	    coption=STAT_FN;
            break;
       case STAT_N:
       case STAT_LN:
       case STAT_FN:
       case STAT_S:
            break;
       default:
	    coption=STAT_N;
	  }
              break;
     case 'f':
       switch(coption){
       case STAT_L:
	    coption=STAT_F;
            break;
       case STAT_N:
	    coption=STAT_FN;
            break;
       case STAT_LN:
	    coption=STAT_FN;
            break;
       case STAT_F:
       case STAT_FN:
       case STAT_S:
            break;
       default:
	    coption=STAT_F;
	    break;
	  }
              break;
     case 's':
       coption=STAT_S;
       break;
     default:
              break;
     }
   }
  return (coption);
}

