;;
;; server  session commands
;;

(defvar qxt-using-pim/m nil)
;;
;; create_database
;;	C: create_database(DatabaseName, ProgramText, Program)
;;		DatabaseName = Atom
;;		ProgramText = [String, ...]
;;		Program = Program form of SRC
;;
(defun qxt-create-database (start end database-name)
  "Start$B$H(BEnd$B$N%j!<%8%g%s$NFbMF$G(BDatabaseName$B$N%G!<%?%Y!<%9$N@8@.$rAw?.$9$k!#(B
Start = Integer (Position of region start)
End   = Integer (Position of region end)
DatabaseName = String
"
  (interactive "r\nsDatabase Name: ")
  (if qxt-using-pim/m
      (qxt-create-database-pim/m start end database-name)
    (qxt-create-database-orig start end database-name)))

(defun qxt-create-database-orig (start end database-name)
  (setq database-name (qxt-term2lisp database-name))
  (let* ((text (buffer-substring start end))
	 program-text program)
    (qxt-check-status 'server)
    (let ((index 0)
	  (len  (length text))
	  line)
      (while (and (< index len)
		  (string-match "\n" text index))
	(setq line (substring text index (match-beginning 0)))
	(setq program-text (cons line program-text))
	(setq index (match-end 0)))
      (setq program-text (reverse program-text))
      (condition-case err
	  (setq program 
		(if qxt-qmacs-i-mode
		    (qxt-qxt2src-I text)
		  (qxt-qxt2src-D text)))
	(syntax (goto-char start)
		(forward-char qxt-lex-pos)
		(error (car (cdr err))))
	(lexical (goto-char start)
		 (forward-char (1- qxt-lex-pos))
		 (error (car (cdr err)))))
      (qxt-timer-start)
      (qxt-send-command
       (qxt-lisp2term-string
	(vector 'create_database database-name program-text program))))))

(defun qxt-create-database-pim/m (start end database-name)
  (setq database-name (qxt-term2lisp database-name))
  (let* ((text (buffer-substring start end))
	 program-text program)
    (qxt-check-status 'server)
    (condition-case err
	(setq program 
	      (if qxt-qmacs-i-mode
		  (qxt-qxt2src-I text)
		(qxt-qxt2src-D text)))
      (syntax (goto-char start)
	      (forward-char qxt-lex-pos)
	      (error (car (cdr err))))
      (lexical (goto-char start)
	       (forward-char (1- qxt-lex-pos))
	       (error (car (cdr err)))))
    (qxt-timer-start)
    (qxt-send-crd)
    (qxt-send-term database-name)
    (qxt-check-result "dbname")
    (qxt-send-term (aref program 1))
    (qxt-check-result "env")
    (qxt-send-term (aref program 2))
    (qxt-check-result "exp")
    (qxt-send-term (aref program 3))
    (qxt-check-result "obj")
    (qxt-send-term (aref program 4))
    (qxt-check-result "mod")
    (qxt-send-term (aref program 5))
    (qxt-check-result "link")
    (qxt-send-term (aref program 6))
    (qxt-check-result "rule")
    (let ((index 0)
	  (len  (length text))
	  line)
      (while (and (< index len)
		  (string-match "\n" text index))
	(setq line (substring text index (match-beginning 0)))
	(setq program-text (cons line program-text))
	(setq index (match-end 0)))
      (setq program-text (reverse program-text)))
    (qxt-send-term program-text)
    (qxt-check-result "program text")
    (qxt-expect-result)
    ;;
    (if qxt-synchronous
	(while qxt-client-state
	  (accept-process-output qxt-process)))))

(defun qxt-create-database-string (string &optional database-name)
  "STRING $B$NFbMF$G(BDatabaseName$B$N%G!<%?%Y!<%9$N@8@.$rAw?.$9$k!#(B
DatabaseName = String
"
  (interactive "Database: s\nsDatabase Name: ")
  (if (null database-name)
      (setq database-name (read-string "Database Name: ")))
  (let* ((text string)
	 program-text program)
    (qxt-check-status 'server)
    (let ((index 0)
	  (len  (length text))
	  line)
      (while (and (< index len)
		  (string-match "\n" text index))
	(setq line (substring text index (match-beginning 0)))
	(setq program-text (cons line program-text))
	(setq index (match-end 0)))
      (setq program-text (reverse program-text))
      (condition-case err
	  (setq program 
		(if qxt-qmacs-i-mode
		    (qxt-qxt2src-I text)
		  (qxt-qxt2src-D text)))
	(syntax (goto-char start)
		(forward-char qxt-lex-pos)
		(error (car (cdr err))))
	(lexical (goto-char start)
		 (forward-char (1- qxt-lex-pos))
		 (error (car (cdr err)))))
      (qxt-timer-start)
      (qxt-send-command
       (qxt-lisp2term-string
	(vector 'create_database (intern database-name) program-text program))))))

(defun qxt-create-database-file (FileName DatabaseName)
  "FileName$B$N%U%!%$%k$NFbMF$G(BDatabseName$B$N%G!<%?%Y!<%9$N@8@.$rAw?.$9$k!#(B
FileName = String
DatabaseName = String
"
  (interactive "fFileName: \nsDatabaseName: ")
  (save-excursion
    (find-file FileName)
    (qxt-create-database (point-min) (point-max) DatabaseName)))

;;
(defun qxt-qxt2src-D (text)
  "Quixote $B%Q!<%5!<$r5/F0$9$k%(%s%H%j4X?t$G$"$k!#(B
qxt-create-database$B$+$i8F$P$l$k!#(B
Emacs lisp$B$G(Btext$B$N9=J82r@O$r9T$J$&!#(B
text = String of quixote syntax
"
  (progn
    (setq qxt-input-string text)
    (setq qxt-input-string-len (length text))
    (setq qxt-lex-pos 0)
    (setq qxt-line-no 1)
    (advance)
    (program)))

;;
(defun qxt-qxt2src-I (text)
  "Quixote $B%Q!<%5!<$r5/F0$9$k%(%s%H%j4X?t$G$"$k!#(B
qxt-create-database$B$+$i8F$P$l$k!#(B
C$B$G=q$+$l$?%Q!<%5!<$r5/F0$7!"(Btext$B$N9=J82r@O$r9T$J$&!#(B
text = String of quixote syntax
"
  (let (Buffer)
    (setq Buffer (get-buffer-create "*work*"))
    (save-excursion
      (set-buffer Buffer)
      (erase-buffer)
      (insert text)
      (call-process-region (point-min) (point-max) "qxt2src" t t nil)
      (beginning-of-buffer)
      (if (looking-at "syntax error")
	  (error (buffer-substring (point-min) (point-max)))
	(read Buffer)))))

;;
;;	S: result_create_database(Status, Release)
;;		Release = {Version, Revision}
;;		Version = Interger
;;		Revision = [Integer, ...]
;;
(defun qxt-result-create-database(Result)
  "$B%G!<%?%Y!<%9$r@8@.$9$k%3%^%s%I$N<B9T7k2L$r<u?.$7$?8e$N=hM}$r9T$J$&!#(B"
  (let ((Release (aref Result 2)))
    (setq qxt-current-session 'database)
    (qxt-timer-end)
    (insert "** created : " (qxt-release-string Release) "\n")))
;;
(defun qxt-release-string (Release)
  (let ((Version (aref Release 0))
	(Revision (aref Release 1))
	(String  ""))
    (if (and (symbolp Version)
	     (eq Version '&void) (eq Revision '&void))
	"null"
      (while Revision
	(setq String (concat String "." (car Revision)))
	(setq Revision (cdr Revision)))
      (concat Version String))))

;;
;; open_database
;;	C: open_database(DatabaseName,SpecifiedRelease,
;;                    DirectoryNames,OpenMode,FileType)
;;  		DirectoryNames = [ DirectoryName, ...]
;;  		DirecotryName = String
;;		SpecifiedRelease = {Version, SpecifiedRevision} | '&void'
;;		Version = Interger
;;		SpecifiedRevision = [Integer, ...] | '&void'
;;  		OpenMode = '&read_only' | '&exclusive'
;;                FileType  = src|obj
;;	S: result_open_database(Status)
;;
(defun qxt-open-database(DatabaseName DirectoryNames OpenMode FileType)
  "DatabaseName DirectoryNames OpenMode FileType $B$G%G!<%?%Y!<%9$N%*!<%W%s$rAw?.$9$k!#(B
DatabaseName  = String
Release       = String
DirectoryNames = List of String
OpenMode       = \"exclusive\" | \"read_only\" | \"\"
FileType       = \"src\" | \"obj\" | \"\"
"
  (interactive
   (list (read-string "DatabaseName: ")
	 (let ((DirectoryNames nil)
	       (DirectoryName (read-string "DirectoryName: ")))
	   (while (not (string= DirectoryName ""))
	     (setq DirectoryNames
		   (append DirectoryNames (list DirectoryName)))
	     (setq DirectoryName (read-string "DirectoryName: ")))
	   DirectoryNames)
	 (completing-read "OpenMode: " 
			  '( ("read_only" 1) ("exclusive" 2)) nil t )
	 (completing-read "FileType: " 
			  '( ("src" 1) ("obj" 2)) nil t )))
  (let* 
     ((AnalyzedName (qxt-analyze-database-name DatabaseName))
      (DatabaseName (car AnalyzedName))
      (Release (car (cdr AnalyzedName)))
      (DirectoryNames (qxt-lisp2term-string DirectoryNames)))
    (qxt-check-status 'server)
    (if (string= OpenMode "")
	(setq OpenMode (concat "\'&exclusive\'"))
      (setq OpenMode (concat "\'&" OpenMode "\'")))
    (if (string= FileType "")
	(setq FileType "obj"))
    (qxt-timer-start)
    (qxt-send-command
     (concat "{open_database," DatabaseName "," Release "," DirectoryNames
	   "," OpenMode "," FileType "}" ))))


(defun qxt-result-open-database (Result)
  "$B%G!<%?%Y!<%9$r%*!<%W%s$9$k%3%^%s%I$N<B9T7k2L$r<u?.8e$N=hM}$r9T$J$&!#(B"
  (qxt-timer-end)
  (setq qxt-current-session 'database))

;;
;; analyze database name
;;
(defun qxt-analyze-database-name(InputDatabaseName)
  "$B%G!<%?%Y!<%9L>$r2r@O$7!"%G!<%?%Y!<%9L>$HHGL>$NAw?.J8;zNs$KJQ49$9$k!#(B"
  (let (DatabaseName Release (pointer 0) nextpointer)
    (setq nextpointer (string-match "\\."  InputDatabaseName pointer))
    (if (eq nextpointer nil) ;; DatabaseName only
	(progn 
	  (setq DatabaseName InputDatabaseName)
	  (setq Release "'&void'")   ;; newest interface!!
	  )
      ;; get DatabaseName
      (setq DatabaseName (substring InputDatabaseName pointer nextpointer))
      ;; get version
      (setq pointer (+ 1 nextpointer))
      (setq nextpointer (string-match "\\."  InputDatabaseName pointer))
      (if (eq nextpointer nil) ;; DatabaseName and Version only
	  (progn    
	    (setq Version (substring InputDatabaseName pointer))
	    (setq Release (concat "{" Version ",'&void'}"))
	    )
	(setq Version (substring InputDatabaseName pointer nextpointer))
	;; get Revision
	(setq pointer (+ 1 nextpointer))
	(setq nextpointer (string-match "\\."  InputDatabaseName pointer))
	(setq Revision (concat  "[" (substring InputDatabaseName pointer nextpointer)))
	(while (not (eq nextpointer nil))
	  (setq pointer (+ 1 nextpointer))
	  (setq nextpointer (string-match "\\."  InputDatabaseName pointer))
	  (setq Revision
		(concat Revision "," (substring InputDatabaseName pointer nextpointer)))
	  ) ;; while end
	(setq Revision (concat Revision "," (substring InputDatabaseName pointer)  "]"))
	(setq Release (concat "{" Version "," Revision "}"))
	) ;;end of  if DatabaseName and Version only
      )  ;; end of if DatabaseName only
    ;; return value
    (list DatabaseName Release)))

;;
;; show_status
;;	C: show_status
;;
(defun qxt-show-status()
  "$B8=:_%5!<%P!<$,J];}$7$F$$$k(Bquixote$B%W%m%0%i%`$N<hF@$rAw?.$9$k!#(B"
  (interactive)
  (progn
    (qxt-check-status 'server)
    (qxt-send-command "show_status")))

;;
;;	S: result_show_status(Status, StatusInfoes)
;;		StatusInfoes = [StatusInfo, ...]
;;		StatusInfo = {DatabaseName, Release, 
;;			DirectryName, UserName, OpenMode, OpenTime}
;;		UserName =String
;;		OpenTime =String
;;
(defun qxt-result-show-status(Result)
  "$B%+%l%s%H%G%#%l%/%H%j$NJQ99$rAw?.$9$k!#(B"
  (let ((StatusInfoes (aref Result 2)))
    (insert "** Status Info **\n")
    (insert "**DatabaseName Directory User OpenMode OpenTime \n")
    (while StatusInfoes
      (let* ((StatusInfo    (car StatusInfoes))
	    (DatabaseName  (aref StatusInfo 0))
	    (Release       (aref StatusInfo 1))
	    (DirectoryName (aref StatusInfo 2))
	    (UserName      (aref StatusInfo 3))
	    (OpenMode      (aref StatusInfo 4))
	    (OpenTime      (aref StatusInfo 5)))
	(insert (symbol-name DatabaseName))
	(insert ".")
	(insert (qxt-release-string Release))
	(insert " ")
	(insert DirectoryName)
	(insert " ")
	(insert UserName)
	(insert " ")
	(insert (symbol-name OpenMode))
	(insert " ")
	(insert OpenTime)
	(newline)
	(setq StatusInfoes (cdr StatusInfoes))))))

;;
;; cd
;;	C: cd(DirectryName)
;;	S: result_cd(Status)
;;
(defun qxt-cd(DirectoryName)
  "$B%+%l%s%H%G%#%l%/%H%j$N<hF@$rAw?.$9$k!#(B"
  (interactive "sDirectoryName: ")
  (progn
    (qxt-check-status 'server)
    (qxt-send-command (concat "{cd,\"" DirectoryName "\"}" ))))

;;
;; pwd
;;	C: pwd
;;	S: result_pwd(Status, CurrentDir)
;;		CurrentDir = String
;;
(defun qxt-pwd()
  "$B%+%l%s%H%G%#%l%/%H%j$N<hF@$rAw?.$9$k!#(B"
  (interactive)
  (progn
    (qxt-check-status 'server)
    (qxt-send-command "pwd")))

;;
(defun qxt-result-pwd(Result)
  "$B%+%l%s%H%G%#%l%/%H%j$rI=<($9$k4X?t$G$"$k!#(B"
  (let ((CurrentDir (aref Result 2)))
    (insert "** Current Directory **\n")
    (insert CurrentDir "\n")))

;;
;; ls
;;	C: ls
;;	S: result_ls(Status, DirectoryNames, DatabaseNameStrings)
;;		DatabaseNameStrings = [DatabaseNameString, ...]
;;		DatabaseNameString = String
;;
(defun qxt-ls()
  "$B%+%l%s%H%G%#%l%/%H%j$NFbMF$N<hF@$rAw?.$9$k!#(B"
  (interactive)
  (progn
    (qxt-check-status 'server)
    (qxt-send-command "ls" )))

;;
(defun qxt-result-ls(Result)
  "$B%+%l%s%H%G%#%l%/%H%j$NFbMF$rI=<($9$k!#(B"
  (let ((DirectoryNames (aref Result 2))
	(DatabaseNames  (aref Result 3)))
    (insert "** Directory **\n")
    (while DirectoryNames
      (insert (car DirectoryNames))
      (newline)
      (setq DirectoryNames (cdr DirectoryNames)))
    (insert "\n** Database **\n")
    (while DatabaseNames
      (insert (car DatabaseNames))
      (newline)
      (setq DatabaseNames (cdr DatabaseNames)))))

;;
;; ls_l		if l ,  Database_name is with all version and revision
;;		if n ,  Database_name is with newest version and revision
;;	C: ls_l(Filter)
;;		Filter = {Options, Conditions}
;;		Options = [Option, ...]
;;		Option = l | n 
;;		Conditions = '&void'
;;
(defun qxt-ls-l(InputOption)
  "Option$B$D$-$G%+%l%s%H%G%#%l%/%H%j$NFbMF$N<hF@$rAw?.$9$k!#(B
Option = \"l\" | \"n\"
"
  (interactive
   (list (completing-read "Option: "  '( ("l" 1) ("n" 2) ) nil t )))
  (let* ((Option
	   (cond  ((string= InputOption "")  "[l]")
		  ((string= InputOption "l")  "[l]")
		  ((string= InputOption "n")  "[n]")))
	 (Filter (concat "{" Option ", '&void'}")))
    (qxt-check-status 'server)
    (qxt-send-command (concat "{ls_l," Filter "}"))))

;;
;;      S: result_ls_l(Status, DirectoryNames, DatabaseInfoes)
;;		DatabaseInfoes = [DatabaseInfo, ...]
;;		DatabaseInfo = {DatabaseName, [Release, ...]}
;;
(defun qxt-result-ls-l(Result)
  "$B%*%W%7%g%s$D$-$G%+%l%s%H%G%#%l%/%H%j$NFbMF$rI=<($9$k!#(B"
  (let ((DirectoryNames (aref Result 2))
	(DatabaseInfoes  (aref Result 3)))
    (insert "** Directory **\n")
    (while DirectoryNames
      (insert (car DirectoryNames))
      (newline)
      (setq DirectoryNames (cdr DirectoryNames)))
    (insert "** Database **\n")
    (while DatabaseInfoes
      (let* ((DatabaseInfo (car DatabaseInfoes))
	     (DatabaseName (aref DatabaseInfo 0))
	     (Releases     (aref DatabaseInfo 1)))
	(while Releases
	  (insert (symbol-name DatabaseName))
	  (insert ".")
	  (insert (qxt-release-string (car Releases)))
	  (setq Releases (cdr Releases))
	  (newline))
	(setq DatabaseInfoes (cdr DatabaseInfoes))))))

;;
;; mkdir
;;	C: mkdir(DirectoryName)
;;	S: result_mkdir(Status)
;;
(defun qxt-mkdir(DirectoryName)
  "DirectoryName$B$G;XDj$7$?%G%#%l%/%H%j$N:n@.$rAw?.$9$k!#(B
DeirectoryName = String
"
  (interactive "sDirectoryName: ")
  (progn
    (qxt-check-status 'server)
    (qxt-send-command (concat "{mkdir,\"" DirectoryName "\"}" ))))

;;
;; rmdir
;;	C: rmdir(DirectoryName)
;;	S: result_rmdir(Status)
;;
(defun qxt-rmdir(DirectoryName)
  "DirectoryName$B$G;XDj$7$?%G%#%l%/%H%j$N:o=|$rAw?.$9$k!#(B
DirecotryName = String
"
  (interactive "sDirectoryName: ")
  (progn
    (qxt-check-status 'server)
    (qxt-send-command (concat "{rmdir,\"" DirectoryName "\"}" )) ))

;;
;; rm
;;	C: rm(DatabaseName, SpecifiedRelease)
;;	S: result_rm(Status)
;;
(defun qxt-rm(DatabaseName)
  "DatabaseName$B$G;XDj$7$?%G!<%?%Y!<%9$N:o=|$rAw?.$9$k!#(B
DatabaseName = String
"
  (interactive "sDatabaseName: ")
  (let* ((AnalyzedName (qxt-analyze-database-name DatabaseName))
	 (DatabaseName (car AnalyzedName))
	 (Release (car (cdr AnalyzedName))))
    (qxt-check-status 'server)
    (qxt-send-command (concat "{rm," DatabaseName "," Release "}" ))))

;;
;; rm_all
;;	C: rm_all(Database_name, Specifed_version)
;;		Specified_version = Integer | '&void'
;;	S: result_rm_all(Status)
;;
(defun qxt-rm-all(DatabaseName Version)
  "DatabaseName$B$H(BVersion$B$G;XDj$7$?%G!<%?%Y!<%972$N:o=|$rAw?.$9$k!#(B
DatabaseName = String
Version = String | \"\"
"
  (interactive "sDatabaseName:\nsVersion: ")
  (progn
    (qxt-check-status 'server)
    (if (string= Version "")
	(setq Version  "'&void'"))
    (qxt-send-command (concat "{rm_all," DatabaseName "," Version "}"))))

;;
;; purge
;;	C: purge(Database_name)
;;	S: result_purge(Status)
;;
(defun qxt-purge(DatabaseName)
  "DatabaseName$B$N:GBg%P!<%8%g%s0J30$N:o=|$rAw?.$9$k!#(B"
  (interactive "sDstabaseName: ")
  (progn
    (qxt-check-status 'server)
    (qxt-send-command (concat "{purge," DatabaseName "}" ))))

;;
;; get_text_DB
;;	C: get_text_DB(DirectoryNames, DatabaseName, SpecifiedVersion)
;;
(defun qxt-get-text-DB(DirectoryNames DatabaseName)
  "DirectoryNames$B$H(BDatabaseName$B$G;XDj$7$?%G!<%?%Y!<%9$N%F%-%9%H$N<hF@$rAw?.$9$k!#(B
Directorynames = List of String
DatabaseName = String
"
  (interactive 
   (list (let ((DirectoryNames nil)
	       (DirectoryName (read-string "DirectoryName: ")))
	   (while (not (string= DirectoryName ""))
	     (setq DirectoryNames
		   (append DirectoryNames (list DirectoryName)))
	     (setq DirectoryName (read-string "DirectoryName: ")))
	   DirectoryNames)
     (read-string "DatabaseName: ")))
  (let ((AnalyzedName (qxt-analyze-database-name DatabaseName))
	(DatabaseName (car AnalyzedName))
	(Release (car (cdr AnalyzedName))))
    (qxt-check-status 'server)
    (qxt-send-command 
     (concat "{get_text_DB," DirectoryNames ","DatabaseName "," Release "}"))))

;;
;;	S: result_get_text_DB(Status, NewVersion, ProgramText, DirectoryName)
;;		New_version = Integer
;;
(defun qxt-result-get-text-DB(Result)
  "Result$B$N%G!<%?%Y!<%9$N%F%-%9%H$rI=<($9$k!#(B"
  (let ((NewVersion    (aref Result 2))
	(ProgramText   (aref Result 3))
	(DirectoryName (aref Result 4)))
    (insert (concat "** text DB ** Version:" NewVersion
		    " Directory:" DirectoryName "\n"))
    (while ProgramText
      (insert (car ProgramText))
      (newline)
      (setq ProgramText (cdr ProgramText)))))

;;
;; set_DBswitch
;;	C: get_DBswitch
;;      S: result_get_DBswitch(Status, DatabaseSwitch)
;;		DatabaseSwitch= simpos | kappa | unix(Hostname)
;;		Hostname = String
;;
(defun qxt-get-DBswitch()
  "DB$B%9%$%C%A$N<hF@$rAw?.$9$k!#(B"
  (interactive)
  (progn
    (qxt-check-status 'server)
    (qxt-send-command "get_DBswitch")))

;;
(defun qxt-result-get-DBswitch(Result)
  "DB$B%9%$%C%A$rI=<($9$k!#(B"
  (let ((DBswitch (aref Result 2)))
    (insert "** Database Switch **\n")
    (if (symbolp DBswitch)
	(insert (symbol-name DBswitch))
      (insert (symbol-name (aref DBswitch 0)))
      (insert " ")
      (insert (aref DBswitch 1) "\n"))))

;;
;; set_DBswitch
;;	C: set_DBswitch(DatabaseSwitch)
;;      S: result_set_DBswitch(Status)
;;
(defun qxt-set-DBswitch(Switch)
  "Switch$B$G(BDB$B%9%$%C%A$N@_Dj$rAw?.$9$k!#(B
Switch = \"simpos\" | \"kappa\" | \"null\" | \"unix(\\\"HostName\\\")\"
"
  (interactive
   (let ( InputSwitch Switch)
     (setq InputSwitch (completing-read "Switch: " 
		  '( ("simpos" 1) ("kappa" 2) ("unix" 3) ("null" 4)) nil t ))
     (if (string= InputSwitch "")
	 (setq Switch "simpos")
       	 (setq Switch InputSwitch) )
     (if (string= InputSwitch "unix")
	 (setq Switch (concat "unix(\"" (read-string "HostName: ") "\")")))
     (list Switch)))
  (progn
    (qxt-check-status 'server)
    (qxt-send-command (concat "{set_DBswitch," Switch "}"))))
