;;
;; quixote Lisp form shell for qmacs testing
;;
(defun qxt-shell ()
  "execute a Quixote functions in current buffer"
  (interactive)
  (let* ((buffer (current-buffer)))
    (save-excursion
      (beginning-of-buffer)
      (display-buffer (qxt-get-result-buffer))
      (qxt-insert-result-buffer "\n** Quixote shell starts ")
      (qxt-insert-result-buffer (current-time-string))
      (qxt-insert-result-buffer " **")
      (qxt-shell-loop buffer)
      (qxt-insert-result-buffer "\n** Quixote command shell ends ")
      (qxt-insert-result-buffer  (current-time-string))
      (qxt-insert-result-buffer " **"))))

(defun qxt-insert-result-buffer (String)
  (save-excursion
      (set-buffer (qxt-get-result-buffer))
      (goto-char (point-max))
      (insert String)))

;;
;; loop exit end-of-file or exit command
;;
(defun qxt-shell-loop (buffer)
  (catch 'break
    (let ((Command nil))
      (while (not (qxt-shell-exitp Command))
	(condition-case ()
	    (setq Command (qxt-shell-read buffer))
	  (end-of-file (throw 'break t)))
	(qxt-shell-execute Command)))))


;;
;; Command spec
;;     (FunctionName Arg1 Arg2 ...)
;;
(defun qxt-shell-read (buffer)
  (prog1
      (setq Command (read buffer))
    (qxt-insert-result-buffer  "\n")
    (qxt-insert-result-buffer  (prin1-to-string Command))))

;;
;; (exit)
;;
(defun qxt-shell-exitp (Command)
  (eq (car Command) 'exit))

;;
(defun qxt-shell-execute (Command)
  (let (Save qxt-synchronous)
    (setq qxt-synchronous t)
    (eval Command)
    (setq qxt-synchronous Save)))
