;; $B9=J82r@OIt$N;H$$J}(B
;;
;; (1) $B;z6g2r@OIt$N=i4|@_Dj$r9T$J$&!#(B
;;  (1-a) Quixote $B%W%m%0%i%`$NJ8;zNs$rJQ?t(B qxt-input-string $B$KBeF~$9$k!#(B
;;  (1-b) Quixote  $B%W%m%0%i%`$NJ8;zNs$ND9$5$r(B qxt-input-string-len $B$KBeF~$9$k!#(B
;;  (1-c) $BJQ?t(B qxt-lex-pos $B$K(B 0 $B$rBeF~$9$k!#(B
;;  (1-d) $BJQ?t(B qxt-line-no $B$K(B 1 $B$rBeF~$9$k!#(B
;;
;; (2) $B4X?t(B advance $B$r8F$V!#(B
;;
;; (3) $B%Q!<%:$9$k9=J8MWAG$KBP1~$7$?4X?t$r8F$S=P$9!#(B
;; (4) SRC $B7A<0$N9=B$$,JV$C$F$/$k!#(B


;; $B%3%a%s%H$O1Q8l$,$$$$$+F|K\8l$,$$$$$+$I$&$7$^$7$g(B?
;; I don't know if I shuld write comment in English.
;; How do you think?

;; I assume it belongs LL(1)
;; I'm slightly afraid that it doesn't belong LL(1)
;; Anyway, go ahead!

;; Oh boy, it doesn't belong LL(1) unfortunately.
;; So, there are some tricky code around.

(defvar token nil
  "$B8=:_$N;z6g!#(B")

(defvar value nil
  "$B8=:_$N;z6g$KBP1~$7$?CM!#(B")

(defun advance (&optional token-expected)
  "token $B$N@hFI$_$r$9$k4X?t!#%*%W%7%g%J%k$N0z?t(B token-expected $B$O(B
$B%^%C%A%s%0$KMQ$$$k!#(B

token-expected $B$,$"$k;~(B(nil $B$G$J$$;~(B)$B$G!"(B
$BJQ?t(B token $B$H(B token-expected $B$,0[$J$k>l9g!"(B
$B4X?t(B qxt-syntax-error $B$r8F$V!#(B

$B4X?t(B qxt-lex $B$r8F$S!"JQ?t(B token $B$*$h$S(B value $B$r@_Dj$9$k!#(B"
  (if (or (null token-expected)
	  (eq token token-expected))
      (let ((token-and-value (qxt-lex)))
	(setq token (car token-and-value))
	(setq value (cdr token-and-value)))
    (qxt-syntax-error)))

(put 'syntax 'error-conditions '(error syntax))

(defvar qxt-syntax-error-backtrace nil
  "Show backtrace when syntax error occured.")

(defun qxt-syntax-error (&optional string)
  "Syntax $B%(%i!<$rH/@8$9$k!#(B
$B%*%W%7%g%J%k$N0z?t(B string $B$O%(%i!<$N%a%C%;!<%8!#(B

$B%(%i!<$N%a%C%;!<%8$HJQ?t(B qxt-line-no $B$K$h$k8=:_$N9T?t$+$i(B
$BJ8;zNs$r9=@.$7!"(Bsymbol syntax $B$N(B signal $B$rH/@8$9$k!#(B"
  (if qxt-syntax-error-backtrace
      (debug))
  (if string
      (signal 'syntax (list
		       (format "SYNTAX %s at line %d" string qxt-line-no)))
    (signal 'syntax (list (format "SYNTAX at line %d." qxt-line-no)))))

(defun program-def ()
  "$B9=J8MWAG(B program-def $B$r(B parse $B$7!"(BSRC $B7A<0$r7A@.$9$k!#(B

program-def $B$NMWAG$H$J$k(B
exp-def, obj-def, mod-def, link-def, rule-def $B$OJ#?t$"$j$&$k!#(B
$B$3$l$i$r0l$D$K$^$H$a$k=hM}$r9T$J$&!#(B
"
  (let* (definition-list)
    (advance 'PROGRAM)
    (advance 'TERMINATER)
    (setq definition-list (definition-list))
    (advance 'END)
    (let (env-def exp-def obj-def mod-def link-def rule-def)
      ;; $BJ#?t$"$k(B xxx-def $B$r0l$D$K$^$H$a$k!#(Benv-def $B$O:G=i$N0l$D!#(B
      (while definition-list
	(let* ((def (car definition-list))
	       (head (aref def 0)))
	  (cond ((eq head 'env_def)
		 (if env-def
		     () ; just ignore
		   (setq env-def def)))
		((eq head 'exp_def)
		 (setq exp-def (append (aref def 1) exp-def)))
		((eq head 'obj_def)
		 (setq obj-def (append (aref def 1) obj-def)))
		((eq head 'mod_def)
		 (setq mod-def (append (aref def 1) mod-def)))
		((eq head 'link_def)
		 (setq link-def (append (aref def 1) link-def)))
		((eq head 'rule_def)
		 (setq rule-def (append (aref def 1) rule-def)))
		(t
		 (qxt-syntax-error)))
	  (setq definition-list (cdr definition-list))))
      ;; [program Env_def Exp_def Obj_def Mod_def Link_def Rule_def]
      (vector 'program
	      (if env-def
		  env-def
		'&void)
	      (if exp-def
		  (vector 'exp_def exp-def)
		'&void)
	      (if obj-def
		  (vector 'obj_def obj-def)
		'&void)
	      (if mod-def
		  (vector 'mod_def mod-def)
		'&void)
	      (if link-def
		  (vector 'link_def link-def)
		'&void)
	      (if rule-def
		  (vector 'rule_def rule-def)
		'&void)))))

(defun program ()
  "$B9=J8MWAG$N(B program $B$r(B parse $B$7!"(BSRC $B7A<0$r7A@.$9$k!#(B

$B4X?t(B program-def $B$r8F$S$@$7$?8e!"(B. $B$rFI$_Ht$P$9!#(B
$BJV$jCM$O(B $B4X?t(B program-def $B$NJV$7$?CM!#(B
"
  (prog1
      (program-def)
    (advance ?.)))

;; Watch out that oftenly, xxx-list have reverse order!
;; BTW, don't you know that
;; poor comments in program contain many bangs!!! like this!!!!
;; :-)

(defun definition-list ()
  "$B9=J8MWAG(B definition-list $B$r(B parse $B$7!"(BSRC $B7A<0$r7A@.$9$k!#(B

$B;z6g(B END $B$NA0$^$G$,(B definition-list $B$J$N$G!"@hFI$_(B token $B$,(B END $B$H0l(B
$BCW$9$k$^$G!"4X?t(B definition $B$r8F$S$@$7!"$=$NCM$r(B list $B$K2C$($k!#(B

$B$3$N4X?t$NJV$9(B list $B$O8@8l$G$N=P8==g$H5U$G$"$k$3$H$KCm0U!#(B"
  (let ((definition-list (cons (definition) nil)))
    (while (not (eq token 'END))
	(let ((definition (definition)))
	  (setq definition-list (cons definition definition-list))))
    definition-list))

(defun definition ()
  "$B9=J8MWAG(B definitio $B$r(B parse $B$7!"(BSRC $B7A<0$r7A@.$9$k!#(B

$B0J2<$N$h$&$K@hFI$_(B token $B$K$h$C$F8F$S=P$94X?t$rA*Br$7!"$=$N4X?t$N(B
$BJV$jCM$rCM$H$9$k!#(B

ENVIRONMENT         env-def
EXPRESSION          exp-def
OBJECT,SUBSUMPTION  obj-def
MODULE,SUBMODULE    mod-def
LINK                link-def
RULE                rule-def
$B$=$NB>(B              qxt-syntax-error
"
  (cond ((eq token 'ENVIRONMENT)
	 (env-def))
	((eq token 'EXPRESSION)
	 (exp-def))
	((or (eq token 'OBJECT)
	     (eq token 'SUBSUMPTION))
	 (obj-def))
	((or (eq token 'MODULE)
	     (eq token 'SUBMODULE))
	 (mod-def))
	((eq token 'LINK)
	 (link-def))
	((eq token 'RULE)
	 (rule-def))
	(t
	 (qxt-syntax-error))))

;; The first occurence is valid.  You cannot override it.
(defun env-def ()
  "$B9=J8MWAG(B env-def $B$r(B parse $B$7!"(BSRC $B7A<0$r7A@.$9$k!#(B

$B8@8l$G:G=i$N=P8=$N(B env $B$,M-8z$G!"$=$l0J8e$N(B env $B$OL58z$G$"$k!#(B
$B4X?t(B env-sequence $B$r8F$S$@$7!"(Blist $B$K$^$H$a$k!#(B
$B$=$N(B list $B$+$i(B name, author, date, def-lib-list $B$r<h$j$@$7!"(B
env-def $B$N(B SRC $B$r9=@.$9$k!#(B

$B4X?t(B env-sequence $B$N(B list $B$O8@8l$N=P8==g$H5U$K$J$C$F$$$k$3$H$KCm0U!#(B"
  (let (env-sequence)
    (advance 'ENVIRONMENT)
    (advance 'TERMINATER)
    (setq env-sequence (env-sequence))
    ;;
    (let ((name '&void)
	  (author '&void)
	  (date '&void)
	  def-lib-list)
      (while env-sequence
	(let* ((env (car env-sequence))
	       (head (aref env 0))
	       (body (aref env 1)))
	  (cond ((eq head 'name)
		 (setq name body))
		((eq head 'author)
		 (setq author body))
		((eq head 'date)
		 (setq date body))
		((eq head 'include)
		 (setq def-lib-list body))
		(t
		 (qxt-syntax-error)))
	  (setq env-sequence (cdr env-sequence))))
      ;; [env_def Name Author Date Def-lib-list]
      (vector 'env_def
	    name author date def-lib-list))))

(defun begining-of-definition ()
  "$B8=:_(B parse $B$7$F$$$k0LCV$,(B definition $B$N:G=i$+$I$&$+$rH=CG$9$k4X?t!#(B"
  (or
   (eq token 'ENVIRONMENT)
   (eq token 'EXPRESSION)
   (eq token 'OBJECT)
   (eq token 'SUBSUMPTION)
   (eq token 'MODULE)
   (eq token 'SUBMODULE)   (eq token 'LINK)
   (eq token 'RULE)
   (eq token 'END)))

(defun env-sequence ()
  (let ((env-sequence (cons (env) nil)))
    (while (not (begining-of-definition))
      (setq env-sequence (cons (env) env-sequence)))
    env-sequence))

(defun env ()
  "$B9=J8MWAG(B env $B$r(B parse $B$7!"(BSRC $B7A<0$r7A@.$9$k!#(B

$B@hFI$_(B token $B$,(B NAME, AUTHOR, DATE $B$N>l9g!"BP1~$9$kJ8;zNs$+$i(B SRC $B7A<0$r(B
$B:n$k!#(B

$B@hFI$_(B token $B$,(B INCLUDE $B$N>l9g!"4X?t(B def-lib-list $B$r8F$S=P$7!"(B
$B$=$NCM$+$i(B SRC $B7A<0$r:n$k!#(B"
  (let (env)
    (cond ((eq token 'NAME)
	   (advance) (advance ?\[) (advance 'PGM_NAME) (advance ?=)
	   (if (eq token 'STRING)
	       (setq env (vector 'name value))
	     (qxt-syntax-error))
	   (advance) (advance ?\]) (advance 'TERMINATER))
	  ((eq token 'AUTHOR)
	   (advance) (advance ?\[) (advance 'AUT_NAME) (advance ?=)
	   (if (eq token 'STRING)
	       (setq env (vector 'author value))
	     (qxt-syntax-error))
	   (advance) (advance ?\]) (advance 'TERMINATER))
	  ((eq token 'DATE)
	   (advance) (advance ?\[) (advance 'DATE) (advance ?=)
	   (if (eq token 'STRING)
	       (setq env (vector 'date value))
	     (qxt-syntax-error))
	   (advance) (advance ?\]) (advance 'TERMINATER))
	  ((eq token 'INCLUDE)
	   (advance) (advance ?\[)
	   (setq env (vector 'include (def-lib-list)))
	   (advance ?\]) (advance 'TERMINATER))
	  (t
	   (qxt-syntax-error)))
    env))

(defun def-lib-list ()
  "$B9=J8MWAG(B def-lib-list $B$r(B parse $B$7!"(BSRC $B7A<0$r7A@.$9$k!#(B

$B4X?t(B def-lib $B$r8F$S=P$7(B list $B$K$^$H$a$k!#!#(B
$B7W;;ESCf$G$O$3$N(B list $B$O8@8l$N=P8==g$H5U$K$J$C$F$$$k$3$H$KCm0U$;$h!#(B

$B$3$N(B list $B$+$i(B exp-lib, pgm-lib, sort-lib $B$r<h$j$@$7!"J;9g$9$k!#(B"
  (let ((def-lib-list (cons (def-lib) nil)))
    (while (eq token ?,)
      (advance)
      (setq def-lib-list (cons (def-lib) def-lib-list)))
    ;; merge
    (let (exp-lib pgm-lib sort-lib)
      (while def-lib-list
	(let* ((def-lib (car def-lib-list))
	       (head (aref def-lib 1))
	       (body (aref def-lib 2)))
	  (cond ((eq head 'exp_lib)
		 (setq exp-lib (append body exp-lib)))
		((eq head 'pgm_lib)
		 (setq pgm-lib (append body pgm-lib)))
		((eq head 'sort_lib)
		 (setq sort-lib (append body sort-lib)))
		(t
		 (qxt-syntax-error))))
	(setq def-lib-list (cdr def-lib-list)))
      (append
       (if exp-lib
	   (list (vector 'def_lib '&exp_lib exp-lib)))
       (if pgm-lib
	   (list (vector 'def_lib '&pgm_lib pgm-lib)))
       (if sort-lib
	   (list (vector 'def_lib '&sort_lib sort-lib)))) )))

(defun def-lib ()
  "$B9=J8MWAG(B def-lib $B$r(B parse $B$7!"(BSRC $B7A<0$r7A@.$9$k!#(B

$B4X?t(B lib-lab, lib-name $B$r8F$S$@$7!"$=$NCM$+$i(BSRC $B7A<0$r:n$k!#(B"
  (let (lib-lab lib-name-list)
    (setq lib-lab (lib-lab))
    (advance ?=)
    (if (eq token ?\{)
	(progn
	  (advance)
	  (setq lib-name-list (lib-name-list))
	  (advance ?\}))
      (setq lib-name-list (cons (lib-name) nil)))
    ;;
    (vector 'def_lib lib-lab lib-name-list)))

(defun lib-name-list ()
  "$B9=J8MWAG(B lib-name-list $B$r(B parse $B$7!"(BSRC $B7A<0$r7A@.$9$k!#(B

$B4X?t(B lib-name $B$r8F$S=P$7(B list $B$K$^$H$a$k!#!#(B
$B7W;;ESCf$G$3$N(B list $B$O8@8l$N=P8==g$H5U$K$J$C$F$$$k$3$H$KCm0U!#(B

$B:G8e$K(B list $B$r(B reverse $B$7$?CM$rJV$9!#(B"
  (let ((lib-name-list (cons (lib-name) nil)))
    (while (eq token ?,)
      (advance)
      (setq lib-name-list (cons (lib-name) lib-name-list)))
    (reverse lib-name-list)))

(defun lib-name ()
  "$B9=J8MWAG(B lib-name $B$r(B parse $B$7!"(BSRC $B7A<0$r7A@.$9$k!#(B"
  (if (eq token 'STRING)
      (prog1
	  ;;
	  value
	(advance))
    (qxt-syntax-error)))

(defun lib-lab ()
  "$B9=J8MWAG(B lib-lab $B$r(B parse $B$7!"(BSRC $B7A<0$r7A@.$9$k!#(B
lib-lab $B$O(B atom $B$G(B EXP_LIB, PGM_LIB, SORT_LIB $B$N$$$:$l$+!#(B"
  (let (lib-lab)
    (cond ((eq token 'EXP_LIB)
	   (setq lib-lab 'exp_lib))
	  ((eq token 'PGM_LIB)
	   (setq lib-lab  'pgm_lib))
	  ((eq token 'SORT_LIB)
	   (setq lib-lab  'sort_lib))
	  (t
	   (qxt-syntax-error)))
    (advance)
    lib-lab))

(defun exp-def ()
  "$B9=J8MWAG(B exp-def $B$r(B parse $B$7!"(BSRC $B7A<0$r7A@.$9$k!#(B
$B4X?t(B exp-list $B$r8F$S$@$7!"$=$NCM$rJV$jCM$H$9$k!#(B"
  (advance 'EXPRESSION)
  (advance 'TERMINATER)
  (vector 'exp_def (exp-list)))

(defun exp-list ()
  "$B9=J8MWAG(B exp-list $B$r(B parse $B$7!"(BSRC $B7A<0$r7A@.$9$k!#(B

$B@hFI$_(B token $B$,(B EXP_NAME $B$G$"$k4V!"4X?t(B exp $B$r8F$S=P$7(B list $B$K$^$H$a$k!#(B
$B7W;;ESCf$G$3$N(B list $B$O8@8l$N=P8==g$H5U$K$J$C$F$$$k$3$H$KCm0U!#(B

$B$3$N(B list $B$r(B reverse $B$7$?$b$N$rCM$H$7$FJV$9!#(B"
  (let ((exp-list (cons (exp) nil)))
    (while (eq token 'EXP_NAME)
      (setq exp-list (cons (exp) exp-list)))
    (reverse exp-list)))

(defun exp ()
  "$B9=J8MWAG(B exp $B$r(B parse $B$7!"(BSRC $B7A<0$r7A@.$9$k!#(B
$B4X?t(B exp-name, exp-operation $B$r8F$S$@$7!"$=$NCM$rMQ$$$F(B SRC $B7A<0$r7A@.$9$k!#(B"
  (if (eq token 'EXP_NAME)
       (let (exp-name exp-operation)
	(setq exp-name (exp-name))
	(advance ?=)
	(setq exp-operation (exp-operation))
	(advance 'TERMINATER)
	;;
	(let* ((head (car exp-operation))
	       (rest (cdr exp-operation)))
	  (vconcat (vector head) (vector exp-name) rest)))
    (qxt-syntax-error)))

(defun exp-name ()
  "$B9=J8MWAG(B exp-name $B$r(B parse $B$7!"(BSRC $B7A<0$r7A@.$9$k!#(B"
  (if (eq token 'EXP_NAME)
      (prog1
	  ;;
	  (vector 'exp_name value)
	(advance))
    (qxt-syntax-error)))

(defun self ()
  ""
  (vector 'c_o_term '&self' nil nil))

;; (normal o-term)
;; (del atom-list expname2
;; (add attr-list cnstr-list expname2)
;; (abs attr cnstr-list expname2)
(defun exp-operation ()
  "$B9=J8MWAG(B exp $B$r(B parse $B$9$k$?$a$NJd=u4X?t!#(B
exp $B$N1&JU$K$h$C$F0J2<$N7A<0$r:n$k!#(B

  o-term, self [normal <oterm>]
  DEL          (del <atom-list> <exp-name>)
  ADD          (add <attr-list> <cnstr-list> <exp-name>)
  ABS          (abs <attr> <cnstr-list> <exp-name>)"
  (cond ((eq token 'SELF)
	 (advance)
	 ;;
	 (list 'normal (self)))
	((eq token 'DEL)
	 (advance) (advance ?\()
	 ;;
	 (let* ((b-obj-list (b-obj-list))
		(exp-name
		 (progn
		   (advance ?\))
		   (exp-name))))
	   (list 'del b-obj-list exp-name)))
	((eq token 'ADD)
	 (let (o-attr-list o-cnstr-list exp-name)
	   (advance) (advance ?\() (advance ?\[)
	   (setq o-attr-list (o-attr-list))
	   (advance ?\])
	   (if (eq token ?,)
	       (progn
		 (advance) (advance ?\{)
		 (setq o-cnstr-list (o-cnstr-list))
		 (advance ?\})))
	   (advance ?\))
	   (setq exp-name (exp-name))
	   ;;
	   (list 'add
		 o-attr-list o-cnstr-list exp-name)))
	((eq token 'ABS)
	 (let (o-attr o-cnstr-list exp-name)
	   (advance) (advance ?\()
	   (setq o-attr (o-attr))
	   (if (eq token ?,)
	       (progn
		 (advance) (advance ?\{)
		 (setq o-cnstr-list (o-cnstr-list))
		 (advance ?\})))
	   (advance ?\))
	   (setq exp-name (exp-name))
	   ;;
	   (list 'abs
		 o-attr o-cnstr-list exp-name)))
	(t
	 (let ((o-term (o-term)))
	   ;;
	   (list 'normal o-term)))))

(defun obj-def ()
  "$B9=J8MWAG(B obj-def $B$r(B parse $B$7!"(BSRC $B7A<0$r7A@.$9$k!#(B

$B4X?t(B obj-sub-list $B$r8F$S$@$7$=$NCM$rMQ$$$F(BSRC $B7A<0$r7A@.$9$k!#(B"
  (let (obj-sub-list)
    (if (eq token 'OBJECT)
	(progn
	  (advance 'OBJECT) (advance 'TERMINATER)
	  (setq obj-sub-list (obj-sub-list))
	  ;;
	  (vector 'obj_def obj-sub-list))
      (advance 'SUBSUMPTION) (advance 'TERMINATER)
      (setq obj-sub-list (obj-sub-list))
      ;;
      (vector 'obj_def obj-sub-list))))

(defun obj-sub-list ()
  "$B9=J8MWAG(B obj-sub-list $B$r(B parse $B$7!"(BSRC $B7A<0$r7A@.$9$k!#(B

$B@hFI$_(B token $B$,(B ATOM $B$G$"$k4V!"4X?t(B obj-sub $B$r8F$S=P$7(B list $B$K$^$H$a$k!#(B
$B7W;;ESCf$G$3$N(B list $B$O8@8l$N=P8==g$H5U$K$J$C$F$$$k$3$H$KCm0U!#(B

$B:G8e$K(B reverse $B$7$FCM$H$9$k!#(B"
  (let ((obj-sub-list (obj-sub)))
    (while (eq token 'ATOM)
      (setq obj-sub-list (append (obj-sub) obj-sub-list)))
    (reverse obj-sub-list)))

;; list of obj-sub
;; 
;; [obj-sub obj1 obj2]
;; obj1    =<      obj2
;;      SUPERSUMES
(defun obj-sub ()
  "$B9=J8MWAG(B obj-sub $B$r(B parse $B$7!"(BSRC $B7A<0$r7A@.$9$k!#(B

$BCM$H$J$k(B SRC $B7A<0$O(B obj-sub $B$N(B SRC $B7A<0$G$O$J$/!"(Bobj-sub-list $B$N(B
SRC $B7A<0$G$"$k$3$H$KCm0U!#(B"
  (let ((b-obj1 (b-obj))
	b-obj-list
	b-obj2
	obj-sub)
    (cond ((eq token 'SUPERSUMES)
	   (advance)
	   (if (eq token ?\{)
	       (progn
		 (advance)
		 (setq b-obj-list (b-obj-list))
		 (advance ?\})
		 ;;
		 (while b-obj-list
		   (setq b-obj2 (car b-obj-list))
		   (setq obj-sub 
			 (cons (vector 'obj_sub b-obj1 b-obj2) obj-sub))
		   (setq b-obj-list (cdr b-obj-list))))
	     (setq b-obj2 (b-obj))
	     ;;
	     (setq obj-sub (list (vector 'obj_sub b-obj1 b-obj2))))
	   (advance 'TERMINATER))
	  ((eq token 'SUBSUMES)
	   (advance)
	   (if (eq token ?\{)
	       (progn
		 (advance)
		 (setq b-obj-list (b-obj-list))
		 (advance ?\})
		 ;;
		 (while b-obj-list
		   (setq b-obj2 (car b-obj-list))
		   (setq obj-sub
			 (cons (vector 'obj_sub b-obj2 b-obj1) obj-sub))
		   (setq b-obj-list (cdr b-obj-list))))
	     (setq b-obj2 (b-obj))
	     ;;
	     (setq obj-sub (list (vector 'obj_sub b-obj2 b-obj1))))
	   (advance 'TERMINATER))
	  (t
	   (qxt-syntax-error)))
    obj-sub))

(defun b-obj-list ()
  "$B9=J8MWAG(B b-obj-list $B$r(B parse $B$7!"(BSRC $B7A<0$r7A@.$9$k!#(B

$B4X?t(B b-obj $B$r8F$S=P$7(B list $B$K$^$H$a$k!#(B
$B7W;;ESCf$G$3$N(B list $B$O8@8l$N=P8==g$H5U$K$J$C$F$$$k$3$H$KCm0U!#(B

$B:G8e$K(B reverse $B$7$?$b$N$rCM$H$9$k!#(B"
  (let ((b-obj-list (cons (b-obj) nil)))
    (while (eq token ?,)
      (advance)
      (setq b-obj-list (cons (b-obj) b-obj-list)))
    (reverse b-obj-list)))

(defun b-obj ()
  "$B9=J8MWAG(B b-obj $B$r(B parse $B$7!"(BSRC $B7A<0$r7A@.$9$k!#(B"
  (if (eq token 'ATOM)
      (prog1
	  ;;
	  value
	(advance))
    (qxt-syntax-error)))

(defun mod-def ()
  "$B9=J8MWAG(B mod-def $B$r(B parse $B$7!"(BSRC $B7A<0$r7A@.$9$k!#(B

$B4X?t(B m-sub-list $B$r8F$S$@$7!"$=$NCM$r7k2L$H$9$k!#(B"
  (let (m-sub-list)
    (cond ((eq token 'MODULE)
	   (advance))
	  ((eq token 'SUBMODULE)
	   (advance))
	  (t
	   (qxt-syntax-error)))
    (advance 'TERMINATER)
    (setq m-sub-list (m-sub-list))
    ;;
    (vector 'mod_def m-sub-list)))

(defun m-sub-list ()
  "$B9=J8MWAG(B m-sub-list $B$r(B parse $B$7!"(BSRC $B7A<0$r7A@.$9$k!#(B
$B4X?t(B m-sub $B$r8F$S=P$7(B list $B$K$^$H$a$k!#(B
$B7W;;ESCf$G$3$N(B list $B$O8@8l$N=P8==g$H5U$K$J$C$F$$$k$3$H$KCm0U!#(B

$B:G8e$K(B reverse $B$7$?$b$N$rCM$H$9$k!#(B"
  (let ((m-sub-list (cons (m-sub) nil)))
    (while (not (begining-of-definition))
      (setq m-sub-list (cons (m-sub) m-sub-list)))
    (reverse m-sub-list)))

;; At first parse as if it is "m-desc XX m-desc"
;; Then, semantically distinguish
;;    mid SUPER_MODULE_OF m-desc
;; and
;;    m-desc SUB_MODULE_OF mid
;;
(defun m-sub ()
  "$B9=J8MWAG(B m-sub $B$r(B parse $B$7!"(BSRC $B7A<0$r7A@.$9$k!#(B

$B4X?t(B mid, m-desc $B$r8F$S$@$7!"$=$NCM$r85$K7k2L$r9=@.$9$k!#(B"
  (let (mid m-desc)
    (setq m-desc (m-desc))
    (cond ((eq token 'SUPER_MODULE_OF)
	   (advance)
	   ;; validate check if m-desc is mid
	   (if (not (eq (aref m-desc 0) 'm_id))
	       (qxt-syntax-error "mid expected"))
	   (setq mid (aref m-desc 1))
	   (setq m-desc (m-desc))
	   (advance 'TERMINATER))
	  ((eq token 'SUB_MODULE_OF)
	   (advance)
	   (setq mid (mid))
	   (advance 'TERMINATER)))
    (vector 'm_sub mid m-desc)))

(defun m-desc ()
  "$B9=J8MWAG(B m-desc $B$r(B parse $B$7!"(BSRC $B7A<0$r7A@.$9$k!#(B"
  (let ((m-desc (m-desc-term))
	op)
    (while (or (eq token ?+)
	       (eq token ?-))
      (setq op (if (eq token ?+) '+ '-))
      (advance)
      (setq m-desc (vector 'm_desc m-desc op (m-desc-term))))
    ;;
    m-desc))

(defun m-desc-term ()
  "$B9=J8MWAG(B m-desc $B$r(B parse $B$9$k$?$a$NJd=u4X?t!#(B"
  (let (mid m-desc)
    (if (eq token ?\()
	(progn
	  (advance)
	  (setq m-desc (m-desc))
	  (advance ?\))
	  ;;
	  m-desc)
      (setq mid (mid))
      ;;
      (vector 'm_id mid))))

(defun link-def ()
  "$B9=J8MWAG(B link-def $B$r(B parse $B$7!"(BSRC $B7A<0$r7A@.$9$k!#(B
$B4X?t(B link-list $B$r8F$S$@$7!"$=$NCM$r7k2L$H$9$k!#(B"
  (advance 'LINK)
  (advance 'TERMINATER)
  (vector 'link_def (link-list)))

(defun link-list ()
  "$B9=J8MWAG(B link-list $B$r(B parse $B$7!"(BSRC $B7A<0$r7A@.$9$k!#(B
definition $B$N:G=i$,8=$l$k$^$G$N4V!"4X?t(B link $B$r8F$S=P$7(B list $B$K$^$H$a$k!#(B
$B7W;;ESCf$G$3$N(B list $B$O8@8l$N=P8==g$H5U$K$J$C$F$$$k$3$H$KCm0U!#(B

$B:G8e$K(B reverse $B$7$?$b$N$r7k2L$H$9$k!#(B"
  (let ((link-list (cons (link) nil)))
    (while (not (begining-of-definition))
      (setq link-list (cons (link) link-list)))
    ;;
    (reverse link-list)))

(defun link ()
  "$B9=J8MWAG(B link $B$r(B parse $B$7!"(BSRC $B7A<0$r7A@.$9$k!#(B
$B4X?t(B link-name, m-link-list, o-link-list $B$r8F$S$@$7!"$=$l$i$NCM$r(B
$BAH$_9g$o$;$F7k2L$r9=@.$9$k!#(B"
  (let (link-name o-link-list m-link-list)
    (advance ?\{)
    (setq link-name (link-name))
    (advance ?,)
    (advance ?\[)
    (setq m-link-list (m-link-list))
    (advance ?\])
    (advance ?,)
    (advance ?\[)
    (setq o-link-list (o-link-list))
    (advance ?\])
    (advance ?\})
    (advance 'TERMINATER)
    ;;
    (vector 'link link-name m-link-list o-link-list)))

(defun link-name ()
  "$B9=J8MWAG(B link-name $B$r(B parse $B$7!"(BSRC $B7A<0$r7A@.$9$k!#(B"
  (if (eq token 'ATOM)
      (prog1
	  ;;
	  value
	(advance))
    (qxt-syntax-error)))

(defun o-link-list ()
  "$B9=J8MWAG(B o-link-list $B$r(B parse $B$7!"(BSRC $B7A<0$r7A@.$9$k!#(B

$B@hFI$_(B toke $B$,%+%s%^(B(,) $B$G$"$k4V!"4X?t(B o-link $B$r8F$S=P$7(B list $B$K$^$H$a$k!#(B
$B7W;;ESCf$G$3$N(B list $B$O8@8l$N=P8==g$H5U$K$J$C$F$$$k$3$H$KCm0U!#(B

$B:G8e$K(B list $B$r(B reverse $B$7$F7k2L$H$9$k!#(B"
  (let ((o-link-list (o-link)))
    (while (eq token ?,)
      (advance)
      (setq o-link-list (append (o-link) o-link-list)))
    (reverse o-link-list)))

(defun o-link ()
  "$B9=J8MWAG(B o-link $B$r(B parse $B$7!"(BSRC $B7A<0$r7A@.$9$k!#(B

$B9=@.$9$k(B SRC $B7A<0$O(B o-link-list $B$N(B SRC $B7A<0$G$"$k!#(B
$B4X?t(B o-term $B$"$k$$$O(B list-o-term-list $B$r8F$S$@$7!"$=$NCM$r$P$i$7$F!"(B
o-link $B$N(B SRC $B7A<0$N(B list $B$r9=@.$9$k!#(B"
  (let (o-term list-o-term-list o-link)
    (advance ?\{)
    (setq o-term (o-term))
    (advance ?,)
    (if (eq token ?\[)
	(progn
	  (advance)
	  (setq list-o-term-list (list-o-term-list))
	  (advance ?\]))
      (setq list-o-term-list (cons (o-term) nil)))
    (advance ?\})
    ;;
    (while list-o-term-list
      (let ((item (car list-o-term-list)))
	(setq o-link (cons (vector o-term item) o-link))
	(setq list-o-term-list (cdr list-o-term-list))))
    o-link))

(defun m-link-list ()
  "$B9=J8MWAG(B m-link $B$r(B parse $B$7!"(BSRC $B7A<0$r7A@.$9$k!#(B
$B@hFI$_(B toke $B$,%+%s%^(B(,) $B$G$"$k4V!"4X?t(B m-link $B$r8F$S=P$7(B list $B$K$^$H$a$k!#(B
$B7W;;ESCf$G$3$N(B list $B$O8@8l$N=P8==g$H5U$K$J$C$F$$$k$3$H$KCm0U!#(B

$B:G8e$K(B list $B$r(B reverse $B$7$F7k2L$H$9$k!#(B"
  (let ((m-link-list (m-link)))
    (while (eq token ?,)
      (advance)
      (setq m-link-list (append (m-link) m-link-list)))
    (reverse m-link-list)))

(defun m-link ()
  "$B9=J8MWAG(B m-link $B$r(B parse $B$7!"(BSRC $B7A<0$r7A@.$9$k!#(B

$B9=@.$9$k(B SRC $B7A<0$O(B m-link-list $B$N(B SRC $B7A<0$G$"$k!#(B
$B4X?t(B m-id $B$"$k$$$O(B c-o-term-list $B$r8F$S$@$7!"$=$NCM$r$P$i$7$F!"(B
m-link $B$N(B SRC $B7A<0$N(B list $B$r9=@.$9$k!#(B"
  (let (mid c-o-term-list m-link)
    (advance ?\{)
    (setq mid (mid))
    (advance ?,)
    (if (eq token ?\[)
	(progn
	  (advance)
	  (setq c-o-term-list (c-o-term-list))
	  (advance ?\]))
      (setq c-o-term-list (cons (mid) nil)))
    (advance ?\})
    ;;
  (while c-o-term-list
    (let ((item (car c-o-term-list)))
      (setq m-link (cons (vector mid item) m-link))
      (setq c-o-term-list (cdr c-o-term-list))))
  m-link))

(defun rule-def ()
  "$B4X?t(B rules $B$r8F$S$@$7!"$=$NCM$r7k2L$H$9$k!#(B"
  (advance 'RULE)
  (advance 'TERMINATER)
  ;;
  (vector 'rule_def (rules)))

(defun rules ()
  "$B9=J8MWAG(B rules $B$r(B parse $B$7!"(BSRC $B7A<0$r7A@.$9$k!#(B

$B@hFI$_(B token $B$,(B definition $B$N:G=i$G$J$$4V!"4X?t(B rules-sub $B$r8F$S$@$7(B
list $B$K$^$H$a$k!#(B

$B7W;;ESCf$G$3$N(B list $B$O8@8l$N=P8==g$H5U$K$J$C$F$$$k$3$H$KCm0U!#(B
$B:G8e$K(B list $B$r(B reverse $B$7$F7k2L$H$9$k!#(B"
  (let ((rules (rules-sub)))
    (while (not (begining-of-definition))
      (setq rules (append (rules-sub) rules)))
    (reverse rules)))

(defun rule-construct ()
  "rules-sub $B$NJd=u4X?t!#(Brule $B$N(B SRC $B7A<0$r7A@.$9$k!#(B
$BJQ?t$NF0E*B+G{$rMQ$$$F$$$k!#(B"
  (vconcat
   (vector 'rule
	   (if (car rule)
	       '&update
	     '&noupdate)
	   mod
	   (car (cdr rule))
	   (car (cdr (cdr rule)))
	   no-assume)
   (cdr (cdr (cdr rule)))))

;; this list is reverse order
(defun rules-sub ()
  "$B9=J8MWAG(B rules-sub $B$r(B parse $B$7!"(BSRC $B7A<0$r7A@.$9$k!#(B

$B$3$N(B list $B$O8@8l$N=P8==g$H5U$K$J$C$F$$$k$3$H$KCm0U!#(B"
  (let ((no-assume '&void)
	mod rule rule-sequence rules-sub)
    (if (eq token 'NO_ASSUME)
	(progn
	  (advance)
	  (setq no-assume '&no_assume)))
    (cond ((eq token 'SELF) ; mod
	   (setq mod (qxt-mod))
	   (if (eq token ?\{)
	       (progn
		 (advance)
		 (setq rule-sequence (rule-sequence))
		 (advance ?\})
		 ;;
		 (while rule-sequence
		   (setq rule (car rule-sequence))
		   (setq rules-sub
			 (cons (rule-construct)
			       rules-sub))
		   (setq rule-sequence (cdr rule-sequence))))
	     (setq rule (rule))
	     ;;
	     (setq rules-sub
		   (list (rule-construct)))))
	  ((eq token ?\()
	   (setq rule (rule))
	   ;;
	   (setq rules-sub
		 (list (rule-construct))))
	  ((eq token ?\{)
	   (advance)
	   (let ((c-o-term-list (c-o-term-list)))
	     (advance ?\})
	     (advance 'DOUBLE_COLON)
	     ;;
	     (setq mod c-o-term-list)
	     (if (eq token ?\{)
		 (progn
		   (advance)
		   (setq rule-sequence (rule-sequence))
		   (advance ?\})
		   ;;
		   (while rule-sequence
		     (setq rule (car rule-sequence))
		     (setq rules-sub
			   (cons (rule-construct)
				 rules-sub))
		     (setq rule-sequence (cdr rule-sequence))) )
	       (setq rule (rule))
	       ;;
	       (setq rules-sub
		     (list (rule-construct))))))
	  (t
	   (let ((o-term (o-term)))
	     (cond ((and
		     (or (eq 'c_o_term (aref o-term 0))
			 (eq 'var (aref o-term 0)))
		     ;; it's c-o-term or it's g-var
		     ;; and 
		     (eq token 'DOUBLE_COLON))
		    ;; then it's mid
		    (advance)
		    (setq mod (list o-term))
		    (if (eq token ?\{)
			(progn
			  (advance)
			  (setq rule-sequence (rule-sequence))
			  (advance ?\})
			  ;;
			  (while rule-sequence
			    (setq rule (car rule-sequence))
			    (setq rules-sub
				  (cons (rule-construct)
					rules-sub))
			    (setq rule-sequence (cdr rule-sequence))) )
		      (setq rule (rule))
		      ;;
		      (setq rules-sub
			    (list (rule-construct)))))
		   (t ;; it's rule
		    (setq rule (rule o-term))
		    (setq rules-sub
			  (list (rule-construct))))))))
    ;; backward compatibility shuld be deleted
    (if (eq token 'TERMINATER)
	(advance))
    ;;
    rules-sub
    ))

;; mid-list
(defun qxt-mod ()
  "$B9=J8MWAG(B mod $B$r(B parse $B$7!"(BSRC $B7A<0$r7A@.$9$k!#(B

$BCM$O(B mid-list $B$N(B SRC $B7A<0!#4X?t(B mid $B$"$k$$$O(B c-o-term-list $B$r8F$S=P$9!#(B"
  (let (c-o-term-list mid)
    (cond ((eq token ?\{)
	   (advance)
	   (setq c-o-term-list (c-o-term-list))
	   (advance ?\}))
	  (t
	   (setq mid (mid))))
    (advance 'DOUBLE_COLON)
    ;;
    (if mid
	(list mid)
      (c-o-term-list))))

(defun rule-sequence ()
  "$B9=J8MWAG(B rule-sequence $B$r(B parse $B$7!"(BSRC $B7A<0$r7A@.$9$k!#(B
$B4X?t(B rule $B$r8F$S=P$7(B list $B$K$^$H$a$k!#(B
$B7W;;ESCf$G$3$N(B list $B$O8@8l$N=P8==g$H5U$K$J$C$F$$$k$3$H$KCm0U!#(B

$B:G8e$K(B list $B$r(B reverse $B$7$F7k2L$H$9$k!#(B"
  (let ((rule-sequence (cons (rule) nil)))
    (while (not (eq token ?\}))
      (setq rule-sequence (cons (rule) rule-sequence)))
    ;;
    (reverse rule-sequence)))

;;
;; (update-p rule-id inheritance-mode a-term cluster-list cnstr-list)
(defun rule (&optional o-term)
  "$B9=J8MWAG(B rule $B$r(B parse $B$9$k!#(B

$B$3$NCJ3,$G$O$^$@!"(Brule $B$N(B SRC $B7A<0$r:n$l$J$$!#(B
$B4X?t(B clause, rule-lab $B$r8F$S$@$7!"$=$NCM$+$i(B
    (update-p rule-id inheritance-mode a-term cluster-list cnstr-list)
$B$H$$$&7A<0$r:n$j!"CM$H$9$k!#(B"
  (let ((rule-lab '(&void &void))
	clause)
    (if o-term
	(setq clause (clause o-term))
      (if (eq token ?\()
	  (progn
	    (advance)
	    (setq rule-lab (rule-lab))
	    (advance ?\))
	    (setq clause (clause)))
	(setq clause (clause))))
    ;;
    (cons (car clause) (append rule-lab (cdr clause)))))

;;
;; (rule-id inheritance-mode)
(defun rule-lab ()
  "$B9=J8MWAG(B rule-lab $B$r(B parse $B$9$k!#(B
SRC $B$K$O(B rule-lab $B$H$$$&$b$N$O$J$$!#(B

$B$3$3$G$O4X?t(B inh-mode $B$r8F$S$@$7!"(B
    (rule-id inheritance-mode)
$B$H$$$&7A<0$r:n$j!"CM$H$9$k!#(B"
  (let ((rule-id '&void)
	(inh-mode '&void))
    (cond ((eq token 'STRING)
	   (setq rule-id value)
	   (advance)
	   (if (eq token ?,)
	       (progn
		 (advance)
		 (setq inh-mode (inh-mode)))))
	  (t (setq inh-mode (inh-mode))))
    ;;
    (list rule-id inh-mode)))

(defun inh-mode ()
  "$B9=J8MWAG(B inh-mode $B$r(B parse $B$7!"(BSRC $B7A<0$r7A@.$9$k!#(B"
  (if (or (eq token 'L)
	  (eq token 'LO)
	  (eq token 'O)
	  (eq token 'OL))
      (prog1
	  value
	(advance))
    (qxt-syntax-error)))

;;
;; (update-p a-term cluster-list cnstr-list)
(defun clause (&optional o-term)
  "$B9=J8MWAG(B clause $B$r(B parse $B$9$k!#(B
$BBP1~$9$k(B SRC $B7A<0$O$J$$!#(B
$B4X?t(B body $B$r8F$S$@$7!"(B
  \begin{quote}
  (update-p a-term cluster-list cnstr-list)
  \end{quote}
$B$H$$$&7A<0$r:n$j!"CM$H$9$k!#(B"
  (let (a-term body)
    (setq a-term (a-term o-term))
    (cond ((eq token 'COMMITS)
	   (advance)
	   (setq body (body))
	   ;; backward compatibility.  Shuld be unconditional advance
	   (if (eq token 'TERMINATER)
	       (advance)))
	  (t
	   (setq body '(nil nil nil))
	   ;; backward compatibility.  Shuld be unconditional advance
	   (if (eq token 'TERMINATER) 
	       (advance))))           
    ;;
    (cons (car body) (cons a-term (cdr body)))))

;;
;; (update-p cluster-list cnstr-list)
(defun body ()
  "$B9=J8MWAG(B body $B$r(B parse $B$9$k!#(B
$BBP1~$9$k(B SRC $B7A<0$O$J$$!#(B

backward compatibility $B$N$?$a$K(B cnstr-list $B$H$$$&MWAG$,$"$k$,(B, 
$B$3$l$O>o$K(B nil $B$G$"$k(B. 
$B4X?t(B cluster $B$r8F$S=P$7!"(B
  (update-p cluster-element...)
$B$H$$$&7A<0$r=8$a(B, $B$3$l$i$+$i(B update-p $B$r7W;;$9$k!#$=$7$F(B, 
  (update-p (cluster-element-list...) nil)
$B$r7A:n$k(B. "
  (let (update-p body cl)
    (setq cl (cluster))
    (if (car cl)
	(setq update-p t))
    (setq body (cons (cdr cl) nil))
    (while (eq token ?\;)
      (advance)
      (setq cl (cluster))
      (if (car cl)
	  (setq update-p t))
      (setq body (cons (cdr cl) body)))
    (list update-p (reverse body) nil)))

;;
;; (update-p cluster-element...)
(defun cluster ()
  "$B9=J8MWAG(B cluster $B$r(B parse $B$9$k!#(B
$BBP1~$9$k(B SRC $B7A<0$O$J$$!#(B
$B4X?t(B u-cluster, $B$"$k$$$O(B props, a-cnstr-list $B$r8F$S$@$7!"(B
  (update-p cluster-element-list)
$B$H$$$&7A<0$r:n$j!"CM$H$9$k!#(B"
  (let (props a-cnstr-list u-cluster)
    (if (or
	 (eq token ?+)
	 (eq token ?-)
	 (eq token 'BEGIN_TRANSACTION)
	 (eq token 'END_TRANSACTION)
	 (eq token 'ABORT_TRANSACTION)
	 (eq token 'CONSIS)
	 (eq token 'INCONSIS))
	(progn
	  (setq u-cluster (u-cluster))
	  ;;
	  (cons t (list u-cluster)))
      (setq props (props))
      (if (eq token 'CONSTRAINED)
	  (progn
	    (advance)
	    (advance ?\{)
	      (setq a-cnstr-list (a-cnstr-list))
	      (advance ?\})))
      ;;
      (cons nil (append props a-cnstr-list)))))

(defun is-sub-rel ()
  "$B<!$N(B token $B$,(Bsub-rel $B$+$I$&$+$rH=CG$9$k4X?t!#(B"
  (or (eq token 'SUBSUMES)
      (eq token 'SUPERSUMES)
      (eq token 'CONGRUENT)
      (eq token 'NOT_EQUAL)))

;;
;; (prop... )
;;
(defun props ()
  "$B9=J8MWAG(B props $B$r(B parse $B$7(B, prop $B$N(B list $B$r:n@.$9$k(B. "
  (let ((props (cons (prop) nil)))
    (while (eq token ?,)
      (advance)
      (setq props (cons (prop) props)))
    (reverse props)))

;;
;; [normal {mid a-term} ]
;; [negation {mid o-term}]
;; [rel {o-term1 sub-rel o-term2}]
;;
(defun prop ()
  "$B9=J8MWAG(B prop $B$r(B parse $B$7!"(BSRC $B7A<0$r7A@.$9$k!#(B

$B4X?t(B m-lab, a-term, o-term $B$r8F$S$@$7!"(BSRC $B7A<0$r7A@.$9$k!#(B"
  (if (or (eq token 'NOT) (eq token ?~))
      (let (mid o-term o-term_preread)
	(advance)
	(if (eq token 'SELF) ; it's mid
	    (progn
	      (setq mid (m-lab))
	      (setq o-term (o-term))
	      ;;
	      (vector 'negation (vector mid o-term)))
	  (setq o-term_preread (o-term))
	  (if (eq token ?:) ;it found that it's mid
	      (progn
		(advance)
		;; check if it is c-o-term or g-var. if not, it's error
		(if (or (eq 'c_o_term (aref o-term_preread 0))
			(eq 'var (aref o-term_preread 0)))
		    (setq mid o-term_preread)
		  (qxt-syntax-error))
		(setq o-term (o-term))
		;;
		(vector 'negation (vector mid o-term)))
	    (setq o-term o-term_preread)
	    ;;
	    (vector 'negation (vector '&void o-term)))))
    (prop-no-naf)))

(defun prop-no-naf ()
  (let (o-term_preread mid a-term o-term prop rel)
    (if (eq token 'SELF) ; it's mid
	(progn
	  (setq mid (m-lab))
	  (setq a-term (a-term))
	  ;;
	  (vector 'normal (vector mid a-term)))
      (setq o-term_preread (o-term))
      (cond ((eq token ?:) ;it found that it's mid
	     (advance)
	     ;; check if it is c-o-term or g-var. if not, it's error
	     (if (or (eq 'c_o_term (aref o-term_preread 0))
		     (eq 'var (aref o-term_preread 0)))
		 (setq mid o-term_preread)
	       (qxt-syntax-error))
	     (setq a-term (a-term))
	     ;;
	     (vector 'normal (vector mid a-term)))
	    ((is-sub-rel)
	     (setq rel value)
	     (advance)
	     (vector 'rel
		     (vector o-term_preread rel (o-term))))
	    (t
	     (setq a-term (a-term o-term_preread))
	     ;;
	     (vector 'normal (vector '&void a-term)) )))))

(defun m-lab ()
  "$B9=J8MWAG(B m-lab $B$r(B parse $B$7!"(BSRC $B7A<0$r7A@.$9$k!#(B"
  (prog1
      (mid)
    (advance ?:)))

;; (mid a-term)
(defun m-lab&a-term ()
  "u-cluster $B$NJd=u4X?t!#(Bm-lab $B$H$=$l$K0z$-B3$/(B a-term $B$r(B parse $B$7!"(B
  (mid a-term)
$B$r7A@.$9$k!#(B"
  (let ((mid '&void)
	a-term
	o-term_preread)
    (if (eq token 'SELF) ; it's mid
	(progn
	  (setq mid (m-lab))
	  (setq a-term (a-term)))
      (setq o-term_preread (o-term))
      (cond ((eq token ?:) ;it found that it's mid
	     (advance)
	     ;; check if it is c-o-term or g-var. if not, it's error
	     (if (or (eq 'c_o_term (aref o-term_preread 0))
		     (eq 'var (aref o-term_preread 0)))
		 (setq mid o-term_preread)
	       (qxt-syntax-error))
	     (setq a-term (a-term)))
	    (t
	     (setq a-term (a-term o-term_preread)))))
    ;;
    (cons mid a-term)))

;; [normal {mid a-term} ]
;; [update {uflag mid a-term}]
;; [transaction xx]
;; [consis i-check]
;; [inconsis i-check]
(defun u-cluster ()
  "$B9=J8MWAG(B u-cluster $B$r(B parse $B$7!"(BSRC $B7A<0$r7A@.$9$k!#(B

$B4X?t(B m-lab\&a-term $B$"$k$$$O(B i-check $B$r8F$S$@$7!"(BSRC $B7A<0$r:n$k!#(B"
  (cond ((eq token 'BEGIN_TRANSACTION)
	 (advance)
	 ;;
	 (vector 'transaction '&bt))
	((eq token 'END_TRANSACTION)
	 (advance)
	 ;;
	 (vector 'transaction '&et))
	((eq token 'ABORT_TRANSACTION)
	 (advance)
	 (vector 'transaction '&at))
	((eq token 'CONSIS)
	 (let (i-check)
	   (advance)
	   (advance ?\()
	   (setq i-check (i-check))
	   (advance ?\))
	   ;;
	   (vector 'consis i-check)))
	((eq token 'INCONSIS)
	 (let (i-check)
	   (advance)
	   (advance ?\()
	   (setq i-check (i-check))
	   (advance ?\))
	   ;;
	   (vector 'inconsis i-check)))
	(t
	 (let (mid a-term m-lab&a-term)
	   (cond ((eq token ?+)
		  (advance)
		  (setq m-lab&a-term (m-lab&a-term))
		  (setq mid (car m-lab&a-term))
		  (setq a-term (cdr m-lab&a-term))
		  ;;
		  (vector 'update (vector '+ mid a-term)))
		 ((eq token ?-)
		  (advance)
		  (setq m-lab&a-term (m-lab&a-term))
		  (setq mid (car m-lab&a-term))
		  (setq a-term (cdr m-lab&a-term))
		  ;;
		  (vector 'update (vector '- mid a-term)))
		 (t
		  (setq m-lab&a-term (m-lab&a-term))
		  (setq mid (car m-lab&a-term))
		  (setq a-term (cdr m-lab&a-term))
		  ;;
		  (vector 'normal (vector mid a-term))))))))

(defun i-check ()
  "$B9=J8MWAG(B i-check $B$r(B parse $B$7!"(BSRC $B7A<0$r7A@.$9$k!#(B"
  (if (eq token ?\{)
      (let (a-cnstr-list)
	(advance)
	(setq a-cnstr-list (a-cnstr-list))
	(advance ?\})
	;;
	(vector 'cnstrs a-cnstr-list))
    (let ((mid '&void)
	  a-term o-term_preread)
      (if (eq token 'SELF)
	  (progn
	    (setq mid (m-lab))
	    (vector 'prop (vector mid (a-term))))
	(setq o-term_preread (o-term))
	(if (eq token ?:)
	    (progn
	      (advance)
	      ;; and check it's c-o-term. if not it's syntax error.
	      (setq mid o-term_preread)
	      (vector 'prop (vector mid (a-term))))
	  (vector 'prop (vector '&void (a-term o-term_preread))))))))
;;
;; (a-term o-term attr-list cnstr-list)
(defun a-term (&optional o-term_preread)
  "$B9=J8MWAG(B a-term $B$r(B parse $B$7!"(BSRC $B7A<0$r7A@.$9$k!#(B
a-term $B$O(B LL(1) $B$K<}$^$i$J$$$N$G!"$9$G$K(B a-term $B$r9=@.$9$k(B o-term
$B$rFI$s$G$7$^$C$?>l9g$,$"$k!#$=$N>l9g$O%*%W%7%g%J%k$N0z?t(B
o-term\_preread $B$,@_Dj$5$l$F8F$S=P$5$l$k!#(B

$B4X?t(B o-term, a-attr-list, a-cnstr-list $B$r8F$S$@$7!"(BSRC $B7A<0$r:n$k!#(Bo"
  (let (o-term a-attr-list a-cnstr-list)
    (if o-term_preread
	(setq o-term o-term_preread)
      (setq o-term (o-term)))
    (if (eq token ?/)
	(progn
	  (advance)
	  (if (eq token ?|)
	      (progn
		(advance)
		(advance ?\{)
		(setq a-cnstr-list (a-cnstr-list))
		(advance ?\}))
	    (advance ?\[)
	    (setq a-attr-list (a-attr-list))
	    (advance ?\])
	    (if (eq token ?|)
		(progn
		  (advance)
		  (advance ?\{)
		  (setq a-cnstr-list (a-cnstr-list))
		  (advance ?\})))))
      (if (eq token ?|)
	  (progn
	    (advance)
	    (advance ?\{)
	    (setq a-cnstr-list (a-cnstr-list))
	    (advance ?\}))))
    ;;
    (vector 'a_term o-term a-attr-list a-cnstr-list)))

(defun a-attr-list ()
  "$B9=J8MWAG(B a-attr-list $B$r(B parse $B$7!"(BSRC $B7A<0$r7A@.$9$k!#(B
$B@hFI$_(B token $B$,%+%s%^(B(,) $B$G$"$k4V!"4X?t(B a-attr $B$r8F$S=P$7(B list $B$K$^$H$a$k!#(B
$B7W;;ESCf$G$3$N(B list $B$O8@8l$N=P8==g$H5U$K$J$C$F$$$k$3$H$KCm0U!#(B

$B:G8e$K(B list $B$r(B reverse $B$7$F7k2L$H$9$k!#(B"
  (let ((a-attr-list (cons (a-attr) nil)))
    (while (eq token ?,)
      (advance)
      (setq a-attr-list (cons (a-attr) a-attr-list)))
    (reverse a-attr-list)))

(defun is-set-rel ()
  "$B@hFI$_(B token $B$,(B set-rel $B$+$I$&$+$rD4$Y$k4X?t!#(B"
  (or (eq token 'SET_SUBSUMES)
      (eq token 'SET_SUPERSUMES)
      (eq token 'SET_CONGRUENT)))

(defun is-attr-op ()
  "$B@hFI$_(B token $B$,(B attr-op $B$+$I$&$+$rD4$Y$k4X?t!#(B"
  (or (eq token 'ABSTRACT_OF)
      (eq token 'INSTANCE_OF)
      (eq token 'NOT_EQUAL)
      (eq token ?=)))

(defun a-attr ()
  "$B9=J8MWAG(B a-attr $B$r(B parse $B$7!"(BSRC $B7A<0$r7A@.$9$k!#(B"
  (if (eq token ?\{)
      (let (label rel ind-term)
	(advance)
	(if (eq token 'SET_ATOM)
	    (setq label (vector 'curl_set (aref (set-lab) 1)))
	  (setq label (vector 'curl_ind (aref (a-lab) 1))))
	(advance ?\})
	(if (is-attr-op)
	    (progn
	      (setq rel value)
	      (advance)
	      (setq ind-term (ind-term))
	      ;;
	      (vector 'attr label rel ind-term))
	  (qxt-syntax-error)))
    (if (eq token 'SET_ATOM)
	(let ((set-lab (set-lab))
	      rel
	      ind-term
	      set-terms)
	  (cond ((eq token 'ABSTRACT_OF)
		 (advance)
		 (setq ind-term (ind-term))
		 ;;
		 (vector 'attr set-lab '<- ind-term))
		((is-set-rel)
		 (setq rel value)
		 (advance)
		 (setq set-terms (set-terms))
		 ;;
		 (vector 'attr set-lab rel set-terms))
		(t
		 (qxt-syntax-error))))
      (let ((a-lab (a-lab))
	    ind-term
	    set-terms
	    o-term*set-lhs)
	(cond ((eq token 'ABSTRACT_OF)
	       (advance)
	       (setq ind-term (ind-term))
	       ;;
	       (vector 'attr a-lab '<- ind-term))
	      ((eq token ?=)
	       (advance)
	       (setq ind-term (ind-term))
	       ;;
	       (vector 'attr a-lab '= ind-term))
	      ((eq token 'INSTANCE_OF)
	       (advance)
	       ;; ind_term or set_terms
	       (cond ((eq token 'SORT_NAME)
		      (setq ind-term (ind-term))
		      ;;
		      (vector 'attr a-lab '-> ind-term))
		     ((eq token ?\{)
		      (setq set-terms (set-terms))
		      ;;
		      (vector 'attr a-lab '-> set-terms))
		     (t
		      (setq o-term*set-lhs (o-term*set-lhs))
		      ;;
		      (vector 'attr a-lab '-> o-term*set-lhs))))
	      ((eq token 'NOT_EQUAL)
	       (advance)
	       (setq ind-term (ind-term))
	       ;;
	       (vector 'attr a-lab '=/= ind-term))
	      (t
	       (qxt-syntax-error)))))))

;; ind(<c-o-term>)               % <c-o-term> $B$N$H$-(B
;; ind(c_o_term('&car',[],[]))   % &car $B$N$H$-(B
;; ind(c_o_term('&cdr',[],[]))   % &cdr $B$N$H$-(B
(defun a-lab ()
  "$B9=J8MWAG(B a-lab $B$r(B parse $B$7!"(BSRC $B7A<0$r7A@.$9$k!#(B"
  (cond ((eq token 'CAR)
	 (advance)
	 (vector 'ind (vector 'c_o_term '&car nil nil)))
	((eq token 'CDR)
	 (advance)
	 (vector 'ind (vector 'c_o_term '&cdr nil nil)))
	(t
	 (vector 'ind (c-o-term)))))

(defun sort- ()
  "$B9=J8MWAG(B sort $B$r(B parse $B$7!"(BSRC $B7A<0$r7A@.$9$k!#(B"
  (let ((sort-name value)
	o-term-list)
    (advance 'SORT_NAME)
    (advance ?\()
    (setq o-term-list (o-term-list))
    (advance ?\))
    ;;
    (vector 'sort (vector 'prolog sort-name o-term-list))))

(defun a-cnstr-list ()
  "$B9=J8MWAG(B a-cnstr-list $B$r(B parse $B$7!"(BSRC $B7A<0$r7A@.$9$k!#(B
$B@hFI$_(B token $B$,%+%s%^(B(,) $B$G$"$k4V!"4X?t(B a-cnstr $B$r8F$S=P$7(B list $B$K$^$H$a$k!#(B
$B7W;;ESCf$G!"$3$N(B list $B$O8@8l$N=P8==g$H5U$K$J$C$F$$$k$3$H$KCm0U!#(B

$B:G8e$K(B list $B$r(B reverse $B$7$F7k2L$H$9$k!#(B"
  (let ((a-cnstr-list (cons (a-cnstr) nil)))
    (while (eq token ?,)
      (advance)
      (setq a-cnstr-list (cons (a-cnstr) a-cnstr-list)))
    (reverse a-cnstr-list)))

(defun a-cnstr ()
  "$B9=J8MWAG(B a-cnstr $B$r(B parse $B$7!"(BSRC $B7A<0$r7A@.$9$k!#(B"
  (let ((mid1 '&void)
	value1
	rel
	(mid2 '&void)
	value2)
    ;; m-lab or ind-term or set-lhs?
    (cond ((eq token 'SELF) ; m-lab
	   (progn
	     (advance)
	     (setq mid1 (self))
	     (advance ?:)
	     (setq value1 (o-term*set-lhs))))
	  ((eq token 'SORT_NAME) ; ind-term
	   (setq value1 (sort-)))
	  (t ; umm... complecated ;_;
	   (let ((o-term*set-lhs (o-term*set-lhs)))
	     (if (is-set o-term*set-lhs)
		 ;; set-lhs
		 (setq value1 o-term*set-lhs)
	       (progn
		 (if (eq token ?:) ; it's m-lab
		     (progn
		       (advance)
		       (setq mid1 o-term*set-lhs)
		       (setq value1 (o-term*set-lhs)))
		   (setq value1 o-term*set-lhs)))))))
    (cond ((or (and (is-set value1)
		    (eq token 'NI)
		    (progn
		      (setq rel '&ni)
		      (advance)
		      t))
	       (and (not (is-set value1))
		    (is-sub-rel)
		    (progn
		      (setq rel value)
		      (advance)
		      t)))
	   ;; m-lab or ind-term
	   (cond ((eq token 'SELF) ; m-lab
		  (progn
		    (advance)
		    (setq mid2 (self))
		    (advance ?:)
		    (setq value2 (ind-term))))
		 ((eq token 'SORT_NAME) ; ind-term
		  (setq value2 (sort-)))
		 (t
		  (let ((o-term (o-term)))
		    (if (eq token ?:) ; it's m-lab
			(progn
			  (advance)
			  (setq mid2 o-term)
			  (setq value2 (ind-term)))
		      (setq value2 o-term))))))
	  ((or (and (is-set value1)
		    (is-set-rel)
		    (progn
		      (setq rel value)
		      (advance)
		      t))
	       (and (not (is-set value1))
		    (eq token 'IN)
		    (progn
		      (setq rel '&in)
		      (advance)
		      t)))
	   ;; m-lab or set-terms
	   (cond ((eq token 'SELF) ; m-lab
		  (progn
		    (advance)
		    (setq mid2 (self))
		    (advance ?:)
		    (setq value2 (set-terms))))
		 ((eq token ?\{) ; set-terms
		  (setq value2 (set-terms)))
		 (t
		  (let ((o-term*set-lhs (o-term*set-lhs)))
		    (if (is-set o-term*set-lhs)
			;; set-lhs
			(setq value2 o-term*set-lhs)
		      (advance ?:)
		      (setq mid2 o-term*set-lhs)
		      (setq value2 (set-terms)))))))
	   (t
	    (qxt-syntax-error)))
    (vector 'cnstr mid1 value1 rel mid2 value2)))

;; set(c_o_term('label*',[],[]))
(defun set-lab ()
  "$B9=J8MWAG(B set-lab $B$r(B parse $B$7!"(BSRC $B7A<0$r7A@.$9$k!#(B"
  (if (eq token 'SET_ATOM)
      (prog1
	  (vector 'set (vector 'c_o_term value nil nil))
	(advance))
    (qxt-syntax-error)))

(defun set-terms ()
  "$B9=J8MWAG(B set-terms $B$r(B parse $B$7!"(BSRC $B7A<0$r7A@.$9$k!#(B"
  (if (eq token ?\{)
      (let (list-o-term-list)
	(advance)
	(setq list-o-term-list (list-o-term-list))
	(advance ?\})
	;;
	(vector 'set list-o-term-list))
    (set-lhs)))

(defun is-set (o)
  "$B0z?t(B o $B$,=89g$+$I$&$+$rD4$Y$k4X?t!#(B"
  (or (and (eq (aref o 0) 'var)
	   (eq (aref o 1) 'set))
      (and (eq (aref o 0) 'dot)
	   (eq (aref (aref o 2) 0) 'set))))

(defun set-lhs ()
  "$B9=J8MWAG(B set-lhs $B$r(B parse $B$7!"(BSRC $B7A<0$r7A@.$9$k!#(B"
  (let ((o-term*set-lhs (o-term*set-lhs)))
    (if (is-set o-term*set-lhs)
	o-term*set-lhs
      (qxt-syntax-error "syntax... expecting set-lhs, o-term comes"))))

(defun o-term-list ()
  "$B9=J8MWAG(B o-term-list $B$r(B parse $B$7!"(BSRC $B7A<0$r7A@.$9$k!#(B
$B@hFI$_(B token $B$,%+%s%^(B(,) $B$G$"$k4V!"4X?t(B o-term $B$r8F$S=P$7(B list $B$K$^$H$a$k!#(B
$B7W;;ESCf$G!"$3$N(B list $B$O8@8l$N=P8==g$H5U$K$J$C$F$$$k$3$H$KCm0U!#(B

$B:G8e$K(B list $B$r(B reverse $B$7$F7k2L$H$9$k!#(B"
  (let ((o-term-list (cons (o-term) nil)))
    (while (eq token ?,)
      (advance)
      (setq o-term-list (cons (o-term) o-term-list)))
    (reverse o-term-list)))

(defun o-term ()
  "$B9=J8MWAG(B o-term $B$r(B parse $B$7!"(BSRC $B7A<0$r7A@.$9$k!#(B
$B4X?t(B o-term*set-lhs $B$r8F$S$@$7!"$=$N7k2L$,(B o-term $B$+$I$&$+%A%'%C%/$7!"(B
o-term $B$G$"$l$P$=$NCM$r7k2L$H$9$k!#(B"
  (let ((o-term*set-lhs (o-term*set-lhs)))
    (if (is-set o-term*set-lhs)
	(qxt-syntax-error "syntax... expecting o-term, set construct comes")
      o-term*set-lhs)))

(defun set-var ()
  "$B9=J8MWAG(B set-var $B$r(B parse $B$7!"(BSRC $B7A<0$r7A@.$9$k!#(B"
  (vector 'var 'set value))

(defun o-term*set-lhs ()
  "$B9=J8MWAG(B o-term $B$"$k$$$O(B set-lhs $B$r(B parse $B$7!"(BSRC $B7A<0$r7A@.$9$k!#(B"
  (if (eq token 'SET_VARIABLE)
      (let (set-var)
	(setq set-var (set-var))
	(advance)
	;;
	set-var)
    (let ((o-term (o-term-sub))
	  set-lhs
	  a-lab
	  set-lab)
      (catch 'set_lhs
	(while (or (eq token ?!) (eq token ?.))
	  (advance)
	  (if (eq token 0)
	      ;; it's the period which end query
	      (progn
		(setq token ?.)
		(throw 'set_lhs nil)))
	  (if (eq token 'SET_ATOM)
	      (progn
		(setq set-lab (set-lab))
		;;
		(setq set-lhs (vector 'dot o-term set-lab))
		(throw 'set_lhs nil))
	    (setq a-lab (a-lab))
	    (setq o-term (vector 'dot o-term a-lab)))))
      ;;
      (if set-lhs
	  set-lhs
	o-term))))

(defun var ()
  (vector 'var 'ind value))

(defun o-term-sub ()
  "o-term*set-lhs $B$NJd=u4X?t!#(B
$B9=J8MWAG(B list-o-term $B$"$k$$$O(B var $B$r(B parse $B$7!"(BSRC $B7A<0$r7A@.$9$k!#(B"
  (let (o-term-sub)
    (if (eq token 'VARIABLE)
      (let ((variable (var)))
	(advance)
	;;
	(setq o-term-sub variable))
      (setq o-term-sub (list-o-term)))
    o-term-sub))

(defun string-o-term ()
  "$B9=J8MWAG(B string-o-term $B$r(B parse $B$7!"(BSRC $B7A<0$r7A@.$9$k!#(B"
  (let ((string-list nil))
    (while (eq token 'STRING)
      (setq string-list (cons value string-list))
      (advance))
    (vector 'string (apply 'concat (reverse string-list)))))

(defun list-o-term ()
  "$B9=J8MWAG(B list-o-term $B$r(B parse $B$7!"(BSRC $B7A<0$r7A@.$9$k!#(B"
  (cond ((eq token 'EXP_NAME)
	 (exp-name))
	((eq token 'STRING)
	 (string-o-term))
	((eq token 'INTEGER)
	 (prog1
	     (vector 'integer value)
	   (advance)))
	((eq token ?\[)
	 (list-))
	((eq token 'NIL)
	 (list-))
	(t
	 (c-o-term))))

(defun ind-term ()
  "$B9=J8MWAG(B ind-term $B$r(B parse $B$7!"(BSRC $B7A<0$r7A@.$9$k!#(B"
  (cond ((eq token 'SORT_NAME)
	 (sort-))
	(t
	 (let ((o-term (o-term)))
	   o-term))))

(defun list-o-term-list ()
  "$B9=J8MWAG(B list-o-term-list $B$r(B parse $B$7!"(BSRC $B7A<0$r7A@.$9$k!#(B

$B@hFI$_(B token $B$,%+%s%^(B(,) $B$G$"$k4V!"(B
$B4X?t(B list-o-term $B$r8F$S=P$7(B list $B$K$^$H$a$k!#(B

$B7W;;ESCf$G!"$3$N(B list $B$O8@8l$N=P8==g$H5U$K$J$C$F$$$k$3$H$KCm0U!#(B
$B:G8e$K(B list $B$r(B reverse $B$7$F7k2L$H$9$k!#(B"
  (let ((list-o-term-list (cons (list-o-term) nil)))
    (while (eq token ?,)
      (advance)
      (setq list-o-term-list (cons (list-o-term) list-o-term-list)))
    (reverse list-o-term-list)))

(defun c-o-term-list ()
  "$B9=J8MWAG(B c-o-term-list $B$r(B parse $B$7!"(BSRC $B7A<0$r7A@.$9$k!#(B
$B@hFI$_(B token $B$,%+%s%^(B(,) $B$G$"$k4V!"(B
$B4X?t(B c-o-term $B$r8F$S=P$7(B list $B$K$^$H$a$k!#(B
$B7W;;ESCf$G!"$3$N(B list $B$O8@8l$N=P8==g$H5U$K$J$C$F$$$k$3$H$KCm0U!#(B
$B:G8e$K(B list $B$r(B reverse $B$7$F7k2L$H$9$k!#(B"
  (let ((c-o-term-list (cons (c-o-term) nil)))
    (while (eq token ?,)
      (advance)
      (setq c-o-term-list (cons (c-o-term) c-o-term-list)))
    (reverse c-o-term-list)))

;;
;; [prolog   head o-term-list]
;; [c-o-term head attr-list cnstr-list]
(defun c-o-term (&optional variable)
  "$B9=J8MWAG(B c-o-term $B$r(B parse $B$7!"(BSRC $B7A<0$r7A@.$9$k!#(B"
  (if (and (null variable) (eq token 'ATOM))
      (let (o-head o-attr-list o-cnstr-list o-term-list)
	(setq o-head (o-head))
	(cond ((eq token ?\[)
	       (advance)
	       (setq o-attr-list (o-attr-list))
	       (advance ?\])
	       (if (eq token ?\{)
		   (progn
		     (setq o-cnstr-list (o-cnstr-list))
		     (advance ?\})))
	       ;;
	       (vector 'c_o_term o-head o-attr-list o-cnstr-list))
	      ((eq token ?\()
	       (advance)
	       (setq o-term-list (o-term-list))
	       (advance ?\))
	       ;;
	       (vector 'prolog o-head o-term-list))
	      (t
	       ;;
	       (vector 'c_o_term o-head o-attr-list o-cnstr-list))))
	(a-o-term variable)
	(qxt-syntax-error "a-o-term is not supported yet")))

(defun o-head ()
  "$B9=J8MWAG(B o-head $B$r(B parse $B$7!"(BSRC $B7A<0$r7A@.$9$k!#(B"
  (b-obj))

(defun o-attr-list ()
  (let ((o-attr-list (cons (o-attr) nil)))
    (while (eq token ?,)
      (advance)
      (setq o-attr-list (cons (o-attr) o-attr-list)))
    (reverse o-attr-list)))

(defun o-attr ()
  "$B9=J8MWAG(B o-attr $B$r(B parse $B$7!"(BSRC $B7A<0$r7A@.$9$k!#(B"
  (let (b-obj o-term)
    (setq b-obj (b-obj))
    (advance ?=)
    (setq o-term (o-term))
    ;;
    (vector 'attr (vector 'ind (vector 'c_o_term b-obj nil nil))
	    '= o-term)))

(defun o-cnstr-list ()
  "$B9=J8MWAG(B o-cnstr-list $B$r(B parse $B$7!"(BSRC $B7A<0$r7A@.$9$k!#(B

$B@hFI$_(B token $B$,%+%s%^(B(,) $B$G$"$k4V!"(B
$B4X?t(B o-cnstr $B$r8F$S=P$7(B list $B$K$^$H$a$k!#(B
$B7W;;ESCf$G!"$3$N(B list $B$O8@8l$N=P8==g$H5U$K$J$C$F$$$k$3$H$KCm0U!#(B

$B:G8e$K(B list $B$r(B reverse $B$7$F7k2L$H$9$k!#(B"
  (let ((o-cnstr-list (cons (o-cnstr) nil)))
    (while (eq token ?,)
      (advance)
      (setq o-cnstr-list (cons (o-cnstr) o-cnstr-list)))
    (reverse o-cnstr-list)))

(defun o-cnstr ()
  "$B9=J8MWAG(B o-cnstr $B$r(B parse $B$7!"(BSRC $B7A<0$r7A@.$9$k!#(B"
  (let (l-var cnstr-o-term)
    (setq l-var (l-var))
    (advance 'CONGRUENT)
    (setq cnstr-o-term (cnstr-o-term))
    ;;
    (vector 'cnstr '&void l-var '== '&void cnstr-o-term)))

(defun cnstr-o-term ()
  "$B9=J8MWAG(B cnstr-o-term $B$r(B parse $B$7!"(BSRC $B7A<0$r7A@.$9$k!#(B"
  (cond ((eq token 'VARIABLE)
	 (l-var))
	((eq token 'EXP_NAME)
	 (exp-name))
	(t
	 (let (o-head o-attr-list)
	   (setq o-head (b-obj))
	   (if (eq token ?\[)
	       (progn
		 (advance)
		 (setq o-attr-list (o-attr-list))
		 (advance ?\[)))
	   ;;
	   (vector 'c_o_term o-head o-attr-list nil) ))))

(defun a-o-term (&optional variable)
  "$B9=J8MWAG(B a-o-term$B$r(B parse $B$9$k!#(B

SRC $B7A<0$G$O(B a-o-term $B$ODj5A$5$l$F$$$J$$!#(B"
  (let (l-var c-o-term)
    (if variable
	(setq l-var variable)
      (setq l-var (l-var)))
    (advance ?@)
    (setq c-o-term (c-o-term))
    ;;
    (vector 'a_o_term l-var c-o-term)))

;; 
(defun list- ()
  "$B9=J8MWAG(B list $B$r(B parse $B$7!"(BSRC $B7A<0$r7A@.$9$k!#(B

$B4X?t(B o-term-list $B$r8F$S=P$9!#(B"
  (let (o-term-list remain list)
    (if (eq token 'NIL)
	(progn
	  (advance)
	  (vector 'list nil))
      (advance ?\[)
      (setq o-term-list (o-term-list))
      (if (eq token ?|)
	  (progn
	    (advance)
	    (if (eq token 'VARIABLE)
		(progn
		  (setq list (vector 'list (append o-term-list (g-var)))))
	      (setq remain (list-))
	      (setq list (vector 'list (append o-term-list remain)))))
	(setq list (vector 'list o-term-list)))
      (advance ?\])
      ;;
      list)))

;; (defun mid-list ()
;;   (let ((mid-list (cons (mid) nil)))
;;     (while (eq token ?,)
;;       (advance)
;;       (setq mid-list (cons (mid) mid-list)))
;;     mid-list))

(defun mid ()
  "$B9=J8MWAG(B mid $B$r(B parse $B$7!"(BSRC $B7A<0$r7A@.$9$k!#(B"
  (cond ((eq token 'SELF)
	 (progn
	   (advance)
	   (self)))
	((eq token 'VARIABLE)
	 (let ((var (var)))
	   (advance)
	   (if (eq token ?@)
	       (c-o-term var)
	     ;; it's g-var
	     var)))
	((eq token 'ATOM)
	 (c-o-term))
	(t
	 (qxt-syntax-error))))

(defun dot-term ()
  "$B9=J8MWAG(B dot-term $B$r(B parse $B$7!"(BSRC $B7A<0$r7A@.$9$k!#(B"
  (let (o-term a-lab)
    (setq o-term (o-term))
    (advance);  ?! or ?.
    (setq a-lab (a-lab))
    ;;
    (vector 'dot o-term a-lab)))

(defun g-var ()
  "$B9=J8MWAG(B g-var $B$r(B parse $B$7!"(BSRC $B7A<0(B var $B$r7A@.$9$k!#(B"
  (if (eq token 'VARIABLE)
      (prog1
	  (var)
	(advance))
    (qxt-syntax-error)))

(defun l-var ()
  "$B9=J8MWAG(B l-var $B$r(B parse $B$7!"(BSRC $B7A<0(B var $B$r7A@.$9$k!#(B"
  (if (eq token 'VARIABLE)
      (prog1
	  (var)
	(advance))
    (qxt-syntax-error)))
;;;
;;; Query
;;; 
;;; [ query query_class q_head (cluster...) nil (q_mode...) program ]
(defun query ()
  "$B9=J8MWAG(B query $B$r(B parse $B$7!"(BSRC $B7A<0$r7A@.$9$k!#(B"
  (let (query-class
	(q-head '&void)
	cluster-list
	cnstr-list
	q-mode-list
	(program '&void)
	body)
    (advance 'SOLVE)
    (if (eq token ?\()
	(progn
	  (advance)
	  (setq q-head (a-term))
	  (advance ?\))))
    (setq body (body))
    (setq query-class (if (car body) '&update '&noupdate))
    (setq cluster-list (nth 1 body))
    (setq cnstr-list (nth 2 body))
    (if (eq token 'TERMINATER)
	(progn
	  (advance)
	  (if (eq token 'Q_MODE)
	      (progn
		(advance)
		(advance ?\[)
		(setq q-mode-list (q-mode-list))
		(advance ?\])
		(if (eq token 'TERMINATER)
		    (progn
		      (advance)
		      (setq program (program-def)))))
	    (setq program (program-def)))
	  (advance ?.))
      (advance ?.))
    (vector 'query query-class q-head
	    cluster-list cnstr-list q-mode-list program)))

(defun q-mode-list ()
  "$B9=J8MWAG(B q-mode-list $B$r(B parse $B$7!"(BSRC $B7A<0$r7A@.$9$k!#(B

$B@hFI$_(B token $B$,%+%s%^(B(,) $B$G$"$k4V!"(B
$B4X?t(B q-mode $B$r8F$S=P$7(B list $B$K$^$H$a$k!#(B
$B7W;;ESCf$G$O$3$N(B list $B$O8@8l$N=P8==g$H5U$K$J$C$F$$$k$3$H$KCm0U!#(B

$B:G8e$K(B list $B$r(B reverse $B$7$F7k2L$H$9$k!#(B"
  (let ((q-mode-list (list (q-mode))))
    (while (eq token ?,)
      (advance)
      (setq q-mode-list (cons (q-mode) q-mode-list)))
    (reverse q-mode-list)))
    
(defun q-mode ()
  "$B9=J8MWAG(B q-mode $B$r(B parse $B$7!"(BSRC $B7A<0$r7A@.$9$k!#(B"
  (cond ((eq token 'PROC_MODE)
	 (advance)
	 (advance ?=)
	 (cond ((eq token 'SINGLE)
		(advance)
		(vector 'proc '&single))
	       ((eq token 'MULTI)
		(advance)
		(vector 'proc '&multi))
	       (t
		(qxt-syntax-error))))
	((eq token 'ANS_MODE)
	 (advance)
	 (advance ?=)
	 (cond ((eq token 'NORMAL)
		(advance)
		(vector 'ans '&normal))
	       ((eq token 'MINIMAL)
		(advance)
		(vector 'ans '&minimal))
	       (t
		(qxt-syntax-error))))
	((eq token 'INHERITANCE)
	 (advance)
	 (advance ?=)
	 (cond ((eq token 'ALL)
		(advance)
		(vector 'inheritance '&all))
	       ((eq token 'DOWN)
		(advance)
		(vector 'inheritance '&down))
	       ((eq token 'UP)
		(advance)
		(vector 'inheritance '&up))
	       ((eq token 'NO)
		(advance)
		(vector 'inheritance '&no))
	       (t
		(qxt-syntax-error))))
	((eq token 'MERGE)
	 (advance)
	 (advance ?=)
	 (cond ((eq token 'YES)
		(advance)
		(vector 'merge '&yes))
	       ((eq token 'NO)
		(advance)
		(vector 'merge '&no))
	       (t
		(qxt-syntax-error))))
	((eq token 'EXPLANATION)
	 (advance)
	 (advance ?=)
	 (cond ((eq token 'ON)
		(advance)
		(vector 'explanation '&on))
	       ((eq token 'OFF)
		(advance)
		(vector 'explanation '&off))
	       (t
		(qxt-syntax-error))))))
;;;
;;
;;
(defun qxt-lisp2term-string (obj)
  "SRC $B7A<0$N(B lisp $B$N<B8=(B obj $B$+$i(B KL1 term $B$NI=8=$K$*$1$k(B
 SRC $B7A<0$N%9%H%j%s%0$rF@$k4X?t!#(B

$B%P%C%U%!$r@8@.$7!"(Bqxt-print-term $B$G$=$3$K=q$-9~$s$@7k2L$rJ8;zNs$H$7$F(B
$B=&$&!#(B"
  (let* ((buffer (generate-new-buffer " *qxt*"))
	 (standard-output buffer))
    (unwind-protect
	(save-excursion
	  (set-buffer buffer)
	  (qxt-print-term obj)
	  (buffer-string))
      (kill-buffer buffer))))

(defun qxt-print-term (obj)
  "You can include NO newline NOR backslash in string object.

$B%+%l%s%H%P%C%U%!$K(B
SRC $B7A<0$N(B lisp $B$N<B8=(B obj $B$r(B KL1 term $B$NI=8=$K$*$1$k(B SRC $B7A<0$N%9%H%j%s%0(B
$B$H$7$F=q$-9~$`!#(B

$B0J2<$N$h$&$K=hM}$9$k!#(B 
   $BJ8;zNs$O(B \" $B$N%(%9%1!<%W$r9T$J$&(B($BFs$D=E$M$k(B)$B!#(B
   nil $B$O(B [].
   integer $B$O$=$N$^$^(B
   list $B$O(B [...].
   vector $B$O(B {...}.
   atom $B$OI,MW$J$i$P(B ' $B$G0O$`!#(B"
  (cond ((stringp obj)
	 (let ((i 0)
	       (len (length obj)))
	   (princ "\"")
	   (while (< i len)
	     (let ((ch (aref obj i)))
	       (if (= ch ?\")
		   (princ "\"\"")
		 (princ (char-to-string ch)))
	       (setq i (1+ i))))
	   (princ "\"")))
	((numberp obj)
	 (prin1 obj))
	((null obj)
	 (princ "[]"))
	((consp obj)
	 (princ "[")
	 (while obj
	   (qxt-print-term (car obj))
	   (setq obj (cdr obj))
	   (if (listp obj)
	       (if obj (princ ","))
	     (princ "|")
	     (qxt-print-term obj)
	     (setq obj nil)))
	 (princ "]"))
	((vectorp obj)
	 (princ "{")
	 (let ((i 0)
	       (len (length obj)))
	   (while (< i len)
	     (qxt-print-term (aref obj i))
	     (setq i (1+ i))
	     (if (< i len)
		 (princ ","))))
	 (princ "}"))
	((symbolp obj)
	 (let ((string-rep (symbol-name obj))
	       (case-fold-search nil))
	   (if (string-match "[-$&>+*=<]\\|^[A-Z_]" string-rep)
	       (progn
		 (princ "'")
		 (princ string-rep)
		 (princ "'"))
	     (princ string-rep))))
	(t
	 (error "qxt-print-term"))))
