;;
;; kl1 term string to lisp object
;;    now Qmacs-I mode
;;
(defun qxt-term2lisp (string)
  "convert string representation of TERM to lisp object.
Term means KL1 term."
  (if qxt-qmacs-i-mode
      (qxt-term2lisp-I string)
    (qxt-term2lisp-D string)))

;;
;;  Qmacs-I mode
;;    needs exec-path for term2lisp(executable file)
;;
(defun qxt-term2lisp-I(String)
  (let (Buffer)
    (setq Buffer (get-buffer-create "*work*"))
    (save-excursion
      (set-buffer Buffer)
      (erase-buffer)
      (insert String)
      (call-process-region (point-min) (point-max) "term2lisp" t t nil)
      (beginning-of-buffer)
      (if (looking-at "syntax error")
	  (error "syntax error on term2lisp-I")
	(read Buffer)))))

;;
;; Qmacs-D mode
;;
(defun qxt-term2lisp-D (string)
  "convert string representation of TERM to lisp object.
Term means KL1 term."
  (let ((result (qxt-term2lisp-sub string 0)))
    (if (/= (cdr result) (length string))
	(error "this string contain more than a term")
      (car result))))

; use dynamic binding
(defun qxt-skip-space ()
  "$BJ8;zNs$NCf$G6uGr$rFI$_Ht$P$94X?t!#(B
$BJQ?t$NF0E*B+G{$r;H$C$F$$$k!#(B"
  (catch 'break
    (while (< pos len)
      (setq ch (aref string pos))
      (if (or (= ch ?\ )
	      (= ch ?\t)
	      (= ch ?\n))
	  ()
	(throw 'break nil))
      (setq pos (1+ pos)))))

(defun qxt-term2lisp-sub (string pos)
  "$BJ8;zNs(B string $B$N(B pos $B$N0LCV$+$i(B KL1 term $BI=8=$r(B parse $B$7!"(B
	(lisp $B$NBP1~$9$k9=B$(B . $B<!$N(B pos)
$B$rJV$94X?t!#(B"
  (let ((ch (aref string pos))
	(len (length string))
	(last-pos pos)
	value
	apos)
    (qxt-skip-space)
    (cond ((memq ch '(?& ?! ?# ?$ ?* ?/ ?+ ?- ?: ?< ?= ?> ?\? ?@ ?^ ?~))
	   (catch 'break
	     (while (< last-pos len)
	       (setq ch (aref string last-pos))
	       (if (memq ch '(?& ?! ?# ?$ ?* ?/ ?+ ?- ?: ?< ?= ?> ?\? ?@ ?^ ?~))
		   ()
		 (throw 'break nil))
	       (setq last-pos (1+ last-pos))))
	   (let ((atom (intern (substring string pos last-pos))))
	     (setq pos last-pos)
	     (qxt-skip-space)
	     (if (= ch ?\()
		 (progn
		   (setq pos (1+ pos))
		   (qxt-skip-space)
		   (if (= ch ?\))
		       (progn ; null
			 (setq pos (1+ pos))
			 (cons (vecor atom) pos))
		     (let (term obj)
		       (catch 'break
			 (while (and (< pos len)
				     (progn
				       (setq ch (aref string pos))
				       (/= ch ?\))))
			   (setq obj (qxt-term2lisp-sub string pos))
			   (setq term (cons (car obj) term))
			   (setq pos (cdr obj))
			   (qxt-skip-space)
			   (if (/= ch ?,)
			       (throw 'break nil))
			   (setq pos (1+ pos))
			   (qxt-skip-space)))
		       (if (/= ch ?\))
			   (error "term syntax"))
		       (setq pos (1+ pos))
		       (cons (vconcat (cons atom (reverse term))) pos))))
	       (cons atom pos))))
	  ((= ch ?\[) ; list
	   (setq pos (1+ pos))
	   (qxt-skip-space)
	   (let* (term
		  obj
		  (last-term
		   (catch 'break
		     (while (and (< pos len)
				 (progn
				   (setq ch (aref string pos))
				   (/= ch ?\])))
		       (setq obj (qxt-term2lisp-sub string pos))
		       (setq term (cons (car obj) term))
		       (setq pos (cdr obj))
		       (qxt-skip-space)
		       (if (= ch ?|)
			   (progn
			     (setq pos (1+ pos))
			     (qxt-skip-space)
			     (setq obj (qxt-term2lisp-sub string pos))
			     (setq pos (cdr obj))
			     (qxt-skip-space)
			     (throw 'break (car obj))))
		       (if (/= ch ?,)
			   (throw 'break nil))
		       (setq pos (1+ pos))
		       (qxt-skip-space)))))
	     (if (/= ch ?\])
		 (error "term syntax"))
	     (setq pos (1+ pos))
	     (cons (append (reverse term) last-term) pos)))
	  ((= ch ?\{) ; vector
	   (setq pos (1+ pos))
	   (qxt-skip-space)
	   (let (term obj)
	     (catch 'break
	       (while (and (< pos len)
			   (progn
			     (setq ch (aref string pos))
			     (/= ch ?\})))
		 (setq obj (qxt-term2lisp-sub string pos))
		 (setq term (cons (car obj) term))
		 (setq pos (cdr obj))
		 (qxt-skip-space)
		 (if (/= ch ?,)
		     (throw 'break nil))
		 (setq pos (1+ pos))
		 (qxt-skip-space)))
	     (if (/= ch ?\})
		 (error "term syntax"))
	     (setq pos (1+ pos))
	     (cons (vconcat (reverse term)) pos)))
	  ((= ch ?\") ; string
	   (setq pos (1+ pos))
	   (setq last-pos pos)
	   (setq apos 0)
	   (setq value (make-string (- len pos) 0))
	   (catch 'break
	     (while t
	       (while (and (< last-pos len)
			   (progn
			     (setq ch (aref string last-pos))
			     (/= ch ?\")))
		 (aset value apos ch)
		 (setq apos (1+ apos))
		 (setq last-pos (1+ last-pos)))
	       (setq last-pos (1+ last-pos))
	       (if (or (>= last-pos len)
		       (progn
			 (setq ch (aref string last-pos))
			 nil)
		       (/= ch ?\"))
		   (throw 'break nil)
		 (aset value apos ch)
		 (setq apos (1+ apos))
		 (setq last-pos (1+ last-pos)))))
	   (cons (substring value 0 apos)
		 last-pos))
	  ((= ch ?\') ; quoted atom
	   (setq pos (1+ pos))
	   (setq last-pos pos)
	   (while (and (< last-pos len)
		       (progn
			 (setq ch (aref string last-pos))
			 (not (= ch ?\'))))
	     (setq last-pos (1+ last-pos)))
	   (let ((atom (intern (substring string pos last-pos))))
	     (setq pos (1+ last-pos))
	     (qxt-skip-space)
	     (if (= ch ?\()
		 (progn
		   (setq pos (1+ pos))
		   (qxt-skip-space)
		   (if (= ch ?\))
		       (progn ; null
			 (setq pos (1+ pos))
			 (cons (vector atom) pos))
		     (let (term obj)
		       (catch 'break
			 (while (and (< pos len)
				     (progn
				       (setq ch (aref string pos))
				       (/= ch ?\))))
			   (setq obj (qxt-term2lisp-sub string pos))
			   (setq term (cons (car obj) term))
			   (setq pos (cdr obj))
			   (qxt-skip-space)
			   (if (/= ch ?,)
			       (throw 'break nil))
			   (setq pos (1+ pos))
			   (qxt-skip-space)))
		       (if (/= ch ?\))
			   (error "term syntax"))
		       (setq pos (1+ pos))
		       (cons (vconcat (cons atom (reverse term))) pos))))
	       (cons atom pos))))
	  ((and (>= ch ?0) (<= ch ?9)) ; integer or atom
	   (let ((is-number t)
		 (value 0))
	     (catch 'break
	       (while (< last-pos len)
		 (setq ch (aref string last-pos))
		 (if (and (>= ch ?0) (<= ch ?9))
		     (setq value (+ (* value 10) (- ch ?0)))
		   (if (or (and (>= ch ?A) (<= ch ?Z))
			 (and (>= ch ?a) (<= ch ?z))
			 (>= ch 128) ; kanji
			 (= ch ?_))
		     (setq is-number nil)
		   (throw 'break nil)))
		 (setq last-pos (1+ last-pos))))
	     (if is-number
		 (cons value last-pos)
	       (let ((atom (intern (substring string pos last-pos))))
		 (setq pos last-pos)
		 (qxt-skip-space)
		 (if (= ch ?\()
		     (progn
		       (setq pos (1+ pos))
		       (qxt-skip-space)
		       (if (= ch ?\))
			   (progn ; null
			     (setq pos (1+ pos))
			     (cons (vector atom) pos))
			 (let (term obj)
			   (catch 'break
			     (while (and (< pos len)
					 (progn
					   (setq ch (aref string pos))
					   (/= ch ?\))))
			       (setq obj (qxt-term2lisp-sub string pos))
			       (setq term (cons (car obj) term))
			       (setq pos (cdr obj))
			       (qxt-skip-space)
			       (if (/= ch ?,)
				   (throw 'break nil))
			       (setq pos (1+ pos))
			       (qxt-skip-space)))
			   (if (/= ch ?\))
			       (error "term syntax"))
			   (setq pos (1+ pos))
			   (cons (vconcat (cons atom (reverse term))) pos))))
		   (cons atom pos))) )))
	  ((or
	    (or (and (>= ch ?A) (<= ch ?Z))
		(= ch ?_))              ; Variable
	    (and (>= ch ?a) (<= ch ?z)) ; atom
	    (>= ch 128) ; kanji
	    )
	   (catch 'break
	     (while (< last-pos len)
	       (setq ch (aref string last-pos))
	       (if (or (and (>= ch ?A) (<= ch ?Z))
		       (and (>= ch ?a) (<= ch ?z))
		       (and (>= ch ?0) (<= ch ?9))
		       (>= ch 128) ; kanji
		       (= ch ?_))
		   ()
		 (throw 'break nil))
	       (setq last-pos (1+ last-pos))))
	   (let ((atom (intern (substring string pos last-pos))))
	     (if (null atom)
		 ;; oh unlucky!
		 (setq atom qxt-nil))
	     (setq pos last-pos)
	     (qxt-skip-space)
	     (if (= ch ?\()
		 (progn
		   (setq pos (1+ pos))
		   (qxt-skip-space)
		   (if (= ch ?\))
		       (progn ; null
			 (setq pos (1+ pos))
			 (cons (vecor atom) pos))
		     (let (term obj)
		       (catch 'break
			 (while (and (< pos len)
				     (progn
				       (setq ch (aref string pos))
				       (/= ch ?\))))
			   (setq obj (qxt-term2lisp-sub string pos))
			   (setq term (cons (car obj) term))
			   (setq pos (cdr obj))
			   (qxt-skip-space)
			   (if (/= ch ?,)
			       (throw 'break nil))
			   (setq pos (1+ pos))
			   (qxt-skip-space)))
		       (if (/= ch ?\))
			   (error "term syntax"))
		       (setq pos (1+ pos))
		       (cons (vconcat (cons atom (reverse term))) pos))))
	       (cons atom pos)))))))

(defvar qxt-stuff-path
  (concat (substitute-in-file-name "$QXTDIR") "/lib")
  "Path for Quixote stuff")

(defun qxt-stuff-start-process (program-name)
  "Start asynchronous process."
  (let* ((program-path
	  (concat qxt-stuff-path "/" program-name))
	 (control-d-path
	  (concat qxt-stuff-path "/" "control-d"))
	 (process
	  (start-process program-name nil control-d-path program-path)))
    (if (boundp 'NEMACS)
	(set-process-kanji-code process 0) ; that is, EUC
      ;; should add some code for MULE
      )
    process))

;;
;; lisp object to quixote syntax string
;;
(defun qxt-lisp2qxt(obj)
  "Lisp $B%*%V%8%'%/%H$r%f!<%6!<$,8+$k(BQuixote $B$NJ8;zNs$KJQ49$9$k!#(B"
  (let* ((buffer (generate-new-buffer " *qxt*"))
	 (standard-output buffer))
    (unwind-protect
	(save-excursion
	  (set-buffer buffer)
	  (qxt-lisp2qxt-obj obj)
	  (buffer-string))
      (kill-buffer buffer))))

(defun qxt-lisp2qxt-obj (obj)
  (let ((Id (aref obj 0)))
    (cond ((eq Id 'c_o_term)    (qxt-lisp2qxt-c-o-term obj))
	  ((eq Id 'prolog)      (qxt-lisp2qxt-prolog obj))
	  ((eq Id 'var)         (qxt-lisp2qxt-var obj))
	  ((eq Id 'dot)         (qxt-lisp2qxt-dot obj))
	  ((eq Id 'list)        (qxt-lisp2qxt-list obj))
	  ((eq Id 'exp_name)    (qxt-lisp2qxt-exp-name obj))
	  ((eq Id 'string)      (qxt-lisp2qxt-string obj))
	  ((eq Id 'integer)     (qxt-lisp2qxt-integer obj))
          ((eq Id 'rule)        (qxt-lisp2qxt-rule obj))
	  ((eq Id 'subgoal)     (qxt-lisp2qxt-subgoal obj))
	  ((eq Id 'dot_cnstr)   (qxt-lisp2qxt-dot-cnstr obj))
	  ((eq Id 'var_cnstr)   (qxt-lisp2qxt-var-cnstr obj))
	  ((eq Id 'rel)         (qxt-lisp2qxt-cluster-rel obj))
	  ((eq Id 'update)      (qxt-lisp2qxt-cluster-update obj))
	  ((eq Id 'transaction) (qxt-lisp2qxt-cluster-transaction obj))
	  ((eq Id 'consis)      (qxt-lisp2qxt-cluster-consis obj))
	  ((eq Id 'inconsis)    (qxt-lisp2qxt-cluster-inconsis obj))
          ((eq Id 'm_id)        (qxt-lisp2qxt-mid obj))
          ((eq Id 'm_desc)      (qxt-lisp2qxt-mdesc obj))
	  ((eq Id 'assump)      (qxt-lisp2qxt-assump obj))
	  ((eq Id 'aterm)       (qxt-lisp2qxt-aterm obj))
	  (t
	   (error "unknown lisp2qxt object")))))

(defun qxt-lisp2qxt-oterm (obj)
  (let ((Id (aref obj 0)))
    (cond ((eq Id 'c_o_term) (qxt-lisp2qxt-c-o-term obj))
	  ((eq Id 'prolog)   (qxt-lisp2qxt-prolog obj))
	  ((eq Id 'var)      (qxt-lisp2qxt-var obj))
	  ((eq Id 'dot)      (qxt-lisp2qxt-dot obj))
	  ((eq Id 'list)     (qxt-lisp2qxt-list obj))
	  ((eq Id 'exp_name) (qxt-lisp2qxt-exp-name obj))
	  ((eq Id 'string)   (qxt-lisp2qxt-string obj))
	  ((eq Id 'integer)  (qxt-lisp2qxt-integer obj))
	  (t
	   (error "unknown lisp2qxt object")))))

(defun qxt-lisp2qxt-c-o-term (obj)
  (let ((Head (aref obj 1))
	(Attrs (aref obj 2)) 
	(Cnstrs (aref obj 3)))
    (princ Head)
    (if (null Attrs) ()
      (princ "[")
      (qxt-lisp2qxt-attr (car Attrs))
      (setq Attrs (cdr Attrs))
      (while Attrs
	(princ ",")
	(qxt-lisp2qxt-attr (car Attrs))
	(setq Attrs (cdr Attrs)))
      (princ "]"))
    (if (null Cnstrs) ()
      (princ "/[")
      (qxt-lisp2qxt-cnstr (car Cnstrs))
      (setq Cnstrs (cdr Cnstrs))
      (while Cnstrs
	(princ ",")
	(qxt-lisp2qxt-cnstr (car Cnstrs))
	(setq Cnstrs (cdr Cnstrs)))
      (princ "]"))))

(defun qxt-lisp2qxt-attr (obj)
  (let ((Label (aref obj 1))
	(Op    (aref obj 2))
	(Value (aref obj 3)))
    (qxt-lisp2qxt-label Label)
    (princ Op)
    (qxt-lisp2qxt-value Value)))

(defun qxt-lisp2qxt-label (obj)
  (let ((Id (aref obj 0))
	(Oterm (aref obj 1)))
    (qxt-lisp2qxt-c-o-term Oterm)
    ))
;    (if (eq Id 'set)
;	(princ "*"))))

(defun qxt-lisp2qxt-value (obj)
  (let ((Id (aref obj 0)))
    (cond ((eq Id 'set)  (qxt-lisp2qxt-set obj))
	  ((eq Id 'sort) (qxt-lisp2qxt-sort obj))
	  (t             (qxt-lisp2qxt-oterm obj)))))

(defun qxt-lisp2qxt-set (obj)
  (let ((Oterms (aref obj 1)))
    (princ "{")
    (if (null Oterms)        ; added by j-takaha
	()                   ; added by j-takaha
        (qxt-lisp2qxt-oterm (car Oterms))
        (setq Oterms (cdr Oterms))
        (while Oterms
        (princ ",")
        (qxt-lisp2qxt-oterm (car Oterms))
        (setq Oterms (cdr Oterms))))
    (princ "}")))

(defun qxt-lisp2qxt-sort (obj)
  (qxt-lisp2qxt-prolog (aref obj 1)))

(defun qxt-lisp2qxt-cnstr (obj)
  (let ((Mid1   (aref obj 1))
	(Value1 (aref obj 2))
	(Op     (aref obj 3))
	(Mid2   (aref obj 4))
	(Value2 (aref obj 5)))
    (if (eq Mid1 '&void)
	()
      (qxt-lisp2qxt-oterm Mid1)
      (princ ":"))
    (qxt-lisp2qxt-value Value1)
    (princ Op)
    (if (eq Mid2 '&void)
	()
      (qxt-lisp2qxt-oterm Mid2)
      (princ ":"))
    (qxt-lisp2qxt-value Value2)))

(defun qxt-lisp2qxt-prolog (obj)
  (let ((Head (aref obj 1))
	(Oterms (aref obj 2)))
    (princ Head)
    (if (eq Oterms nil)
	()
      (princ "(")
      (qxt-lisp2qxt-oterm (car Oterms))
      (setq Oterms (cdr Oterms))
      (while Oterms
	(princ ",")
	(qxt-lisp2qxt-oterm (car Oterms))
	(setq Oterms (cdr Oterms)))
      (princ ")"))))

(defun qxt-lisp2qxt-dot (obj)
  (let ((Oterm (aref obj 1))
	(Label (aref obj 2)))
    (qxt-lisp2qxt-oterm Oterm)
    (princ ".")
    (qxt-lisp2qxt-label Label)))

(defun qxt-lisp2qxt-list (obj)
  (let ((Id (aref obj 0))
	(Oterms (aref obj 1)))
    (princ "[")
    (if Oterms
	(progn
	  (qxt-lisp2qxt-oterm (car Oterms))
	  (setq Oterms (cdr Oterms))
	  (if (not (listp Oterms))
	      (progn
		(princ "|")
		(qxt-lisp2qxt-oterm Oterms)
		(setq Oterms nil)))
	  (while Oterms
	    (princ ",")
	    (qxt-lisp2qxt-oterm (car Oterms))
	    (setq Oterms (cdr Oterms))
	    (if (not (listp Oterms))
		(progn
		  (princ "|")
		  (qxt-lisp2qxt-oterm Oterms)
		  (setq Oterms nil))))))
    (princ "]")))

(defun qxt-lisp2qxt-var (obj)
  (let ((Id      (aref obj 1))
	(VarName (aref obj 2)))
    (princ VarName)))
;    (if (eq Id 'set)
;      (princ "*"))))

(defun qxt-lisp2qxt-exp-name (obj)
  (princ (aref obj 1)))

(defun qxt-lisp2qxt-string (obj)
  (prin1 (aref obj 1)))

(defun qxt-lisp2qxt-integer (obj)
  (princ (aref obj 1)))

;;
;; Rule = rule(Rule_class,[$M_id,...],Rule_id,Inheritance_mode,No_assume,
;;		     $A_term,[$Cluster,...],[$Cnstr,...])
;;	Rule_class = '&noupdate' | '&update'
;;	Rule_id = String | &void
;;	Inheritance_mode = '&l' | '&o' | '&lo' | '&ol' | &void
;;	No_assume = '&no_assume' | &void
;;
(defun qxt-lisp2qxt-rule (obj)
  (let ((RuleClass (aref obj 1))
	(MIds      (aref obj 2))
	(RuleId    (aref obj 3))
	(InheritanceMode (aref obj 4))
	(NoAssume  (aref obj 5))
	(Aterm     (aref obj 6))
	(Clusters  (aref obj 7))
	(Cnstrs    (aref obj 8)))
    ;; assume
    (if (eq NoAssume '&void)
	()
      (princ NoAssume)
      (princ " "))
    ;; mids
    (if (eq MIds nil) ()
      (let ((MId (car MIds)))
	(setq MIds (cdr MIds))
	(if (eq MIds nil)
	    (qxt-lisp2qxt-oterm MId)
	  (princ "{")
	  (qxt-lisp2qxt-oterm MId)
	  (while MIds
	    (princ ",")
	    (qxt-lisp2qxt-oterm (car MIds))
	    (setq MIds (cdr MIds)))	    
	  (princ "}"))
	(princ "::")))
    ;; rule label
    (if (eq RuleId '&void)
	(if (eq InheritanceMode '&void) ()
	  (princ "(")
	  (princ InheritanceMode)
	  (princ ") "))
      (princ "(")
      (prin1 RuleId)
      (if (eq InheritanceMode '&void)
	  ()
	(princ ", ")
	(princ InheritanceMode))
      (princ ") "))
    ;; aterm
    (qxt-lisp2qxt-aterm Aterm)
    ;; props
    (if (eq Clusters nil)
	()
      (princ " <= ")
      (qxt-lisp2qxt-cluster (car Clusters))
      (setq Clusters (cdr Clusters))
      (while Clusters
	(princ "; ")
	(qxt-lisp2qxt-cluster (car Clusters))
	(setq Clusters (cdr Clusters))))
    ;; cnstr
    (if (eq Cnstrs nil)
	()
      (princ " || ")
      (princ "{")
      (qxt-lisp2qxt-cnstr (car Cnstrs))
      (setq Cnstrs (cdr Cnstrs))
      (while Cnstrs
	(princ ",")
	(qxt-lisp2qxt-cnstr (car Cnstrs))
	(setq Cnstrs (cdr Cnstrs)))
      (princ "}"))
    ;; terminator
    (princ " ;;")))

;;
;; $Cluster = [$Cluster_element,...]
;;
(defun qxt-lisp2qxt-cluster (Cluster)
  (qxt-lisp2qxt-cluster-element (car Cluster))
  (setq Cluster (cdr Cluster))
  (while Cluster
    (princ ", ")
    (qxt-lisp2qxt-cluster-element (car Cluster))
    (setq Cluster (cdr Cluster))))

;;
;; $Cluster_element = normal({M_id,$A_term})
;;       | negation({M_id,$O_term})
;;	 | rel({$O_term1,Sub_rel,$O_term2})
;;	 | update({Uflag,M_id,$A_term})
;;	 | transaction('&bt')
;;	 | transaction('&et')
;;	 | transaction('&at')
;;	 | consis($I_check)
;;	 | inconsis($I_check)
;;	 | $Cnstr		(*) 10.7 % for query
;;	Sub_rel = '=<' | '>=' | '=='
;;	Uflag = '+' | '-'
;;	M_id = $M_id | &void
;;
(defun qxt-lisp2qxt-cluster-element (ClusterE)
  (let ((Id (aref ClusterE 0)))
    (cond ((eq Id 'normal)      (qxt-lisp2qxt-cluster-normal ClusterE))
	  ((eq Id 'negation)    (qxt-lisp2qxt-cluster-negation ClusterE))
	  ((eq Id 'rel)         (qxt-lisp2qxt-cluster-rel ClusterE))
	  ((eq Id 'update)      (qxt-lisp2qxt-cluster-update ClusterE))
	  ((eq Id 'transaction) (qxt-lisp2qxt-cluster-transaction ClusterE))
	  ((eq Id 'consis)      (qxt-lisp2qxt-cluster-consis ClusterE))
	  ((eq Id 'inconsis)    (qxt-lisp2qxt-cluster-inconsis ClusterE)))))
;;
(defun qxt-lisp2qxt-cluster-normal (Cluster)
  (let (( MId (aref (aref Cluster 1) 0))
	(Aterm (aref (aref Cluster 1) 1)))
    (if (eq MId '&void)
	()
      (qxt-lisp2qxt-oterm MId)
      (princ ":"))
    (qxt-lisp2qxt-aterm Aterm)))
;;
(defun qxt-lisp2qxt-cluster-negation (Cluster)
  (let ((MId (aref (aref Cluster 1) 0))
	(Oterm (aref (aref Cluster 1) 1)))
    (princ "~")
    (if (eq MId '&void)
	()
      (qxt-lisp2qxt-oterm MId)
      (princ ":"))
    (qxt-lisp2qxt-oterm Oterm)))

;;
(defun qxt-lisp2qxt-cluster-rel (Cluster)
  (let ((Oterm1 (aref (aref Cluster 1) 0))
	(SubRel (aref (aref Cluster 1) 1))
	(Oterm2 (aref Body 2)))
    (qxt-lisp2qxt-oterm Oterm1)
    (princ SubRel)
    (qxt-lisp2qxt-oterm Oterm2)))

;;
(defun qxt-lisp2qxt-cluster-update (Cluster)
  (let ((Uflag (aref (aref Cluster 1) 0))
	(MId   (aref (aref Cluster 1) 1))
	(Aterm (aref (aref Cluster 1) 2)))
    (princ Uflag)
    (if (eq MId '&void)
	()
      (qxt-lisp2qxt-oterm MId)
      (princ ":"))
    (qxt-lisp2qxt-aterm Aterm)))

;;
(defun qxt-lisp2qxt-cluster-transaction (Cluster)
  (princ (aref Cluster 1)))

;;
(defun qxt-lisp2qxt-cluster-consis (Cluster)
  (progn
    (princ "&consis")
    (qxt-lisp2qxt-cluster-icheck (aref Cluster 1))))
;;
(defun qxt-lisp2qxt-cluster-inconsis (Cluster)
  (progn
    (princ "&inconsis")
    (qxt-lisp2qxt-cluster-icheck (aref Cluster 1))))

;;
;; $I_check = prop({M_id,$A_term})
;;	 | cnstrs([$Cnstr,...])
;;
(defun qxt-lisp2qxt-cluster-icheck (Icheck)
  (let ((Id   (aref Icheck 0)))
    (princ "(")
    (if (eq Id 'prop)
	(let ((MId   (aref (aref Icheck 1) 0))
	      (Aterm (aref (aref Icheck 1) 1)))
	  (if (eq MId '&void) ()
	    (qxt-lisp2qxt-oterm MId)
	    (princ ":"))
	  (qxt-lisp2qxt-aterm Aterm))
      (let ((Cnstrs  (aref Icheck 1)))
	(princ "{")
	(qxt-lisp2qxt-cnstr (car Cnstrs))
	(setq Cnstrs (cdr Cnstrs))
	(while Cnstrs
	  (princ ", ")
	  (qxt-lisp2qxt-cnstr (car Cnstrs))
	  (setq Cnstrs (cdr Cnstrs)))
	(princ "}")))
    (princ ")")))

;;
;; $A_term = a_term($O_term,[$Attr,...],[$Cnstr,...])
;;
(defun qxt-lisp2qxt-aterm (Aterm)
  (let ((Oterm (aref Aterm 1))
	(Attrs (aref Aterm 2))
	(Cnstrs (aref Aterm 3)))
    (qxt-lisp2qxt-oterm Oterm)
    (if (eq Attrs nil)
	()
      (princ "/[")
      (qxt-lisp2qxt-attr (car Attrs))
      (setq Attrs (cdr Attrs))
      (while Attrs
	(princ ",")
	(qxt-lisp2qxt-attr (car Attrs))
	(setq Attrs (cdr Attrs)))
      (princ "]"))
    (if (eq Cnstrs nil)
	()
      (princ "|{")
      (qxt-lisp2qxt-cnstr (car Cnstrs))
      (setq Cnstrs (cdr Cnstrs))
      (while Cnstrs
	(princ ",")
	(qxt-lisp2qxt-cnstr (car Cnstrs))
	(setq Cnstrs (cdr Cnstrs)))      
      (princ "}"))))


(defun qxt-lisp2qxt-subgoal (obj)
  (let ((Mid       (aref obj 1))
	(Oterm     (aref obj 2))
	(VarCnstrs (aref obj 3)))
    (progn
      (qxt-lisp2qxt-oterm Mid)
      (princ ":")
      (qxt-lisp2qxt-oterm Oterm)
      (if (eq VarCnstrs nil)
	  ()
	(princ "|{")
	(while VarCnstrs
	  (let ((Var         (aref (car VarCnstrs) 0))
		(Constraint  (aref (car VarCnstrs) 1)))
	    (if (eq Constraint '&void) ()
	      (let ((Ups   (aref (aref Constraint 1) 0))
		    (Downs (aref (aref Constraint 1) 1)))
		(if (eq Ups nil)
		    ()
		  (qxt-lisp2qxt-oterm Var)
		  (princ " =< ")
		  (qxt-lisp2qxt-oterm (car Ups))
		  (setq Ups (cdr Ups))
		  (while Ups
		    (princ ", ")
		    (qxt-lisp2qxt-oterm Var)
		    (princ " =< ")
		    (qxt-lisp2qxt-oterm (car Ups))
		    (setq Ups (cdr Ups))))
		(if (eq Downs nil)
		    ()
		  (if (eq (aref (aref Constraint 1) 0) nil) ()
		    (princ ", "))
		  (qxt-lisp2qxt-oterm Var)
		  (princ " => ")
		  (qxt-lisp2qxt-oterm (car Downs))
		  (setq Downs (cdr Downs))
		  (while Downs
		    (princ ", ")
		    (qxt-lisp2qxt-oterm Var)
		    (princ " => ")
		    (qxt-lisp2qxt-oterm (car Downs))
		    (setq Downs (cdr Downs))))))
	    (setq VarCnstrs (cdr VarCnstrs))))
	(princ "}")))))
;;
(defun qxt-lisp2qxt-dot-cnstr (obj)
  (let ((Mid   (aref obj 1))
	(Dot   (aref obj 2)) 
	(Rel   (aref obj 3))
	(Mid2  (aref obj 4))
	(Value  (aref obj 5)))
    (if (eq Mid '&void)
	()
      (qxt-lisp2qxt-oterm Mid)
      (princ ":"))
    (qxt-lisp2qxt-oterm Dot)
    (princ " ")
    (princ (symbol-name Rel))
    (princ " ")
    (if (eq Mid2 '&void)
	()
      (qxt-lisp2qxt-oterm Mid2)
      (princ ":"))
    (qxt-lisp2qxt-value Value)))
;;
(defun qxt-lisp2qxt-var-cnstr (obj)
  (let ((Var   (aref obj 1))
	(Rel   (aref obj 2))
	(Value (aref obj 3)))
    (qxt-lisp2qxt-oterm Var)
    (princ " ")
    (princ (symbol-name Rel))
    (princ " ")
    (qxt-lisp2qxt-value Value)))
;;
(defun qxt-lisp2qxt-mdesc (obj)
  (let ((Mdesc1   (aref obj 1))
	(Op       (aref obj 2))
	(Mdesc2   (aref obj 3)))
    (princ "(")
    (qxt-lisp2qxt-mid-mdesc Mdesc1)
    (princ " ")
    (princ Op)
    (princ " ")
    (qxt-lisp2qxt-mid-mdesc Mdesc2)
    (princ ")")))
;;
(defun qxt-lisp2qxt-mid-mdesc (obj)
  (if (eq 'm_id (aref obj 0))
      (qxt-lisp2qxt-mid obj)
    (qxt-lisp2qxt-mdesc obj)))
;;
(defun qxt-lisp2qxt-mid (obj)
  (qxt-lisp2qxt-oterm (aref obj 1)))

;;
;; Assump = assump(M_id, Dot, [{Var, Constraint}, ...])
;;
(defun qxt-lisp2qxt-assump (obj)
  (let ((MidVoid    (aref obj 1))
	(Dot        (aref obj 2))
	(VarCnstrs  (aref obj 3)))
    (if (eq MidVoid '&void) ()
      (qxt-lisp2qxt-oterm MidVoid)
      (princ ":"))
    (qxt-lisp2qxt-dot Dot)
    (if (eq VarCnstrs nil)
	()
      (princ "|{")
      (while VarCnstrs
	(let ((Var         (aref (car VarCnstrs) 0))
	      (Constraint  (aref (car VarCnstrs) 1)))
	  (if (eq Constraint '&void)
	      ()
	    (let ((Ups   (aref (aref Constraint 1) 0))
		  (Downs (aref (aref Constraint 1) 1)))
	      (if (eq Ups nil)
		  ()
		(qxt-lisp2qxt-oterm Var)
		(princ " =< ")
		(qxt-lisp2qxt-oterm (car Ups))
		(setq Ups (cdr Ups))
		(while Ups
		  (princ ", ")
		  (qxt-lisp2qxt-oterm Var)
		  (princ " =< ")
		  (qxt-lisp2qxt-oterm (car Ups))
		  (setq Ups (cdr Ups))))
	      (if (eq Downs nil)
		  ()
		(if (eq (aref (aref Constraint 1) 0) nil) ()
		  (princ ", "))
		(qxt-lisp2qxt-oterm Var)
		(princ " => ")
		(qxt-lisp2qxt-oterm (car Downs))
		(setq Downs (cdr Downs))
		(while Downs
		  (princ ", ")
		  (qxt-lisp2qxt-oterm Var)
		  (princ " => ")
		  (qxt-lisp2qxt-oterm (car Downs))
		  (setq Downs (cdr Downs))))))
	  (setq VarCnstrs (cdr VarCnstrs))))
      (princ "}"))))

;;
;; qxt-oterm2src using parser
;;
(defun qxt-oterm2src (text)
  "$BF~NO$5$l$?%3%^%s%ICf$N%*%V%8%'%/%H9`(B text$B$r(B
$B%5!<%P!<$,<u$1$H$k(B\.src$B7A<0$NJ8;zNs$KJQ49$9$k!#(B
"
  (progn
    (setq qxt-input-string text)
    (setq qxt-input-string-len (length text))
    (setq qxt-lex-pos 0)
    (setq qxt-line-no 1)
    (advance)
    (qxt-lisp2term-string (o-term))))

;;;;;;;;;;;;;;;;;  We can't use following stuffs
;; because C implementation of PP is not reliable.


;;
(defconst qxt-prity-print-program "cat")
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;; "term2qxt")

;; RULE:   lisp representation of Rule
;; OUTPUT: string, prity printed

(defun qxt-prity-print (rule)
  (let* ((process-connection-type nil)
	 ; we can't use pty because it has short buffer (256?)
	 ; we use pipe for connection
	 (string-rep (qxt-lisp2term-string rule))
	 (buffer (get-buffer-create " *Quixote-Tmp*"))
	 (pp-process (start-process "pp" buffer "control-d"
				    qxt-prity-print-program)))
    (save-excursion
      (set-buffer buffer)
      (erase-buffer)
      (process-send-string pp-process string-rep)
      (process-send-string pp-process "\n\004\n")
      (while (not (eq (process-status pp-process) 'exit))
	(accept-process-output pp-process))
      (let* ((text (buffer-string))
	     (index 0)
	     (len  (length text))
	     line
	     output)
	(while (and (< index len)
		    (string-match "\n" text index))
	  (setq line (substring text index (match-beginning 0)))
	  (setq output (cons line output))
	  (setq index (match-end 0)))
	(setq output (reverse output))
	output))))

;;
(defun qxt-src2str-answer (Answer)
  "Answer$BCf$N%k!<%k$d%*%V%8%'%/%H9`$J$I$NI=<(ItJ,$r%9%H%j%s%0$KJQ49$9$k!#(B
$B9=B$$OJ]B8$9$k!#(B
Answer = answer([AnswerElement, ...])
"
  (let ((AnswerElements (aref Answer 1))
	(StringAnswerElements nil))
    (while AnswerElements
      (setq StringAnswerElements (append StringAnswerElements
	   (list (qxt-src2str-answer-element (car AnswerElements)))))
      (setq AnswerElements (cdr AnswerElements)))
    (vector 'answer StringAnswerElements)))
;;
(defun qxt-src2str-answer-element (AnswerElement)
  "AnswerElement$BCf$NI=<(ItJ,$r%9%H%j%s%0$KJQ49$9$k!#(B
AnswerElement = answer_element([DotCnstr, ...],[Var_cnstr, ...],ExpVoid)
	ExpVoid = {Explanation,[{RuleId, Rule}, ...]} | '&void'

DotCnstr = String, VarCnstr = String, RuleId   = String,  Rule     = String
"
  (let ((DotCnstrs    (aref AnswerElement 1))
	(VarCnstrs    (aref AnswerElement 2))
	(ExpVoid      (aref AnswerElement 3)))
    (vector 'answer_element
	    (qxt-src2str-objects DotCnstrs)
	    (qxt-src2str-objects VarCnstrs)
	    (if (eq ExpVoid '&void)  '&void
	      (vector (qxt-src2str-explanation  (aref ExpVoid 0))
		      (qxt-src2str-ruleid-rule-pairs (aref ExpVoid 1)))))))

(defun qxt-src2str-objects (Objects)
  "\.src$B7A<0$N%*%V%8%'%/%H$N%j%9%H$r%9%H%j%s%0$N%j%9%H$KJQ49$9$k!#(B
Objects$B$O(Bqxt-lisp2qxt$B$GJ8;zNs$KJQ492DG=$J%*%V%8%'%/%H$N%j%9%H$G$"$k!#(B
"
  (let ((StringObjects nil))
    (while Objects
      (setq StringObjects
	    (append StringObjects (list (qxt-lisp2qxt (car Objects)))))
      (setq Objects (cdr Objects)))
    StringObjects))

(defun qxt-src2str-ruleid-rule-pairs (Objects)
  (let ((StringObjects nil))
    (while Objects
      (let* ((Object (car Objects))
	     (RuleId (aref Object 0))
	     (Rule   (aref Object 1)))
       	(setq StringObjects
	      (append StringObjects 
		      (list (vector RuleId (qxt-lisp2qxt Rule)))))
;;;;;;;;;;;	      (list (vector RuleId (qxt-prity-print Rule)))));;;;;
	(setq Objects (cdr Objects))))
    StringObjects))

;;
;; Explanation = UnitExplanation
;;    | merge([UnitExplanation, ...])
;;    | lookup({Subgoal,LookedS,LookingS,Explanation})
;;
(defun qxt-src2str-explanation (Explanation)
  "Explanation($B@bL@%G!<%?(B)$B$rI=<(MQ$K%G!<%?JQ49$9$k!#(B
"
  (let ((Id (aref Explanation 0)))
    (cond  ((eq Id 'merge)   (qxt-src2str-merge Explanation))
	   ((eq Id 'lookup)  (qxt-src2str-lookup Explanation))
	   (t                (qxt-src2str-unit-explanation Explanation)))))

(defun qxt-src2str-merge (Explanation)
  (let ((Objects (aref Explanation 1))
	(StringObjects nil))
    (while Objects
      (setq StringObjects
	    (append StringObjects 
		    (list (qxt-src2str-unit-explanation (car Objects)))))
      (setq Objects (cdr Objects)))
    (vector 'merge StringObjects)))

(defun qxt-src2str-lookup (Lookup)
  (let* ((Body         (aref Lookup 1))
	 (Subgoal      (aref Body 0))
	 (LookedS      (aref Body 1))
	 (LookingS     (aref Body 2))
	 (Explanation  (aref Body 3)))
    (vector 'lookup
	    (vector (qxt-lisp2qxt Subgoal)
		    LookedS
		    LookingS
		    (qxt-src2str-explanation Explanation)))))
;;
;;UnitExplanation = unit(OneRule)
;;		  | inherit({OneRule,Up,Down})
;;	Up = up([OneRule, ...]) | '&void'
;;	Down = down([OneRule, ...]) | '&void'
;;
(defun qxt-src2str-unit-explanation (UnitExplanation)
  (let ((Id   (aref UnitExplanation 0))
	(Body (aref UnitExplanation 1)))
    (if (eq Id 'unit)
	(vector 'unit (qxt-src2str-one-rule Body))
      (vector 'inherit
	      (vector
	       (qxt-src2str-one-rule (aref Body 0))
	       (let ((Up (aref Body 1)))
		 (if (eq Up '&void)
		     '&void
		   (vector 'up (qxt-src2str-one-rules (aref Up 1)))))
	       (let ((Down (aref Body 2)))
		 (if (eq Down '&void) '&void
		   (vector 'down (qxt-src2str-one-rules (aref Down 1))))))))))

(defun qxt-src2str-one-rules (Objects)
  (let ((StringObjects nil))
    (while Objects
      (setq StringObjects
	    (append StringObjects (list (qxt-src2str-one-rule (car Objects)))))
      (setq Objects (cdr Objects)))
    StringObjects))

;;
;;OneRule = reduce({Subgoal,RuleId,[Explanation, ...],Assump-list})
;;	  | fact(RuleId)
;;	  | query
;;	RuleId = String
;;	Assump-list = [Assump, ...]
;;
;;Subgoal = String
;;Assump  = String
;;
(defun qxt-src2str-one-rule (OneRule)
  (if (eq OneRule 'query)
      'query
    (if (eq 'fact (aref OneRule 0))
	OneRule
      (qxt-src2str-reduce OneRule))))

(defun qxt-src2str-reduce (OneRule)
  (let* ((Body         (aref OneRule 1))
	 (Subgoal      (aref Body 0))
	 (RuleId       (aref Body 1))
	 (Explanations (aref Body 2))
	 (Assump-list   (aref Body 3)))
    (vector 'reduce
	    (vector (qxt-lisp2qxt Subgoal)
		    RuleId
		    (qxt-src2str-explanations Explanations)
		    (qxt-src2str-objects Assump-list)))))

(defun qxt-src2str-explanations (Objects)
  (let ((StringObjects nil))
    (while Objects
      (setq StringObjects
	    (append StringObjects
		    (list (qxt-src2str-explanation (car Objects)))))
      (setq Objects (cdr Objects)))
    StringObjects))


;;
;;  session independent command
;;     qxt-set-qmacs-i-mode
;;     qxt-set-window-mode
;;     qxt-set-time-switch
;;     qxt-set-syncronous
;;     qxt-show-qmacs-mode
;;     qxt-quit
;;     qxt-reset
;;     qxt-to-message
;;     qxt-to-message-region
;;

;;
;; set window mode
;;     effects qxt-result-query
;;             qxt-result-show-lattice
;;             qxt-result-show-module-hierachy
;;
(defvar qxt-window-mode nil
  "$B%&%$%s%I%&%b!<%I$rJ];}$9$kJQ?t!#(B
use$B$O(B t$B!"(Bno use$B$O(B nil")

(defun qxt-set-window-mode(WindowMode)
  "$B%&%$%s%I%&%b!<%I$K(BWindowMode$B$r@_Dj$9$k!#(B
WindowMode = \"use\" | \"no use\"
use$B$r;XDj$9$k$H(Banswer,lattice, module_hierachy$B$NI=<($,(BX$B%&%$%s%I%&$H$J$k!#(B"
  (interactive
   (let (WindowMode)
     (setq WindowMode (completing-read "WindowMode: " 
		  '( ("no use" 1) ("use" 2) ) nil t ))
     (if (string= WindowMode "")
	 (setq WindowMode "no use"))
     (list WindowMode)))
  (if (string= WindowMode "use")
      (setq qxt-window-mode t)
    (setq qxt-window-mode nil))
  (qxt-result-reply))

;;
(defun qxt-set-time-switch (TimeSwitch)
  "$B%?%$%`%9%$%C%A$K(BTimeSwitch$B$r@_Dj$9$k!#(B
TimeSwitch = \"on\" | \"off\"
on$B$r;XDj$9$k$H!"%5!<%P!<$N<B9T;~4V$rB,Dj$9$k!#(B"
  (interactive
   (let (TimeSwitch)
     (setq TimeSwitch (completing-read "TimeSwitch: " 
		  '( ("on" 1) ("off" 2) ) nil t ))
     (if (string= TimeSwitch "")
	 (setq TimeSwitch "off"))
     (list TimeSwitch)))
  (if (string= TimeSwitch "off")
      (setq qxt-time-switch nil)
    (setq qxt-time-switch t))
  (qxt-result-reply))

;;
(defun qxt-set-synchronous (Switch)
  "$BF14|<B9T%U%i%0$K(BSwitch$B$r@_Dj$9$k!#(B
Switch = \"on\" | \"off\"
on$B$r;XDj$9$k$H!"%3%^%s%I$N<B9T$,=*N;$9$k$^$G!"F~NO$,$G$-$J$$!#(B
"
  (interactive
   (let (Switch)
     (setq Switch (completing-read "Switch: " 
		  '( ("on" 1) ("off" 2) ) nil t ))
     (if (string= Switch "")
	 (setq Switch "off"))
     (list Switch)))
  (if (string= Switch "off")
      (setq qxt-synchronous nil)
    (setq qxt-synchronous t))
  (qxt-result-reply))

;;
;; set-qmacs-i-mode effects
;;     qxt-lisp2term, qxt-create-database
;;
(defvar qxt-qmacs-i-mode nil)
(defun qxt-set-qmacs-i-mode(QmacsMode)
  "qmacs-i-mode$B$K(BQmacsMode$B$r@_Dj$9$k!#(B
QmacsMode = \"D\" | \"I\"
"
  (interactive
   (let (QmacsMode)
     (setq QmacsMode (completing-read "QmacsMode: " 
		  '( ("I" 1) ("D" 2) ) nil t ))
     (if (string= QmacsMode "")
	 (setq QmacsMode "D"))
     (list QmacsMode)))
  (if (string= QmacsMode "D")
      (setq qxt-qmacs-i-mode nil)
    (setq qxt-qmacs-i-mode t))
  (qxt-result-reply))

;;
;; show qmacs mode
;;     qxt-window-mode
;;     qxt-qmacs-i-mode
(defun qxt-show-qmacs-mode ()
  "Qmacs$B$N>uBV$rI=<($9$k!#(B"
  (interactive)
  (save-excursion
    (display-buffer qxt-result-buffer)
    (set-buffer qxt-result-buffer)
    (goto-char (point-max))
    (insert "\n** Qmacs Mode **")
    (insert "\n  Client State    : ")
    (if (eq qxt-client-state nil)
	(insert "sending ok")
      (insert (symbol-name qxt-client-state)))
    (insert "\n  Current Session : ")
    (insert (symbol-name qxt-current-session))
    (insert "\n  Time switch     : ")
    (if (eq qxt-time-switch nil)
	(insert "off")
      (insert "on"))
    (insert "\n  Synchronous     : ")
    (if (eq qxt-synchronous nil)
	(insert "off")
      (insert "on"))
    (insert "\n  Conv mode       : ")
    (insert (symbol-name qxt-conv-mode))
    (insert "\n  Window mode     : ")
    (if (eq qxt-window-mode t)
	(insert "use")
      (insert "no use"))
    (insert "\n  Qmacs I mode    : ")
    (if (eq qxt-qmacs-i-mode t)
	(insert "I")
      (insert "D"))))

;;
;; quit
;;
(defun qxt-quit (Yes)
  "Yes$B$r(Bt$B;XDj$G(BQuixote $B$r=*N;$9$k4X?t$G$"$k!#(B
Yes = t | nil
"
  (interactive
   (list (yes-or-no-p "Realy Quit ? ")))
  (if (eq Yes t)
      (progn
	(setq qxt-client-state 'expect-status)
	(qxt-process-send-string "QUIT\n")
	(while qxt-client-state
	    (accept-process-output qxt-process))
	(setq qxt-current-session 'server))))
;;
;;
(defun qxt-reset ()
  "$BDL?.%W%m%;%9$r%G%j!<%H$7!"(BQmacs$B$N>uBV$r=i4|2=$9$k!#(B"
  (interactive)
  (if (yes-or-no-p "Realy Reset ? ")
      (progn
	(if qxt-process
	    (delete-process qxt-process))
	(setq qxt-current-session 'server)
	(setq qxt-client-state nil)
	(setq qxt-server-output nil))))
;;
;; qmacs status checker
;;
(defvar qxt-current-session 'server)
(defun qxt-check-status (Session)
  "$B%3%^%s%IAw?.;~$K(BSession$B$N%A%'%C%/!"DL?.>uBV%A%'%C%/$r9T$J$&4X?t$G$"$k!#(B
$B%3%^%s%I<B9T;~$K3F4X?t$+$i8F$P$l$k!#(B
Session = 'server | 'database | 'trace | 'inspect
"
    (if (eq qxt-client-state nil)
	()
      (error "now Server executing"))
    (if (eq qxt-current-session Session)
	()
      (error "illegal command for current session")))

;; 
;; qxt-to-message command for ALL sessions(Server,Database,Trace,Inspect)
;; to_message
;;    C:to_message(ProcessName,MessageName,InputArgument,OutPutArgumentCount)
;;		ProcessName= qd | sv
;;	        MessageName= Atom,
;;        	InputArgument = Vector
;;	        OutPutArgumentCount=Integer
;;    S:result_to_message(Status,OutPutArgument)
;;
(defun qxt-to-message(ProcessName MessageName InputArgument OutputArgumentCount)
  "$B%5!<%P!<$N%W%m%;%9$K(BProcessName MessageName InputArgument
 OutputArgumentCount$B%G!<%?$rAw$k!#(B
ProcessName  = String
MessageName  = String
InputArgument = String
OutputArgumentCount = Integer
"
  (interactive "sProcessName: \nsMessageName: \nsInputArgument: \nnOutputArgumentCount: ")
  (qxt-send-command
   (concat "{to_message," ProcessName "," MessageName "," InputArgument "," OutputArgumentCount "}" )))

;;
(defun qxt-to-message-region(Start End)
  "$B%5!<%P!<$N%W%m%;%9$K(BStart$B$H(BEnd$B$N%j!<%8%g%sFb$N%G!<%?$rAw?.$9$k4X?t$G$"$k!#(B
Start = Integer (Position of region start)
End   = Integer (Position of region end)
"
  (interactive "r")
  (let ((text (buffer-substring Start End)))
    (let ((index 0)
	  (len (length text)))
      (while (and (< index len)
		  (string-match "^.*$" text index))
	(if (> len (match-end 0))  ;; last new line
	    (aset text (match-end 0) ? )
	  (aset text (- len 1) ? ))
	(setq index (1+ (match-end 0)))))
    (qxt-send-command (concat "{to_message" text "}" ))))

;;
(defun qxt-result-to-message(Result)
  "Result$B$N%5!<%P!<$N%W%m%;%9$+$i$N=PNO0z?t$rI=<($9$k!#(B"
  (let ((OutputArgument (aref Result 2)))
    (insert "\n** output argument **\n")
    (insert (qxt-lisp2term-string OutputArgument))))


(defun qxt-insert-prompt (prompt)
  (insert (format "%s> " prompt)))
