(defconst qxt-debug-mode-prompt-expression
  '(format "%s> " qxt-current-session))

(defun qxt-debug-mode ()
  "Major mode for tracing Quixote.
Quixote $B$N%H%l!<%9$N<g%b!<%I$G$9!#(B

\\{qxt-debug-mode-map}
"
  (interactive)
  (setq major-mode 'qxt-debug-mode)
  (setq mode-name "Quixote Debug")
  (use-local-map qxt-debug-mode-map)
  (run-hooks 'qxt-debug-mode-hook))

(defvar qxt-debug-mode-map nil
  "Keymap for Quixote Debug mode")

(if qxt-debug-mode-map
    ()
  (setq qxt-debug-mode-map (make-sparse-keymap))
  (define-key qxt-debug-mode-map "\t"  'qxt-debug-complete)
  (define-key qxt-debug-mode-map "\eq"  'qxt-command)
  (define-key qxt-debug-mode-map "\C-m" 'qxt-execute-this-line)
  (define-key qxt-debug-mode-map "\M-s" 'qxt-execute-step)
  (define-key qxt-debug-mode-map "\M-t" 'qxt-execute-by-trace-mode)
  )

(defun qxt-debug-complete ()
  "$B%3%s%W%j!<%7%g%s$G$9!#$&$^$/%3%s%W%j!<%7%g%s$,=PMh$?$i(B t $B$rJV$9!#(B"
  (interactive)
  (qxt-complete-for qxt-debug-command-table
		    'qxt-valid-for-current-session "^.*> "))

; qxt-set-gate-on-trace
; qxt-set-gate-all-on-trace
; qxt-execute-by-trace-mode
; qxt-execute-step
; qxt-execute-spy
; qxt-execute-notrace
; qxt-list-spy-on-trace
; qxt-inspect
; qxt-abort-trace
