/**************************************************************
 *        
 *    revision number
 *
 **************************************************************/

#include     <stdio.h>
#include     <string.h>
#include     <sys/types.h>

#define RNMAX 100
#define REVNOMAX 32767    /** add 94.5.12 by M.gouda **/
#define REVDEPTHMAX 4  /** add 94.5.12 by M.gouda **/
static char *n[RNMAX];
static short ni = 0;

/**************************************************************
 *
 *  init_revision();     
 *
 *  <input>
 *
 *  <output>
 *
 *  <description>
 *
 **************************************************************/

void init_revision()     
	{
	register i;

	for(i=0;i<ni;i++)
		{
		free(n[i]);
		}
	ni = 0;
	}

/**************************************************************
 *
 *  nr = new_revision(r);     
 *
 *  <input>
 *          char           *r      : revision number to update
 *
 *  <output>
 *          char           *nr     : new revision number
 *
 *  <description>
 *
 **************************************************************/

char *new_revision(r)     
char *r;
	{
	char *new_revisionx();
	char *c,*cw;
	int get_revision_depth();
	int p,w,d;

	rm_b(r);
        d=get_revision_depth(r);
	c = (char *)malloc(strlen(r)+16);
	if((p = dot_revision(r)) == 0)
		c[0] = 0;
	else
		strncpy(c,r,p);
	sscanf(&r[p],"%d",&w);
	if(w == REVNOMAX)
	  {
	    free(c);
	    return(NULL);
	  }
	sprintf(&c[p],"%d",w+1);

	if(find_revision(c) < 0)
		{
		cw = n[add_revision(c)];
		free(c);
		return(cw);
		}
	else
		{
		strcpy(c,r);
		if(d==REVDEPTHMAX)
		  {
		    free(c);
		    return(NULL);
		  }
		d++;  
		strcat(c,",1");

		if(find_revision(c) < 0)
			{
			cw = n[add_revision(c)];
			free(c);
			return(cw);
			}
		else
			{
			c[strlen(c)-2] = 0;
			cw = new_revisionx(c,d-1);
			free(c);
/*                if(cw!=NULL) */
			return(cw);
			}
		}
	}

static char *new_revisionx(r,d)
char *r;
int   d;
	{
	char *c,*cw;
	int p;
	c = (char *)malloc(strlen(r)+16);
	strcpy(c,r);
       	d=d+2;  
	if(d>REVDEPTHMAX)
       	  {
       	    free(c);
       	    return(NULL);
       	  }
	strcat(c,",0,1");
	if(find_revision(c) < 0)
		{
		cw = n[add_revision(c)];
		free(c);
		return(cw);
		}
	else
		{
		c[strlen(c)-2] = '\0';
		cw = new_revisionx(c,d-1);
		free(c);
		return(cw);
		}
	}

/**************************************************************
 *
 *  n = add_revision(r);     
 *
 *  <input>
 *          char           *r      : revision number
 *
 *  <output>
 *          char           n       : 0  - 
 *				     -1 - error
 *
 *  <description>
 *
 **************************************************************/

int add_revision(r)
char *r;
	{
	rm_b(r);

	if(ni < RNMAX)
		{
		n[ni] = strcpy((char *)malloc(strlen(r)+1),r);
		return(ni++);
		}
	else
		return(-1);
	}

/**************************************************************
 *
 *  n = find_revision(r);     
 *
 *  <input>
 *          char           *r      : revision number
 *
 *  <output>
 *          char           n       : >=0 - found
 *				     -1  - not found
 *
 *  <description>
 *
 **************************************************************/

int find_revision(r)
char *r;
	{
	register i;

	rm_b(r);

	for(i=0;i<ni;i++)
		{
		if(strcmp(n[i],r) == 0)
			return(i);
		}
	return(-1);
	}

/**************************************************************
 *
 *  n = dot_revision(r);     
 *
 *  <input>
 *          char           *r      : revision number
 *
 *  <output>
 *          char           n       : >0  - found
 *				     0   - not found
 *
 *  <description>
 *
 *	    search ',' backward, returns n (position of dot) + 1
 *
 **************************************************************/

int dot_revision(r)
char *r;
	{
	register i;

	rm_b(r);

	for(i = strlen(r)-1;i >= 0;i--)
		{
		if(r[i] == ',')
			return(++i);
		}
	return(0);
	}

static rm_b(r)
char *r;
	{
	register i,j,k;

	k = strlen(r);
	for(i=0,j=0;i<k;i++)
		{
		if(r[i] != ' ')
			r[j++] = r[i];
		}
	r[j] = 0;
	return(j);
	}
static int get_revision_depth(r)
char *r;
       {
        int i,j,k;
        
	k=strlen(r);
        for(i=0,j=0;i<k;i++)
	  {
	    if(r[i]==',')
	      j++;
	  }
	j++;
	return(j);
      }

/***** <<< end of  >>> *********************************/


