/**********************************************************
 *     FUNCTION TOOL MODULE
 *
 **********************************************************/

#include  <sys/types.h>
#define _SIZE_T
#include  <stdio.h>
#include  <stdlib.h>
#include  <string.h>
#include  <time.h>
#include  <fcntl.h>
#include  "pmhead.h"

/**********************************************************
 *
 * p = pm_mkdir_name(dir,r_buf)
 *
 * input : char  *dir   : original dir name
 *         char  *r_buf : changed dir name
 *
 * output : char *p : r_buf
 *
 **********************************************************/

char *pm_mkdir_name(dir,r_buf)
char *dir;
char *r_buf;
	{
	char c[128];
	register i,j,k;

	k = strlen(dir);
	for(i=0,j=0;i<k;i++)
		{
		if(dir[i] == ' ')
			continue;
		if(dir[i] == '>')
			c[j++] = '/';
		else
			c[j++] = dir[i];
		}
	c[j] = 0;

  	if(c[0] == '/')
    		sprintf(r_buf,".%s",c);
  	else if(c[0] == '.')
    		strcpy(r_buf,c);
  	else
    		sprintf(r_buf,"./%s",c);

	return(r_buf);
	}

/**********************************************************
 *
 * n = pm_sep_prm(prm,sepprm)
 *
 * input : char *prm    : input string (separated by ',')
 *         char *sepprm : output string (separated by 0)
 *
 * output : int ret : count of parameters
 *
 **********************************************************/

int pm_sep_prm(prm,sepprm)
char *prm, *sepprm;
	{
  	char *wp;	/* input buffer pointer */
	char *curp;	/* pointer (position of ',') */
	char *sepp;	/* outputbuffer pointer */
  	int i;
	wp =prm; 
  	sepp = sepprm;

	for(i = 0;(curp = opr_search_comma(wp,0)) != NULL;i++)
		{
    		if(wp[0] == '\"')
			{
      			strncpy(sepp,wp+1,(curp-2)-(wp+1));
			sepp[((curp-2)-(wp+1))] = NULL;
    			}
    		else
			{
      			strncpy(sepp,wp,(curp-1)-wp);
			sepp[((curp-1)-wp)] = NULL;
    			}
    		wp = curp;
    		sepp = ((sepp+strlen(sepp))+1);
  		}

	if(wp[0] == '\"')
		{
    		strcpy(sepp,wp+1);
    		sepp[strlen(sepp)-2] = NULL;
		i++;
  		}
  	else if(wp[0] != NULL)
		{
		strcpy(sepp,wp);
		sepp[strlen(sepp)-1] = NULL;
		i++;
  		}

	return(i);
	}

int pm_sep_prm2(prm,sepprm)
char *prm, *sepprm;
	{
  	char *wp;	/* input buffer pointer */
	char *curp;	/* pointer (position of ',') */
	char *sepp;	/* outputbuffer pointer */
  	int i;
	wp =prm; 
  	sepp = sepprm;

	for(i = 0;(curp = opr_search_comma(wp,0)) != NULL;i++)
		{
      			strncpy(sepp,wp,(curp-1)-wp);
			sepp[((curp-1)-wp)] = NULL;
    		wp = curp;
    		sepp = ((sepp+strlen(sepp))+1);
  		}

	if(wp[0] == '\"')
		{
    		strcpy(sepp,wp+1);
    		sepp[strlen(sepp)-2] = NULL;
		i++;
  		}
  	else if(wp[0] != NULL)
		{
		strcpy(sepp,wp);
		sepp[strlen(sepp)-1] = NULL;
		i++;
  		}

	return(i);
	}

/**********************************************************
 *
 * ret = pm_rep_rev(orgrev,reprev)
 *
 * input :
 *         char  *orgrev       : original revsion
 *         char  *reprev       : replaced revsion
 *
 * output :
 *         long int   ret      : 
 *
 * description :
 *   	   orgrev = [1,1,2] ---->  reprev = 1,1,2
 *
 **********************************************************/

long int pm_rep_rev(orgrev,reprev)
char *orgrev,*reprev;
	{
	register int i,j;
	long int r;
	int s;

	j = strlen(orgrev)-1;
	r = 0;
	s = 0;

	if(orgrev[j] != ']')
		return(-1);
/**	else                               update 5/6 by M.gouda 
		orgrev[j] = 0; **/

	if(orgrev[0] != '[')
		return(-1);
	else
		orgrev++;

	for(i = 0,j = 0;orgrev[i] != NULL;i++)
		{
		switch(orgrev[i])
			{
			case ',':
				reprev[j++] = ',';
				r <<= 8;
				r += s;
				s = 0;
				break;
			case ']':            /** update 5/6 by M.gouda **/
				r <<= 8;
				r += s;
				s = 0;
				reprev[j] = 0;
				break;
			case ' ':
				break;
			default:
				reprev[j++] = orgrev[i];
				s += orgrev[i] & 0x0f;
				break;
			}
		}

	return(r);
	}

/**********************************************************
 *
 * pm_mk_rev(orgrev,mkrev)
 *
 * input :
 *         char  *orgrev       : original revsion
 *         char  *mkrev        : maked revsion
 *
 * output :
 *         int   ret           : return status
 *                               0 = normal
 *                              -1 = abnormal
 *
 * description :
 *   orgrev = 1_1_2 ---->  reprev = [1,1,2]
 *
 **********************************************************/

int  pm_mk_rev(orgrev,mkrev)
char  *orgrev, *mkrev;
	{
	int i;
	char *wp;

	mkrev[0] = '[';
	wp = mkrev+1;
	for( i = 0; orgrev[i] != NULL; i++ )
		{
		if( orgrev[i] == '_' )
			wp[i] = ',';
		else
			wp[i] = orgrev[i];
		}
	wp[i++] = ']';
	wp[i++] = NULL;
	}

/**********************************************************
 *
 * pm_rep_rev(org,rep)
 *
 * input :
 *         char  *org       : original revsion
 *         char  *rep       : replaced revsion
 *
 * output :
 *         int   ret        : return status
 *                               0 = normal
 *                              -1 = abnormal
 *
 * description :
 *   orgrev = 1,1,2 ---->  reprev = [1,1,2]
 *
 **********************************************************/

int pm_add_list(org,rep)
char  *org, *rep;
	{
	strcpy(rep,"[");
	strcat(rep,org);
	strcat(rep,"]");
	}

/**********************************************************
 *
 * pm_del_list(org,rep)
 *
 * input :
 *         char  *org       : original revsion
 *         char  *rep       : replaced revsion
 *
 * output :
 *         int   ret           : return status
 *                               0 = normal
 *                              -1 = abnormal
 *
 * description :
 *   orgrev = [1,1,2] ---->  reprev = 1,1,2
 *
 **********************************************************/

int pm_del_list(org,rep)
char *org,*rep;
	{
	if( ((org[0] != '[') && (org[strlen(org)-1] != ']')) &&
	    ((org[0] != '(') && (org[strlen(org)-1] != ')')) &&
	    ((org[0] != '{') && (org[strlen(org)-1] != '}')) )
		return -1;
	strcpy(rep,org+1);
	rep[strlen(rep)-1] = NULL;
	return 0;
	}

/**********************************************************
 *
 * pm_get_date(date)
 *
 * input :
 *         char  *date     : (r) get date
 * output :
 *         char  *pnt      : pointer of date buffer
 *
 * description :
 *
 *    date = {xx,xx,xx,xx,xx,xx}
 *            |  |  |  |  |  |
 *            |  |  |  |  |  --- second
 *            |  |  |  |  ------ min
 *            |  |  |  --------- hour
 *            |  |  ------------ day
 *            |  --------------- month
 *            ------------------ year
 *
 **********************************************************/

char *pm_get_date(date)
char *date;
	{
	long tloc;
	time_t clock;	
	struct tm *tm;

	clock = time(&tloc);
	tm = localtime(&clock);

	sprintf(date,"{%i,%i,%i,%i,%i,%i}",
		     tm->tm_year,
		     tm->tm_mon + 1,
		     tm->tm_mday,
		     tm->tm_hour,
		     tm->tm_min,
		     tm->tm_sec);

	return date;
	}

/**********************************************************
 *
 * len = pm_file_read(fp,buf)
 *
 * input :
 *         FILE  *fp       : file pointer
 *         char  **buf      : (r) get data to file
 * output :
 *         int   len       : read data length
 *
 * <description>
 *     This function read data from file.
 *     if buffer length short, realloc memory.
 *
 **********************************************************/
int  pm_read_file(fp,bufx)
FILE *fp;
char **bufx;
	{
	int i;
	int cnt = 1;
	char *buf;

	buf = *bufx;

	for(i = 0;opr_read(fp,&buf[i],1) > 0; i++)
		{
		if(i == (BUF_MAX * cnt - 1))
			{
			cnt++;
			if((buf = realloc(buf,BUF_MAX * cnt)) == NULL)
				return -1;
			}
		}

	buf[i] = NULL;
	*bufx = buf;

	return i+1;
	}

/**************************************************************
 *
 *  ret = opr_cd(*pathname)
 *
 *  <input>
 *          char  *pathname : pointer of path name string
 *
 *  <output>
 *          int    ret      : return status
 *                                0 = normal end status
 *                               -1 = abnormal end status
 *
 *  <description>
 *         this function change directory for argument.
 *         when success, return normal end status(0), 
 *         else return abnormal end status(-1).
 *
 **************************************************************/

int opr_cd(pathname)
char *pathname;
	{
  	return(chdir(pathname));
	}

/**************************************************************
 *
 *  <calling sequence>
 *          ret = opr_cmnd(*command)
 *
 *  <input>
 *          char  *command : pointer of command name string
 *
 *  <output>
 *          int    ret    : return status
 *                                0 = normal end status
 *                               -1 = abnormal end status
 *
 *  <description>
 *         this function execute unix command.
 *         when success, return normal end status(0), 
 *         else return abnormal end status(-1).
 *
 **************************************************************/

int opr_cmnd(command)
char *command;
	{
  	int ret;

  	ret = system(command);
  	if(ret != STS_NORM)
    		ret = STS_ABNORM;
  	return(ret);
	}

/**************************************************************
 *
 *  <calling sequence>
 *          ret = opr_write(*fp, *data, len)     
 *
 *  <input>
 *          FILE  *fp     : file pointer
 *          char  *data   : write string to file
 *          int   len     : length of string
 *
 *  <output>
 *          int    ret    : return status
 *                                0 = normal end
 *                               -1 = abnormal end
 *
 *  <description>
 *         this function write string to file.
 *         when success ,return normal end status(0), 
 *         else return abnormal end status(-1).
 **************************************************************/

int opr_write(fp, data, len)
FILE *fp;
char *data;
size_t len;
	{
  	int ret;

  	ret = fwrite(data,sizeof(*data),len,fp);
  	if(ret == NULL) ret = STS_ABNORM;
  	return(ret);
	}

/**************************************************************
 *
 *  <calling sequence>
 *          ret = opr_read(fp, buf, len)     
 *
 *  <input>
 *          FILE   *fp     : file pointer
 *          char   *buf    : save buffer pointer for read string from file
 *          size_t len     : string length for reading
 *
 *  <output>
 *          int    ret    : return status
 *                                0 > string length
 *                               -1 = abnormal end
 *
 *  <description>
 *         this function read string from file.
 *         when read fail ,return abnormal end status.
 *         if file length shorter than "len", all file reading,
 *         and return read string length.
 *         if file length larger than "len", read only "len"
 *         and return read length.("len" = return length)
 *         before call this function,must be file open.(used "fopen"...etc)
 *
 **************************************************************/

int opr_read(fp, buf, len)
FILE *fp;
char *buf;
int len;
	{
	int ret;

	ret = fread(buf,sizeof(char),len,fp);
	if(ret == NULL) ret = -1;
	return ret;
	}
 
/**************************************************************
 *
 *  <calling sequence>
 *          p = opr_search_vstart(buf, start)     
 *
 *  <input>
 *          char           *buf    : search buffer pointer
 *          unsigned int   start   : search start point
 *
 *  <output>
 *          char           *p      : search char next point
 *                                           (not found = NULL)
 *
 *  <description>
 *         this function search "{" for buffer.
 *         search start point is argument "start".
 *         when search "{", return this pointer + 1.(next pointer)
 *         if "{" not found, return NULL.
 *
 **************************************************************/

char *opr_search_vstart(buf,start)     
char *buf;
unsigned int start;
	{
  	char *ret;
	char *curpnt;

	/*** start num check ***/
  	if((strlen(buf)) < start)
    		return(NULL);		/* start num too large */ 

	/*** make current pointer ***/
  	curpnt = (buf+start);

  	/*** search "{" ***/
  	if((ret = strchr(curpnt,'{')) == NULL) return(NULL);
	else                 		       return(ret+1);
	}

/**************************************************************
 *
 *  <calling sequence>
 *          p = opr_search_vend(buf, start)     
 *
 *  <input>
 *          char           *buf    : search buffer pointer
 *          unsigned int   start   : search start point
 *
 *  <output>
 *          char           *p      : search char next point
 *                                           (not found = NULL)
 *
 *  <description>
 *         this function search "}" for buffer.
 *         search start point is argument "start".
 *         when search "}", return this pointer + 1.(next pointer)
 *         if "}" not found, return NULL.
 * 
 *   <ex>
 *         first found
 *              |
 *       .......{..{.....}....}......}...
 *             |         |    |      |
 *           start    ignore ignore found!!(pair of first found "{")
 *************************************************************/

char *opr_search_vend(buf,start)
char *buf;
unsigned int start;
	{
  	register int i,j;
	char c;
	int stcnt = 0;		/*** found "{" counter ***/
  	char *curpnt;		/*** current pointer, return pointer ***/
  
	/*** start num check ***/
  	if(strlen(buf) < start)
		return(NULL);	/*** start num too large ***/

	/*** search "{" & "}" ***/
  	curpnt = (buf+start);
	j = strlen(curpnt);

  	for(i = 0;i < j;i++)
		{
    		c = curpnt[i];          
    		if(c == '{')
			{
			stcnt++;
			continue;	
			}
    		if(c == '}')
			{
			if(stcnt == 0) return(curpnt+(i+1));
      			else	       stcnt--;
      			}
    		}

  	return(NULL);		/*** not found ***/
	}

/**************************************************************
 *
 *  <calling sequence>
 *          p = opr_search_comma(buf, start)     
 *
 *  <input>
 *          char           *buf    : buffer
 *          unsigned int   start   : search start point
 *
 *  <output>
 *          char           *p      : search char (',') next point
 *                                           (not found = NULL)
 *
 *  <description>
 *         this function search ",".
 *         search start point is argument "start".
 *         when search ",", return this pointer + 1.(next pointer)
 *         if "," not found, return NULL.
 **************************************************************/

char *opr_search_comma(buf, start)     
char *buf;
unsigned int start;
	{
	char *curpnt ;
	register i,len;
  	int vcnt = 0;		/* '{' flag */
 	int lcnt = 0;		/* '[' flag */
	int ccnt = 0;		/* '(' flag */

	/*** start num check ***/
  	if(strlen(buf) < start)
    		return(NULL);	/*** start num too large ***/

	/*** make current pointer ***/
  	curpnt = (buf+start);

	/*** search ***/
  	len = strlen(curpnt);
  	for(i = 0;i < len;i++)
		{
		/*** search " ***/
    		if(curpnt[i] == '\"')
			{
			for(i++;i < len;i++)
				if(curpnt[i] == '\"') break;
			if(i < len) continue;
			else	    break;
			}

		/*** search ' ***/
    		if(curpnt[i] == '\'')
			{
			for(i++;i < len;i++)
				if(curpnt[i] == '\'') break;
			if(i < len) continue;
			else	    break;
			}

		/*** search "{" ***/
    		if(curpnt[i] == '{')
			{
			vcnt++;
			continue;
			}
		/*** search "}" ***/
    		if(curpnt[i] == '}')
			{
			if(vcnt > 0) vcnt--;
			continue;
    			}

		/*** search "[" ***/
    		if(curpnt[i] == '[')
			{
			lcnt++;
			continue;
			}
		/*** search "]" ***/
    		if(curpnt[i] == ']')
			{
			if(lcnt > 0) lcnt--;
			continue;
    			}

		/*** search "(" ***/
    		if(curpnt[i] == '(')
			{
			ccnt++;
			continue;
			}
		/*** search ")" ***/
    		if(curpnt[i] == ')')
			{
			if(ccnt > 0) ccnt--;
			continue;
    			}

		/*** search "," ***/
		if(curpnt[i] == ',')
			{
         		if((vcnt == 0) && (lcnt == 0) && (ccnt == 0))
	   			return(curpnt+(i+1));
    			}
    		}

  	return(NULL);		/*** not found ***/
	}

/************************************************
 *  
 *  <calling sequence>
 *          pm_check_file_exist(name)   
 *
 *  <input>
 *          char           *name :file name
 *
 *  <output>
 *         int   1,-1
 *  <description>
 *         this function 
 *         check whether file exist
 *         if return 1,otherwise  return -1.
*************************************************/
pm_check_file_exist(fname)   /*ADD  94.04.28 by M.gouda */
char *fname ;
{
  int fd;
  if((fd=open(fname,O_RDONLY,0))==-1)
     return -1;
  else
   {   close(fd);
      return 1;
     }
}

/*** <<< END OF PMTOOL.C >>> ***********************/









