#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <memory.h>

#include "pmhead.h"

/**********************************************************
 *
 * module name : get_text_DB()
 *
 * input :
 *
 * output :
 *
 **********************************************************/

void get_text_DB(buf)
char *buf;
	{
	char *dirs;		/* Dirs = [Dir,...] */
	char *DB_name;		/* DB_name */
	char *VerNO1;		/* VerNO1 */

	char dirs2[80];		/* dirs -> strings */

	char *wp;		/* work pointer */
	char wbuf[80];		/* work buffer */
	char *curp;		/* current directory pointer */
	unsigned int dircnt;	/* directory count to check */

	char *DBqxt;		/* buffer for .txt */
	int DBqxtcnt;		/* size of DBqxt */

	FILE  *fp;

	char VerNO2[80];	/* version number in cntrl file */
	char DB_name2[40];	/* data base name in cntrl file */

	/*** parameter set *************************************/
	if(pm_sep_prm(buf,prm_buf) != 3)
		{
		strcpy(wr_data,"{'result_get_text_DB',");
		strcat(wr_data,"{abnormal,\"invalid prm\"},");
		strcat(wr_data,"\'&void\',");
		strcat(wr_data,"\'&void\',");
		strcat(wr_data,"\'&void\',");
		strcat(wr_data,"done}");
/*		write(sn,wr_data,strlen(wr_data)); */
		return;
		}

	dirs = (prm_buf+1);                      /* get dirs */
	DB_name = ((dirs+strlen(dirs))+1);       /* get DB_name */
	VerNO1 = (DB_name+strlen(DB_name))+1;	 /* get VerNO1 */
  
	/*** execute *******************************************/
	dircnt = pm_sep_prm(dirs,dirs2);
	curp = dirs2;

	for(;;)
		{
		if(dircnt == 0)		/* error response */
			{
			strcpy(wr_data,"{'result_get_text_DB',");
			strcat(wr_data,"{abnormal,\"not found\"},");
			strcat(wr_data,"\'&void\',");
			strcat(wr_data,"\'&void\',");
			strcat(wr_data,"\'&void\',");
			strcat(wr_data,"done}");
/* 			write(sn,wr_data,strlen(wr_data)); */
			return;
			}

		/*** change dir ***/
		pm_mkdir_name(curp,wbuf);
		if(opr_cd(wbuf) == -1)
			{
			dircnt--;
			curp += (strlen(curp)+1);
			continue;
			}

		/*** cd DB_name.db ***/
		sprintf(wbuf,"%s.db",DB_name);
		if(opr_cd(wbuf) == -1)
			{
			dircnt--;
			curp += (strlen(curp)+1);
			opr_cd(cur_dir);
			continue;
			}

		/*** search "cntrl" ***/
		if((fp = fopen("cntrl","r")) == NULL)
			{
			curp += (strlen(curp)+1);
			dircnt--;
			opr_cd(cur_dir);
			continue;
			}
		if(strcmp(VerNO1,"\'&void\'") == 0)
			{
			/* skip first line */
			fgets(VerNO2,sizeof(VerNO2),fp);

			while(fgets(VerNO2,sizeof(VerNO2),fp))
				{
				if(VerNO2[0] == 'd') continue;
				strcpy(VerNO1,VerNO2+1);
				}
			}
		fclose(fp);

		break;
		}

	/*** search ".qxt" file ***/
    	sprintf(wbuf,"%s.qxt",VerNO1);
	if((fp = fopen(wbuf,"r")) == NULL)
		{
		strcpy(wr_data,"{'result_get_text_DB',");
		strcat(wr_data,"normal,");
		strcat(wr_data,"\'&void\',");
		strcat(wr_data,"\'&void\',");
		strcat(wr_data,"\'&void\',");
		strcat(wr_data,"done}");
/*		write(sn,wr_data,strlen(wr_data)); */
      		opr_cd(cur_dir);
		return;
    		}

	/*** read ".qxt" file ***/
	if((DBqxt = calloc(1,BUF_MAX)) == NULL)
		{
		strcpy(wr_data,"{'result_get_text_DB',");
		strcat(wr_data,"{abnormal,\"memory shortage\"},");
		strcat(wr_data,"\'&void\',");
		strcat(wr_data,"\'&void\',");
		strcat(wr_data,"\'&void\',");
		strcat(wr_data,"done}");
/* 		write(sn,wr_data,strlen(wr_data)); */
		opr_cd(cur_dir);
		return;
		}

	if((DBqxtcnt = pm_read_file(fp,&DBqxt)) == -1)
		{
		fclose(fp);
		strcpy(wr_data,"{'result_get_text_DB',");
		strcat(wr_data,"{abnormal,\"pm_server err\"},");
		strcat(wr_data,"\'&void\',");
		strcat(wr_data,"\'&void\',");
		strcat(wr_data,"\'&void\',");
		strcat(wr_data,"done}");
/*		write(sn,wr_data,strlen(wr_data)); */
		opr_cd(cur_dir);
		return;
		}

	fclose(fp);

	if((wp = realloc(wr_data,DBqxtcnt+1024)) == NULL)
		{
		strcpy(wr_data,"{'result_get_text_DB',");
		strcat(wr_data,"{abnormal,\"memory shortage\"},");
		strcat(wr_data,"\'&void\',");
		strcat(wr_data,"\'&void\',");
		strcat(wr_data,"\'&void\',");
		strcat(wr_data,"done}");
/*		write(sn,wr_data,strlen(wr_data)); */
		opr_cd(cur_dir);
		return;
		}
	wr_data = wp;

	/*** response *******************************************/
	sprintf(wr_data,
		"{'result_get_text_DB',normal,%s,{%s},\"%s\",done}",
		VerNO1,
		DBqxt,
		curp);
/*	write(sn,wr_data,strlen(wr_data)); */
    
	/*** change directory ***********************************/
	opr_cd(cur_dir);
	}

/**********************************************************
 *
 * module name : get_DB()
 *
 * input :
 *
 * output :
 *
 **********************************************************/

void get_DB(buf)
char *buf;
	{
	char *dirs;		/* Dirs = [Dir,...] */
	char *DB_name;		/* DB_name */
	char *VerNO1;		/* {VerNO,RevNO} */
	char *RevNO1;		/* RevNO = [RevNO_ele,...] */

	char dirs2[80];		/* dirs -> strings */
	char RevNO2[80];	/* RevNO1 -> strings */
	long int RevNO;		/* RevNO1 -> long integer */

	char *wp;		/* work pointer */
	char wbuf[80];		/* work buffer */
	char *curp;		/* current directory pointer */
	unsigned int dircnt;	/* directory count to check */

	char *DBsrc;		/* buffer for .src */
	char *DBobj;		/* buffer for .obj */
	int DBcnt = 0;		/* size of DBsrc,DBobj */

	FILE  *fp;

	/*** parameter set *************************************/
	if(pm_sep_prm(buf,prm_buf) != 3)
		{
		strcpy(wr_data,"{'result_get_DB',");
		strcat(wr_data,"{abnormal,\"invalid prm\"},");
		strcat(wr_data,"{\'&void\',\'&void\'},");
		strcat(wr_data,"\'&void\',");
		strcat(wr_data,"done}");
/*		write(sn,wr_data,strlen(wr_data)); */
		return;
		}

	dirs = (prm_buf+1);                      /* get dirs */
	DB_name = ((dirs+strlen(dirs))+1);       /* get DB_name */
	wp = ((DB_name+strlen(DB_name))+1);
	VerNO1 = opr_search_vstart(wp,0);        /* get VerNO1 */
	wp = opr_search_comma(VerNO1,0);
	wp[-1] = NULL;
	RevNO1 = wp;                             /* get RevNO1 */
	RevNO1[strlen(RevNO1)-1] = NULL;

	if((!strcmp(VerNO1,"\'&void\'")) || (!strcmp(RevNO1,"\'&void\'")))
		{
		strcpy(wr_data,"{'result_get_DB',");
		strcat(wr_data,"{abnormal,\"invalid prm\"},");
		strcat(wr_data,"{\'&void\',\'&void\'},");
		strcat(wr_data,"\'&void\',");
		strcat(wr_data,"done}");
/*		write(sn,wr_data,strlen(wr_data)); */
		return;
		}

	/*** execute *******************************************/
	dircnt = pm_sep_prm(dirs,dirs2);
	curp = dirs2;

	for(;;)
		{
		if(dircnt == 0)		/* error response */
			{
			strcpy(wr_data,"{'result_get_DB',");
			strcat(wr_data,"{abnormal,\"not found\"},");
			strcat(wr_data,"{\'&void\',\'&void\'},");
			strcat(wr_data,"\'&void\',");
			strcat(wr_data,"done}");
/*			write(sn,wr_data,strlen(wr_data)); */
			return;
			}

		/*** change dir ***/
		pm_mkdir_name(curp,wbuf);
		if(opr_cd(wbuf) == -1)
			{
			dircnt--;
			curp += (strlen(curp)+1);
			continue;
			}

		/*** cd DB_name.db ***/
		sprintf(wbuf,"%s.db",DB_name);
		if(opr_cd(wbuf) == -1)
			{
			dircnt--;
			curp += (strlen(curp)+1);
			opr_cd(cur_dir);
			continue;
			}

		break;
		}

	/*** search ".src" file ***/
	RevNO = pm_rep_rev(RevNO1,RevNO2);
	sprintf(wbuf,"%s_%ld.src",VerNO1,RevNO);
	if((fp = fopen(wbuf,"r")) == NULL)
		{
		wp = "\'&void\'";
		DBsrc = strcpy((char *)malloc(strlen(wp)+1),wp);
		}
	else
		{
		if((DBsrc = calloc(1,BUF_MAX)) == NULL)
			{
			fclose(fp);
			printf("pm_server: memory alloc\n");
			strcpy(wr_data,"{'result_get_DB',");
			strcat(wr_data,"{abnormal,\"pm_server err\"},");
			strcat(wr_data,"{\'&void\',\'&void\'},");
			strcat(wr_data,curp);
			strcat(wr_data,",done}");
/* 			write(sn,wr_data,strlen(wr_data)); */
			opr_cd(cur_dir);
			return;
			}  
		if((DBcnt += pm_read_file(fp,&DBsrc)) <= 0)
			{
			fclose(fp);
			printf("pm_server: realloc\n");
			strcpy(wr_data,"{'result_get_DB',");
			strcat(wr_data,"{abnormal,\"pm_server err\"},");
			strcat(wr_data,"{\'&void\',\'&void\'},");
			strcat(wr_data,curp);
			strcat(wr_data,",done}");
/*			write(sn,wr_data,strlen(wr_data)); */
			opr_cd(cur_dir);
			return;
			}  
		fclose(fp);
		}

	/*** search ".obj" file ***/
	sprintf(wbuf,"%s_%ld.obj",VerNO1,RevNO);
	if((fp = fopen(wbuf,"r")) == NULL)
		{
		wp = "\'&void\'";
		DBobj = strcpy((char *)malloc(strlen(wp)+1),wp);
		}
	else
		{
		if((DBobj = calloc(1,BUF_MAX)) == NULL)
			{
			fclose(fp);
			printf("pm_server: memory alloc\n");
			strcpy(wr_data,"{'result_get_DB',");
			strcat(wr_data,"{abnormal,\"pm_server err\"},");
			strcat(wr_data,"{\'&void\',\'&void\'},");
			strcat(wr_data,curp);
			strcat(wr_data,",done}");
/*			write(sn,wr_data,strlen(wr_data));*/
			opr_cd(cur_dir);
			return;
			}  
		if((DBcnt += pm_read_file(fp,&DBobj)) <= 0)
			{
			fclose(fp);
			printf("pm_server: realloc\n");
			strcpy(wr_data,"{'result_get_DB',");
			strcat(wr_data,"{abnormal,\"pm_server err\"},");
			strcat(wr_data,"{\'&void\',\'&void\'},");
			strcat(wr_data,curp);
			strcat(wr_data,",done}");
/*			write(sn,wr_data,strlen(wr_data)); */
			opr_cd(cur_dir);
			return;
			}  
		fclose(fp);
		}

	if((wp = realloc(wr_data,DBcnt+1024)) == NULL)
		{
		strcpy(wr_data,"{'result_get_DB',");
		strcat(wr_data,"{abnormal,\"memory shortage\"},");
		strcat(wr_data,"{\'&void\',\'&void\'},");
		strcat(wr_data,"\'&void\',");
		strcat(wr_data,"done}");
/*		write(sn,wr_data,strlen(wr_data)); */
		opr_cd(cur_dir);
		return;
		}
	wr_data = wp;

	sprintf(wr_data,"{'result_get_DB',normal,{%s,%s},\"%s\",done}",
			DBsrc,DBobj,curp);
/*	free(DBsrc);
	free(DBobj);
*/
	/*** response *******************************************/
/*	write(sn,wr_data,strlen(wr_data)); */

	opr_cd(cur_dir);
/*	if((strlen(wr_data)) > BUF_MAX)
		realloc(wr_data,BUF_MAX); */
	}

/**********************************************************
 *
 * module name : get_last_version()
 *
 * input :
 *
 * output :
 *
 **********************************************************/
void get_last_version(buf)
char *buf;
	{
	char *dirs;		/* Dirs = [Dir,...] */
	char *DB_name;		/* DB_name */
	char *VerNO1;		/* {VerNO,RevNO} */
	char *RevNO1;		/* RevNO = [RevNO_ele,...] */

	char dirs2[128];	/* dirs -> strings */
	char VerNO2[80];	/* */
	char RevNO2[80];	/* RevNO1 -> strings */

	char *wp;		/* work pointer */
	char wbuf[1024];	/* work buffer */
	char *curp;		/* current directory pointer */
	unsigned int dircnt;	/* directory count to check */

	FILE  *fp;

	/*** parameter set *************************************/
	if(pm_sep_prm(buf,prm_buf) != 3)
		{
		strcpy(wr_data,"{result_get_last_version,");
		strcat(wr_data,"{abnormal,\"invalid prm\"},");
		strcat(wr_data,"{\'&void\',\'&void\'},");
		strcat(wr_data,"\'&void\',");
		strcat(wr_data,"done}");
/*		write(sn,wr_data,strlen(wr_data)); */
		return;
		}

	dirs = (prm_buf+1);                      /* get dirs */
	DB_name = ((dirs+strlen(dirs))+1);       /* get DB_name */
	VerNO1 = ((DB_name+strlen(DB_name))+1);  /* get VerNO1 */

	/*** execute *******************************************/
	dircnt = pm_sep_prm(dirs,dirs2);
	curp = dirs2;
  
	for(;;)
	    {
	    if( dircnt == 0 )
		{			/* no DB */
		strcpy(wr_data,"{result_get_last_version,");
		strcat(wr_data,"normal,");
		strcat(wr_data,"{\'&void\',\'&void\'},");
		strcat(wr_data,"\'&void\',");
		strcat(wr_data,"done}");
/*		write(sn,wr_data,strlen(wr_data)); */
		return;
		}

	    /*** change dir ***/
	    pm_mkdir_name(curp,wbuf);
	    if(opr_cd(wbuf) == -1)
		{
		dircnt--;
		curp += (strlen(curp)+1);
		continue;
		}

	    /*** cd DB_name.db ***/
	    sprintf(wbuf,"%s.db",DB_name);
	    if(opr_cd(wbuf) == -1)
		{
		dircnt--;
		curp += (strlen(curp)+1);
		opr_cd(cur_dir);
		continue;
		}

	    break;
	    }

	/*** check "cntrl" ***/
	if( (fp = fopen("cntrl","r")) == NULL )
		{
		strcpy(wr_data,"{result_get_last_version,");
		strcat(wr_data,"abnormal(\"invalid DB\"),");
		strcat(wr_data,"{\'&void\',\'&void\'},");
		strcat(wr_data,"\'&void\',");
		strcat(wr_data,"done}");
/*		write(sn,wr_data,strlen(wr_data)); */
		opr_cd(cur_dir);
		return;
		}

	/* get version number */
	fgets(VerNO2,sizeof(VerNO2),fp);	/* skip first line */
	while(fgets(wbuf,sizeof(wbuf),fp))
		{
		if(wbuf[0] == ' ')
			strcpy(VerNO2,&wbuf[1]);
		}
	VerNO2[strlen(VerNO2)-1] = NULL;	/* delete crlf */

	if(strcmp(VerNO1,"\'&void\'") != 0)
		strcpy(VerNO2,VerNO1);

	/*** check ".cntrl" ***/
	sprintf(wbuf,"%s.cntrl",VerNO2);
	if( (fp = fopen(wbuf,"r")) == NULL )
		{
		strcpy(wr_data,"{result_get_last_version,");
		strcat(wr_data,"{abnormal,\"invalid DB\"},");
		strcat(wr_data,"{\'&void\',\'&void\'},");
		strcat(wr_data,"\'&void\',");
		strcat(wr_data,"done}");
/*		write(sn,wr_data,strlen(wr_data)); */
		opr_cd(cur_dir);
		return;
		}

	/* get revision number */
	fgets(wbuf,sizeof(wbuf),fp);	/* skip 3 lines */
	fgets(wbuf,sizeof(wbuf),fp);
	fgets(wbuf,sizeof(wbuf),fp);
	while(fgets(wbuf,sizeof(wbuf),fp))
		{
		strcpy(RevNO2,wbuf);
                fgets(wbuf,sizeof(wbuf),fp);
		}
	RevNO2[strlen(RevNO2)-1] = NULL;	/* delete crlf */

	sprintf(wr_data,
		"{result_get_last_version,normal,{%s,[%s]},\"%s\",done}",
		VerNO2,
		RevNO2,
		curp);

	/*** response *******************************************/
/*	write(sn,wr_data,strlen(wr_data)); */
  
	/*** change directory ***********************************/
	opr_cd(cur_dir);
	}

