;;
;; % emacs -batch -l tty.el file-to-be-create-database.qxt
;;
(load-file "/db/Quixote/v3/SS/lib/emacs/qxt-all.el")

(defun read-query ()
  "Read query from user, until input end `.'.
Returns entire string."
  (let ((prompt "?- ")
	str
	done
	result)
    (while (not done)
      (setq str (read-string prompt))
      (setq prompt "> ")
      (if (eq (aref str (1- (length str))) ?\.)
	  (setq done t))
      (setq result (cons str result)))
    (mapconcat '(lambda (a) a) (reverse result) "\n")))

(setq qxt-synchronous t)
;;(setq qxt-inferior-qxt-program nil)

(qxt-start nil)

;;
;; ("emacs" "-l" "tty.el" "file-to-be-create-database.qxt")
;;
(let ((database-file (nth 3 command-line-args))
      name)
  (find-file-read-only database-file)
  (setq name (file-name-nondirectory buffer-file-name))
  (setq name (substring name 0 (string-match "\\." name)))
  (qxt-create-database (point-min) (point-max) name))

(set-buffer qxt-result-buffer)

(let (query)
  (while 1
    (erase-buffer)
    (setq query (read-query))
    (qxt-query-string (concat "?-" query))
    (message (buffer-string))))
