(defun qxt-mode ()
  "Major mode for Quixote session.
\\{qxt-mode-map}
"
  (interactive)
  (setq major-mode 'qxt-mode)
  (setq mode-name "Quixote")
  (use-local-map qxt-mode-map)
  (run-hooks 'qxt-mode-hook))

(defvar qxt-mode-map nil
  "Keymap for Quixote mode")

(if qxt-mode-map
    ()
  (setq qxt-mode-map (make-sparse-keymap))
  (define-key qxt-mode-map "\C-c\C-b" 'qxt-create-database-buffer)
  (define-key qxt-mode-map "\C-c\C-s" 'qxt-start)
  (define-key qxt-mode-map "\C-c\C-z" 'qxt-quit)
  (define-key qxt-mode-map "\C-c\C-c" 'qxt-close-database)
  (define-key qxt-mode-map "\C-c\C-q" 'qxt-query-this-query)
  (define-key qxt-mode-map "\C-c\C-r" 'qxt-create-database))

(defun qxt-create-database-buffer (database-name)
  ""
  (interactive "sDatabaseName: ")
  (if qxt-process
      (qxt-create-database (point-min) (point-max) database-name)
    (let ((qxt-synchronous t)) (qxt-start nil))
    (qxt-create-database (point-min) (point-max) database-name) ))

;; comm.el $B$KF~$C$F$$$k$,(B, qxt-mode $B$+$i(B qxt $B$r(B start $B$9$k$?$a$KI,MW!#(B
(defvar qxt-process nil "Communication Channel to Quixote Server
Quixote Server $B$H$NDL?.(B channel $B$r2!$($F$$$kJQ?t!#(B
$BF~$kCM$O(B Emacs $B$N(B Process.")
(defvar qxt-synchronous nil
  "$BF14|<B9T$9$k$+$I$&$+$N%9%$%C%A!#(Bnil $B$N$H$-(B off. $B$=$l0J30$N;~(B on.")

