/* ---------------------------------------------------------- 
%   (C)1994 Institute for New Generation Computer Technology 
%       (Read COPYRIGHT for detailed information.) 
----------------------------------------------------------- */
#include <stdlib.h>
#include <math.h>
#include <stdio.h>

#include "quant2.h"


int lda(DATA_SET *data_set1, DATA_SET *data_set2, DATA_SET *data_set, 
	float *dist, unsigned long n1, unsigned long n2, 
	unsigned long n, unsigned long num_p)
{

    /* n1$@8D(J,n2$@8D$N<BB,CM%G!<%?(J */
    float **data1;
    float **data2;
    float **data;

    /* $@72(J1,2$@$NJQNL$NJ?6Q(J */
    float *av1;
    float *av2;

    /* $@AmJ?6Q(J */
    float *av;

    /* $@J?6QCM$N:9(J */
    float *d;

    /* $@72(J1,2$@$NJ,;6!&6&J,;69TNs(J */
    float **s1;
    float **s2;

    /* $@A4$F$NJ,;6!&6&J,;69TNs(J */
    float **v;

    /* $@@~7AH=JL4X?t$N78?t(J */
    float *x;

    /* $@ItJ,%T%]%C%HA*Br$N:]$N9T8r49>pJs$r5-O?(J */
    int *index;

    /* $@9T8r492s?t(J(1:$@6v?t2s(J, -1:$@4q?t2s(J) */
    float count;

    /* $@72(J1,2$@$N%5%s%W%k3F!9$NH=JL4X?t$K$h$C$FM?$($i$l$k%9%3%"(J */
    float *score1, *score2, *score;

    /* $@72(J1,2$@$N%5%s%W%k$GH=JL4X?t$K$h$C$F@5$7$/H=JL$G$-$?%5%s%W%k$N?t(J */
    int right_n1 = 0;
    int right_n2 = 0;

    /* $@72(J1,2$@$N%5%s%W%k$K4X$9$kH=JL4X?t$K$h$kH=JLN((J */
    float right1;
    float right2;

    /* $@Am9gH=JLN((J */
    float right;


    float discrim_func(float *, float *, float *, int);
    float mahalanobis(float *, float *, int);

    void ludcmp(float **a, int n, int *indx, float *d);
    void lubksb(float **a, int n, int *indx, float b[]);

    int print_matrix(float **, int, int);
    int print_vector(float *, int);
    float average(float *, int);
    float variance(float *, float, float *, float, int);
    int vector_plus(float *, float *, int, float *);
    int vector_times(float *, float, int, float *);
    int matrix_plus(float **, float **, int, int, float **);
    int matrix_times(float **, float, int, int, float **);
 
    float **matrix(long, long, long, long);
    void free_matrix(float **, long, long, long, long);

    int i, j, k;
    float *dum1, *dum10, *dum11;
    float *dum2, *dum20, *dum21;
    float *dum_vec, **dum_mat;


    /* $@%a%b%j$N3NJ](J */
    data1 = (float**) matrix((long) 1, (long) n1, (long) 1, (long) num_p);
    data2 = (float**) matrix((long) 1, (long) n2, (long) 1, (long) num_p);
    av = (float*) vector((long) 1, (long) num_p);
    av1 = (float*) vector((long) 1, (long) num_p);
    av2 = (float*) vector((long) 1, (long) num_p);
    d = (float*) vector((long) 1, (long) num_p);
    dum1 = (float*) vector((long) 1, (long) n1);
    dum10 = (float*) vector((long) 1, (long) n1);
    dum11 = (float*) vector((long) 1, (long) n1);
    dum2 = (float*) vector((long) 1, (long) n2);
    dum20 = (float*) vector((long) 1, (long) n2);
    dum21 = (float*) vector((long) 1, (long) n2);
    s1 = (float**) matrix((long) 1, (long) num_p, (long) 1, (long) num_p);
    s2 = (float**) matrix((long) 1, (long) num_p, (long) 1, (long) num_p);
    v = (float**) matrix((long) 1, (long) num_p, (long) 1, (long) num_p);
    dum_vec = (float*) vector((long) 1, (long) num_p);
    dum_mat = (float**) matrix((long) 1, (long) num_p, (long) 1, (long) num_p);
    x = (float*) vector((long) 1, (long) num_p);
    score1 = (float*) vector((long) 1, (long) n1);
    score2 = (float*) vector((long) 1, (long) n2);

    /* float *, float **$@7?0J30$O<+J,$G3NJ](J */
    if((index = (int *) calloc (num_p+1, sizeof(int))) == NULL)
	{
	    fprintf(stderr, "not enought memory...\n");
	    return(-1);
	}

    /* $@%G!<%?%U%!%$%k$N%3%T!<(J */
    for(i = 1; i <= n1; i++)
	{
	    data1[i][1] = (data_set1 + i) -> score;
	}
    for(i = 1; i <= n2; i++)
	{
	    data2[i][1] = (data_set2 + i) -> score;
	}

    /* $@3F72$K$*$1$k3FJQNL$NJ?6Q$r;;=P(J */
    fprintf(stderr, "--- calculating average of group1...\n");
    for(i = 1; i <= num_p; i++)
	{
	    for(j = 1; j <= n1; j++)
		{
		    dum1[j] = data1[j][i];
		}
	    av1[i] = average(dum1, n1);
	}
    /* print_vector(av1, num_p); */
    fprintf(stderr, "--- calculating average of group2...\n");
    for(i = 1; i <= num_p; i++)
	{
	    for(j = 1; j <= n2; j++)
		{
		    dum2[j] = data2[j][i];
		}
	    av2[i] = average(dum2, n2);
	}
    /* print_vector(av2, num_p); */

    /* $@3F72$K$*$1$kJQNL$K4X$9$kJ,;6!&6&J,;69TNs$r;;=P(J */
    fprintf(stderr, "--- calculating variance matrix of group1...\n");
    for(i = 1; i <= num_p; i++)
	{
	    for(k = 1; k <= n1; k++)
		{
		    dum10[k] = data1[k][i];
		}
	    for(j = 1; j <= num_p; j++)
		{
		    for(k = 1; k <= n1; k++)
			{
			    dum11[k] = data1[k][j];
			}
		    s1[i][j] = variance(dum10, av1[i], dum11, av1[j], n1);
		}
	}
    /* print_matrix(s1, num_p, num_p); */
    fprintf(stderr, "--- calculating variance matrix of group2...\n");
    for(i = 1; i <= num_p; i++)
	{
	    for(k = 1; k <= n2; k++)
		{
		    dum20[k] = data2[k][i];
		}
	    for(j = 1; j <= num_p; j++)
		{
		    for(k = 1; k <= n2; k++)
			{
			    dum21[k] = data2[k][j];
			}
		    s2[i][j] = variance(dum20, av2[i], dum21, av2[j], n2);
		}
	}
    /* print_matrix(s2, num_p, num_p); */

    /* $@ITMW$J%a%b%j$N2rJ|(J */
    free_vector(dum1, (long) 1, (long) n1);
    free_vector(dum10, (long) 1, (long) n1);
    free_vector(dum11, (long) 1, (long) n1);
    free_vector(dum2, (long) 1, (long) n2);
    free_vector(dum20, (long) 1, (long) n2);
    free_vector(dum21, (long) 1, (long) n2);

    /* $@AmJ?6Q$r;;=P(J */
    fprintf(stderr, "--- calculating average of all groups...\n");
    vector_plus(av1, av2, num_p, dum_vec);
    vector_times(dum_vec, 0.5, num_p, av);
    /* print_vector(av, num_p); */

    /* $@J?6QCM$N:9$r;;=P(J */
    fprintf(stderr, "--- calculating differences of averages...\n");
    vector_times(av2, -1.0, num_p, dum_vec);
    vector_plus(av1, dum_vec, num_p, d);
    /* print_vector(d, num_p); */

    /* $@A4$F$NJ,;6!&6&J,;69TNs$r;;=P(J */
    fprintf(stderr, "--- calculating variance matrix of all groups...\n");
    matrix_plus(s1, s2, num_p, num_p, dum_mat);
    matrix_times(dum_mat, 1.0 / ((float) n1+n2-2), num_p, num_p, v);
    /* print_matrix(v, num_p, num_p); */

    /* $@@~7AH=JL4X?t$NDj?t$r;;=P(J */
    fprintf(stderr, "--- calculating constants of LDF...\n");
    vector_times(d, 1.0, num_p, x);
    matrix_times(v, 1.0, num_p, num_p, dum_mat);
    ludcmp(v, num_p, index, &count);
    lubksb(v, num_p, index, x);
    printf("# constants of LDF are...\n# ");
    print_vector(x, num_p);


    /* $@H=JL4X?t$rMQ$$$F%5%s%W%k%;%C%H$rI>2A(J */
    fprintf(stderr, "--- evaluating samples of group1...\n");
    printf("# --- sample scores of group1...\n");
    for(i = 1; i <= n1; i++)
	{
	    for(j = 1; j <= num_p; j++)
		{
		    dum_vec[j] = data1[i][j];
		}
	    score1[i] = discrim_func(x, dum_vec, av, num_p);
	    if(score1[i] >= 0.0)
		{
		    /*
		    printf("%s:%s\t%13.7f\to\n", 
			   (data_set1 + i) -> source,
			   (data_set1 + i) -> position, score1[i]);
			   */
		    right_n1++;
		}
	    else
		{
		    /*
		    printf("%s:%s\t%13.7f\tx\n", 
			   (data_set1 + i) -> source,
			   (data_set1 + i) -> position, score1[i]);
			   */
		}
	}
    right1 = ((float) right_n1) / ((float) n1);
    printf("\tright of group1 = %d / %d = %8.6f\n", right_n1, n1, right1);
    fprintf(stderr, "--- evaluating samples of group2...\n");
    printf("# --- sample scores of group2...\n");
    for(i = 1; i <= n2; i++)
	{
	    for(j = 1; j <= num_p; j++)
		{
		    dum_vec[j] = data2[i][j];
		}
	    score2[i] = discrim_func(x, dum_vec, av, num_p);
	    if(score2[i] < 0.0)
		{
		    /*
		    printf("%s:%s\t%13.7f\to\n", 
			   (data_set2 + i) -> source,
			   (data_set2 + i) -> position, score2[i]);
			   */
		    right_n2++;
		}
	    else
		{
		    /*
		    printf("%s:%s\t%13.7f\tx\n", 
			   (data_set2 + i) -> source,
			   (data_set2 + i) -> position, score2[i]);
			   */
		}
	}
    right2 = ((float) right_n2) / ((float) n2);
    printf("\tright of group2 = %d / %d = %8.6f\n", right_n2, n2, right2);
    fprintf(stderr, "--- evaluating all samples...\n");
    right = 0.50 * (((float) right_n1) / ((float) n1)
		    + ((float) right_n2) / ((float) n2));
    printf("right of total = %8.6f\n", right);


    /* 2$@724V$N%^%O%i%N%S%9J?J}5wN%$r;;=P(J */
    fprintf(stderr, "--- calculating mahalanobis distance...\n");
    *dist = mahalanobis(x, d, num_p);
    printf("mahalanobis distance (Dp^2) = %13.7f\n", *dist);
    printf("                     (Dp)   = %13.7f\n", sqrt(*dist));
    printf("                     (Dp/2) = %13.7f\n", sqrt(*dist)/2.0);


    /* $@%F%9%HMQ$NG[Ns$,$"$l$PI>2A$9$k(J */
    if(data_set != NULL)
	{
	    fprintf(stderr, "--- evaluating test sequences...\n");
	    printf("# --- sample scores of test sequences...\n");

	    data = (float**) matrix((long) 1, (long) n, 
				    (long) 1, (long) num_p);
	    score = (float*) vector((long) 1, (long) n);

	    for(i = 1; i <= n; i++)
		{
		    data[i][1] = (data_set + i) -> score;
		}


	    for(i = 1; i <= n; i++)
		{
		    for(j = 1; j <= num_p; j++)
			{
			    dum_vec[j] = data[i][j];
			}
		    score[i] = discrim_func(x, dum_vec, av, num_p);
		    if(score[i] >= 0.0)
			{
			    printf("%s:%s\t%13.7f\to\n", 
				   (data_set + i) -> source,
				   (data_set + i) -> position, score[i]);
			}
		    else
			{
			    printf("%s:%s\t%13.7f\tx\n", 
				   (data_set + i) -> source,
				   (data_set + i) -> position, score[i]);
			}
		}

	    free_matrix(data, (long) 1, (long) n, (long) 1, (long) num_p);
	    free_vector(score, (long) 1, (long) n);

	}


    /* $@ITMW$J%a%b%j$N2rJ|(J */
    free_vector(dum_vec, (long) 1, (long) num_p);
    free_matrix(dum_mat, (long) 1, (long) num_p, (long) 1, (long) num_p);


    /* $@%a%b%j$N2rJ|(J */
    free_matrix(data1, (long) 1, (long) n1, (long) 1, (long) num_p);
    free_matrix(data2, (long) 1, (long) n2, (long) 1, (long) num_p);
    free_vector(av, (long) 1, (long) num_p);
    free_vector(av1, (long) 1, (long) num_p);
    free_vector(av2, (long) 1, (long) num_p);
    free_vector(d, (long) 1, (long) num_p);
    free_matrix(s1, (long) 1, (long) num_p, (long) 1, (long) num_p);
    free_matrix(s2, (long) 1, (long) num_p, (long) 1, (long) num_p);
    free_matrix(v, (long) 1, (long) num_p, (long) 1, (long) num_p);
    free_vector(x, (long) 1, (long) num_p);
    free_vector(score1, (long) 1, (long) n1);
    free_vector(score2, (long) 1, (long) n2);

    /* float *, float **$@7?0J30$O<+J,$G2rJ|(J */
    free(index);


    return(0);
}


/* n$@8D$N%G!<%?$r3JG<$9$kG[Ns(J*data$@$K$D$$$F!"%G!<%?$NJ?6QCM$r;;=P$9$k!#(J
$@JV$jCM$OJ?6QCM!#(J */
float average(float *data, int n)
{
    int i;
    float sum = 0.0;
    float av;

    for(i = 1; i <= n; i++)
	{
	    sum += data[i];
	}
    av = sum / ((float) n);
    /*
    av = sum / ((float) (n - 1.0));
    */

    return(av);
}

/* n$@8D$N%G!<%?$r3JG<$9$kG[Ns(J*xi$@$H(J*xj$@$K$D$$$F!"%G!<%?$N6&J,;6$r;;=P$9$k!#(J
$@JV$jCM$O6&J,;6!#(J*xi$@$H(J*xj$@$,F10l$J$i$P!"J,;6$r;;=P$9$k!#(J
av_xi$@$O!"%G!<%?%;%C%H(J*xi$@$NJ?6QCM!"(Jav_xj$@$O!"%G!<%?%;%C%H(J*xj$@$NJ?6QCM!#(J */
float variance(float *xi, float av_xi, float *xj, float av_xj, int n)
{
    int i;
    float sum = 0.0;
    float s_xy;

    for(i = 1; i <= n; i++)
	{
	    sum += (xi[i] - av_xi) * (xj[i] - av_xj);
	}
    s_xy = sum;
    /*
    s_xy = sum / ((float) n);
    s_xy = sum / ((float) (n - 1.0));
    */

    return(s_xy);
}

/* $@@~7AH=JL4X?t(J score = $@&2(J_i^n c[i]*(x[i]-av[i]) 
   $@$N%9%3%"$rJV$9(J */
float discrim_func(float *c, float *x, float *av, int n)
{
    int i;
    float score = 0.0;

    for(i = 1; i <= n; i++)
	{
	    score += c[i] * (x[i] - av[i]);
	}

    return(score);
}

/* $@%^%O%i%N%S%9J?J}5wN%(J Dp^2 = l^t d (l^t$@$O%Y%/%H%k(Jl$@$N=D%Y%/%H%k(J)
   $@$r;;=P$9$k(J */
float mahalanobis(float *l, float *d, int n)
{
    int i, j;
    float *dum_vec;
    float dum;
    float distance = 0.0;

    dum_vec = (float*) vector((long) 1, (long) n);

    for(i = 1; i <= n; i++)
	{
	    distance += l[i] * d[i];
	}

    free_vector(dum_vec, (long) 1, (long) n);

    return(distance);
}


