#include <stdlib.h>
#include <math.h>
#include <stdio.h>

#include "hmm-gene.h"
#include "ga.h"


int gray2int(int length, unsigned char *gray)
{
    /* gray[0..length-1]$B$NFbMF$r(Bgray code$B$G5-=R$5$l$?$b$N$H$7!$(B
       $B@0?t$KJQ49$9$k!%(B */

    int rtn = -1;
    int flag;
    int i, j, k;
    unsigned char *cdum;

    unsigned char *cvector(long, long);
    void free_cvector(unsigned char *, long, long);


    cdum = cvector((long)0, (long)(length-1));

    for(i = 0; i < pow((double)BINARY, (double)length); i++){

	for(j = length-1; j >= 0; j--){
	    k = (int)(((double)i + pow((double)BINARY, (double)j)) / 
			      pow((double)BINARY, (double)(j+1))) % BINARY;
	    if(k == 0){
		cdum[(length-1)-j] = '0';
	    }
	    else if(k == 1){
		cdum[(length-1)-j] = '1';
	    }
	    else{
		free_cvector(cdum, (long)0, (long)(length-1));
		return(-1);
	    }
	}

	/* strcmp$B$O!$%4%_$,$"$k$H%P%0$N4p$K$J$k!%(B */
	/*
	if(strcmp(cdum, gray) == 0){
	    rtn = i;
	    break;
	}
	*/
	flag = 0;
	for(j = 0; j < length; j++){
	    if(cdum[j] != gray[j]){
		flag++;
	    }
	}
	if(flag == 0){
	    rtn = i;
	    break;
	}

    }

    free_cvector(cdum, (long)0, (long)(length-1));

    return(rtn);
}


int print_vector(double *vector, int imax)
{
    /* imax$B<!85%Y%/%H%k(Bdouble *vector$B$r=PNO$9$k!%(B */
    int i;

    fprintf(stderr, "\t");
    for(i = 1; i <= imax; i++){
	fprintf(stderr, "%e ", vector[i]);
    }
    fprintf(stderr, "\n");

    return(0);
}


int print_matrix(double **matrix, int imax, int jmax)
{
    /* i$B!_(Bj$B$N(B2$B<!85G[Ns(Bdouble **matrix$B$r=PNO$9$k!%(B */
    int i, j;

    for(i = 1; i <= imax; i++){
	fprintf(stderr, "\t");
	for(j = 1; j <= jmax; j++){
	    fprintf(stderr, "%e ", matrix[i][j]);
	}
	fprintf(stderr, "\n");
    }

    return(0);
}


int copy_cvector(unsigned char *vec, int m, unsigned char *ans_vec)
{
    /* m$B<!85$NJ8;zNs%Y%/%H%k(B*vec$B$r%Y%/%H%k(B*ans_vec$B$K%3%T!<$9$k!%(B */
    int i;

    for(i = 1; i <= m; i++){
	ans_vec[i] = vec[i];
    }

    return(0);
}


int vector_times(double *vec, double cnst, int m, double* ans_vec)
{
    /* m$B<!85$N%Y%/%H%k(B*vec$B$KDj?t(Bc$B$r$+$1!$%Y%/%H%k(B*ans_vec$B$KBeF~$9$k!%(B */
    int i;

    for(i = 1; i <= m; i++){
	ans_vec[i] = vec[i] * cnst;
    }

    return(0);
}


int matrix_times(double **mat, double cnst, int m, int n, double **ans_mat)
{
    /* m$B!_(Bn$B$N9TNs(B**mat$B$KDj?t(Bc$B$r$+$1!$9TNs(B**ans_mat$B$KBeF~$9$k!%(B */
    int i, j;

    for(i = 1; i <= m; i++){
	for(j = 1; j <= n; j++){
	    ans_mat[i][j] = mat[i][j] * cnst;
	}
    }

    return(0);
}


int is_zero(double d)
{
    /* $B0z?t$,(B0$B$+H]$+$rD4$Y$k!%(B */

    if((d > -EPS) && (d < EPS)){
	return(TRUE);
    }

    return(FALSE);
}


int is_almost_zero(double d)
{
    /* $B0z?t$,(B0$B$+H]$+$rD4$Y$k!%(B */

    if((d > -AEPS) && (d < AEPS)){
	return(TRUE);
    }

    return(FALSE);
}


int int2n(int i, int length, int n, int *ptr)
{
    int j;
    int show;
    int amari = i;

    for(j = length-1; j >= 0; j--){
	show = amari / ((int)pow((double)n, (double)j));
	amari = amari % ((int)pow((double)n, (double)j));
	if(show >= n){
	    return(-1);
	}
	ptr[length-j-1] = show;
    }

    return(0);
}


