#ifdef BSD
#include <sys/wait.h>
#include <signal.h>
#endif

#ifdef SYS5
#include <sys/types.h>
#include <sys/wait.h>
#include <signal.h>
#include <unistd.h>
#endif

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <strings.h>

#include "sp2mp.h"


main(int argc, char *argv[])
{
    int i, j;
    int rtn = 0;

    ARGS *args_ptr;
    int num_task;
    int num_cpu;
    int num_starting = 1;
    int num_finished = 0;
    int pid;
    int status;


    char *str;
    char buf[LONG_SIZE];
    FILE *file_ptr;

    int hmm_train(char *);

    unsigned char *cvector(long, long);
    void free_cvector(unsigned char *, long, long);


    /* ο */
    num_task = argc - 1;
    if(num_task <= 0){
	fprintf(stderr, "there are no task ...\n");
	exit(-1);
    }


    /* եɤ߹ */
    if((file_ptr = fopen("./env.cnd", "r")) == NULL){
	fprintf(stderr, "can not find ./env.cnd ...\n");
	exit(-1);
    }
    for(; fgets(buf, LONG_SIZE-1, file_ptr) != NULL; ){
	if((buf[0] != '#') && (buf[0] == '@') &&
	   (index(buf, ' ') != NULL) && 
	   (index(buf, ' ') == rindex(buf, ' '))){

	    str = (char *) strtok(buf, " ");
	    /* ׻˼ƤCPUο */
	    if(strcmp(str, "@num_cpu=") == 0){
		str = (char *) strtok(NULL, "\n");
		sscanf(str, "%d", &num_cpu);
		if(num_cpu <= 0){
		    fprintf(stderr, 
			    "number of cpu should be positive integer.\n");
		    exit(-1);
		}
	    }
	}
    }
    fclose(file_ptr);
#ifdef DEBUG
    fprintf(stderr, "    num. cpu = %d ...\n", num_cpu);
#endif


    /*  */
    if((args_ptr = (ARGS *) calloc (num_task+1, sizeof(ARGS))) == NULL){
	fprintf(stderr, "not enought memory...\n");
	exit(-1);
    }
    for(i = 1; i <= num_task; i++){
	((args_ptr + i)->a_argument) = 
	    cvector((long)0, (long)(strlen(argv[i])));
    }


    /*  */
    for(i = 1; i <= num_task; i++){
	strcpy(((args_ptr + i)->a_argument), argv[i]);
    }
#ifdef DEBUG
    fprintf(stderr, "    num. task = %d ...\n", num_task);
    for(i = 1; i <= num_task; i++){
	fprintf(stderr, "    arg. of %dth task = %s ...\n", 
		i, (args_ptr + i)->a_argument);
    }
#endif


    /* cpuθĿʬ */
    if(num_task < num_cpu){
	num_cpu = num_task;
    }
    for(i = 1; i <= num_cpu; i++){

	if((pid = fork()) < 0){
	    fprintf(stderr, "can not fork...\n");
	    for(j = 1; j <= num_task; j++){
		free_cvector(((args_ptr + j)->a_argument), (long)0, 
			     (long)(strlen(((args_ptr + j)->a_argument))));
	    }
	    free(args_ptr);
	    while(wait(&status) != -1);
	    exit(-1);
	}
	/* ƥץ */
	else if(pid > 0){
	    /* ҤȤĻϤ᤿ */
#ifdef DEBUG
	    fprintf(stderr, "--- %dth child process %d is generated...\n", 
		    num_starting, pid);
#endif
	    num_starting++;
	}
	/* ҥץ */
	else if(pid == 0){
#ifdef DEBUG
	    fprintf(stderr, 
		    "--- %dth child process (sp2mp %s) is starting...\n",
		    num_starting, (args_ptr + num_starting)->a_argument);
#endif
	    /* Baum-Welch algorithm */
	    status = hmm_train((args_ptr + num_starting)->a_argument);
#ifdef DEBUG
	    fprintf(stderr, 
		    "--- %dth child process is finished...(rtn = %d)\n",
		    num_starting, status);
#endif
	    exit(status);
	}

    }


    /* waitʤ1Ľ1fork() */
    for( ; ; ){

	/* 顼ϵäƤʤ */
	pid = wait(&status);
	if(status != 0){
	    rtn = -1;
	}


	/* ҤȤĽä */
	if(pid != -1){
	    num_finished++;
	}


	/* ƽä */
	if(num_finished == num_task){
	    break;
	}


	/* ϤƤʤ¹Ԥ */
	if(num_starting <= num_task){

	    if((pid = fork()) < 0){
		fprintf(stderr, "can not fork...\n");
		for(j = 1; j <= num_task; j++){
		    free_cvector(((args_ptr + j)->a_argument), (long)0, 
				 (long)(strlen(((args_ptr + j)->a_argument))));
		}
		free(args_ptr);
		while(wait(&status) != -1);
		exit(-1);
	    }
	    /* ƥץ */
	    else if(pid > 0){
		/* ҤȤĻϤ᤿ */
#ifdef DEBUG
		fprintf(stderr, "--- %dth child process %d is generated...\n", 
			num_starting, pid);
#endif
		num_starting++;
	    }
	    /* ҥץ */
	    else if(pid == 0){
#ifdef DEBUG
		fprintf(stderr, 
			"--- %dth child process (sp2mp %s) is starting...\n",
			num_starting, (args_ptr + num_starting)->a_argument);
#endif
		/* Baum-Welch algorithm */
		status = hmm_train((args_ptr + num_starting)->a_argument);
#ifdef DEBUG
		fprintf(stderr, 
			"--- %dth child process is finished...(rtn = %d)\n",
			num_starting, status);
#endif
		exit(status);
	    }

	}

    }
#ifdef DEBUG
    fprintf(stderr, "all processes are finished...\n");
#endif


    /* β */
    for(i = 1; i <= num_task; i++){
	free_cvector(((args_ptr + i)->a_argument), (long)0, 
		     (long)(strlen(((args_ptr + i)->a_argument))));
    }
    free(args_ptr);


    exit(rtn);
}


