#include <stdlib.h>
#include <math.h>
#include <stdio.h>

#include "hmm-gene.h"
#include "ga.h"
#include "hmm.h"


int viterbi(char *a_seq, int length, int num_state, int *tuple, 
	    int **connect, double **a_ij, double *pi_i, TPL_TBL *b_ij, 
	    double *likelihd, int **path)
{
    int i, j, k;
    double freq;
    double ddum_max;
    double **alpha;
    double *ddum;

    double *dvector(long, long);
    void free_dvector(double *, long, long);
    double **dmatrix(long, long, long, long);
    void free_dmatrix(double **, long, long, long, long);
    int is_zero(double);
    int frequency(char *, int, int, TPL_TBL **, int, double *);


    /* $B%a%b%j3NJ](B */
    alpha = dmatrix((long)1, (long)num_state, (long)1, (long)length);
    ddum = dvector((long)1, (long)num_state);


    /* $B&A(B_i(k,1)$B$r=i4|2=$9$k(B */
    for(i = 1; i <= num_state; i++){
	frequency(a_seq, 1, tuple[i], &b_ij, i, &freq);
	if((is_zero(pi_i[i]) == TRUE) || (is_zero(freq) == TRUE)){
	    alpha[i][1] = L_NEGATIVE;
	}
	else{
	    alpha[i][1] = log(pi_i[i]) + log(freq);
	}
    }


    /* $B%5%s%W%kG[NsD9$5$N%k!<%W(B */
    for(i = 2; i <= length; i++){

	/* $B>uBV?t$N%k!<%W(B */
	for(j = 1; j <= num_state; j++){

	    /* $B;~4V(Bi$B$N>uBV(Bj$B$K$D$$$F9M$($i$l$k%Q%9(Bk-j$B4V$N(B
	       $B&A(Bk(i-1)$B!_(Ba_kj$B$N:GBgCM$r8+$D$1$k(B */
	    for(k = 1; k <= num_state; k++){
		if(is_zero(a_ij[k][j]) == TRUE){
		    ddum[k] = alpha[k][i-1] + L_NEGATIVE;
		}
		else{
		    ddum[k] = alpha[k][i-1] + log(a_ij[k][j]);
		}
	    }
	    ddum_max = ddum[1];
	    for(k = 2; k <= num_state; k++){
		if(ddum_max < ddum[k]){
		    ddum_max = ddum[k];
		}
	    }
	    frequency(a_seq, i, tuple[j], &b_ij, j, &freq);
	    if(is_zero(freq) == TRUE){
		alpha[j][i] = ddum_max + L_NEGATIVE;
	    }
	    else{
		alpha[j][i] = ddum_max + log(freq);
	    }
	}
    }
#ifdef DEBUG
    fprintf(stderr, "alpha(i,j)...\n");
    for(i = 1; i <= num_state; i++){
	for(j = 1; j <= length; j++){
	    fprintf(stderr, "%e ", alpha[i][j]);
	}
	fprintf(stderr, "\n");
    }
#endif


    /* $BBP?t$f$&EY(B */
    ddum_max = alpha[1][length];
    for(i = 2; i <= num_state; i++){
	if(ddum_max < alpha[i][length]){
	    ddum_max = alpha[i][length];
	}
    }
    *likelihd = ddum_max;


    /* $B:GE,%Q%9(B */
    if(*likelihd > (double)L_NEGATIVE){
	ddum_max = alpha[1][length];
	(*path)[length] = 1;
	for(i = 2; i <= num_state; i++){
	    if(ddum_max < alpha[i][length]){
		(*path)[length] = i;
	    }
	}
	for(i = length-1; i >= 1; i--){
	    for(j = 1; j <= num_state; j++){
		double ddum1;
		double ddum2;
		frequency(a_seq, i+1, tuple[(*path)[i+1]], &b_ij, 
			  (*path)[i+1], &freq);
		if((is_zero(freq) == FALSE) && 
		   (is_zero(a_ij[j][(*path)[i+1]]) == FALSE)){
		    ddum1 = alpha[j][i] + log(a_ij[j][(*path)[i+1]]) + 
			log(freq);
		    ddum2 = alpha[(*path)[i+1]][i+1];
		    if(is_zero(ddum1-ddum2) == TRUE){
			(*path)[i] = j;
		    }
		}
	    }
	}
    }
    else{
	for(i = 1; i <= length; i++){
	    (*path)[i] = 0;
	}
    }
#ifdef DEBUG
    fprintf(stderr, "opt. path...\n...");
    for(i = 1; i <= length; i++){
	fprintf(stderr, "-> %d ", (*path)[i]);
    }
    fprintf(stderr, "->...\n");
#endif


    /* $B%a%b%j2rJ|(B */
    free_dmatrix(alpha, (long)1, (long)num_state, (long)1, (long)length);
    free_dvector(ddum, (long)1, (long)num_state);


    return(0);
}


