#include <stdlib.h>
#include <math.h>
#include <stdio.h>
#include <string.h>
#include <strings.h>

#include "hmm-gene.h"
#include "ga.h"
#include "hmm.h"


int read_hmm_cnd(char *file_name, HMM_CND *hmm_cnd)
{
    FILE *file_ptr;
    char buf[TINY_SIZE];
    char *str;
    float f;


    if((file_ptr = fopen(file_name, "r")) == NULL){
	fprintf(stderr, "can not open file %s.\n", file_name);
	return(-1);
    }
    for(; fgets(buf, LONG_SIZE-1, file_ptr) != NULL; ){
	/* $B%3%a%s%HJ80J30$G:G=i$,(B@$B$G(B
	   $B:G=i$H:G8e$N6uGr$N0LCV$,F1$89T$rFI$_9~$`!%(B */
	if((buf[0] != '#') && (buf[0] == '@') &&
	   (index(buf, ' ') != NULL) && 
	   (index(buf, ' ') == rindex(buf, ' '))){

	    str = (char *) strtok(buf, " ");

	    /* $B<}B+H=DjogCM(B */
	    if(strcmp(str, "@tolerance=") == 0){
		str = (char *) strtok(NULL, "\n");
		sscanf(str, "%f", &f);
		hmm_cnd->eps = (double) f;
		if(hmm_cnd->eps <= 0){
		    fprintf(stderr, "tolerance should be positive value.\n");
		    return(-1);
		}
	    }

	    /* $BBG$A@Z$j3X=,2s?t(B */
	    if(strcmp(str, "@max_iteration=") == 0){
		str = (char *) strtok(NULL, "\n");
		hmm_cnd->max_itr = atoi(str);
		if(hmm_cnd->max_itr <= 0){
		    fprintf(stderr, "max. number of iteration should be positive integer.\n");
		    return(-1);
		}
	    }

	    /* AIC$B$K$*$$$F!$J?6QBP?tL`EY$r(B1.0$B$H$7$?;~$N(B
	       HMM$B$N<+M3%Q%i%a!<%??t%&%'%$%H(B */
	    if(strcmp(str, "@aic_weight=") == 0){
		str = (char *) strtok(NULL, "\n");
		sscanf(str, "%f", &f);
		hmm_cnd->aic_weight = (double) f;
		if(hmm_cnd->aic_weight < 0){
		    fprintf(stderr, "aic weight should be positive value.\n");
		    return(-1);
		}
	    }

	}
    }
    fclose(file_ptr);

    return(0);
}


int alloc_parameter1(int num_state, int *length, TPL_TBL **b_ij,
		     double ***a_ij, double **pi_i, double **score, 
		     int num_seq)
{
    int i;
    double ddum;

    char **cmatrix(long, long, long, long);
    double *dvector(long, long);
    double **dmatrix(long, long, long, long);

    /* $B9=B$BN$NG[Ns$O(B1$BHV$+$i(Bnum_state$BHV$^$G$H$k!%(B */
    if((*b_ij = (TPL_TBL *) calloc (num_state+1, sizeof(TPL_TBL))) == NULL){
	fprintf(stderr, "not enought memory...\n");
	return(-1);
    }

    for(i = 1; i <= num_state; i++){
	ddum = pow((double)NUCL, (double)(length[i]));

	/* tuple */
	((*b_ij + i)->tuple) = cmatrix((long)1, (long)ddum,
					(long)1, (long)length[i]);

	/* $BIQEY(B */
	((*b_ij + i)->frq) = dvector((long)1, (long)ddum);
    }

    /* $B>uBVA+0\3NN((B */
    *a_ij = dmatrix((long)1, (long)num_state, (long)1, (long)num_state);

    /* $B=i4|$N>uBVJ,I[3NN((B */
    *pi_i = dvector((long)1, (long)num_state);

    /* $B%5%s%W%kG[Ns$N%9%3%"(B */
    *score = dvector((long)1, (long)num_seq);

    return(0);
}


int free_parameter1(int num_state, int *length, TPL_TBL *b_ij, double **a_ij, 
		    double *pi_i, double *score, int num_seq)
{
    int i;
    double ddum;

    void free_cmatrix(char **, long, long, long, long);
    void free_dvector(double *, long, long);
    void free_dmatrix(double **, long, long, long, long);


    /* $B9=B$BN$NG[Ns$O(B1$BHV$+$i(Bnum_state$BHV$^$G$H$k!%(B */
    if(b_ij != NULL){
	for(i = 1; i <= num_state; i++){
	    ddum = pow((double)NUCL, (double)(length[i]));

	    if(((b_ij + i)->tuple) != NULL){
		free_cmatrix((b_ij + i)->tuple, 
			     (long)1, (long)ddum, (long)1, (long)length[i]);
	    }

	    if(((b_ij + i)->frq) != NULL){
		free_dvector((b_ij + i)->frq, (long)1, (long)ddum);
	    }
	}
	free(b_ij);
    }

    free_dmatrix(a_ij, (long)1, (long)num_state, (long)1, (long)num_state);
    free_dvector(pi_i, (long)1, (long)num_state);
    free_dvector(score, (long)1, (long)num_seq);

    return(0);
}


int param_initial(int num_state, int *length, TPL_TBL **b_ij, double ***a_ij,
		  double **pi_i, double **a0_ij, double *freq, double *pi0_i)
{
    int i, j, k;
    int idum;
    int *idum_ptr;

    int *ivector(long, long);
    void free_ivector(int *, long, long);
    int int2n(int, int, int, int *);
    int matrix_times(double **, double, int, int, double **);


    for(i = 1; i <= num_state; i++){
	idum = (int) pow((double)NUCL, (double)(length[i]));

	/* $BD9$5(Blength[i]$B$N(Btuple$B$r@8@.(B */
	idum_ptr = ivector(0, (long)length[i]-1);
	for(j = 1; j <= idum; j++){

	    /* $B@0?t(B(j-1)$B$r(B4$B?J?t$KJQ49(B */
	    if(int2n(j-1, length[i], NUCL, idum_ptr) != 0){
		fprintf(stderr, "error occures in int2n()...\n");
		free_ivector(idum_ptr, 0, (long)(length[i]-1));
		return(-1);
	    }
	    for(k = 0; k < length[i]; k++){
		if(idum_ptr[k] == 0)
		    ((*b_ij + i)->tuple)[j][k+1] = 'A';
		else if(idum_ptr[k] == 1)
		    ((*b_ij + i)->tuple)[j][k+1] = 'T';
		else if(idum_ptr[k] == 2)
		    ((*b_ij + i)->tuple)[j][k+1] = 'C';
		else if(idum_ptr[k] == 3)
		    ((*b_ij + i)->tuple)[j][k+1] = 'G';
		else{
		    free_ivector(idum_ptr, 0, (long)(length[i]-1));
		    return(-1);
		}
	    }

	}
	free_ivector(idum_ptr, 0, (long)(length[i]-1));

	/* $B1v4pIQEY$N=i4|CM(B */
	for(j = 1; j <= idum; j++){
	    ((*b_ij + i)->frq)[j] = freq[(i-1)*idum+j];
	}
    }


    /* $B>uBVA+0\3NN($N=i4|CM(B */
    matrix_times(a0_ij, 1.0, num_state, num_state, *a_ij);


    /* $B=i4|>uBVJ,I[$N=i4|CM!%(B */
    for(i = 1; i <= num_state; i++){
	(*pi_i)[i] = pi0_i[i];
    }


    return(0);
}


int alloc_parameter2(int num_seq, int num_state, int seq_length4hmm,
		     HMM_LEARN_PARAM **param_str, double ***dum_a,
		     double **dum_pi, TPL_TBL **dum_b, int *tuple,
		     double ***dum_scale, double **dum_likelihd)
{
    int i;
    double ddum;

    char **cmatrix(long, long, long, long);
    double *dvector(long, long);
    double **dmatrix(long, long, long, long);
    double ***d3tensor(long, long, long, long, long, long);

    /* $B9=B$BN$NG[Ns$O(B1$BHV$+$i(Bnum_state$BHV$^$G$H$k!%(B */
    if((*param_str = 
	(HMM_LEARN_PARAM *) calloc (num_seq+1, sizeof(HMM_LEARN_PARAM)))
       == NULL){
	fprintf(stderr, "not enought memory...\n");
	return(-1);
    }

    for(i = 1; i <= num_seq; i++){
	/* $B&A(B_n(i,t) : 0 <= t <= seq_length4hmm */
	(*param_str + i)->alpha_ij = dmatrix((long)1, (long)num_state, 
					     (long)0, (long)seq_length4hmm);
	
	/* $B&B(B_n(i,t) : 0 <= t <= seq_length4hmm */
	(*param_str + i)->beta_ij = dmatrix((long)1, (long)num_state, 
					    (long)0, (long)seq_length4hmm);

	/* $B&C(B_n(i,j,t) */
	(*param_str + i)->gamma_ijt = dmatrix((long)1, (long)num_state, 
					      (long)0, (long)seq_length4hmm);
    }

    *dum_a = dmatrix((long)1, (long)num_state, (long)1, (long)num_state);
    *dum_pi = dvector((long)1, (long)num_state);

    /* $B9=B$BN$NG[Ns$O(B1$BHV$+$i(Bnum_state$BHV$^$G$H$k!%(B */
    if((*dum_b = (TPL_TBL *) calloc (num_state+1, sizeof(TPL_TBL))) == NULL){
	fprintf(stderr, "not enought memory...\n");
	return(-1);
    }
    for(i = 1; i <= num_state; i++){
	ddum = pow((double)NUCL, (double)(tuple[i]));

	/* tuple */
	((*dum_b + i)->tuple) = cmatrix((long)1, (long)ddum,
					(long)1, (long)tuple[i]);

	/* $BIQEY(B */
	((*dum_b + i)->frq) = dvector((long)1, (long)ddum);
    }

    /* $B%9%1!<%k%U%!%/%?(B */
    *dum_scale = dmatrix((long)1, (long)num_seq, 
			 (long)1, (long)seq_length4hmm);
    /* $BBP?t$f$&EY(B */
    *dum_likelihd = dvector((long)1, (long)num_seq);


    return(0);
}


int free_parameter2(int num_seq, int num_state, int seq_length4hmm, 
		    HMM_LEARN_PARAM *param_str, double **dum_a, 
		    double *dum_pi, TPL_TBL *dum_b, int *tuple,
		    double **dum_scale, double *dum_likelihd)
{
    int i;
    double ddum;

    void free_cmatrix(char **, long, long, long, long);
    void free_dvector(double *, long, long);
    void free_dmatrix(double **, long, long, long, long);
    void free_d3tensor(double ***, long, long, long, long, long, long);

    /* $B9=B$BN$NG[Ns$O(B1$BHV$+$i(Bnum_seq$BHV$^$G$H$k!%(B */
    if(param_str != NULL){
	for(i = 1; i <= num_seq; i++){

	    /* $B&A(B_n(i,t) : 0 <= t <= seq_length4hmm */
	    if(((param_str + i)->alpha_ij) != NULL){
		free_dmatrix((param_str + i)->alpha_ij, 
			     (long)1, (long)num_state, 
			     (long)0, (long)seq_length4hmm);
	    }

	    /* $B&B(B_n(i,t) : 0 <= t <= seq_length4hmm */
	    if(((param_str + i)->beta_ij) != NULL){
		free_dmatrix((param_str + i)->beta_ij, 
			     (long)1, (long)num_state, 
			     (long)0, (long)seq_length4hmm);
	    }

	    /* $B&C(B_n(i,j,t) : 0 <= t <= seq_length4hmm */
	    if(((param_str + i)->gamma_ijt) != NULL){
		free_dmatrix((param_str + i)->gamma_ijt, 
			     (long)1, (long)num_state, 
			     (long)0, (long)seq_length4hmm);
	    }

	}
	free(param_str);
    }

    free_dmatrix(dum_a, (long)1, (long)num_state, (long)1, (long)num_state);
    free_dvector(dum_pi, (long)1, (long)num_state);

    /* $B9=B$BN$NG[Ns$O(B1$BHV$+$i(Bnum_state$BHV$^$G$H$k!%(B */
    if(dum_b != NULL){
	for(i = 1; i <= num_state; i++){
	    ddum = pow((double)NUCL, (double)(tuple[i]));

	    if(((dum_b + i)->tuple) != NULL){
		free_cmatrix((dum_b + i)->tuple, 
			     (long)1, (long)ddum, (long)1, (long)tuple[i]);
	    }

	    if(((dum_b + i)->frq) != NULL){
		free_dvector((dum_b + i)->frq, (long)1, (long)ddum);
	    }
	}
	free(dum_b);
    }

    /* $B%9%1!<%k%U%!%/%?(B */
    free_dmatrix(dum_scale, (long)1, (long)num_seq, 
		 (long)1, (long)seq_length4hmm);
    /* $BBP?t$f$&EY(B */
    free_dvector(dum_likelihd, (long)1, (long)seq_length4hmm);


    return(0);
}


int frequency(char *seq, int pos, int tuple, TPL_TBL **b_ij, 
	      int state, double *freq)
{
    int i, j;
    int sensor;
    double ddum;
    unsigned char *key;

    unsigned char *cvector(long, long);
    void free_cvector(unsigned char *, long, long);

    key = cvector((long)1, (long)tuple);

    /* $B%5%s%W%kG[Ns(Bstr$B$K$D$$$F!$>uBV(Bstate$B$N(B
       $B0LCV(Bpos$B$K$*$1$kD9$5(Btuple$B$NJ8;zNs$r<h$j=P$7(Bkey$B$K3JG<$9$k!%(B */
    for(i = 1; i <= tuple; i++){
	key[i] = seq[(pos-1)+(i-1)];
    }
    
    /* key$B$NIQEY(Bfreq$B$r9=B$BN$h$j8!:w$9$k!%(B */
    ddum = pow((double)NUCL, (double)tuple);
    for(i = 1; i <= (int)ddum; i++){
	sensor = 0;
	for(j = 1; j <= tuple; j++){
	    if(key[j] != ((*b_ij + state)->tuple)[i][j]){
		sensor++;
		break;
	    }
	}
	if(sensor == 0){
	    *freq = ((*b_ij + state)->frq)[i];
	    break;
	}
    }
    if(sensor != 0){
	fprintf(stderr, "invalid tuple is obtained...\n");
	*freq = 0.0;
	free_cvector(key, (long)1, (long)tuple);
	return(0);
    }

    free_cvector(key, (long)1, (long)tuple);
    return(0);
}
