#include <stdlib.h>
#include <math.h>
#include <stdio.h>

#include "hmm-gene.h"
#include "ga.h"
#include "hmm.h"


int forward(int num_seq, SEQ *seq_str, int seq_length4hmm, int num_state, 
	    int *tuple, int **connect, HMM_CND hmm_cnd, double ***a_ij, 
	    double **pi_i, TPL_TBL **b_ij, HMM_LEARN_PARAM **param_str,
	    double ***dum_scale, double **dum_likelihd)
{
    int i, j, k, l;
    double freq;
    double sum;

    int is_zero(double);
    int frequency(char *, int, int, TPL_TBL **, int, double *);


    /* $B%5%s%W%kG[Ns?t$N%k!<%W(B */
    for(i = 1; i <= num_seq; i++){

	/* $B&A(B_i(k,1)$B$r&P(Bi$B$K4p$E$$$F=i4|2=$9$k(B */
	for(j = 1; j <= num_state; j++){
	    frequency((seq_str + i)->a_seq, 1, tuple[j], b_ij, j, &freq);
	    ((*param_str + i)->alpha_ij)[j][1] = (*pi_i)[j] * freq;
	}

	/* $B&A(B_i(k,1)$B$r=i4|2=$9$k(B
	   ($B=i4|>uBV$G$O>uBV(B1$B$K$$$k$b$N$H$9$k(B)
	   <$BCm0U(B>
	   $B$3$3$r%3%a%s%H%"%&%H$9$k>l9g$O(B
	   **1**$B$b%3%a%s%H%"%&%H$9$k$3$H(B */
	/*
	frequency((char *)((seq_str + i)->a_seq), 1, tuple[1], b_ij, 1, &freq);
	((*param_str + i)->alpha_ij)[1][1] = 1.0 * freq;
	for(j = 2; j <= num_state; j++){
	    frequency((char *)((seq_str + i)->a_seq), 1, tuple[j], b_ij, 
		      j, &freq);
	    ((*param_str + i)->alpha_ij)[j][1] = 0.0 * freq;
	}
	*/

	/* $B%9%1!<%k%U%!%/%?$K$h$k@55,2=(B */
	sum = 0.0;
	for(j = 1; j <= num_state; j++){
	    sum += ((*param_str + i)->alpha_ij)[j][1];
	}
	if(is_zero(sum) == FALSE){
	    (*dum_scale)[i][1] = 1.0 / sum;
	}
	else{
	    /*
	    (*dum_scale)[i][1] = L_POSITIVE;
	    */
	    (*dum_scale)[i][1] = 0.0;
	}
	for(j = 1; j <= num_state; j++){
	    ((*param_str + i)->alpha_ij)[j][1] = 
		((*param_str + i)->alpha_ij)[j][1] * (*dum_scale)[i][1];
	}

	/* $B%5%s%W%kG[NsD9$5$N%k!<%W(B */
	for(j = 2; j <= seq_length4hmm; j++){

	    /* $B>uBV?t$N%k!<%W(B */
	    for(k = 1; k <= num_state; k++){
		sum = 0.0;
		for(l = 1; l <= num_state; l++){
		    sum += ((*param_str + i)->alpha_ij)[l][j-1] * 
			(*a_ij)[l][k];
		}
		frequency((char *)((seq_str + i)->a_seq), j, tuple[k], 
			  b_ij, k, &freq);
		((*param_str + i)->alpha_ij)[k][j] = sum * freq;
	    }

	    /* $B%9%1!<%k%U%!%/%?$K$h$k@55,2=(B */
	    sum = 0.0;
	    for(k = 1; k <= num_state; k++){
		sum += ((*param_str + i)->alpha_ij)[k][j];
	    }
	    if(is_zero(sum) == FALSE){
		(*dum_scale)[i][j] = 1.0 / sum;
	    }
	    else{
		/*
		(*dum_scale)[i][j] = L_POSITIVE;
		*/
		(*dum_scale)[i][j] = 0.0;
	    }
	    for(k = 1; k <= num_state; k++){
		((*param_str + i)->alpha_ij)[k][j] = 
		    ((*param_str + i)->alpha_ij)[k][j] * (*dum_scale)[i][j];
	    }

	}

	/* $B=PNO3NN((B */
	sum = 0.0;
	for(j = 1; j <= seq_length4hmm; j++){
	    if(is_zero((*dum_scale)[i][j]) == FALSE){
		sum -= log((*dum_scale)[i][j]);
	    }
	    else{
		sum -= L_NEGATIVE;
	    }
	}
	(*dum_likelihd)[i] = sum;

	/* $B:G=*>uBV$KE~C#$7$F$$$J$$>l9g(B **1** */
	/*
	if(is_zero(((*param_str + i)->alpha_ij)[num_state][seq_length4hmm]) 
	   == TRUE){
	    (*dum_likelihd)[i] = L_NEGATIVE;
	}
	*/

#ifdef DEBUG
	fprintf(stderr, "alpha_n(i,j) of seq. %s...\n",
		(seq_str + i)->a_name);
	for(j = 1; j <= num_state; j++){
	    for(k = 1; k <= seq_length4hmm; k++){
		fprintf(stderr, "%e ", ((*param_str + i)->alpha_ij)[j][k]);
	    }
	    fprintf(stderr, "\n");
	}
	fprintf(stderr, "scaling factor...\n");
	for(j = 1; j <= seq_length4hmm; j++){
	    fprintf(stderr, "%e ", (*dum_scale)[i][j]);
	}
	fprintf(stderr, "\nprobability= %e\n", (*dum_likelihd)[i]);
#endif
    }


    return(0);
}


