#include <stdlib.h>
#include <math.h>
#include <stdio.h>

#include "hmm-gene.h"
#include "ga.h"


int selection1(GA_CND *ga_cnd, INDIVIDUAL **individual_ptr)
{
    int i, j, k;
    int state;
    float fdum;
    double ddum;
    double *roulette;
    double sum;
    INDIVIDUAL *dum_population;

    float xrandom(long *);
    int is_zero(double);
    int copy_cvector(unsigned char *, int, unsigned char *);
    int show_population(GA_CND *, INDIVIDUAL **);

    unsigned char *cvector(long, long);
    double *dvector(long, long);
    double **dmatrix(long, long, long, long);
    int **imatrix(long, long, long, long);
    int *ivector(long, long);

    void free_cvector(unsigned char *, long, long);
    void free_dvector(double *, long, long);
    void free_dmatrix(double **, long, long, long, long);
    void free_imatrix(int **, long, long, long, long);
    void free_ivector(int *, long, long);


    /* $BE,1~EY$K1~$8$?%k!<%l%C%H$r:n@.(B */
    roulette = dvector((long)0, (long)ga_cnd->population);
    sum = 0.0;
    for(i = 1; i <= ga_cnd->population; i++){
	sum += ((*individual_ptr) + i)->scaled_fitness;
    }
    if(is_zero(sum) == TRUE){
	fprintf(stderr, "population is extinct\n");
	free_dvector(roulette, (long)0, (long)ga_cnd->population);
	return(-1);
    }
    roulette[0] = 0.0;
    for(i = 1; i <= ga_cnd->population; i++){
	roulette[i] = (((*individual_ptr) + i)->scaled_fitness)/sum;
    }
    for(i = 1; i <= ga_cnd->population; i++){
	roulette[i] += roulette[i-1];
    }
#ifdef DEBUG
    fprintf(stderr, "    selection roulette...\n");
    for(i = 0; i <= ga_cnd->population; i++){
	fprintf(stderr, "%f ", roulette[i]);
    }
    fprintf(stderr, "\n");
#endif


    /* $B%a%b%j$N3NJ](B */
    if((dum_population = (INDIVIDUAL *) calloc (ga_cnd->population+1, 
						sizeof(INDIVIDUAL))) == NULL){
	fprintf(stderr, "not enought memory...\n");
	return(-1);
    }
    for(i = 1; i <= ga_cnd->population; i++){
	/* HMM$B$N>uBV?t$N%3%T!<(B */
	(dum_population + i)->state = (*individual_ptr + i)->state;

	/* HMM$B$N7k9g9TNs$r3JG<$9$kG[Ns(B */
	((dum_population + i)->gene_connect) = 
	    cvector((long)1, (long)(((dum_population + i)->state)*
				    ((dum_population + i)->state)));

	/* HMM$B$NA+0\3NN($N=i4|CM$r3JG<$9$kG[Ns(B */
	((dum_population + i)->gene_a0_ij) = 
	    cvector((long)1, (long)(((dum_population + i)->state)*
				    ((dum_population + i)->state)*UNIT_AIJ));

	/* HMM$B$N>uBVJ,I[$N=i4|CM$r3JG<$9$kG[Ns(B */
	((dum_population + i)->gene_pi_i) = 
	    cvector((long)1, (long)(((dum_population + i)->state)*UNIT_PI));

	/* HMM$B$N3F>uBV$K$*$1$k1v4pIQEY$N=i4|CM$r3JG<$9$kG[Ns(B */
	((dum_population + i)->gene_freq) = 
	    cvector((long)1, (long)(((dum_population + i)->state)*
				    UNIT_FRQ*NUCL));

	/* $BE,1~EY$N%3%T!<(B */
	(dum_population + i)->scaled_fitness = 
	    (*individual_ptr + i)->scaled_fitness;

    }


    /* $BK\@$Be$N%P%C%/%"%C%W(B */
    for(i = 1; i <= ga_cnd->population; i++){
	/* HMM$B$N>uBV?t$N%3%T!<$O%a%b%j3NJ]$N:]$K9T$J$C$F$$$k(B */
	state = (dum_population + i)->state;

	/* HMM$B$N7k9g9TNs$r3JG<$9$kG[Ns(B */
	copy_cvector(((*individual_ptr) + i)->gene_connect, state*state, 
		     (dum_population + i)->gene_connect);

	/* HMM$B$NA+0\3NN($N=i4|CM$r3JG<$9$kG[Ns(B */
	copy_cvector(((*individual_ptr) + i)->gene_a0_ij, 
		     state*state*UNIT_AIJ, 
		     (dum_population + i)->gene_a0_ij);

	/* HMM$B$N>uBVJ,I[$N=i4|CM$r3JG<$9$kG[Ns(B */
	copy_cvector(((*individual_ptr) + i)->gene_pi_i, state*UNIT_PI, 
		     (dum_population + i)->gene_pi_i);

	/* HMM$B$N3F>uBV$K$*$1$k1v4pIQEY$N=i4|CM$r3JG<$9$kG[Ns(B */
	copy_cvector(((*individual_ptr) + i)->gene_freq, state*UNIT_FRQ*NUCL, 
		     (dum_population + i)->gene_freq);

	/* $BE,1~EY$N%3%T!<$O%a%b%j3NJ]$N:]$K9T$J$C$F$$$k(B */
    }

    /* $B%k!<%l%C%H$rMQ$$$?EqBA(B */
    for(i = 1; i <= ga_cnd->population; i++){

	/* $B<!@$Be$N(Bi$BHVL\$N8DBN(Bj$B$rA*$V!%(B
	   (mating$B$9$k(B2$B8DBN$N>uBV?t$OEy$7$$!%(B) */
	fdum = xrandom(&(ga_cnd->seed));
	for(j = 1; j <= ga_cnd->population; j++){
	    if((fdum >= roulette[j-1]) && (fdum < roulette[j])){
		break;
	    }
	}

	/* ($B$H$j$"$($:(B)$B%(%j!<%H@oN,(B
	   ($BK\@$Be$NE,1~EY:GBg8DBN$O<!@$Be8DBN(B1$B$K$J$k(B) */
	if(i == 1){
	    ddum = 0.0;
	    for(k = 1; k <= ga_cnd->population; k++){
		if(ddum <= ((*individual_ptr) + k)->scaled_fitness){
		    ddum = ((*individual_ptr) + k)->scaled_fitness;
		    j = k;
		}
	    }
	}

	/* $B6v?tHVL\$N8DBN(Bi$B$N>l9g!$8DBN(B(i-1)$B$HF1$8>uBV?t$rM-$9$k8DBN$N(B
	   $BJ,=8CD$+$i8DBN(Bj$B$rA*$V(B */
	if((i%2 == 0) && ((dum_population + j)->state != 
			  ((*individual_ptr) + (i-1))->state)){
	    int *sub_population;
	    double *sub_roulette;
	    int sub_size;
	    int sub_state;
	    double sub_sum;

#ifdef DEBUG
	    fprintf(stderr, "--- subpopulation selection...\n");
#endif

	    /* $BJ,=8CD$N%5%$%:$r%+%&%s%H(B */
	    sub_state = ((*individual_ptr) + (i-1))->state;
	    sub_size = 0;
	    for(j = 1; j <= ga_cnd->population; j++){
		if((dum_population + j)->state == sub_state){
		    sub_size++;
		}
	    }
#ifdef DEBUG
	    fprintf(stderr, "    state=%d size=%d\n", sub_state, sub_size);
#endif

	    /* $BJ,=8CD$N%a%s%P(B */
	    sub_population = ivector((long)1, (long)sub_size);
	    k = 1;
	    for(j = 1; j <= ga_cnd->population; j++){
		if((dum_population + j)->state == sub_state){
		    sub_population[k] = j;
		    k++;
		}
	    }
#ifdef DEBUG
	    fprintf(stderr, "    members= ");
	    for(j = 1; j <= sub_size; j++){
		fprintf(stderr, "%d ", sub_population[j]);
	    }
	    fprintf(stderr, "\n");
#endif

	    /* $BJ,=8CD$N%k!<%l%C%H$r:n@.(B */
	    sub_roulette = dvector((long)0, (long)sub_size);
	    sub_sum = 0.0;
	    for(j = 1; j <= sub_size; j++){
		sub_sum += 
		    (dum_population + sub_population[j])->scaled_fitness;
	    }
	    sub_roulette[0] = 0.0;
	    if(is_zero(sub_sum) == TRUE){
		for(j = 1; j <= sub_size; j++){
		    sub_roulette[j] = 1.0 / (double)sub_size;
		}
	    }
	    else{
		for(j = 1; j <= sub_size; j++){
		    sub_roulette[j] = (dum_population + sub_population[j])->
			scaled_fitness/sub_sum;
		}
	    }
	    for(j = 1; j <= sub_size; j++){
		sub_roulette[j] += sub_roulette[j-1];
	    }
#ifdef DEBUG
	    fprintf(stderr, "    selection roulette for subpopulation...\n");
	    for(j = 0; j <= sub_size; j++){
		fprintf(stderr, "%f ", sub_roulette[j]);
	    }
	    fprintf(stderr, "\n");
#endif

	    /* $BJ,=8CD$+$i8DBN(Bj$B$rA*$V(B */
	    for(k = 1; k <= sub_size; k++){
		if((fdum >= sub_roulette[k-1]) && (fdum < sub_roulette[k])){
		    break;
		}
	    }
	    j = sub_population[k];

	    /* $B%a%b%j$N2rJ|(B */
	    free_ivector(sub_population, (long)1, (long)sub_size);
	    free_dvector(sub_roulette, (long)0, (long)sub_size);

	}
#ifdef DEBUG
	fprintf(stderr, "since %f, %dth individual is sellected (id=%d)...\n", 
		fdum, j, i);
#endif


	/* $BA*$P$l$?%@%_!<=8CDCf$N8DBN(Bj$B$rK\@$Be$N8DBN(Bi$B$K%3%T!<$9$k!%(B
	   ($B8DBN(Bi$B$N%a%b%j$O2rJ|$7$F3NJ]$7D>$9!%(B) */
	/* $B8DBN(Bi$B$N%a%b%j$r2rJ|(B */
	state = ((*individual_ptr) + i)->state;
	if((((*individual_ptr) + i)->gene_connect) != NULL){
	    free_cvector(((*individual_ptr) + i)->gene_connect, 
			 (long)1, (long)(state*state));
	}
	if((((*individual_ptr) + i)->gene_a0_ij) != NULL){
	    free_cvector(((*individual_ptr) + i)->gene_a0_ij, (long)1, 
			 (long)(state*state*UNIT_AIJ));
	}
	if((((*individual_ptr) + i)->gene_pi_i) != NULL){
	    free_cvector(((*individual_ptr) + i)->gene_pi_i, (long)1, 
			 (long)(state*UNIT_PI));
	}
	if((((*individual_ptr) + i)->gene_freq) != NULL){
	    free_cvector(((*individual_ptr) + i)->gene_freq, (long)1, 
			 (long)(state*UNIT_FRQ*NUCL));
	}
	if((((*individual_ptr) + i)->connect) != NULL){
	    free_imatrix(((*individual_ptr) + i)->connect, (long)1, 
			 (long)state, (long)1, (long)state);
	}
	if((((*individual_ptr) + i)->a0_ij) != NULL){
	    free_dmatrix(((*individual_ptr) + i)->a0_ij, (long)1, 
			 (long)state, (long)1, (long)state);
	}
	if((((*individual_ptr) + i)->pi_i) != NULL){
	    free_dvector(((*individual_ptr) + i)->pi_i, (long)1, 
			 (long)state);
	}
	if((((*individual_ptr) + i)->freq) != NULL){
	    free_dvector(((*individual_ptr) + i)->freq, (long)1, 
			 (long)state*NUCL);
	}
	/* $B8DBN(Bi$B$N%a%b%j$r3NJ](B */
	(((*individual_ptr) + i)->state) = state = 
	    (dum_population + j)->state;
	(((*individual_ptr) + i)->gene_connect) = 
	    cvector((long)1, (long)(state*state));
	(((*individual_ptr) + i)->gene_a0_ij) = 
	    cvector((long)1, (long)(state*state*UNIT_AIJ));
	(((*individual_ptr) + i)->gene_pi_i) = 
	    cvector((long)1, (long)(state*UNIT_PI));
	(((*individual_ptr) + i)->gene_freq) = 
	    cvector((long)1, (long)(state*UNIT_FRQ*NUCL));
	((*individual_ptr) + i)->connect = 
	    imatrix(1, (long)state, 1, (long)state);
	((*individual_ptr) + i)->a0_ij = 
	    dmatrix(1, (long)state, 1, (long)state);
	((*individual_ptr) + i)->pi_i = dvector(1, (long)state);
	((*individual_ptr) + i)->freq = dvector(1, (long)state*NUCL);
	/* $B8DBN(Bj$B$N0dEA;R$r8DBN(Bi$B$K%3%T!<(B */
	copy_cvector((dum_population + j)->gene_connect, state*state, 
		     ((*individual_ptr) + i)->gene_connect);
	copy_cvector((dum_population + j)->gene_a0_ij, state*state*UNIT_AIJ, 
		     ((*individual_ptr) + i)->gene_a0_ij);
	copy_cvector((dum_population + j)->gene_pi_i, state*UNIT_PI, 
		     ((*individual_ptr) + i)->gene_pi_i);
	copy_cvector((dum_population + j)->gene_freq, state*UNIT_FRQ*NUCL, 
		     ((*individual_ptr) + i)->gene_freq);

    }


    /* $B%a%b%j$N2rJ|(B */
    free_dvector(roulette, (long)0, (long)ga_cnd->population);
    if(dum_population != NULL){
	for(i = 1; i <= ga_cnd->population; i++){
	    if(((dum_population + i)->gene_connect) != NULL){
		free_cvector((dum_population + i)->gene_connect, 
			     (long)1, (long)(((dum_population + i)->state)*
					     ((dum_population + i)->state)));
	    }

	    if(((dum_population + i)->gene_a0_ij) != NULL){
		free_cvector((dum_population + i)->gene_a0_ij, (long)1, 
			     (long)(((dum_population + i)->state)*
				    ((dum_population + i)->state)*UNIT_AIJ));
	    }

	    if(((dum_population + i)->gene_pi_i) != NULL){
		free_cvector((dum_population + i)->gene_pi_i, (long)1, 
			     (long)(((dum_population + i)->state)*UNIT_PI));
	    }

	    if(((dum_population + i)->gene_freq) != NULL){
		free_cvector((dum_population + i)->gene_freq, (long)1, 
			     (long)(((dum_population + i)->state)*
				    UNIT_FRQ*NUCL));
	    }
	}
	free(dum_population);
    }

#ifdef DEBUG
    show_population(ga_cnd, individual_ptr);
#endif

    return(0);
}


int selection2(GA_CND *ga_cnd, INDIVIDUAL **ptr, INDIVIDUAL **dum_ptr)
{
    int i, j, k;
    int state;
    float fdum;
    double ddum;
    double *roulette;
    double sum;
    INDIVIDUAL *dum_ptr2;

    float xrandom(long *);
    int is_zero(double);
    int copy_cvector(unsigned char *, int, unsigned char *);
    int show_population(GA_CND *, INDIVIDUAL **);

    unsigned char *cvector(long, long);
    double *dvector(long, long);
    double **dmatrix(long, long, long, long);
    int **imatrix(long, long, long, long);
    int *ivector(long, long);

    void free_cvector(unsigned char *, long, long);
    void free_dvector(double *, long, long);
    void free_dmatrix(double **, long, long, long, long);
    void free_imatrix(int **, long, long, long, long);
    void free_ivector(int *, long, long);


    /* $BE,1~EY$K1~$8$?%k!<%l%C%H$r:n@.(B */
    roulette = dvector((long)0, (long)((ga_cnd->population)*2));
    sum = 0.0;
    for(i = 1; i <= ga_cnd->population; i++){
	sum += ((*ptr) + i)->scaled_fitness;
	sum += ((*dum_ptr) + i)->scaled_fitness;
    }
    if(is_zero(sum) == TRUE){
	fprintf(stderr, "population is extinct\n");
	free_dvector(roulette, (long)0, (long)((ga_cnd->population)*2));
	return(-1);
    }
    roulette[0] = 0.0;
    for(i = 1; i <= ga_cnd->population; i++){
	roulette[i+(ga_cnd->population)] = (((*ptr) + i)->scaled_fitness)/sum;
	roulette[i] = (((*dum_ptr) + i)->scaled_fitness)/sum;
    }
    for(i = 1; i <= (ga_cnd->population)*2; i++){
	roulette[i] += roulette[i-1];
    }
#ifdef DEBUG
    fprintf(stderr, "    selection roulette...\n");
    for(i = 0; i <= (ga_cnd->population)*2; i++){
	fprintf(stderr, "%f ", roulette[i]);
    }
    fprintf(stderr, "\n");
#endif


    /* $B%a%b%j$N3NJ](B */
    if((dum_ptr2 = (INDIVIDUAL *) calloc ((ga_cnd->population)*2+1, 
					  sizeof(INDIVIDUAL))) == NULL){
	fprintf(stderr, "not enought memory...\n");
	return(-1);
    }
    for(i = 1; i <= (ga_cnd->population)*2; i++){
	if(i <= ga_cnd->population){
	    /* HMM$B$N>uBV?t$N%3%T!<(B */
	    (dum_ptr2 + i)->state = (*dum_ptr + i)->state;

	    /* HMM$B$N7k9g9TNs$r3JG<$9$kG[Ns(B */
	    ((dum_ptr2 + i)->gene_connect) = 
		cvector((long)1, (long)(((dum_ptr2 + i)->state)*
					((dum_ptr2 + i)->state)));

	    /* HMM$B$NA+0\3NN($N=i4|CM$r3JG<$9$kG[Ns(B */
	    ((dum_ptr2 + i)->gene_a0_ij) = 
		cvector((long)1, (long)(((dum_ptr2 + i)->state)*
					((dum_ptr2 + i)->state)*UNIT_AIJ));

	    /* HMM$B$N>uBVJ,I[$N=i4|CM$r3JG<$9$kG[Ns(B */
	    ((dum_ptr2 + i)->gene_pi_i) = 
		cvector((long)1, (long)(((dum_ptr2 + i)->state)*UNIT_PI));

	    /* HMM$B$N3F>uBV$K$*$1$k1v4pIQEY$N=i4|CM$r3JG<$9$kG[Ns(B */
	    ((dum_ptr2 + i)->gene_freq) = 
		cvector((long)1, (long)(((dum_ptr2 + i)->state)*
					UNIT_FRQ*NUCL));

	    /* $BE,1~EY$N%3%T!<(B */
	    (dum_ptr2 + i)->likelihd = (*dum_ptr + i)->likelihd;
	    (dum_ptr2 + i)->num_p = (*dum_ptr + i)->num_p;
	    (dum_ptr2 + i)->aic = (*dum_ptr + i)->aic;
	    (dum_ptr2 + i)->raw_fitness = (*dum_ptr + i)->raw_fitness;
	    (dum_ptr2 + i)->scaled_fitness = (*dum_ptr + i)->scaled_fitness;
	}
	else{
	    /* HMM$B$N>uBV?t$N%3%T!<(B */
	    (dum_ptr2 + i)->state = (*ptr + (i-(ga_cnd->population)))->state;

	    /* HMM$B$N7k9g9TNs$r3JG<$9$kG[Ns(B */
	    ((dum_ptr2 + i)->gene_connect) = 
		cvector((long)1, (long)
			(((dum_ptr2 + i)->state)*((dum_ptr2 + i)->state)));

	    /* HMM$B$NA+0\3NN($N=i4|CM$r3JG<$9$kG[Ns(B */
	    ((dum_ptr2 + i)->gene_a0_ij) = 
		cvector((long)1, (long)(((dum_ptr2 + i)->state)*
			 ((dum_ptr2 + i)->state)*UNIT_AIJ));

	    /* HMM$B$N>uBVJ,I[$N=i4|CM$r3JG<$9$kG[Ns(B */
	    ((dum_ptr2 + i)->gene_pi_i) = 
		cvector((long)1, (long)
			(((dum_ptr2 + i)->state)*UNIT_PI));

	    /* HMM$B$N3F>uBV$K$*$1$k1v4pIQEY$N=i4|CM$r3JG<$9$kG[Ns(B */
	    ((dum_ptr2 + i)->gene_freq) = 
		cvector((long)1, (long)
			(((dum_ptr2 + i)->state)*UNIT_FRQ*NUCL));

	    /* $BE,1~EY$N%3%T!<(B */
	    (dum_ptr2 + i)->likelihd = 
		(*ptr + (i-(ga_cnd->population)))->likelihd;
	    (dum_ptr2 + i)->num_p = 
		(*ptr + (i-(ga_cnd->population)))->num_p;
	    (dum_ptr2 + i)->aic = 
		(*ptr + (i-(ga_cnd->population)))->aic;
	    (dum_ptr2 + i)->raw_fitness = 
		(*ptr + (i-(ga_cnd->population)))->raw_fitness;
	    (dum_ptr2 + i)->scaled_fitness = 
		(*ptr + (i-(ga_cnd->population)))->scaled_fitness;
	}

    }


    /* $BK\@$Be$N%P%C%/%"%C%W(B */
    for(i = 1; i <= (ga_cnd->population)*2; i++){
	if(i <= ga_cnd->population){
	    /* HMM$B$N>uBV?t$N%3%T!<$O%a%b%j3NJ]$N:]$K9T$J$C$F$$$k(B */
	    state = (dum_ptr2 + i)->state;

	    /* HMM$B$N7k9g9TNs$r3JG<$9$kG[Ns(B */
	    copy_cvector(((*dum_ptr) + i)->gene_connect, state*state, 
			 (dum_ptr2 + i)->gene_connect);

	    /* HMM$B$NA+0\3NN($N=i4|CM$r3JG<$9$kG[Ns(B */
	    copy_cvector(((*dum_ptr) + i)->gene_a0_ij, 
			 state*state*UNIT_AIJ, 
			 (dum_ptr2 + i)->gene_a0_ij);

	    /* HMM$B$N>uBVJ,I[$N=i4|CM$r3JG<$9$kG[Ns(B */
	    copy_cvector(((*dum_ptr) + i)->gene_pi_i, state*UNIT_PI, 
			 (dum_ptr2 + i)->gene_pi_i);

	    /* HMM$B$N3F>uBV$K$*$1$k1v4pIQEY$N=i4|CM$r3JG<$9$kG[Ns(B */
	    copy_cvector(((*dum_ptr) + i)->gene_freq, state*UNIT_FRQ*NUCL, 
			 (dum_ptr2 + i)->gene_freq);

	    /* $BE,1~EY$N%3%T!<$O%a%b%j3NJ]$N:]$K9T$J$C$F$$$k(B */
	}
	else{
	    /* HMM$B$N>uBV?t$N%3%T!<$O%a%b%j3NJ]$N:]$K9T$J$C$F$$$k(B */
	    state = (dum_ptr2 + i)->state;

	    /* HMM$B$N7k9g9TNs$r3JG<$9$kG[Ns(B */
	    copy_cvector(((*ptr) + (i-(ga_cnd->population)))->gene_connect, 
			 state*state, 
			 (dum_ptr2 + i)->gene_connect);

	    /* HMM$B$NA+0\3NN($N=i4|CM$r3JG<$9$kG[Ns(B */
	    copy_cvector(((*ptr) + (i-(ga_cnd->population)))->gene_a0_ij, 
			 state*state*UNIT_AIJ, 
			 (dum_ptr2 + i)->gene_a0_ij);

	    /* HMM$B$N>uBVJ,I[$N=i4|CM$r3JG<$9$kG[Ns(B */
	    copy_cvector(((*ptr) + (i-(ga_cnd->population)))->gene_pi_i, 
			 state*UNIT_PI, (dum_ptr2 + i)->gene_pi_i);

	    /* HMM$B$N3F>uBV$K$*$1$k1v4pIQEY$N=i4|CM$r3JG<$9$kG[Ns(B */
	    copy_cvector(((*ptr) + (i-(ga_cnd->population)))->gene_freq, 
			 state*UNIT_FRQ*NUCL, (dum_ptr2 + i)->gene_freq);

	    /* $BE,1~EY$N%3%T!<$O%a%b%j3NJ]$N:]$K9T$J$C$F$$$k(B */
	}
    }


    /* $B%k!<%l%C%H$rMQ$$$?EqBA(B */
    for(i = 1; i <= ga_cnd->population; i++){

	/* $B<!@$Be$N(Bi$BHVL\$N8DBN(Bj$B$rA*$V!%(B
	   (mating$B$9$k(B2$B8DBN$N>uBV?t$OEy$7$$!%(B) */
	fdum = xrandom(&(ga_cnd->seed));
	for(j = 1; j <= (ga_cnd->population)*2; j++){
	    if((fdum >= roulette[j-1]) && (fdum < roulette[j])){
		break;
	    }
	}

	/* ($B$H$j$"$($:(B)$B%(%j!<%H@oN,(B
	   ($BK\@$Be$NE,1~EY:GBg8DBN$O<!@$Be8DBN(B1$B$K$J$k(B) */
	if(i == 1){
	    ddum = 0.0;
	    for(k = 1; k <= (ga_cnd->population)*2; k++){
		if(ddum <= (dum_ptr2 + k)->scaled_fitness){
		    ddum = (dum_ptr2 + k)->scaled_fitness;
		    j = k;
		}
	    }
	}

	/* $B6v?tHVL\$N8DBN(Bi$B$N>l9g!$8DBN(B(i-1)$B$HF1$8>uBV?t$rM-$9$k8DBN$N(B
	   $BJ,=8CD$+$i8DBN(Bj$B$rA*$V(B */
	if((i%2 == 0) && ((dum_ptr2 + j)->state != 
			  ((*ptr) + (i-1))->state)){
	    int *sub_population;
	    double *sub_roulette;
	    int sub_size;
	    int sub_state;
	    double sub_sum;

#ifdef DEBUG
	    fprintf(stderr, "--- subpopulation selection...\n");
#endif

	    /* $BJ,=8CD$N%5%$%:$r%+%&%s%H(B */
	    sub_state = ((*ptr) + (i-1))->state;
	    sub_size = 0;
	    for(j = 1; j <= (ga_cnd->population)*2; j++){
		if((dum_ptr2 + j)->state == sub_state){
		    sub_size++;
		}
	    }
#ifdef DEBUG
	    fprintf(stderr, "    state=%d size=%d\n", sub_state, sub_size);
#endif
	    
	    /* $BJ,=8CD$N%a%s%P(B */
	    sub_population = ivector((long)1, (long)sub_size);
	    k = 1;
	    for(j = 1; j <= (ga_cnd->population)*2; j++){
		if((dum_ptr2 + j)->state == sub_state){
		    sub_population[k] = j;
		    k++;
		}
	    }
#ifdef DEBUG
	    fprintf(stderr, "    members= ");
	    for(j = 1; j <= sub_size; j++){
		fprintf(stderr, "%d ", sub_population[j]);
	    }
	    fprintf(stderr, "\n");
#endif

	    /* $BJ,=8CD$N%k!<%l%C%H$r:n@.(B */
	    sub_roulette = dvector((long)0, (long)sub_size);
	    sub_sum = 0.0;
	    for(j = 1; j <= sub_size; j++){
		sub_sum += 
		    (dum_ptr2 + sub_population[j])->scaled_fitness;
	    }
	    sub_roulette[0] = 0.0;
	    if(is_zero(sub_sum) == TRUE){
		for(j = 1; j <= sub_size; j++){
		    sub_roulette[j] = 1.0 / (double)sub_size;
		}
	    }
	    else{
		for(j = 1; j <= sub_size; j++){
		    sub_roulette[j] = (dum_ptr2 + sub_population[j])->
			scaled_fitness/sub_sum;
		}
	    }
	    for(j = 1; j <= sub_size; j++){
		sub_roulette[j] += sub_roulette[j-1];
	    }
#ifdef DEBUG
	    fprintf(stderr, "    selection roulette for subpopulation...\n");
	    for(j = 0; j <= sub_size; j++){
		fprintf(stderr, "%f ", sub_roulette[j]);
	    }
	    fprintf(stderr, "\n");
#endif

	    /* $BJ,=8CD$+$i8DBN(Bj$B$rA*$V(B */
	    for(k = 1; k <= sub_size; k++){
		if((fdum >= sub_roulette[k-1]) && (fdum < sub_roulette[k])){
		    break;
		}
	    }
	    j = sub_population[k];

	    /* $B%a%b%j$N2rJ|(B */
	    free_ivector(sub_population, (long)1, (long)sub_size);
	    free_dvector(sub_roulette, (long)0, (long)sub_size);

	}
#ifdef DEBUG
	fprintf(stderr, "since %f, %dth individual is sellected (id=%d)...\n", 
		fdum, j, i);
#endif


	/* $BA*$P$l$?%@%_!<=8CDCf$N8DBN(Bj$B$rK\@$Be$N8DBN(Bi$B$K%3%T!<$9$k!%(B
	   ($B8DBN(Bi$B$N%a%b%j$O2rJ|$7$F3NJ]$7D>$9!%(B) */
	/* $B8DBN(Bi$B$N%a%b%j$r2rJ|(B */
	state = ((*ptr) + i)->state;
	if((((*ptr) + i)->gene_connect) != NULL){
	    free_cvector(((*ptr) + i)->gene_connect, 
			 (long)1, (long)(state*state));
	}
	if((((*ptr) + i)->gene_a0_ij) != NULL){
	    free_cvector(((*ptr) + i)->gene_a0_ij, (long)1, 
			 (long)(state*state*UNIT_AIJ));
	}
	if((((*ptr) + i)->gene_pi_i) != NULL){
	    free_cvector(((*ptr) + i)->gene_pi_i, (long)1, 
			 (long)(state*UNIT_PI));
	}
	if((((*ptr) + i)->gene_freq) != NULL){
	    free_cvector(((*ptr) + i)->gene_freq, (long)1, 
			 (long)(state*UNIT_FRQ*NUCL));
	}
	if((((*ptr) + i)->connect) != NULL){
	    free_imatrix(((*ptr) + i)->connect, (long)1, 
			 (long)state, (long)1, (long)state);
	}
	if((((*ptr) + i)->a0_ij) != NULL){
	    free_dmatrix(((*ptr) + i)->a0_ij, (long)1, 
			 (long)state, (long)1, (long)state);
	}
	if((((*ptr) + i)->pi_i) != NULL){
	    free_dvector(((*ptr) + i)->pi_i, (long)1, 
			 (long)state);
	}
	if((((*ptr) + i)->freq) != NULL){
	    free_dvector(((*ptr) + i)->freq, (long)1, 
			 (long)state*NUCL);
	}
	/* $B8DBN(Bi$B$N%a%b%j$r3NJ](B */
	(((*ptr) + i)->state) = state = (dum_ptr2 + j)->state;
	(((*ptr) + i)->gene_connect) = cvector((long)1, (long)(state*state));
	(((*ptr) + i)->gene_a0_ij) = 
	    cvector((long)1, (long)(state*state*UNIT_AIJ));
	(((*ptr) + i)->gene_pi_i) = cvector((long)1, (long)(state*UNIT_PI));
	(((*ptr) + i)->gene_freq) = 
	    cvector((long)1, (long)(state*UNIT_FRQ*NUCL));
	((*ptr) + i)->connect = imatrix(1, (long)state, 1, (long)state);
	((*ptr) + i)->a0_ij = dmatrix(1, (long)state, 1, (long)state);
	((*ptr) + i)->pi_i = dvector(1, (long)state);
	((*ptr) + i)->freq = dvector(1, (long)state*NUCL);
	/* $B8DBN(Bj$B$N0dEA;R$r8DBN(Bi$B$K%3%T!<(B */
	copy_cvector((dum_ptr2 + j)->gene_connect, state*state, 
		     ((*ptr) + i)->gene_connect);
	copy_cvector((dum_ptr2 + j)->gene_a0_ij, state*state*UNIT_AIJ, 
		     ((*ptr) + i)->gene_a0_ij);
	copy_cvector((dum_ptr2 + j)->gene_pi_i, state*UNIT_PI, 
		     ((*ptr) + i)->gene_pi_i);
	copy_cvector((dum_ptr2 + j)->gene_freq, state*UNIT_FRQ*NUCL, 
		     ((*ptr) + i)->gene_freq);

	/* $BE,1~EY$N%3%T!<(B */
	((*ptr) + i)->likelihd = (dum_ptr2 + j)->likelihd;
	((*ptr) + i)->num_p = (dum_ptr2 + j)->num_p;
	((*ptr) + i)->aic = (dum_ptr2 + j)->aic;
	((*ptr) + i)->raw_fitness = (dum_ptr2 + j)->raw_fitness;
	((*ptr) + i)->scaled_fitness = (dum_ptr2 + j)->scaled_fitness;
		     

    }


    /* $B%a%b%j$N2rJ|(B */
    free_dvector(roulette, (long)0, (long)ga_cnd->population);
    if(dum_ptr2 != NULL){
	for(i = 1; i <= (ga_cnd->population)*2; i++){
	    if(((dum_ptr2 + i)->gene_connect) != NULL){
		free_cvector((dum_ptr2 + i)->gene_connect, 
			     (long)1, (long)(((dum_ptr2 + i)->state)*
					     ((dum_ptr2 + i)->state)));
	    }

	    if(((dum_ptr2 + i)->gene_a0_ij) != NULL){
		free_cvector((dum_ptr2 + i)->gene_a0_ij, (long)1, 
			     (long)(((dum_ptr2 + i)->state)*
				    ((dum_ptr2 + i)->state)*UNIT_AIJ));
	    }

	    if(((dum_ptr2 + i)->gene_pi_i) != NULL){
		free_cvector((dum_ptr2 + i)->gene_pi_i, (long)1, 
			     (long)(((dum_ptr2 + i)->state)*UNIT_PI));
	    }

	    if(((dum_ptr2 + i)->gene_freq) != NULL){
		free_cvector((dum_ptr2 + i)->gene_freq, (long)1, 
			     (long)(((dum_ptr2 + i)->state)*
				    UNIT_FRQ*NUCL));
	    }
	}
	free(dum_ptr2);
    }

#ifdef DEBUG
    show_population(ga_cnd, ptr);
#endif

    return(0);
}

