#include <stdlib.h>
#include <math.h>
#include <stdio.h>

#include "hmm-gene.h"
#include "ga.h"


int mutation(GA_CND *ga_cnd, INDIVIDUAL **individual_ptr)
{
    int i, j;
    float fdum;

    float xrandom(long *);
    int p_mutation(unsigned char *, int);
    int i_mutation(INDIVIDUAL **, int, int, GA_CND *);
    int d_mutation(INDIVIDUAL **, int, int, GA_CND *);
    int show_population(GA_CND *, INDIVIDUAL **);


    for(i = 1; i <= ga_cnd->population; i++){

	/* $B7k9g9TNs$K$O!$A^F~FMA3JQ0[!$7g<:FMA3JQ0[$,5/$3$k!%(B*/
	for(j = 1; j <= (((*individual_ptr)+i)->state)*
	    (((*individual_ptr)+i)->state); j++){

	    fdum = xrandom(&(ga_cnd->seed));

	    /* $BA^F~FMA3JQ0[(B 
	       ($BA^F~FMA3JQ0[$O!$0LCV(B1$B$+$i0LCV(B(length-1)$B$G5/$3$k!%(B
	        $B0l8DBN$G0l@$Be$K$D$-0lEY$7$+5/$3$i$J$$!%(B) */
	    if((fdum <= (ga_cnd->imutation)) &&
	       (j >= 1) && (j < (((*individual_ptr)+i)->state))){
#ifdef DEBUG
		fprintf(stderr, "--- insert mutation on gene_connect...\n");
		fprintf(stderr, "    id=%d pos=%d rand=%f\n", i, j, fdum);
#endif
		if(i_mutation(individual_ptr, i, j, ga_cnd) != 0){
		    fprintf(stderr, "error occures in i_mutation()...\n");
		    return(-1);
		}
	        /* $B0l8DBN$G0l@$Be$K$D$-2?EY$b5/$3$k!%(B */
		/*
		break;
		*/
	    }
	    /* $B7g<:FMA3JQ0[(B 
	       ($B7g<:FMA3JQ0[$O!$0LCV(B2$B$+$i0LCV(B(length-1)$B$G5/$3$k!%(B
	        $B0l8DBN$G0l@$Be$K$D$-0lEY$7$+5/$3$i$J$$!%(B) */
	    else if((fdum <= (ga_cnd->imutation)+(ga_cnd->dmutation)) && 
		    (j > 1) && (j < (((*individual_ptr)+i)->state))){
#ifdef DEBUG
		fprintf(stderr, "--- delete mutation on gene_connect...\n");
		fprintf(stderr, "    id=%d pos=%d rand=%f\n", i, j, fdum);
#endif
		if(d_mutation(individual_ptr, i, j, ga_cnd) != 0){
		    fprintf(stderr, "error occures in d_mutation()...\n");
		    return(-1);
		}
	        /* $B0l8DBN$G0l@$Be$K$D$-2?EY$b5/$3$k!%(B */
		/*
		break;
		*/
	    }
	}
    }


    for(i = 1; i <= ga_cnd->population; i++){

	/* $B7k9g9TNs$K$O!$E@FMA3JQ0[$,5/$3$k!%(B*/
	for(j = 1; j <= (((*individual_ptr)+i)->state)*
	    (((*individual_ptr)+i)->state); j++){

	    fdum = xrandom(&(ga_cnd->seed));

	    /* $BE@FMA3JQ0[(B */
	    if(fdum <= ga_cnd->pmutation){
#ifdef DEBUG
		fprintf(stderr, "--- point mutation on gene_connect...\n");
		fprintf(stderr, "    id=%d pos=%d rand=%f\n", i, j, fdum);
#endif
		if(p_mutation((((*individual_ptr)+i)->gene_connect), j) != 0){
		    fprintf(stderr, "error occures in p_mutation()...\n");
		    return(-1);
		}
	    }
	}


	/* $BA+0\3NN($K$O!$E@FMA3JQ0[$,5/$3$k!%(B*/
	for(j = 1; j <= (((*individual_ptr)+i)->state)*
	    (((*individual_ptr)+i)->state)*UNIT_AIJ; j++){

	    fdum = xrandom(&(ga_cnd->seed));

	    /* $BE@FMA3JQ0[(B */
	    if(fdum <= ga_cnd->pmutation){
#ifdef DEBUG
		fprintf(stderr, "--- point mutation on gene_a0_ij...\n");
		fprintf(stderr, "    id=%d pos=%d rand=%f\n", i, j, fdum);
#endif
		if(p_mutation((((*individual_ptr)+i)->gene_a0_ij), j) != 0){
		    fprintf(stderr, "error occures in p_mutation()...\n");
		    return(-1);
		}
	    }
	}


	/* $B>uBVJ,I[$K$O!$E@FMA3JQ0[$,5/$3$k!%(B*/
	for(j = 1; j <= (((*individual_ptr)+i)->state)*UNIT_PI; j++){

	    fdum = xrandom(&(ga_cnd->seed));

	    /* $BE@FMA3JQ0[(B */
	    if(fdum <= ga_cnd->pmutation){
#ifdef DEBUG
		fprintf(stderr, "--- point mutation on gene_pi_i...\n");
		fprintf(stderr, "    id=%d pos=%d rand=%f\n", i, j, fdum);
#endif
		if(p_mutation((((*individual_ptr)+i)->gene_pi_i), j) != 0){
		    fprintf(stderr, "error occures in p_mutation()...\n");
		    return(-1);
		}
	    }
	}


	/* $B1v4pIQEY$K$O!$E@FMA3JQ0[$,5/$3$k!%(B*/
	for(j = 1; j <= (((*individual_ptr)+i)->state)*UNIT_FRQ*NUCL; j++){

	    fdum = xrandom(&(ga_cnd->seed));

	    /* $BE@FMA3JQ0[(B */
	    if(fdum <= ga_cnd->pmutation){
#ifdef DEBUG
		fprintf(stderr, "--- point mutation on gene_freq...\n");
		fprintf(stderr, "    id=%d pos=%d rand=%f\n", i, j, fdum);
#endif
		if(p_mutation((((*individual_ptr)+i)->gene_freq), j) != 0){
		    fprintf(stderr, "error occures in p_mutation()...\n");
		    return(-1);
		}
	    }
	}
    }

#ifdef DEBUG
    show_population(ga_cnd, individual_ptr);
#endif

    return(0);
}


int p_mutation(unsigned char *str, int pos)
{
    if(str[pos] == '0'){
	str[pos] = '1';
    }
    else if(str[pos] == '1'){
	str[pos] = '0';
    }
    else{
	fprintf(stderr, "invalid character...\n");
	return(-1);
    }

    return(0);
}


