#include <stdlib.h>
#include <math.h>
#include <stdio.h>

#include "hmm-gene.h"
#include "ga.h"


int fitness(GA_CND ga_cnd, INDIVIDUAL **individual_ptr)
{
    int i, j, k, l, m, n;
    int idum;
    float fdum;
    double sum;
    unsigned char *cdum1;
    unsigned char *cdum2;
    unsigned char *cdum3;
    double **ddum;
    int *idum_ptr;

    char file_name[TINY_SIZE];
    FILE *file_ptr;
    char command[LONGEST_SIZE];
    char buf[TINY_SIZE];

    int *ivector(long, long);
    void free_ivector(int *, long, long);
    int int2n(int, int, int, int *);
    int gray2int(int, unsigned char *);
    int matrix_times(double **, double, int, int, double **);
    int print_matrix(double **, int, int);
    int is_zero(double);

    unsigned char *cvector(long, long);
    double **dmatrix(long, long, long, long);
    void free_cvector(unsigned char *, long, long);
    void free_dmatrix(double **, long, long, long, long);


    cdum1 = cvector((long)0, (long)(UNIT_AIJ-1));
    cdum2 = cvector((long)0, (long)(UNIT_FRQ-1));
    cdum3 = cvector((long)0, (long)(UNIT_PI-1));


    /* $B3F<o%Q%i%a!<%?$N%G%3!<%I$H3X=,$r9T$J$&!%(B */
    for(i = 1; i <= ga_cnd.population; i++){

	/* $B7k9g9TNs$r%G%3!<%I$9$k!%(B */
#ifdef DEBUG
	fprintf(stderr, "--- id= %d ...\n", i);
	fprintf(stderr, "--- decoding connectivity...\n");
#endif
	l = 1;
	for(j = 1; j <= (*individual_ptr + i)->state; j++){
	    for(k = 1; k <= (*individual_ptr + i)->state; k++){
		if(((*individual_ptr + i)->gene_connect)[l] == '0'){
		    ((*individual_ptr + i)->connect)[j][k] = 0;
		}
		else if(((*individual_ptr + i)->gene_connect)[l] == '1'){
		    ((*individual_ptr + i)->connect)[j][k] = 1;
		}
		else{
		    fprintf(stderr, "invalid value in gene_connect\n");
		    free_cvector(cdum1, (long)0, (long)(UNIT_AIJ-1));
		    free_cvector(cdum2, (long)0, (long)(UNIT_FRQ-1));
		    free_cvector(cdum3, (long)0, (long)(UNIT_PI-1));
		    return(-1);
		}
		l++;
	    }
	}
#ifdef DEBUG
	for(j = 1; j <= (*individual_ptr + i)->state; j++){
	    fprintf(stderr, "\t");
	    for(k = 1; k <= (*individual_ptr + i)->state; k++){
		fprintf(stderr, "%d ", 
			((*individual_ptr + i)->connect)[j][k]);
	    }
	    fprintf(stderr, "\n");
	}
#endif


	/* $BA+0\3NN($N=i4|CM(B(gray code)$B$r%G%3!<%I$9$k!%(B */
#ifdef DEBUG
	fprintf(stderr, "--- decoding trans. prob...\n");
#endif

	ddum = dmatrix((long)1, (long)(*individual_ptr + i)->state,
		       (long)1, (long)(*individual_ptr + i)->state);


	for(j = 1; j <= ((*individual_ptr + i)->state)*
	    ((*individual_ptr + i)->state); j++){

	    /* (*individual_ptr + i)->gene_a0_ij$B$NFbMF$r(B
	       ($B$H$j$"$($:(B)$B@0?t$KJQ49$9$k!%(B */
	    for(k = 0; k < UNIT_AIJ; k++){
		cdum1[k] = ((*individual_ptr + i)->
			   gene_a0_ij)[(j-1)*UNIT_AIJ+(k+1)];
	    }
	    if((l = gray2int(UNIT_AIJ, cdum1)) < 0){
		fprintf(stderr, "error occures in gray2int()...\n");
		free_dmatrix(ddum, (long)1, (long)(*individual_ptr + i)->state,
			     (long)1, (long)(*individual_ptr + i)->state);
		free_cvector(cdum1, (long)0, (long)(UNIT_AIJ-1));
		free_cvector(cdum2, (long)0, (long)(UNIT_FRQ-1));
		free_cvector(cdum3, (long)0, (long)(UNIT_PI-1));
		return(-1);
	    }

	    /* $B@0?t$KJQ49$5$l$?CM$r(B**ddum$B$N3:Ev$9$k>l=j$K3JG<$9$k!%(B */
	    m = (j-1)/((*individual_ptr + i)->state)+1;
	    n = (j-1)%((*individual_ptr + i)->state)+1;
	    ddum[m][n] = (double)l;

	}

	/* $B7k9g9TNs$r3]$1$k!%(B */
	for(j = 1; j <= (*individual_ptr + i)->state; j++){
	    for(k = 1; k <= (*individual_ptr + i)->state; k++){
		ddum[j][k] = ((*individual_ptr + i)->connect)[j][k] *
		    ddum[j][k];
	    }
	}

	/* $B@0?tCM$r<B?tCM$KJQ49$9$k!%(B */
	for(j = 1; j <= (*individual_ptr + i)->state; j++){
	    sum = 0.0;
	    for(k = 1; k <= (*individual_ptr + i)->state; k++){
		sum += ddum[j][k];
	    }
	    if(is_zero(sum) == TRUE){
		for(k = 1; k <= (*individual_ptr + i)->state; k++){
		    ddum[j][k] = 0.0;
		}
	    }
	    else{
		for(k = 1; k <= (*individual_ptr + i)->state; k++){
		    ddum[j][k] = ddum[j][k]/sum;
		}
	    }
	}

	matrix_times(ddum, 1.0, (*individual_ptr + i)->state, 
		     (*individual_ptr + i)->state,
		     (*individual_ptr + i)->a0_ij);

#ifdef DEBUG
	print_matrix((*individual_ptr + i)->a0_ij,
		     (*individual_ptr + i)->state,
		     (*individual_ptr + i)->state);
#endif


	/* $B=i4|>uBVJ,I[(B(gray code)$B$r%G%3!<%I$9$k!%(B */
#ifdef DEBUG
	fprintf(stderr, "--- decoding init. dist...\n");
#endif
	sum = 0.0;
	for(j = 1; j <= ((*individual_ptr + i)->state); j++){

	    /* (*individual_ptr + i)->gene_pi_i$B$NFbMF$r(B
	       $B@0?t$KJQ49$9$k!%(B */
	    for(k = 0; k < UNIT_PI; k++){
		cdum3[k] = ((*individual_ptr + i)->
			    gene_pi_i)[(j-1)*UNIT_PI+(k+1)];
	    }

	    if((l = gray2int(UNIT_PI, cdum3)) < 0){
		fprintf(stderr, "error occures in gray2int()...\n");
		free_dmatrix(ddum, (long)1, (long)(*individual_ptr + i)->state,
			     (long)1, (long)(*individual_ptr + i)->state);
		free_cvector(cdum1, (long)0, (long)(UNIT_AIJ-1));
		free_cvector(cdum2, (long)0, (long)(UNIT_FRQ-1));
		free_cvector(cdum3, (long)0, (long)(UNIT_PI-1));
		return(-1);
	    }

	    ((*individual_ptr + i)->pi_i)[j] = (double)l;
	    sum += (double)l;
	}
	if(is_zero(sum) == TRUE){
	    for(j = 1; j <= ((*individual_ptr + i)->state); j++){
		((*individual_ptr + i)->pi_i)[j] = 0.0;
	    }
	}
	else{
	    for(j = 1; j <= ((*individual_ptr + i)->state); j++){
		((*individual_ptr + i)->pi_i)[j] = 
		    ((*individual_ptr + i)->pi_i)[j]/sum;
	    }
	}

#ifdef DEBUG
	fprintf(stderr, "\t");
	for(j = 1; j <= ((*individual_ptr + i)->state); j++){
	    fprintf(stderr, "%f ", 
		   ((*individual_ptr + i)->pi_i)[j]);
	}
	fprintf(stderr, "\n");
#endif


	/* $B1v4pIQEY$N=i4|CM(B(gray code)$B$r%G%3!<%I$9$k!%(B */
#ifdef DEBUG
	fprintf(stderr, "--- decoding base freq...\n");
#endif
	for(j = 1; j <= ((*individual_ptr + i)->state)*NUCL; j++){

	    /* (*individual_ptr + i)->gene_freq$B$NFbMF$r(B
	       $B@0?t$KJQ49$9$k!%(B */
	    for(k = 0; k < UNIT_FRQ; k++){
		cdum2[k] = ((*individual_ptr + i)->
			   gene_freq)[(j-1)*UNIT_FRQ+(k+1)];
	    }

	    if((l = gray2int(UNIT_FRQ, cdum2)) < 0){
		fprintf(stderr, "error occures in gray2int()...\n");
		free_dmatrix(ddum, (long)1, (long)(*individual_ptr + i)->state,
			     (long)1, (long)(*individual_ptr + i)->state);
		free_cvector(cdum1, (long)0, (long)(UNIT_AIJ-1));
		free_cvector(cdum2, (long)0, (long)(UNIT_FRQ-1));
		free_cvector(cdum3, (long)0, (long)(UNIT_PI-1));
		return(-1);
	    }

	    ((*individual_ptr + i)->freq)[j] = (double)l;
	}
	/* $B@55,2=$9$k(B */
	for(j = 1; j <= ((*individual_ptr + i)->state); j++){
	    sum = 0.0;
	    for(k = 0; k < NUCL; k++){
		sum += ((*individual_ptr + i)->freq)[(j-1)*NUCL+(k+1)];
	    }
	    for(k = 0; k < NUCL; k++){
		if(is_zero(sum) == TRUE){
		    ((*individual_ptr + i)->freq)[(j-1)*NUCL+(k+1)] = 0.0;
		}
		else{
		    ((*individual_ptr + i)->freq)[(j-1)*NUCL+(k+1)] = 
			((*individual_ptr + i)->freq)[(j-1)*NUCL+(k+1)]/sum;
		}
	    }
	}

#ifdef DEBUG
	for(j = 1; j <= ((*individual_ptr + i)->state)*NUCL; j++){
	    if(j%NUCL == 1){
		fprintf(stderr, "\t");
	    }
	    fprintf(stderr, "%f ", 
		    ((*individual_ptr + i)->freq)[j]);
	    if(j%NUCL == 0){
		fprintf(stderr, "\n");
	    }
	}
#endif

	free_dmatrix(ddum, (long)1, (long)(*individual_ptr + i)->state,
		     (long)1, (long)(*individual_ptr + i)->state);


    }


    /* $B=PNO(B($B3X=,A0(B)$B!%(B */
    for(i = 1; i <= ga_cnd.population; i++){

	/* $B=PNO%U%!%$%kL>(B */
	/* /tmp$B$K:n$k>l9g(B */
	/*
	sprintf((char *) &buf, "%d", i);
	strcpy(file_name, "/tmp/");
	strcat(file_name, buf);
	*/
	/* ./$B$K:n$k>l9g(B */
	sprintf((char *) &file_name, "%d", i);

	/* $B=PNO%U%!%$%k%]%$%s%?(B */
	if((file_ptr = fopen(file_name, "w")) == NULL){
	    fprintf(stderr, "can not open wrk file...\n");
	    free_cvector(cdum1, (long)0, (long)(UNIT_AIJ-1));
	    free_cvector(cdum2, (long)0, (long)(UNIT_FRQ-1));
	    free_cvector(cdum3, (long)0, (long)(UNIT_PI-1));
	    return(-1);
	}

	/* $B7k9g9TNs!%(B */
	fprintf(stdout, "--- id= %d ...(before learning)\n", i);
	fprintf(stdout, "--- num. states= %d\n", (*individual_ptr + i)->state);
	fprintf(stdout, "--- decoding connectivity...\n");
	for(j = 1; j <= (*individual_ptr + i)->state; j++){
	    fprintf(stdout, "\t");
	    for(k = 1; k <= (*individual_ptr + i)->state; k++){
		fprintf(stdout, "%d ", ((*individual_ptr + i)->connect)[j][k]);
	    }
	    fprintf(stdout, "\n");
	}
	fflush(stdout);
	fprintf(file_ptr, "--- id= %d ...(before learning)\n", i);
	fprintf(file_ptr, 
		"--- num. states= %d\n", (*individual_ptr + i)->state);
	fprintf(file_ptr, "--- decoding connectivity...\n");
	for(j = 1; j <= (*individual_ptr + i)->state; j++){
	    fprintf(file_ptr, "\t");
	    for(k = 1; k <= (*individual_ptr + i)->state; k++){
		fprintf(file_ptr, "%d ", 
			((*individual_ptr + i)->connect)[j][k]);
	    }
	    fprintf(file_ptr, "\n");
	}
	fflush(file_ptr);


	/* $BA+0\3NN($N=i4|CM(B(gray code)$B!%(B */
	fprintf(stdout, "--- decoding trans. prob...\n");
	for(j = 1; j <= (*individual_ptr + i)->state; j++){
	    fprintf(stdout, "\t");
	    for(k = 1; k <= (*individual_ptr + i)->state; k++){
		fprintf(stdout, "%e ", ((*individual_ptr + i)->a0_ij)[j][k]);
	    }
	    fprintf(stdout, "\n");
	}
	fflush(stdout);
	fprintf(file_ptr, "--- decoding trans. prob...\n");
	for(j = 1; j <= (*individual_ptr + i)->state; j++){
	    fprintf(file_ptr, "\t");
	    for(k = 1; k <= (*individual_ptr + i)->state; k++){
		fprintf(file_ptr, "%e ", ((*individual_ptr + i)->a0_ij)[j][k]);
	    }
	    fprintf(file_ptr, "\n");
	}
	fflush(file_ptr);


	/* $B1v4pIQEY$N=i4|CM(B(gray code)$B!%(B */
	fprintf(stdout, "--- decoding base freq...\n");
	for(j = 1; j <= ((*individual_ptr + i)->state)*NUCL; j++){
	    if(j%NUCL == 1){
		fprintf(stdout, "\t");
	    }
	    fprintf(stdout, "%e ", ((*individual_ptr + i)->freq)[j]);
	    if(j%NUCL == 0){
		fprintf(stdout, "\n");
	    }
	}
	fflush(stdout);
	fprintf(file_ptr, "--- decoding base freq...\n");
	for(j = 1; j <= ((*individual_ptr + i)->state)*NUCL; j++){
	    if(j%NUCL == 1){
		fprintf(file_ptr, "\t");
	    }
	    fprintf(file_ptr, "%e ", ((*individual_ptr + i)->freq)[j]);
	    if(j%NUCL == 0){
		fprintf(file_ptr, "\n");
	    }
	}
	fflush(file_ptr);


	/* $B=i4|>uBVJ,I[(B(gray code)$B!%(B */
	fprintf(stdout, "--- decoding init. dist...\n");
	fprintf(stdout, "\t");
	for(j = 1; j <= ((*individual_ptr + i)->state); j++){
	    fprintf(stdout, "%e ", ((*individual_ptr + i)->pi_i)[j]);
	}
	fprintf(stdout, "\n");
	fflush(stdout);
	fprintf(file_ptr, "--- decoding init. dist...\n");
	fprintf(file_ptr, "\t");
	for(j = 1; j <= ((*individual_ptr + i)->state); j++){
	    fprintf(file_ptr, "%e ", ((*individual_ptr + i)->pi_i)[j]);
	}
	fprintf(file_ptr, "\n");
	fflush(file_ptr);


	/* $B%U%!%$%k$rJD$8$k(B */
	fclose(file_ptr);
    }


    /* $BJBNs2=$N$?$a$K(BBaum-Welch algorithm$B$r<B9T7A<0$N%U%!%$%k$K$7$F(B
       system$B4X?t$G%3!<%k$9$k!%(B */
    /* $B%3%^%s%I$N@8@.(B */
    strcpy(command, "./sp2mp ");
    for(i = 1; i <= ga_cnd.population; i++){
	/* /tmp$B$K:n$C$?>l9g(B */
	/*
	strcat(command, "/tmp/");
	sprintf((char *) &buf, "%d ", i);
	strcat(command, buf);
	*/
	/* ./$B$K:n$C$?>l9g(B */
	sprintf((char *) &buf, "%d ", i);
	strcat(command, buf);
    }
    if(system((char *)&command) != 0){
	fprintf(stderr, "error occures in sp2mp...\n");
	free_cvector(cdum1, (long)0, (long)(UNIT_AIJ-1));
	free_cvector(cdum2, (long)0, (long)(UNIT_FRQ-1));
	free_cvector(cdum3, (long)0, (long)(UNIT_PI-1));
	for(i = 1; i <= ga_cnd.population; i++){
	    /* /tmp$B$K:n$C$?>l9g(B */
	    /*
	    sprintf((char *) &buf, "%d", i);
	    strcpy(file_name, "/tmp/");
	    strcat(file_name, buf);
	    */
	    /* ./$B$K:n$C$?>l9g(B */
	    sprintf((char *) &file_name, "%d", i);
	    unlink(file_name);
	}
	return(-1);
    }


    /* $B3X=,7k2L$rFI$_9~$`(B */
    for(i = 1; i <= ga_cnd.population; i++){

	/* $BF~NO%U%!%$%kL>(B */
	/* /tmp$B$K:n$C$?>l9g(B */
	/*
	sprintf((char *) &buf, "%d", i);
	strcpy(file_name, "/tmp/");
	strcat(file_name, buf);
	*/
	/* ./$B$K:n$C$?>l9g(B */
	sprintf((char *) &file_name, "%d", i);

	/* $BF~NO%U%!%$%k%]%$%s%?(B */
	if((file_ptr = fopen(file_name, "r")) == NULL){
	    fprintf(stderr, "can not open wrk file...\n");
	    free_cvector(cdum1, (long)0, (long)(UNIT_AIJ-1));
	    free_cvector(cdum2, (long)0, (long)(UNIT_FRQ-1));
	    free_cvector(cdum3, (long)0, (long)(UNIT_PI-1));
	    return(-1);
	}

	/* $B7k2L$NFI$_9~$_(B */
	for(; fscanf(file_ptr, "%s", buf) != EOF; ){
	    /* $BA+0\3NN(!%(B */
	    if(strcmp(buf, "a_ij") == 0){
		fscanf(file_ptr, "%s", buf);
		fscanf(file_ptr, "%s", buf);
		for(j = 1; j <= (*individual_ptr + i)->state; j++){
		    for(k = 1; k <= (*individual_ptr + i)->state; k++){
			fscanf(file_ptr, "%f", &fdum);
			((*individual_ptr + i)->a0_ij)[j][k] = (double)fdum;
		    }
		}
	    }
	    /* $B1v4pIQEY!%(B */
	    else if(strcmp(buf, "b_ij") == 0){
		fscanf(file_ptr, "%s", buf);
		fscanf(file_ptr, "%s", buf);
		for(j = 1; j <= (*individual_ptr + i)->state; j++){
		    fscanf(file_ptr, "%s", buf);
		    fscanf(file_ptr, "%s", buf);
		    idum = (int) pow((double)NUCL, (double)(TPL_LEN));
		    for(k = 1; k <= idum; k++){
			fscanf(file_ptr, "%s", buf);
			fscanf(file_ptr, "%f", &fdum);
			((*individual_ptr + i)->freq)[(j-1)*idum+k] = 
			    (double)fdum;
		    }
		}
	    }

	    /* $B=i4|>uBVJ,I[!%(B */
	    else if(strcmp(buf, "pi_i") == 0){
		fscanf(file_ptr, "%s", buf);
		fscanf(file_ptr, "%s", buf);
		for(j = 1; j <= (*individual_ptr + i)->state; j++){
		    fscanf(file_ptr, "%f", &fdum);
		    ((*individual_ptr + i)->pi_i)[j] = (double)fdum;
		}
	    }
	    /* $BJ?6QBP?tL`EY(B */
	    else if(strcmp(buf, "likelihd=") == 0){
		fscanf(file_ptr, "%f", &fdum);
		(*individual_ptr + i)->likelihd = (double)fdum;
	    }
	    /* HMM$B$N<+M3%Q%i%a!<%??t(B */
	    else if(strcmp(buf, "num_p=") == 0){
		fscanf(file_ptr, "%d", &idum);
		(*individual_ptr + i)->num_p = idum;
	    }
	    /* AIC */
	    else if(strcmp(buf, "aic=") == 0){
		fscanf(file_ptr, "%f", &fdum);
		(*individual_ptr + i)->aic = (double)fdum;
	    }
	    /* $BE,1~EY(B(1/AIC) */
	    else if(strcmp(buf, "raw_fitness=") == 0){
		fscanf(file_ptr, "%f", &fdum);
		(*individual_ptr + i)->raw_fitness = (double)fdum;
	    }

	}

	/* $B%U%!%$%k$rJD$8$k(B */
	fclose(file_ptr);

	/* $BF~NO%U%!%$%k$N:o=|(B */
	unlink(file_name);

    }


    /* $B=PNO(B($B3X=,8e(B)$B!%(B */
    for(i = 1; i <= ga_cnd.population; i++){

	fprintf(stdout, "--- id= %d ...(after learning)\n", i);
	fprintf(stdout, 
		"    num. states= %d\n", (*individual_ptr + i)->state);
	fflush(stdout);


	/* $B7k9g9TNs!%(B */
	fprintf(stdout, "    connectivity...\n");
	for(j = 1; j <= (*individual_ptr + i)->state; j++){
	    fprintf(stdout, "\t");
	    for(k = 1; k <= (*individual_ptr + i)->state; k++){
		fprintf(stdout, "%d ", ((*individual_ptr + i)->connect)[j][k]);
	    }
	    fprintf(stdout, "\n");
	}
	fflush(stdout);


	/* $BA+0\3NN(!%(B */
	fprintf(stdout, "    a_ij = ...\n");
	for(j = 1; j <= (*individual_ptr + i)->state; j++){
	    fprintf(stdout, "\t");
	    for(k = 1; k <= (*individual_ptr + i)->state; k++){
		fprintf(stdout, "%e ", ((*individual_ptr + i)->a0_ij)[j][k]);
	    }
	    fprintf(stdout, "\n");
	}
	fflush(stdout);


	/* $B1v4pIQEY!%(B */
	fprintf(stdout, "    b_ij = ...\n");
	k = 1;
	for(j = 1; j <= ((*individual_ptr + i)->state); j++){
	    fprintf(stdout, "\tstate=%d  freq.=...\n", j);

	    /* $BD9$5(BTPL_LEN$B$N(Btuple$B$r@8@.(B */
	    idum = (int) pow((double)NUCL, (double)TPL_LEN);
	    idum_ptr = ivector(0, (long)TPL_LEN-1);
	    for(l = 1; l <= idum; l++){

		/* $B@0?t(B(l-1)$B$r(B4$B?J?t$KJQ49(B */
		if(int2n(l-1, TPL_LEN, NUCL, idum_ptr) != 0){
		    fprintf(stderr, "error occures in int2n()...\n");
		    free_cvector(cdum1, (long)0, (long)(UNIT_AIJ-1));
		    free_cvector(cdum2, (long)0, (long)(UNIT_FRQ-1));
		    free_cvector(cdum3, (long)0, (long)(UNIT_PI-1));
		    free_ivector(idum_ptr, 0, (long)(TPL_LEN-1));
		    return(-1);
		}
		fprintf(stdout, "\t");
		for(m = 0; m < TPL_LEN; m++){
		    if(idum_ptr[m] == 0)
			fprintf(stdout, "A");
		    else if(idum_ptr[m] == 1)
			fprintf(stdout, "T");
		    else if(idum_ptr[m] == 2)
			fprintf(stdout, "C");
		    else if(idum_ptr[m] == 3)
			fprintf(stdout, "G");
		    else{
			free_cvector(cdum1, (long)0, (long)(UNIT_AIJ-1));
			free_cvector(cdum2, (long)0, (long)(UNIT_FRQ-1));
			free_cvector(cdum3, (long)0, (long)(UNIT_PI-1));
			free_ivector(idum_ptr, 0, (long)(TPL_LEN-1));
			return(-1);
		    }
		}
		fprintf(stdout, "\t%e\n", 
			((*individual_ptr + i)->freq)[(j-1)*idum+l]);

	    }
	    free_ivector(idum_ptr, 0, (long)(TPL_LEN-1));

	}
	fflush(stdout);


	/* $B=i4|>uBVJ,I[!%(B */
	fprintf(stdout, "    pi_i = ...\n");
	fprintf(stdout, "\t");
	for(j = 1; j <= ((*individual_ptr + i)->state); j++){
	    fprintf(stdout, "%e ", ((*individual_ptr + i)->pi_i)[j]);
	}
	fprintf(stdout, "\n");
	fflush(stdout);


	/* $BE,1~EY(B */
	fprintf(stdout, "    likelihd= %e\tnum_p= %d\n", 
	       (*individual_ptr + i)->likelihd, 
	       (*individual_ptr + i)->num_p);
	fprintf(stdout, "    aic= %e\traw_fitness= %e\n", 
	       (*individual_ptr + i)->aic, 
	       (*individual_ptr + i)->raw_fitness);
	fflush(stdout);

    }


    free_cvector(cdum1, (long)0, (long)(UNIT_AIJ-1));
    free_cvector(cdum2, (long)0, (long)(UNIT_FRQ-1));
    free_cvector(cdum3, (long)0, (long)(UNIT_PI-1));


    return(0);
}

