/* ---------------------------------------------------------- 
%(C)1994,1995 Institute for New Generation Computer Technology 
%       (Read COPYRIGHT for detailed information.) 
----------------------------------------------------------- */
/* -------------------------------------------------------------------- */
/*    pairListSelect.c                                                  */
/*          make base pair lists within selected sequences              */
/* -------------------------------------------------------------------- */

#include <X11/Xlib.h>
#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <X11/Shell.h>
#include <Xm/Xm.h>
#include <Xm/Label.h>
#include <Xm/Form.h>
#include <Xm/RowColumn.h>
#include <Xm/List.h>
#include <Xm/PushB.h>
#include <string.h> 
#include <stdio.h>
#include "stem.h"
/*
#define DEBUG TRUE
*/

Widget select_list_pair,select_list_cancel;
extern Pixmap pixmap_da;
extern Widget da,select_form;
extern GC gc_da;

int    s_ItemSelected,select_NoOfPair;
int    select_columns[MAXPAIRS][2];
char   select_ListString[MAXPAIRS][12];
char          *select_string[MAXPAIRS];
int    s_dispPairs;    /* flag wheather emphasize selected pairs */

extern void pairStringToIntString();
/*
extern void dispSelectedPair(); */
extern void select_undispSelectedPair();
extern int NumberToString();
extern void dispSeqs();

void select_sortColumns() /* sort slected colums */
{
  int i,temp[2],gap,j1,j2;

#ifdef DEBUG
  printf("---- columns sort (s)-----\n");
  for(i=0;i != s_ItemSelected;i++)
    printf("select_columns[%d] : %2d  %2d \n",i,select_columns[i][0],select_columns[i][1]);
  printf("\n");
#endif

  for(gap = s_ItemSelected/2 ;gap != 0 ;gap = gap/2)
    {
      for(i = gap ; i != s_ItemSelected; i++)
	{
	  for(j1 = i-gap;j1 >= 0 ;j1 = j1 -gap)
	    {
	      j2 = j1 + gap;
/*
#ifdef DEBUG
	      printf("ji:select_columns[%d][0] = %d, ",j1,select_columns[j1][0]);
	      printf("j2:select_columns[%d][0] = %d\n",j2,select_columns[j2][0]);
#endif
*/
	      if(select_columns[j1][0] <= select_columns[j2][0])
		break;
	      else
		{
		  temp[0] = select_columns[j1][0];
		  temp[1] = select_columns[j1][1];
		  select_columns[j1][0] = select_columns[j2][0];
		  select_columns[j1][1] = select_columns[j2][1];
		  select_columns[j2][0] = temp[0];
		  select_columns[j2][1] = temp[1];
		}
	    }
	}
    }

#ifdef DEBUG
  printf("---- columns after sort(s) -----\n");
  for(i=0;i != s_ItemSelected;i++)
    printf("select_columns[%d] : %2d  %2d \n",i,select_columns[i][0],select_columns[i][1]);
  printf("\n");
#endif
}



/* make ListString from PairListForHyoujiS (convert intger to string) */
int select_changePairListToString()
{
  int i,No1,No2;
  char NoString1[5],NoString2[5];
  char StringPair[12];
  char *str;

  select_NoOfPair = 0;
  StringPair[0] = '\0';

  for(i=0;PairListForHyoujiS[i][0]!=MAXIMUM;i++)
    {
      No1 = PairListForHyoujiS[i][3];
      No2 = PairListForHyoujiS[i][4];

      NumberToString(No1,NoString1);
      NumberToString(No2,NoString2);
/*
#ifdef DEBUG      
      printf("NoString1 = %s    ",NoString1);
      printf("NoString2 = %s\n",NoString2);
#endif
*/
      strcat(StringPair,"(");
      strcat(StringPair,NoString1);
      strcat(StringPair,",");
      strcat(StringPair,NoString2);
      str = strcat(StringPair,")");
      
      strcpy(select_ListString[i], str);

      StringPair[0] = '\0';
/*
#ifdef DEBUG      
      printf("StringPair = %s\n",str);
#endif
*/
      select_NoOfPair++;
    }
/*
#ifdef DEBUG
  for(i=0;PairListForHyoujiS[i][0]!=MAXIMUM;i++)
    {
      printf("select_ListSring[%d] = %s\n",i,select_ListString[i]);
    }
#endif 
*/
}


/* called when items in the list selected */
void s_selectL1(w,client_data,call_data)
     Widget       w;
     caddr_t          client_data;
     XmListCallbackStruct *call_data;
{
  int i;

  /* get number of items selected */
  s_ItemSelected = call_data->selected_item_count;

  /* set selected items to select_string */  
  for(i=0; i != s_ItemSelected ; i++)
    {
      XmStringGetLtoR(call_data->selected_items[i],XmSTRING_DEFAULT_CHARSET,&select_string[i]);
#ifdef DEBUG
      printf("(s)selected items[%2d]: %s\n",i,select_string[i]);
#endif
    }
}


/* called when "ok" button pushed */
void selectDispSelect(w,client_data,call_data)
     Widget       w;
     caddr_t      client_data;
     XmAnyCallbackStruct *call_data;
{
  int col1,col2,i;


  /* convert select_string to integer */
  if(s_ItemSelected)
    {
      s_dispPairs = TRUE;
      for(i=0;i != s_ItemSelected ; i++)
	{
	  pairStringToIntString(select_string[i],&col1,&col2);
	  select_columns[i][0] = col1;
	  select_columns[i][1] = col2;
	}
      
#ifdef DEBUG
      for(i=0;i != s_ItemSelected ; i++)
	printf("(s) Pair[%2d]:( %d , %d )\n",i,select_columns[i][0],select_columns[i][1]);
#endif
      select_sortColumns();
    }
  select_dispSelectedPair(w,select_columns,call_data);
      /* emphasize selected base pairs  */
  XCopyArea(XtDisplay(da),pixmap_da,XtWindow(da),gc_da,0,0,1000,1000,0,0);
}
 

/* called when "cancel" button pushed */
void selectUndispSelect(w,client_data,call_data)
     Widget       w;
     caddr_t      client_data;
     XmAnyCallbackStruct *call_data;
{
  /* cancel */
  s_dispPairs = FALSE;
  if(s_ItemSelected)    /* items selected */
    {                /* cancel emphasis */
      XmListDeselectAllItems(select_list_pair); /* cancel selection of items */
      select_undispSelectedPair(w,select_columns,call_data);
      s_ItemSelected = 0;
    }
/*  dispSelectedPair(w,columns,call_data); */
  XCopyArea(XtDisplay(da),pixmap_da,XtWindow(da),gc_da,0,0,1000,1000,0,0);
}


 
/* make list widget */
void create_listS(select_form)
     Widget select_form;
{
  Widget  scroll_w;
  Arg    args[10];
  int i,n;

/* create list widget */
  n=0;
  XtSetArg(args[n],XmNitemCount,0);
  n++;
  XtSetArg(args[n],XmNselectionPolicy,XmEXTENDED_SELECT);
  n++;
  XtSetArg(args[n],XmNscrollBarDisplayPolicy,XmSTATIC);
  n++;
  XtSetArg(args[n],XmNlistMarginHeight,5);
  n++;
  XtSetArg(args[n],XmNlistMarginWidth,5);
  n++;
  XtSetArg(args[n],XmNlistSpacing,3);
  n++;
  XtSetArg(args[n],XmNbackground,MyColor(XtDisplay(select_form),"wheat"));
  n++;
  select_list_pair = XmCreateScrolledList(select_form,"select_list_pair",args,n);
  XtManageChild(select_list_pair);

  scroll_w = XtParent(select_list_pair);
  n=0;
  XtSetArg(args[n],XmNtopWidget,select_list_cancel);
  n++;
  XtSetArg(args[n],XmNwidth,100);
  n++;
  XtSetArg(args[n],XmNtopAttachment,XmATTACH_WIDGET);
  n++;
  XtSetArg(args[n],XmNtopOffset,2);
  n++;
  XtSetArg(args[n],XmNrightAttachment,XmATTACH_FORM);
  n++;
  XtSetArg(args[n],XmNbottomAttachment,XmATTACH_FORM);
  n++;
  XtSetValues(scroll_w,args,n); 

  /* set callback function */  
  XtAddCallback(select_list_pair,XmNextendedSelectionCallback,s_selectL1,NULL);
}


/* set items to list */
void AddItemToListS()
{
  XmString    ListXString;
  int i;

/* convert pair of integer to compound string */
  select_changePairListToString();
/* remove all current items from list */
  XmListDeleteAllItems(select_list_pair);

  if(select_NoOfPair == 0) /* no pairs */
    {
      ListXString = XmStringCreateLtoR("no pairs",XmSTRING_DEFAULT_CHARSET);
      XmListAddItemUnselected(select_list_pair,ListXString,1);
    }
  else
    { /* add items to list */
      for(i=0;i != select_NoOfPair;i++)
	{
	  ListXString = XmStringCreateLtoR(select_ListString[i],XmSTRING_DEFAULT_CHARSET);
	  XmListAddItemUnselected(select_list_pair,ListXString,1);
/*	  printf("select_ListString[%d] = %s\n",i,select_ListString[i]); */
	}
    }
  XmStringFree(ListXString);
}


void createListS(parent_wd)
     Widget   parent_wd;  /* parent widget*/
{
  Widget select_list_ok,select_list_label; 
  XmString  x_charsetListOk,x_charsetListCancel;
  int n;
  Arg args[20];

  s_ItemSelected = 0;


/* create push buttons */

  n=0;
  XtSetArg(args[n],XmNtopWidget,select_list_label);
  n++;
  XtSetArg(args[n],XmNtopAttachment,XmATTACH_FORM);
  n++;
  XtSetArg(args[n],XmNtopOffset,2);
  n++;
  XtSetArg(args[n],XmNrightAttachment,XmATTACH_FORM);
  n++;
  XtSetArg(args[n],XmNrightOffset,2);
  n++;
  XtSetArg(args[n],XmNwidth,96);
  n++;
  XtSetArg(args[n],XmNheight,30);
  n++; 
  x_charsetListOk = XmStringCreateLtoR("show",XmSTRING_DEFAULT_CHARSET);
  XtSetArg(args[n],XmNlabelString,x_charsetListOk);
  n++;
  XtSetArg(args[n],XmNbackground,MyColor(XtDisplay(select_form),"wheat"));
  n++;
  select_list_ok = XmCreatePushButton(select_form,"select_list_ok",args,n);

  n=0;
  XtSetArg(args[n],XmNtopWidget,select_list_ok);
  n++;
  XtSetArg(args[n],XmNtopAttachment,XmATTACH_WIDGET);
  n++;
  XtSetArg(args[n],XmNtopOffset,2);
  n++;
  XtSetArg(args[n],XmNrightAttachment,XmATTACH_FORM);
  n++;
  XtSetArg(args[n],XmNrightOffset,2);
  n++;
  XtSetArg(args[n],XmNwidth,96);
  n++;
  XtSetArg(args[n],XmNheight,30);
  n++; 
  x_charsetListCancel = XmStringCreateLtoR("erase",XmSTRING_DEFAULT_CHARSET);
  XtSetArg(args[n],XmNlabelString,x_charsetListCancel);
  n++;
  XtSetArg(args[n],XmNbackground,MyColor(XtDisplay(select_form),"wheat"));
  n++;
  select_list_cancel = XmCreatePushButton(select_form,"select_list_cancel",args,n);

  XtManageChild(select_list_ok); 
  XtManageChild(select_list_cancel); 
  XmStringFree(x_charsetListOk);
  XmStringFree(x_charsetListCancel);

  if(file_flag)
    changePairListToString(); /* convert pair of integer to compound string */
  create_listS(select_form);  /* create list widget */

  /* add callback function to "ok" button */
  XtAddCallback(select_list_ok,XmNactivateCallback,selectDispSelect,NULL);
  /* add callback function to "cancel" button */
  XtAddCallback(select_list_cancel,XmNactivateCallback,selectUndispSelect,NULL);

}

/* ----------- end of pairListSelect.c ----------------------------- */
